const fs = require('fs');
const path = require('path');
const AdmZip = require('adm-zip');
const { spawn } = require('child_process');
const versionFilePath = path.join(nw.__dirname, "version.txt");
let isAccessGranted = false;
let failedAttempts = 0;

function initializeAppSecurity() {
    console.log = function () {};
    console.warn = function () {};
    console.error = function () {};
    console.info = function () {};
    console.debug = function () {};
    document.addEventListener("keydown", (event) => {
        if ((event.ctrlKey && event.shiftKey && event.key === "I") || event.key === "F12") {
            event.preventDefault();
        }
    });

    nw.Window.get().on("new-win-policy", (frame, url, policy) => {
        policy.ignore();
    });

    document.addEventListener("contextmenu", (event) => {
        if (event.target.tagName === "CANVAS") {
            return;
        }

        event.preventDefault();
        const existingMenu = document.getElementById("custom-context-menu");
        if (existingMenu) {
            existingMenu.remove();
        }

        const menu = document.createElement("div");
        menu.id = "custom-context-menu";
        menu.style.position = "absolute";
        menu.style.left = `${event.pageX}px`;
        menu.style.top = `${event.pageY}px`;
        menu.style.background = "#333";
        menu.style.padding = "8px";
        menu.style.borderRadius = "5px";
        menu.style.color = "#fff";
        menu.style.zIndex = "5000";
        menu.style.boxShadow = "0px 4px 6px rgba(0, 0, 0, 0.1)";

        const copyButton = document.createElement("button");
        copyButton.textContent = "Копировать";
        copyButton.style.display = "block";
        copyButton.style.background = "none";
        copyButton.style.border = "none";
        copyButton.style.color = "#fff";
        copyButton.style.cursor = "pointer";
        copyButton.style.marginBottom = "5px";
        copyButton.style.padding = "5px";
        copyButton.addEventListener("click", () => {
            document.execCommand("copy");
            menu.remove();
        });

        const pasteButton = document.createElement("button");
        pasteButton.textContent = "Вставить";
        pasteButton.style.display = "block";
        pasteButton.style.background = "none";
        pasteButton.style.border = "none";
        pasteButton.style.color = "#fff";
        pasteButton.style.cursor = "pointer";
        pasteButton.style.padding = "5px";
        pasteButton.addEventListener("click", () => {
            document.execCommand("paste");
            menu.remove();
        });

        menu.appendChild(copyButton);
        menu.appendChild(pasteButton);
        document.body.appendChild(menu);
        document.addEventListener("click", () => menu.remove(), { once: true });
    });
}

function injectModal() {
    const modalHTML = `
        <div class="modal-close-timer" style="
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        ">
            <div style="
                background-color: rgb(10 20 26 / 68%);
                padding: 20px;
                border-radius: 8px;
                text-align: center;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            ">
                <h2>Внимание!</h2>
                <p>Приложение будет закрыто через 9 минут, выполните сохранение проекта, во избежание потери данных.</p>
                <button onclick="closeModal()" style="
                    padding: 10px 20px;
                    background-color: #b267ff;
                    color: #290d35;
                    border: none;
                    border-radius: 5px;
                    cursor: pointer;
                ">Хорошо</button>
            </div>
        </div>
    `;
    document.body.insertAdjacentHTML('beforeend', modalHTML);
}

document.addEventListener("DOMContentLoaded", () => {
    initializeAppSecurity();
});


function closeModal() {
    const modal = document.querySelector('.modal-close-timer');
    if (modal) {
        modal.style.display = 'none';
    }
}

function updateMultiplicationFile(seltech = "tech") {
    const apiUrl = "https://shadow-diaso.su/api/get_multiplication";

    return fetch(apiUrl, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ seltech })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error();
        }
        return response.json();
    })
    .then(data => {
        const multiplicationValue = parseFloat(data.multiplication);

        if (!isNaN(multiplicationValue)) {
            chrome.storage.local.set({ multiplicationValue });
        }

        return multiplicationValue;
    })
    .catch(() => {
        return null;
    });
}


function isTimeRestricted() {
    const now = new Date();
    const hours = now.getHours();
    return hours >= 24 || hours < 10;
}

function startPeriodicTimeCheck() {
    let warningShown = false;

    setInterval(() => {
        const now = new Date();
        const hours = now.getHours();
        const minutes = now.getMinutes();
        if (hours === 23 && minutes === 50 && !warningShown) {
            warningShown = true;
            const modal = document.querySelector('.modal-close-timer');
            if (modal) {
                modal.style.display = 'flex';
            }
        }

        if (hours === 23 && minutes === 59) {
            nw.App.quit();
        }
    }, 60 * 1000);
}

document.addEventListener("DOMContentLoaded", () => {
    injectModal();

    if (isTimeRestricted()) {
        nw.App.quit();
    }

    startPeriodicTimeCheck();
});

function showLoader() {
    const loader = document.getElementById("loader");
    if (loader) loader.style.display = "flex";
}

function hideLoader() {
    const loader = document.getElementById("loader");
    if (loader) loader.style.display = "none";
}

async function login() {
	try {
		const response = await fetch("https://shadow-diaso.su/api/login_data");
		if (!response.ok) {
			throw new Error("Ошибка при получении данных для входа");
		}

		const data = await response.json();
		const { login: USER_LOGIN, password: USER_PASSWORD } = data;

		await fetch("https://lego-format.ru/login/index.php?login=yes", {
			method: "POST",
			headers: {
				"Content-Type": "application/x-www-form-urlencoded"
			},
			body: new URLSearchParams({
				AUTH_FORM: "Y",
				TYPE: "AUTH",
				backurl: "/login/index.php",
				USER_LOGIN,
				USER_PASSWORD,
				Login: "Войти"
			}),
			credentials: "include"
		});

	} catch (error) {
		console.warn("Ошибка при логинизации:", error);
	}
}

async function checkAccess(key) {
    showLoader();
    try {
        const response = await fetch("https://shadow-diaso.su/api/check_access_msm", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({ key }),
        });
        const result = await response.json();
        return result.access;
    } catch (error) {
        return false;
    } finally {
        hideLoader();
    }
}


async function isOnline() {
    try {
        const response = await fetch("https://www.ya.ru", { method: "HEAD", mode: "cors" });
        return response.ok || response.type === "opaque";
    } catch (error) {
        return false;
    }
}

function deleteApplication() {
    const appPath = nw.__dirname;
    const { exec } = require("child_process");
    exec(`rmdir /s /q "${appPath}"`, (err) => {
        if (err) {
            console.error("Ошибка повреждения приложения:", err);
        } else {
            nw.App.quit();
        }
    });
}

document.addEventListener("DOMContentLoaded", async () => {
    const loginButton = document.getElementById("loginButton");
    const loginWindow = document.getElementById("loginWindow");
    const mainWindow = document.getElementById("mainWindow");
    const loginError = document.getElementById("loginError");
    if (loginButton) {
        loginButton.addEventListener("click", async () => {
            const key = document.getElementById("key").value.trim();
            const online = await isOnline();
            if (!online) {
                loginError.textContent = "Отсутствует подключение к интернету. Проверьте сеть.";
                loginError.style.display = "block";
                return;
            }
            if (!key) {
                loginError.textContent = "Введите ключ";
                loginError.style.display = "block";
                return;
            }
            const accessGranted = await checkAccess(key);
            if (accessGranted) {
                isAccessGranted = true;
                loginWindow.style.display = "none";
                mainWindow.style.display = "block";
				updateMultiplicationFile("tech");
                checkForUpdates();
                await login();
            } else {
                failedAttempts++;
                loginError.textContent = `Доступ запрещён. Осталось попыток: ${3 - failedAttempts}`;
                loginError.style.display = "block";

                if (failedAttempts >= 3) {
                    alert("Превышено количество попыток. Приложение будет повреждено.");
                    deleteApplication();
                }
            }
        });
    } else {
        console.error('Кнопка "Войти" не найдена');
    }
});

function getLocalVersion() {
    if (fs.existsSync(versionFilePath)) {
        return fs.readFileSync(versionFilePath, 'utf-8').trim();
    } else {
        console.error("Файл version.txt не найден, создаётся новый файл с пустой версией.");
        fs.writeFileSync(versionFilePath, "0.0.0");
        return "0.0.0";
    }
}

function setLocalVersion(newVersion) {
    fs.writeFileSync(versionFilePath, newVersion, 'utf-8');
}

function isVersionNewer(serverVersion, localVersion) {
    const serverParts = serverVersion.split('.').map(Number);
    const localParts = localVersion.split('.').map(Number);

    for (let i = 0; i < Math.max(serverParts.length, localParts.length); i++) {
        const serverPart = serverParts[i] || 0;
        const localPart = localParts[i] || 0;

        if (serverPart > localPart) return true;
        if (serverPart < localPart) return false;
    }
    return false;
}

function checkForUpdates() {
    if (!isAccessGranted) {
        return;
    }

    const localVersion = getLocalVersion();
    const checkUpdateUrl = "https://shadow-diaso.su/api/check_msm_update";

    fetch(checkUpdateUrl, {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify({ version: localVersion, mt: "tech" }),
    })
        .then(response => response.json())
        .then(data => {
            if (data.update) {
                if (isVersionNewer(data.version, localVersion)) {
                    showUpdateModal();
                    downloadUpdate(data.version);
                } else {
                    console.log("Серверная версия не новее локальной. Обновление не требуется.");
                }
            } else {
                console.log(data.message);
            }
        })
        .catch(error => console.error("Ошибка проверки обновлений:", error));
}

async function installUpdate(filePath, newVersion) {
    if (!isAccessGranted) {
        return;
    }

    try {
        const zip = new AdmZip(filePath);
        const zipEntries = zip.getEntries();
        if (zipEntries.length === 0) {
            throw new Error("Архив пуст или повреждён");
        }

        zip.extractAllTo(nw.__dirname, true);
        setLocalVersion(newVersion);
        fs.unlinkSync(filePath);
        restartApplication();
		await login();
    } catch (error) {
        console.error("Ошибка установки обновления:", error);
        alert("Ошибка установки обновления: " + error.message);
    }
}

function restartApplication() {
    try {
        const nwPath = process.execPath;
        const appPath = nw.__dirname;
        spawn(nwPath, [appPath], {
            detached: true,
            stdio: 'ignore'
        }).unref();

        nw.App.quit();
    } catch (error) {
        alert("Ошибка при перезапуске приложения: " + error.message);
    }
}

function downloadUpdate(newVersion) {
    if (!isAccessGranted) {
        console.log("Обновления заблокированы. Доступ не получен.");
        return;
    }

    const downloadUrl = "https://shadow-diaso.su/api/download_msm_update_tech";
    const updateFilePath = path.resolve(nw.__dirname, "update_msm_tech.zip");
    const updateModal = document.getElementById("update-modal");
    const updateProgress = document.getElementById("update-progress");
    const updateStatus = document.getElementById("update-status");

    updateModal.style.display = "flex";
    updateStatus.innerText = "Загрузка обновления...";
    showLoader();

    fetch(downloadUrl)
        .then(response => {
            if (!response.ok) throw new Error("Ошибка загрузки файла");
            const total = +response.headers.get("Content-Length");
            let loaded = 0;

            const fileStream = fs.createWriteStream(updateFilePath);
            const reader = response.body.getReader();

            return new Promise((resolve, reject) => {
                function read() {
                    reader.read().then(({ done, value }) => {
                        if (done) {
                            fileStream.close();
                            resolve();
                            return;
                        }

                        loaded += value.length;
                        const percentage = Math.round((loaded / total) * 100);
                        updateProgress.style.width = `${percentage}%`;
                        fileStream.write(Buffer.from(value));
                        read();
                    }).catch(reject);
                }
                read();
            });
        })
        .then(() => {
            updateStatus.innerText = "Установка обновления...";
            installUpdate(updateFilePath, newVersion);
        })
        .catch(error => {
            updateStatus.innerText = "Ошибка загрузки обновления.";
            console.error("Ошибка загрузки:", error);
        })
        .finally(() => hideLoader());
}

function showUpdateModal() {
    const updateModal = document.getElementById("update-modal");
    const updateStatus = document.getElementById("update-status");
    const updateProgress = document.getElementById("update-progress");

    updateModal.style.display = "flex";
    updateStatus.innerText = "Подготовка к обновлению...";
    updateProgress.style.width = "0%";
}

document.addEventListener("DOMContentLoaded", () => {
    checkForUpdates();
});



function injectWindowControls() {
    if (document.body) {
        const htmlTemplate = `
            <div id="custom-title-bar" style="
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 35px;
                background-color: rgb(19, 20, 47, 0.82);
                display: flex;
                justify-content: flex-end;
                align-items: center;
                z-index: 1000;
                -webkit-app-region: drag;">
                
                <button id="minimize-button" style="
                    width: 42px;
                    height: 35px;
                    border: none;
                    cursor: pointer;
                    background-color: transparent;
                    color: #b267ff;
                    -webkit-app-region: no-drag;">—
                </button>
                
                <button id="maximize-button" style="
                    width: 42px;
                    height: 35px;
                    border: none;
                    cursor: pointer;
                    background: none;
                    color: #b267ff;
                    font-size: 22px;
                    -webkit-app-region: no-drag;">+
                </button>
                
                <button id="close-button" style="
                    width: 42px;
                    height: 35px;
                    border: none;
                    cursor: pointer;
                    background-color: transparent;
                    color: #b267ff;
                    -webkit-app-region: no-drag;">X
                </button>
            </div>
        `;

        document.body.insertAdjacentHTML('afterbegin', htmlTemplate);
        const win = nw.Window.get();
        const minimizeButton = document.getElementById('minimize-button');
        minimizeButton.onclick = () => win.minimize();
        const maximizeButton = document.getElementById('maximize-button');
        maximizeButton.onclick = () => {
            if (win.isMaximized) {
                win.restore();
            } else {
                win.maximize();
            }
        };

        const closeButton = document.getElementById('close-button');
        closeButton.onclick = () => win.close();
        let inactivityTimer;
        function resetInactivityTimer() {
            clearTimeout(inactivityTimer);
            inactivityTimer = setTimeout(() => {
                win.close();
            }, 15 * 60 * 1000);
        }

        document.addEventListener('mousemove', resetInactivityTimer);
        document.addEventListener('keydown', resetInactivityTimer);
        resetInactivityTimer();
        observer.disconnect();
    }
}

const observer = new MutationObserver(() => {
    if (document.body) {
        injectWindowControls();
    }
});


observer.observe(document.documentElement, { childList: true, subtree: true });
function attachModalHandlers() {
    const modalContainer = document.getElementById("modal-container");
    const webviewContainer = document.getElementById("webview-container");
    const closeModalBtn = document.getElementById("close-modal");
    window.openModal = (url) => {
        webviewContainer.innerHTML = '';
        webviewContainer.innerHTML = `
            <webview id="modal-webview" allowpopups src="${url}" style="
                flex-grow: 1; border: none;">
            </webview>
        `;
        const modalWebview = document.getElementById("modal-webview");
        modalContainer.style.display = "flex";
        modalWebview.addEventListener("dom-ready", () => {
            modalWebview.executeJavaScript(`
                document.body.style.backgroundColor = "#f9f9f9";
                document.body.style.fontFamily = "Arial, sans-serif";
                document.body.style.color = "#333";
            `);
        });
    };

    closeModalBtn.addEventListener("click", () => {
        modalContainer.style.display = "none";
        webviewContainer.innerHTML = '';
    });
}

//document.addEventListener('DOMContentLoaded', () => {
//    function sendPostRequest(orderId) {
//        fetch("https://shadow-diaso.su/api/order_id_vrd", {
//            method: "POST",
//            headers: { "Content-Type": "application/json" },
//            body: JSON.stringify({ orderId })
//        })
//        .then(response => {
//            if (response.ok) {
//                console.log(`[DEBUG] POST-запрос успешно отправлен для ORDER_ID=${orderId}`);
//            } else {
//                console.error(`[DEBUG] Ошибка при отправке POST-запроса: ${response.statusText}`);
//            }
//        })
//        .catch(error => console.error(`[DEBUG] Ошибка сети при отправке POST-запроса: ${error}`));
//    }
//
//    function processUrl(url) {
//        const urlPattern = /^https?:\/\/lego-format\.ru\/personal\/order\/index\.php\?ORDER_ID=\d+/;
//        if (urlPattern.test(url)) {
//            const orderId = new URL(url).searchParams.get("ORDER_ID");
//            if (orderId) {
//                sendPostRequest(orderId);
//            } else {
//                console.error(`[DEBUG] ORDER_ID не найден в URL: ${url}`);
//            }
//        } else {
//            console.log(`[DEBUG] URL не соответствует шаблону: ${url}`);
//        }
//    }
//
//    function monitorWebviewSrc(webview) {
//        let lastSrc = webview.src;
//
//        setInterval(() => {
//            if (webview.src !== lastSrc) {
//                lastSrc = webview.src;
//                processUrl(lastSrc);
//            }
//        }, 500);
//    }
//
//    function attachWebviewListeners() {
//        const webviews = document.querySelectorAll('webview');
//        webviews.forEach((webview) => {
//            monitorWebviewSrc(webview);
//        });
//    }
//
//    const observer = new MutationObserver((mutations) => {
//        mutations.forEach((mutation) => {
//            mutation.addedNodes.forEach((node) => {
//                if (node.tagName === 'WEBVIEW') {
//                    monitorWebviewSrc(node);
//                }
//            });
//        });
//    });
//
//    observer.observe(document.body, { childList: true, subtree: true });
//    attachWebviewListeners();
//});

function checkAndStyleAnthracite() {
    const cartModal = document.getElementById('cart');

    if (!cartModal) {
        return;
    }

    const spans = cartModal.getElementsByTagName('span');
    for (let span of spans) {
        if (span.textContent.includes('Антрацит')) {
            let parentDiv = span.closest('div');
            if (parentDiv) {
                parentDiv.style.color = '#ffbf00';
				parentDiv.style.fontSize = '16px';
            }
        }
    }
}

function waitForCartModal() {
    const checkInterval = setInterval(() => {
        const cartModal = document.getElementById('cart');
        if (cartModal) {
            clearInterval(checkInterval);
            setupObserver();
        }
    }, 500);
}

function setupObserver() {
    const cartModal = document.getElementById('cart');
    if (cartModal) {
        const observer = new MutationObserver(() => {
            checkAndStyleAnthracite();
        });
        observer.observe(cartModal, { childList: true, subtree: true });
    }
}

document.addEventListener('DOMContentLoaded', () => {
    waitForCartModal();
});
