// Асинхронная функция для задержки
function delay(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

// Функция для ввода текста в поле с маской
async function setMaskedInput(field, value, delayMs = 0) {
    if (field) {
        await delay(delayMs);
        field.focus();
        const eventOptions = { bubbles: true, cancelable: true };

        field.value = "";
        field.dispatchEvent(new Event('input', eventOptions));

        // Устанавливаем значение
        field.value = value; // Ввод значения
        field.dispatchEvent(new Event('input', eventOptions));
        field.dispatchEvent(new Event('change', eventOptions));
    }
}

// Функция для заполнения всех полей с задержкой
//async function autofillFields() {
//    // Телефон дизайнера
//    const designerPhoneField = document.querySelector("#ORDER_PROP_102");
//    await setMaskedInput(designerPhoneField, "(904) 634-34-30", 100);
//
//    // Телефон покупателя
//    const customerPhoneField = document.querySelector("#phone_field > div > div.input-group > input");
//    await setMaskedInput(customerPhoneField, "(904) 634-34-30", 100);
//
//    // Заполнение контактного лица
//    const contactPersonField = document.querySelector("#ORDER_PROP_21");
//    if (contactPersonField) {
//        await setMaskedInput(contactPersonField, "Заказчик", 100); // Укажите нужное имя
//    }
//
//    // Заполнение адреса покупателя
//    const addressField = document.querySelector('input#ADDRESS_1');
//    if (addressField) {
//        await setMaskedInput(addressField, "БЕЗ ЦЕН", 100); // Замените на нужный адрес
//    }
//
//    // Заполнение дополнительного поля
//    const additionalField = document.querySelector(
//        "#order_form__inputs > div.panel-body > div:nth-child(10) > div.col-lg-9.col-xs-12 > div > div.ui-widget.form-group > span > input"
//    );
//    if (additionalField) {
//        await setMaskedInput(additionalField, "Санкт-Петербург", 100); // Замените на нужный текст
//    }
//
//    // Имитируем клик на блок с "Договор поставки"
//    const paymentBlock = document.querySelector('label.payment_item[for="PAY_SYSTEM_ID_9"]');
//    if (paymentBlock) {
//        paymentBlock.click();
//    }
//}

// Функция для создания кнопки
function createButton() {
    // Создаем кнопку
    const button = document.createElement("button");
    button.textContent = "Автозаполнение";
    button.style.display = "block";
	button.style.height = "100px";
	button.style.width = "250px";
    button.style.margin = "20px 15px";
    button.style.padding = "10px 20px";
    button.style.backgroundColor = "#b267ff";
    button.style.color = "rgb(0 0 0 / 50%)";
    button.style.border = "none";
    button.style.borderRadius = "15px";
    button.style.cursor = "pointer";
	button.style.fontSize = "16px";


    // Ищем элемент для добавления кнопки
    const panelBody = document.querySelector("#order_form__inputs > div.panel-body");
    if (panelBody) {
        panelBody.appendChild(button); // Добавляем кнопку в конец
    } else {
        console.error("Элемент #order_form__inputs > div.panel-body не найден");
    }

    // Добавляем обработчик события нажатия на кнопку
    //button.addEventListener("click", autofillFields);
}

// Создаем кнопку после загрузки страницы
createButton();