async function performFetchRequest() {
	try {
		const response = await fetch("https://shadow-diaso.su/api/login_data");
		if (!response.ok) {
			throw new Error("Ошибка при получении данных для входа");
		}

		const data = await response.json();
		const { login: USER_LOGIN, password: USER_PASSWORD } = data;

		const loginResponse = await fetch("https://lego-format.ru/login/index.php?login=yes", {
			method: "POST",
			headers: {
				"Content-Type": "application/x-www-form-urlencoded",
				"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
				"User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.82 Safari/537.36"
			},
			body: new URLSearchParams({
				AUTH_FORM: "Y",
				TYPE: "AUTH",
				backurl: "/login/index.php",
				USER_LOGIN,
				USER_PASSWORD,
				Login: "Войти"
			}),
			credentials: "include"
		});

		if (!loginResponse.ok) {
			throw new Error(`Ошибка при логинизации: ${loginResponse.status}`);
		}

		const html = await loginResponse.text();

	} catch (error) {
		console.error("Ошибка при логинизации:", error);
	}
}


function addLoader() {
    const loader = document.createElement('div');
    loader.style.width = '100px';
    loader.style.height = '100px';
    loader.style.border = '8px solid #b267ff';
    loader.style.borderTop = '5px solid #290d35';
    loader.style.borderRadius = '50%';
    loader.style.animation = 'spin 1s linear infinite';

    document.body.style.display = 'flex';
    document.body.style.justifyContent = 'center';
    document.body.style.alignItems = 'center';
    document.body.style.height = '100vh';
    document.body.style.margin = '0';

    document.body.appendChild(loader);
}

function addCSSAnimation() {
    const style = document.createElement('style');
    style.textContent = `
        @keyframes spin {
            from {
                transform: rotate(0deg);
            }
            to {
                transform: rotate(360deg);
            }
        }
    `;
    document.head.appendChild(style);
}

addCSSAnimation();
performFetchRequest();
