const modalHTML = `
<div id="modal-container" style="
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.7);
    z-index: 1000;
    justify-content: center;
    align-items: center;">
    
    <div style="
        background-color: #290d35;
        width: 900px;
        height: 90%;
        border-radius: 10px;
        overflow: hidden;
        display: flex;
        flex-direction: column;
		box-shadow: 0px 0px 25px 0px;">
        
        <!-- Кнопка закрытия -->
        <div style="
            display: flex;
            justify-content: flex-end;
            padding: 10px;
            background-color: #290d35;
			border: none">
            <button id="close-modal" style="
                border: none;
                background: none;
                font-size: 18px;
                cursor: pointer;">×</button>
        </div>

        <!-- Контейнер для webview -->
        <div id="webview-container" style="flex-grow: 1; border: none; background-color: transparent;"></div>
    </div>
</div>
`;

function removeGoToCartModal() {
    const modal = document.getElementById("goToCart");
    if (modal) {
        modal.remove();
        console.log("Модальное окно с ID 'goToCart' было удалено.");
    } else {
        console.warn("Модальное окно с ID 'goToCart' не найдено.");
    }
}


const observer = new MutationObserver(() => {
    if (document.body) {
        document.body.insertAdjacentHTML("beforeend", modalHTML);
        observer.disconnect();
        attachModalHandlers();
        const orderBtn = document.querySelector(".modal #order_btn");
        if (orderBtn) {
            orderBtn.addEventListener("click", () => {
                openModal("https://lego-format.ru/personal/order/");
            });
        } else {
            console.warn("Кнопка #order_btn внутри .modal не найдена.");
        }
    }
});


observer.observe(document.documentElement, { childList: true, subtree: true });

function attachModalHandlers() {
    const modalContainer = document.getElementById("modal-container");
    const webviewContainer = document.getElementById("webview-container");
    const closeModalBtn = document.getElementById("close-modal");

    let mutationObserver;
    window.openModal = (url) => {
        webviewContainer.innerHTML = '';
        webviewContainer.innerHTML = `
            <webview id="modal-webview" nodeintegration allowpopups src="${url}" style="
                flex-grow: 1; border: none;">
            </webview>
        `;
		removeGoToCartModal();
        const modalWebview = document.getElementById("modal-webview");
        modalContainer.style.display = "flex";
        mutationObserver = new MutationObserver((mutations) => {
            mutations.forEach((mutation) => {
                if (mutation.type === "attributes" && mutation.attributeName === "src") {
                    webviewContainer.innerHTML = '';
                    webviewContainer.innerHTML = `
                        <webview id="modal-webview" nodeintegration allowpopups src="https://lego-format.ru/personal/order/" style="
                            flex-grow: 1; border: none;">
                        </webview>
                    `;
                }
            });
        });

        mutationObserver.observe(modalWebview, { attributes: true });

        modalWebview.addEventListener("dom-ready", () => {
            modalWebview.executeJavaScript(`
                document.body.style.backgroundColor = "#f9f9f9";
                document.body.style.fontFamily = "Arial, sans-serif";
                document.body.style.color = "#333";
            `);
        });
    };

    closeModalBtn.addEventListener("click", () => {
        modalContainer.style.display = "none";
        webviewContainer.innerHTML = '';
        if (mutationObserver) {
            mutationObserver.disconnect();
        }
    });
}
