/**
 * Created by WebDevelop on 21.11.2014.
 * Единица измерения 1 = 1(мм)
 */
"use strict";

// import * as THREE from '/local/libs/threejs/three.js-r120/build/three.module.js';
// import { DeviceOrientationControls } from '/local/libs/threejs/three.js-r120/examples/jsm/controls/DeviceOrientationControls.js';
// import { TransformControls } from '/local/libs/threejs/three.js-r120/examples/jsm/controls/TransformControls.js';
// import { OrbitControlsactive_fasade_segment } from '/local/libs/threejs/three.js-r120/examples/jsm/controls/OrbitControls.js';
// import { WEBGL } from '/local/libs/threejs/three.js-r120/examples/jsm/WebGL.js';

function Constructor() {
    /**
     * Debug tweeks
     * */

    // console.log(this.dat)
    // var gui = new dat.GUI();
    // gui.close(); // make closed debug panel closed

    /*Ссылаемся на обьект*/
    var self = this;

    this.scope = {};

    this.selected = false;

    this.timer = 0;

    this.cache = [];

    /*Управление*/
    this.raycaster = new THREE.Raycaster();

    this.mouse = new THREE.Vector3();
    /********** Создаём сцену **********/

    this.System = new Object({
        mobile: /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent),
        browser: (function () {
            var n = navigator.userAgent;
            return /Arora/i.test(n)
                ? "Arora"
                : /Chrome/i.test(n)
                    ? "Chrome"
                    : /Epiphany/i.test(n)
                        ? "Epiphany"
                        : /Firefox/i.test(n)
                            ? "Firefox"
                            : /Mobile(\/.*)? Safari/i.test(n)
                                ? "Mobile Safari"
                                : /MSIE/i.test(n)
                                    ? "Internet Explorer"
                                    : /Midori/i.test(n)
                                        ? "Midori"
                                        : /Opera/.test(n)
                                            ? "Opera"
                                            : /Safari/i.test(n)
                                                ? "Safari"
                                                : !1;
        })(),
        os: (function () {
            var n = navigator.userAgent;
            return /Android/i.test(n)
                ? "Android"
                : /CrOS/i.test(n)
                    ? "Chrome OS"
                    : /iP[ao]d|iPhone/i.test(n)
                        ? "iOS"
                        : /Linux/i.test(n)
                            ? "Linux"
                            : /Mac OS/i.test(n)
                                ? "Mac OS"
                                : /windows/i.test(n)
                                    ? "Windows"
                                    : !1;
        })(),
        support: {
            canvas: !!window.CanvasRenderingContext2D,
            localStorage: (function () {
                try {
                    return !!window.localStorage.getItem;
                } catch (n) {
                    return !1;
                }
            })(),
            file: !!window.File && !!window.FileReader && !!window.FileList && !!window.Blob,
            fileSystem: !!window.requestFileSystem || !!window.webkitRequestFileSystem,
            getUserMedia:
                !!window.navigator.getUserMedia ||
                !!window.navigator.webkitGetUserMedia ||
                !!window.navigator.mozGetUserMedia ||
                !!window.navigator.msGetUserMedia,
            requestAnimationFrame:
                !!window.mozRequestAnimationFrame ||
                !!window.webkitRequestAnimationFrame ||
                !!window.oRequestAnimationFrame ||
                !!window.msRequestAnimationFrame,
            sessionStorage: (function () {
                try {
                    return !!window.sessionStorage.getItem;
                } catch (n) {
                    return !1;
                }
            })(),
            webgl: (function () {
                try {
                    return (
                        !!window.WebGLRenderingContext &&
                        !!document.createElement("canvas").getContext("experimental-webgl")
                    );
                } catch (n) {
                    return !1;
                }
            })(),
            worker: !!window.Worker,
        },
    });

    this.start = function () {
        THREE.Object3D.prototype.castShadow = true;
        THREE.Object3D.prototype.receiveShadow = true;

        THREE.Mesh.prototype.castShadow = true;
        THREE.Mesh.prototype.receiveShadow = true;

        THREE.Group.prototype.receiveShadow = true;
        THREE.Group.prototype.castShadow = true;

        THREE.Cache.enabled = true;

        self.manager = new THREE.LoadingManager();

        self.manager.onProgress = function (item, loaded, total) {
        };
        self.manager.onLoad = function () {
        };
        self.manager.onError = function () {
        };

        /********** div #container **********/
        self.container_sel = "container";
        self.container = angular.element("#" + this.container_sel);

        self.consoleContainer = angular.element("#console");

        self.scene = new THREE.Scene();

        /*
     * THREE.LinearEncoding
     * THREE.sRGBEncoding
     * THREE.GammaEncoding
     * THREE.RGBEEncoding
     * THREE.LogLuvEncoding
     * THREE.RGBM7Encoding
     * THREE.RGBM16Encoding
     * THREE.RGBDEncoding
     * THREE.BasicDepthPacking
     * THREE.RGBADepthPacking
     * */
        self.encode = THREE.sRGBEncoding; //sRGBEncoding

        self.renderer = new THREE.WebGLRenderer({
            antialias: true,
            preserveDrawingBuffer: true,
        });

        // self.renderer.autoClear = false
        self.renderer.sortObjects = true;

        self.renderer.outputEncoding = self.encode;

        self.renderer.setClearColor(self.scope.outlineType ? "#ffffff" : "#ffde00");
        self.renderer.setSize(window.innerWidth, window.innerHeight);

        self.TextureLoader = new THREE.TextureLoader(self.manager);
        self.DaeLoader = new THREE.ColladaLoader(self.manager);
        self.FBXLoader = new THREE.FBXLoader(self.manager);
        self.GLTFLoader = new THREE.GLTFLoader(self.manager);

        self.container.html("");
        self.container.append(self.renderer.domElement);

        window.addEventListener("resize", self.onWindowResize, false);

        self.createRoom();

        self.initCamera();

        self.scope.onCopySuccess = function (e) {
            self.alert("ID скопированн в буфер обмена", "success");
        };
        self.scope.onCopyerror = function (e) {
            self.alert("Копирование запрещено", "error");
        };
        self.scope.alerts = {};
        self.scope.disabledProducts = {};
        self.scope.disabledObjectProducts = {};
        self.scope.fasadeErrorColor = 6004285;
        self.scope.Math = window.Math;
        self.scope.resizeForm = false;
        self.scope.setElementOptions = self.setElementOptions;
        self.scope.setElementUslugi = self.controlElementUslugi;
        self.scope.setElementWidthMom = self.setElementWidthMom;
        self.scope.setElementHem = self.setElementHem;
        self.scope.controlRaspil = self.controlRaspil;
        self.scope.controlRaspilInputPosition = self.controlRaspilInputPosition;
        self.scope.initRaspil = self.initRaspil;
        self.scope.showConfigRaspil = self.showConfigRaspil;
        self.scope.resetRotation = self.resetRotation;
        self.scope.saveRaspil = self.saveRaspil;
        self.scope.addRaspil = self.addRaspil;
        self.scope.changeRaspilSize = self.changeRaspilSize;
        self.scope.removeRaspil = self.removeRaspil;
        self.scope.deleteHandle = self.deleteHandle;
        self.scope.Print = self.Print;
        self.scope.changeHandlePosition = self.changeHandlePosition;
        self.scope.configHandle = self.configHandle;
        self.scope.setRotation = self.setRotation;
        self.scope.showBasket = self.showBasket;
        self.scope.createNewProject = self.createNewProject;
        self.scope.elementSizeWatch = new Function();
        self.scope.OpenSaveModal = self.OpenSaveModal;
        self.scope.DeleteProject = self.DeleteProject;
        self.scope.login = self.login;
        self.scope.logout = self.logout;
        self.scope.OpenProject = self.OpenProject;
        self.scope.ChangeDefaultHandle = self.rebuildHandle;
        self.scope.addProjectToBasket = self.addProjectToBasket;
        self.scope.OpenProjects = self.OpenProjects;
        self.scope.Auth = self.Auth;
        self.scope.changeSize = self.changeSize;
        self.scope.changeFilling = self.changeFilling;
        self.scope.showOptionsTab = self.showOptionsTab;
        self.scope.hideOptionsTab = self.hideOptionsTab;
        self.scope.changeFasadeSize = self.changeFasadeSize;
        self.scope.getMaxSectionPosition = self.getMaxSectionPosition;
        self.scope.splitSection = self.splitSection;
        self.scope.addSlideDoor = self.addSlideDoor;
        self.scope.removeSlideDoor = self.removeSlideDoor;
        self.scope.addDoor = self.addDoor;
        self.scope.checkAddDoor = self.checkAddDoor;
        self.scope.removeDoor = self.removeDoor;
        self.scope.calcSumDoorSegments = self.calcSumDoorSegments;
        self.scope.changeBasketCountProducts = self.changeBasketCountProducts;
        self.scope.getMaxSectionPosition = self.getMaxSectionPosition;
        self.scope.getProductInfo = self.getProductInfo;
        self.scope.changeFasadeHeight = self.changeFasadeHeight;    //Изменить высоту фасада через ввод
        self.scope.getMaxSubFasadeSize = self.getMaxSubFasadeSize;  //Посчитать максимально возможный размер для изменяемого фасада
        self.scope.checkBoxIsFasade = self.checkBoxIsFasade;    //Проверить, является ли фасад фасадом ящика
        self.scope.getFasadeSrc = self.getFasadeSrc;    //Получить информацию по фасаду для интерфейса
        self.scope.getFilteredAvailableFasades = self.getFilteredAvailableFasades;    //Отфильтровать фасады на недоступность размеров
        self.scope.changeBenchPartitionSize = self.changeBenchPartitionSize;
        self.scope.checkCanRemoveFasadeSegment = self.checkCanRemoveFasadeSegment //Проверка возможности удаления сегмента фасада
        self.scope.calcSideHiTechProfile = self.calcSideHiTechProfile;
        self.scope.parseBasketProps = self.parseBasketProps
        self.scope.isObject = self.isObject
        self.scope.checkFasadesCount = self.checkFasadesCount;    //Проверка наличия фасадов в модуле
        self.scope.parsePropIndex = self.parsePropIndex;
        self.scope.getGroupedOptions = self.getGroupedOptions;
        self.scope.getFasadePosition = self.getFasadePosition;
        self.scope.createCompositeFasade = self.createCompositeFasade;
        self.scope.calcFasadeWidth = self.calcFasadeWidth;
        self.scope.addFasadeSegment = self.addFasadeSegment; //Добавить сегмент для составного фасада
        self.scope.removeFasadeSection = self.removeFasadeSection; //Удалить сегмент для составного фасада
        self.scope.checkAutoGenShelf = self.checkAutoGenShelf;  //Проверить, является ли элемент авто-сгенерированной полкой
        self.scope.deleteCompositeFasade = self.deleteCompositeFasade;
        self.scope.deleteBackwall = self.deleteBackwall; //Удалить заднюю стенку
        //self.scope.clearBackwallBasket = self.clearBackwallBasket; //Очистка BASKET от поля BACKWALL
        self.scope.deleteTopFasade = self.deleteTopFasade; //Удалить накладку на крышку модуля
        self.scope.deleteHorizont = self.deleteHorizont; //Удалить горизонт
        self.scope.changeHorizontHeight = self.changeHorizontHeight; //Изменить высоту горизонта
        self.scope.checkGroupedFasades = self.checkGroupedFasades; //Возможно ли объединить фасады выделенных модулей
        self.scope.checkDegroupedFasades = self.checkDegroupedFasades; //Возможно ли разгруппировать фасады выделенных модулей
        self.scope.groupFasades = self.groupFasades; //Объединить фасады выделенных модулей
        self.scope.degroupFasades = self.degroupFasades; //Разгруппировать фасады выделенных модулей
        self.scope.removeElementFromGroup = self.removeElementFromGroup; //Удалить модуль из группы фасадов
        self.scope.getGroupFasadeFromSelected = self.getGroupFasadeFromSelected; //Преобразовать объект selected в массив, для обработки в интерфейсе
        self.scope.SaveProject = self.SaveProject;
        self.scope.getUserId = self.getUserId;
        self.scope.showFasadeParam = self.showFasadeParam;
        self.scope.showCatalog = self.showCatalog;
        self.scope.selectElement = self.selectElement;
        self.scope.CatalogGetElement = self.CatalogGetElement;
        self.scope.controlChangedTabletop = self.controlChangedTabletop;
        self.scope.controlChangedPlinth = self.controlChangedPlinth;
        self.scope.copyElement = self.copyElement;
        self.scope.isResize = self.isResize;
        self.scope.isArray = Array.isArray;
        self.scope.ActionMenu = self.ActionMenu;
        self.scope.optionsFunction = self.optionsFunction;
        self.scope.optionsIsActive = self.optionsIsActive;
        self.scope.optionsGetData = self.optionsGetData;
        self.scope.haveHandle = self.haveHandle;
        self.scope.rebuildWrap = self.rebuildWrap;
        self.scope.changeShelfCount = self.changeShelfCount;
        self.scope.changeShelfPosition = self.changeShelfPosition;
        self.scope.changeSubElementPosition = self.changeSubElementPosition;
        self.scope.getSizeBorders = self.getSizeBorders;
        self.scope.changeBoxFasadeSize = self.changeBoxFasadeSize;// Изменение размеров внешнего фасада ящика
        self.scope.deleteSubElementToElement = self.deleteSubElementToElement;
        self.scope.controlSectionFilling = self.controlSectionFilling;
        self.scope.controlSectionInput = self.controlSectionInput;
        self.scope.returnElementWidth = self.returnElementWidth;
        self.scope.hideElement = self.hideElement;
        self.scope.showElement = self.showElement;
        self.scope.disableInput = self.disableInput;
        self.scope.searchSizeFasade = self.searchSizeFasade;
        self.scope.checkSizeFasade = self.checkSizeFasade;
        self.scope.setSectionsSize = self.setSectionsSize;
        self.scope.setElementMechanism = self.setElementMechanism;
        self.scope.clearElementMechanism = self.clearElementMechanism;
        self.scope.changeJoinDepth = self.changeJoinDepth;
        self.scope.catalogButtonCurPrevAdd = self.catalogButtonCurPrevAdd;
        self.scope.catalogButtonCurPrevShow = self.catalogButtonCurPrevShow;
        self.scope.loadProjectStatus = true;

        /*Для работы с технологом*/
        self.scope.showFormTech = self.showFormTech;
        self.scope.submitTechForm = self.submitTechForm;
        self.scope.clearForm = self.clearForm;
        self.scope.addInputTechnique = self.addInputTechnique;
        self.scope.technologist = self.technologist;
        self.scope.getTechList = self.getTechList;
        self.scope.setStatus = self.setStatus;
        self.scope.sendToDesigner = self.sendToDesigner;
        self.scope.openModalSTD = self.openModalSTD;
        self.scope.openModalComments = self.openModalComments;
        self.scope.openModalOrder = self.openModalOrder;
        self.scope.uploadProjectTech = self.uploadProjectTech;
        self.scope.arrIdInputFile = {}
        self.scope.deal = {
            'dealId': false,
            'dealStatus': false,
            'techProjectId': false,
            'techProject': false,
        }
        /*Для работы с технологом*/

        self.scope.activeRotation = {
            x: 0,
            y: 0,
            z: 0,
        };
        self.scope.sectionsSizes = {
            universalModule: {
                VSECTION_MIN: 114,
                VSECTION_MAX: 900,
            },
        };
        self.scope.setCatalogSection = function (type) {
            self.scope.sectionsType = type;
            self.scope.$applyAsync();
        };
        self.scope.changeShelfquant = function () {
            self.updateElement(self.scope.app.active);
        };
        self.scope.changeJoinDepth = function () {
            let val = parseInt(self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH);
            if (isNaN(val)) {
                val = self.getProductInfo(self.scope.app.active.PROPS.CONFIG.ID).SIZE_EDIT_JOINDEPTH_MIN;
            }
            if (
                val > self.getProductInfo(self.scope.app.active.PROPS.CONFIG.ID).SIZE_EDIT_JOINDEPTH_MAX
            ) {
                val = self.getProductInfo(self.scope.app.active.PROPS.CONFIG.ID).SIZE_EDIT_JOINDEPTH_MAX;
            } else if (
                val < self.getProductInfo(self.scope.app.active.PROPS.CONFIG.ID).SIZE_EDIT_JOINDEPTH_MIN
            ) {
                val = self.getProductInfo(self.scope.app.active.PROPS.CONFIG.ID).SIZE_EDIT_JOINDEPTH_MIN;
            }
            if (val == 0) {
                delete self.scope.app.active.PROPS.CONFIG.BASKET["SIZEEDITJOINDEPTH"];
            } else {
                self.scope.app.active.PROPS.CONFIG.BASKET["SIZEEDITJOINDEPTH"] = val;
            }
            self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH = val;
            self.controlJoinDeph();
            self.updateElement(self.scope.app.active);
        };

        self.scope.errorPropFilter = function (item, list, el, sect) {
            const loopDepth = 73;
            let match = false;
            let section = false;

            if (el) {
                const prop = self.getProductInfo(item.ID)
                const modelId = self.getProductInfo(el.ID)?.models[0];
                const isLoop = self.scope.app.MODELS[modelId]?.loop_position;

                if (prop) {
                    if (prop.CNSTR_MIN_WIDTH) {
                        if (sect) {
                            const section = Number(sect.split(" ")[2]);

                            if (prop.CNSTR_MIN_WIDTH > el.PROPS["SECTIONS" + section]) {
                                return "errorWidth";
                            }
                        }
                    }
                    if (isLoop && prop.IS_BOX_SECTION === 1) {
                        if (prop.ACTUAL_DEPT + loopDepth >= el.PROPS.SIZEEDITDEPTH) {
                            return "errorDepth";
                        }
                    } else if (prop.ACTUAL_DEPT >= el.PROPS.SIZEEDITDEPTH) {
                        return "errorDepth";
                    } else if (item.VALUE !== null && item.VALUE === 0) {
                        return "errorHeight";
                    } else if (item.WARNING) {
                        return "warning";
                    } else if (item.ERROR) {
                        return "error";
                    }
                }
            }

            angular.forEach(list, function (listItem) {
                let i = Number(item);
                let i2 = Number(listItem);

                if (i === i2) {
                    match = true;
                }
            });
            return match;
        };

        self.scope.removeElementFromProject = function (e) {
            self.removeElementFromProject(e, false, self.getBasket);
        };
        self.scope.rebuildRoomLineOut = this.rebuildRoomLineOut;
        self.scope.warningBox = new THREE.Mesh(
            new THREE.BoxBufferGeometry(1, 1, 1),
            new THREE.MeshLambertMaterial({
                transparent: !0,
                opacity: 0.5,
                color: 0xff0000,
            })
        );
        self.scope.warningBox.material.color.convertSRGBToLinear();

        self.scope.goBasePosition = function () {
            self.goBasePosition();
        };

        self.scope.range = function (min, max, step) {
            step = step || 1;
            var input = [];
            for (var i = min; i <= max; i += step) {
                input.push(i);
            }
            return input;
        };

        self.scene.add(self.scope.warningBox);

        angular.element(document).ready(function () {
            jQuery.event.special.touchstart = {
                setup: function (_, ns, handle) {
                    if (ns.includes("noPreventDefault")) {
                        this.addEventListener("touchstart", handle, {passive: false});
                    } else {
                        this.addEventListener("touchstart", handle, {passive: true});
                    }
                }
            };
            jQuery.event.special.touchmove = {
                setup: function (_, ns, handle) {
                    if (ns.includes("noPreventDefault")) {
                        this.addEventListener("touchmove", handle, {passive: false});
                    } else {
                        this.addEventListener("touchmove", handle, {passive: true});
                    }
                }
            };

            // // self.renderer.domElement.addEventListener(self.mousemove, self.onMouseMove);
            // self.renderer.domElement.addEventListener('mousemove', self.onMouseMov, false);
            // self.renderer.domElement.addEventListener('touchmove', function (e) {
            //   // stop touch event
            //   e.stopPropagation();
            //   e.preventDefault();
            //
            //   // translate to mouse event
            //   var clkEvt = document.createEvent('MouseEvent');
            //   clkEvt.initMouseEvent('mousemove', true, true, window, e.detail,
            //       e.touches[0].screenX, e.touches[0].screenY,
            //       e.touches[0].clientX, e.touches[0].clientY,
            //       false, false, false, false,
            //       0, null);
            //   mydiv.dispatchEvent(clkEvt);
            //
            //   // or just handle touch event
            //   myMoveHandler(e);
            // }, false);
            // // self.renderer.domElement.addEventListener(self.mousedown, self.onDocumentMouseDown);
            // self.renderer.domElement.addEventListener('mousedown', self.onDocumentMouseDown, false);
            // self.renderer.domElement.addEventListener('touchstart', function (e) {
            //   // stop touch event
            //   e.stopPropagation();
            //   e.preventDefault();
            //
            //   // translate to mouse event
            //   var clkEvt = document.createEvent('MouseEvent');
            //   clkEvt.initMouseEvent('mousedown', true, true, window, e.detail,
            //       e.touches[0].screenX, e.touches[0].screenY,
            //       e.touches[0].clientX, e.touches[0].clientY,
            //       false, false, false, false,
            //       0, null);
            //   mydiv.dispatchEvent(clkEvt);
            //
            //   // or just handle touch event
            //   myMoveHandler(e);
            // }, false);
            // // self.renderer.domElement.addEventListener(self.mouseup, self.onDocumentMouseUp );
            // self.renderer.domElement.addEventListener('mouseup', self.onDocumentMouseUp, false);
            // self.renderer.domElement.addEventListener('touchend', function (e) {
            //   // stop touch event
            //   e.stopPropagation();
            //   e.preventDefault();
            //
            //   // translate to mouse event
            //   var clkEvt = document.createEvent('MouseEvent');
            //   clkEvt.initMouseEvent('mouseup', true, true, window, e.detail,
            //       e.touches[0].screenX, e.touches[0].screenY,
            //       e.touches[0].clientX, e.touches[0].clientY,
            //       false, false, false, false,
            //       0, null);
            //   mydiv.dispatchEvent(clkEvt);
            //
            //   // or just handle touch event
            //   myMoveHandler(e);
            // }, false);

            $(self.renderer.domElement)
                .on(self.mousemove, self.onMouseMove)
                .on(self.mousedown, self.onDocumentMouseDown)
                .on(self.mouseup, self.onDocumentMouseUp);
        });
    };

    
    this.export = function () {
        self.exportGLTF(self.scene);
    };

    this.exportToObj = function () {
        var exporter = new THREE.OBJExporter();
        var result = exporter.parse(self.scene);

        self.ExportLink = document.createElement("a");
        self.ExportLink.style.display = "none";
        document.body.appendChild(self.ExportLink); // Firefox workaround, see #6594

        self.saveString(result, "scene.obj");
    };

    this.exportToDAE = function () {
        var exporter = new THREE.OBJExporter();
        var result = exporter.parse(self.scene);

        self.ExportLink = document.createElement("a");
        self.ExportLink.style.display = "none";
        document.body.appendChild(self.ExportLink); // Firefox workaround, see #6594

        self.saveString(result, "scene.obj");
    };

    /*Экспорт*/
    
    this.exportGLTF = function (input) {
        var gltfExporter = new THREE.GLTFExporter();
    
        const fileName = self.scope.project.name || "scene";
        input.traverse((child) => {
            if (child.isMesh && child.material.opacity < 1) {
                const color = child.material.color.getHex();
                if (color !== 0x000000) {
                    child.visible = false;
                }
            }
        });
    
        var options = {
            binary: false,
            onlyVisible: true,
            embedImages: true,
            forcePowerOfTwoTextures: true,
        };
    
        gltfExporter.parse(
            input,
            function (result) {
                if (result instanceof ArrayBuffer) {
                    self.saveArrayBuffer(result, `${fileName}.glb`);
                } else {
                    var output = JSON.stringify(result);
                    self.saveString(output, `${fileName}.gltf`);
                }
            },
            options
        );
    
        self.ExportLink = document.createElement("a");
        self.ExportLink.style.display = "none";
        document.body.appendChild(self.ExportLink);
    };

    this.save = function (blob, filename) {
        self.ExportLink.href = URL.createObjectURL(blob);
        self.ExportLink.download = filename;
        self.ExportLink.click();

        // URL.revokeObjectURL( url ); breaks Firefox...
    };

    this.saveString = function (text, filename) {
        self.save(new Blob([text], {type: "text/plain"}), filename);
    };

    this.saveArrayBuffer = function (buffer, filename) {
        self.save(new Blob([buffer], {type: "application/octet-stream"}), filename);
    };
    /*Экспорт*/

    this.resetRotation = function () {
        self.scope.app.active.rotation.set(0, 0, 0);
        self.sincRotation();
    };

    this.showOptionsTab = function (type) {
        self.scope.lineElementFilterInput = "";
        self.scope.app.optionsTabName = self.scope.app.optionsTabName == type ? false : type;
    };

    this.hideOptionsTab = function () {
        self.scope.app.optionsTabName = false;
    };

    this.controlRaspilMarkerPosition = function (e) {
        var group = self.scope.app.active;
        var mooved = false;

        if (group && self.scope.app.raspilactive !== false) {
            var distance = e.clientX - self.scope.app.raspilactivePos;
            var factor = group.PROPS.CONFIG.SIZE.width / 918;
            var position = self.scope.app.raspilactivePosOld + Math.floor(distance * factor);
            self.controlRaspilPosition(group, self.scope.app.raspilactive, position);
            mooved = true;
        }

        if (mooved) self.scope.$applyAsync();
    };

    this.controlRaspilInputPosition = function (item, position) {
        var group = self.scope.app.active;
        self.controlRaspilPosition(group, item, position);
    };

    this.controlRaspilPosition = function (group, item, position) {
        var min = 10; //50
        var max = group.PROPS.CONFIG.SIZE.width - min;

        var prev = group.PROPS.RASPILLIST[item - 1];
        var next = group.PROPS.RASPILLIST[item + 1];

        position = Math.floor(position / 10) * 10;

        if (next) max = next - min;

        if (prev) min = prev + min;

        if (!position || position < min) position = min;

        if (position > max) position = max;

        group.PROPS.RASPILLIST[item] = position;

        self.calcRaspil(group);
    };

    this.calcRaspil = function (group) {
        group.PROPS.RASPILFRAGMENT = [];

        angular.forEach(group.PROPS.RASPILLIST, function (v, k) {
            var start = 0;
            var stop = group.PROPS.CONFIG.SIZE.width;

            var prev = group.PROPS.RASPILLIST[k - 1];
            var next = group.PROPS.RASPILLIST[k + 1];

            if (prev) start = prev;

            group.PROPS.RASPILFRAGMENT[k] = v - start;

            if (!next) group.PROPS.RASPILFRAGMENT[k + 1] = stop - v;
        });
    };

    /********** Запуск приложения **********/
    this.init = function ($rootScope, $scope, $http, $filter, $location) {
        self.scope = $scope;
        self.scope.error = false;

        if (THREE.WEBGL.isWebGLAvailable() === false) {
            self.scope.error = $(THREE.WEBGL.getWebGLErrorMessage()).text();
            return false;
        }

        /*Назначаем алиас глобального scope*/
        self.isStop = false;
        self.mouseup = "mouseup touchend";
        self.mousemove = "mousemove touchmove";
        self.mousedown = "mousedown touchstart";

        self.rootScope = $rootScope;
        self.$http = $http;
        self.$filter = $filter;
        self.$location = $location;
        /********** информация о проекте **********/

        self.scope.default = {};
        self.scope.project = {
            options: [],
            room_config: [],
            items: {},
            handle: false,
            table: false,
            table_color: false,
            wall: false,
            plinthDefault: false,
            plinthFasade: false,
            plinthPalette: false,
            floor: false,
            city: false,
            time: 0,
            default_module_color: false,
            default_module_color_up: false,
            default_module_color_down: false,
            default_fasade: false,
            default_fasade_up: false,
            default_fasade_down: false,
            default_fasade_milling_up: false,
            default_fasade_milling_down: false,
            default_fasade_patina_up: false,
            default_fasade_patina_down: false,
            default_fasade_palette_up: false,
            default_fasade_palette_down: false,
            name: "AP000000",
            saved: false,
            autoload: false,
            tabletopTypeAuto: true,
            camera: {
                position: false,
                rotation: false,
            },
            lightIntensive: 0.5,
            poitlightIntensive: 0.5,
            shadowQuality: 0,
            contextSentence: {
                link: false,
                error: false,
                text: false,
                saved: false,
            },
            technologist: false,
        };

        self.scope.setDefaultDesigner = self.setDefaultDesigner;
        self.scope.setSalonOwnerSetDesign = self.setSalonOwnerSetDesign;
        self.scope.preloaderDesignerProject = false;

        /**
         * Debug
         * */
        // gui.add(self.scope.project, 'lightIntensive')
        //  .min(-1)
        //  .max(3)
        //  .step(0.01)
        //  .name('свет');
        // gui.add(self.scope.project, 'poitlightIntensive')
        //  .min(-1)
        //  .max(3)
        //  .step(0.01)
        //  .name('poitlightIntensive');
        // gui.add(self.scope.project, 'shadowQuality')
        //  .min(-1)
        //  .max(3)
        //  .step(0.01)
        //  .name('shadowQuality');
        // gui.add( document, 'title' );

        self.scope.AfterSaveFn = function () {
        };
        self.scope.saveModalbtnOk = "Сохранить";
        self.scope.saveModalTitle = "Сохранение проекта";
        self.scope.outlineType = false;
        self.scope.controlDevice = false;
        self.scope.font = false;
        self.scope.camFactor = 45;
        self.scope.catalog = {
            items: [],
            page: 1,
            sections: [],
            section: false,
            pager: false,
            loading: false,
            element: false,
            filter: "",
            filterSection: "",
        };

        self.scope.catalogEvent = false;

        self.scope.app = {
            shadowQualityList: [
                {
                    name: "Отключено",
                    val: 0,
                },
                {
                    name: "Низкое",
                    val: 256,
                },
                {
                    name: "Стандарт",
                    val: 512,
                },
                {
                    name: "Высокое",
                    val: 1024,
                },
                {
                    name: "Ультра-высокое",
                    val: 2048,
                },
            ],
            Menu: {
                /*Левое*/
                sub_main: {
                    name: "Главное меню",
                    icon: "glyphicon glyphicon-home",
                    type: "func",
                    tooltip: "Главное меню",
                    placement: "right",
                    parent: "left",
                },
                getNewProject: {
                    name: "Начать новый проект",
                    icon: "glyphicon glyphicon-file",
                    type: "func",
                    tooltip: "Начать новый проект",
                    placement: "right",
                    parent: "left",
                },
                sub_project_settings: {
                    name: "Параметры проекта",
                    icon: "glyphicon glyphicon-wrench",
                    type: "tab",
                    tooltip: "Параметры проекта",
                    placement: "right",
                    parent: "left",
                },
                sub_catalog: {
                    name: "Каталог элементов",
                    icon: "glyphicon glyphicon-list",
                    type: "tab",
                    tooltip: "Каталог элементов",
                    placement: "right",
                    parent: "left",
                },
                sub_room_settings: {
                    name: "Параметры помещения",
                    icon: "glyphicon glyphicon-th",
                    type: "tab",
                    tooltip: "Параметры помещения",
                    placement: "right",
                    parent: "left",
                },
                sub_element_settings: {
                    name: "Параметры элемента",
                    icon: "glyphicon glyphicon-cog",
                    type: "tab",
                    tooltip: "Параметры элемента",
                    placement: "right",
                    parent: "left",
                },
                fullScreen: {
                    name: "Полноэкранный режим",
                    icon: "glyphicon glyphicon-fullscreen",
                    type: "func",
                    tooltip: "Полноэкранный режим",
                    placement: "right",
                    parent: "left",
                },

                /*Правое*/
                showHelp: {
                    name: "Справка",
                    icon: "glyphicon glyphicon-question-sign",
                    type: "func",
                    tooltip: "Справка",
                    placement: "right",
                    parent: "right",
                },
                Auth: {
                    name: "Авторизация",
                    icon: "glyphicon glyphicon-user",
                    type: "func",
                    tooltip: "Авторизация",
                    placement: "left",
                    parent: "right",
                },
                OpenProjects: {
                    name: "Открыть проект",
                    icon: "glyphicon glyphicon-folder-open",
                    type: "func",
                    tooltip: "Открыть проект",
                    placement: "left",
                    parent: "right",
                },
                OpenSaveModal: {
                    name: "Сохранить проект",
                    icon: "glyphicon glyphicon-floppy-disk",
                    type: "func",
                    tooltip: "Сохранить проект",
                    placement: "left",
                    parent: "right",
                },
                goBasePosition: {
                    name: "Установить вид по умолчанию",
                    icon: "glyphicon glyphicon-eye-open",
                    type: "func",
                    tooltip: "Установить вид по умолчанию",
                    placement: "left",
                    parent: "right",
                },
                downloadCanvas: {
                    name: "Сохранить снимок проекта",
                    icon: "glyphicon glyphicon-camera",
                    type: "func",
                    tooltip: "Сохранить снимок проекта",
                    placement: "left",
                    id: "screenshot",
                    return: 1,
                    target: "_blank",
                    parent: "right",
                },
                Print: {
                    name: "Печать спецификации",
                    icon: "glyphicon glyphicon-print",
                    type: "func",
                    tooltip: "Печать спецификации",
                    placement: "left",
                    parent: "right",
                },
                rebuildRoomLineOut: {
                    name: "Режим просмотра чертежа",
                    icon: "glyphicon glyphicon-edit",
                    type: "func",
                    tooltip: "Режим просмотра чертежа",
                    placement: "left",
                    parent: "right",
                },
                hideFrames: {
                    name: "Скрыть размеры",
                    icon: "glyphicon glyphicon-eye-close",
                    type: "func",
                    tooltip: "Скрыть размеры",
                    placement: "right",
                    parent: "right",
                },
                export: {
                    name: 'Экспорт', 
                    icon: 'glyphicon glyphicon-share',
                    type: 'func', 
                    tooltip: 'Экспорт', 
                    placement: 'left', 
                    parent:'right'
                },

            },
            optionsTab: {
                defaultFloor: {
                    name: "Цвет пола",
                    clearElement: false,
                    data: "FLOOR",
                    projectVarName: "floor",
                    function: "changeFloor",
                    templates: "matrixElement",
                    default: true,
                },
                defaultWall: {
                    name: "Цвет стен",
                    clearElement: false,
                    data: "WALL",
                    projectVarName: "wall",
                    function: "changeWall",
                    templates: "matrixElement",
                    default: true,
                },
                plinthDefault: {
                    name: "Тип цокольных планок",
                    clearElement: "clear_plinth",
                    data: "PLINTH",
                    projectVarName: "plinthDefault",
                    function: "changePlinth",
                    templates: "lineElement",
                    default: true,
                },
                plinthDefaultFasade: {
                    name: "Тип фасада цокольных планок",
                    clearElement: "clear_fasade",
                    data: "FASADE",
                    projectVarName: "plinthFasade",
                    templates: "fasade",
                    function: "changePlinthFasade",
                    parent: "plinthDefault",
                    default: true,
                },
                plinthDefaultPalette: {
                    name: "Тип палитры цокольных планок",
                    clearElement: false,
                    data: "PALETTE",
                    projectVarName: "plinthPalette",
                    templates: "palette",
                    filter: "filterPalette",
                    parent: "plinthFasade",
                    function: "changePlinthFasade",
                    default: true,
                },
                tableDefault: {
                    name: "Тип столешницы",
                    clearElement: "clear_table",
                    data: "TABLES",
                    projectVarName: "table",
                    templates: "lineElement",
                    function: "changeTableTop",
                    default: true,
                },

                defaultHandle: {
                    name: "Тип ручек",
                    clearElement: "clear_hendles",
                    data: "HANDLES",
                    projectVarName: "handle",
                    templates: "lineElement",
                    function: "rebuildHandle",
                    default: true,
                },

                defaultFasadeup: {
                    name: "Цвет верхних фасадов",
                    clearElement: "clear_fasade",
                    data: "FASADE",
                    projectVarName: "default_fasade_up",
                    function: "changeFasade",
                    templates: "fasade",
                    default: true,
                },
                defaultFasadeMillingup: {
                    name: "Тип Фрезеровки верхних фасадов",
                    clearElement: "",
                    data: "MILLING",
                    projectVarName: "default_fasade_milling_up",
                    templates: "matrixElement",
                    function: "changeMilling",
                    parent: "default_fasade_up",
                    default: true,
                },
                defaultFasadePatinaup: {
                    name: "Тип патины верхних фасадов",
                    clearElement: "clear_patina",
                    data: "PATINA",
                    projectVarName: "default_fasade_patina_up",
                    templates: "matrixElement",
                    function: "changePatina",
                    default: true,
                },
                defaultFasadePaletteup: {
                    name: "Тип палитры верхних фасадов",
                    clearElement: "",
                    data: "PALETTE",
                    projectVarName: "default_fasade_palette_up",
                    templates: "palette",
                    filter: "filterPalette",
                    parent: "default_fasade_up",
                    function: "changePalette",
                    default: true,
                },

                defaultFasadedown: {
                    name: "Цвет нижних фасадов",
                    clearElement: "clear_fasade",
                    data: "FASADE",
                    projectVarName: "default_fasade_down",
                    templates: "fasade",
                    function: "changeFasade",
                    default: true,
                },
                defaultFasadeMillingdown: {
                    name: "Тип Фрезеровки нижних фасадов",
                    clearElement: "",
                    data: "MILLING",
                    projectVarName: "default_fasade_milling_down",
                    templates: "matrixElement",
                    parent: "default_fasade_down",
                    function: "changeMilling",
                    default: true,
                },
                defaultFasadePatinadown: {
                    name: "Тип патины нижних фасадов",
                    clearElement: "clear_patina",
                    data: "PATINA",
                    projectVarName: "default_fasade_patina_down",
                    templates: "matrixElement",
                    function: "changePatina",
                    default: true,
                },
                defaultFasadePalettedown: {
                    name: "Тип палитры нижних фасадов",
                    data: "PALETTE",
                    projectVarName: "default_fasade_palette_down",
                    templates: "palette",
                    filter: "filterPalette",
                    parent: "default_fasade_down",
                    function: "changePalette",
                    default: true,
                },
                defaultModuleColor: {
                    name: "Цвет корпуса по умолчанию",
                    data: "FASADE",
                    projectVarName: "default_module_color",
                    templates: "matrixGroupElement",
                    filter: "filterModuleColorID",
                    function: "changeModuleColor",
                    default: true,
                },
                elementModuleColor: {
                    name: "Цвет корпуса",
                    data: "FASADE",
                    templates: "matrixGroupElement",
                    filter: "filterModuleColorID",
                    function: "changeModuleColor",
                    default: false,
                },
                elementModuleColorPalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changeElementModuleColorPalette",
                    objectColor: "MODULECOLOR",
                    default: false,
                },
                hiTechProfileColor: {
                    name: "Цвет профиля",
                    data: "COLOR",
                    templates: "matrixElement",
                    filter: "filterProfileColorID",
                    function: "changeProfileColor",
                    default: false,
                },
                profileType: {
                    name: "Тип профиля",
                    data: "PRODUCT_TYPE",
                    templates: "matrixElement",
                    filter: "filterProfileTypeID",
                    function: "changeProfileType",
                    default: false,
                },
                elementBackModuleColor: {
                    name: "Цвет задней стенки",
                    data: "FASADE",
                    templates: "matrixGroupElement",
                    filter: "filterModuleColorID",
                    function: "changeBackModuleColor",
                    objectColor: "BACKWALL",
                    default: false,
                },
                elementBackModuleColorPalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changeBackModuleColorPalette",
                    objectColor: "BACKWALL",
                    default: false,
                },
                elementBackModuleColorMilling: {
                    name: "Тип фрезеровки",
                    data: "MILLING",
                    templates: "matrixElement",
                    filter: "filterMilling",
                    function: "changeBackModuleColorMilling",
                    objectColor: "BACKWALL",
                    default: false,
                },
                elementBackModuleColorPatina: {
                    name: "Тип патины",
                    data: "PATINA",
                    templates: "matrixElement",
                    filter: "filterPatina",
                    function: "changeBackModuleColorPatina",
                    objectColor: "BACKWALL",
                    default: false,
                },
                benchPartitionColor: {
                    name: "Цвет фасада",
                    data: "FASADE",
                    templates: "matrixGroupElement",
                    filter: "filterModuleColorID",
                    function: "changeBenchPartition",
                    objectColor: "BENCHPARTITION",
                    default: false,
                },
                benchPartitionColorPalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changeBenchPartitionColorPalette",
                    objectColor: "BENCHPARTITION",
                    default: false,
                },
                elementLeftModuleColor: {
                    name: "Цвет левой стенки",
                    data: "FASADE",
                    templates: "matrixGroupElement", //"matrixElementLeft",
                    filter: "filterModuleColorID",
                    function: "changeLeftModuleColor",
                    objectColor: "LEFTSIDECOLOR",
                    default: false,
                },
                elementLeftModuleColorMilling: {
                    name: "Тип фрезеровки",
                    data: "MILLING",
                    templates: "matrixElement",
                    filter: "filterMilling",
                    function: "changeLeftModuleColorMilling",
                    objectColor: "LEFTSIDECOLOR",
                    default: false,
                },
                elementLeftModuleColorPalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changeLeftModuleColorPalette",
                    objectColor: "LEFTSIDECOLOR",
                    default: false,
                },
                elementLeftModuleColorPatina: {
                    name: "Тип патины",
                    data: "PATINA",
                    templates: "matrixElement",
                    filter: "filterPatina",
                    function: "changeLeftModuleColorPatina",
                    objectColor: "LEFTSIDECOLOR",
                    default: false,
                },
                elementRightModuleColor: {
                    name: "Цвет правой стенки",
                    data: "FASADE",
                    templates: "matrixGroupElement", //"matrixElementRight",
                    filter: "filterModuleColorID",
                    function: "changeRightModuleColor",
                    objectColor: "RIGHTSIDECOLOR",
                    default: false,
                },
                elementRightModuleColorMilling: {
                    name: "Тип фрезеровки",
                    data: "MILLING",
                    templates: "matrixElement",
                    filter: "filterMilling",
                    function: "changeRightModuleColorMilling",
                    objectColor: "RIGHTSIDECOLOR",
                    default: false,
                },
                elementRightModuleColorPalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changeRightModuleColorPalette",
                    objectColor: "RIGHTSIDECOLOR",
                    default: false,
                },
                elementRightModuleColorPatina: {
                    name: "Тип патины",
                    data: "PATINA",
                    templates: "matrixElement",
                    filter: "filterPatina",
                    function: "changeRightModuleColorPatina",
                    objectColor: "RIGHTSIDECOLOR",
                    default: false,
                },
                elementFasade: {
                    name: "Цвет фасада",
                    data: "FASADE",
                    templates: "fasade",
                    function: "changeFasade",
                    default: false,
                },
                elementFasadeMilling: {
                    name: "Тип фрезеровки",
                    data: "MILLING",
                    templates: "matrixElement",
                    filter: "filterMilling",
                    function: "changeMilling",
                    default: false,
                },
                elementFasadeType: {
                    name: "Тип фасада",
                    data: "FASADETYPE",
                    templates: "matrixElement",
                    filter: "filterFasadeType",
                    function: "changeFasadeType",
                    default: false,
                },
                fasadeLoopSide: {
                    name: "Сторона петель",
                    data: "LOOPSIDE",
                    templates: "matrixElement",
                    filter: "filterLoopSide",
                    function: "changeLoopSide",
                    default: false,
                },
                elementFasadePalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changePalette",
                    default: false,
                },
                elementFasadePatina: {
                    name: "Тип патины",
                    data: "PATINA",
                    templates: "matrixElement",
                    filter: "filterPatina",
                    function: "changePatina",
                    default: false,
                },
                elementFasadeGlass: {
                    name: "Тип стекла",
                    data: "GLASS",
                    templates: "matrixElement",
                    filter: "DefaultGlassFilter",
                    function: "changeGlass",
                    default: false,
                },
                elementFasadeShowCase: {
                    name: "Тип витрины",
                    data: "SHOWCASE",
                    templates: "matrixElement",
                    filter: "filterShowcase",
                    function: "changeShowcase",
                    default: false,
                },
                elementFasadeHandle: {
                    name: "Тип ручек",
                    clearElement: "clear_hendles",
                    data: "HANDLES",
                    templates: "lineElement",
                    function: "changeHandle",
                    default: false,
                },
                elementSlideDoorHandle: {
                    name: "Тип ручек",
                    clearElement: "clear_hendles",
                    data: "HANDLES",
                    templates: "lineElement",
                    function: "changeHandle",
                    default: false,
                },
                elementHem: {
                    name: "Тип кромки",
                    clearElement: false,
                    data: "HEM",
                    templates: "matrixHemElement",
                    function: "setElementHem",
                    default: false,
                },
                elementColor: {
                    name: "Цвет",
                    clearElement: false,
                    data: "COLOR",
                    templates: "matrixElement",
                    filter: "filterColor",
                    function: "changeColor",
                    default: false,
                },
                elementTopFasadeColor: {
                    name: "Цвет накладки на крышку модуля",
                    data: "FASADE",
                    templates: "matrixGroupElement",
                    filter: "filterModuleColorID",
                    function: "changeTopFasadeColor",
                    objectColor: "TOPFASADECOLOR",
                    default: false,
                },
                elementTopFasadeColorPalette: {
                    name: "Тип палитры",
                    data: "PALETTE",
                    templates: "palette",
                    filter: "filterPalette",
                    function: "changeTopFasadeColorPalette",
                    objectColor: "TOPFASADECOLOR",
                    default: false,
                },
                elementTopFasadeModuleColorMilling: {
                    name: "Тип фрезеровки",
                    data: "MILLING",
                    templates: "matrixElement",
                    filter: "filterMilling",
                    function: "changeTopFasadeModuleColorMilling",
                    objectColor: "TOPFASADECOLOR",
                    default: false,
                },
                elementTopFasadeModuleColorPatina: {
                    name: "Тип патины",
                    data: "PATINA",
                    templates: "matrixElement",
                    filter: "filterPatina",
                    function: "changeTopFasadeModuleColorPatina",
                    objectColor: "TOPFASADECOLOR",
                    default: false,
                },
            },
            rayElements: [],
            configElementFilling: false,
            rotationSnap: 0,
            optionsTabName: false,
            transformMode: false,
            wraps: [],
            elements: [],
            elementsObj: {},
            room: [],
            roomIDS: [],
            tableLenght: 0,
            plinthLenght: 0,
            selected: false,
            activeTab: false,
            activeSubTab: false,
            Lines: {x: false, y: false, z: false},
            newElement: false,
            projectf: {
                user_hash: false,
                name: "",
                id: "",
            },
            saveImg: {},
            projectsAllList: false,
            newDragElement: false,
            delete: false,
            basket: {},
            balance: {},
            basketFrame: [],
            basketFrameOther: [],
            basketFrameError: [],
            basketFramePropError: [],
            basketCount: 0,
            new_model: false,
            is_load: false,
            hideFrames: false,
            block_cart: false,
            errors: {},
            user: {},
            default_module_color_list: [],
            default_module_options_list: {},
            default_module_color_btn: "up",
            default_fasade_color_btn: "up",
            newSubelemPos: {},
            new_size: {
                width: 0,
                height: 0,
                depth: 0,
            },
            propsLabel: {
                COLOR: {type: "COLOR", val: "int", NAME: "Цвет", SORT: 300},
                MODULECOLOR: {type: "FASADE", val: "int", NAME: "Цвет корпуса", SORT: 300},
                SIZE: {type: "SIZE", val: "int", NAME: "Размер", SORT: 400},
                THICKNESS: {type: "THICKNESS", val: "int", NAME: "Толщина", SORT: 500},
                OPTION: {type: "OPTION", val: "array", NAME: "Опции", SORT: 600},
                SIZEEDITHEIGHT: {type: false, val: "int", NAME: "Высота", SORT: 800},
                SIZEEDITDEPTH: {type: false, val: "int", NAME: "Глубина", SORT: 800},
                SIZEEDITWIDTH: {type: false, val: "int", NAME: "Ширина", SORT: 800},
                HEM: {type: "HEM", val: "int", NAME: "Кромка", SORT: 900},
                SHELFQUANT: {type: false, val: "int", NAME: "Количество полок", SORT: 900},
                SIZEEDITJOINDEPTH: {
                    type: false,
                    val: "int",
                    NAME: "Глубина пристыковочного модуля",
                    SORT: 1000,
                },
                BACKWALL: {type: "FASADE", val: "color_obj_list", NAME: "Задняя стенка", SORT: 100},
                LEFTSIDECOLOR: {type: "FASADE", val: "color_obj_list", NAME: "Левая стенка", SORT: 100},
                RIGHTSIDECOLOR: {type: "FASADE", val: "color_obj_list", NAME: "Правая стенка", SORT: 100},
                TOPFASADECOLOR: {type: "FASADE", val: "color_obj_list", NAME: "Накладка на крышку", SORT: 100},

                DOORS: {type: "FASADE", val: "obj_list", NAME: "Двери", SORT: 100},
                FACADE: {type: "FASADE", val: "int", NAME: "Цвет фасада", SORT: 100},
                FASADE1: {type: "FASADE", val: "int", NAME: "Цвет фасада 1", SORT: 1000},
                FASADE2: {type: "FASADE", val: "int", NAME: "Цвет фасада 2", SORT: 1100},
                FASADE3: {type: "FASADE", val: "int", NAME: "Цвет фасада 3", SORT: 1200},
                FASADE4: {type: "FASADE", val: "int", NAME: "Цвет фасада 4", SORT: 1300},
                FASADE5: {type: "FASADE", val: "int", NAME: "Цвет фасада 5", SORT: 1300},

                FASADEWIDTH: {type: false, val: "int", NAME: "Ширина фасада", SORT: 1360},
                FASADESIZE: {type: "FASADESIZE", val: "int", NAME: "Высота фасада", SORT: 1350},
                FASADESIZE1: {
                    type: "FASADESIZE",
                    val: "int",
                    NAME: "Размер фасада 1",
                    SORT: 1350,
                },
                FASADESIZE2: {
                    type: "FASADESIZE",
                    val: "int",
                    NAME: "Размер фасада 2",
                    SORT: 1350,
                },
                FASADESIZE3: {
                    type: "FASADESIZE",
                    val: "int",
                    NAME: "Размер фасада 3",
                    SORT: 1350,
                },
                FASADESIZE4: {
                    type: "FASADESIZE",
                    val: "int",
                    NAME: "Размер фасада 4",
                    SORT: 1350,
                },
                FASADESIZE5: {
                    type: "FASADESIZE",
                    val: "int",
                    NAME: "Размер фасада 5",
                    SORT: 1350,
                },

                FASADESIZEWIDTH1: {
                    type: false,
                    val: "int",
                    NAME: "Ширина фасада 1",
                    SORT: 1350,
                },
                FASADESIZEWIDTH2: {
                    type: false,
                    val: "int",
                    NAME: "Ширина фасада 2",
                    SORT: 1350,
                },
                FASADESIZEWIDTH3: {
                    type: false,
                    val: "int",
                    NAME: "Ширина фасада 3",
                    SORT: 1350,
                },
                FASADESIZEWIDTH4: {
                    type: false,
                    val: "int",
                    NAME: "Ширина фасада 4",
                    SORT: 1350,
                },
                FASADESIZEWIDTH5: {
                    type: false,
                    val: "int",
                    NAME: "Ширина фасада 5",
                    SORT: 1350,
                },

                GLASS: {type: "GLASS", val: "int", NAME: "Стекло", SORT: 700},
                GLASS1: {type: "GLASS", val: "int", NAME: "Стекло 1", SORT: 1400},
                GLASS2: {type: "GLASS", val: "int", NAME: "Стекло 2", SORT: 1500},
                GLASS3: {type: "GLASS", val: "int", NAME: "Стекло 3", SORT: 1600},
                GLASS4: {type: "GLASS", val: "int", NAME: "Стекло 4", SORT: 1700},
                GLASS5: {type: "GLASS", val: "int", NAME: "Стекло 5", SORT: 1700},

                PATINA: {type: "PATINA", val: "int", NAME: "Патина", SORT: 1800},
                PATINA1: {type: "PATINA", val: "int", NAME: "Патина 1", SORT: 1800},
                PATINA2: {type: "PATINA", val: "int", NAME: "Патина 2", SORT: 1800},
                PATINA3: {type: "PATINA", val: "int", NAME: "Патина 3", SORT: 1800},
                PATINA4: {type: "PATINA", val: "int", NAME: "Патина 4", SORT: 1800},
                PATINA5: {type: "PATINA", val: "int", NAME: "Патина 5", SORT: 1800},

                SHOWCASE: {type: "SHOWCASE", val: "int", NAME: "Тип витрины", SORT: 1800},
                SHOWCASE1: {type: "SHOWCASE", val: "int", NAME: "Тип витрины 1", SORT: 1800},
                SHOWCASE2: {type: "SHOWCASE", val: "int", NAME: "Тип витрины 2", SORT: 1800},
                SHOWCASE3: {type: "SHOWCASE", val: "int", NAME: "Тип витрины 3", SORT: 1800},
                SHOWCASE4: {type: "SHOWCASE", val: "int", NAME: "Тип витрины 4", SORT: 1800},
                SHOWCASE5: {type: "SHOWCASE", val: "int", NAME: "Тип витрины 5", SORT: 1800},

                PALETTE: {type: "PALETTE", val: "int", NAME: "Палитра", SORT: 1800},
                PALETTE1: {type: "PALETTE", val: "int", NAME: "Палитра 1", SORT: 1800},
                PALETTE2: {type: "PALETTE", val: "int", NAME: "Палитра 2", SORT: 1800},
                PALETTE3: {type: "PALETTE", val: "int", NAME: "Палитра 3", SORT: 1800},
                PALETTE4: {type: "PALETTE", val: "int", NAME: "Палитра 4", SORT: 1800},
                PALETTE5: {type: "PALETTE", val: "int", NAME: "Палитра 5", SORT: 1800},

                FASADEALIGN: {
                    type: "FASADEALIGN",
                    val: "list",
                    NAME: "Сторона открывания",
                    SORT: 1800,
                    VALUE: {left: "Левая", right: "Правая"},
                },
                FASADEALIGN1: {
                    type: "FASADEALIGN",
                    val: "list",
                    NAME: "Сторона открывания 1",
                    SORT: 1800,
                },
                FASADEALIGN2: {
                    type: "FASADEALIGN",
                    val: "list",
                    NAME: "Сторона открывания 2",
                    SORT: 1800,
                },
                FASADEALIGN3: {
                    type: "FASADEALIGN",
                    val: "list",
                    NAME: "Сторона открывания 3",
                    SORT: 1800,
                },
                FASADEALIGN4: {
                    type: "FASADEALIGN",
                    val: "list",
                    NAME: "Сторона открывания 4",
                    SORT: 1800,
                },
                FASADEALIGN5: {
                    type: "FASADEALIGN",
                    val: "list",
                    NAME: "Сторона открывания 5",
                    SORT: 1800,
                },

                FASADEFIRST: {
                    type: "FASADEFIRST",
                    val: "list",
                    NAME: "Передний фасад",
                    SORT: 1800,
                    VALUE: {left: "Левый", right: "Правый"},
                },

                MILLING: {type: "MILLING", val: "int", NAME: "Фрезеровка", SORT: 200},
                MILLING1: {type: "MILLING", val: "int", NAME: "Фрезеровка 1", SORT: 1800},
                MILLING2: {type: "MILLING", val: "int", NAME: "Фрезеровка 2", SORT: 1900},
                MILLING3: {type: "MILLING", val: "int", NAME: "Фрезеровка 3", SORT: 2000},
                MILLING4: {type: "MILLING", val: "int", NAME: "Фрезеровка 4", SORT: 2100},
                MILLING5: {type: "MILLING", val: "int", NAME: "Фрезеровка 5", SORT: 2100},

                USLUGI: {type: "USLUGI", val: "array", NAME: "Услуга", SORT: 2110},
                USLUGIL: {type: "USLUGI", val: "array", NAME: "Услуга левая часть", SORT: 2120},
                USLUGIR: {
                    type: "USLUGI",
                    val: "array",
                    NAME: "Услуга правая часть",
                    SORT: 2130,
                },
                USLUGI1: {type: "USLUGI", val: "array", NAME: "Услуга 1", SORT: 2201},
                USLUGI2: {type: "USLUGI", val: "array", NAME: "Услуга 2", SORT: 2202},
                USLUGI3: {type: "USLUGI", val: "array", NAME: "Услуга 3", SORT: 2203},
                USLUGI4: {type: "USLUGI", val: "array", NAME: "Услуга 4", SORT: 2204},
                USLUGI5: {type: "USLUGI", val: "array", NAME: "Услуга 5", SORT: 2205},

                USLUGIraspil: {type: false, val: "str", NAME: "Распил", SORT: 2300},

                PROFILE: {type: "USLUGI", val: "int", NAME: "Тип завала", SORT: 2200},
                FILLING: {type: "FILLING", val: "int", NAME: "Вариант компоновки", SORT: 2400},

                FASADETYPE: {type: "FASADETYPE", val: "int", NAME: "Тип фасада", SORT: 2500},
                FASADETYPE1: {type: "FASADETYPE", val: "int", NAME: "Тип фасада 1", SORT: 2510},
                FASADETYPE2: {type: "FASADETYPE", val: "int", NAME: "Тип фасада 2", SORT: 2520},
                FASADETYPE3: {type: "FASADETYPE", val: "int", NAME: "Тип фасада 3", SORT: 2530},
                FASADETYPE4: {type: "FASADETYPE", val: "int", NAME: "Тип фасада 4", SORT: 2540},
                FASADETYPE5: {type: "FASADETYPE", val: "int", NAME: "Тип фасада 5", SORT: 2550},

                //SECTIONS: {type: "SECTIONS", val: "int", NAME: "Количество секций", SORT: 2550},
                SECTIONS: {type: false, val: "int", NAME: "Размер секции", SORT: 2550},
                SECTIONS1: {type: false, val: "int", NAME: "Размер секции 1", SORT: 2550},
                SECTIONS2: {type: false, val: "int", NAME: "Размер секции 2", SORT: 2550},
                SECTIONS3: {type: false, val: "int", NAME: "Размер секции 3", SORT: 2550},
                SECTIONS4: {type: false, val: "int", NAME: "Размер секции 4", SORT: 2550},
                SECTIONS5: {type: false, val: "int", NAME: "Размер секции 5", SORT: 2550},
                SECTIONS6: {type: false, val: "int", NAME: "Размер секции 6", SORT: 2550},
                SECTIONS7: {type: false, val: "int", NAME: "Размер секции 7", SORT: 2550},
                SECTIONS8: {type: false, val: "int", NAME: "Размер секции 8", SORT: 2550},
                SECTIONS9: {type: false, val: "int", NAME: "Размер секции 9", SORT: 2550},
                SECTIONS10: {type: false, val: "int", NAME: "Размер секции 10", SORT: 2550},

                SHELFPOSITION: {type: false, val: "int", NAME: "Позиции полок", SORT: 2550},
                SHELFPOSITION1: {type: false, val: "int", NAME: "Позиции полок 1", SORT: 2550},
                SHELFPOSITION2: {type: false, val: "int", NAME: "Позиции полок 2", SORT: 2550},
                SHELFPOSITION3: {type: false, val: "int", NAME: "Позиции полок 3", SORT: 2550},
                SHELFPOSITION4: {type: false, val: "int", NAME: "Позиции полок 4", SORT: 2550},
                SHELFPOSITION5: {type: false, val: "int", NAME: "Позиции полок 5", SORT: 2550},
                SHELFPOSITION6: {type: false, val: "int", NAME: "Позиции полок 6", SORT: 2550},
                SHELFPOSITION7: {type: false, val: "int", NAME: "Позиции полок 7", SORT: 2550},
                SHELFPOSITION8: {type: false, val: "int", NAME: "Позиции полок 8", SORT: 2550},
                SHELFPOSITION9: {type: false, val: "int", NAME: "Позиции полок 9", SORT: 2550},
                SHELFPOSITION10: {
                    type: false,
                    val: "int",
                    NAME: "Позиции полок 10 ",
                    SORT: 2550,
                },

                SECTIONSFILLING: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции",
                    SORT: 2550,
                },
                SECTIONSFILLING1: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 1",
                    SORT: 2550,
                },
                SECTIONSFILLING2: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 2",
                    SORT: 2550,
                },
                SECTIONSFILLING3: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 3",
                    SORT: 2550,
                },
                SECTIONSFILLING4: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 4",
                    SORT: 2550,
                },
                SECTIONSFILLING5: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 5",
                    SORT: 2550,
                },
                SECTIONSFILLING6: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 6",
                    SORT: 2550,
                },
                SECTIONSFILLING7: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 7",
                    SORT: 2550,
                },
                SECTIONSFILLING8: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 8",
                    SORT: 2550,
                },
                SECTIONSFILLING9: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 9",
                    SORT: 2550,
                },
                SECTIONSFILLING10: {
                    type: "PRODUCTS",
                    val: "int",
                    NAME: "Наполнение секции 10",
                    SORT: 2550,
                },
                MECHANISM: {
                    type: "MECHANISM",
                    val: "int",
                    NAME: "Подъемный механизм",
                    SORT: 2560,
                },
            },
            projectList: [],
            projectListPage: 1,
            raspilactive: false,
            raspilactivePos: 0,
            raspilactivePosOld: 0,
            sizeLabel: {
                width: "WIDTH",
                height: "HEIGHT",
                depth: "DEPTH",
            },
            showNavStok: false,
            constants: {
                noFasad: 7397,
                deg_to_rad_coefficient: Math.PI / 180,
                rad_to_deg_coefficient: 180 / Math.PI,
                forHem: {
                    kromka_torec: "182294",
                    kromka_perimetr: "182295",
                    kromka_tri_storony: "182816",
                    kromka_right: '3966035',
                    kromka_left: '3966036',
                },
                gugol: "251701",
                deletedMillings: {
                    1617660: {
                        oldName: 'Мюнхен',
                        newName: 'Мюнхен 20мм',
                        newId: 4288260,
                    },
                    3971689: {
                        oldName: 'Мюнхен с импостом',
                        newName: 'Мюнхен 20мм с импостом',
                        newId: 4288261,
                    },
                    1617734: {
                        oldName: 'Дрезден',
                        newName: 'Дрезден 20мм',
                        newId: 4288258,
                    },
                    3971698: {
                        oldName: 'Дрезден с импостом',
                        newName: 'Дрезден 20мм с импостом',
                        newId: 4288259,
                    },
                    1617661: {
                        oldName: 'Кельн',
                        newName: 'Кельн 20мм',
                        newId: 4288256,
                    },
                    2503151: {
                        oldName: 'Кельн',
                        newName: 'Кельн 20мм',
                        newId: 4288408,
                    },
                    2503152: {
                        oldName: 'Дрезден',
                        newName: 'Дрезден 20мм',
                        newId: 4288410,
                    },
                    3971897: {
                        oldName: 'Дрезден с импостом',
                        newName: 'Дрезден 20мм с импостом',
                        newId: 4288409,
                    },
                    2503150: {
                        oldName: 'Мюнхен',
                        newName: 'Мюнхен 20мм',
                        newId: 4288412,
                    },
                    3971894: {
                        oldName: 'Мюнхен с импостом',
                        newName: 'Мюнхен 20мм с импостом',
                        newId: 4288411,
                    },

                },
                support_options: {
                    metallreg: '4621257', //Опора регулируемая метал. d38, h30, до 150 кг. CAMAR
                    plactick100: '4621238', //Опора пластиковая 100мм
                    plactick150: '4621240', //Опора пластиковая 150мм
                },
                loop_sides: {
                    left: 3077513,
                    right: 3077514,
                },

            }
        };

        self.scope.confirm = {
            question: "",
            title: "",
            btnOk: "",
            btnNo: "",
            funcOk: function () {
            },
            funcNo: function () {
            },
        };

        self.EDGES = {};

        /*Получаем информацию с сервера*/
        angular.element(document).ready(function () {
            self.scope.TEMPLATE_PATH = self.scope.app.config.TEMPLATE_PATH;

            self.scope.setDefaultDesigner();

            self.getData($scope, $http, function () {
                self.start();

                self.initDomEvent();

                self.initBind();

                self.ControlLoadProject();

                self.scope.app.is_load = true;

                self.render();
            });
        });
    };

    this.filterShowcase = function () {
        return function (items, criteria) {
            let list = [];
            let props =
                criteria && criteria.group != undefined
                    ? criteria.group.PROPS
                    : self.scope.app.active.PROPS;
            let product = props.PRODUCT;
            let fasade_number =
                criteria && criteria.FASADE_NUMBER != undefined
                    ? criteria.FASADE_NUMBER
                    : self.scope.app.active_fasade;
            let fasade_position =
                self.scope.app.FASADE_POSITION[props.CONFIG.FASADELIST[fasade_number]];

            const segment = self.scope.app.active_fasade_segment || "0"


            let fasade = props.CONFIG.BASKET.DOORS?.[fasade_number]?.[segment] || props.CONFIG.BASKET["FASADE" + fasade_number]?.[segment] || props.CONFIG.BASKET["FASADE" + fasade_number];
            let glass = props.CONFIG.BASKET["GLASS" + fasade_number]?.[segment] || props.CONFIG.BASKET["GLASS" + fasade_number];
            let milling = props.CONFIG.BASKET["MILLING" + fasade_number]?.[segment] || props.CONFIG.BASKET["MILLING" + fasade_number];

            if (glass && milling && fasade && fasade_position.glass && product.type_showcase) {
                let fasadeObject = self.scope.app.FASADE[fasade];
                let millingObject = self.scope.app.MILLING[milling];

                angular.forEach(items, function (showcase, showcaseId) {
                    let id = parseInt(showcaseId);
                    if (
                        product.type_showcase.indexOf(id) != -1 &&
                        (fasadeObject.type_showcase.indexOf(id) != -1 ||
                            millingObject.type_showcase.indexOf(id) != -1)
                    ) {
                        list.push(showcase);
                    }
                });
            }

            return list.sort(function (a, b) {
                return a.SORT - b.SORT;
            });
        };
    };
    this.changeShowcase = function (news) {
        if (news) {
            const segment = +self.scope.app.active_fasade_segment || "0" //Часть составного фасада

            const fasadeSegments = self.scope.app.active.PROPS.CONFIG.BASKET.DOORS?.[self.scope.app.active_fasade] ||
                self.scope.app.active.PROPS.CONFIG.BASKET['FASADE' + self.scope.app.active_fasade]

            if (segment !== undefined) {
                self.scope.app.active.PROPS.CONFIG.BASKET["SHOWCASE" + self.scope.app.active_fasade][segment] = news;
                self.changeFasade(self.scope.app.active, fasadeSegments[segment]);
            } else {
                self.scope.app.active.PROPS.CONFIG.BASKET["SHOWCASE" + self.scope.app.active_fasade] = news;
                self.changeFasade(self.scope.app.active, fasadeSegments);
            }

        }
    };

    this.ControlLoadProject = function () {
        if (localStorage["project" + self.scope.app.config.dataProvider]) {
            var project = JSON.parse(
                localStorage["project" + self.scope.app.config.dataProvider]
            );

            if (Object.keys(project.items).length) {
                if (project.autoload) {
                    if (project.time < self.getTime() - 259200000) self.showStartWindow();
                    else self.loadProject(project);
                } else if (self.scope.app.config.projectid) {
                    self.getProject(parseInt(self.scope.app.config.projectid));
                } else if (self.scope.app.config.autoload) {
                    if (project.time < self.getTime() - 259200000) self.showStartWindow();
                    else self.loadProject(project);
                } else {
                    var text = $("<div>", {text: "Найдено автосохранение проекта "}).append(
                        $("<a>", {
                            text: "Загрузить",
                            class: "btn btn-success btn-xs",
                        })
                    );
                    self.alert(text, "info", {
                        timeOut: "0",
                        extendedTimeOut: "3000",
                        onclick: function () {
                            self.loadProject(project);
                        },
                    });
                    self.showStartWindow();
                }
            } else if (self.scope.app.config.projectid) {
                self.getProject(parseInt(self.scope.app.config.projectid));
            } else {
                self.showStartWindow();
            }
        } else if (self.scope.app.config.projectid) {
            self.getProject(parseInt(self.scope.app.config.projectid));
        } else {
            self.showStartWindow();
        }
    };

    this.showStartWindow = function () {
        if (self.scope.app.config.show_start_window) {
            //console.log("Show Start Window");
        }
    };

    this.ActionMenu = function (menu) {


        if (
            (
                self.scope.deal.techProject == '1' &&
                self.scope.app.userGroup[56] === undefined
            ) &&
            (
                self.scope.deal.dealStatus != 'C10:3' &&
                self.scope.deal.dealStatus != 'C10:PREPAYMENT_INVOIC' &&
                self.scope.deal.dealStatus != 'C10:1'
            )
        ) {
            if (
                menu == 'sub_project_settings' ||
                menu == 'sub_catalog' ||
                menu == 'sub_room_settings' ||
                menu == 'OpenSaveModal' ||
                menu == 'getNewProject'
            ) {
                self.alert("Меню запрещено, это проект технолога");
                return false;
            }
        }


        let rootMenu = self.scope.app.Menu[menu];

        if (self.scope.app.SETTINGS.no_auth.VALUE == 1 && menu == "Auth") {
            self.alert("Авторизация недоступна");
            return false;
        }
        if (self.scope.app.SETTINGS.no_save.VALUE == 1 && menu == "OpenSaveModal") {
            self.alert("Сохранение недоступно");
            return false;
        }

        if (self.scope.app.configElementFilling) {
            self.alert("Включен режим настройки наполнения, переход в раздел не возможен");
        } else {
            if (rootMenu.type == "tab") {
                self.scope.app.activeTab = self.scope.app.activeTab == menu ? false : menu;

                if (self.scope.app.activeTab === "sub_project_settings")
                    self.unmarkSelected();

                self.hideOptionsTab();
            } else if (rootMenu.type == "modal") {
                $(menu).modal();
            } else if (rootMenu.type == "func") {
                if (typeof self[menu] === "function") {
                    self[menu]();
                } else {
                    self[menu]();
                    self.alert("Опционал в разработке");
                }
            }

            if (rootMenu.return == "") return false;
        }
    };

    this.initDomEvent = function () {
        /*Нажатия клавиш*/
        self.initKeyPres();

        /************** Меню конструктора ****************/
        $(document)
            .on(self.mouseup, function (e) {
                self.scope.camPosition = false;
                self.autoSave();
                if (self.scope.app.raspilactive !== false) {
                    self.scope.app.raspilactive = false;
                    self.scope.app.raspilactivePos = 0;
                    self.scope.app.raspilactivePosOld = 0;
                    self.scope.$applyAsync();
                }
            })
            .on(self.mousedown, ".product_element", function (e) {
                e.preventDefault();
                self.scope.app.newElement = self.getProductInfo($(this).data("id"));
                self.calcRayElement();
                self.scope.$applyAsync();
            })
            .on(self.mouseup, "#left_panel", function (e) {
                //console.log('#left_panel')
                self.scope.app.newElement = false;
                self.scope.$applyAsync();
            })
            .on(self.mousemove, self.onMouseMove)
            .on("click", ".filling_element .badge, .sections_element .badge", function () {
                var img = $(this).data("href");
                $.fancybox({
                    href: img,
                    maxHeight: "100%",
                });
            })
            .on("mousedown", ".raspilMarker, .raspilMarkerLabel", function (e) {
                e.preventDefault();
                self.scope.app.raspilactive = $(e.target).data("id");
                self.scope.app.raspilactivePos = e.clientX;
                self.scope.app.raspilactivePosOld =
                    self.scope.app.active.PROPS.RASPILLIST[self.scope.app.raspilactive];
                self.scope.$applyAsync();
                return false;
            });
    };

    this.calcRayElement = function () {
        self.scope.app.rayElements = self.scope.app.room.filter(function (i) {
            if (
                (i.PARENT == undefined ||
                    (self.scope.app.selected !== false &&
                        i.PARENT != self.scope.app.selected.object.parent.id)) &&
                !(
                    i.PARENT != undefined &&
                    self.scope.app.elementsObj[i.PARENT].PROPS.CONFIG.DISABLE_RAYCAST
                )
            ) {
                return true;
            }
        });
    };

    this.initKeyPres = function () {

        /*Запретил нажатие клавишь в настройках стилей в админке*/
        if (self.scope.app.SETTINGS.block_key == 1) return false;

        /*keylistener события нажатия кловиш*/
        this.keylistener = new window.keypress.Listener();

        self.keylistener.simple_combo("ctrl b", function (e) {
            self.deleteElement(e);
        });

        self.keylistener.simple_combo("ctrl s", function (e) {
            e.preventDefault();
            self.OpenSaveModal();
            return false;
        });

        self.keylistener.simple_combo("ctrl c", function (e) {
            e.preventDefault();
            self.copyElement();
            return false;
        });

        self.keylistener.simple_combo("ctrl p", function (e) {
            e.preventDefault();
            self.Print();
            return false;
        });

        self.keylistener.simple_combo("f1", function (e) {
            e.preventDefault();
            self.showHelp();
            return false;
        });

        self.keylistener.simple_combo("esc", function (e) {
            if (!$(".modal:visible").length) {
                self.scope.app.activeTab = false;
                self.unmarkSelected();
            }
        });

        self.keylistener.simple_combo("f11", function (e) {
            e.preventDefault();
            self.fullScreen();
            return false;
        });

        self.keylistener.simple_combo("ctrl o", function (e) {
            e.preventDefault();
            self.OpenProjects();
            return false;
        });

        self.keylistener.simple_combo("f2", function (e) {
            e.preventDefault();
            self.rebuildRoomLineOut();
            return false;
        });
    };

    this.Print = function () {
        self.scope.app.is_load = false;
        self.scope.$applyAsync();
        //self.goBasePosition();

        self.autoSave(function () {
            self.getBasket(function () {
                self.getPringImage(function () {
                    self.scope.app.is_load = true;
                    self.scope.$applyAsync();
                    setTimeout(function () {
                        toastr.clear();
                        window.print();
                    }, 6000);
                });
            });
        });
    };

    this.getPringImage = function (callback) {
        self.scope.app.saveImg[self.scope.outlineType ? "ItemOutLine" : "ItemModel"] =
            self.downloadCanvas(true);

        $(self.scope.outlineType ? ".screanProjectItemOutLine" : ".screanProjectItem").attr(
            "src",
            self.scope.app.saveImg[self.scope.outlineType ? "ItemOutLine" : "ItemModel"]
        );

        self.rebuildRoomLineOut(function () {
            setTimeout(function () {
                self.scope.app.saveImg[self.scope.outlineType ? "ItemOutLine" : "ItemModel"] =
                    self.downloadCanvas(true);
                $(
                    self.scope.outlineType ? ".screanProjectItemOutLine" : ".screanProjectItem"
                ).attr(
                    "src",
                    self.scope.app.saveImg[self.scope.outlineType ? "ItemOutLine" : "ItemModel"]
                );

                setTimeout(function () {
                    self.rebuildRoomLineOut(false, !self.scope.outlineType);
                    callback();
                }, 500)
            }, 2000);
        }, !self.scope.outlineType);
    };

    this.showHelp = function () {
        if (!self.scope.help)
            $.ajax({
                type: "GET",
                url: self.scope.TEMPLATE_PATH + "/API/data.help.php",
                dataType: "HTML",
                data: {config: self.scope.app.config.config},
                success: function (data, s) {
                    self.scope.help = data;
                    self.scope.$applyAsync();
                    $("#help").modal();
                },
            });
        else $("#help").modal({keyboard: false, backdrop: "static", handleUpdate: true});
    };

    
    this.getNewProject = function () {
        $("#newProject").modal({keyboard: false, backdrop: "static", handleUpdate: true});
    };
    
    this.sub_main = function () {
        window.location.href = "file://" + nw.__dirname + "/index.html";
    };

    this.createNewProject = function () {
        localStorage.removeItem("project" + self.scope.app.config.dataProvider);
        window.location = self.scope.app.config.dir;
    };

    this.DeleteProject = function (id) {
        self.confirm(
            "Удалить",
            "Отмена",
            "Вы действительно хотите удалить проект №" + id + "?",
            function () {
                $.ajax({
                    type: "POST",
                    url: self.scope.TEMPLATE_PATH + "/API/data.project.php",
                    data: {type: "DeleteProject", data: id},
                    cache: false,
                    success: function (data, s) {
                        if (data.type == "success") {
                            self.getProjectListData();
                        } else {
                            self.alert(data.data, "error");
                        }
                        self.scope.$applyAsync();
                    },
                });
            }
        );
    };

    this.searchSizeFasade = function (productID, type, numberFasade, segment, door) {

        const group = self.scope.app.active
        self.scope.app.block_cart = true

        if (segment == undefined || segment == false) segment = 0;

        let boxFasadeSize = self.checkBoxIsFasade(group, numberFasade, segment, door)
        if (boxFasadeSize) {
            let standartSectionFasadePosition = this.getFasadePosition(group, numberFasade)
            boxFasadeSize = {width: standartSectionFasadePosition.FASADE_WIDTH, height: boxFasadeSize.SIZE}
        }

        self.scope.$applyAsync();
        $.ajax({
            url: '/api/constructor/checkfasadesize/search/',
            method: 'post',
            dataType: 'json',
            contentType: "application/json",
            data: JSON.stringify({
                id: productID,
                type: type,
                numberFasade: numberFasade,
                width: self.scope.app.new_size.width,
                height: self.scope.app.new_size.height,
                fasadePosition: group.PROPS.CONFIG.FASADELIST[numberFasade]?.[door] || group.PROPS.CONFIG.FASADELIST[numberFasade],
                basket: group.PROPS.CONFIG.BASKET,
                segment: segment,
                door: door || false,
                boxFasadeSize: boxFasadeSize ? boxFasadeSize : false,
            }),
            success: function (data) {

                let result = data.DATA;

                if (result.type == "success") {
                    self.scope.app.sizeMinMaxFasade = result.data;
                } else {
                    //self.alert(data.data, 'error');
                }
                //Муртазин Э. 25.10.23 обновляет данные для корзины
                self.getBasket();

                self.scope.app.block_cart = false
                self.scope.$applyAsync();
            }
        });
    };


    this.showFasadeParam = function (type, FASADE_NUMBER, door_key = false, segment_key = false) {
        //Section key == 'string'. Может быть либо undefined || string || false
        //Например "0", '1', '2'....
        //!!! Проверить, стоит ли сегмент сделать по дефолту 0
        self.searchSizeFasade(self.scope.app.active.PROPS.PRODUCT.ID, type, FASADE_NUMBER, segment_key, door_key);
        if (!(self.scope.app.active_fasade != FASADE_NUMBER &&
            self.scope.app.optionsTabName == type)) {
            self.showOptionsTab(type);
        }
        self.scope.app.active_fasade = self.scope.app.optionsTabName != false ? FASADE_NUMBER : false;
        self.scope.app.active_fasade_door = door_key || door_key === 0 ? `${door_key}` : false
        self.scope.app.active_fasade_segment = segment_key || segment_key === 0 ? `${segment_key}` : false
        self.scope.$applyAsync();

    };

    this.initBind = function () {
        /*При смене размеров помещения*/
        self.scope.$watchGroup(
            [
                "project.room_config.width",
                "project.room_config.height",
                "project.room_config.depth",
            ],
            self.onRoomResize
        );
        self.scope.$watch("project.tabletopTypeAuto", self.changeTableTopType);
        self.scope.$watch("app.delete", self.deleteElement);
        self.scope.$watch("app.rotationSnap", function () {
            self.transform.rotationSnap = THREE.Math.degToRad(self.scope.app.rotationSnap);
        });
        self.scope.$watch("app.new_model", self.changeModel);
        self.scope.$watch("project.floor", self.changeFloor);
        self.scope.$watch("project.wall", self.changeWall);
        self.scope.$watch("project.handle", self.rebuildHandle);
        self.scope.$watch("app.projectListPage", self.changeprojectsAllList);
        self.scope.$watch("controlDevice", self.initCamera);
        self.scope.$watch("catalog.element", self.CatalogGetElement);
        self.scope.$watch("catalog.filter", function (i) {
            if (self.scope.catalog.filter.length > 0) {
                self.scope.catalog.section = false;
                self.getCatalog();
            } else {
                self.getCatalog();
            }
        });
        self.scope.$watchGroup(
            ["catalog.section", "catalog.page", "catalog.filterSection"],
            function (e) {
                if (self.scope.catalog.section !== false) self.scope.catalog.filter = "";
                self.getCatalog();
            }
        );
        self.scope.$watch("app.transformMode", self.changeTransformMode);
        self.scope.$watch("app.projectsAllList", self.changeprojectsAllList);
        self.scope.$watch("project.lightIntensive", self.changelightIntensive);
        self.scope.$watch("project.poitlightIntensive", self.changePointlightIntensive);
        self.scope.$watch("project.shadowQuality", self.changeQuality);
        self.scope.$watchGroup(
            ["app.default_module_color_btn", "app.default_fasade_color_btn"],
            function () {
                self.hideOptionsTab();
            }
        );
        self.scope.$watchGroup(
            ["app.projectf.id", "app.projectf.name", "app.projectf.user_hash"],
            function () {
                self.scope.app.projectListPage = 1;
                self.getProjectListData();
            }
        );
        self.scope.$watchGroup(
            [
                "techList.filter",
                "techList.pager",
            ],
            function () {
                if (self.scope.techList !== undefined) {
                    self.scope.getTechList();
                }
            }
        );
    };

    this.changeQuality = function (news) {
        self.scene.remove(self.light);
        self.createGlobalLight();
    };

    this.console = function (text) {
        self.consoleContainer.append("<p>" + text + "</p>");
    };

    this.changeTransformMode = function (news, old) {
        if (news != false) {
            self.transform.attach(self.scope.app.active);

            if (news == "rotate") self.transform.setMode("rotate");

            if (news == "translate") self.transform.setMode("translate");
        } else {
            self.transform.detach(self.scope.app.active);
        }
        self.scope.$applyAsync();
    };

    this.switchControlDevice = function () {
        self.scope.controlDevice = !self.scope.controlDevice;
    };

    this.changeprojectsAllList = function () {
        self.getProjectListData();
        self.scope.preloaderDesignerProject = true;
    };

    this.getDefaultTableTop = function () {
        var table = self.scope.app.TABLES;
        var table_id = Object.keys(table)[0];
        return {table: table_id, table_color: self.getDefaultTableTopColor(table_id)};
    };

    this.getDefaultTableTopColor = function (table_id) {
        let info = self.getProductInfo(table_id)
        if (info.COLOR != undefined) {
            var color = info.COLOR;
            var color_id = color[0];
        } else {
            var color_id = 0;
        }

        return color_id;
    };

    this.getDefaultPlinth = function () {
        var plinth = self.scope.app.PLINTH;
        var plinth_id = Object.keys(plinth)[0];
        return plinth_id;
    };

    this.getDefaultFasade = function (productId) {
        var productId = productId || false;
        var fasadeId = false;


        if (productId) {
            fasadeId = self.scope.fasadeErrorColor; //Фасад недоступен

            //Авто-замена фасадов, если те недоступны, на первый подходящий
            //Отключено по требованию
            /*var fasadeList = self.scope.app.CATALOG.PRODUCTS[productId].FACADE.filter(function (
                    i
                ) {
                    return self.canBeSetFasade(productId, i);
                });
                fasadeId = fasadeList[Object.keys(fasadeList)[0]];*/
        } else {
            var fasadeList = self.scope.app.FASADE;
            fasadeId = Object.keys(fasadeList)[0];
        }

        return parseInt(fasadeId);
    };

    // можетли быть фасад
    this.canBeSetFasade = function (productId, fasadeId, fasadeNumber, doorKey) {
        if (self.scope.app.active && fasadeNumber && self.scope.app.active.PROPS.CONFIG) {
            var fasadePositionID = self.scope.app.active.PROPS.CONFIG.FASADELIST[fasadeNumber]?.[doorKey] || self.scope.app.active.PROPS.CONFIG.FASADELIST[fasadeNumber];
            var fasadePosition = self.scope.app.FASADE_POSITION[fasadePositionID];
        }

        let info = self.getProductInfo(productId)
        var result =
            self.scope.app.FASADE[fasadeId] != undefined &&
            info != undefined &&
            info.FACADE != undefined &&
            info.FACADE.indexOf(fasadeId) != -1 &&
            !(
                self.scope.app.FASADE[fasadeId].UNSETINPRODUCT != undefined &&
                self.scope.app.FASADE[fasadeId].UNSETINPRODUCT[self.scope.legacy_city] !=
                undefined &&
                self.scope.app.FASADE[fasadeId].UNSETINPRODUCT[self.scope.legacy_city].indexOf(
                    productId
                ) != -1
            ) &&
            !(
                self.scope.app.active &&
                fasadeNumber &&
                self.scope.app.FASADE[fasadeId].TYPE == "made" &&
                fasadePosition &&
                fasadePosition.glass
            ) &&
            (!(
                    // проверка на витрину
                    (
                        fasadePosition && // проверка на пустой элемент
                        !fasadePosition.glass && // проверка элемента на параметр "Витрина"
                        self.scope.app.FASADE[fasadeId].GLASS_ONLY
                    )
                ) ||
                (fasadePosition && // проверка на пустой элемент
                    fasadePosition.is_glass_fasade && // проверка элемента на параметр "Есть витрина (шкаф)"
                    self.scope.app.FASADE[fasadeId].GLASS_ONLY)); // проверка фасада на параметр "только для витрины"

        return result;
    };

    this.SectionIdFilter = function () {
        return function (items, criteria) {
            var tmp = {};
            for (var i in items) {
                var item = items[i];
                if (
                    (criteria.SECTION_TYPE &&
                        self.scope.app.CATALOG.SECTIONS[item.SECTION_ID] != undefined &&
                        self.scope.app.CATALOG.SECTIONS[item.SECTION_ID].TYPE ==
                        criteria.SECTION_TYPE) ||
                    (criteria.SECTION_ID && item.SECTION_ID == criteria.SECTION_ID)
                ) {
                    tmp[i] = item;
                }
            }
            return tmp;
        };
    };

    this.elementFilter = function () {
        return function (items, criteria) {
            var tmp = {};

            var s = criteria.filter ? criteria.filter.toLowerCase() : false;

            for (var i in items) {
                var item = items[i];
                if (
                    !s ||
                    (s &&
                        (item.NAME.toLowerCase().search(s) != -1 ||
                            item.UNAME.toLowerCase().search(s) != -1))
                ) {
                    if (item.TYPE.indexOf(type) != -1) tmp[item.ID] = item;
                }
            }
            return tmp;
        };
    };

    this.elementFilterId = function () {
        return function (items, criteria) {
            var tmp = {};

            var DB = self.scope.app.CATALOG.PRODUCTS;

            angular.forEach(items, function (v, k) {
                angular.forEach(criteria.filter, function (criteriaVal, criteriaKey) {
                    var s = criteriaVal ? criteriaVal.toLowerCase() : "";
                    if (
                        criteriaVal == undefined ||
                        (DB[v] && DB[v][criteriaKey].toLowerCase().search(s) != -1)
                    ) {
                        tmp[k] = v;
                    }
                });
            });

            return tmp;
        };
    };

    this.setRotation = function (key, angle, cicle) {
        if (cicle) self.scope.app.active.rotation[key] -= angle;
        else self.scope.app.active.rotation[key] = angle;

        self.controlItemPosition(
            self.scope.app.active.PROPS.WRAP,
            self.scope.app.active.position
        );
    };

    this.filterFilling = function () {
        return function (items, criteria) {
            var tmp = [];

            if (criteria.ID != undefined) {
                for (var i in items) {
                    var item = items[i];

                    if (
                        criteria.ID.indexOf(item.ID) != -1 &&
                        (!item.CONDITIONS ||
                            eval(
                                self.expressionsReplace(item.CONDITIONS, {
                                    "#X#": criteria.PR.SIZE.width,
                                    "#Y#": criteria.PR.SIZE.height,
                                    "#Z#": criteria.PR.SIZE.depth,
                                })
                            ))
                    )
                        tmp.push(item);
                }
            }
            return tmp.sort(function (a, b) {
                return self.scope.app.FILLING[a.ID].SORT - self.scope.app.FILLING[b.ID].SORT;
            });
        };
    };

    this.filterFasadePosition = function () {
        return function (items, CONFIG, sort = true) {
            var tmp = [];
            var _items = [];

            if (CONFIG.CUSTOMFILLING) {
                let largestId = Object.keys(CONFIG.FASADELIST).pop()
                for (let i = 1; i <= largestId; i++) {
                    let tmp = CONFIG.FASADELIST[i] || {}
                    _items.push(tmp)
                }
            } else
                _items = items

            const chekPosition = (pos) => {
                var fasadePosition = self.scope.app.FASADE_POSITION[pos];

                if (
                    (!CONFIG.BASKET["FILLING"] ||
                        (!!CONFIG.BASKET["FILLING"] &&
                            fasadePosition["filling"].indexOf(CONFIG.BASKET["FILLING"]) != -1) ||
                        (!!CONFIG.BASKET["FILLING"] && !fasadePosition["filling"][0])) &&
                    (!CONFIG.BASKET["FASADESIZE"] ||
                        (!!CONFIG.BASKET["FASADESIZE"] &&
                            fasadePosition["FASADE_SIZE"] == CONFIG.BASKET["FASADESIZE"])) &&
                    (!CONFIG.BASKET["FASADESIZE" + fasadePosition.FASADE_NUMBER] ||
                        (!!CONFIG.BASKET["FASADESIZE" + fasadePosition.FASADE_NUMBER] &&
                            fasadePosition["FASADE_SIZE"] ==
                            CONFIG.BASKET["FASADESIZE" + fasadePosition.FASADE_NUMBER]))
                ) {
                    return fasadePosition["ID"]
                }
            }

            for (var i in _items) {
                let item = _items[i]
                if (typeof item === "object") {
                    let resUnite = []

                    angular.forEach(item, function (val, key) {
                        let res = chekPosition(val) || []
                        if (res)
                            resUnite.push(res);
                    })

                    //if (resUnite.length)
                    tmp.push(resUnite);
                } else {
                    let res = chekPosition(item) || []
                    if (res)
                        tmp.push(res);
                }
            }

            if (sort)
                return tmp.sort(function (a, b) {
                    return (
                        self.scope.app.FASADE_POSITION[a]?.FASADE_NUMBER -
                        self.scope.app.FASADE_POSITION[b]?.FASADE_NUMBER
                    );
                });
            else
                return tmp
        };
    };

    this.filterFasadeSize = function () {
        return function (items, number) {
            let tmp;
            if (number === false) {
                tmp = {};
                for (let i in items) {
                    let fasadeNumbedSize = items[i];
                    angular.forEach(
                        self.scope.app.FASADENUMBERSIZE[fasadeNumbedSize],
                        function (v, k) {
                            angular.forEach(v, function (fasadeSizeId) {
                                if (self.scope.app.FASADESIZE[fasadeSizeId] != undefined) {
                                    if (!tmp[k]) {
                                        tmp[k] = [];
                                    }

                                    tmp[k].push(fasadeSizeId);
                                }
                            });

                            if (tmp[k]) {
                                tmp[k] = tmp[k].sort(function (a, b) {
                                    return (
                                        self.scope.app.FASADESIZE[a].SORT - self.scope.app.FASADESIZE[b].SORT
                                    );
                                });
                            }
                        }
                    );
                }
            } else {
                tmp = [];
                for (let i in items) {
                    let fasadeNumbedSize = items[i];
                    if (self.scope.app.FASADENUMBERSIZE[fasadeNumbedSize])
                        angular.forEach(
                            self.scope.app.FASADENUMBERSIZE[fasadeNumbedSize][number],
                            function (fasadeSizeId, k) {
                                if (self.scope.app.FASADESIZE[fasadeSizeId] != undefined) {
                                    tmp.push(fasadeSizeId);
                                }
                            }
                        );
                }
                tmp = tmp.sort(function (a, b) {
                    return self.scope.app.FASADESIZE[a].SORT - self.scope.app.FASADESIZE[b].SORT;
                });
            }

            return tmp;
        };
    };

    this.filterFasadeType = function () {
        return function (items, criteria) {
            var tmp = {};

            //Глушка
            if (typeof criteria.fasade == 'object') {
                criteria.fasade = criteria.fasade[0];
            }

            if (
                criteria.fasade &&
                self.scope.app.FASADE[criteria.fasade].fasade_type[0] &&
                criteria.milling === undefined
            ) {

                var fasadeList = self.scope.app.FASADE[criteria.fasade].fasade_type;

                if (items.length > 0) {
                    angular.forEach(items, function (type) {
                        if (
                            self.scope.app.FASADETYPE[type] != undefined &&
                            fasadeList.indexOf(type) != -1
                        ) {
                            tmp[type] = self.scope.app.FASADETYPE[type];
                        }
                    });
                }
            } else if (!self.scope.app.MILLING[criteria.milling]) {
                if (items.length > 0) {
                    angular.forEach(items, function (type) {
                        if (self.scope.app.FASADETYPE[type] != undefined) {
                            tmp[type] = self.scope.app.FASADETYPE[type];
                        }
                    });
                }
            } else {
                var millingList = self.scope.app.MILLING[criteria.milling].fasade_type;

                if (items.length > 0) {
                    angular.forEach(items, function (type) {
                        if (
                            self.scope.app.FASADETYPE[type] != undefined &&
                            millingList.indexOf(type) != -1
                        ) {
                            tmp[type] = self.scope.app.FASADETYPE[type];
                        }
                    });
                }
            }
            return tmp;
        };
    };
    this.filterLoopSide = function () {
        return function (items, criteria) {
            const tmp = {}
            if (items.length > 0) {
                angular.forEach(items, function (type) {
                    if (self.scope.app.LOOPSIDE[type] != undefined) {
                        tmp[type] = self.scope.app.LOOPSIDE[type];
                    }
                });
            }

            const door_number = +self.scope.app.active_fasade_door

            if (door_number) {
                const group = self.scope.app.active
                const CONFIG = group.PROPS.CONFIG
                const section = +self.scope.app.active_fasade

                const sectionLeft = CONFIG.BASKET[`SECTIONS${section - 1}`] || false
                const sectionRight = CONFIG.BASKET[`SECTIONS${section + 1}`] || false

                switch (door_number) {
                    case 1:
                        if (CONFIG.BASKET.LOOPSSIDE[section][2]) {
                            tmp = {}
                        } else {
                            if (sectionLeft) {
                                const sectionLeftLoops = CONFIG.BASKET.LOOPSSIDE[section - 1] || {}
                                if (sectionLeftLoops[2] || [4693757, 7080949].includes(sectionLeftLoops[1])) {
                                    delete tmp[7080918]
                                } else {
                                    tmp[7080918] = self.scope.app.LOOPSIDE[7080918]
                                }

                                delete tmp[4693746]
                            }
                            if (sectionRight) {
                                const sectionRightLoops = CONFIG.BASKET.LOOPSSIDE[section + 1] || {}
                                if ([7080918, 4693746].includes(sectionRightLoops[1])) {
                                    delete tmp[7080949]
                                } else {
                                    tmp[7080949] = self.scope.app.LOOPSIDE[7080949]
                                }

                                delete tmp[4693757]
                            }
                        }
                        break;
                    case 2:
                        tmp = {}
                        break;
                }
            }
            return tmp;
        }
    }

    this.filterModuleColor = function () {
        return function (items, criteria) {
            var tmp = [];

            for (var color in items) {
                var colorId = items[color];

                if (self.scope.app.FASADE[colorId] != undefined) tmp.push(colorId);
            }

            return tmp;
        };
    };

    this.filterModuleColorID = function () {
        return function (items, criteria) {
            var tmp = {};
            var ids = criteria?.IDS || false;
            var productId = criteria?.PRODUCT_ID ? criteria.PRODUCT_ID : false;

            var s = criteria?.filter ? criteria.filter.toLowerCase() : false;

            for (var i in items) {
                // список доступных элементов

                if (self.scope.app.FASADE[items[i]])
                    var item = self.scope.app.FASADE[items[i]];
                else
                    var item = items[i];

                if (
                    item != undefined && item.ID &&
                    (!s || (item.NAME !== undefined && s && item.NAME.toLowerCase().search(s) != -1)) && item["ELEMENT_TYPE"] != "plinth"
                ) {
                    if (
                        self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID] != undefined &&
                        self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                            "UF_GROUP_CONSTRUCTOR"
                            ] != null
                    ) {
                        if (!ids || (ids && ids.indexOf(item.ID) != -1)) {
                            if (
                                tmp[
                                    self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                        "UF_GROUP_CONSTRUCTOR"
                                        ]
                                    ] == undefined
                            )
                                tmp[
                                    self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                        "UF_GROUP_CONSTRUCTOR"
                                        ]
                                    ] = [];

                            if (
                                self.scope.app.optionsTabName == "defaultModuleColor"
                            ) {
                                if (item.ID !== 1042113 && item.ID !== 2307265 && item.ID !== 2307267) {
                                    tmp[
                                        self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                            "UF_GROUP_CONSTRUCTOR"
                                            ]
                                        ].push(item.ID);
                                }
                            } else {
                                tmp[
                                    self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                        "UF_GROUP_CONSTRUCTOR"
                                        ]
                                    ].push(item.ID);
                            }
                        }
                    }
                }
            }

            var tmpl = {};
            angular.forEach(tmp, function (k, i) {
                if (
                    self.scope.app.optionsTabName == "defaultModuleColor"
                ) {
                    if (i !== "1294117" && i !== "953073") {
                        tmpl[i] = self.scope.app.FASADE_GROUPS[i];
                        tmpl[i]["FASADES"] = tmp[i];
                    }
                } else if (self.scope.app.FASADE_GROUPS[i]) {
                    tmpl[i] = self.scope.app.FASADE_GROUPS[i];
                    tmpl[i]["FASADES"] = tmp[i];
                }
            });

            return tmpl;
        };
    };

    this.filterProfileColorID = function () {
        return function (items, criteria) {
            let tmpl = {}
            const product = self.scope.app.CATALOG.PRODUCTS[6513251] //C - образный профиль
            const aprovedColors = product.COLOR

            for (let color of aprovedColors) {
                if (items[color])
                    tmpl[color] = items[color]
            }

            return tmpl;
        };
    };

    this.filterProfileTypeID = function () {
        return function (items, criteria) {
            let tmpl = {}
            const products = self.scope.app.PRODUCTS_TYPES[6520633].PRODUCTS
            const aprovedProducts = self.scope.app.CATALOG.PRODUCTS

            for (let product of products) {
                if (aprovedProducts[product])
                    tmpl[product] = aprovedProducts[product]
            }

            return tmpl;
        };
    };


    this.filterPalette = function () {
        return function (items, criteria) {
            var tmp = {};

            //Глушка
            if (typeof criteria.element == 'object') {
                criteria.element = criteria.element[0];
            }

            var s = criteria.filter ? criteria.filter.toLowerCase() : false;
            var root = criteria.root ? criteria.root : "FASADE";

            if (
                criteria.element != undefined &&
                self.scope.app[root][criteria.element] &&
                self.scope.app[root][criteria.element].PALETTE[0]
            ) {
                var type = self.scope.app[root][criteria.element].PALETTE;

                for (var i in items) {
                    var item = items[i];
                    if (
                        !s ||
                        (s &&
                            (item.NAME.toLowerCase().search(s) != -1))
                    ) {
                        for (let w in type) {
                            if (type[w] == item.TYPE) {
                                tmp[item.ID] = item;
                                break;
                            }
                        }
                    }
                }
            }

            return tmp;
        };
    };

    this.setGroupPosition = function (group, coordinates) {
        if (coordinates) {
            if (coordinates.position && coordinates.rotation) {
                var position = coordinates.position;
                var rotation = coordinates.rotation;
            } else {
                var position = new THREE.Vector3(0, 0, 0);
                var rotation = new THREE.Euler();
            }
        } else {
            var position = new THREE.Vector3(0, 0, 0);
            var rotation = new THREE.Euler();
        }

        group.old_position = group.position;
        group.old_rotation = group.rotation;
        group.position.copy(position);
        group.rotation.copy(rotation);
        self.scope.project.items[group.id].POSITION = group.position;
        self.scope.project.items[group.id].ROTATION = group.rotation;

        if (self.scope.project.items[group.id].PARENT) {
            var parent = self.scope.project.items[self.scope.project.items[group.id].PARENT];
            parent.CHILDPOSITION[self.scope.project.items[group.id].RASPILKEY] = {
                position: position,
                rotation: rotation,
            };
        }
    };

    this.removeElementFromProject = function (obj, only_child, callback) {
        var callback = callback || new Function();

        if (obj == undefined) return;

        if (!obj.name?.toLowerCase().includes("ручка"))
            self.scope.app.configElementFilling = false;

        if (obj["TYPE"] != undefined && obj.TYPE == "CATALOG") {
            delete self.scope.app.basket[obj.UID];

            delete self.scope.project.items[obj.UID];
        } else {
            if (!self.scope.project.items[obj.id]) return;

            this.removeEdgeFromElement(obj);

            var parent = self.scope.project.items[obj.id].PARENT;

            if (
                !only_child &&
                self.scope.project.items[obj.id].CHILD != undefined &&
                self.scope.project.items[obj.id].CHILD.length
            ) {
                angular.forEach(self.scope.project.items[obj.id].CHILD, function (v) {
                    var remItem = {id: v};

                    if (
                        self.scope.project.items[v] != undefined &&
                        self.scope.project.items[v].TYPE == "SUBELEMENT"
                    )
                        remItem = self.scope.app.elementsObj[v];

                    self.removeElementFromProject(remItem);
                });
            }

            if (obj.PROPS != undefined) {
                if (obj.PROPS.WRAP != undefined)
                    angular.forEach(self.scope.app.wraps, function (v, k) {
                        if (v.id == obj.PROPS.WRAP.id) {
                            self.scope.app.wraps.splice(k, 1);
                        }
                    });

                if (
                    obj.PROPS.PRODUCT != undefined &&
                    obj.PROPS.PRODUCT.element_type == "element_room"
                )
                    self.deleteRoomElement(obj.id);

                if (obj.PROPS.CONFIG.BASKET.GROUP)
                    self.removeElementFromGroup(obj)
            }

            angular.forEach(self.scope.app.elements, function (v, k) {
                if (v.id == obj.id) {
                    self.scope.app.elements.splice(k, 1);
                }
            });

            if (obj.parent != undefined) {
                self.scene.remove(self.scope.app.elementsObj[obj.id]);
            }

            delete self.scope.app.basket[obj.id];
            delete self.scope.project.items[obj.id];
            delete self.scope.app.elementsObj[obj.id];

            if (!parent) {
                self.hideOptionsTab();
                self.scope.app.selected = false;
                self.drag = false;
                self.controls.enabled = true;
                self.scope.app.configElementFilling = false;
                self.scope.app.selectSecionElement = false;

                self.getBasketPrice();
            } else if (only_child) {
                angular.forEach(self.scope.project.items[parent].CHILD, function (k, v) {
                    if (k == obj.id) {
                        self.scope.project.items[parent].CHILD.splice(v, 1);
                    }
                });
            }
        }

        //self.scope.app.basketCount--;

        self.scope.app.basketCount = Object.keys(self.scope.app.basket).length

        callback();

        self.calcElementsGroup();
    };

    this.deleteRoomElement = function (id) {
        angular.forEach(self.scope.app.room, function (k, v) {
            if (k.PARENT != undefined && k.PARENT == id) {
                delete self.scope.app.room[v];
            }
        });
    };

    this.filterCatalog = function () {
        return function (items, search) {
            var s = search.toLowerCase();
            if (items)
                return items.filter(function (v) {
                    return !(self.getProductInfo(v).NAME.toLowerCase().search(s) == -1);
                });
        };
    };

    /*
    Вересников В.Д. 01.04.2024:
    Фильтрация списка элементов типа matrixElement по поисковому запросу.
    @param items - объект, где поля являются объектами матрицы
    @param criteria - объект переменных для функции, в котором передаётся строка поиска
  */
    this.DefaultMatrixElementFilter = function () {
        return function (items, criteria) {

            var filter_substring = criteria.filter ? criteria.filter.toLowerCase() : false;

            // список доступных элементов
            var result_object = {};
            Object.values(items).map(item => {
                if (!filter_substring ||
                    (filter_substring && item.NAME && item.NAME.toLowerCase().search(filter_substring) != -1)) {
                    result_object[item.ID] = item
                }
            })

            return result_object;
        };
    };
    //

    /*
    Вересников В.Д. 13.05.2024:
    Фильтрация списка кромок
    @param items - объект, где поля являются объектами матрицы
    @param criteria - объект переменных для функции, в котором передаётся строка поиска
  */
    this.DefaultHemElementFilter = function () {
        return function (items, criteria) {

            var filter_substring = criteria.filter ? criteria.filter.toLowerCase() : false;
            var recomended_mode = criteria.recomendedMode || false;

            var recomend_hem = self.scope.app.active.PROPS.PRODUCT.REC_HEM || []

            // список доступных элементов
            var result_object = {};

            Object.values(items).map(item => {
                if (!filter_substring ||
                    (filter_substring && item.NAME && item.NAME.toLowerCase().search(filter_substring) != -1)) {

                    if (recomended_mode && recomend_hem.includes(item.ID))
                        result_object[item.ID] = item
                    else if (!recomended_mode)
                        result_object[item.ID] = item
                }
            })

            return result_object;
        };
    };
    //

    this.DefaultFasadeFilter = function () {
        return function (items, criteria) {
            var tmp = {};
            var ids = criteria?.IDS || false;
            var productId = criteria.PRODUCT_ID ? criteria.PRODUCT_ID : false;
            var door_id = self.scope.app.active?.PROPS?.CONFIG.BASKET.DOORS ? self.scope.app.active_fasade_door || "1" : false

            if (
                !productId &&
                (self.scope.app.optionsTabName == "defaultFasadeup" ||
                    self.scope.app.optionsTabName == "defaultFasadedown" ||
                    self.scope.app.optionsTabName == "plinthDefaultFasade")
            ) {
                productId =
                    self.scope.project[
                        self.scope.app.optionsTab[self.scope.app.optionsTabName].parent
                        ];
            } else if (!productId && self.scope.app.optionsTabName == "elementFasade") {
                productId = self.scope.app.active.PROPS.PRODUCT.ID;
            }

            var s = criteria.filter ? criteria.filter.toLowerCase() : false;

            for (var i in items) {
                // список доступных элементов

                if (self.scope.app.optionsTabName == "elementFasade")
                    var item = self.scope.app.FASADE[items[i]];
                else var item = items[i];

                if (
                    item != undefined &&
                    !(
                        productId &&
                        item.ID &&
                        !self.canBeSetFasade(
                            productId,
                            item.ID,
                            self.scope.app.active_fasade || false,
                            door_id
                        )
                    ) &&
                    (!s ||
                        (item.NAME !== undefined && s && item.NAME.toLowerCase().search(s) != -1)) &&
                    (productId || item["ELEMENT_TYPE"] != "plinth")
                ) {
                    if (
                        self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID] != undefined &&
                        self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                            "UF_GROUP_CONSTRUCTOR"
                            ] != null
                    ) {
                        if (!ids || (ids && ids.indexOf(item.ID) != -1)) {
                            if (
                                tmp[
                                    self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                        "UF_GROUP_CONSTRUCTOR"
                                        ]
                                    ] == undefined
                            )
                                tmp[
                                    self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                        "UF_GROUP_CONSTRUCTOR"
                                        ]
                                    ] = [];

                            if (
                                self.scope.app.optionsTabName == "defaultFasadeup" ||
                                self.scope.app.optionsTabName == "defaultFasadedown"
                            ) {
                                if (item.ID !== 1042113 && item.ID !== 2307265 && item.ID !== 2307267) {
                                    tmp[
                                        self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                            "UF_GROUP_CONSTRUCTOR"
                                            ]
                                        ].push(item.ID);
                                }
                            } else {
                                tmp[
                                    self.scope.app.FASADE_SECTION[item.IBLOCK_SECTION_ID][
                                        "UF_GROUP_CONSTRUCTOR"
                                        ]
                                    ].push(item.ID);
                            }
                        }
                    }
                }
            }

            var tmpl = {};
            angular.forEach(tmp, function (k, i) {
                if (
                    self.scope.app.optionsTabName == "defaultFasadeup" ||
                    self.scope.app.optionsTabName == "defaultFasadedown"
                ) {
                    if (i !== "1294117" && i !== "953073") {
                        tmpl[i] = self.scope.app.FASADE_GROUPS[i];
                        tmpl[i]["FASADES"] = tmp[i];
                    }
                } else if (self.scope.app.FASADE_GROUPS[i]) {
                    tmpl[i] = self.scope.app.FASADE_GROUPS[i];
                    tmpl[i]["FASADES"] = tmp[i];
                }
            });

            return tmpl;
        };
    };

    this.DefaultGlassFilter = function () {
        return function (items, criteria) {
            if (criteria.FASADE == undefined) return;

            var tmp = {};
            var ids = criteria.IDS || false;
            var fasade_id = criteria.FASADE || false;
            var fasade = self.scope.app.FASADE[fasade_id];

            //глушка
            if (typeof fasade_id == 'object') {
                var fasade = self.scope.app.FASADE[fasade_id[0]];
            }

            for (var i in items) {
                var item = items[i];
                if (
                    ids &&
                    ids.indexOf(item.ID) != -1 &&
                    ((fasade.ATTACH_GLASS[0] && fasade.ATTACH_GLASS.indexOf(item.ID) != -1) ||
                        !fasade.ATTACH_GLASS[0])
                ) {
                    tmp[i] = item;
                }
            }

            return tmp;
        };
    };

    this.deleteElement = function (e) {
        if (e && self.scope.app.selected.object) {
            self.scope.app.transformMode = false;
            if (self.scope.app.config.show_message != false)
                self.alert(
                    "Удаление объекта - " + self.scope.app.selected.object.parent.PROPS.PRODUCT.NAME
                );

            self.removeElementFromProject(self.scope.app.selected.object.parent);
            self.scope.app.delete = false;
        }
        self.scope.$applyAsync();
    };

    this.alert = function (text, type, options) {
        var type = type || "info";
        var options = options || {};

        toastr.options = {
            closeButton: true,
            debug: false,
            newestOnTop: true,
            progressBar: false,
            positionClass: "toast-bottom-right",
            preventDuplicates: true,
            onclick: null,
            showDuration: "300",
            hideDuration: "1000",
            timeOut: "3000",
            extendedTimeOut: "3000",
            showEasing: "swing",
            hideEasing: "linear",
            showMethod: "fadeIn",
            hideMethod: "fadeOut",
        };

        toastr.options = angular.extend(toastr.options, options);
        toastr[type](text);
    };

    this.MouseMove = function (event) {
        self.onDocumentMouseMove(event);
    };

    this.unmarkSelected = function () {
        self.scope.elementSizeWatch();
        self.scope.elementSizeWatch = new Function();

        if (self.scope.app.selected) {
            const disableSelect = (elem, multiselect = false) => {
                elem.object.parent.PROPS.FRAME.material.visible = false;

                if (!multiselect && elem.object.parent.PROPS.RULER)
                    elem.object.parent.PROPS.RULER.visible = false
            }

            if (Array.isArray(self.scope.app.selected)) {
                self.scope.app.selected.forEach(item => disableSelect(item, true))
            } else {
                disableSelect(self.scope.app.selected)
            }

        } else
            angular.forEach(self.scope.app.elements, function (item, key) {
                item.PROPS.FRAME.material.visible = false;

                if (item.PROPS.RULER)
                    item.PROPS.RULER.visible = false
            });


        self.scope.warningBox.visible = false;
        self.scope.app.configElementFilling = false;
        self.scope.app.selected = false;
        self.scope.app.active = false;
        self.scope.app.active_fasade = false;
        self.scope.app.active_fasade_door = false;
        self.scope.app.active_fasade_segment = false;
        self.drag = false;
        self.controls.enabled = true;
        self.scope.app.transformMode = false;

        self.scope.app.new_size.width = 0;
        self.scope.app.new_size.height = 0;
        self.scope.app.new_size.depth = 0;
        self.scope.app.newSubelemPos = {};

        self.scope.$applyAsync();
    };

    this.login = function () {
        self.hendler.login(self.scope);
    };

    this.logout = function () {
        self.hendler.logout(self.scope);
    };

    this.getDisabledProductsInfo = function () {
        self.scope.app.block_cart = true
        self.scope.$applyAsync();
        $.ajax({
            url: '/api/constructor/catalog/getdisabledproducts/',
            method: 'post',
            dataType: 'json',
            contentType: "application/json",
            data: JSON.stringify({
                style: self.scope.app.config.style,
                config: self.scope.app.config.config,
                products: self.scope.disabledProducts,
            }),
            success: function (data) {
                let result = data.DATA;

                if (result && Object.keys(result).length > 0) {

                    angular.forEach(result, function (info, key) {
                        self.scope.disabledProducts[key] = info

                        angular.forEach(self.scope.disabledObjectProducts[key], function (item, id) {
                            let group = self.addElementToProjectFromProp(item);
                            if (group)
                                self.checkFasadeGroupOnLoadProduct(group)
                        })
                    })

                    self.scope.disabledObjectProducts = {}
                }

                self.scope.app.block_cart = false
                self.scope.$applyAsync();
            }
        });
    };

    this.updateUMdataNewFormat = function (_data, objID) {
        const PRODUCT = self.getProductInfo(_data.ID)
        let new_data = {}

        if (PRODUCT?.moduleType && (PRODUCT.moduleType.CODE === "wardrobe" || (PRODUCT.moduleType.CODE !== "wardrobe" && !_data?.BASKET?.DOORS))) {
            new_data = Object.assign({}, _data)

            const sectionsCount = Object.keys(new_data.SECTIONS).length
            const fasadePosition = self.getFasadePosition({
                PROPS: {
                    CONFIG: new_data,
                    PRODUCT
                }
            }, 1)

            let tmpSubelements = {}

            for (let i = 1; i <= sectionsCount; i++) {
                if (!tmpSubelements[i])
                    tmpSubelements[i] = {}

                if (new_data.SECTIONS[i]?.SUBELEMENTS) {
                    angular.forEach(new_data.SECTIONS[i].SUBELEMENTS, (subEl, key) => {
                        tmpSubelements[i][key] = Object.assign({}, subEl)
                    })
                    new_data.SECTIONS[i].SUBELEMENTS = {}
                }

                delete new_data.BASKET[`SECTIONSFILLING${i}`]

                if (new_data.BASKET[`FASADE${i}`]) {
                    new_data.BASKET[`FASADE${i}`] = {0: self.scope.app.constants.noFasad}
                    new_data.BASKET[`FASADESIZES${i}`] = [fasadePosition.FASADE_HEIGHT]
                }
            }

            new_data.FASADE_SECTIONS = {
                COLORS: {},
                MILLINGS: {},
                PALETTES: {},
                PATINAS: {},
                BOX_FASADE: {},
                HI_TECH_PROFILES: {},
                DRAWERS_SHELVES: {},
                PARTITION: {},
                FILLING_COUNT: {},
                FASADE_POSITIONS: {},
                LOOPS: {},
                AVAILABLE_FASADES: {},
            }

            let tmp_group = self.addElementToProject(_data.ID, new_data);

            angular.forEach(tmpSubelements, (section, i) => {
                angular.forEach(section, (subel, subelKey) => {
                    const productInfo = self.getProductInfo(subel.ID)

                    let addSubElement = self.addSubElementToElement(
                        tmp_group,
                        productInfo,
                        i,
                        subelKey,
                        subel
                    );

                    let positionValue = self.getSectionMousePositionFromInput(
                        tmp_group,
                        new THREE.Vector3(subel.position.x, subel.position.y, subel.position.z),
                        addSubElement.PROPS.FRAME
                    );
                    self.setSectionElementPosition(
                        tmp_group,
                        addSubElement.PROPS.FRAME,
                        positionValue,
                        tmp_group.PROPS.SECTIONCONTROL[i - 1],
                        subelKey
                    );

                    if (self.scope.app.newSubelemPos[subel.objId]) {
                        self.scope.app.newSubelemPos[addSubElement.PROPS.FRAME.id] = self.scope.app.newSubelemPos[subel.objId]
                        delete self.scope.app.newSubelemPos[subel.objId]
                    }

                    if (productInfo.MIN_FASADE_SIZE) {
                        self.addFasadeToBox(tmp_group, addSubElement, productInfo)
                    }

                    self.scope.$applyAsync();
                })
                self.calcSectionSubElementConfigValue(tmp_group);

                self.controlFasadeCount(tmp_group, i)
            })

            self.calcSectionSubElementConfigValue(tmp_group);

            new_data = tmp_group.PROPS.CONFIG

            self.alert(`Универсальный модуль ID: ${objID} - был переконвертирован! ПРОВЕРЬТЕ ПРАВИЛЬНОСТЬ ПОЛУЧЕННОГО МОДУЛЯ!`, "error");

        } else
            new_data = _data

        return new_data
    }

    this.loadProject = function (project) {
        self.clearBasket(function () {
            var items = project.items;
            var basket = project.basket || {};
            var groups = project.groups;
            const projectDate = new Date(project.time).getTime()
            const updateConstructorTime = new Date(2025, 7, 26).getTime()

            delete project.items;
            delete project.groups

            project.city = self.scope.project.city;

            if (project.technologist === undefined)
                project.technologist = false;

            self.scope.project = angular.extend(self.scope.project, project);
            self.scope.project.items = {};
            self.scope.alerts = {};
            self.scope.disabledProducts = {};
            self.scope.project.autoload = false;

            self.controlDefaultFasade("element_up", self.scope.project.default_fasade_up);
            self.controlDefaultFasade("element_down", self.scope.project.default_fasade_down);
            self.controlDefaultTabletop();
            self.controlDefaultPlinth();

            let old_project = false
            if (projectDate < updateConstructorTime)
                old_project = true

            angular.forEach(items, function (item, key) {
                if (!item.PARENT && key != "table_top" && key != "plinth") {

                    if (self.alertsTimer)
                        clearTimeout(self.alertsTimer);

                    if (self.disabledProductsTimer)
                        clearTimeout(self.disabledProductsTimer);

                    //Таймаут для появления айтемов
                    setTimeout(() => {
                        if (old_project)
                            item = self.updateUMdataNewFormat(item, key)

                        let group = self.addElementToProjectFromProp(item)

                        if (group) {
                            self.checkFasadeGroupOnLoadProduct(group)
                            if (group.PROPS.SECTIONSOBJ)
                                self.calcSectionSubElementConfigValue(group)
                        }
                    }, 500)

                    self.alertsTimer = setTimeout(() => {
                        angular.forEach(self.scope.alerts, function (alert, fasade) {
                            const color = self.scope.app.FASADE[fasade]
                                ? self.scope.app.FASADE[fasade].NAME
                                : fasade;
                            const text = alert + " - " + color;
                            self.alert(text, "info", {timeOut: "0", extendedTimeOut: "3000"});
                        });
                    }, 500)

                    self.disabledProductsTimer = setTimeout(() => {
                        if (Object.keys(self.scope.disabledProducts).length)
                            self.getDisabledProductsInfo()
                    }, 600)

                } else if (item.QUANTITY > 1 && self.scope.app.HANDLES[item.ID]) {
                    setTimeout(() => {
                        let handle = Object.entries(self.scope.app.basket).find(_item => _item[1].ID === item.ID)
                        self.scope.app.basket[handle[0]].QUANTITY = item.QUANTITY
                    }, 1000)
                }
            });

            self.unmarkSelected()

            if (project.camera) {
                self.camera.position.fromArray(project.camera.position);
                self.camera.rotation.fromArray(project.camera.rotation);
            }

            if (self.scope.app.config.options)
                self.controlOptions();

            if (self.scope.app.config.show_message != false)
                self.alert("Проект загружен", "success");
        });
    };

    this.loadFileCache = function (url, type, callback, modelName) {
        var callback = callback || new Function();

        var data;
        if (url) {
            if (type == "" || type == "dae" || type == "DAE") {
                self.DaeLoader.load(url, function (collada) {
                    data = collada;
                    callback(data);
                });
            }
            if (type == "GLTF") {
                self.GLTFLoader.load(url, function (collada) {
                    data = collada;
                    callback(data);
                });
            }
            if (type == "FBX") {
                self.FBXLoader.load(url, function (FBX) {
                    data = FBX;
                    callback(data);
                });
            }

            if (type == "img") {
                data = self.TextureLoader.load(url);
                data.encoding = self.encode;
                data.anisotropy = 10;
            }
        }

        return data;
    };

    this.controlNierestObjects = function (obj, position, rotation, pos) {
        if (pos == "bottom")
            return {}

        const roomSize = self.scope.project.room_config
        var obj = obj || self.scope.app.selected.object
        const group = obj.parent;

        var dragElement = self.getMinMaxPosition(obj, position, rotation);
        var intersection = {};

        const calcRelZPos = (element, val, front, back, left, right) => {
            if ((element.minZ >= dragElement.minZ && element.minZ <= dragElement.maxZ) ||
                (element.maxZ >= dragElement.minZ && element.maxZ <= dragElement.maxZ)) {
                let destXSub = Math.max(Math.abs(element.minX - dragElement.minX), Math.abs(dragElement.maxX - element.minX),
                    Math.abs(element.maxX - dragElement.minX), Math.abs(dragElement.maxX - element.maxX))
                let destZSub = Math.max(Math.abs(element.minZ - dragElement.minZ), Math.abs(dragElement.maxZ - element.minZ),
                    Math.abs(element.maxZ - dragElement.minZ), Math.abs(dragElement.maxZ - element.maxZ))
                let destSub = Math.max(destXSub, destZSub)

                if (element.minY >= dragElement.maxY && destSub <= 1000) {
                    if (!intersection["topObj"] || intersection["topObj"].distance > Math.abs(element.minY - dragElement.maxY)) {
                        intersection["topObj"] = {
                            obj: val,
                            distance: Math.abs(element.minY - dragElement.maxY),
                        }
                    }
                } else if (element.maxY <= dragElement.minY && destSub <= 1000) {
                    if (!intersection["bottomObj"] || intersection["bottomObj"].distance > Math.abs(dragElement.minY - element.maxY)) {
                        intersection["bottomObj"] = {
                            obj: val,
                            distance: Math.abs(dragElement.minY - element.maxY),
                        }
                    }
                } else {
                    if (element.minX >= dragElement.maxX) {
                        if (!intersection[right] || intersection[right].distance > Math.abs(element.minX - dragElement.maxX)) {
                            intersection[right] = {
                                obj: val,
                                distance: Math.abs(element.minX - dragElement.maxX),
                            }
                        }
                    } else if (dragElement.minX >= element.maxX) {
                        if (!intersection[left] || intersection[left].distance > Math.abs(dragElement.minX - element.maxX)) {
                            intersection[left] = {
                                obj: val,
                                distance: Math.abs(dragElement.minX - element.maxX),
                            }
                        }
                    }
                }
            }
        }

        const calcRelXPos = (element, val, front, back, left, right) => {
            if ((element.minX >= dragElement.minX && element.minX <= dragElement.maxX) ||
                (element.maxX >= dragElement.minX && element.maxX <= dragElement.maxX)) {
                let destXSub = Math.max(Math.abs(element.minX - dragElement.minX), Math.abs(dragElement.maxX - element.minX),
                    Math.abs(element.maxX - dragElement.minX), Math.abs(dragElement.maxX - element.maxX))
                let destZSub = Math.max(Math.abs(element.minZ - dragElement.minZ), Math.abs(dragElement.maxZ - element.minZ),
                    Math.abs(element.maxZ - dragElement.minZ), Math.abs(dragElement.maxZ - element.maxZ))
                let destSub = Math.max(destXSub, destZSub)

                if (element.minY >= dragElement.maxY && destSub <= 1000) {
                    if (!intersection["topObj"] || intersection["topObj"].distance > Math.abs(element.minY - dragElement.maxY)) {
                        intersection["topObj"] = {
                            obj: val,
                            distance: Math.abs(element.minY - dragElement.maxY),
                        }
                    }
                } else if (element.maxY <= dragElement.minY && destSub <= 1000) {
                    if (!intersection["bottomObj"] || intersection["bottomObj"].distance > Math.abs(dragElement.minY - element.maxY)) {
                        intersection["bottomObj"] = {
                            obj: val,
                            distance: Math.abs(dragElement.minY - element.maxY),
                        }
                    }
                } else {
                    if (element.minZ >= dragElement.maxZ) {
                        if (!intersection[front] || intersection[front].distance > Math.abs(element.minZ - dragElement.maxZ)) {
                            intersection[front] = {
                                obj: val,
                                distance: Math.abs(element.minZ - dragElement.maxZ),
                            }
                        }
                    } else if (dragElement.minZ >= element.maxZ) {
                        if (!intersection[back] || intersection[back].distance > Math.abs(dragElement.minZ - element.maxZ)) {
                            intersection[back] = {
                                obj: val,
                                distance: Math.abs(dragElement.minZ - element.maxZ),
                            }
                        }
                    }
                }
            }
        }

        angular.forEach(
            self.scope.app.elements.filter(function (el) {
                if (el.id != group.id &&
                    el.PROPS.PRODUCT.NAME.toLowerCase().indexOf("фальш") < 0)
                    return true;
            }),
            function (val, key) {

                if (val.PROPS.CONFIG.CHILD?.length > 0 && val.PROPS.CONFIG.CHILDPOSITION?.length > 0) {
                    return;
                }

                var element = self.getMinMaxPosition(val.PROPS.WRAP);

                let front = "frontObj"
                let back = "backObj"
                let left = "leftObj"
                let right = "rightObj"

                switch (pos) {
                    case "right":
                        front = "rightObj"
                        back = "leftObj"
                        left = "frontObj"
                        right = "backObj"

                        calcRelXPos(element, val, front, back, left, right);
                        calcRelZPos(element, val, front, back, left, right);

                        break;
                    case "left":
                        front = "leftObj"
                        back = "rightObj"
                        left = "backObj"
                        right = "frontObj"

                        calcRelXPos(element, val, front, back, left, right);
                        calcRelZPos(element, val, front, back, left, right);

                        break;
                    case "forward":
                        front = "backObj"
                        back = "frontObj"
                        left = "rightObj"
                        right = "leftObj"

                        calcRelXPos(element, val, front, back, left, right);
                        calcRelZPos(element, val, front, back, left, right);

                        break;
                    default:
                        calcRelXPos(element, val, front, back, left, right);
                        calcRelZPos(element, val, front, back, left, right);
                        break;
                }
            })

        return intersection
    }

    this.removeObjectFromScene = function (object) {
        if (object.material) {
            object.geometry.dispose()
            object.material.dispose()
        }

        for (let child in object.children) {
            self.removeObjectFromScene(child)
        }
    }

    //Создание линейки расстояний от объекта до стен комнаты
    this.createObjectPositionRulers = function (obj, position, rotation, _pos, update = false) {
        const group = obj.parent
        const pos = group.PROPS.CONFIG.ROOM_ROTATION || _pos
        const correctionDef = 150;
        const roomSize = self.scope.project.room_config
        const size = group.PROPS.CONFIG.SIZE
        let sizeVector = new THREE.Vector3(size.width, size.height, size.depth).divideScalar(2)

        const rulerSummary = new THREE.Object3D()
        const tabletop = group.PROPS.CONFIG.HAVETABLETOP;
        const rulersArr = []

        let intersection = self.controlNierestObjects(obj, position, rotation, pos) || {};

        if (update && group.PROPS.RULER) {
            self.removeObjectFromScene(group.PROPS.RULER)
            group.remove(group.PROPS.RULER)
            delete group.PROPS.RULER
        }

        let room_sides = {}
        switch (pos) {
            case "left":
                room_sides = {
                    left: roomSize.depth - (position.z + size.width / 2),
                    right: position.z - size.width / 2,
                    back: position.x - size.depth / 2 - -(roomSize.width / 2),
                    //front: roomSize.width / 2 - (position.x + size.depth / 2),
                    bottom: position.y - size.height / 2 - -(roomSize.height / 2),
                    top: roomSize.height / 2 - (position.y + size.height / 2),
                }
                sizeVector = new THREE.Vector3(size.depth, size.height, size.width).divideScalar(2)
                break;
            case "right":
                room_sides = {
                    left: position.z - size.width / 2,
                    right: roomSize.depth - (position.z + size.width / 2),
                    back: roomSize.width / 2 - (position.x + size.depth / 2),
                    //front: position.x - size.depth / 2 - -(roomSize.width / 2),
                    bottom: position.y - size.height / 2 - -(roomSize.height / 2),
                    top: roomSize.height / 2 - (position.y + size.height / 2),
                }
                sizeVector = new THREE.Vector3(size.depth, size.height, size.width).divideScalar(2)
                break;
            case "forward":
                room_sides = {
                    left: roomSize.width / 2 - (position.x + size.width / 2),
                    right: position.x - size.width / 2 - -(roomSize.width / 2),
                    back: roomSize.depth - (position.z + size.depth / 2),
                    //front: position.z - size.depth / 2,
                    bottom: position.y - size.height / 2 - -(roomSize.height / 2),
                    top: roomSize.height / 2 - (position.y + size.height / 2),
                }
                break;
            default:
                room_sides = {
                    left: position.x - size.width / 2 - -(roomSize.width / 2),
                    right: roomSize.width / 2 - (position.x + size.width / 2),
                    back: position.z - size.depth / 2,
                    //front: roomSize.depth - (position.z + size.depth / 2),
                    bottom: position.y - size.height / 2 - -(roomSize.height / 2),
                    top: roomSize.height / 2 - (position.y + size.height / 2),
                }
                break;
        }

        angular.forEach(room_sides, function (_value, side) {
            let value = Math.ceil(_value)

            if (value > 0) {
                let sub_lines = ["back", "front", "left", "right"].includes(side) ? 190 : false
                let ruler = self.createArrowSize({
                    width: value,
                    text: value,
                    lineColor: "#ffde00",
                    lines: sub_lines
                });
                ruler.name = `${side}_ruler`

                if (["back", "front", "left", "right"].includes(side)) {
                    if (tabletop) {
                        ruler.position.setY(size.height / 2 + 80 + correctionDef);

                    } else {
                        if (group.PROPS.PRODUCT.NAME.indexOf('Столешница') >= 0) { // корректировка для столешниц
                            ruler.position.setY(size.height / 2 + 240);
                        } else {
                            ruler.position.setY(size.height / 2 + 40 + correctionDef);
                        }
                    }
                }

                let sign_side = 1;
                switch (side) {
                    case "bottom":
                        sign_side = -1
                    case "top":
                        ruler.position.setY(sign_side * (value / 2 + size.height / 2));
                        ruler.rotation.z = Math.PI / 2;
                        break;
                    case "left":
                        sign_side = -1
                    case "right":
                        ruler.position.setX(sign_side * (value / 2 + size.width / 2));
                        break;
                    case "back":
                        sign_side = -1
                    case "front":
                        ruler.position.setZ(sign_side * (value / 2 + size.depth / 2));
                        ruler.rotation.y = Math.PI / 2;
                        break;
                }

                rulerSummary.add(ruler)
            }
        })

        angular.forEach(intersection, function (_object, id) {
            const object = _object.obj
            const distance = Math.ceil(_object.distance)
            const side = {
                leftObj: "left",
                rightObj: "right",
                topObj: "top",
                bottomObj: "bottom",
                backObj: "back",
                frontObj: "front",
            }[id]

            if (distance > 0) {
                let sub_lines = ["back", "front", "left", "right"].includes(side) ?
                    group.position.y + size.height / 2 + 100 - (-roomSize.height / 2)
                    : false
                let ruler = self.createArrowSize({
                    width: distance,
                    text: distance,
                    lineColor: "#ffde00",
                    lines: sub_lines
                });
                ruler.name = `${id}_ruler`

                if (["back", "front", "left", "right"].includes(side)) {
                    if (tabletop) {
                        ruler.position.setY(size.height / 2 + 100);

                    } else {
                        if (group.PROPS.PRODUCT.NAME.indexOf('Столешница') >= 0) { // корректировка для столешниц
                            ruler.position.setY(size.height / 2 + 150);
                        } else {
                            ruler.position.setY(size.height / 2 + 100);
                        }
                    }
                }

                let sign_side = 1;
                switch (side) {
                    case "bottom":
                        sign_side = -1
                    case "top":
                        ruler.position.setY(sign_side * (distance / 2 + size.height / 2));
                        ruler.rotation.z = Math.PI / 2;
                        ruler.position.x += 50
                        break;
                    case "left":
                        sign_side = -1
                    case "right":
                        ruler.position.setX(sign_side * (distance / 2 + size.width / 2));
                        ruler.position.z += 10
                        break;
                    case "back":
                        sign_side = -1
                    case "front":
                        ruler.position.setZ(sign_side * (distance / 2 + size.depth / 2));
                        ruler.rotation.y = Math.PI / 2;
                        ruler.position.x += 10
                        break;
                }

                rulerSummary.add(ruler)
            }
        })

        group.PROPS.RULER = rulerSummary;
        group.add(rulerSummary);
    }

    //Создание линейки для наполнения
    this.createSubelelmentsRulers = function (group, updateElementRuler = false) {
        const correctionDef = 10;
        const rulersArr = []

        let rulerSummary = new THREE.Object3D()
        rulerSummary.name = "Subelements_rulers"

        const calcRuler = (section_size, section, currentElement) => {
            const currentElementKey = +currentElement.KEY
            const sectionKey = +currentElement.SECTION

            const elementRulersSummary = new THREE.Object3D()
            elementRulersSummary.name = `Subelement_${sectionKey}_${currentElementKey}_rulers`

            let element_object = currentElement.parent ? currentElement.parent : currentElement

            const elem_position = element_object.position
            const elem_position_in_section = currentElement.POSITION || elem_position
            const size = currentElement.SIZE || element_object.SIZE || {width: 0, height: 0, depth: 0};

            let leftBorder = group.getObjectByName("PARTITION_" + (sectionKey - 1))?.["POSITION" || "position"].x + size.width / 2 || 0;

            let rightBorder = group.getObjectByName("PARTITION_" + (sectionKey + 1))?.["POSITION" || "position"].x - size.width / 2 ||
                group.PROPS.CONFIG.SIZE.width - size.width * 2;

            const section_sides = {
                left: Math.ceil(elem_position_in_section.x - size.width / 2 - leftBorder),
                right: Math.ceil(rightBorder - (elem_position_in_section.x + size.width / 2)),
                back: Math.ceil(elem_position_in_section.z - size.depth / 2 - section_size.depth),
                bottom: Math.ceil(elem_position_in_section.y),
                top: Math.ceil(section_size.height - (elem_position_in_section.y + size.height)),
                front_left: Math.ceil(elem_position_in_section.x - size.width / 2 - leftBorder),
                front_right: Math.ceil(rightBorder - (elem_position_in_section.x + size.width / 2)),
            }

            const sides = {
                left: false,
                right: false,
                top: false,
                bottom: false,
                back: false,
                front: false,
                front_left: false,
                front_right: false,
            }

            if (currentElement.TYPE === "PARTITION") {

                angular.forEach(group.PROPS.SECTIONSOBJ, function (element2, element_key2) {
                    if (element2.TYPE === "PARTITION" && sectionKey !== +element2.SECTION) {
                        const elem2_position = element2.parent?.position || element2.position
                        const elem2_position_in_section = element2.POSITION || elem2_position

                        if (elem2_position_in_section.x > elem_position_in_section.x && (!sides.right || sides.right > ((elem2_position_in_section.x - element2.SIZE.width / 2) - (elem_position_in_section.x + size.width / 2)))) {
                            sides.right = (elem2_position_in_section.x - element2.SIZE.width / 2) - (elem_position_in_section.x + size.width / 2)
                        } else if (elem2_position_in_section.x < elem_position_in_section.x && (!sides.left || sides.left > ((elem_position_in_section.x - size.width / 2) - (elem2_position_in_section.x + element2.SIZE.width / 2)))) {
                            sides.left = (elem_position_in_section.x - size.width / 2) - (elem2_position_in_section.x + element2.SIZE.width / 2)
                        }
                    }
                })

                if (!sides.left)
                    sides.left = section_sides.left

                if (!sides.right)
                    sides.right = section_sides.right
                else
                    sides.right = false

            } else if (currentElement.PRODUCT_TYPE === "vertical_shelf") {

                angular.forEach(group.PROPS.SECTIONSOBJ, function (element2, element_key2) {
                    if (element2.TYPE === "PARTITION" || element2.PRODUCT_TYPE === "vertical_shelf") {
                        const elem2_position = element2.parent?.position || element2.position
                        const elem2_position_in_section = element2.POSITION || elem2_position

                        if (elem2_position_in_section.x > elem_position_in_section.x && (!sides.front_right || sides.front_right > ((elem2_position_in_section.x - element2.SIZE.width / 2) - (elem_position_in_section.x + size.width / 2)))) {
                            sides.front_right = (elem2_position_in_section.x - element2.SIZE.width / 2) - (elem_position_in_section.x + size.width / 2)
                        } else if (elem2_position_in_section.x < elem_position_in_section.x && (!sides.front_left || sides.front_left > ((elem_position_in_section.x - size.width / 2) - (elem2_position_in_section.x + element2.SIZE.width / 2)))) {
                            sides.front_left = (elem_position_in_section.x - size.width / 2) - (elem2_position_in_section.x + element2.SIZE.width / 2)
                        }
                    }
                })

                if (!sides.front_left)
                    sides.front_left = section_sides.front_left

                if (!sides.front_right)
                    sides.front_right = section_sides.front_right

                sides.front = size.width
            } else {
                angular.forEach(section.SUBELEMENTS, function (element2, element_key2) {
                    if (element2.TYPE === "SUBELEMENT" && currentElementKey !== +element_key2) {
                        const elem2_position = element2.parent?.position || element2.position
                        const elem2_position_in_section = element2.POSITION

                        if (elem2_position.y > elem_position_in_section.y && (!sides.top || sides.top > (elem2_position.y - (elem_position_in_section.y + size.height)))) {
                            sides.top = elem2_position.y - (elem_position_in_section.y + size.height)
                        } else if (elem2_position.y < elem_position_in_section.y && (!sides.bottom || sides.bottom > (elem_position_in_section.y - (elem2_position.y + element2.SIZE.height)))) {
                            sides.bottom = elem_position_in_section.y - (elem2_position.y + element2.SIZE.height)
                        }
                    }
                })

                if (!sides.bottom)
                    sides.bottom = section_sides.bottom

                if (!sides.top)
                    sides.top = section_sides.top
                else
                    sides.top = false

                sides.front = size.height

            }

            angular.forEach(sides, function (distance, side) {
                if (distance) {
                    let sub_lines = ["left", "right"].includes(side) ? 50 :
                        ["back", "front", "front_left", "front_right"].includes(side) ? 150 : false

                    let ruler = self.createArrowSize({
                        width: distance,
                        text: distance,
                        lineColor: "green",
                        lines: sub_lines,
                    });
                    ruler.name = `${side}_ruler`

                    ruler.position.copy(elem_position)

                    if (["left", "right"].includes(side)) {
                        ruler.position.setY(size.height / 2 + 100);
                    }

                    let sign_side = 1;
                    switch (side) {
                        case "bottom":
                            sign_side = -1
                        case "top":
                            ruler.position.y += sign_side * (distance / 2 + size.height / 2);
                            ruler.rotation.z = Math.PI / 2;
                            break;
                        case "left":
                            sign_side = -1
                            ruler.position.x -= size.width
                        case "right":
                            ruler.position.x += sign_side * (distance / 2);
                            break;
                        case "front_left":
                            sign_side = -1
                            ruler.position.x -= size.width
                        case "front_right":
                            ruler.position.x += sign_side * (distance / 2);
                            ruler.position.z += (150 + size.depth / 2);

                            ruler.rotation.x = Math.PI / 2;

                            let text1 = ruler.getObjectByName("Label")
                            if (text1) {
                                text1.rotation.x = -Math.PI / 2;
                            }

                            break;
                        case "back":
                            sign_side = -1
                        case "front":
                            ruler.position.z += sign_side * (150 + size.depth / 2);
                            ruler.position.x -= sign_side * (size.width / 3);

                            ruler.rotation.z = Math.PI / 2;
                            ruler.rotation.y = Math.PI / 2;

                            let text2 = ruler.getObjectByName("Label")
                            if (text2) {
                                text2.rotation.z = -Math.PI / 2;
                                text2.rotation.x = -Math.PI / 2;
                            }

                            break;
                    }
                    elementRulersSummary.add(ruler)
                }
            })

            return elementRulersSummary
        }

        const calcSectionRulers = (section_key, section) => {

            if (!section?.SUBELEMENTS)
                return

            const section_size = self.getSectionSize(group, section_key)

            let sectionRulerSummary = new THREE.Object3D()
            sectionRulerSummary.name = `Section_${section_key}_rulers`
            sectionRulerSummary.SECTION = section_key

            angular.forEach(section.SUBELEMENTS, function (_element, key) {

                let subElName = `${_element.TYPE}_${_element.SECTION}`;
                if (_element.TYPE !== "PARTITION")
                    subElName += `_${_element.KEY}`

                let currentElement = group.getObjectByName(subElName) || group.PROPS.SECTIONSOBJ.find(item => item.id == _element.objId)
                let element_object = currentElement?.parent

                if (!element_object || !currentElement)
                    return

                if (group.PROPS.SUBELEMENTS_RULERS && element_object.PROPS?.CONFIG?.SUBRULER) {
                    self.removeObjectFromScene(element_object.PROPS.CONFIG.SUBRULER)
                    self.scene.remove(element_object.PROPS.CONFIG.SUBRULER)
                    group.remove(element_object.PROPS.CONFIG.SUBRULER)
                    group.PROPS.SUBELEMENTS_RULERS.remove(element_object.PROPS.CONFIG.SUBRULER)
                    delete element_object.PROPS.CONFIG.SUBRULER
                }


                let elem_rulers = calcRuler(section_size, section, currentElement)

                if (elem_rulers.children.length) {
                    element_object.PROPS.CONFIG.SUBRULER = elem_rulers
                    sectionRulerSummary.add(elem_rulers)
                }
            })

            if (sectionRulerSummary.children.length) {
                rulerSummary.add(sectionRulerSummary)
            }
        }

        if (updateElementRuler) {
            calcSectionRulers(updateElementRuler.SECTION, group.PROPS.CONFIG.SECTIONS[updateElementRuler.SECTION])
        } else {

            if (group.PROPS.SUBELEMENTS_RULERS) {
                group.remove(group.PROPS.SUBELEMENTS_RULERS)
                self.removeObjectFromScene(group.PROPS.SUBELEMENTS_RULERS)
                self.scene.remove(group.PROPS.SUBELEMENTS_RULERS)
                delete group.PROPS.SUBELEMENTS_RULERS
            }

            angular.forEach(group.PROPS.CONFIG.SECTIONS, function (section, section_key) {
                calcSectionRulers(+section_key, section)
            })
        }

        if (group.PROPS.SUBELEMENTS_RULERS) {

            //Переносим из уже имеющегося объекта рулеток недостающие рулетки секций в новый объект
            let tmp_array = [...group.PROPS.SUBELEMENTS_RULERS.children]
            angular.forEach(tmp_array, function (child, key) {
                let _ruler = rulerSummary.getObjectByName(child.name)

                if (!_ruler && group.PROPS.CONFIG.BASKET["SECTIONS" + child.SECTION]) {
                    rulerSummary.add(child)
                }
            })

            //Удаляем старый объект рулеток
            group.remove(group.PROPS.SUBELEMENTS_RULERS)
            self.removeObjectFromScene(group.PROPS.SUBELEMENTS_RULERS)
            self.scene.remove(group.PROPS.SUBELEMENTS_RULERS)
            delete group.PROPS.SUBELEMENTS_RULERS

            //Вставляем новый
            group.PROPS.SUBELEMENTS_RULERS = rulerSummary;
            group.add(rulerSummary);
        } else if (rulerSummary.children.length) {
            group.PROPS.SUBELEMENTS_RULERS = rulerSummary;
            group.add(rulerSummary);
        }
    }

    this.markSelected = function (hideSelected) {
        var hideSelected = hideSelected ? true : false;

        const enableSelect = (elem, multiselect = false) => {
            elem.object.parent.PROPS.FRAME.material.visible = true;
            elem.object.parent.PROPS.SECTIONFRAME.material.visible = false;

            if (!multiselect) {
                if (elem.object.parent.PROPS.RULER)
                    elem.object.parent.PROPS.RULER.visible = true

                self.scope.app.activeTab = "sub_element_settings";

                self.controlItemPosition(elem.object.parent.PROPS.WRAP, elem.object.parent.position);

                var warningSize = elem.object.parent.PROPS.FRAME.SIZE;
                self.scope.warningBox.scale.set(
                    warningSize.width,
                    warningSize.height,
                    warningSize.depth
                );
            } else {
                self.scope.app.activeTab = false;
            }
        }

        if (Array.isArray(self.scope.app.selected)) {
            self.scope.app.selected.forEach(item => enableSelect(item, true))
        } else {
            enableSelect(self.scope.app.selected)
        }

    };

    this.render = function () {
        if (self.isStop) {
            self.isStop = false;
            return false;
        }

        self.renderer.clear();
        self.renderer.render(self.scene, self.camera);
        self.renderer.clearDepth();

        if (self.scope.controlDevice) self.controls.update();

        self.controls.update();

        requestAnimationFrame(self.render);
    };

    this.remPlinth = function () {
        self.scene.remove(
            self.topPlinthLeft,
            self.topPlinthRight,
            self.topPlinthBack,
            self.bottomPlinthLeft,
            self.bottomPlinthRight,
            self.bottomPlinthBack,
            self.bottomPlinthForward,
            self.topPlinthForward
        );
    };

    this.addElementToProject = function (id, prop) {
        var group = self.createGroup(self.getProductInfo(id), prop);

        return group;
    };

    this.convertVersionProject = function (item) {
        if (item.CARTCONFIG) {
            item.BASKET = item.CARTCONFIG;
            delete item.CARTCONFIG;
        }

        if (item.TYPE != "CATALOG") {
            var PRODUCT = self.getProductInfo(item.ID)

            if (PRODUCT.moduleType && (PRODUCT.BACKWALL?.length && PRODUCT.BACKWALL?.[0]) && (!item.BASKET.BACKWALL || typeof item.BASKET.BACKWALL !== "object")) {
                var modulecolor_list = self.$filter("filterModuleColor")(PRODUCT.BACKWALL);
                item.BASKET.BACKWALL = {
                    COLOR: item.BASKET.BACKWALL || self.calcDefaultModuleColor(
                        PRODUCT,
                        modulecolor_list
                    )
                }
            }

            var CONFIG = self.createProductObject(item.ID, item);

            if (PRODUCT.moduleType) {

                let changeFilling = false
                if (PRODUCT.FILLING.length === 1 && CONFIG.BASKET.FILLING !== PRODUCT.FILLING[0]) {
                    CONFIG.BASKET.FILLING = PRODUCT.FILLING[0]
                    changeFilling = true
                } else if (CONFIG.BASKET.FILLING === null) {
                    delete CONFIG.BASKET.FILLING
                }

                if (!CONFIG.CUSTOMFILLING) {
                    CONFIG.CUSTOMFILLING = Object.assign({}, self.scope.app.FILLING[CONFIG.BASKET["FILLING"]]);
                    CONFIG.CUSTOMFILLING.VSECTION_MIN = CONFIG.CUSTOMFILLING.VSECTION_MIN || self.scope.sectionsSizes.universalModule.VSECTION_MIN;
                    CONFIG.CUSTOMFILLING.VSECTION_MAX = CONFIG.CUSTOMFILLING.VSECTION_MAX || self.scope.sectionsSizes.universalModule.VSECTION_MAX;
                    CONFIG.CUSTOMFILLING.VSECTION = 1;
                    CONFIG.CUSTOMFILLING.GROUP_SECTION = {customSect: [1], groups: [[1]]}
                    CONFIG.CUSTOMFILLING.CUSTOM = true;
                } else if (changeFilling) {
                    CONFIG.CUSTOMFILLING.ID = self.scope.app.FILLING[CONFIG.BASKET["FILLING"]].ID;
                    CONFIG.CUSTOMFILLING.MODELS = self.scope.app.FILLING[CONFIG.BASKET["FILLING"]].MODELS;
                    CONFIG.CUSTOMFILLING.NAME = self.scope.app.FILLING[CONFIG.BASKET["FILLING"]].NAME;
                    CONFIG.CUSTOMFILLING.CHANGED_FILLING = true
                }
            }

            self.controlFasade({
                PROPS: {CONFIG, PRODUCT},
            });
        }

        return CONFIG;
    };

    this.getProductInfo = function (id) {
        let info = self.scope.app.CATALOG.PRODUCTS[id]

        if (!info) {
            info = self.scope.disabledProducts[id]

            if (info?.ALTERNATIVE_PRODUCT?.[0]) {
                for (let i = 0; i < info.ALTERNATIVE_PRODUCT.length; i++) {
                    if (self.scope.app.CATALOG.PRODUCTS[info.ALTERNATIVE_PRODUCT[i]]) {
                        info = self.scope.app.CATALOG.PRODUCTS[info.ALTERNATIVE_PRODUCT[i]]
                        break;
                    }
                }
            }

        }

        if (info)
            info = Object.assign({}, info)

        return info;
    }

    this.addElementToProjectFromProp = function (item, parent) {
        if (item["TYPE"] != undefined && item.TYPE == "CATALOG") {
            var product = self.convertVersionProject(item) || item;

            if (product)
                self.addToBasket(product);
        } else {
            var product = self.getProductInfo(item.ID);
            if (!product) {
                self.scope.disabledProducts[item.ID] = false

                if (!self.scope.disabledObjectProducts[item.ID])
                    self.scope.disabledObjectProducts[item.ID] = []

                self.scope.disabledObjectProducts[item.ID].push(item)

                self.alert("Элемент ID" + item.ID + " не найден!", "warning");
                return;
            } else {
                if (item.ID != product.ID)
                    item.ID = product.ID

                var new_item = self.convertVersionProject(item);
                product = self.getProductInfo(new_item.ID)

                let group
                try {
                    group = self.addElementToProject(product.ID, new_item);
                } catch (error) {

                    if (error.group) {
                        self.alert(`Модуль ID: ${error.group.id} не был загружен, т.к. он не корректен!`, "error")
                        delete self.scope.project.items[error.group.id]
                    } else
                        throw error
                    return false;
                }

                if (group.PROPS.CONFIG.sideHiTechProfile)
                    if (group.PROPS.CONFIG.BASKET.SIDEPROFILE && Object.entries(group.PROPS.CONFIG.BASKET.SIDEPROFILE).length) {
                        self.updateSideHiTechProfile(group)
                    }

                group.QUANTITY = item.QUANTITY || 1

                self.setGroupPosition(group, {
                    position: new_item.POSITION,
                    rotation: new_item.ROTATION,
                });

                if (group.ERR)
                    self.alert(group.ERR, "warning");
                else
                    self.addToScen(group, parent);

                return group;
            }
        }
    };

    this.addToScen = function (obj, parent) {
        self.scene.add(obj);
        self.drag = true;
        self.scope.app.elements.push(obj);
        self.scope.app.elementsObj[obj.id] = obj;
        self.scope.app.wraps.push(obj.PROPS.WRAP);

        self.addToBasket(obj, parent);

        return obj.PROPS.WRAP;
    };

    this.addToBasket = function (obj, parent) {

        if (obj.TYPE != "CATALOG" && obj.PROPS != undefined) {
            const isDecor = self.scope.app.decor.filter(function (item) {
                return item === obj.PROPS.CONFIG.ID;
            });

            if (isDecor.length > 0) return false;
        }

        if (obj["TYPE"] != undefined && obj.TYPE == "CATALOG") {

            var id = obj.UID;
            self.scope.project.items[id] = obj;
            self.scope.app.basket[id] = {
                ID: self.scope.project.items[id].ID,
                PROPS: self.scope.project.items[id].BASKET,
                QUANTITY: self.scope.project.items[id].QUANTITY,
            };
        } else {
            var parent = parent || false;
            var id = obj.PID || obj.id;
            var quantity =
                self.getProductInfo(self.scope.project.items[obj.id].ID).count_in_basket ||
                obj.QUANTITY || 1;

            if ((obj.PROPS && obj.PROPS.CONFIG["TYPE"] == "SUBELEMENT" && parent) || !parent) {
                self.scope.project.items[obj.id] = obj.PROPS.CONFIG;
            }

            if (!(obj.PROPS && obj.PROPS.CONFIG["TYPE"] == "SUBELEMENT" && parent)) {
                self.scope.app.basket[id] = {
                    ID: self.scope.project.items[obj.id].ID,
                    PROPS: self.scope.project.items[obj.id].BASKET,
                    QUANTITY: quantity,
                };
            }

            if (parent) {
                self.scope.project.items[parent.id].CHILD.push(obj.id);
                self.scope.project.items[obj.id].PARENT = parent.id;
            }
        }

        //self.scope.app.basketCount++;

        self.scope.app.basketCount = Object.keys(self.scope.app.basket).length

        self.getBasketPrice();
    };

    
    let multiplicationValue = null;
    this.getBasketPrice = function (callback) {
        self.scope.app.block_cart = true;
        self.scope.$applyAsync();
        if (self.timer) {
            clearTimeout(self.timer);
        }
        callback = callback || new Function();
        if (!Object.keys(self.scope.app.basket).length && self.scope.app.oldPrice) return;
        self.calcElementsGroup();
        chrome.storage.local.get("multiplicationValue", function(data) {
            if (multiplicationValue === null) {
                if (data.multiplicationValue !== undefined) {
                    multiplicationValue = data.multiplicationValue;
                    console.log("Loaded multiplication value from storage:", multiplicationValue);
                } else {
                    console.log("Multiplication value not found in storage.");
                }
            } else {
                console.log("Using already defined multiplication value:", multiplicationValue);
            }
        });
        self.timer = setTimeout(function () {
            var data = {
                options: JSON.stringify(self.scope.project.options),
                basket: JSON.stringify(self.scope.app.basket),
                city: self.scope.project.city,
                custom_price_type: self.scope.app.SETTINGS.PRICE_TYPE_STYLE,
            };
            const facadeRanges = [
                { min: 91100011, max: 91102000, replacement: 178591 },
                { min: 91102011, max: 91103000, replacement: 38916, useMultiplikationField: false },
                { min: 91103011, max: 91104000, replacement: 5979586, multiplier: 1.4 },
                { min: 91104011, max: 91105000, replacement: 66592 },
                { min: 91105011, max: 91106000, replacement: 66592, multiplier: 5 }
            ];
            function adjustBasketItems(basket) {
                for (let itemKey in basket) {
                    if (basket.hasOwnProperty(itemKey)) {
                        let item = basket[itemKey];
                        for (let range of facadeRanges) {
                            if (range.min === 91100011 && range.max === 91102000) {
                                if (item.PROPS && item.PROPS.FASADE1) {
                                    let facadeKey = Object.keys(item.PROPS.FASADE1)[0];
                                    let facadeValue = item.PROPS.FASADE1[facadeKey];
                                    
                                    if (facadeValue >= range.min && facadeValue <= range.max) {
                                        item.PROPS.FASADE1[facadeKey] = range.replacement;
                                    }
                                }
                            } else {
                                if (item.ID >= range.min && item.ID <= range.max) {
                                    if (range.useMultiplikationField && self.scope.app.CATALOG.PRODUCTS[item.ID]?.MULTIPLIKATION) {
                                        const multiplier = self.scope.app.CATALOG.PRODUCTS[item.ID].MULTIPLIKATION;
                                        item.QUANTITY = (item.QUANTITY || 1) * multiplier;
                                    } else if (range.multiplier) {
                                        item.QUANTITY = (item.QUANTITY || 1) * range.multiplier;
                                    }
                                    item.ID = range.replacement;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            let modifiedBasket = JSON.parse(JSON.stringify(self.scope.app.basket));
            adjustBasketItems(modifiedBasket);
            let modifiedData = {
                options: JSON.stringify(self.scope.project.options),
                basket: JSON.stringify(modifiedBasket),
                city: self.scope.project.city,
                custom_price_type: self.scope.app.SETTINGS.PRICE_TYPE_STYLE,
            };
            $.ajax({
                type: "POST",
                url: self.scope.TEMPLATE_PATH + "/API/data.basket.getprice.php",
                data: modifiedData,
                dataType: "json"
            }).then(function (response) {
                let total = parseFloat(response.total.replace(/[^\d.]/g, '')) || 0;
                let finalPrice = Math.round(total * multiplicationValue);
                self.scope.app.totalprice = finalPrice + ' руб';
                self.scope.app.oldPrice = response.oldPrice;
                self.scope.$apply();
                callback();
                self.scope.app.block_cart = false;
                self.scope.$applyAsync();
            }).catch(function (error) {
                self.scope.app.block_cart = false;
                self.scope.$applyAsync();
            });
    
            self.autoSave();
        }, 500);
        return null;
    };

    this.getBasketPriceTime = function () {
        self.getBasketPrice();
        setTimeout(function () {
            self.getBasketPriceTime();
        }, 600000);
    };

    this.addProjectToBasket = function () {
        //Муртазин Э. 25.10.23 баг ангуляра, принудительно закрываю модальное окно корзины
        $("#cart").modal("hide");
        self.scope.$applyAsync();
        if (!self.scope.app.basketFrameError[0] && !self.scope.app.basketFramePropError[0]) {
            self.hendler.AddProjectToBasket(self.scope);
        } else {
            self.alert("в корзине есть не доступные товары", "error");
        }
    };

    this.Auth = function () {
        self.hendler.Auth(self.scope);
    };

    this.OpenProjects = function () {
        self.hendler.OpenProjects(self.scope);
    };

    this.OpenProject = function (id) {
        self.hendler.OpenProject(id);
    };

    this.SaveProject = function () {
        self.hendler.SaveProject(self.scope);
    };

    this.OpenSaveModal = function () {
        self.hendler.OpenSaveModal(self.scope);
    };

    this.getUserId = function () {
        self.hendler.getUserId(self.scope);
    };

    this.getProjectListData = function (callback) {
        var callback = callback || new Function();

        if (self.scope.app.projectf.user_hash) {
            var user_hash = self.scope.app.config.user_hash
                ? self.scope.app.config.user_hash
                : self.scope.app.user.idhash;
        } else {
            var user_hash = true;
        }

        var data = {
            user_hash: user_hash,
            city: self.scope.project.city,
            id: self.scope.app.projectsAllList ? self.scope.app.projectf.id : "",
            name: self.scope.app.projectsAllList ? self.scope.app.projectf.name : "",
            type: self.scope.app.projectsAllList ? "manager" : "user",
            config: self.scope.app.config.config,
            page: self.scope.app.projectListPage,
            designer: self.scope.salonOwnerSetDesign,
            salonOwner: self.scope.app.salon_owner,
        };
        $.ajax({
            type: "POST",
            url: self.scope.TEMPLATE_PATH + "/API/data.project.php",
            data: {type: "GetProjectList", data: data},
            cache: false,
            success: function (data, s) {
                if (data.type == "success") {
                    self.scope.app.projectList = data.data;
                    callback();
                } else {
                    self.alert("Ошибка загрузки", "danger");
                }
                self.scope.preloaderDesignerProject = false;
                self.scope.$applyAsync();
            },
        });
    };

    this.getData = function ($scope, $http, callback_func) {
        var data = {
            config: self.scope.app.config.config,
        };

        if (self.scope.app.config.style_id) data.style_id = self.scope.app.config.style_id;

        $.ajax({
            type: "GET",
            url: self.scope.TEMPLATE_PATH + "/API/data.get.php",
            data: data,
            dataType: "json",
            success: function (data) {
                self.scope.app = angular.extend(self.scope.app, data);
                self.scope.project = angular.extend(self.scope.project, self.scope.app.project);
                self.scope.legacy_city = self.scope.project.city =
                    self.scope.app.CITY.ID || self.scope.app.SETTINGS.city;
                self.scope.project.wall = Object.keys(self.scope.app.WALL)[0];
                self.scope.project.floor = Object.keys(self.scope.app.FLOOR)[0];
                self.scope.app.totalprice = self.getBasketPrice();
                self.scope.sectionsType = Object.keys(self.scope.app.CATALOG.SECTIONS_TYPE)[0];

                self.scope.project.handle = self.scope.app.SETTINGS.clear_hendles.VALUE;
                self.scope.project.plinthDefault = self.scope.app.SETTINGS.clear_plinth.VALUE;

                //var table = self.getDefaultTableTop();

                self.scope.project.table = self.scope.app.SETTINGS.clear_table.VALUE;
                //self.scope.project.table_color = table.table_color;

                self.scope.project.default_fasade = parseInt(
                    self.scope.app.SETTINGS.clear_fasade.VALUE
                );
                self.scope.project.default_fasade_up = self.scope.project.default_fasade_down =
                    self.getDefaultFasade();
                self.controlDefaultFasade("element_up", self.scope.project.default_fasade_up);
                self.controlDefaultFasade("element_down", self.scope.project.default_fasade_down);
                self.hendler = new window[
                    self.scope.app.config.js ? self.scope.app.config.js : "frame"
                    ]();
                self.calcDefaultProps();
                self.getBasketPriceTime();

                self.scope.$apply();
                callback_func();
            },
        });

        //self.loadFont('fonts/helvetiker', 'regular', function () {});
    };

    this.getStartPosition = function (size) {
        var position = {x: -size.width / 2, y: -size.height / 2, z: -size.depth / 2};
        return position;
    };

    this.getExec = function (obj) {
        $.each(obj, function (i, v) {
            if (i == "NAME" || i == "drawer" || i == "box_color" || i == "fasade_color") {
                obj[i] = v;
            } else {
                obj[i] = eval(v);
            }
        });
        return obj;
    };

    this.controlItemPosition = function (obj, position, intersect) {
        var intersectParent =
            intersect && intersect.PARENT != undefined ? intersect.PARENT : false;
        position.roundToZero();
        var group = obj.parent;

        var rotation = new THREE.Euler(0, 0, 0, "XYZ");
        if (group.old_rotation)
            rotation.copy(group.old_rotation);

        var pos = false;
        if (position.z == 0) {
            pos = "back";
            group.PROPS.CONFIG.ROOM_ROTATION = pos;
        } else if (
            position.z == self.scope.project.room_config.depth - 1 ||
            position.z == self.scope.project.room_config.depth
        ) {
            pos = "forward";
            group.PROPS.CONFIG.ROOM_ROTATION = pos;
        } else if (
            position.x == -(self.scope.project.room_config.width / 2) + 1 ||
            position.x == -(self.scope.project.room_config.width / 2)
        ) {
            pos = "left";
            group.PROPS.CONFIG.ROOM_ROTATION = pos;
        } else if (
            position.x == self.scope.project.room_config.width / 2 - 1 ||
            position.x == self.scope.project.room_config.width / 2
        ) {
            pos = "right";
            group.PROPS.CONFIG.ROOM_ROTATION = pos;
        } else if (
            position.y == self.scope.project.room_config.height / 2 - 1 ||
            position.y == self.scope.project.room_config.height / 2
        ) {
            pos = "top";
        } else
            pos = "bottom";

        if (group.PROPS.CONFIG.DISABLE_MOVE)
            return {
                rotation: group.rotation,
                position: group.position,
            };

        /*Контроль поворота*/
        if (group.PROPS.PRODUCT.element_type != "element_room") {
            if (pos == "left") {
                rotation.y = Math.PI / 2;
            }
            if (pos == "right") {
                rotation.y = -Math.PI / 2;
            }
            if (pos == "back") {
                rotation.y = 0;
            }
            if (pos == "forward") {
                rotation.y = Math.PI;
            }
        }

        let size = self.getMinMaxPosition(obj, position, rotation) || group.PROPS.CONFIG.SIZE;

        if (
            intersectParent &&
            self.scope.app.elementsObj[intersectParent].PROPS.PRODUCT.element_type ==
            "element_room" &&
            !self.scope.app.elementsObj[intersectParent].PROPS.CONFIG.DISABLE_RAYCAST
        ) {
            var calc = self.calcNichRotation(size, intersect, position, rotation);
            rotation = calc.rotation;
            position = calc.position;
        }

        var normY = -self.scope.project.room_config.height / 2 + size.height / 2;

        if (position.y < normY) position.y = normY;
        if (position.y > -normY) position.y = -normY;

        /*Контроль поворота*/
        var fdepth = size.depth;
        var fwidth = size.width;

        /*Контроль сталкивания*/
        var intersection = self.controlCollision(obj, position, rotation);
        /*Контроль сталкивания*/

        if (group.PROPS.PRODUCT.element_type == "element_down") {
            position.y =
                normY + (group.PROPS.PRODUCT.leg_length ? group.PROPS.PRODUCT.leg_length : 0);
        } else if (
            group.PROPS.PRODUCT.element_type == "element_room" &&
            group.PROPS.PRODUCT.substitution_height == "#ROOM_HEIGHT#"
        ) {
            position.y = 0;
        } else if (group.PROPS.PRODUCT.element_type == "element_inner") {
        } else {
            /*Примагничивание Y*/
            if (Math.abs(intersection.dragElement.maxY - intersection.Magnet.top) < 25) {
                position.setY(intersection.Magnet.top - size.height / 2);
            }
            if (Math.abs(intersection.dragElement.minY - intersection.Magnet.bottom) < 25) {
                position.setY(intersection.Magnet.bottom + size.height / 2);
            }
            /*Примагничивание Y*/
        }

        if (!group.PROPS.CONFIG.sideHiTechProfile) {
            if (rotation.y != 0 && rotation.y != Math.PI) {
                /*Примагничивание Z*/
                if (!intersection.Magnet?.rightObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.maxZ - intersection.Magnet.right) < 30) {
                    position.setZ(intersection.Magnet.right - fwidth / 2);
                }
                if (!intersection.Magnet?.leftObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.minZ - intersection.Magnet.left) < 30) {
                    position.setZ(intersection.Magnet.left + fwidth / 2);
                }
                /*Примагничивание Z*/

                /*Примагничивание X*/
                if (!intersection.Magnet?.forwardObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.minX - intersection.Magnet.forward) < 30) {
                    position.setX(intersection.Magnet.forward + fdepth / 2);
                }
                if (!intersection.Magnet?.backObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.maxX - intersection.Magnet.back) < 30) {
                    position.setX(intersection.Magnet.back - fdepth / 2);
                }
                /*Примагничивание X*/
            } else {
                /*Примагничивание X*/
                if (!intersection.Magnet?.rightObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.minX - intersection.Magnet.right) < 30) {
                    position.setX(intersection.Magnet.right + fwidth / 2);
                }
                if (!intersection.Magnet?.leftObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.maxX - intersection.Magnet.left) < 30) {
                    position.setX(intersection.Magnet.left - fwidth / 2);
                }
                /*Примагничивание X*/

                /*Примагничивание Z*/
                if (!intersection.Magnet?.forwardObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.maxZ - intersection.Magnet.forward) < 30) {
                    position.setZ(intersection.Magnet.forward - fdepth / 2);
                }
                if (!intersection.Magnet?.backObj?.PROPS.CONFIG.sideHiTechProfile && Math.abs(intersection.dragElement.minZ - intersection.Magnet.back) < 30) {
                    position.setZ(intersection.Magnet.back + fdepth / 2);
                }
                /*Примагничивание Z*/
            }
        }

        if (rotation.y != 0 && rotation.y != Math.PI) {
            var fdepth = size.width;
            var fwidth = size.depth;
        }

        if (position.z < fdepth / 2) position.z = fdepth / 2;
        if (position.z + fdepth / 2 > self.scope.project.room_config.depth)
            position.z = self.scope.project.room_config.depth - fdepth / 2;
        if (self.scope.project.room_config.width / 2 < position.x + fwidth / 2)
            position.x = self.scope.project.room_config.width / 2 - fwidth / 2;
        if (-self.scope.project.room_config.width / 2 > position.x - fwidth / 2)
            position.x = -self.scope.project.room_config.width / 2 + fwidth / 2;

        self.scope.warningBox.position.copy(position);
        self.scope.warningBox.rotation.copy(rotation);

        /*Контрольная проверка сталкивания*/
        var intersectionW = self.controlCollision(obj, position, rotation);
        /*Контрольная проверка сталкивания*/

        if (
            intersectionW.intersection.length ||
            position.y > self.scope.project.room_config.height / 2 - size.height / 2 ||
            position.y < -(self.scope.project.room_config.height / 2) + size.height / 2
        ) {
            self.scope.warningBox.visible = true;

            if (group.old_position) position.copy(group.old_position);

            if (group.old_rotation) rotation.copy(group.old_rotation);
        } else {
            self.scope.warningBox.visible = false;
        }

        self.sincRotation();

        self.createObjectPositionRulers(obj, position, rotation, pos, true)

        return {
            rotation: rotation,
            position: position,
        };
    };

    this.calcNichRotation = function (size, obj, pos, rot) {
        var parent = self.scope.app.elementsObj[obj.PARENT];

        var rotation = new THREE.Euler(
            obj.rotation.x - parent.rotation.x,
            obj.rotation.y - parent.rotation.y,
            obj.rotation.z - parent.rotation.z,
            "XYZ"
        );
        var depth = size.depth / 2;

        var posX = pos.x;
        var posY = pos.y;
        var posZ = pos.z;

        if (rotation.y == 0) {
            posZ += depth;
        } else if (rotation.y < -3) {
            posZ -= depth;
        } else if (rotation.y < -1.5) {
            posX -= depth;
        } else if (rotation.y > 0) {
            posX += depth;
        }

        var position = new THREE.Vector3(posX, posY, posZ);

        return {position: position, rotation: rotation};
    };

    this.changeFloor = function (key) {
        if (key && !self.scope.outlineType) {
            if (self.scope.app.FLOOR[key] == undefined) {
                key = Object.keys(self.scope.app.FLOOR)[0];
            }

            var floor = self.scope.app.FLOOR[key];

            var texture = self.loadFileCache(floor.texture, "img");
            self.materialFloor.map = texture;
            self.materialFloor.map.wrapS = self.materialFloor.map.wrapT = THREE.RepeatWrapping;
            self.materialFloor.map.repeat.set(
                (self.scope.project.room_config.width / 1000) * floor.scale,
                (self.scope.project.room_config.depth / 1000) * floor.scale
            );

            // отключен мешает пользователям
            // if (self.scope.app.config.show_message != false)
            // self.alert("Цвет напольного покрытия изменён");
        }
    };

    this.changeWall = function (key) {
        if (key && !self.scope.outlineType) {
            if (self.scope.app.WALL[key] == undefined) {
                key = Object.keys(self.scope.app.WALL)[0];
            }

            var wall = self.scope.app.WALL[key];

            self.materialWall.map = self.loadFileCache(wall.texture, "img");
            self.materialWall.map.wrapS = self.materialWall.map.wrapT = THREE.RepeatWrapping;
            self.materialWall.map.repeat.set(
                (self.scope.project.room_config.width / 1000) * wall.scale,
                (self.scope.project.room_config.height / 1000) * wall.scale
            );

            // отключен мешает пользователям
            // if (self.scope.app.config.show_message != false)
            //  self.alert("Цвет настенного покрытия изменён");
        }
    };

    this.changeRoomSize = function () {
        self.back.geometry = new THREE.PlaneBufferGeometry(
            self.scope.project.room_config.width,
            self.scope.project.room_config.height,
            1,
            1
        );

        self.forward.geometry = new THREE.PlaneBufferGeometry(
            self.scope.project.room_config.width,
            self.scope.project.room_config.height,
            1,
            1
        );
        self.forward.position.set(0, 0, self.scope.project.room_config.depth);

        self.right.geometry = new THREE.PlaneBufferGeometry(
            self.scope.project.room_config.depth,
            self.scope.project.room_config.height,
            1,
            1
        );
        self.right.position.set(
            self.scope.project.room_config.width / 2,
            0,
            self.scope.project.room_config.depth / 2
        );

        self.left.geometry = new THREE.PlaneBufferGeometry(
            self.scope.project.room_config.depth,
            self.scope.project.room_config.height,
            1,
            1
        );
        self.left.position.set(
            -self.scope.project.room_config.width / 2,
            0,
            self.scope.project.room_config.depth / 2
        );

        self.top.geometry = new THREE.PlaneBufferGeometry(
            self.scope.project.room_config.width,
            self.scope.project.room_config.depth,
            1,
            1
        );
        self.top.position.set(
            0,
            self.scope.project.room_config.height / 2,
            self.scope.project.room_config.depth / 2
        );

        self.bottom.geometry = new THREE.PlaneBufferGeometry(
            self.scope.project.room_config.width,
            self.scope.project.room_config.depth,
            1,
            1
        );
        self.bottom.position.set(
            0,
            -self.scope.project.room_config.height / 2,
            self.scope.project.room_config.depth / 2
        );

        self.materialWall.map.repeat.set(
            self.scope.project.room_config.width / 1000,
            self.scope.project.room_config.height / 1000
        );
        self.materialFloor.map.repeat.set(
            self.scope.project.room_config.width / 1000,
            self.scope.project.room_config.depth / 1000
        );

        self.changeRoomLine();
    };

    this.GetMillingList = function (fasadeId, productId) {


        var millingList = [];

        var PRODUCT = productId ? self.getProductInfo(productId) : false;

        //Глушка
        if (typeof fasadeId == 'object') {
            var fasadeId = fasadeId[0] || fasadeId[1][0];
        }

        if (
            self.scope.app.FASADE[fasadeId].ALT_MILLINGS[0] != undefined &&
            PRODUCT.MILLING_ALT
        ) {
            millingList = self.scope.app.FASADE[fasadeId].ALT_MILLINGS;
        } else millingList = self.scope.app.FASADE[fasadeId].ATTACH_MILLINGS;

        return millingList
            .filter(function (i) {
                if (
                    (!PRODUCT || PRODUCT.MILLING.indexOf(i) != -1) &&
                    self.scope.app.MILLING[i] != undefined
                ) {
                    return true;
                }
            })
            .sort(function (a, b) {
                return self.scope.app.MILLING[a].SORT - self.scope.app.MILLING[b].SORT;
            });


    };

    this.filterHandleSlideDoor = function (list, group) {

        if (!group || !group.PROPS.PRODUCT.HANDLES?.[0])
            return list

        var resultList = {};

        for (let handle of group.PROPS.PRODUCT.HANDLES) {
            let handle_info = self.getProductInfo(handle)
            resultList[handle] = handle
        }

        return resultList;
    };

    this.GetPatinaList = function (fasadeId, millingId) {
        var patinaList = [];

        //Глушка
        if (typeof fasadeId == 'object') {
            var fasadeId = fasadeId[0];
        }

        var fasadeId = fasadeId ? self.scope.app.FASADE[fasadeId] : false;
        var millingId = millingId ? self.scope.app.MILLING[millingId] : false;

        if (fasadeId.PATINA[0] && (!millingId || (millingId && !millingId.PATINAOFF))) {
            fasadeId.PATINA.forEach(function (v, k) {
                if (self.scope.app.PATINA[v] != undefined) patinaList.push(v);
            });
        }

        return patinaList.sort(function (a, b) {
            return self.scope.app.PATINA[a].SORT - self.scope.app.PATINA[b].SORT;
        });
    };

    this.changeFasadeSize = function (id, number) {
        var group = self.scope.app.selected.object.parent;
        group.PROPS.CONFIG.BASKET["FASADESIZE" + (number ? number : "")] = id;

        if (self.scope.app.FASADESIZE[id].SIZE_EDIT_WIDTH_MAX) {
            if (
                !self.scope.app.new_fasade_width ||
                self.scope.app.new_fasade_width <
                self.scope.app.FASADESIZE[id].SIZE_EDIT_WIDTH_MIN
            )
                self.scope.app.new_fasade_width =
                    self.scope.app.FASADESIZE[id].SIZE_EDIT_WIDTH_MIN;

            if (
                self.scope.app.new_fasade_width >
                self.scope.app.FASADESIZE[id].SIZE_EDIT_WIDTH_MAX
            )
                self.scope.app.new_fasade_width =
                    self.scope.app.FASADESIZE[id].SIZE_EDIT_WIDTH_MAX;

            group.PROPS.CONFIG.BASKET["FASADESIZEWIDTH" + (number ? number : "")] =
                self.scope.app.new_fasade_width;
            //group.PROPS.CONFIG.SIZE.width = group.PROPS.PRODUCT.width + (group.PROPS.CONFIG.BASKET['FASADESIZEWIDTH' + (number?number:'')]-self.scope.app.FASADESIZE[id].SIZE_EDIT_WIDTH_MIN);
        } else {
            delete group.PROPS.CONFIG.BASKET["FASADESIZEWIDTH" + (number ? number : "")];
        }

        self.updateElement(group);
    };

    this.getMaxSubFasadeSize = function (group, fasade_id, subfasade_id, doorKey) {

        if (!group)
            return

        const sumArray = (accumulator, value) => {
            accumulator += value;
            return accumulator;
        }

        let fasade_sizes = typeof group.PROPS.CONFIG.BASKET['FASADESIZES' + fasade_id] === "object" ? doorKey ? Object.values(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasade_id][doorKey]) :
                Object.values(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasade_id])
            : group.PROPS.CONFIG.BASKET['FASADESIZES' + fasade_id]
        let result = 0;

        if (fasade_sizes.length > 1) {
            let tmp_arr = [...fasade_sizes]
            tmp_arr.splice(subfasade_id, 1)

            let size = self.getFasadePosition(group, fasade_id, doorKey).FASADE_HEIGHT
            size = group.PROPS.CONFIG.BASKET.DOORS && !doorKey ? size : size - ((fasade_sizes.length - 1) * 4)

            result = size - tmp_arr.reduce(sumArray, 0)
        } else {
            result = self.getFasadePosition(group, fasade_id, doorKey).FASADE_HEIGHT
        }


        return result
    }

    this.checkBoxIsFasade = function (_group, fasade_id, subfasade_id, doorKey) {

        let group = _group || self.scope.app.active;

        if (group && group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasade_id]) {
            if (doorKey) {
                for (let box of Object.values(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[fasade_id]))
                    if (box.PATH === +subfasade_id)
                        return box
            } else {
                for (let box of Object.values(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[fasade_id]))
                    if (box.PATH === +subfasade_id)
                        return box
            }
        }

        return false
    }

    this.getFasadeSrc = function (fasade_id, subfasade_id, doorKey, fieldName) {

        const group = self.scope.app.active;
        const isBoxFasade = self.checkBoxIsFasade(group, fasade_id, subfasade_id, doorKey)

        let result;

        if (isBoxFasade) {
            let boxObj = group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${fasade_id}`].find(item => item.PATH == isBoxFasade.PATH)
            let box = boxObj.FASADE?.fasade || isBoxFasade.FASADE.FASADE_INFO

            if (box)
                switch (fieldName) {
                    case 'MILLING':
                        result = box['MILLING']
                        break;
                    case 'GLASS':
                        result = box['GLASS']
                        break;
                    case 'PATINA':
                        result = box['PATINA']
                        break;
                    case 'PALETTE':
                        result = box['PALETTE']
                        break;
                    case 'SHOWCASE':
                        result = box['SHOWCASE']
                        break;
                    case 'FASADETYPE':
                        result = box['FASADETYPE']
                        break;
                    case 'HANDLE':
                        result = box['HANDLE']
                        break;
                    case 'HANDLE_POSITION':
                        result = box['HANDLE_POSITION']
                        break;
                    case 'FASADE_HEIGHT':
                        result = boxObj?.FASADE?.size?.height || isBoxFasade.SIZE
                        break;
                    case "COLOR":
                        result = box['COLOR']
                        break;
                }
        } else {
            switch (fieldName) {
                case 'MILLING':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET[`MILLING${fasade_id}`]?.[doorKey]?.[subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET[`MILLING${fasade_id}`]?.[subfasade_id]
                    }
                    break;
                case 'GLASS':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET[`GLASS${fasade_id}`]?.[doorKey]?.[subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET[`GLASS${fasade_id}`]?.[subfasade_id]
                    }
                    break;
                case 'PATINA':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET[`PATINA${fasade_id}`]?.[doorKey]?.[subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET[`PATINA${fasade_id}`]?.[subfasade_id]
                    }
                    break;
                case 'PALETTE':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET[`PALETTE${fasade_id}`]?.[doorKey]?.[subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET[`PALETTE${fasade_id}`]?.[subfasade_id]
                    }
                    break;
                case 'SHOWCASE':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET[`SHOWCASE${fasade_id}`]?.[doorKey]?.[subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET[`SHOWCASE${fasade_id}`]?.[subfasade_id]
                    }
                    break;
                case 'FASADETYPE':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET[`FASADETYPE${fasade_id}`]?.[doorKey]?.[subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET[`FASADETYPE${fasade_id}`]?.[subfasade_id]
                    }
                    break;
                case 'COLOR':
                    if (doorKey) {
                        result = group.PROPS.CONFIG.BASKET.DOORS?.[fasade_id][doorKey][subfasade_id]
                    } else {
                        result = group.PROPS.CONFIG.BASKET.DOORS?.[fasade_id]?.[subfasade_id] || group.PROPS.CONFIG.BASKET['FASADE' + fasade_id][subfasade_id]
                    }
                    break;
            }
        }

        return result
    }

    this.changeFasadeHeight = function (fasade_id, subfasade_id, size, max, doorKey) {
        const group = self.scope.app.active;

        if (max && size > max) {
            size = max
        } else if (!size || size < 100) {
            size = max
        }

        size = Number(size)

        if (doorKey) {
            if (!self.scope.app.new_fasade_height[fasade_id][doorKey] || typeof self.scope.app.new_fasade_height[fasade_id][doorKey] !== "object")
                self.scope.app.new_fasade_height[fasade_id][doorKey] = {}

            self.scope.app.new_fasade_height[fasade_id][doorKey][subfasade_id] = size
        } else
            self.scope.app.new_fasade_height[fasade_id][subfasade_id] = size

        let FASADESIZES = doorKey ? group.PROPS.CONFIG.BASKET["FASADESIZES" + fasade_id][doorKey] : group.PROPS.CONFIG.BASKET["FASADESIZES" + fasade_id]
        let oldSize = FASADESIZES[subfasade_id];

        let deltaSize = size - oldSize

        if (doorKey)
            group.PROPS.CONFIG.BASKET["FASADESIZES" + fasade_id][doorKey][subfasade_id] = size;
        else
            group.PROPS.CONFIG.BASKET["FASADESIZES" + fasade_id][subfasade_id] = size;

        if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasade_id]) {

            let FASADE_POSITIONS = doorKey ? group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasade_id][doorKey] : group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasade_id]
            let AVAILABLE_FASADES = doorKey ? group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasade_id][doorKey] : group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasade_id]

            angular.forEach(AVAILABLE_FASADES, (fasade, _key) => {
                if (fasade.basket_key === subfasade_id) {
                    let key = +_key
                    fasade.size.height += deltaSize

                    if (AVAILABLE_FASADES[key + 1] && AVAILABLE_FASADES[key + 1].external_box === false) {
                        fasade.position -= deltaSize
                        FASADE_POSITIONS[fasade.basket_key] -= deltaSize

                        FASADESIZES[AVAILABLE_FASADES[key + 1].basket_key] -= deltaSize
                        AVAILABLE_FASADES[key + 1].size.height -= deltaSize
                    } else if (AVAILABLE_FASADES[key - 1] && AVAILABLE_FASADES[key - 1].external_box === false) {
                        AVAILABLE_FASADES[key - 1].position += deltaSize
                        FASADE_POSITIONS[AVAILABLE_FASADES[key - 1].basket_key] += deltaSize
                        FASADESIZES[AVAILABLE_FASADES[key - 1].basket_key] -= deltaSize
                    }
                }
            })
        }

        group.PROPS.CONFIG.recalcFasadeHeight = true
        self.updateElement(group);
    };

    this.initProductSize = function (CONFIG, product, size) {
        /*Свойство Нестандарт*/
        if (product.SIZE_EDIT == "optional") {
            angular.forEach(size, function (v, k) {
                if (product[k] != v) {
                    CONFIG.BASKET["SIZEEDIT" + k.toUpperCase()] = v;
                } else {
                    delete CONFIG.BASKET["SIZEEDIT" + k.toUpperCase()];
                }
            });
        }
        if (product.SIZE_EDIT == "obligatory") {
            angular.forEach(size, function (v, k) {
                if (self.canResizeType(product, k))
                    CONFIG.BASKET["SIZEEDIT" + k.toUpperCase()] = v;
            });
        }
        /*Свойство Нестандарт*/
    };

    this.createProductObject = function (productId, props) {
        /*(конфиг) */
        var product = self.getProductInfo(productId);

        var defProp = {
            ID: productId,
            CHILD: [],
            ALIGN: false,
            CHILDPOSITION: [],
            PARENT: false,
            HANDLES: {},
            SIZE: {
                width: product.width,
                height: product.height,
                depth: product.depth,
            },
            HANDLES_POSITION: {},
            models: [],
            FASADELIST: {},
            TYPE: "MODEL",
            DISABLE_RAYCAST: !!product.disable_raycast,
            HIDE_FASADE: false,
            DISABLE_MOVE: false,
            PATINALIST: {},
            BASKET: {},
            OPTIONLIST: {},
            PROFILELIST: false,
            USLUGILIST: false,
            USLUGISUBLIST: false,
            HEMLIST: false,
            HIDE_PROPS: [],
            SHOW_PROPS: [],
            HAVE_RASPIL: false,
            RASPILLIST: [],
            RASPILKEY: false,
            RASPILSHOW: [],
            ISSHOW: true,
            SHELFQUANT: 0,
            SECTIONS: {},
            HIDDENCHILDREN: {},
            HIDDEN: false,
            FASADE_SECTIONS: {
                COLORS: {},
                MILLINGS: {},
                PALETTES: {},
                PATINAS: {},
                BOX_FASADE: {},
                HI_TECH_PROFILES: {},
                DRAWERS_SHELVES: {},
                PARTITION: {},
                FILLING_COUNT: {},
                FASADE_POSITIONS: {},
                LOOPS: {},
                AVAILABLE_FASADES: {},
            }
        };

        var CONFIG = props || defProp;
        var PROPS = {CONFIG: CONFIG, PRODUCT: product}

        if (props == false) {
            var size = self.getProductSize(PROPS);

            this.initProductSize(CONFIG, product, size);

            /*Если есть столешница*/
            CONFIG.HAVETABLETOP =
                product.tabletop != null && self.scope.project.tabletopTypeAuto;
            /*Если есть столешница*/

            /*Нанесение цвета на корпус*/
            if (product.COLOR.length && product.COLOR[0]) {
                var color_list = self.$filter("filterColor")(self.scope.app.COLOR, {
                    product: product,
                });
                CONFIG.BASKET["COLOR"] = color_list[0].ID;
            }
            /*Нанесение цвета на корпус*/

            /*Нанесение цвета на корпус*/
            if (product.MODULECOLOR.length && product.MODULECOLOR[0]) {
                var modulecolor_list = self.$filter("filterModuleColor")(product.MODULECOLOR);
                CONFIG.BASKET["MODULECOLOR"] = self.calcDefaultModuleColor(
                    product,
                    modulecolor_list
                );
            }
            /*Нанесение цвета на корпус*/

            /*Нанесение цвета на заднюю стенку*/
            if (product.BACKWALL.length && product.BACKWALL[0]) {
                var modulecolor_list = self.$filter("filterModuleColor")(product.BACKWALL);
                CONFIG.BASKET["BACKWALL"] = {
                    COLOR: self.calcDefaultModuleColor(
                        product,
                        modulecolor_list
                    )
                }
            }
            /*Нанесение цвета на заднюю стенку*/

            /*Компоновки*/
            if (product.FILLING.length && product.FILLING[0]) {
                var filling_list = self.$filter("filterFilling")(self.scope.app.FILLING, {
                    PR: defProp,
                    ID: product.FILLING,
                });
                CONFIG.BASKET["FILLING"] = filling_list[0].ID;
            }
            /*Компоновки*/

            /*Если есть опции*/
            if (product.OPTION.length && product.OPTION[0]) {
                self.controlOptions({PROPS});
            }
            /*Если есть опции*/

            /*Если есть модель*/
            self.controlModelList({PROPS});
            /*Если есть модель*/

            /*Если есть разные размеры фасадов*/
            if (product.FASADE_SIZES[0]) {
                /*Размер фасада без номера*/
                var fasade_list = self.$filter("filterFasadeSize")(product.FASADE_SIZES, false);
                if (fasade_list[0]) {
                    CONFIG.BASKET["FASADESIZE"] = fasade_list[0][0];
                } else {
                    angular.forEach(fasade_list, function (fv, fk) {
                        CONFIG.BASKET["FASADESIZE" + fk] = fv[0];
                    });
                }
                /*Размер фасада без номера*/
            }
            /*Если есть разные размеры фасадов*/

            CONFIG.SIZE = self.getProductSize(PROPS);

            /*Если есть Фасад*/
            if (product.FACADE.length && product.FACADE[0]) {
                self.controlFasade({PROPS});
            }

            if (CONFIG.FASADELIST[1]) {
                if ([5168676, 5178415].includes(product.ID)) {
                    angular.forEach(CONFIG.FASADELIST, function (fasade, fkey) {
                        let fasadePosition = self.getFasadePosition({PROPS}, fkey)
                        const fasadeSize = [fasadePosition.FASADE_HEIGHT]
                        const fasadePositionNumber = self.calcFasadePositions(fasadeSize, CONFIG, fasadePosition)

                        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
                            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}
                        CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fkey] = fasadePositionNumber

                        if (!CONFIG.BASKET['FASADESIZES' + fkey])
                            CONFIG.BASKET['FASADESIZES' + fkey] = [fasadePosition.FASADE_HEIGHT]

                        if (!CONFIG.BASKET['FASADEWIDTH' + fkey])
                            CONFIG.BASKET['FASADEWIDTH' + fkey] = fasadePosition.FASADE_WIDTH

                    })
                } else if (product.ID !== 5171728) {
                    angular.forEach(CONFIG.FASADELIST, function (fasade, fkey) {
                        let fasadePosition = self.getFasadePosition({PROPS}, fkey)
                        const fasadeSize = [fasadePosition.FASADE_HEIGHT]
                        const fasadePositionNumber = self.calcFasadePositions(fasadeSize, CONFIG, fasadePosition)

                        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
                            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}
                        CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fkey] = fasadePositionNumber

                        if (!CONFIG.BASKET['FASADESIZES' + fkey])
                            CONFIG.BASKET['FASADESIZES' + fkey] = [fasadePosition.FASADE_HEIGHT]

                        if (!CONFIG.BASKET['FASADEWIDTH' + fkey] && product.moduleType)
                            CONFIG.BASKET['FASADEWIDTH' + fkey] = fasadePosition.FASADE_WIDTH

                        CONFIG.FASADE_SECTIONS.LOOPS[fkey] = self.calcLoopPositions(CONFIG, fasadeSize, fasadePositionNumber, fkey, product)

                        if (!CONFIG.BASKET.LOOPS)
                            CONFIG.BASKET.LOOPS = {}

                        if (product.moduleType?.CODE === "universal") {
                            CONFIG.BASKET.LOOPS[fkey] = self.convertRealToBasketLoopPos(CONFIG.FASADE_SECTIONS.LOOPS[fkey], CONFIG)

                            if (!CONFIG.BASKET.LOOPS[fkey].length)
                                delete CONFIG.BASKET.LOOPS[fkey]
                        }

                    })
                }
            }
            /*Если есть Фасад*/

            if (CONFIG.models.length) {
                self.controlModel({PROPS});
            }

        } else {
            angular.forEach(defProp, function (i, k) {
                if (props[k] == undefined) {
                    props[k] = i;
                }
            });
        }

        return CONFIG;
    };

    this.doElementlign = function (group) {
        var ret = false;

        if (group.PROPS.CONFIG.BASKET["FILLING"]) {
            let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];
            if (filling.PROP_ALIGN.VALUE) ret = filling.PROP_ALIGN.VALUE_XML_ID;
        } else if (group.PROPS.PRODUCT.FACADEALIGNSELECT == "always") {
            ret = "FASADEALIGN";
        }

        return ret;
    };

    this.getProductSize = function (PROPS, EXPRESSIONS) {
        var product = self.getProductInfo(PROPS.CONFIG.ID);
        const MODULECOLOR = self.scope.app.FASADE[PROPS?.CONFIG?.BASKET?.MODULECOLOR]?.DEPTH || 18

        PROPS.EXPRESSIONS = {
            "#MWIDTH#": product.width,
            "#MODUL_MWIDTH#": product.width,
            "#MODUL_WIDTH#": product.width,
            "#X#": product.width,
            "#MHEIGHT#": product.height,
            "#MODUL_MHEIGHT#": product.height,
            "#MODUL_HEIGHT#": product.height,
            "#Y#": product.height,
            "#MDEPTH#": product.depth,
            "#MODUL_MDEPTH#": product.depth,
            "#MODUL_DEPTH#": product.depth,
            "#Z#": product.depth,
            "#ROOM_HEIGHT#": self.scope.project.room_config.height,
            "#SIZEEDITJOINDEPTH#": product.SIZE_EDIT_JOINDEPTH_MIN,
            "#MATERIAL_THICKNESS#": MODULECOLOR
        };
        angular.forEach(PROPS.CONFIG.BASKET, function (v, k) {
            PROPS.EXPRESSIONS["#" + k + "#"] = v;
            if (k == "FASADESIZE1") {
                PROPS.EXPRESSIONS["#FASADESIZEWIDTH1#"] = self.scope.app.FASADESIZE[v].WIDTH;
                PROPS.EXPRESSIONS["#FASADESIZEDEPTH1#"] = self.scope.app.FASADESIZE[v].DEPTH;
                PROPS.EXPRESSIONS["#FASADESIZEDIFFWIDTH1#"] =
                    self.scope.app.FASADESIZE[v].DIFFWIDTH;
                PROPS.EXPRESSIONS["#FASADESIZEDIFFDEPTH1#"] =
                    self.scope.app.FASADESIZE[v].DIFFDEPTH;
            }
            if (k == "FASADESIZE2") {
                PROPS.EXPRESSIONS["#FASADESIZEWIDTH2#"] = self.scope.app.FASADESIZE[v].WIDTH;
                PROPS.EXPRESSIONS["#FASADESIZEDEPTH2#"] = self.scope.app.FASADESIZE[v].DEPTH;
                PROPS.EXPRESSIONS["#FASADESIZEDIFFWIDTH2#"] =
                    self.scope.app.FASADESIZE[v].DIFFWIDTH;
                PROPS.EXPRESSIONS["#FASADESIZEDIFFDEPTH2#"] =
                    self.scope.app.FASADESIZE[v].DIFFDEPTH;
            }
        });

        let exp = PROPS.EXPRESSIONS;

        if (EXPRESSIONS) exp = angular.extend(exp, PROPS.EXPRESSIONS);

        let depthCalc = product.SIZE_EDIT_DEPTH_MAX ? PROPS.CONFIG.SIZE.depth : product.depth;

        var size = {
            width: parseInt(PROPS.CONFIG.SIZE.width),
            height: parseInt(PROPS.CONFIG.SIZE.height),
            depth: parseInt(depthCalc),
        };

        if (product.element_type == "element_room") {
            if (product.substitution_height == "#ROOM_HEIGHT#") {
                size.height = self.scope.project.room_config.height;
            }
        }

        if (PROPS.CONFIG.MODEL) {
            var selectmodel = self.expressionsReplace(
                self.scope.app.MODELS[PROPS.CONFIG.MODEL],
                exp
            );

            if (selectmodel.width) size.width = parseInt(eval(selectmodel.width));
            if (selectmodel.height) size.height = parseInt(eval(selectmodel.height));
            if (selectmodel.depth) size.depth = parseInt(eval(selectmodel.depth));
        }

        if (!size.width) size.width = parseInt(product.width);
        if (!size.height) size.height = parseInt(product.height);
        if (!size.depth) size.depth = parseInt(product.depth);

        return size;
    };

    this.empty = function (obj) {
        for (var key in obj) {
            return false;
        }
        return true;
    };

    this.createGroup = function (product, prop, configObj, basketObj, parent) {

        if (product.moduleType?.CODE && prop?.BASKET?.OPTION && (prop.BASKET.OPTION.includes(4621238) || prop.BASKET.OPTION.includes(4621240)))
            product.leg_length = prop.BASKET.OPTION.includes(4621238) ? 100 : 150

        /* Пропсы */
        var config = self.createProductObject(
            product.ID,
            typeof prop == "object" ? prop : false
        );
        var group = new THREE.Object3D();

        if (configObj && typeof configObj == "object") {
            config = Object.assign(config, configObj);
        }

        if (basketObj && typeof basketObj == "object") {
            config.BASKET = Object.assign(config.BASKET, basketObj);
        }

        group.PROPS = {
            CONFIG: config,
            PRODUCT: product,
            FASADE: {},
            GLASS: {},
            HANDLES: {},
            TABLETOP: {},
            LEG: {},
            RASPILLIST: [],
            RASPILFRAGMENT: [],
            EXPRESSIONS: false,
            SEPARATED: [],
            DRAWERS: {},
            SECTIONSOBJ: [],
            SECTIONCONTROL: [],
            HIDDENCHILDREN: {},
            HIDDEN: false,
            PARENT_GROUP: config.PARENT_GROUP ? config.PARENT_GROUP : false,
        };

        if (group.PROPS.PRODUCT.moduleType && !group.PROPS.CONFIG.CUSTOMFILLING) {
            group.PROPS.CONFIG.CUSTOMFILLING = Object.assign({}, self.scope.app.FILLING[group.PROPS.CONFIG.BASKET["FILLING"]]);
            group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MIN = group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MIN || self.scope.sectionsSizes.universalModule.VSECTION_MIN;
            group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MAX = group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MAX || self.scope.sectionsSizes.universalModule.VSECTION_MAX;
            group.PROPS.CONFIG.CUSTOMFILLING.VSECTION = 1;
            group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION = {customSect: [1], groups: [[1]]}
            group.PROPS.CONFIG.CUSTOMFILLING.CUSTOM = true;
        }

        delete config.PARENT_GROUP

        group.ERR = false;

        // self.calcSectionsWidth(group); проверка изменения размера секции
        if (!group.PROPS.CONFIG.BASKET.SECTIONS1) {
            self.calcSectionsWidth(group);
        }
        self.controlElementUslugi(false, group);

        group.PROPS.MECHANISM = self.avalibleMechanism(group);

        self.initJoinDepth(group);

        /*Сохранение конфига в проекте*/
        if (product.element_type != "element_inner" && !configObj?.doNotAddGroupToProject)
            self.scope.project.items[group.id] = group.PROPS.CONFIG;
        /*Сохранение конфига в проекте*/

        /*Создание тела модели*/
        self.controlSize(group) //Перед созданием модели, надо обновить рассчёт размеров товара. Иначе, например, у ТуГ-ов будут неправильные размеры.

        try {
            self.createBody(group)
        } catch (error) {
            throw {error, group}
        }

        self.scope.$applyAsync();

        group.unionBoudingBox = self.calculateUnionBoundingBox(group)

        return group;
    };

    this.calculateUnionBoundingBox = function (group) {
        let boundingBox = new THREE.Box3();

        if (group.geometry) {
            group.geometry.computeBoundingBox();
            boundingBox = group.geometry.boundingBox.clone();
            if (boundingBox?.min?.length() === Infinity || boundingBox?.max?.length() === Infinity) {
                return null;
            }
        }

        for (let child of group.children) {
            let childBoundingBox = self.calculateUnionBoundingBox(child)
            if (childBoundingBox)
                boundingBox.union(childBoundingBox);
        }

        if (!group.geometry)
            group.unionBoudingBox = boundingBox

        return boundingBox;
    }

    this.calculateUnionBoundingBoxFromObject = function (group) {
        let boundingBox = new THREE.Box3();

        if (group.PROPS?.FRAME) {
            boundingBox = boundingBox.setFromObject(group.PROPS.FRAME);
            if (boundingBox.min.length() === Infinity || boundingBox.max.length() === Infinity) {
                return null;
            }
        }

        for (let child of group.children) {
            boundingBox.union(self.calculateUnionBoundingBoxFromObject(child));
        }

        return boundingBox;
    }

    this.initJoinDepth = function (group) {
        let productID = group.PROPS.CONFIG.ID
        var product = self.getProductInfo(productID);
        if (
            product.SIZE_EDIT_JOINDEPTH_MIN !=
            null &&
            product.SIZE_EDIT_JOINDEPTH_MAX !=
            null
        ) {

            var product = self.getProductInfo(group.PROPS.CONFIG.ID);

            let fasadePositionIds = product.FASADE_POSITION;

            var fasadeWidth = self.scope.app.FASADE_POSITION[fasadePositionIds[0]].FASADE_WIDTH,
                widthFrame = group.PROPS.CONFIG.SIZE.width;

            let min = product.SIZE_EDIT_JOINDEPTH_MIN,
                max = product.SIZE_EDIT_JOINDEPTH_MAX,
                joinDepth = group.PROPS.CONFIG.SIZEEDITJOINDEPTH,
                detected = false,
                conditions = self.scope.app.FASADE_POSITION[fasadePositionIds[0]].conditions;

            group.PROPS.CONFIG.MIN_JOIN_DEPTH = min;
            group.PROPS.CONFIG.MAX_JOIN_DEPTH = max;

            for (var changeMax = max; changeMax >= min; changeMax--) {
                detected = self.expressionsReplace(conditions, {
                    "#X#": widthFrame,
                    "#SIZEEDITJOINDEPTH#": changeMax,
                });
                detected = eval(detected);
                if (detected) break;
            }

            //if (group.PROPS.CONFIG.BASKET.FASADE1 == 7397) {
            //group.PROPS.CONFIG.SIZEEDITJOINDEPTH = false;
            //} else {
            if (detected) {
                if (joinDepth === undefined) {
                    const standartJoinDepth = 310
                    group.PROPS.CONFIG.SIZEEDITJOINDEPTH = min < standartJoinDepth && standartJoinDepth < max ? standartJoinDepth : min;
                }

                if (changeMax < max) {
                    group.PROPS.CONFIG.MAX_JOIN_DEPTH = changeMax;
                }

                if (changeMax < group.PROPS.CONFIG.SIZEEDITJOINDEPTH) {
                    group.PROPS.CONFIG.SIZEEDITJOINDEPTH = changeMax;
                }
            } else {
                group.PROPS.CONFIG.SIZEEDITJOINDEPTH = false;
            }
            //}
        } else {
            group.PROPS.CONFIG.SIZEEDITJOINDEPTH = false;
        }

        if (
            group.PROPS.CONFIG.SIZEEDITJOINDEPTH === undefined ||
            group.PROPS.CONFIG.SIZEEDITJOINDEPTH === false
        ) {
            delete group.PROPS.CONFIG.BASKET["SIZEEDITJOINDEPTH"];
        } else {
            let q = self.expressionsReplace(fasadeWidth, {
                "#X#": widthFrame,
                "#SIZEEDITJOINDEPTH#": group.PROPS.CONFIG.SIZEEDITJOINDEPTH,
            });
            q = eval(q);
            group.PROPS.CONFIG.FASADEWIDTH = q;
            group.PROPS.CONFIG.BASKET["SIZEEDITJOINDEPTH"] =
                group.PROPS.CONFIG.SIZEEDITJOINDEPTH;
        }
    };

    this.controlJoinDeph = function (group = false) {
        if (!self.scope.app.active)
            return

        let productID = self.scope.app.active.PROPS.CONFIG.ID
        var product = self.getProductInfo(productID);

        if (
            product.SIZE_EDIT_JOINDEPTH_MIN != null &&
            product.SIZE_EDIT_JOINDEPTH_MAX != null
        ) {

            let fasadePositionIds = product.FASADE_POSITION;
            var fasadeWidth = self.scope.app.FASADE_POSITION[fasadePositionIds[0]].FASADE_WIDTH,
                widthFrame = self.scope.app.active.PROPS.CONFIG.SIZE.width;

            let min = product.SIZE_EDIT_JOINDEPTH_MIN,
                max = product.SIZE_EDIT_JOINDEPTH_MAX,
                joinDepth = self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH,
                detected = false,
                conditions = self.scope.app.FASADE_POSITION[fasadePositionIds[0]].conditions;

            self.scope.app.active.PROPS.CONFIG.MIN_JOIN_DEPTH = min;
            self.scope.app.active.PROPS.CONFIG.MAX_JOIN_DEPTH = max;

            for (var changeMax = max; changeMax >= min; changeMax--) {
                detected = self.expressionsReplace(conditions, {
                    "#X#": widthFrame,
                    "#SIZEEDITJOINDEPTH#": changeMax,
                });
                detected = eval(detected);
                if (detected) break;
            }

            if (detected) {
                if (joinDepth === undefined) {
                    group.PROPS.CONFIG.SIZEEDITJOINDEPTH = min;
                }

                if (changeMax < max) {
                    self.scope.app.active.PROPS.CONFIG.MAX_JOIN_DEPTH = changeMax;
                }

                if (changeMax < self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH) {
                    self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH = changeMax;
                }

                if (self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH == false) {
                    self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH = min;
                }
            } else {
                self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH = false;
            }
        } else {
            self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH = false;
        }

        if (
            self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH === undefined ||
            self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH === false
        ) {
            delete self.scope.app.active.PROPS.CONFIG.BASKET["SIZEEDITJOINDEPTH"];
        } else {
            let q = self.expressionsReplace(fasadeWidth, {
                "#X#": widthFrame,
                "#SIZEEDITJOINDEPTH#": self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH,
            });
            q = eval(q);
            self.scope.app.active.PROPS.CONFIG.FASADEWIDTH = q;
            self.scope.app.active.PROPS.CONFIG.BASKET["SIZEEDITJOINDEPTH"] =
                self.scope.app.active.PROPS.CONFIG.SIZEEDITJOINDEPTH;
        }
    };

    this.getSubUslugi = function (group, key) {
        return group.PROPS.CONFIG["USLUGI" + key + "LIST"];
    };

    this.controlModelList = function (group) {
        var CONFIG = group.PROPS.CONFIG;
        var PRODUCT = group.PROPS.PRODUCT;

        if (
            !!CONFIG.BASKET["FILLING"] &&
            self.scope.app.FILLING[CONFIG.BASKET["FILLING"]].MODELS[0]
        ) {
            CONFIG.models = self.scope.app.FILLING[CONFIG.BASKET["FILLING"]].MODELS;
        } else if (PRODUCT.models.length && PRODUCT.models[0]) {
            CONFIG.models = PRODUCT.models;
        }
    };

    this.getRaspilPosition = function (group, width, key, hiddenRaspilArray) {
        var CONFIG = group.PROPS.CONFIG;
        var raspPos = CONFIG.RASPILLIST[key] ? CONFIG.RASPILLIST[key] : CONFIG.SIZE.width;
        var position = new THREE.Vector3();
        var rotation = new THREE.Euler(0, 0, 0, "XYZ");

        if (CONFIG.CHILDPOSITION[key]) {
            position.copy(CONFIG.CHILDPOSITION[key].position);
            rotation.copy(CONFIG.CHILDPOSITION[key].rotation);
        } else {
            position.copy(group.position);
            rotation.copy(group.rotation);

            if (group.rotation.y == 0) {
                position.x = position.x - CONFIG.SIZE.width / 2 + raspPos - width / 2;
            } else if (group.rotation.y > 0) {
                position.z = position.z - CONFIG.SIZE.width / 2 + raspPos - width / 2;
            } else if (group.rotation.y < 0) {
                position.z = position.z - CONFIG.SIZE.width / 2 + raspPos - width / 2;
            }
        }

        return {
            position: position,
            rotation: rotation,
        };
    };

    this.changeTableTopType = function (news) {
        angular.forEach(self.scope.app.elements, function (el) {
            if (news) {
                el.PROPS.CONFIG.HAVETABLETOP = !!el.PROPS.PRODUCT.tabletop;
            } else {
                el.PROPS.CONFIG.HAVETABLETOP = false;
            }

            self.controlTableTop(el);
        });

        self.getBasketPrice();
    };

    this.createWrap = function (group) {
        var size = self.getProductSize(group.PROPS);

        var wrap = new THREE.Mesh(
            new THREE.BoxBufferGeometry(size.width, size.height, size.depth),
            //new THREE.MeshLambertMaterial({visible: false})
            new THREE.MeshLambertMaterial({
                transparent: !0,
                color: 0xfcd303,
                opacity: 0.25,
                visible: false,
            })
        );

        var frame = new THREE.Mesh(
            new THREE.BoxBufferGeometry(size.width, size.height, size.depth),
            new THREE.MeshLambertMaterial({
                transparent: !0,
                color: 0x00ff00,
                opacity: 0.25,
                visible: false,
            })
        );

        frame.scale.multiplyScalar(1.02);

        var sectionframe = new THREE.Mesh(
            new THREE.BoxBufferGeometry(1, 1, 1),
            new THREE.MeshLambertMaterial({
                transparent: !0,
                color: 0x00ff00,
                opacity: 0.25,
                visible: false,
            })
        );
        sectionframe.scale.multiplyScalar(1.5);

        group.add(wrap, frame, sectionframe);

        group.PROPS.WRAP = wrap;
        group.PROPS.FRAME = frame;
        group.PROPS.SECTIONFRAME = sectionframe;
        group.PROPS.FRAME.SIZE = size;
    };

    this.isResize = function (product) {
        var ret =
            product != undefined &&
            (product.SIZE_EDIT ||
                product.SIZE_EDIT_DEPTH[0] ||
                product.SIZE_EDIT_DEPTH_MAX ||
                product.SIZE_EDIT_DEPTH_MIN ||
                product.SIZE_EDIT_HEIGHT[0] ||
                product.SIZE_EDIT_HEIGHT_MAX ||
                product.SIZE_EDIT_HEIGHT_MIN ||
                product.SIZE_EDIT_WIDTH[0] ||
                product.SIZE_EDIT_WIDTH_MAX ||
                product.SIZE_EDIT_WIDTH_MIN) != null;

        return ret;
    };

    this.buildLegs = function (group) {
        var product = group.PROPS.PRODUCT;

        var size = group.PROPS.CONFIG.SIZE;

        if (product.leg_length) {
            group.PROPS.LEG = group.PROPS.LEG || {};

            var start_position = self.getStartPosition(size);

            if (self.scope.app.MODELS[self.scope.project.items[group.id].MODEL] != undefined)
                var model = self.expressionsReplace(
                    self.scope.app.MODELS[group.PROPS.CONFIG.MODEL],
                    group.PROPS.EXPRESSIONS
                );

            if (self.haveLeg(group)) {
                var leg_position =
                    self.scope.app.MODELS[self.scope.project.items[group.id].MODEL].json.legs;
            } else {
                if (model) {

                    var model = self.scope.app.MODELS[self.scope.project.items[group.id].MODEL];
                    model = self.expressionsReplace(
                        self.scope.app.MODELS[group.PROPS.CONFIG.MODEL],
                        group.PROPS.EXPRESSIONS
                    );
                    start_position.x += eval(model.corr_x);
                    start_position.y += eval(model.corr_y);
                    start_position.z += eval(model.corr_z);
                }

                var leg_position = {
                    1: {x: start_position.x + 70, y: start_position.y, z: start_position.z + 70},
                    2: {
                        x: start_position.x + size.width - 70,
                        y: start_position.y,
                        z: start_position.z + 70,
                    },
                    3: {
                        x: start_position.x + size.width - 70,
                        y: start_position.y,
                        z: start_position.z + size.depth - 70,
                    },
                    4: {
                        x: start_position.x + 70,
                        y: start_position.y,
                        z: start_position.z + size.depth - 70,
                    },
                };
                // если 6 ног Колесниченко М. 25.09.23
                if (self.scope.app.MODELS[self.scope.project.items[group.id].MODEL].json.sixLegs) {
                    leg_position["5"] = {
                        x: start_position.x + size.width / 2,
                        y: start_position.y,
                        z: start_position.z + 70,
                    };
                    leg_position["6"] = {
                        x: start_position.x + size.width / 2,
                        y: start_position.y,
                        z: start_position.z + size.depth - 70,
                    };
                }
                // если 6 ног Колесниченко М. 25.09.23
            }

            angular.forEach(leg_position, function (v, i) {
                if (group.PROPS.LEG[i]) {
                    self.removeEdgeFromElement(group.PROPS.LEG[i]);
                    group.remove(group.PROPS.LEG[i]);
                }

                var leg_length = product.leg_length;
                var leg = self.createLeg(leg_length);
                leg.position.set(v.x, v.y, v.z);

                if (model && model.corr_z) leg.position.z += parseInt(eval(model.corr_z));

                group.PROPS.LEG[i] = leg;
                group.add(leg);
            });
        } else if (group.PROPS.LEG?.[1]) {
            angular.forEach(group.PROPS.LEG, function (leg, i) {
                self.removeEdgeFromElement(group.PROPS.LEG[i]);
                group.remove(group.PROPS.LEG[i]);
            });
        }
    };

    this.haveLeg = function (group) {
        var product = group.PROPS.PRODUCT;
        return (
            product.models.length &&
            self.scope.app.MODELS[self.scope.project.items[group.id].MODEL] != undefined &&
            self.scope.app.MODELS[self.scope.project.items[group.id].MODEL].json.legs !=
            undefined
        );
    };

    this.havePlinth = function (group) {
        var product = group.PROPS.PRODUCT;
        return (
            product.models.length &&
            self.scope.app.MODELS[self.scope.project.items[group.id].MODEL] != undefined &&
            self.scope.app.MODELS[self.scope.project.items[group.id].MODEL].json.plinth !=
            undefined
        );
    };

    this.setFasadePosition = function (obj, fasade_conf, type, group, start_position) {
        if (obj === false) {
            $.each(group.PROPS.FASADE, function (i, obj) {
                self.setFasadePositionEx(
                    obj,
                    group.PROPS.CONFIG.FASADELIST[i],
                    type,
                    group,
                    start_position
                );
            });
        } else {
            self.setFasadePositionEx(obj, fasade_conf, type, group, start_position);
        }
    };

    this.setFasadePositionEx = function (obj, fasade_conf, type, group, start_position) {
        obj.rotation.x = 0;
        obj.rotation.y = 0;
        obj.rotation.z = 0;

        if (type == "left") {
            obj.rotation.y = fasade_conf.ROTATE_Y ? (-fasade_conf.ROTATE_Y * Math.PI) / 180 : 0;
            obj.rotation.z = fasade_conf.ROTATE_Z ? (-fasade_conf.ROTATE_Z * Math.PI) / 180 : 0;
            obj.rotation.x = fasade_conf.ROTATE_X ? (-fasade_conf.ROTATE_X * Math.PI) / 180 : 0;
        } else if (type == "right") {
            if (fasade_conf.ROTATE_2_Y)
                obj.rotation.y = (-fasade_conf.ROTATE_2_Y * Math.PI) / 180;
            else if (fasade_conf.ROTATE_Y)
                obj.rotation.y = (-fasade_conf.ROTATE_Y * Math.PI) / 180;

            if (fasade_conf.ROTATE_2_X)
                obj.rotation.x = (-fasade_conf.ROTATE_2_X * Math.PI) / 180;
            else if (fasade_conf.ROTATE_X)
                obj.rotation.x = (-fasade_conf.ROTATE_X * Math.PI) / 180;

            if (fasade_conf.ROTATE_2_Z)
                obj.rotation.z = (-fasade_conf.ROTATE_2_Z * Math.PI) / 180;
            else if (fasade_conf.ROTATE_Z)
                obj.rotation.z = (-fasade_conf.ROTATE_Z * Math.PI) / 180;
        } else {
            obj.rotation.y = fasade_conf.ROTATE_Y ? (fasade_conf.ROTATE_Y * Math.PI) / 180 : 0;
            obj.rotation.z = fasade_conf.ROTATE_Z ? (fasade_conf.ROTATE_Z * Math.PI) / 180 : 0;
            obj.rotation.x = fasade_conf.ROTATE_X ? (fasade_conf.ROTATE_X * Math.PI) / 180 : 0;
        }

        if (
            group.PROPS.CONFIG.MODEL &&
            self.scope.app.MODELS[group.PROPS.CONFIG.MODEL].type == "right"
        ) {
            var posx =
                fasade_conf.POSITION_2_X != null
                    ? fasade_conf.POSITION_2_X
                    : fasade_conf.POSITION_X;
            var posy =
                fasade_conf.POSITION_2_Y != null
                    ? fasade_conf.POSITION_2_Y
                    : fasade_conf.POSITION_Y;
            var posz =
                fasade_conf.POSITION_2_Z != null
                    ? fasade_conf.POSITION_2_Z
                    : fasade_conf.POSITION_Z;
        } else {
            var posx = fasade_conf.POSITION_X;
            var posy = fasade_conf.POSITION_Y;
            var posz = fasade_conf.POSITION_Z;
        }

        posx = start_position.x + fasade_conf.FASADE_WIDTH / 2 + posx;
        posy = start_position.y + fasade_conf.FASADE_HEIGHT / 2 + posy;
        posz = start_position.z + posz;

        obj.position.set(posx, posy, posz);
    };

    this.createGlobalLight = function () {
        self.light = new THREE.Group();

        if (!self.scope.outlineType) {
            self.renderer.shadowMap.enabled = true;
            self.pointLight = new THREE.PointLight(
                0xffffff,
                self.scope.project.poitlightIntensive
            );
            self.pointLight.distance = self.scope.project.room_config.height * 6;
            self.pointLight.position.set(
                self.scope.project.room_config.width / 4,
                self.scope.project.room_config.height / 2,
                self.scope.project.room_config.depth / 2
            );

            if (self.scope.project.shadowQuality && !self.System.mobile) {
                self.renderer.shadowMap.type = THREE.PCFSoftShadowMap;
                self.pointLight.castShadow = true;
                self.pointLight.shadow.bias = 0.0001;
                self.pointLight.shadow.camera.near = 0.5;
                self.pointLight.shadow.camera.far = self.scope.project.room_config.height * 2;

                self.pointLight.shadow.mapSize = new THREE.Vector2(
                    self.scope.app.shadowQualityList[self.scope.project.shadowQuality].val,
                    self.scope.app.shadowQualityList[self.scope.project.shadowQuality].val
                );
            } else {
                self.renderer.shadowMap.enabled = false;
            }

            self.light.add(self.pointLight);
            self.pointLight2 = self.pointLight.clone();
            self.pointLight2.position.setX(-self.scope.project.room_config.width / 4);
            self.light.add(self.pointLight2);

            self.globaLight = new THREE.HemisphereLight(
                0xffffff,
                0x666666,
                self.scope.project.lightIntensive
            );
        } else {
            self.globaLight = new THREE.AmbientLight(0xffffff, 1);
        }

        self.globaLight.castShadow = false;

        self.light.add(self.globaLight);

        self.scene.add(self.light);
    };

    this.changelightIntensive = function (news) {
        if (news) {
            self.globaLight.intensity = news;
        }
    };

    this.changePointlightIntensive = function (news) {
        if (news) {
            self.pointLight2.intensity = self.pointLight.intensity = news;
            self.pointLight.intensity = self.pointLight.intensity = news;
        }
    };

    this.copyElement = function () {
        if (self.scope.app.active) {
            self.scope.app.newElementProps = JSON.parse(
                JSON.stringify(self.scope.app.active.PROPS.CONFIG)
            );
            self.scope.app.newElement = self.scope.app.active.PROPS.PRODUCT;

            if (self.scope.app.newElementProps.BASKET)   //Скопированные элементы не должны сохранять группу фасадов
                delete self.scope.app.newElementProps.BASKET.GROUP

            self.alert("Товар скопирован", "success");
        }
    };

    this.createDrawer = function (group, fasadePosition, start_position_facade) {
        var widthCorection = 50;
        var bottomIndentation = "28";
        let wallThickness = 16;

        if (self.scope.app.MODELS[2929883].wall_thickness) {
            wallThickness;
        }

        var drawer = fasadePosition.drawer.split("_");

        var size = self.getProductSize(group.PROPS, group.PROPS.EXPRESSIONS);

        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        var buildInDrawer = {
            material: {
                type: "MeshPhysicalMaterial",
                opt: {color: 0x3d3a3b, transparent: true, opacity: 0.8},
            },
            items: [
                {
                    id: "bottom",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: "#DRAWWIDTH#-32", y: 16, z: "#DRAWDEPTH#"},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: 0, y: "(-#DRAWHEIGHT#/2)+32+" + bottomIndentation, z: "-16"},
                },
                {
                    id: "leftbox",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: 16, y: "#DRAWHEIGHT#-8-" + widthCorection, z: "#DRAWDEPTH#"},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: "(-#DRAWWIDTH#/2)+8", y: bottomIndentation, z: `-${fasadeThickness}`},
                },
                {
                    id: "rightbox",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: 16, y: "#DRAWHEIGHT#-8-" + widthCorection, z: "#DRAWDEPTH#"},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: "(#DRAWWIDTH#/2)-8", y: bottomIndentation, z: `-${fasadeThickness}`},
                },
                {
                    id: "back",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: "#DRAWWIDTH#-32", y: "#DRAWHEIGHT#-4-" + widthCorection, z: 8},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: 0, y: bottomIndentation, z: "(-#DRAWDEPTH#/2)-4"},
                },
            ],
        };

        var standartDrawer = {
            material: {
                type: "MeshPhysicalMaterial",
                opt: {color: 0x3d3a3b, transparent: true, opacity: 0.8},
            },
            items: [
                {
                    id: "bottom",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: "#DRAWWIDTH#-32", y: 16, z: "#DRAWDEPTH#"},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: 0, y: "(-#DRAWHEIGHT#/2)+8", z: 0},
                },
                {
                    id: "leftbox",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: 16, y: "#DRAWHEIGHT#", z: "#DRAWDEPTH#"},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: "(-#DRAWWIDTH#/2)+8", y: 0, z: 0},
                },
                {
                    id: "rightbox",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: 16, y: "#DRAWHEIGHT#", z: "#DRAWDEPTH#"},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: "(#DRAWWIDTH#/2)-8", y: 0, z: 0},
                },
                {
                    id: "back",
                    type: "object",
                    geometry: {
                        type: "BoxGeometry",
                        opt: {x: "#DRAWWIDTH#-32", y: "#DRAWHEIGHT#-16", z: 8},
                    },
                    rotation: {x: 0, y: 0, z: 0},
                    position: {x: 0, y: "8", z: "(-#DRAWDEPTH#/2)+8"},
                },
            ],
        };

        var json = fasadePosition.built_in === 1 ? buildInDrawer : standartDrawer;

        group.PROPS.EXPRESSIONS["#DRAWHEIGHT#"] = drawer[1];
        group.PROPS.EXPRESSIONS["#DRAWWIDTH#"] = fasadePosition.FASADE_WIDTH - group.PROPS.EXPRESSIONS["#MATERIAL_THICKNESS#"] * 2; //group.PROPS.CONFIG.SIZE.width - widthCorection;
        group.PROPS.EXPRESSIONS["#DRAWDEPTH#"] =
            group.PROPS.CONFIG.SIZE.depth - widthCorection;
        group.PROPS.EXPRESSIONS["#X#"] = group.PROPS.CONFIG.SIZE.width;

        var conf = self.expressionsReplace(json, group.PROPS.EXPRESSIONS);

        var model = self.createModelFromJson(conf);

        model.position.x =
            start_position_facade.x + fasadePosition.POSITION_X + group.PROPS.EXPRESSIONS["#DRAWWIDTH#"] / 2 + group.PROPS.EXPRESSIONS["#MATERIAL_THICKNESS#"];
        model.position.y =
            start_position_facade.y + fasadePosition.POSITION_Y + drawer[1] / 2 + 10;
        model.position.z =
            start_position_facade.z + fasadePosition.POSITION_Z - (size.depth - 50) / 2;

        group.PROPS.DRAWERS[fasadePosition.FASADE_NUMBER] = model;
        group.add(model);
    };

    this.checkFasadesCount = function () {
        const group = self.scope.app.active

        if (group && group.PROPS?.FASADE)
            return Object.keys(group.PROPS.FASADE).length
        else
            return 0
    }

    this.createFasade = function (fasadePosition, start_position, fasade_id, group, basket_key, isPhantom, itsBoxFasade, doorId) {

        let hide_slide_door = false
        var fasade_color = self.scope.app.FASADE[fasade_id];
        fasadePosition.FASADE_DEPTH = fasade_color?.DEPTH || fasadePosition.FASADE_DEPTH

        if (fasade_id === self.scope.fasadeErrorColor)
            isPhantom = true;

        if ([5168676, 5178415].includes(group.PROPS.PRODUCT.ID) && group.PROPS.CONFIG.HIDE_FASADE) {
            isPhantom = true
            hide_slide_door = true
        }

        var start_position_facade = Object.assign({}, start_position);
        var product = group.PROPS.PRODUCT;

        var model = fasadePosition.FASADE_MODEL ? fasadePosition.FASADE_MODEL : false;
        let geometryHeight = fasadePosition.FASADE_HEIGHT
        if (!itsBoxFasade && typeof basket_key !== 'undefined' && group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadePosition.FASADE_NUMBER]) {
            geometryHeight = group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadePosition.FASADE_NUMBER]?.[doorId]?.[basket_key] || group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadePosition.FASADE_NUMBER][basket_key]
        }
        //Если прозрачный фасад меньше 10мм
        if (geometryHeight < 10) return

        var geometryConfig = {
            x: fasadePosition.FASADE_WIDTH,
            y: geometryHeight,
            z: fasade_color?.DEPTH || fasadePosition.FASADE_DEPTH,   //брать толщину фасада из его материала
            bevelEnabled: true,
        };

        if (fasade_color == undefined) return new THREE.Object3D();

        if (fasade_color["EDGE_COLOR"] || fasade_color["EDGE_TEXTURE"]) {
            geometryConfig.material = 0;
            geometryConfig.extrudeMaterial = 1;
        }


        /*Создание материала*/
        var allmaterial = self.getMaterials(fasade_color, fasadePosition, group, basket_key, doorId, false, itsBoxFasade);
        var geometry = self.ExtrudeBoxGeometry(geometryConfig);

        if (isPhantom) {
            /* Доступные фасады. Рисуется тоже фасадами. Но со своими параметрами*/
            let color = 0x00ff00

            if (itsBoxFasade || hide_slide_door) {
                //Голубой цвет у фасадов для ящика и дверей-купе
                color = 0x1E90FF
            } else if (fasade_id === self.scope.fasadeErrorColor) {
                color = fasade_color.COLOR  //красный цвет у недоступных фасадов
            }

            allmaterial = new THREE.MeshBasicMaterial({color: color, opacity: 0.3})
            allmaterial.transparent = true
        }
        if (Array.isArray(allmaterial)) {
            if (allmaterial[0].map) {
                allmaterial[0].map.wrapS = allmaterial[0].map.wrapT = THREE.RepeatWrapping;
                allmaterial[0].map.repeat.set(
                    1 / fasade_color.TEXTURE_WIDTH,
                    1 / fasade_color.TEXTURE_HEIGHT
                );
                allmaterial[0].map.offset.set(0.5, 0.5);
            }
        } else if (allmaterial.map) {
            // если фасад угол

            allmaterial.map.wrapS = allmaterial.map.wrapT = THREE.RepeatWrapping;
            allmaterial.map.repeat.set(
                1 / fasade_color.TEXTURE_WIDTH,
                1 / fasade_color.TEXTURE_HEIGHT
            );
            allmaterial.map.offset.set(0.5, 0.5);
        }
        /*Создание материала*/

        /*Если указан тип - без фасада или доступные фасады*/
        if ((fasade_color.TYPE == "no_fasade" || group.PROPS.CONFIG.HIDE_FASADE)) {
            if (isPhantom) {
                var obj = new THREE.Mesh(geometry, allmaterial);
                obj.visible = true;
            } else {
                var obj = new THREE.Mesh(geometry, allmaterial);
                obj.visible = false;
            }
        } else if (
            (doorId && self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[doorId]?.[basket_key]]) ||
            (!doorId &&
                (typeof group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] === "object" && self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[basket_key]] ||
                    typeof group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] !== "object" && self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]])
            )
        ) {

            var glassConf =
                self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[doorId]?.[basket_key]] ||
                self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[basket_key]] ||
                self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]];

            if (glassConf) {
                /*Получаем тип модели*/

                if (fasade_color.MODEL) {
                    var model_id = fasade_color.MODEL;
                } else {
                    var prefabricated_model =
                        fasade_color.TYPE == "made" ? "model_vitrin_prefabricated" : "model_vitrin";
                    var model_id = self.scope.app.SETTINGS[prefabricated_model].VALUE;
                }

                var model = self.scope.app.MODELS[model_id].json;
                model.color = fasade_color;
                var obj = self.createFasadeFromModel(model, geometryConfig, fasadePosition, group);

                /*Рисуем стекло*/

                var glass = self.createGlass(glassConf, fasadePosition, model);
                if (model) {
                    if (model.items) {
                        const glassWidth = 5;
                        if (model.items.backbottomhorizontal) {
                            const fasadeLeftHeight = Number(model.items.leftvertical.geometry.opt.z);

                            glass.position.set(0, 0, fasadeLeftHeight - glassWidth / 2);
                        } else if (model.glassPosCorrection) {
                            const glassXCorr = model.glassPosCorrection.x;
                            const glassYCorr = model.glassPosCorrection.y;
                            const glassZCorr = model.glassPosCorrection.z;
                            glass.position.set(glassXCorr, glassYCorr, glassZCorr + glassWidth / 2);
                        }
                    }
                } else {
                    glass.position.set(0, 0, 0);
                }
                glass.PROPS = glassConf;

                if (self.scope.app.GLASS[group.PROPS.CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[basket_key]]) {
                    if (!group.PROPS.GLASS[fasadePosition.FASADE_NUMBER])
                        group.PROPS.GLASS[fasadePosition.FASADE_NUMBER] = {}

                    if (doorId) {
                        if (!group.PROPS.GLASS[fasadePosition.FASADE_NUMBER][doorId])
                            group.PROPS.GLASS[fasadePosition.FASADE_NUMBER][doorId] = {}

                        group.PROPS.GLASS[fasadePosition.FASADE_NUMBER][doorId][basket_key] = glass;
                    } else
                        group.PROPS.GLASS[fasadePosition.FASADE_NUMBER][basket_key] = glass;

                } else
                    group.PROPS.GLASS[fasadePosition.FASADE_NUMBER] = glass;

                obj.add(glass);
                /*Рисуем стекло*/

                if (group.PROPS.CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]) {
                    let showcase = self.scope.app.SHOWCASE[doorId ? group.PROPS.CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER][doorId][basket_key] :
                        group.PROPS.CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER][basket_key]]

                    if (showcase?.CODE == 4) {
                        let gor = new THREE.Mesh(
                            new THREE.BoxBufferGeometry(geometryConfig.x - 60, 16, 8),
                            allmaterial
                        );
                        gor.position.set(0, 0, 5);
                        obj.add(gor);

                        let vert = new THREE.Mesh(
                            new THREE.BoxBufferGeometry(16, geometryConfig.y - 60, 8),
                            allmaterial
                        );
                        vert.position.set(0, 0, 5);
                        obj.add(vert);
                    }
                    if (showcase?.CODE == 6) {
                        let pos = (geometryConfig.y - 100) / 2 - (geometryConfig.y - 100) / 3;
                        let gor = new THREE.Mesh(
                            new THREE.BoxBufferGeometry(geometryConfig.x - 60, 16, 8),
                            allmaterial
                        );
                        gor.position.set(0, pos, 5);
                        obj.add(gor);

                        let gor2 = new THREE.Mesh(
                            new THREE.BoxBufferGeometry(geometryConfig.x - 60, 16, 8),
                            allmaterial
                        );
                        gor2.position.set(0, -pos, 5);
                        obj.add(gor2);

                        let vert = new THREE.Mesh(
                            new THREE.BoxBufferGeometry(16, geometryConfig.y - 60, 8),
                            allmaterial
                        );
                        vert.position.set(0, 0, 5);
                        obj.add(vert);
                    }
                }

            }

            /*Если фасад сборный*/
        } else if (fasade_color.TYPE == "made") {
            /*Получаем тип модели*/
            var prefabricated_model =
                fasadePosition.FASADE_WIDTH < 200
                    ? "prefabricated_model_minwidth"
                    : fasadePosition.FASADE_HEIGHT < 200
                        ? "prefabricated_model_minheight"
                        : "prefabricated_model";
            var model =
                self.scope.app.MODELS[self.scope.app.SETTINGS[prefabricated_model].VALUE].json;
            model.color = fasade_color;
            var obj = self.createFasadeFromModel(model, geometryConfig, fasadePosition, group);

            /*Если обычный фасад*/
        } else if (model) {
            var model_facade = self.scope.app.MODELS[model].json;
            model_facade.color = fasade_color;
            var obj = self.createFasadeFromModel(
                model_facade,
                geometryConfig,
                fasadePosition,
                group
            );

            if (isPhantom) {
                const changeOpacity = (obj) => {
                    if (obj.material) {
                        if (Array.isArray(obj.material))
                            obj.material.map(item => {
                                item.opacity = 0.3
                                item.transparent = true
                            })
                        else {
                            obj.material.opacity = 0.3
                            obj.material.transparent = true
                        }
                    }

                    for (let child of obj.children)
                        changeOpacity(child)
                }

                changeOpacity(obj)
            }

        } else {

            if (Array.isArray(allmaterial)) {
                self.CreateFasadeKant(geometry);
                var obj = new THREE.Mesh(geometry, allmaterial);
            } else
                var obj = new THREE.Mesh(geometry, allmaterial);

            if (self.scope.outlineType) {
                obj.material = new THREE.MeshPhongMaterial({
                    transparent: !0,
                    color: 0x0000ff,
                    opacity: 0.25,
                });
                self.createEdge(obj);
            } else {
                self.createEdge(obj, false, true);
            }
        }

        self.preFabricateFasadeModel(obj, group, fasadePosition, fasade_id, basket_key, doorId);

        self.setFasadePosition(
            obj,
            fasadePosition,
            group.PROPS.CONFIG.MODEL != undefined
                ? self.scope.app.MODELS[group.PROPS.CONFIG.MODEL].type
                : "left",
            group,
            start_position_facade
        );

        if (!isPhantom && !itsBoxFasade) {
            let realFasadePosition = obj.position.x - start_position_facade.x //Math.floor(obj.position.x - start_position_facade.x)

            if (!group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`])
                group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`] = {}

            if (doorId) {
                if (!group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`][doorId] ||
                    typeof group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`][doorId] === "number")
                    group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`][doorId] = {}

                group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`][doorId][basket_key] = realFasadePosition
            } else {
                group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${fasadePosition.FASADE_NUMBER}`][basket_key] = realFasadePosition
            }
        }

        /*если есть возможность добавить ручку*/
        const setHandle = (key) => {
            if (
                self.scope.app.POSITION_HANDLES[fasadePosition.PRODUCT] &&
                self.scope.app.POSITION_HANDLES[fasadePosition.PRODUCT][group.PROPS.PRODUCT.moduleType ? 1 : fasadePosition.FASADE_NUMBER]
            ) {
                const objHandles = doorId ? group.PROPS.CONFIG.HANDLES[fasadePosition.FASADE_NUMBER]?.[doorId] : group.PROPS.CONFIG.HANDLES[fasadePosition.FASADE_NUMBER];
                var handle = objHandles && typeof objHandles === "object" ? objHandles[key] : objHandles || self.scope.project.handle;
                var productHandle = self.getProductInfo(handle);

                if (productHandle == undefined) {
                    var handle_list = Object.keys(self.scope.app.HANDLES);

                    if (handle_list.length)
                        handle = Object.keys(self.scope.app.HANDLES)[0];
                    else
                        handle = false;
                }

                /*проверяем на значение - без ручки*/
                var no_handle =
                    handle == self.scope.app.SETTINGS.clear_hendles.VALUE ||
                    fasade_color.TYPE == "no_fasade" ||
                    !handle;

                /*Если есть прорисованная ручка - удаляем*/
                if ((doorId && group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]?.[doorId]) || (!doorId && group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER])) {
                    self.removeHandle(group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]?.[doorId]?.[key]?.id ||
                        group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]?.[key]?.id ||
                        group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER].id);
                }

                const HANDLES_POSITION = doorId ? group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER]?.[doorId] : group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER]
                /*Если ручка назначена*/
                if (!no_handle) {
                    if (
                        (HANDLES_POSITION?.[key] == undefined || HANDLES_POSITION == undefined) &&
                        self.scope.app.POSITION_HANDLES[fasadePosition.PRODUCT][group.PROPS.PRODUCT.moduleType ? 1 : fasadePosition.FASADE_NUMBER].POSITION_X2
                    ) {
                        if (group.PROPS.PRODUCT.moduleType) {
                            if (!group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER])
                                group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER] = {}

                            if (doorId && !group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER][doorId])
                                group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER][doorId] = {}

                            if (doorId && !group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER][doorId][key]) {
                                group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER][doorId][key] = "left";
                            } else if (!doorId && !group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER][key]) {
                                group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER][key] = "left";
                            }
                        } else {
                            group.PROPS.CONFIG.HANDLES_POSITION[fasadePosition.FASADE_NUMBER] = "left";
                        }
                    }

                    if (group.PROPS.PRODUCT.moduleType?.CODE === "wardrobe") {
                        if (!group.PROPS.CONFIG.HANDLES_SIZE)
                            group.PROPS.CONFIG.HANDLES_SIZE = {}

                        if (!group.PROPS.CONFIG.HANDLES_SIZE[fasadePosition.FASADE_NUMBER])
                            group.PROPS.CONFIG.HANDLES_SIZE[fasadePosition.FASADE_NUMBER] = {}

                        if (doorId && !group.PROPS.CONFIG.HANDLES_SIZE[fasadePosition.FASADE_NUMBER][doorId])
                            group.PROPS.CONFIG.HANDLES_SIZE[fasadePosition.FASADE_NUMBER][doorId] = {}

                        if (doorId) {
                            group.PROPS.CONFIG.HANDLES_SIZE[fasadePosition.FASADE_NUMBER][doorId][key] = fasadePosition.FASADE_HEIGHT;
                        } else {
                            group.PROPS.CONFIG.HANDLES_SIZE[fasadePosition.FASADE_NUMBER][key] = fasadePosition.FASADE_HEIGHT;
                        }

                    }

                    group.PROPS.HANDLES_POSITION = self.scope.project.items[group.id].HANDLES_POSITION;

                    let _fasadePosition = Object.assign({}, fasadePosition)

                    if (group.PROPS.PRODUCT.moduleType) {
                        if (!group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER])
                            group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER] = {}

                        if (doorId && !group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][doorId])
                            group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][doorId] = {}

                        if (group.PROPS.PRODUCT.HANDLES?.[0] && !group.PROPS.PRODUCT.HANDLES.includes(handle))
                            return

                        if (doorId) {
                            group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][doorId][key] = self.addHandle(
                                handle,
                                _fasadePosition,
                                obj,
                                group,
                                key,
                                doorId
                            );
                        } else {
                            group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][key] = self.addHandle(
                                handle,
                                _fasadePosition,
                                obj,
                                group,
                                key
                            );
                        }


                    } else
                        group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER] = self.addHandle(
                            handle,
                            _fasadePosition,
                            obj,
                            group
                        );
                } else {
                    if (group.PROPS.PRODUCT.moduleType && group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]) {
                        if (doorId)
                            delete group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]?.[doorId]?.[key];
                        else
                            delete group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][key];

                        if (doorId && group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]?.[doorId] && Object.keys(group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][doorId]).length == 0)
                            delete group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER][doorId];
                        if (Object.keys(group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER]).length == 0)
                            delete group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER];
                    } else
                        delete group.PROPS.HANDLES[fasadePosition.FASADE_NUMBER];
                }
            }
        }

        const setBoxHandle = (key) => {
            if (
                self.scope.app.POSITION_HANDLES[fasadePosition.PRODUCT] &&
                self.scope.app.POSITION_HANDLES[fasadePosition.PRODUCT][group.PROPS.PRODUCT.moduleType ? 1 : fasadePosition.FASADE_NUMBER]
            ) {
                const box = self.checkBoxIsFasade(group, fasadePosition.FASADE_NUMBER, key)

                if (!box.FASADE?.FASADE_INFO)
                    return

                var handle = box.FASADE?.FASADE_INFO?.HANDLE || self.scope.project.handle;
                var productHandle = self.getProductInfo(handle);

                if (productHandle == undefined) {
                    var handle_list = Object.keys(self.scope.app.HANDLES);

                    if (handle_list.length)
                        handle = Object.keys(self.scope.app.HANDLES)[0];
                    else
                        handle = false;
                }

                /*проверяем на значение - без ручки*/
                var no_handle =
                    handle == self.scope.app.SETTINGS.clear_hendles.VALUE ||
                    fasade_color.TYPE == "no_fasade" ||
                    !handle;

                /*Если есть прорисованная ручка - удаляем*/
                if (box.FASADE.FASADE_INFO.HANDLE_OBJECT) {
                    self.removeHandle(box.FASADE.FASADE_INFO.HANDLE_OBJECT.id);
                }

                const HANDLES_POSITION = box.FASADE.FASADE_INFO.HANDLE_POSITION
                /*Если ручка назначена*/
                if (!no_handle) {
                    if (
                        ((typeof HANDLES_POSITION === "object" && HANDLES_POSITION?.[key] == undefined) || HANDLES_POSITION == undefined) &&
                        self.scope.app.POSITION_HANDLES[fasadePosition.PRODUCT][group.PROPS.PRODUCT.moduleType ? 1 : fasadePosition.FASADE_NUMBER].POSITION_X2
                    ) {
                        box.FASADE.FASADE_INFO.HANDLE_POSITION = "middle";
                    }

                    group.PROPS.HANDLES_POSITION =
                        self.scope.project.items[group.id].HANDLES_POSITION;

                    let _fasadePosition = Object.assign({}, fasadePosition)

                    box.FASADE.FASADE_INFO.HANDLE_OBJECT = self.addHandle(
                        handle,
                        _fasadePosition,
                        obj,
                        group,
                        key,
                        doorId || "box"
                    );
                } else {
                    delete box.FASADE.FASADE_INFO.HANDLE_OBJECT;
                }
            }
        }

        if (itsBoxFasade) {
            setBoxHandle(basket_key)
        } else {

            if (group.PROPS.CONFIG.DOUBLE_HANDLES?.[fasadePosition.FASADE_NUMBER]) {
                for (let item of Object.entries(group.PROPS.CONFIG.HANDLES[fasadePosition.FASADE_NUMBER])) {
                    setHandle(item[0])
                }
            } else {
                setHandle(basket_key)
            }

            if (group.PROPS.PRODUCT.moduleType) {
                if (doorId)
                    group.PROPS.CONFIG.BASKET['FASADEWIDTH' + fasadePosition.FASADE_NUMBER][doorId] = self.calcFasadeWidth({}, fasadePosition.FASADE_NUMBER, group, doorId)
                else
                    group.PROPS.CONFIG.BASKET['FASADEWIDTH' + fasadePosition.FASADE_NUMBER] = self.calcFasadeWidth({}, fasadePosition.FASADE_NUMBER, group)
            } else {
                delete group.PROPS.CONFIG.BASKET['FASADEWIDTH' + fasadePosition.FASADE_NUMBER]
            }
        }

        /*Добавление ящиков*/
        if (fasadePosition.drawer) {
            group.remove(group.PROPS.DRAWERS[fasadePosition.FASADE_NUMBER]);
            self.createDrawer(group, fasadePosition, start_position_facade);
        }
        /*Добавление ящиков*/

        obj.PROPS = fasade_color;

        //obj.geometry?.computeBoundingBox()
        self.calculateUnionBoundingBox(obj)

        return obj;
    };

    this.createCompositeFasade = function (group, fasadeNumber, _doorId) {
        //Удаляем старый фасад
        group.remove(group.PROPS.FASADE[fasadeNumber]);
        const CONFIG = group.PROPS.CONFIG
        const obj = new THREE.Object3D()

        const create = (doorId) => {
            const fasadePosition = self.getFasadePosition(group, fasadeNumber, doorId)

            if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS) CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}
            if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber]) CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber] = {}
            if (doorId && !CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorId]) CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorId] = {}

            const fasadePositions = CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber]?.[doorId] || CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber]
            const fasadeSegments = CONFIG.BASKET.DOORS?.[fasadeNumber]?.[doorId] || CONFIG.BASKET.DOORS?.[fasadeNumber] || CONFIG.BASKET['FASADE' + fasadeNumber]
            angular.forEach(fasadeSegments, function (color, key) {
                const start_position = self.getStartPosition(self.getProductSize(group.PROPS));
                const new_start_position = JSON.parse(JSON.stringify(start_position))

                new_start_position.y = fasadePositions[key]// - (group.PROPS.CONFIG.BASKET["FASADESIZES" + fasadeNumber][key] / 2)
                fasadePosition.FASADE_HEIGHT = CONFIG.BASKET["FASADESIZES" + fasadeNumber]?.[doorId]?.[key] || CONFIG.BASKET["FASADESIZES" + fasadeNumber][key] || CONFIG.BASKET["FASADESIZES" + fasadeNumber][0]
                fasadePosition.POSITION_Y = 0

                const new_fasade = self.createFasade(fasadePosition, new_start_position, color, group, key, false, false, doorId)
                obj.add(new_fasade)
            })
        }

        const createBoxFasade = () => {
            const fasadePosition = self.getFasadePosition(group, fasadeNumber)

            const fasadeSegments = CONFIG.BASKET[`SECTIONSFILLING${fasadeNumber}`]?.length ? CONFIG.BASKET[`SECTIONSFILLING${fasadeNumber}`]?.filter(item => item.FASADE) :
                group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasadeNumber] ? Object.values(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasadeNumber]) : []

            angular.forEach(fasadeSegments, function (box, key) {
                const start_position = self.getStartPosition(self.getProductSize(group.PROPS));
                const new_start_position = JSON.parse(JSON.stringify(start_position))

                const color = box.FASADE?.FASADE_INFO?.COLOR || box.FASADE?.fasade?.COLOR || self.scope.constants.noFasad;
                const basket_key = box.FASADE?.basket_key || box.KEY;

                new_start_position.y = box?.FASADE?.position || box?.POSITION?.y || 0
                fasadePosition.FASADE_HEIGHT = box.FASADE?.size?.height || box.FASADE.size || box.SIZE
                fasadePosition.FASADE_WIDTH = box.FASADE?.size?.width || fasadePosition.FASADE_WIDTH
                fasadePosition.POSITION_Y = 0

                const new_fasade = self.createFasade(fasadePosition, new_start_position, color, group, basket_key, false, box)
                obj.add(new_fasade)
            })
        }

        if (_doorId) {
            angular.forEach(CONFIG.BASKET.DOORS[fasadeNumber], function (door, doorId) {
                create(doorId)
            })
            createBoxFasade()
        } else {
            create()
            createBoxFasade()
        }

        group.PROPS.FASADE[fasadeNumber] = obj;
        return obj
    }

    this.calcFasadeHeight = function (fasades, fasadeNumber, group, _fasadePosition, doorKey) {
        let fasadePosition = self.getFasadePosition(group, fasadeNumber, doorKey) || _fasadePosition
        let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];

        const HEIGHT_PLINTH = +filling.HEIGHT_PLINTH
        const HEIGHT_CORNICE = +filling.HEIGHT_CORNICE

        //Вересников В.Д. 19.04.2024
        //Какая-то необоснованая дичь, ломающая отсутствие цоколя, я её закоментил:
        //!Если высота горизонта 0
        //const horizonHeight = group.PROPS.CONFIG.BASKET.HORIZONT === 0 ? HEIGHT_PLINTH - HEIGHT_CORNICE * 2 : 0
        let fasadeHeight = fasadePosition.FASADE_HEIGHT  // + horizonHeight
        let isSlideDoor = group.PROPS.PRODUCT.moduleType?.CODE === 'wardrobe'

        const fasadeSectionSizes = self.getDefaultHeight(fasadeHeight, fasades, isSlideDoor)
        let fasadeSectionSizesSum = fasadeSectionSizes.reduce((partialSum, a) => partialSum + a, 0)

        if (fasadeHeight !== fasadeSectionSizesSum) {
            if (isSlideDoor)
                fasadeSectionSizes[0] += fasadeHeight - fasadeSectionSizesSum
            else {
                let delta = fasadeHeight - fasadeSectionSizesSum - ((fasadeSectionSizes.length - 1) * 4)
                fasadeSectionSizes[0] += delta
            }
        }

        return fasadeSectionSizes
    }

    this.calcFasadeWidth = function (fasades, fasadeNumber, group, doorId) {
        let fasadePosition = self.getFasadePosition(group, fasadeNumber, doorId)
        return fasadePosition.FASADE_WIDTH || group.PROPS.CONFIG.SIZE.width //group.PROPS.PRODUCT.moduleType ? fasadePosition.FASADE_WIDTH : group.PROPS.CONFIG.SIZE.width
    }

    this.getDefaultHeight = function (fasadeHeight, fasades, isSlideDoor = false) {
        const fasadeSectionSizes = []
        let sectionHeight = isSlideDoor ? Math.floor(fasadeHeight / Object.keys(fasades).length) :
            Math.floor(fasadeHeight / Object.keys(fasades).length - Math.round(Object.keys(fasades).length))

        if (Object.keys(fasades).length === 1) {
            return [fasadeHeight]
        }

        angular.forEach(fasades, function (color, key) {
            fasadeSectionSizes.push(sectionHeight)
        })
        return fasadeSectionSizes
    }

    this.calcFasadePositions = function (fasades, group, fasadePosition) {

        const CONFIG = group.PROPS ? group.PROPS.CONFIG : group
        const PRODUCT = group.PROPS ? group.PROPS.PRODUCT : false

        const fasadeSectionSizes = [...fasades]


        let fasadeSectionPositions = {}

        if (PRODUCT.moduleType?.CODE === "wardrobe") {
            let bottomFasadePosition = -(CONFIG.SIZE.height / 2 - fasadePosition.POSITION_Y)

            angular.forEach(fasadeSectionSizes, function (size, key) {
                fasadeSectionPositions[key] = bottomFasadePosition
                bottomFasadePosition = bottomFasadePosition + size
            })

            //Разворачиваем позиции фасадов, т.к. они посчитаны снизу-вверх, а рисоваться будут сверху-вниз,
            // т.е. id позиции не будет совпадать с id фасада
            let tmp_array = Object.values(fasadeSectionPositions)
            tmp_array.reverse()
            fasadeSectionPositions = {}
            tmp_array.forEach((item, index) => fasadeSectionPositions[index] = item)
        } else if (PRODUCT.moduleType?.CODE === "universal") {
            let bottomFasadePosition = -(CONFIG.SIZE.height / 2 - Math.abs(fasadePosition.FASADE_HEIGHT - CONFIG.SIZE.height + 2))

            //if (CONFIG.recalcFasadeHeight === true)
            fasadeSectionSizes.reverse()

            angular.forEach(fasadeSectionSizes, function (size, key) {
                fasadeSectionPositions[key] = bottomFasadePosition
                bottomFasadePosition = bottomFasadePosition + size + 4//отступ предусмотрен в высоте фасада
            })

            //Разворачиваем позиции фасадов, т.к. они посчитаны снизу-вверх, а рисоваться будут сверху-вниз,
            // т.е. id позиции не будет совпадать с id фасада
            let tmp_array = Object.values(fasadeSectionPositions)
            tmp_array.reverse()
            fasadeSectionPositions = {}
            tmp_array.forEach((item, index) => fasadeSectionPositions[index] = item)
        } else if (group.ID !== 5171728) {
            let bottomFasadePosition = -(CONFIG.SIZE.height / 2)

            angular.forEach(fasadeSectionSizes, function (size, key) {
                fasadeSectionPositions[key] = bottomFasadePosition + fasadePosition.POSITION_Y
            })
        }

        return fasadeSectionPositions
    }

    this.addFasadeSegment = function (fasadeNumber, fasade, subfasade_id, doorKey) {

        /* Как работает функция
    1. Принимает в себя номер фасада
    2. Скрывает выбор фасадов, чтобы не было возможности изменить
    3. Удаляет фасад визуально
    4. Условие для добавления фасадов
    5. Прорисовка составного фасада
    6. Перерасчет петель
    7. Запрос цены
    */


        //Группа
        const group = self.scope.app.active
        delete group.PROPS.CONFIG.recalcFasadeHeight  //удалить флаг, обозначающий наличие ручного ввода размеров фасадов

        const BASKET = group.PROPS.CONFIG.BASKET
        const CONFIG = group.PROPS.CONFIG
        const moduleThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        //Без фасада, номер в корзине
        const noFasade = self.scope.app.constants.noFasad

        //Информация по фасаду с бека
        let fasadePosition = self.getFasadePosition(group, fasadeNumber, doorKey)

        if ((fasadePosition.FASADE_HEIGHT / 2) - 2 < 360) {
            self.alert('Слишком малая высота фасада!')
            return
        }

        //2. Скрывает меню выбора цвета фасадов
        self.hideOptionsTab()

        //3. удаляет визуально фасад
        group.remove(group.PROPS.FASADE[fasadeNumber]);

        const fasadeSegments = doorKey ? BASKET.DOORS?.[fasadeNumber]?.[doorKey] : BASKET.DOORS?.[fasadeNumber] || BASKET['FASADE' + fasadeNumber]

        let tmp_obj = {}

        if (typeof fasadeSegments === 'number') {
            self.devideFasade(group, fasadeNumber) //Разделение с 1го фасада до двух.
            group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] = 1
        } else {
            const segmentsCount = Object.keys(fasadeSegments).length

            if (doorKey) {

                if (!group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber])
                    group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] = {}
                else if (typeof group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] !== 'object')
                    group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] = {1: group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber]}

                group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber][doorKey] = group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber][doorKey] + 1 || segmentsCount + 1
            } else {
                group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] = group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] + 1 || segmentsCount + 1
            }

            if (subfasade_id || subfasade_id === 0) {
                tmp_obj[subfasade_id] = noFasade

                for (let fas of Object.entries(fasadeSegments)) {
                    let key = +fas[0]
                    let value = fas[1]

                    if (key < subfasade_id)
                        tmp_obj[key] = value
                    else if (key === subfasade_id)
                        tmp_obj[key + 1] = noFasade
                    else
                        tmp_obj[key + 1] = value
                }

                if (BASKET.DOORS) {
                    if (doorKey)
                        group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber][doorKey] = tmp_obj
                    else
                        group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber] = tmp_obj
                } else
                    group.PROPS.CONFIG.BASKET['FASADE' + fasadeNumber] = tmp_obj

            } else
                fasadeSegments[segmentsCount] = noFasade //добавить новую секцию без фасада, начинается с 0, поэтому не ставим +1
        }

        let FASADE_SIZES = typeof group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber] === "object" ? doorKey ? group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][doorKey]
            : group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber] : group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber];

        if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasadeNumber] && (subfasade_id || subfasade_id === 0)) {
            group.PROPS.CONFIG.recalcFasadeHeight = true

            let tmp_arr
            if (typeof FASADE_SIZES === "object") {
                tmp_arr = {}
                let i
                angular.forEach(FASADE_SIZES, (size, _key) => {
                    const key = parseInt(_key)
                    if (key == subfasade_id) {
                        let new_value = size / 2 - 2
                        tmp_arr[key] = new_value
                        tmp_arr[key + 1] = new_value
                        i = key + 1
                    } else {
                        tmp_arr[i ? key + 1 : key] = size
                    }
                })
            } else {
                tmp_arr = []

                for (let index = 0; index < FASADE_SIZES.length; index++) {
                    let value = FASADE_SIZES[index]

                    if (index === subfasade_id) {
                        let new_value = value / 2 - 2
                        tmp_arr.push(new_value)
                        tmp_arr.push(new_value)
                    } else
                        tmp_arr.push(value)
                }
            }

            FASADE_SIZES = tmp_arr

            group.PROPS.CONFIG.BASKET['SECTIONSFILLING' + fasadeNumber].forEach(item => {
                if (item.PATH > subfasade_id)
                    item.PATH += 1
            })

            angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[fasadeNumber], (item, key) => {
                if (item.PATH > subfasade_id)
                    item.PATH += 1
            })


        } else {
            FASADE_SIZES = self.calcFasadeHeight(Object.keys(tmp_obj).length ? tmp_obj : fasadeSegments, fasadeNumber, group, fasadePosition, doorKey)
        }

        if (doorKey)
            group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][doorKey] = FASADE_SIZES
        else
            group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber] = FASADE_SIZES

        if (group.PROPS.PRODUCT.moduleType) {
            if (doorKey)
                group.PROPS.CONFIG.BASKET['FASADEWIDTH' + fasadeNumber][doorKey] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group, doorKey)
            else
                group.PROPS.CONFIG.BASKET['FASADEWIDTH' + fasadeNumber] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group)
        } else
            delete group.PROPS.CONFIG.BASKET['FASADEWIDTH' + fasadeNumber]

        //group.PROPS.CONFIG['AVAILABLE_FASADES' + fasadeNumber] = FASADE_SIZES

        group.ID = group.PROPS.CONFIG.ID

        if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasadeNumber] && (subfasade_id || subfasade_id === 0)) {

            let FASADE_POSITIONS = doorKey ? group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorKey] : group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber]
            let currentPos = FASADE_POSITIONS[subfasade_id]
            let currSize = FASADE_SIZES[subfasade_id]

            let tmpObj = {}

            angular.forEach(FASADE_POSITIONS, (position, _key) => {
                const key = +_key

                if (key < subfasade_id) {
                    tmpObj[key] = position
                } else if (key > subfasade_id) {
                    tmpObj[key + 1] = position
                } else {
                    tmpObj[key] = position + currSize + 4
                    tmpObj[key + 1] = position
                }
            })

            if (doorKey)
                group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorKey] = tmpObj
            else
                group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber] = tmpObj

            let AVAILABLE_FASADES = doorKey ? CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber][doorKey] : CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber]
            tmpObj = {}

            let basket_key
            angular.forEach(AVAILABLE_FASADES, (fasade, _key) => {
                const key = +_key

                if (fasade.basket_key === false) {
                    if (basket_key)
                        tmpObj[key + 1] = fasade
                    else
                        tmpObj[key] = fasade

                    return
                }

                if (fasade.basket_key < subfasade_id) {
                    tmpObj[key] = fasade
                } else if (fasade.basket_key > subfasade_id) {
                    fasade.basket_key += 1
                    tmpObj[key + 1] = fasade
                } else {
                    fasade.size.height = currSize

                    let newFasade = Object.assign({}, fasade)
                    fasade.basket_key += 1
                    newFasade.position += currSize + 4
                    newFasade.size = {width: newFasade.size.width, height: newFasade.size.height}

                    tmpObj[key] = newFasade
                    tmpObj[key + 1] = fasade
                    basket_key = key + 1
                }
            })

            if (doorKey)
                CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber][doorKey] = tmpObj
            else
                CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber] = tmpObj

        } else {
            if (doorKey)
                group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorKey] = self.calcFasadePositions(BASKET['FASADESIZES' + fasadeNumber][doorKey], group, fasadePosition)
            else
                group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber] = self.calcFasadePositions(BASKET['FASADESIZES' + fasadeNumber], group, fasadePosition)
        }

        //Создание и отрисовка составного фасада
        const compositeFasade = self.createCompositeFasade(group, fasadeNumber, doorKey)

        group.add(compositeFasade);

        group.PROPS.FASADE[fasadeNumber] = compositeFasade;

        //6.Обновление позиций петель
        if (!group.PROPS.PRODUCT.moduleType || group.PROPS.PRODUCT.moduleType.CODE !== "wardrobe") {
            if (group.PROPS.CONFIG.FASADELIST[fasadeNumber]) {
                self.calcLoops(group, fasadeNumber, doorKey)
            }
        }

        //addFasadeSegment
        self.controlFasadeCount(group, fasadeNumber, doorKey)

        self.updateElement(group)

        //6.Запрос цены
        self.getBasketPrice();

        //Консоль

    }

    this.removeFasadeSection = function (fasadeNumber, fasade/* Принимает в себя номер фасада */, subfasade_id, doorKey) {

        /* Как работает функция
    1. Скрывает выбор фасадов, чтобы не было возможности изменить
    2. Принимает в себя номер фасада
    3. Удаляет фасад визуально
    4. Условие для удаления сегмента фасадов, если больше 2х сегментов и когда 2 сегмента и идет удаление составного фасада.
    5. Перерасчет петель
    6. Запрос цены
    */

        /* !!!ЧТО ДОДЕЛАТЬ
    Переписать переменную segmentCount в условии 4, удалить else, когда в корзине фасады станут обьектом
    */


        //1
        self.hideOptionsTab()

        //2
        //Выбранный элемент(шкаф)
        const group = self.scope.app.active
        delete group.PROPS.CONFIG.recalcFasadeHeight  //удалить флаг, обозначающий наличие ручного ввода размеров фасадов

        const BASKET = group.PROPS.CONFIG.BASKET
        const fasadeSegments = doorKey ? BASKET.DOORS?.[fasadeNumber]?.[doorKey] : BASKET.DOORS?.[fasadeNumber] || BASKET['FASADE' + fasadeNumber]

        //Количество сегментов фасада, нужно для логики.
        /* !!! Переписать, когда фасады в корзине все станут обьектами. */

        const segmentsCount = typeof fasadeSegments === 'object' ? Object.keys(fasadeSegments).length : 1
        //Фасады в корзине

        //3
        group.remove(group.PROPS.FASADE[fasadeNumber]);

        //Позиция фасада, информация
        let fasadePosition = self.getFasadePosition(group, fasadeNumber, doorKey)

        //4
        if (segmentsCount > 2) {
            if (subfasade_id || subfasade_id === 0) {
                group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] = segmentsCount - 1

                const removeFasade = (fieldName) => {
                    if (BASKET[fieldName + fasadeNumber]) {
                        for (let i = subfasade_id; i < segmentsCount; i++)
                            BASKET[fieldName + fasadeNumber][i] = BASKET[fieldName + fasadeNumber][i + 1]

                        delete BASKET[fieldName + fasadeNumber][segmentsCount - 1]
                    }
                }

                //Удаление фасадов, и дополнений к ним.
                for (let i = subfasade_id; i < segmentsCount; i++)
                    fasadeSegments[i] = fasadeSegments[i + 1]
                delete fasadeSegments[segmentsCount - 1]

                removeFasade('MILLING');
                removeFasade('PALETTE');
                removeFasade('PATINA');

                //Расчет размеров фасадов
                let FASADE_SIZES = typeof group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber] === "object" ? doorKey ? group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][doorKey]
                    : group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber] : group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber];

                if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasadeNumber] && (subfasade_id || subfasade_id === 0)) {
                    group.PROPS.CONFIG.recalcFasadeHeight = true

                    let tmp_arr
                    if (typeof FASADE_SIZES === "object") {
                        tmp_arr = {}
                        let i
                        angular.forEach(FASADE_SIZES, (size, _key) => {
                            const key = parseInt(_key)
                            if (key == subfasade_id) {

                                if (FASADE_SIZES[key + 1]) {
                                    tmp_arr[key] = size + FASADE_SIZES[key + 1] + 4
                                    i = key
                                } else if (FASADE_SIZES[key - 1]) {
                                    tmp_arr[key - 1] = size + FASADE_SIZES[key - 1] + 4
                                    i = key
                                } else
                                    tmp_arr[key] = size

                            } else {
                                tmp_arr[i ? key - 1 : key] = size
                            }
                        })
                    } else {
                        tmp_arr = []

                        for (let index = 0; index < FASADE_SIZES.length; index++) {
                            let value = FASADE_SIZES[index]

                            if (index === subfasade_id) {

                                if (FASADE_SIZES[index + 1]) {
                                    FASADE_SIZES[index + 1] += value + 4
                                } else if (FASADE_SIZES[index - 1]) {
                                    tmp_arr[tmp_arr.length - 1] += value + 4
                                } else
                                    tmp_arr.push(value)

                            } else
                                tmp_arr.push(value)
                        }
                    }

                    FASADE_SIZES = tmp_arr

                    group.PROPS.CONFIG.BASKET['SECTIONSFILLING' + fasadeNumber].forEach(item => {
                        if (item.PATH > subfasade_id)
                            item.PATH -= 1
                    })

                    angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[fasadeNumber], (item, key) => {
                        if (item.PATH > subfasade_id)
                            item.PATH -= 1
                    })

                } else {
                    FASADE_SIZES = self.calcFasadeHeight(fasadeSegments, fasadeNumber, group, fasadePosition, doorKey)
                }

                if (doorKey)
                    BASKET['FASADESIZES' + fasadeNumber][doorKey] = FASADE_SIZES
                else
                    BASKET['FASADESIZES' + fasadeNumber] = FASADE_SIZES

                if (group.PROPS.PRODUCT.moduleType)
                    if (doorKey)
                        BASKET['FASADEWIDTH' + fasadeNumber][doorKey] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group, doorKey)
                    else
                        BASKET['FASADEWIDTH' + fasadeNumber] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group)
                else
                    delete BASKET['FASADEWIDTH' + fasadeNumber]

                //Расчет позиций сегментов фасадов
                /* возвращает массив чисел */
                group.ID = group.PROPS.CONFIG.ID
                if (doorKey)
                    group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorKey] = self.calcFasadePositions(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][doorKey], group, fasadePosition)
                else
                    group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber] = self.calcFasadePositions(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber], group, fasadePosition)

            } else {
                group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber] = segmentsCount - 1
                //Удаление фасадов, и дополнений к ним.
                if (fasadeSegments) delete fasadeSegments[segmentsCount - 1]
                if (BASKET['MILLING' + fasadeNumber]) delete BASKET['MILLING' + fasadeNumber][segmentsCount - 1]
                if (BASKET['PALETTE' + fasadeNumber]) delete BASKET['PALETTE' + fasadeNumber][segmentsCount - 1]
                if (BASKET['PATINA' + fasadeNumber]) delete BASKET['PATINA' + fasadeNumber][segmentsCount - 1]


                //Расчет размеров фасадов
                const FASADE_SIZES = self.calcFasadeHeight(fasadeSegments, fasadeNumber, group, fasadePosition, doorKey)

                if (doorKey)
                    BASKET['FASADESIZES' + fasadeNumber][doorKey] = FASADE_SIZES
                else
                    BASKET['FASADESIZES' + fasadeNumber] = FASADE_SIZES

                if (group.PROPS.PRODUCT.moduleType)
                    if (doorKey)
                        BASKET['FASADEWIDTH' + fasadeNumber][doorKey] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group, doorKey)
                    else
                        BASKET['FASADEWIDTH' + fasadeNumber] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group)
                else
                    delete BASKET['FASADEWIDTH' + fasadeNumber]

                //Расчет позиций сегментов фасадов
                /* возвращает массив чисел */
                group.ID = group.PROPS.CONFIG.ID
                if (doorKey)
                    group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber][doorKey] = self.calcFasadePositions(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][doorKey], group, fasadePosition)
                else
                    group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[fasadeNumber] = self.calcFasadePositions(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber], group, fasadePosition)
            }
        } else {
            delete group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber]

            self.resetFasades(group, fasadeNumber)
            const FASADE_SIZES = self.calcFasadeHeight(fasadeSegments, fasadeNumber, group, fasadePosition, doorKey)

            if (doorKey)
                BASKET['FASADESIZES' + fasadeNumber][doorKey] = FASADE_SIZES
            else
                BASKET['FASADESIZES' + fasadeNumber] = FASADE_SIZES

            if (group.PROPS.PRODUCT.moduleType)
                if (doorKey)
                    BASKET['FASADEWIDTH' + fasadeNumber][doorKey] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group, doorKey)
                else
                    BASKET['FASADEWIDTH' + fasadeNumber] = self.calcFasadeWidth(fasadeSegments, fasadeNumber, group)
            else
                delete BASKET['FASADEWIDTH' + fasadeNumber]
        }

        //5.Обновление позиций петель
        if (!group.PROPS.PRODUCT.moduleType || group.PROPS.PRODUCT.moduleType.CODE !== "wardrobe") {
            if (group.PROPS.CONFIG.FASADELIST[fasadeNumber]) {
                self.calcLoops(group, fasadeNumber, doorKey)
            }

            if (!group.PROPS.CONFIG['COMPOSITE_FASADE' + fasadeNumber]) {
                self.initLoops(group)
            }
        }

        //В случае наличия фасадов ящиков чистим AVAILABLE_FASADES
        if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[fasadeNumber] && (subfasade_id || subfasade_id === 0)) {

            let AVAILABLE_FASADES = doorKey ? group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber][doorKey] : group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber]
            let tmpObj = {}

            let basket_key
            angular.forEach(AVAILABLE_FASADES, (fasade, _key) => {
                const key = +_key

                if (fasade.basket_key === false) {
                    if (basket_key)
                        tmpObj[key - 1] = fasade
                    else
                        tmpObj[key] = fasade

                    return
                }

                if (fasade.basket_key < subfasade_id) {
                    tmpObj[key] = fasade
                } else if (fasade.basket_key > subfasade_id) {
                    fasade.basket_key -= 1
                    tmpObj[key - 1] = fasade
                } else {
                    basket_key = key

                    if (AVAILABLE_FASADES[key + 1]?.external_box === false)
                        AVAILABLE_FASADES[key + 1].position = fasade.position
                    else if (AVAILABLE_FASADES[key - 1]?.external_box === false)
                        AVAILABLE_FASADES[key - 1].position = fasade.position
                }
            })

            if (doorKey)
                group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber][doorKey] = tmpObj
            else
                group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[fasadeNumber] = tmpObj

        }

        self.updateElement(group)

        //6.Запрос цены
        self.getBasketPrice();
    }

    this.checkCanRemoveFasadeSegment = function (_group, sectionKey, segmentKey, doorKey = false) {
        const group = _group || self.scope.app.active

        let segmentsCount
        if (doorKey && parseInt(doorKey)) {
            segmentsCount = group.PROPS.CONFIG.BASKET.DOORS?.[sectionKey]?.[doorKey] ? Object.entries(group.PROPS.CONFIG.BASKET.DOORS[sectionKey][doorKey]).length : 0
        } else {
            segmentsCount = group.PROPS.CONFIG.BASKET.DOORS ? Object.entries(group.PROPS.CONFIG.BASKET.DOORS[sectionKey]).length :
                group.PROPS.CONFIG.BASKET['FASADE' + sectionKey] ? Object.entries(group.PROPS.CONFIG.BASKET['FASADE' + sectionKey]).length : 0
        }

        let FASADE_SIZES = typeof group.PROPS.CONFIG.BASKET['FASADESIZES' + sectionKey] === "object" ? doorKey ? group.PROPS.CONFIG.BASKET['FASADESIZES' + sectionKey][doorKey]
            : group.PROPS.CONFIG.BASKET['FASADESIZES' + sectionKey] : group.PROPS.CONFIG.BASKET['FASADESIZES' + sectionKey];

        let checkNeerFasades = true
        if (typeof FASADE_SIZES === "object") {
            angular.forEach(FASADE_SIZES, (size, _key) => {
                const key = parseInt(_key)
                if (key == segmentKey) {

                    if (FASADE_SIZES[key + 1] || FASADE_SIZES[key - 1]) {
                        checkNeerFasades = true
                    } else
                        checkNeerFasades = false
                }
            })
        } else {
            if (FASADE_SIZES[segmentKey + 1] || FASADE_SIZES[segmentKey - 1]) {
                checkNeerFasades = true
            } else {
                checkNeerFasades = false
            }
        }

        return segmentsCount > 1 && checkNeerFasades
    }

    this.resetFasades = function (group, fasadeNumber) {

        const fasadeSegments = group.PROPS.CONFIG.BASKET.DOORS?.[fasadeNumber] || group.PROPS.CONFIG.BASKET['FASADE' + fasadeNumber]

        if (!fasadeSegments)
            return

        const clear = (door = false) => {

            if (group.PROPS.CONFIG.BASKET.DOORS?.[fasadeNumber]) {
                if (door) {
                    if (group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber][door])
                        group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber][door] = {0: group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber][door][0]}
                } else {
                    group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber] = {0: group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber][0]}
                }
            } else
                group.PROPS.CONFIG.BASKET['FASADE' + fasadeNumber] = {0: group.PROPS.CONFIG.BASKET['FASADE' + fasadeNumber][0]}

            if (group.PROPS.CONFIG.BASKET['MILLING' + fasadeNumber]) {
                if (door)
                    group.PROPS.CONFIG.BASKET['MILLING' + fasadeNumber][door] = {0: group.PROPS.CONFIG.BASKET['MILLING' + fasadeNumber][door][0]}
                else
                    group.PROPS.CONFIG.BASKET['MILLING' + fasadeNumber] = {0: group.PROPS.CONFIG.BASKET['MILLING' + fasadeNumber][0]}
            }

            if (group.PROPS.CONFIG.BASKET['PALETTE' + fasadeNumber]) {
                if (door)
                    group.PROPS.CONFIG.BASKET['PALETTE' + fasadeNumber][door] = {0: group.PROPS.CONFIG.BASKET['PALETTE' + fasadeNumber][door][0]}
                else
                    group.PROPS.CONFIG.BASKET['PALETTE' + fasadeNumber] = {0: group.PROPS.CONFIG.BASKET['PALETTE' + fasadeNumber][0]}
            }

            if (group.PROPS.CONFIG.BASKET['PATINA' + fasadeNumber]) {
                if (door)
                    group.PROPS.CONFIG.BASKET['PATINA' + fasadeNumber][door] = {0: group.PROPS.CONFIG.BASKET['PATINA' + fasadeNumber][door][0]}
                else
                    group.PROPS.CONFIG.BASKET['PATINA' + fasadeNumber] = {0: group.PROPS.CONFIG.BASKET['PATINA' + fasadeNumber][0]}
            }

            if (group.PROPS.CONFIG.BASKET['FASADETYPE' + fasadeNumber]) {
                if (door)
                    group.PROPS.CONFIG.BASKET['FASADETYPE' + fasadeNumber][door] = {0: group.PROPS.CONFIG.BASKET['FASADETYPE' + fasadeNumber][door][0]}
                else
                    group.PROPS.CONFIG.BASKET['FASADETYPE' + fasadeNumber] = {0: group.PROPS.CONFIG.BASKET['FASADETYPE' + fasadeNumber][0]}
            }

            if (door)
                delete group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][door]
            else
                delete group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber]
        }

        if (group.PROPS.CONFIG.BASKET.DOORS?.[fasadeNumber] && group.PROPS.PRODUCT.moduleType?.CODE === "universal") {
            angular.forEach(group.PROPS.CONFIG.BASKET.DOORS[fasadeNumber], function (door, doorKey) {
                clear(doorKey)
            })
        } else
            clear()

        self.initLoops(group)
    }


    this.devideFasade = function (group, section) {
        //Фасады имели формат number, теперь обьект

        //Работает в addFasade

        const BASKET = group.PROPS.CONFIG.BASKET

        const noFasade = self.scope.app.constants.noFasad //Без фасада

        const prevFasade = BASKET.DOORS?.[section] || BASKET['FASADE' + section]

        if (BASKET.DOORS?.[section])
            BASKET.DOORS[section] = {
                0: prevFasade,
                1: noFasade
            }
        else
            BASKET['FASADE' + section] = {
                0: prevFasade,
                1: noFasade
            }

        if (BASKET['PALETTE' + section]) {
            const prevPalette = BASKET['PALETTE' + section]
            BASKET['PALETTE' + section] = {0: prevPalette}
        }

        if (BASKET['PATINA' + section]) {
            const prevPatina = BASKET['PATINA' + section]
            BASKET['PATINA' + section] = {0: prevPatina}
        }

        if (BASKET['MILLING' + section]) {
            const prevMilling = BASKET['MILLING' + section]
            BASKET['MILLING' + section] = {0: prevMilling}
        }

        if (BASKET['FASADETYPE' + section]) {
            const prevType = BASKET['FASADETYPE' + section]
            BASKET['FASADETYPE' + section] = {0: prevType}
        }
    }


    this.calcCompositeFasadeSizes = function (group, section, _fasadePosition, doorKey) {

        let fasadePosition = self.getFasadePosition(group, section, doorKey) || _fasadePosition

        /////////////////////////
        const config = {}

        const fasadeSegments = doorKey ? group.PROPS.CONFIG.BASKET.DOORS?.[section][doorKey] : group.PROPS.CONFIG.BASKET.DOORS?.[section] || group.PROPS.CONFIG.BASKET['FASADE' + section]

        config.sizes = self.calcFasadeHeight(fasadeSegments, section, group, fasadePosition, doorKey)

        if (group.PROPS.CONFIG.recalcFasadeHeight === true) {
            config.sizes = doorKey ? group.PROPS.CONFIG.BASKET["FASADESIZES" + section][doorKey] : group.PROPS.CONFIG.BASKET["FASADESIZES" + section]
        }
        group.ID = group.PROPS.CONFIG.ID

        config.positions = self.calcFasadePositions(config.sizes, group, fasadePosition)
        return config
    }

    this.extrudeModuleProfile = function (group) {

        const geometry = group.PROPS.BOX.getObjectByName("ModuleGeometry")

        if (group.PROPS.CONFIG.sideHiTechProfile) {
            angular.forEach(group.PROPS.CONFIG.BASKET.SIDEPROFILE, function (profile, key) {
                let side_wall = geometry.children.find(item => item.name === `${profile.SIDE}box`)
                let profileObj = group.getObjectById(profile.objId)

                let scaleVector = new THREE.Vector3(1, 1, 1)
                let sizeVector = new THREE.Vector3()

                side_wall.geometry.boundingBox.getSize(sizeVector)
                scaleVector.z = (sizeVector.z - profileObj.PROPS.CONFIG.SIZE.depth) / sizeVector.z
                side_wall.scale.copy(scaleVector)
                side_wall.position.z = -profileObj.PROPS.CONFIG.SIZE.depth / 2
            })
        } else
            for (let child of geometry.children) {
                let bBox1 = new THREE.Box3().setFromObject(child);
                let oldSize = new THREE.Vector3()
                bBox1.getSize(oldSize)

                let child_bsp = THREE.CSG.fromMesh(child);
                let new_child;
                angular.forEach(group.PROPS.SECTIONSOBJ.filter(item => item.isProfile === true), function (element, key) {

                    element.scale.set(1, 1, 1)

                    let bBox1 = new THREE.Box3().setFromObject(child);
                    let bBox2 = new THREE.Box3().setFromObject(element);

                    const intersection = bBox1.intersectsBox(bBox2);
                    if (!intersection)
                        return

                    let element_clone = element.clone()
                    element.scale.set(1.02, 1.02, 1.02)

                    element_clone.position.copy(element.parent.position)
                    let element_bsp = THREE.CSG.fromMesh(element_clone);
                    child_bsp = child_bsp.subtract(element_bsp);
                    new_child = true
                })

                if (!new_child)
                    continue

                new_child = THREE.CSG.toMesh(child_bsp, child.material.clone());
                new_child.geometry.boundingBox = child.geometry.boundingBox
                new_child.geometry.boundingSphere = child.geometry.boundingSphere
                new_child.geometry.center()
                new_child.position.copy(child.position)

                new_child.geometry.faceVertexUvs = child.geometry.faceVertexUvs

                child.geometry = new_child.geometry;

                let bBox2 = new THREE.Box3().setFromObject(child);
                let newSize = new THREE.Vector3()
                bBox2.getSize(newSize)

                newSize.sub(oldSize).divideScalar(2)

                if (Math.abs(group.rotation.y) == Math.PI / 2) {
                    let tmp = newSize.x
                    newSize.x = newSize.z
                    newSize.z = tmp
                }

                child.position.add(newSize)
                self.assignUVs(child.geometry, true);
            }
    }

    // добавление интегрированной ручки
    this.preFabricateFasadeModel = function (obj, group, fasadePosition, fasade_id, segment_key, doorKey) {
        segment_key = segment_key ? segment_key : 0

        const section = fasadePosition.section;

        const isBoxFasade = self.checkBoxIsFasade(group, section, segment_key, doorKey)

        let milling = isBoxFasade ? isBoxFasade.FASADE?.FASADE_INFO?.MILLING :
            doorKey ? group.PROPS.CONFIG.BASKET?.["MILLING" + section]?.[doorKey]?.[segment_key] :
                group.PROPS.CONFIG.BASKET?.["MILLING" + section]?.[segment_key]
        let millingItem = self.scope.app.MILLING[milling];
        const fasadeSegments = doorKey ? group.PROPS.CONFIG.BASKET.DOORS?.[section]?.[doorKey] : group.PROPS.CONFIG.BASKET.DOORS?.[section] || group.PROPS.CONFIG.BASKET['FASADE' + section]

        let fasade = isBoxFasade ? isBoxFasade.FASADE?.FASADE_INFO?.COLOR :
            fasadeSegments?.[segment_key] ? parseInt(fasadeSegments[segment_key]) :
                false;

        const FASADETYPE = isBoxFasade ? isBoxFasade.FASADE?.FASADE_INFO?.FASADETYPE :
            doorKey ? group.PROPS.CONFIG.BASKET["FASADETYPE" + section]?.[doorKey] :
                group.PROPS.CONFIG.BASKET["FASADETYPE" + section]

        let fasadeType = FASADETYPE && typeof FASADETYPE === "object" && FASADETYPE[segment_key]
            ? parseInt(FASADETYPE[segment_key])
            : FASADETYPE && typeof FASADETYPE !== "object" ? parseInt(FASADETYPE)
                : milling != undefined &&
                fasadePosition.fasade_type[0] != null &&
                millingItem?.fasade_type[0] &&
                millingItem?.fasade_type.indexOf(fasadePosition.fasade_type[0]) != -1
                    ? fasadePosition.fasade_type[0]
                    : false;

        const notHndle = [3077513, 3077514]; //исключения интегр. ручек

        if (fasadeType === notHndle[0] || fasadeType === notHndle[1]) {
            fasadeType = false;
        }

        if (fasade && millingItem) {
            if (obj.type == "Object3D") {
                /*angular.forEach(obj.children, function (elem) {
          let glass = false;

          if (elem.PROPS && elem.PROPS.ID && self.scope.app.GLASS[elem.PROPS.ID]) {
            glass = true;
          }

          elem.receiveShadow = true;
          elem.castShadow = true;
          self.millingFasadeModelFunc(
              group,
              fasadePosition,
              elem,
              millingItem,
              fasade_id,
              glass
          );

        });*/
            } else if (obj.type == "Mesh") {
                self.millingFasadeModelFunc(group, fasadePosition, obj, millingItem);
                obj.receiveShadow = true;
                obj.castShadow = true;
            }
        }

        if (fasadeType) {
            let code = self.scope.app.FASADETYPE[fasadeType]["CODE"];

            if (group.PROPS?.PRODUCT.moduleType?.CODE === "universal") {
                code = group.PROPS.CONFIG.BASKET.LOOPSSIDE[section] == 4693757 ? "right_side" : "left_side"
            }

            if (obj.type == "Object3D") {
                angular.forEach(obj.children, function (elem) {
                    let glass = false;

                    if (elem.PROPS && elem.PROPS.ID && self.scope.app.GLASS[elem.PROPS.ID]) {
                        glass = true;
                    }

                    elem.receiveShadow = true;
                    elem.castShadow = true;
                    self.preFabricateFasadeModelFunc(
                        group,
                        fasadePosition,
                        elem,
                        code,
                        fasade_id,
                        glass
                    );
                });
            } else if (obj.type == "Mesh") {
                self.preFabricateFasadeModelFunc(group, fasadePosition, obj, code);
                obj.receiveShadow = true;
                obj.castShadow = true;
            }
        }
    };

    this.preFabricateFasadeModelFunc = function (
        group,
        fasadePosition,
        obj,
        code,
        fasade_id,
        glass
    ) {
        var c = Math.PI / 180;
        var back_bsp = THREE.CSG.fromGeometry(obj.geometry);
        var shape = new THREE.Shape();

        if (glass) {
            shape.moveTo(7.5, -15);
            shape.lineTo(-5, -15);
            shape.absarc(1, 9, 8, -180 * c, 0 * c, true);
        } else if (
            self.scope.app.FASADE[fasade_id] &&
            self.scope.app.FASADE[fasade_id].fasade_type[0]
        ) {
            shape.moveTo(7.5, -15);
            shape.lineTo(-7, -15);
            shape.absarc(1, 10, 8, -180 * c, 0 * c, true);
        } else {
            shape.moveTo(7.5, -15);
            shape.lineTo(-5, -15);
            shape.absarc(-2, 15, 3, -180 * c, 0 * c, true);
            shape.absarc(5, 9, 2, -180 * c, 0 * c, false);
        }

        var extrudeSettings = {
            steps: 2,
            amount:
                code == "left_side" || code == "right_side"
                    ? fasadePosition.FASADE_HEIGHT
                    : fasadePosition.FASADE_WIDTH,

            bevelEnabled: false,
        };

        var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
        var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
        materialq.color.convertSRGBToLinear();
        var shapeMesh = new THREE.Mesh(geometryq, materialq);

        if (code == "left_down" || code == "right_down" || code == "bottom") {
            shapeMesh.rotation.y = -Math.PI / 2;
            shapeMesh.position.y = -obj.position.y - fasadePosition.FASADE_HEIGHT / 2 + 10;
            shapeMesh.position.x = fasadePosition.FASADE_WIDTH / 2;
            if (glass) {
                shapeMesh.position.z = 0;
            } else {
                shapeMesh.position.z = 10;
            }
        }
        if (code == "left_top" || code == "right_top" || code == "top") {
            shapeMesh.rotation.y = Math.PI / 2;
            shapeMesh.rotation.x = -Math.PI;
            shapeMesh.position.y = -obj.position.y + fasadePosition.FASADE_HEIGHT / 2 - 10;
            shapeMesh.position.x = -fasadePosition.FASADE_WIDTH / 2;
            if (glass) {
                shapeMesh.position.z = 0;
            } else {
                shapeMesh.position.z = 10;
            }
        }

        if (code == "left_side") {
            if (
                self.scope.app.FASADE[fasade_id] &&
                self.scope.app.FASADE[fasade_id].fasade_type[0]
            ) {
                if (obj.NAME === "rightvertical") {
                    shapeMesh.rotation.x = -Math.PI / 2;
                    shapeMesh.rotation.z = Math.PI / 2;
                    shapeMesh.position.y = -fasadePosition.FASADE_HEIGHT / 2;
                    shapeMesh.position.x = 15;
                    shapeMesh.position.z = 10;
                } else if (glass) {
                    shapeMesh.rotation.x = -Math.PI / 2;
                    shapeMesh.rotation.z = Math.PI / 2;
                    shapeMesh.position.y = -fasadePosition.FASADE_HEIGHT / 2;
                    shapeMesh.position.x = fasadePosition.FASADE_WIDTH / 2 - 8;
                    shapeMesh.position.z = 0;
                } else {
                    return;
                }
            } else {
                shapeMesh.rotation.x = -Math.PI / 2;
                shapeMesh.rotation.z = -Math.PI / 2;
                shapeMesh.rotation.y = Math.PI;
                shapeMesh.position.x = fasadePosition.FASADE_WIDTH / 2 - 10;
                shapeMesh.position.y = fasadePosition.FASADE_HEIGHT / 2;
                shapeMesh.position.z = fasadePosition.FASADE_DEPTH / 2 + 1;
            }
        }

        if (code == "right_side") {
            if (
                self.scope.app.FASADE[fasade_id] &&
                self.scope.app.FASADE[fasade_id].fasade_type[0]
            ) {
                if (obj.NAME === "leftvertical") {
                    shapeMesh.rotation.x = -Math.PI / 2;
                    shapeMesh.rotation.z = -Math.PI / 2;
                    shapeMesh.position.y = -fasadePosition.FASADE_HEIGHT / 2;
                    shapeMesh.position.x = -15;
                    shapeMesh.position.z = 10;
                } else if (glass) {
                    shapeMesh.rotation.x = -Math.PI / 2;
                    shapeMesh.rotation.z = Math.PI / 2;
                    shapeMesh.position.y = -fasadePosition.FASADE_HEIGHT / 2;
                    shapeMesh.position.x = -fasadePosition.FASADE_WIDTH / 2 + 8;
                    shapeMesh.position.z = 0;
                } else {
                    return;
                }
            } else {
                shapeMesh.rotation.x = Math.PI / 2;
                shapeMesh.rotation.z = Math.PI / 2;
                shapeMesh.rotation.y = -Math.PI;
                shapeMesh.position.x = -fasadePosition.FASADE_WIDTH / 2 + 10;
                shapeMesh.position.y = -fasadePosition.FASADE_HEIGHT / 2;
                shapeMesh.position.z = fasadePosition.FASADE_DEPTH / 2 + 1;
            }
        }

        var cube_bsp = THREE.CSG.fromMesh(shapeMesh);
        var subtract_bsp = back_bsp.subtract(cube_bsp);
        //var subtract_bsp = back_bsp.union(cube_bsp);
        obj.geometry = THREE.CSG.toGeometry(subtract_bsp);
        self.assignUVs(obj.geometry);
    };

    // Вересников В.Д. 08.04.2024
    // Применение фрезеровки к фасаду
    this.millingFasadeModelFunc = function (
        group,
        fasadePosition,
        obj,
        milling,
    ) {
        var svgLoader = new THREE.SVGLoader()

        try {
            THREE.CSG.fromGeometry(obj.geometry)
        } catch (err) {
            return;
        }

        var back_bsp = THREE.CSG.fromGeometry(obj.geometry);

        var figures = []
        var shapes_array = []

        //Парсинг кастомного svg path
        const parseSVG = (svg_str, width, height, isHole = false) => {
            var tmp_shape = new THREE.Shape();

            //Подставляем смещения от краёв
            svg_str = svg_str.replaceAll("wth", width)
                .replaceAll("hgh", height)

            var tmp_array = svg_str.split(/, | /)
            svg_str = ``

            tmp_array.map(item => {
                if (item.split(/,/).length > 1) {
                    var sum = item.split(/,/).reduce((accumulator, currentValue) => {
                        return accumulator + +currentValue
                    }, 0)
                    item = sum
                }
                svg_str += ` ${item}`
            })

            if (isHole) {
                tmp_shape = svgLoader.parse(svg_str).paths
            } else {
                tmp_shape = svgLoader.parse(svg_str).paths[0]
                tmp_shape = tmp_shape.toShapes()[0]
            }

            return tmp_shape
        }

        //TODO: Получать параметры фрезеровок из БД
        switch (milling.ID) {
            case 566722:   //Прямоугольник для краски
            case 2503119:  //Прямоугольник для плёнки

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 1.5,
                            bevelEnabled: true,
                            bevelThickness: 4.5,
                            bevelSize: 13,
                            bevelOffset: -13,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 175,
                                        max: 295,
                                    },
                                    height: {
                                        min: 396,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -40,
                                    heightOffset: -60,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+26 -hgh,+26 L -wth,+26 hgh,-26 L wth,-26 hgh,-26 L wth,-26 -hgh,+26 L -wth,+26 -hgh,+26 Z"/>`,
                                    widthOffset: -40,
                                    heightOffset: -60,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 396,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 175,
                                        max: 295,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -60,
                                    heightOffset: -40,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+26 -hgh,+26 L -wth,+26 hgh,-26 L wth,-26 hgh,-26 L wth,-26 -hgh,+26 L -wth,+26 -hgh,+26 Z"/>`,
                                    widthOffset: -60,
                                    heightOffset: -40,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -57,
                                    heightOffset: -57,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+41 -hgh,+41 L -wth,+41 hgh,-41 L wth,-41 hgh,-41 L wth,-41 -hgh,+41 L -wth,+41 -hgh,+41 Z"/>`,
                                    widthOffset: -57,
                                    heightOffset: -57,
                                }
                            },
                        ],
                    },
                    {
                        name: "corner_milling_1",
                        isCorner: true,
                        extrudeSettings: {
                            steps: 1,
                            depth: 1.5,
                            bevelEnabled: true,
                            bevelThickness: 4.5,
                            bevelSize: 7.49,
                            bevelOffset: -7.49,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: 7.5,
                                    heightOffset: 7.5,
                                },
                                hole: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -7.5,
                                    heightOffset: -7.5,
                                }
                            },
                        ],
                    },
                ]

                break;
            case 2462673:   //Каприччио R4 для краски
            case 2839849:   //Каприччио R4 для краски
            case 2503107:   //Каприччио R4 для плёнки

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 2,
                            bevelEnabled: false,
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 70,
                                        max: 295,
                                    },
                                    height: {
                                        min: 396,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh,+76.55 L wth -hgh,+76.55 L wth hgh,-76.55 L -wth hgh,-76.55 L -wth -hgh,+76.55 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth -hgh,+83.45 L wth -hgh,+83.45 L wth hgh,-83.45 L -wth hgh,-83.45 L -wth -hgh,+83.45 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 396,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 56,
                                        max: 295,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth,+76.55 -hgh L wth,-76.55 -hgh L wth,-76.55 hgh L -wth,+76.55 hgh L -wth,+76.55 -hgh Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+83.45 -hgh L wth,-83.45 -hgh L wth,-83.45 hgh L -wth,+83.45 hgh L -wth,+83.45 -hgh Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 457,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth,+76.55 -hgh L -wth,+83.45 -hgh L -wth,+83.45 -hgh,+76.55
                          L wth,-83.45 -hgh,+76.55 L wth,-83.45 -hgh L wth,-76.55 -hgh L wth,-76.55 hgh
                          L wth,-83.45 hgh L wth,-83.45 hgh,-76.55 L -wth,+83.45 hgh,-76.55 L -wth,+83.45 hgh
                          L -wth,+76.55 hgh L -wth,+76.55 -hgh Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+83.45 -hgh,+83.45 L wth,-83.45 -hgh,+83.45
                          L wth,-83.45 hgh,-83.45 L -wth,+83.45 hgh,-83.45 L -wth,+83.45 -hgh,+83.45 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default_rotated",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh,+76.55 L -wth -hgh,+83.45 L -wth,+76.55 -hgh,+83.45
                                 L -wth,+76.55 hgh,-83.45 L -wth hgh,-83.45 L -wth hgh,-76.55 L wth hgh,-76.55
                                 L wth hgh,-83.45 L wth,-76.55 hgh,-83.45 L wth,-76.55 -hgh,+83.45 L wth -hgh,+83.45
                                 L wth -hgh,+76.55 L -wth -hgh,+76.55 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+83.45 -hgh,+83.45 L wth,-83.45 -hgh,+83.45
                          L wth,-83.45 hgh,-83.45 L -wth,+83.45 hgh,-83.45 L -wth,+83.45 -hgh,+83.45 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                ]

                break;
            case 5591083:   //Мюнхен 3
            case 5591080:   //Мюнхен 3

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.1,
                            bevelEnabled: true,
                            bevelThickness: 2.9,
                            bevelSize: 6.99,
                            bevelOffset: -6.99,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 146,
                                        max: 175,
                                    },
                                    height: {
                                        min: 296,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+48 -hgh,+7 L -wth,+48 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+62 -hgh,+7 L wth,-62 -hgh,+7 L wth,-62 -hgh,+63 L -wth,+62 -hgh,+63 Z"/>
                            <path d="M wth,-48 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-48 hgh,-7 Z"/>
                            <path d="M -wth,+62 hgh,-63 L wth,-62 hgh,-63 L wth,-62 hgh,-7 L -wth,+62 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 146,
                                        max: 175,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+63 -hgh,+7 L -wth,+63 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+77 -hgh,+7 L wth,-77 -hgh,+7 L wth,-77 -hgh,+48 L -wth,+77 -hgh,+48 Z"/>
                            <path d="M wth,-63 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-63 hgh,-7 Z"/>
                            <path d="M -wth,+77 hgh,-48 L wth,-77 hgh,-48 L wth,-77 hgh,-7 L -wth,+77 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+63 -hgh,+7 L -wth,+63 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+77 -hgh,+7 L wth,-77 -hgh,+7 L wth,-77 -hgh,+63 L -wth,+77 -hgh,+63 Z"/>
                            <path d="M wth,-63 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-63 hgh,-7 Z"/>
                            <path d="M -wth,+77 hgh,-63 L wth,-77 hgh,-63 L wth,-77 hgh,-7 L -wth,+77 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                ]

                break;
                // case 2051525:   //Даллас
                // case 2503131:   //Даллас
                // case 2839857:   //Даллас

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        hem: true,
                        extrudeSettings: {
                            steps: 1,
                        },
                        figureParams: [
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 0,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 0,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M 0 0 L 16.5 0 C 16 -2 15 -3 13.5 -3 L 7.6 -3 C 6.5 -3 5.9 -3.6 5.5 -4.3 C 4.9 -5.4 4 -5.5 3 -5.5 L 2 -5.5 C 1 -5.5 0 -6.5 0 -7.5 L 0 0 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: ``,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                    {
                        name: "milling_2",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.1,
                            bevelEnabled: true,
                            bevelThickness: 3.1,
                            bevelSize: 5.49,
                            bevelOffset: -5.49,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 146,
                                        max: 175,
                                    },
                                    height: {
                                        min: 296,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+48 -hgh,+7 L -wth,+48 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+62 -hgh,+7 L wth,-62 -hgh,+7 L wth,-62 -hgh,+63 L -wth,+62 -hgh,+63 Z"/>
                            <path d="M wth,-48 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-48 hgh,-7 Z"/>
                            <path d="M -wth,+62 hgh,-63 L wth,-62 hgh,-63 L wth,-62 hgh,-7 L -wth,+62 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 146,
                                        max: 175,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+63 -hgh,+7 L -wth,+63 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+77 -hgh,+7 L wth,-77 -hgh,+7 L wth,-77 -hgh,+48 L -wth,+77 -hgh,+48 Z"/>
                            <path d="M wth,-63 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-63 hgh,-7 Z"/>
                            <path d="M -wth,+77 hgh,-48 L wth,-77 hgh,-48 L wth,-77 hgh,-7 L -wth,+77 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 16.5,
                                    heightOffset: 16.5,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+16.5 -hgh,+22 L -wth,+74.5 -hgh,+82.3 L -wth,+74.5 hgh,-82.3 L -wth,+16.5 hgh,-22 Z"/>
                            <path d="M -wth,+22 -hgh,+16.5 L wth,-22 -hgh,+16.5 L +wth,-82.3 -hgh,+74.5 L -wth,+82.3 -hgh,+74.5 Z"/>
                            <path d="M wth,-74.5 -hgh,+82.3 L wth,-16.5 -hgh,+22 L wth,-16.5 hgh,-22 L wth,-74.5 hgh,-82.3 Z"/>
                            <path d="M -wth,+82.3 hgh,-74.5 L wth,-82.3 hgh,-74.5 L wth,-22 hgh,-16.5 L -wth,+22 hgh,-16.5 Z"/>
                            <path d="M -wth,+85.5 -hgh,+85.5 L wth,-85.5 -hgh,+85.5 L wth,-85.5 hgh,-85.5 L -wth,+85.5 hgh,-85.5 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                ]

                break;
            case 3971695:   //Бавария ШК
            case 3971915:   //Бавария ШК

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.01,
                            bevelEnabled: true,
                            bevelThickness: 3.99,
                            bevelSize: 7,
                            bevelOffset: -7,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 146,
                                        max: 195,
                                    },
                                    height: {
                                        min: 716,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -48,
                                    heightOffset: -63,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+14 -hgh,+14 L -wth,+14 hgh,-14 L wth,-14 hgh,-14 L wth,-14 -hgh,+14 L -wth,+14 -hgh,+14 Z"/>`,
                                    widthOffset: -48,
                                    heightOffset: -63,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 396,
                                        max: 900,
                                    },
                                    height: {
                                        min: 150,
                                        max: 195,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -48,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+14 -hgh,+14 L -wth,+14 hgh,-14 L wth,-14 hgh,-14 L wth,-14 -hgh,+14 L -wth,+14 -hgh,+14 Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -48,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 196,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 196,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -63,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+14 -hgh,+14 L -wth,+14 hgh,-14 L wth,-14 hgh,-14 L wth,-14 -hgh,+14 L -wth,+14 -hgh,+14 Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -63,
                                }
                            },
                        ],
                    },
                    {
                        name: "corner_milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.01,
                            bevelEnabled: true,
                            bevelThickness: 0.99,
                            bevelSize: 9.99,
                            bevelOffset: -9.99,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: 10,
                                    heightOffset: 10,
                                },
                                hole: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -10,
                                    heightOffset: -10,
                                }
                            },
                        ],
                    },
                ]

                break;
            default:
                break;
        }

        //Рассчёт shape-ов из данных фрезеровки
        for (var figure of figures) {

            var figureParams = false;

            for (var params of figure.figureParams) {
                var {width, height} = params.condition

                if ((width.min <= fasadePosition.FASADE_WIDTH && fasadePosition.FASADE_WIDTH <= width.max) &&
                    (height.min <= fasadePosition.FASADE_HEIGHT && fasadePosition.FASADE_HEIGHT <= height.max)) {
                    figureParams = params
                    break;
                }
            }

            if (!figureParams)
                return;

            var _extrudeSettings = figure.extrudeSettings;

            var svg = figureParams.figure.svg
            var svg_hole = figureParams.hole.svg

            var widthOffset = figureParams.figure.widthOffset || 0
            var heightOffset = figureParams.figure.heightOffset || 0
            var holeWidthOffset = figureParams.hole.widthOffset || 0
            var holeHeightOffset = figureParams.hole.heightOffset || 0

            var shape = parseSVG(svg, fasadePosition.FASADE_WIDTH / 2 + widthOffset, fasadePosition.FASADE_HEIGHT / 2 + heightOffset)

            var hole = parseSVG(svg_hole, fasadePosition.FASADE_WIDTH / 2 + holeWidthOffset, fasadePosition.FASADE_HEIGHT / 2 + holeHeightOffset, true)
            hole.map(item => {
                shape.holes.push(...item.toShapes())
            })

            shapes_array.push({shape, extrudeSettings: _extrudeSettings})
        }

        let fasadeThickness = fasadePosition.FASADE_DEPTH || 18

        //Вырезание фрезеровки в фасаде, путём удаления пересечений геометрии shape-ов фрезеровки с геометрией фасада
        for (var item of shapes_array) {
            var extrudeSettings = item.extrudeSettings || {
                steps: 1,
                depth: 2,
                bevelEnabled: false,
            };
            var _shape = item.shape

            var geometryq = new THREE.ExtrudeGeometry(_shape, extrudeSettings);
            var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
            materialq.color.convertSRGBToLinear();

            var shapeMesh = new THREE.Mesh(geometryq, materialq);

            shapeMesh.rotation.x = -Math.PI;
            shapeMesh.position.z = fasadeThickness;
            shapeMesh.geometry.computeBoundingBox()

            //var shapeSize = shapeMesh.geometry.boundingBox.getSize()

            var shape_bsp = THREE.CSG.fromMesh(shapeMesh);
            back_bsp = back_bsp.subtract(shape_bsp);   //Вырезать в фасаде фигуру
            //back_bsp = back_bsp.union(shape_bsp);    //"Нарастить" на фасад фигуру
        }

        //Вставляем полученную геометрию в объект фасада
        let faceVertexUvs = obj.geometry.faceVertexUvs
        obj.geometry = THREE.CSG.toGeometry(back_bsp);

        //TODO: Здесь ломаются карты UV, надо починить
        if (!shapes_array.length)
            obj.geometry.faceVertexUvs = faceVertexUvs
        else
            self.assignUVs(obj.geometry);
    };
    //

    // Применение фрезеровки к объекту
    this.millingOnObject = function (
        group,
        obj,
        objParams,
        milling
    ) {
        const svgLoader = new THREE.SVGLoader()
        const {size, rotation} = objParams

        try {
            THREE.CSG.fromGeometry(obj.geometry)
        } catch (err) {
            return;
        }

        var back_bsp = THREE.CSG.fromGeometry(obj.geometry);

        var figures = []
        var shapes_array = []

        //Парсинг кастомного svg path
        const parseSVG = (svg_str, width, height, isHole = false) => {
            var tmp_shape = new THREE.Shape();

            //Подставляем смещения от краёв
            svg_str = svg_str.replaceAll("wth", width)
                .replaceAll("hgh", height)

            var tmp_array = svg_str.split(/, | /)
            svg_str = ``

            tmp_array.map(item => {
                if (item.split(/,/).length > 1) {
                    var sum = item.split(/,/).reduce((accumulator, currentValue) => {
                        return accumulator + +currentValue
                    }, 0)
                    item = sum
                }
                svg_str += ` ${item}`
            })

            if (isHole) {
                tmp_shape = svgLoader.parse(svg_str).paths
            } else {
                tmp_shape = svgLoader.parse(svg_str).paths[0]
                tmp_shape = tmp_shape.toShapes()[0]
            }

            return tmp_shape
        }

        //TODO: Получать параметры фрезеровок из БД
        switch (milling.ID) {
            case 566722:   //Прямоугольник для краски
            case 2503119:  //Прямоугольник для плёнки

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 1.5,
                            bevelEnabled: true,
                            bevelThickness: 4.5,
                            bevelSize: 13,
                            bevelOffset: -13,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 175,
                                        max: 295,
                                    },
                                    height: {
                                        min: 396,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -40,
                                    heightOffset: -60,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+26 -hgh,+26 L -wth,+26 hgh,-26 L wth,-26 hgh,-26 L wth,-26 -hgh,+26 L -wth,+26 -hgh,+26 Z"/>`,
                                    widthOffset: -40,
                                    heightOffset: -60,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 396,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 175,
                                        max: 295,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -60,
                                    heightOffset: -40,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+26 -hgh,+26 L -wth,+26 hgh,-26 L wth,-26 hgh,-26 L wth,-26 -hgh,+26 L -wth,+26 -hgh,+26 Z"/>`,
                                    widthOffset: -60,
                                    heightOffset: -40,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -57,
                                    heightOffset: -57,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+41 -hgh,+41 L -wth,+41 hgh,-41 L wth,-41 hgh,-41 L wth,-41 -hgh,+41 L -wth,+41 -hgh,+41 Z"/>`,
                                    widthOffset: -57,
                                    heightOffset: -57,
                                }
                            },
                        ],
                    },
                    {
                        name: "corner_milling_1",
                        isCorner: true,
                        extrudeSettings: {
                            steps: 1,
                            depth: 1.5,
                            bevelEnabled: true,
                            bevelThickness: 4.5,
                            bevelSize: 7.49,
                            bevelOffset: -7.49,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: 7.5,
                                    heightOffset: 7.5,
                                },
                                hole: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -7.5,
                                    heightOffset: -7.5,
                                }
                            },
                        ],
                    },
                ]

                break;
            case 2462673:   //Каприччио R4 для краски
            case 2839849:   //Каприччио R4 для краски
            case 2503107:   //Каприччио R4 для плёнки

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 2,
                            bevelEnabled: false,
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 70,
                                        max: 295,
                                    },
                                    height: {
                                        min: 396,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh,+76.55 L wth -hgh,+76.55 L wth hgh,-76.55 L -wth hgh,-76.55 L -wth -hgh,+76.55 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth -hgh,+83.45 L wth -hgh,+83.45 L wth hgh,-83.45 L -wth hgh,-83.45 L -wth -hgh,+83.45 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 396,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 56,
                                        max: 295,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth,+76.55 -hgh L wth,-76.55 -hgh L wth,-76.55 hgh L -wth,+76.55 hgh L -wth,+76.55 -hgh Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+83.45 -hgh L wth,-83.45 -hgh L wth,-83.45 hgh L -wth,+83.45 hgh L -wth,+83.45 -hgh Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 457,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth,+76.55 -hgh L -wth,+83.45 -hgh L -wth,+83.45 -hgh,+76.55
                          L wth,-83.45 -hgh,+76.55 L wth,-83.45 -hgh L wth,-76.55 -hgh L wth,-76.55 hgh
                          L wth,-83.45 hgh L wth,-83.45 hgh,-76.55 L -wth,+83.45 hgh,-76.55 L -wth,+83.45 hgh
                          L -wth,+76.55 hgh L -wth,+76.55 -hgh Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+83.45 -hgh,+83.45 L wth,-83.45 -hgh,+83.45
                          L wth,-83.45 hgh,-83.45 L -wth,+83.45 hgh,-83.45 L -wth,+83.45 -hgh,+83.45 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default_rotated",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 296,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh,+76.55 L -wth -hgh,+83.45 L -wth,+76.55 -hgh,+83.45
                                 L -wth,+76.55 hgh,-83.45 L -wth hgh,-83.45 L -wth hgh,-76.55 L wth hgh,-76.55
                                 L wth hgh,-83.45 L wth,-76.55 hgh,-83.45 L wth,-76.55 -hgh,+83.45 L wth -hgh,+83.45
                                 L wth -hgh,+76.55 L -wth -hgh,+76.55 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+83.45 -hgh,+83.45 L wth,-83.45 -hgh,+83.45
                          L wth,-83.45 hgh,-83.45 L -wth,+83.45 hgh,-83.45 L -wth,+83.45 -hgh,+83.45 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                ]

                break;
            case 5591083:   //Мюнхен 3
            case 5591080:   //Мюнхен 3

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.1,
                            bevelEnabled: true,
                            bevelThickness: 2.9,
                            bevelSize: 6.99,
                            bevelOffset: -6.99,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 146,
                                        max: 175,
                                    },
                                    height: {
                                        min: 296,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+48 -hgh,+7 L -wth,+48 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+62 -hgh,+7 L wth,-62 -hgh,+7 L wth,-62 -hgh,+63 L -wth,+62 -hgh,+63 Z"/>
                            <path d="M wth,-48 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-48 hgh,-7 Z"/>
                            <path d="M -wth,+62 hgh,-63 L wth,-62 hgh,-63 L wth,-62 hgh,-7 L -wth,+62 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 146,
                                        max: 175,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+63 -hgh,+7 L -wth,+63 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+77 -hgh,+7 L wth,-77 -hgh,+7 L wth,-77 -hgh,+48 L -wth,+77 -hgh,+48 Z"/>
                            <path d="M wth,-63 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-63 hgh,-7 Z"/>
                            <path d="M -wth,+77 hgh,-48 L wth,-77 hgh,-48 L wth,-77 hgh,-7 L -wth,+77 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+63 -hgh,+7 L -wth,+63 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+77 -hgh,+7 L wth,-77 -hgh,+7 L wth,-77 -hgh,+63 L -wth,+77 -hgh,+63 Z"/>
                            <path d="M wth,-63 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-63 hgh,-7 Z"/>
                            <path d="M -wth,+77 hgh,-63 L wth,-77 hgh,-63 L wth,-77 hgh,-7 L -wth,+77 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                ]

                break;
                // case 2051525:   //Даллас
                // case 2503131:   //Даллас
                // case 2839857:   //Даллас

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        hem: true,
                        extrudeSettings: {
                            steps: 1,
                        },
                        figureParams: [
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 0,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 0,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M 0 0 L 16.5 0 C 16 -2 15 -3 13.5 -3 L 7.6 -3 C 6.5 -3 5.9 -3.6 5.5 -4.3 C 4.9 -5.4 4 -5.5 3 -5.5 L 2 -5.5 C 1 -5.5 0 -6.5 0 -7.5 L 0 0 Z"/>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                },
                                hole: {
                                    svg: ``,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                    {
                        name: "milling_2",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.1,
                            bevelEnabled: true,
                            bevelThickness: 3.1,
                            bevelSize: 5.49,
                            bevelOffset: -5.49,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 146,
                                        max: 175,
                                    },
                                    height: {
                                        min: 296,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+48 -hgh,+7 L -wth,+48 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+62 -hgh,+7 L wth,-62 -hgh,+7 L wth,-62 -hgh,+63 L -wth,+62 -hgh,+63 Z"/>
                            <path d="M wth,-48 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-48 hgh,-7 Z"/>
                            <path d="M -wth,+62 hgh,-63 L wth,-62 hgh,-63 L wth,-62 hgh,-7 L -wth,+62 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 296,
                                        max: 1250,
                                    },
                                    height: {
                                        min: 146,
                                        max: 175,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 7,
                                    heightOffset: 7,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+7 -hgh,+7 L -wth,+63 -hgh,+7 L -wth,+63 hgh,-7 L -wth,+7 hgh,-7 Z"/>
                            <path d="M -wth,+77 -hgh,+7 L wth,-77 -hgh,+7 L wth,-77 -hgh,+48 L -wth,+77 -hgh,+48 Z"/>
                            <path d="M wth,-63 -hgh,+7 L wth,-7 -hgh,+7 L wth,-7 hgh,-7 L wth,-63 hgh,-7 Z"/>
                            <path d="M -wth,+77 hgh,-48 L wth,-77 hgh,-48 L wth,-77 hgh,-7 L -wth,+77 hgh,-7 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 176,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh Z"/>`,
                                    widthOffset: 16.5,
                                    heightOffset: 16.5,
                                },
                                hole: {
                                    svg: `<svg>
                            <path d="M -wth,+16.5 -hgh,+22 L -wth,+74.5 -hgh,+82.3 L -wth,+74.5 hgh,-82.3 L -wth,+16.5 hgh,-22 Z"/>
                            <path d="M -wth,+22 -hgh,+16.5 L wth,-22 -hgh,+16.5 L +wth,-82.3 -hgh,+74.5 L -wth,+82.3 -hgh,+74.5 Z"/>
                            <path d="M wth,-74.5 -hgh,+82.3 L wth,-16.5 -hgh,+22 L wth,-16.5 hgh,-22 L wth,-74.5 hgh,-82.3 Z"/>
                            <path d="M -wth,+82.3 hgh,-74.5 L wth,-82.3 hgh,-74.5 L wth,-22 hgh,-16.5 L -wth,+22 hgh,-16.5 Z"/>
                            <path d="M -wth,+85.5 -hgh,+85.5 L wth,-85.5 -hgh,+85.5 L wth,-85.5 hgh,-85.5 L -wth,+85.5 hgh,-85.5 Z"/>
                        </svg>`,
                                    widthOffset: 0,
                                    heightOffset: 0,
                                }
                            },
                        ],
                    },
                ]

                break;
            case 3971695:   //Бавария ШК
            case 3971915:   //Бавария ШК

                figures = milling.figures || [
                    {
                        name: "milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.01,
                            bevelEnabled: true,
                            bevelThickness: 3.99,
                            bevelSize: 7,
                            bevelOffset: -7,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "small_width",
                                condition: {
                                    width: {
                                        min: 146,
                                        max: 195,
                                    },
                                    height: {
                                        min: 716,
                                        max: 2500,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -48,
                                    heightOffset: -63,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+14 -hgh,+14 L -wth,+14 hgh,-14 L wth,-14 hgh,-14 L wth,-14 -hgh,+14 L -wth,+14 -hgh,+14 Z"/>`,
                                    widthOffset: -48,
                                    heightOffset: -63,
                                }
                            },
                            {
                                nameCondition: "small_height",
                                condition: {
                                    width: {
                                        min: 396,
                                        max: 900,
                                    },
                                    height: {
                                        min: 150,
                                        max: 195,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -48,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+14 -hgh,+14 L -wth,+14 hgh,-14 L wth,-14 hgh,-14 L wth,-14 -hgh,+14 L -wth,+14 -hgh,+14 Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -48,
                                }
                            },
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 196,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 196,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -63,
                                },
                                hole: {
                                    svg: `<path d="M -wth,+14 -hgh,+14 L -wth,+14 hgh,-14 L wth,-14 hgh,-14 L wth,-14 -hgh,+14 L -wth,+14 -hgh,+14 Z"/>`,
                                    widthOffset: -63,
                                    heightOffset: -63,
                                }
                            },
                        ],
                    },
                    {
                        name: "corner_milling_1",
                        extrudeSettings: {
                            steps: 1,
                            depth: 0.01,
                            bevelEnabled: true,
                            bevelThickness: 0.99,
                            bevelSize: 9.99,
                            bevelOffset: -9.99,
                            bevelSegments: 1
                        },
                        figureParams: [
                            {
                                nameCondition: "default",
                                condition: {
                                    width: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                    height: {
                                        min: 20,
                                        max: Infinity,
                                    },
                                },
                                figure: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: 10,
                                    heightOffset: 10,
                                },
                                hole: {
                                    svg: `<path d="M -wth -hgh L wth -hgh L wth hgh L -wth hgh L -wth -hgh Z"/>`,
                                    widthOffset: -10,
                                    heightOffset: -10,
                                }
                            },
                        ],
                    },
                ]

                break;
            default:
                break;
        }

        //Рассчёт shape-ов из данных фрезеровки
        for (var figure of figures) {

            var figureParams = false;

            for (var params of figure.figureParams) {
                var {width, height} = params.condition

                if ((width.min <= size.width && size.width <= width.max) &&
                    (height.min <= size.height && size.height <= height.max)) {
                    figureParams = params
                    break;
                }
            }

            if (!figureParams)
                return;

            var _extrudeSettings = figure.extrudeSettings;

            var svg = figureParams.figure.svg
            var svg_hole = figureParams.hole.svg

            var widthOffset = figureParams.figure.widthOffset || 0
            var heightOffset = figureParams.figure.heightOffset || 0
            var holeWidthOffset = figureParams.hole.widthOffset || 0
            var holeHeightOffset = figureParams.hole.heightOffset || 0

            var shape = parseSVG(svg, size.width / 2 + widthOffset, size.height / 2 + heightOffset)

            var hole = parseSVG(svg_hole, size.width / 2 + holeWidthOffset, size.height / 2 + holeHeightOffset, true)
            hole.map(item => {
                shape.holes.push(...item.toShapes())
            })

            shapes_array.push({shape, extrudeSettings: _extrudeSettings})
        }

        let fasadeThickness = size.depth || 18

        //Вырезание фрезеровки в фасаде, путём удаления пересечений геометрии shape-ов фрезеровки с геометрией фасада
        for (var item of shapes_array) {
            var extrudeSettings = item.extrudeSettings || {
                steps: 1,
                depth: 2,
                bevelEnabled: false,
            };
            var _shape = item.shape

            var geometryq = new THREE.ExtrudeGeometry(_shape, extrudeSettings);
            var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
            materialq.color.convertSRGBToLinear();

            var shapeMesh = new THREE.Mesh(geometryq, materialq);

            shapeMesh.geometry.computeBoundingBox()
            var shapeSize = shapeMesh.geometry.boundingBox.getSize()

            shapeMesh.rotation.x = rotation.x
            shapeMesh.rotation.y = rotation.y
            shapeMesh.rotation.z = rotation.z
            shapeMesh.position.z = (fasadeThickness / 2) - extrudeSettings.depth;

            shapeMesh.position.applyAxisAngle(new THREE.Vector3(1, 0, 0), rotation.x)
            shapeMesh.position.applyAxisAngle(new THREE.Vector3(0, 1, 0), rotation.y)
            shapeMesh.position.applyAxisAngle(new THREE.Vector3(0, 0, 1), rotation.z)

            shapeMesh.updateMatrix()
            shapeMesh.geometry.computeBoundingBox()

            var shape_bsp = THREE.CSG.fromMesh(shapeMesh);
            back_bsp = back_bsp.subtract(shape_bsp);   //Вырезать в фасаде фигуру
            //back_bsp = back_bsp.union(shape_bsp);    //"Нарастить" на фасад фигуру
        }

        //Вставляем полученную геометрию в объект фасада
        let faceVertexUvs = obj.geometry.faceVertexUvs
        obj.geometry = THREE.CSG.toGeometry(back_bsp);

        //TODO: Здесь ломаются карты UV, надо починить
        if (!shapes_array.length)
            obj.geometry.faceVertexUvs = faceVertexUvs
        else
            self.assignUVs(obj.geometry);
    };
    //

    this.getMaterials = function (color, fasadePosition, group, segment, door = false, specialPartName = false, itsBoxFasade = false) {
        var texture = self.loadFileCache(color.TEXTURE, "img");
        segment = segment ? segment : self.scope.app.active_fasade_segment || "0"

        var roughness =
            1 - (!color.SHININESS ? 30 : color.SHININESS < 20 ? 20 : color.SHININESS) / 100;

        /*Если указан цвет*/
        if (itsBoxFasade) {
            var palette = self.scope.app.PALETTE[itsBoxFasade.FASADE?.fasade?.PALETTE] || false

            if (palette) {
                if (palette.HTML) {
                    var options = {color: "#" + palette.HTML, roughness: roughness};
                } else {
                    var options = {
                        map: self.loadFileCache(palette.DETAIL_PICTURE, "img"),
                        roughness: roughness,
                    };
                }
            } else if (color.COLOR) {
                var options = {color: color.COLOR, roughness: roughness};
            } else {
                var options = {map: texture, roughness: roughness};
            }

        } else if (fasadePosition && segment &&
            (door ? group.PROPS.CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]?.[door]?.[segment] :
                group.PROPS.CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]?.[segment])
        ) {
            var palette = door ? self.scope.app.PALETTE[group.PROPS.CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER][door][segment]] :
                self.scope.app.PALETTE[group.PROPS.CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER][segment]]

            if (palette) {
                if (palette?.TYPE !== "KANT") {
                    if (palette.HTML) {
                        var options = {color: "#" + palette.HTML, roughness: roughness};
                    } else {
                        var options = {
                            map: self.loadFileCache(palette.DETAIL_PICTURE, "img"),
                            roughness: roughness,
                        };
                    }
                } else {
                    let options, kant;
                    if (color.COLOR) {
                        options = {color: color.COLOR, roughness: roughness};
                    } else {
                        options = {map: texture, roughness: roughness};
                    }

                    if (palette.HTML) {
                        kant = new THREE.MeshStandardMaterial({color: "#" + palette.HTML, roughness: roughness});
                    } else {
                        kant = new THREE.MeshStandardMaterial({
                            map: self.loadFileCache(palette.DETAIL_PICTURE, "img"),
                        })
                    }

                    return [
                        new THREE.MeshStandardMaterial(options),
                        kant
                    ]
                }
            }

        } else if (color.COLOR) {
            var options = {color: color.COLOR, roughness: roughness};
        } else {
            var options = {map: texture, roughness: roughness};
        }

        //Если продукт - зеркало
        if (group.PROPS.PRODUCT.productType == 10336730) {
            let mirror = self.scope.app.FASADE[3957174]
            let texture = new THREE.MeshStandardMaterial({
                map: self.loadFileCache(mirror.TEXTURE, "img"),
            })

            return [
                new THREE.MeshStandardMaterial(options),
                texture
            ]
        }

        if (specialPartName && group.PROPS.CONFIG.BASKET[specialPartName]) {
            var palette = self.scope.app.PALETTE[group.PROPS.CONFIG.BASKET[specialPartName].PALETTE || group.PROPS.CONFIG.BASKET[specialPartName]]
            if (palette) {
                if (palette.HTML) {
                    delete options.map
                    options.color = "#" + palette.HTML
                } else {
                    delete options.color
                    options.map = self.loadFileCache(palette.DETAIL_PICTURE, "img")
                }
            }
        }

        if (group.PROPS.CONFIG.BASKET["HEM"]) {
            // добавляет кромку
            var hem = self.scope.app.HEM[group.PROPS.CONFIG.BASKET["HEM"]];
            if (hem)
                return [
                    new THREE.MeshStandardMaterial({
                        map: self.loadFileCache(hem.PREVIEW_PICTURE, "img"),
                    }),
                    new THREE.MeshStandardMaterial({
                        map: self.loadFileCache(hem.PREVIEW_PICTURE, "img"),
                    }),
                    new THREE.MeshStandardMaterial({
                        map: self.loadFileCache(hem.PREVIEW_PICTURE, "img"),
                    }),
                    new THREE.MeshStandardMaterial({
                        map: self.loadFileCache(hem.PREVIEW_PICTURE, "img"),
                    }),
                    new THREE.MeshStandardMaterial(options),
                    new THREE.MeshStandardMaterial(options),
                ];
            else
                return {}
        }

        if (color.EDGE_COLOR) {
            return [
                new THREE.MeshStandardMaterial(options),
                new THREE.MeshStandardMaterial({color: color.EDGE_COLOR}),
            ];
        } else {
            return new THREE.MeshStandardMaterial(options);
        }
    };

    this.changeFasade = function (element, news, old) {

        //костыль из-за optionsFunction
        if (element && (!news && news !== 0)) {
            news = element
            element = self.scope.app.active
        }

        const group = self.scope.app.active || element
        const active_fasade = self.scope.app.active_fasade
        //Приходит в формате строки
        const segment = +self.scope.app.active_fasade_segment //Часть составного фасада
        const doorKey = self.scope.app.active_fasade_door
        const itsBoxFasade = self.checkBoxForFasade(group, active_fasade, segment, false, doorKey)

        if (group?.PROPS?.CONFIG.BASKET['FASADESIZES' + active_fasade]?.[segment] < 360 && !itsBoxFasade && group.PROPS?.PRODUCT.moduleType?.CODE === "universal") {
            self.alert('Внимание, невозможный размер, измените размер фасада!')
        }

        var fasadePosition = self.getFasadePosition(group, active_fasade, doorKey)
        if ([5168676, 5178415].includes(group?.PROPS?.PRODUCT.ID)) {
            if (fasadePosition?.FASADE_WIDTH < 600) {
                news = self.scope.fasadeErrorColor  //фасад не доступен
                self.alert('Минимальная ширина двери 600 мм.', "error")
            } else if (fasadePosition?.FASADE_WIDTH > 1300) {
                news = self.scope.fasadeErrorColor  //фасад не доступен
                self.alert('Максимальная ширина двери 1300 мм.', "error")
            }
        }

        if (news) {
            if (
                self.scope.app.active_fasade &&
                (!self.scope.app.optionsTabName ||
                    (self.scope.app.optionsTabName &&
                        self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true))
            ) {
                self.changeElementFasade(
                    self.scope.app.active.id,
                    news,
                    self.scope.app.active_fasade,
                    segment,
                    doorKey);
                self.getBasketPrice();
            } else {
                if (self.scope.app.optionsTabName == "defaultFasadeup") {
                    self.ChangeDefaultFasade("element_up", news);
                } else if (self.scope.app.optionsTabName == "defaultFasadedown") {
                    self.ChangeDefaultFasade("element_down", news);
                }
            }
            self.controlJoinDeph();
        }
        if (group.PROPS?.PRODUCT.moduleType?.CODE === "universal") {
            if ((group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[active_fasade] || group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[active_fasade]) || group.PROPS.CONFIG['COMPOSITE_FASADE' + active_fasade]) {
                //Наличие петель зависит от опции "без фасада"
                self.controlFasadeCount(group, active_fasade, doorKey)
                self.updateLoops(group, active_fasade)
            } else {
                self.initLoops(group)
                self.updateLoops(group, active_fasade)
            }
        }

        self.getGroupedOptions(group);
    };

    this.controlFasadeSiblings = function (product_id, fasade_id, fasade_number, door_id) {
        var id = fasade_id;
        if (!self.canBeSetFasade(product_id, fasade_id, fasade_number, door_id)) {
            if (
                self.scope.app.FASADE[fasade_id] &&
                self.scope.app.FASADE[fasade_id].SIBLINGS_COLOR != null &&
                self.canBeSetFasade(
                    product_id,
                    self.scope.app.FASADE[fasade_id].SIBLINGS_COLOR,
                    fasade_number,
                    door_id
                )
            ) {
                id = self.scope.app.FASADE[fasade_id].SIBLINGS_COLOR;
            } else {
                id = self.getDefaultFasade(product_id);
            }
        }
        return id;
    };

    this.changeElementFasade = function (idElement, fasadeID, numberFasade, segmentKey, doorKey) {

        segmentKey = segmentKey ? segmentKey : 0

        var group = self.scope.app.elementsObj[idElement];
        var start_position = self.getStartPosition(self.getProductSize(group.PROPS));
        let _fasadeID;

        if (typeof fasadeID === "object") {
            _fasadeID = Object.assign({}, fasadeID)
            _fasadeID = _fasadeID[segmentKey] || _fasadeID[0]
        } else
            _fasadeID = fasadeID

        group.remove(group.PROPS.FASADE[numberFasade]);

        self.removeEdgeFromElement(group.PROPS.FASADE[numberFasade]);
        _fasadeID = self.controlFasadeSiblings(group.PROPS.PRODUCT.ID, _fasadeID, numberFasade, doorKey);

        const fasadeSegments = group.PROPS.CONFIG.BASKET.DOORS?.[numberFasade]?.[doorKey] || group.PROPS.CONFIG.BASKET.DOORS?.[numberFasade] || group.PROPS.CONFIG.BASKET['FASADE' + numberFasade]
        const boxFasade = self.checkBoxIsFasade(group, numberFasade, segmentKey, doorKey);

        if (boxFasade) {
            boxFasade.FASADE.FASADE_INFO.COLOR = _fasadeID;

            let box = group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${numberFasade}`].find(item => item.PATH == boxFasade.PATH)
            if (box.FASADE?.fasade) {
                box.FASADE.fasade.COLOR = _fasadeID;

                let newFasadeParams = Object.assign({}, box.FASADE.fasade, boxFasade.FASADE.FASADE_INFO)
                boxFasade.FASADE.FASADE_INFO = newFasadeParams

                box.FASADE.fasade = Object.assign({}, newFasadeParams)
                delete box.FASADE.fasade.HANDLE_OBJECT
            }
        } else {
            /* !!! Проверить на ошибки*/
            if (!group.PROPS.CONFIG.DOUBLE_HANDLES || !group.PROPS.CONFIG.DOUBLE_HANDLES[numberFasade]?.[segmentKey]) {
                fasadeSegments[segmentKey] = _fasadeID;
            } else {
                fasadeSegments[0] = _fasadeID;
            }
        }


        self.controlFasade(group, segmentKey, doorKey); //!!!??? проверить или удалить

        var fasadePosition = self.getFasadePosition(group, numberFasade, doorKey)

        if (segmentKey !== undefined || boxFasade) {
            const new_fasade = self.createCompositeFasade(group, numberFasade, doorKey)
            group.add(new_fasade);
            group.PROPS.FASADE[numberFasade] = new_fasade;
        } else {
            const new_fasade = self.createFasade(fasadePosition, start_position, _fasadeID, group, doorKey);
            group.add(new_fasade);
            group.PROPS.FASADE[numberFasade] = new_fasade;
        }

        if (fasadePosition.inherit_fasade_number.length)
            angular.forEach(fasadePosition.inherit_fasade_number, function (v) {
                if (v) {
                    self.changeElementFasade(idElement, _fasadeID, v, segmentKey);
                }
            });

        self.scope.app.new_fasade = false;
        self.scope.app.new_model = false;
        self.scope.app.new_glass = false;
        self.scope.app.new_milling = false;
        self.scope.app.new_patina = false;
        self.scope.app.new_handle = false;
        self.scope.app.new_palette = false;

        if (!boxFasade)
            self.checkSizeFasade(
                group.PROPS.CONFIG.BASKET,
                group.PROPS.CONFIG.FASADELIST,
                group.PROPS.CONFIG.SIZE,
                group.PROPS.CONFIG.ID
            )

        //Проверка механизмов при смене фасада
        self.controlMechanism();
        //Проверка механизмов при смене фасада
    };

    this.createLabel = function (
        text,
        x,
        y,
        z,
        size,
        color,
        backGroundColor,
        backgroundMargin,
        rotation
    ) {
        if (!backgroundMargin) backgroundMargin = 50;

        var group = new THREE.Object3D();

        var canvas = document.createElement("canvas");

        var context = canvas.getContext("2d");

        context.font = size + "pt Arial";

        var textWidth = context.measureText(text).width;

        canvas.width = textWidth + backgroundMargin;
        canvas.height = size + backgroundMargin;

        context = canvas.getContext("2d");
        context.font = size + "pt Arial";

        if (backGroundColor) {
            context.fillStyle = backGroundColor;
            context.fillRect(
                canvas.width / 2 - textWidth / 2 - backgroundMargin / 2,
                canvas.height / 2 - size / 2 - +backgroundMargin / 2,
                textWidth + backgroundMargin,
                size + backgroundMargin
            );
        }

        context.textAlign = "center";
        context.textBaseline = "middle";
        context.fillStyle = color;
        context.fillText(text, canvas.width / 2, canvas.height / 2);

        var texture = new THREE.Texture(canvas);
        texture.anisotropy = 16;
        texture.needsUpdate = true;

        var material = new THREE.MeshPhongMaterial({
            map: texture,
            transparent: true,
        });

        var mesh = new THREE.Mesh(
            new THREE.PlaneGeometry(canvas.width, canvas.height, 1, 1),
            material
        );
        var mesh2 = new THREE.Mesh(
            new THREE.PlaneGeometry(canvas.width, canvas.height, 1, 1),
            material
        );
        mesh2.rotation.y = Math.PI;

        if (rotation) {
            mesh.rotation.z = rotation;
            mesh2.rotation.z = rotation;
        }

        group.add(mesh, mesh2);

        return group;
    };

    this.changeGlass = function (news, old) {
        const group = self.scope.app.active
        const section = self.scope.app.active_fasade
        const door = self.scope.app.active_fasade_door
        const segment = self.scope.app.active_fasade_segment

        if (news) {
            const fasadeSegments = door ? group.PROPS.CONFIG.BASKET.DOORS?.[section]?.[door] : group.PROPS.CONFIG.BASKET.DOORS?.[section] ||
                group.PROPS.CONFIG.BASKET['FASADE' + section]

            if (segment) {
                if (!group.PROPS.CONFIG.BASKET["GLASS" + section])
                    group.PROPS.CONFIG.BASKET["GLASS" + section] = {}

                if (door) {
                    if (!group.PROPS.CONFIG.BASKET["GLASS" + section][door])
                        group.PROPS.CONFIG.BASKET["GLASS" + section][door] = {}

                    group.PROPS.CONFIG.BASKET["GLASS" + section][door][segment] = news;
                } else
                    group.PROPS.CONFIG.BASKET["GLASS" + section][segment] = news;

                self.changeFasade(group,
                    fasadeSegments[segment]
                );
            } else {
                group.PROPS.CONFIG.BASKET["GLASS" + section] =
                    news;
                self.changeFasade(group,
                    fasadeSegments
                );
            }

        }
    };

    this.createFasadeFromModel = function (conf, options, fasade, group) {
        var options = $.extend(
            {
                z: 16,
                lineX: 70,
                centerZ: options.centerZ ? options.centerZ : 16 / 2,
            },
            options
        );

        conf.material = options.material || conf.material;

        var expressions = {
            "#FWIDTH#": options.x,
            "#FHEIGHT#": options.y,
            "#FDEPTH#": options.z,
            "#FCENTERZ#": options.centerZ,
            "#FLINEX#": options.lineX,
            "#X#": group.PROPS.CONFIG.SIZE.width,
            "#Y#": group.PROPS.CONFIG.SIZE.height,
            "#Z#": group.PROPS.CONFIG.SIZE.depth,
        };

        conf = self.expressionsReplace(conf, expressions);

        var obj = self.createModelFromJson(conf, fasade, group);

        return obj;
    };

    this.assignUVs = function (geometry, moduleProfile = false) {
        geometry.faceVertexUvs[0] = [];

        if (moduleProfile) {
            for (var i = 0; i < geometry.faces.length; i++) {
                var face = geometry.faces[i];

                var va = geometry.vertices[geometry.faces[i].a]
                var vb = geometry.vertices[geometry.faces[i].b]
                var vc = geometry.vertices[geometry.faces[i].c]

                var vab = new THREE.Vector3().copy(vb).sub(va)
                var vac = new THREE.Vector3().copy(vc).sub(va)

                //теперь у нас есть 2 вектора, чтобы получить векторное произведение...
                var vcross = new THREE.Vector3().copy(vab).cross(vac);

                //Найдём наибольшую ось нормали плоскости...
                vcross.set(Math.abs(vcross.x), Math.abs(vcross.y), Math.abs(vcross.z))
                var majorAxis = vcross.x > vcross.y ? (vcross.x > vcross.z ? 'x' : vcross.y > vcross.z ? 'y' : vcross.y > vcross.z) : vcross.y > vcross.z ? 'y' : 'z'

                //Возьмём две другие оси из наибольшей оси.
                var vAxis = majorAxis == 'x' ? 'y' : majorAxis == 'y' ? 'x' : 'x';
                var uAxis = majorAxis == 'x' ? 'z' : majorAxis == 'y' ? 'z' : 'y';

                geometry.faceVertexUvs[0].push([
                    new THREE.Vector2(va[uAxis], va[vAxis]).normalize(),
                    new THREE.Vector2(vb[uAxis], vb[vAxis]).normalize(),
                    new THREE.Vector2(vc[uAxis], vc[vAxis]).normalize(),
                ]);
            }

            geometry.elementsNeedUpdate = geometry.verticesNeedUpdate = geometry.uvsNeedUpdate = true;
        } else {
            geometry.faces.forEach(function (face) {
                var components = ["x", "z", "y"].sort(function (a, b, c) {
                    return Math.abs(face.normal[a]) > Math.abs(face.normal[b]);
                });

                var v1 = geometry.vertices[face.a];
                var v2 = geometry.vertices[face.b];
                var v3 = geometry.vertices[face.c];

                geometry.faceVertexUvs[0].push([
                    new THREE.Vector2(v1[components[0]], v1[components[1]]),
                    new THREE.Vector2(v2[components[0]], v2[components[1]]),
                    new THREE.Vector2(v3[components[0]], v3[components[1]]),
                ]);
            });

            geometry.uvsNeedUpdate = true;
        }

    };

    this.createModelFromJson = function (
        conf,
        fasade,
        parent_group,
        isBox,
        leftColor,
        rightColor,
        backColor,
        topFasadeColor,
        metalTsargaColor
    ) {
        if (!parent_group && conf.parent) parent_group = conf.parent;

        var parent = conf.parent ? conf.parent : false;

        var isBox = !!isBox;

        var group = new THREE.Object3D();

        var obj = [],
            edge = [];


        const PROFILE_ID = parent && parent.PROPS && parent.PROPS.CONFIG && parent.PROPS.CONFIG.BASKET && parent.PROPS.CONFIG.BASKET.PROFILE;

        const profile_ids = {
            uugol: "251698",
            u2ugol: "251699",
            gugol: "251701"
        };

        const PARENT_DEPTH = parent && parent.PROPS && parent.PROPS.CONFIG && parent.PROPS.CONFIG.SIZE && parent.PROPS.CONFIG.SIZE.depth || 600
        const PARENT_HEIGHT = parent && parent.PROPS && parent.PROPS.CONFIG && parent.PROPS.CONFIG.SIZE && parent.PROPS.CONFIG.SIZE.height

        const USLIGI_LIST = parent && parent.PROPS && parent.PROPS.CONFIG && parent.PROPS.CONFIG.BASKET && parent.PROPS.CONFIG.BASKET.USLUGI || [];
        const usllugi_ids = {
            kromka_torec: "182294",
            kromka_perimetr: "182295",
            kromka_tri_storony: "182816",
            left_skos: "201638",
            right_skos: "201639",
            left_zakr: "201640",
            right_krug: "201641",
            evrozapilpp: "247669",
            evrozapilpl: "247670",
            evrozapilmp: "247671",
            evrozapilml: "247672",
            plastik: "249713",
            barn_zakr: "616287",
            raspil: "98683",
        };

        /**
         * v = 0 левая сторона
         * v = 1 правая сторона
         * v = 2 нижняя сторона
         * v = 3 верхняя сторона
         * v = 4 задняя сторона
         * */
        $.each(conf.items, function (v, i) {
            const leftSide = 0;
            const rightSide = 1;
            const bottomSide = 2;
            const topSide = 3;
            const backSide = 4;
            const topFasade = 6;

            if (i.id === 'forwardbox') { // пропускаем если ширина детали меньше или равна 0
                if (eval(i.geometry.opt.x) <= 0) {
                    return true;
                }
            }

            var material;
            let color
            if (conf.color || conf.moduleColor) {
                if (i.id === "leftbox" && leftColor) {
                    material = self.getMaterials(leftColor, fasade, parent_group, false, false, "LEFTSIDECOLOR");
                } else if (i.id === "rightbox" && rightColor) {
                    material = self.getMaterials(rightColor, fasade, parent_group, false, false, "RIGHTSIDECOLOR");
                } else if (i.id === "back" && backColor) {
                    material = self.getMaterials(backColor, fasade, parent_group, false, false, "BACKWALL");
                } else if ((i.id === 'horizontallineback' || i.id === 'horizontallinefront') && metalTsargaColor) {
                    material = self.getMaterials(metalTsargaColor, fasade, parent_group);
                } else if (i.id === "top_fasade" && topFasadeColor) {
                    material = self.getMaterials(topFasadeColor, fasade, parent_group, false, false, "TOPFASADECOLOR");
                } else {
                    if (i.useColor) {
                        color = conf.color || conf.moduleColor
                        material = self.getMaterials(color, fasade, parent_group, false, false, "MODULECOLOR_PALETTE");
                    } else {
                        color = conf.moduleColor || conf.color
                        material = self.getMaterials(color, fasade, parent_group, false, false, "MODULECOLOR_PALETTE");
                    }
                }

                if (material.map)
                    material.map.wrapS = material.map.wrapT = THREE.MirroredRepeatWrapping;
            } else if (conf.material instanceof THREE.Material) {
                material = conf.material;
            } else {
                material = new THREE[conf.material.type](conf.material.opt);
                if (i.geometry.opt.color) {
                    material.color.set(i.geometry.opt.color);
                }
            }

            if (!Object.keys(material).length)
                return group

            //Если содержит стекло
            if (i.glass) {
                const materialConf = {
                    color: "#" + 939393,
                    transparent: true,
                    opacity: 0.5,
                    shininess: 100,
                    specular: 0x999999,
                };
                material = new THREE.MeshPhongMaterial(materialConf);
                material.color.convertSRGBToLinear();
            }

            if (i.type == "object") {
                self.getExec(i.geometry.opt);

                if (i.geometry.type == "ExtrudeGeometry") {

                    if (Array.isArray(material)) {
                        angular.forEach(material, function (v, k) {
                            material = v
                            if (material.map) {
                                material.map.wrapS = THREE.RepeatWrapping;
                                material.map.rotation = (-Math.PI / 2)
                                material.map.repeat.set(
                                    1 / 3000,
                                    1 / 1200
                                );
                                material.map.offset.set(0, 0.5);
                            }
                        })
                    } else if (material.map && material.map.repeat.x == 1) {
                        material.map.wrapS = THREE.RepeatWrapping;
                        material.map.rotation = (-Math.PI / 2)
                        material.map.repeat.set(
                            1 / 3000,
                            1 / 1200
                        );
                        material.map.offset.set(0, 0.5);
                    } else {
                        if (material.map) {
                            material.map.repeat.set(1 / 2048, 1 / 1024); // Нет свойства color
                            material.map.offset.set(0.7, 0.7);
                        }

                    }

                    var shape = new THREE.Shape();

                    let profileGeometryCommand = i.geometry.command; //переопределяю снизу
                    const gugolCommand = [
                        {
                            type: "moveTo",
                            opt: {
                                x: `${-(PARENT_DEPTH / 2)}`,
                                y: `${-(PARENT_HEIGHT / 2)}`,
                            },
                        },
                        {
                            type: "lineTo",
                            opt: {
                                x: `${-(PARENT_DEPTH / 2)}`,
                                y: `${(PARENT_HEIGHT / 2)}`,
                            },
                        },
                        {
                            type: "moveTo",
                            opt: {
                                x: `${PARENT_DEPTH / 2}`,
                                y: `${(PARENT_HEIGHT / 2)}`,
                            },
                        },
                        {
                            type: "lineTo",
                            opt: {
                                x: `${PARENT_DEPTH / 2}`,
                                y: `${-(PARENT_HEIGHT / 2)}`,
                            },
                        },
                    ];
                    const u2ugolCommand = [
                        {
                            type: "absarc",
                            opt: {
                                aX: `${-(PARENT_DEPTH / 2) + 9}`,
                                aY: `${-(PARENT_HEIGHT / 2) + 9}`,
                                aRadius: 9,
                                aStartAngle: -Math.PI / 2,
                                aEndAngle: Math.PI,
                                aClockwise: true,
                            },
                        },
                        {
                            type: "absarc",
                            opt: {
                                aX: `${-(PARENT_DEPTH / 2) + 9}`,
                                aY: `${(PARENT_HEIGHT / 2) - 9}`,
                                aRadius: 9,
                                aStartAngle: Math.PI,
                                aEndAngle: Math.PI / 2,
                                aClockwise: true,
                            },
                        },
                        {
                            type: "absarc",
                            opt: {
                                aX: `${PARENT_DEPTH / 2 - 9}`,
                                aY: `${(PARENT_HEIGHT / 2) - 9}`,
                                aRadius: 9,
                                aStartAngle: Math.PI / 2,
                                aEndAngle: 0,
                                aClockwise: true,
                            },
                        },
                        {
                            type: "absarc",
                            opt: {
                                aX: `${PARENT_DEPTH / 2 - 9}`,
                                aY: `${-(PARENT_HEIGHT / 2) + 9}`,
                                aRadius: 9,
                                aStartAngle: 0,
                                aEndAngle: -Math.PI / 2,
                                aClockwise: true,
                            },
                        },
                    ];

                    if (i.id !== "profil") {
                        if (PROFILE_ID === "251699") {
                            //2uugol
                            profileGeometryCommand = u2ugolCommand;
                        } else if (PROFILE_ID === "251701") {
                            //gugol
                            profileGeometryCommand = gugolCommand;
                        } else if (PARENT_HEIGHT === 16 && i.id !== 'radius1' || PARENT_HEIGHT === 40 && !PROFILE_ID || PARENT_HEIGHT === 38 && !PROFILE_ID) {
                            profileGeometryCommand = gugolCommand;
                        }
                    }

                    profileGeometryCommand.forEach(function (command) {
                        var opt = self.getExec(
                            Object.keys(command.opt).map(function (key) {
                                return command.opt[key];
                            })
                        );
                        shape[command.type](opt[0], opt[1], opt[2], opt[3], opt[4], opt[5], opt[6]);
                    });

                    var geometry = new THREE[i.geometry.type](shape, i.geometry.opt);//new THREE.BoxGeometry(1000, 1000,100)
                } else if (i.geometry.type == "BoxGeometry") {
                    if (Array.isArray(material)) {
                        angular.forEach(material, function (v, k) {
                            if (v.map)
                                v.map.wrapS = v.map.wrapT = THREE.MirroredRepeatWrapping;
                        });

                        if (material[0].map && parent_group.PROPS.PRODUCT.productType !== 10336730) {
                            if (i.id === "stolesh") {

                                material[0].map.rotation = Math.PI / 2; // кромка торец прав
                                material[1].map.rotation = -Math.PI / 2; // кромка торец лев
                                // material[2].map.rotation = Math.PI / 2; //кромка перед
                                // material[3].map.rotation = Math.PI / 2;
                                material[4].map.rotation = Math.PI / 2; // кромка зад
                                material[5].map.rotation = Math.PI / 2; //
                            } else {
                                material[0].map.rotation = -Math.PI / 2;
                                material[1].map.rotation = Math.PI / 2;
                                material[3].map.rotation = Math.PI;
                            }
                        }

                    } else if (material.map) {
                        material.map.wrapS = material.map.wrapT = THREE.MirroredRepeatWrapping;
                    }

                    var geometry = new THREE[i.geometry.type](
                        i.geometry.opt.x,
                        i.geometry.opt.y,
                        i.geometry.opt.z
                    );
                } else if (i.geometry.type == "ExtrudeBoxGeometry") {
                    if (Array.isArray(material)) {
                        if (material[0].map) {
                            material[0].map.wrapS = material[0].map.wrapT =
                                THREE.MirroredRepeatWrapping;
                            material[0].map.repeat.set(
                                1 / color.TEXTURE_WIDTH,
                                1 / color.TEXTURE_HEIGHT
                            );
                            material[0].map.offset.set(0.5, 0.5);
                        }

                        i.geometry.opt.material = 0;
                        i.geometry.opt.extrudeMaterial = 1;
                        i.geometry.opt.UVGenerator = THREE.ExtrudeGeometry.BoundingUVGenerator;
                    } else if (material.map) {
                        material.map.wrapS = material.map.wrapT = THREE.MirroredRepeatWrapping;
                        material.map.repeat.set(
                            1 / color.TEXTURE_WIDTH,
                            1 / color.TEXTURE_HEIGHT
                        );
                    }

                    var geometry = self.ExtrudeBoxGeometry(i.geometry.opt);
                } else if (i.geometry.type == "PlaneGeometry") {
                    if (color && material.map)
                        material.map.repeat.set(
                            i.geometry.opt.x / color.TEXTURE_WIDTH,
                            i.geometry.opt.y / color.TEXTURE_HEIGHT
                        );

                    var geometry = new THREE[i.geometry.type](i.geometry.opt.x, i.geometry.opt.y);
                } else if (i.geometry.type == "CylinderGeometry") {
                    if (Array.isArray(material)) {
                        angular.forEach(material, function (v, k) {
                            if (v.map)
                                v.map.wrapS = v.map.wrapT = THREE.MirroredRepeatWrapping;
                        });

                        if (material[0].map) {
                            if (i.id === "stolesh") {

                                material[0].map.rotation = Math.PI / 2; // кромка торец прав
                                material[1].map.rotation = -Math.PI / 2; // кромка торец лев
                                // material[2].map.rotation = Math.PI / 2; //кромка перед
                                // material[3].map.rotation = Math.PI / 2;
                                material[4].map.rotation = Math.PI / 2; // кромка зад
                                material[5].map.rotation = Math.PI / 2; //
                            } else {
                                material[0].map.rotation = -Math.PI / 2;
                                material[1].map.rotation = Math.PI / 2;
                                material[3].map.rotation = Math.PI;
                            }
                        }

                    } else if (material.map) {
                        material.map.wrapS = material.map.wrapT = THREE.MirroredRepeatWrapping;
                    }

                    var geometry = new THREE[i.geometry.type](
                        i.geometry.opt.radiusTop,
                        i.geometry.opt.radiusBottom,
                        i.geometry.opt.height,
                        i.geometry.opt.radialSegments,
                        i.geometry.opt.heightSegments,
                        i.geometry.opt.openEnded,
                        i.geometry.opt.thetaStart,
                        i.geometry.opt.thetaLength,
                    );
                }

                /* ------------------КРОМКА МЕШ------------------------- */
                geometry.computeBoundingBox();
                let hemGeometry = geometry.clone(); //кромка повторяет геометрию

                const hemId = parent && parent.PROPS && parent.PROPS.CONFIG && parent.PROPS.CONFIG.BASKET && parent.PROPS.CONFIG.BASKET.HEM
                const hemMaterial = new THREE.MeshStandardMaterial({
                    map: self.loadFileCache(self.scope.app.HEM[hemId] && self.scope.app.HEM[hemId].DETAIL_PICTURE, "img"),
                }); //Взять материал кромки

                const redMaterial = new THREE.MeshStandardMaterial({
                    map: self.loadFileCache(self.scope.app.HEM[692788] && self.scope.app.HEM[692788].DETAIL_PICTURE, "img"),
                }); //Взять красную кромку, для примера!

                const hemMaterials = hemMaterial || redMaterial; //Берет текущую кромку или красную (для тестов)
                /* if (hemMaterials.map?.wrapS) {
          hemMaterials.map.wrapS = THREE.MirroredRepeatWrapping;
          hemMaterials.map.wrapT = THREE.MirroredRepeatWrapping;
          hemMaterials.map.repeat.set(1 / 64, 1 / 32);
          hemMaterials.map.rotation = -Math.PI / 2;
          hemMaterials.map.offset.set(0.7, 0.3);
        } */

                if (self.scope.app.SETTINGS.clear_table.VALUE == self.scope.project.table && material.opacity == 0.5) {
                    hemMaterials.transparent = true;
                    hemMaterials.opacity = 0.01;
                }

                /* ------------------КРОМКА МЕШ------------------------- */

                if (parent_group && parent_group.PROPS.CONFIG.USLUGILIST) {
                    var geometry_type = geometry.type;
                    material.map.rotation = (-Math.PI / 2)
                    angular.forEach(parent_group.PROPS.CONFIG.USLUGILIST, function (v, k) {
                        if (v) {
                            var usluga = self.scope.app.USLUGI[k];

                            if (usluga.CODE == "left_skos") {
                                var back_bsp = THREE.CSG.fromGeometry(geometry);
                                var cube_geometry = new THREE.CubeGeometry(600, 500, 500);
                                var cube_mesh = new THREE.Mesh(cube_geometry);

                                if (geometry_type == "ExtrudeGeometry") {
                                    cube_mesh.rotation.x = Math.PI / 2;
                                    cube_mesh.rotation.z = -Math.PI / 3;

                                    cube_mesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 + 100, // x
                                        parent_group.PROPS.CONFIG.SIZE.height / 2 + 95, //y
                                        parent_group.PROPS.CONFIG.SIZE.width - 95 //z
                                    );
                                } else {
                                    cube_mesh.rotation.z = -Math.PI / 3;
                                    cube_mesh.position.set(
                                        -parent_group.PROPS.CONFIG.SIZE.width / 2 + 20,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 + 95,
                                        0
                                    );
                                }

                                var cube_bsp = THREE.CSG.fromMesh(cube_mesh);
                                var subtract_bsp = back_bsp.subtract(cube_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);

                                //------РЕЖЕТ КРОМКУ

                                cube_mesh.scale.set(0.99, 0.99, 0.99);
                                const hem_cube_bsp = THREE.CSG.fromMesh(cube_mesh);
                                const hem_subtract_bsp = back_bsp.subtract(hem_cube_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "right_skos") {
                                var materiald = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var back_bsp = THREE.CSG.fromGeometry(geometry);
                                var cube_geometry = new THREE.CubeGeometry(600, 500, 500);
                                var cube_mesh = new THREE.Mesh(cube_geometry, materiald);

                                if (geometry_type == "ExtrudeGeometry") {
                                    cube_mesh.rotation.x = Math.PI / 2;
                                    cube_mesh.rotation.z = Math.PI / 3;

                                    cube_mesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 + 100, // x
                                        parent_group.PROPS.CONFIG.SIZE.height / 2 + 95, //y
                                        95 //z
                                    );
                                } else {
                                    cube_mesh.rotation.z = Math.PI / 3;
                                    cube_mesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.width / 2 - 20,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 + 95,
                                        0
                                    );
                                }

                                var cube_bsp = THREE.CSG.fromMesh(cube_mesh);
                                var subtract_bsp = back_bsp.subtract(cube_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);
                                //------Повторяет кромку

                                cube_mesh.scale.set(0.99, 0.99, 0.99);
                                const hem_back_bsp = THREE.CSG.fromGeometry(hemGeometry);
                                const hem_cube_bsp = THREE.CSG.fromMesh(cube_mesh);
                                const hem_subtract_bsp = hem_back_bsp.subtract(hem_cube_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "left_zakr") {
                                var back_bsp = THREE.CSG.fromGeometry(geometry);
                                var shape = new THREE.Shape();

                                shape.moveTo(-150, -150);
                                shape.lineTo(150, -150);
                                shape.absarc(
                                    150,
                                    150,
                                    300,
                                    (-90 * Math.PI) / 180,
                                    (-180 * Math.PI) / 180,
                                    true
                                );

                                var extrudeSettings = {
                                    steps: 2,
                                    amount: 48,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);
                                shapeMesh.receiveShadow = true;
                                shapeMesh.castShadow = true;

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.x = Math.PI / 2;
                                    shapeMesh.rotation.z = Math.PI;

                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 150, // x
                                        parent_group.PROPS.CONFIG.SIZE.height / 2, //y
                                        parent_group.PROPS.CONFIG.SIZE.width - 150 //z
                                    );
                                } else {
                                    shapeMesh.rotation.z = -Math.PI / 2;
                                    shapeMesh.position.set(
                                        -parent_group.PROPS.CONFIG.SIZE.width / 2 + 150,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 150,
                                        -24
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);
                                //------------------------------------
                                const hem_shapeMesh = shapeMesh.clone();
                                const hem_back_bsp = THREE.CSG.fromGeometry(hemGeometry);
                                const hem_shapeMesh_bsp = THREE.CSG.fromMesh(hem_shapeMesh);
                                const hem_subtract_bsp = hem_back_bsp.subtract(hem_shapeMesh_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "right_krug") {
                                var back_bsp = THREE.CSG.fromGeometry(geometry);

                                var shape = new THREE.Shape();

                                shape.moveTo(-150, -150);
                                shape.lineTo(150, -150);
                                shape.absarc(
                                    150,
                                    150,
                                    300,
                                    (-90 * Math.PI) / 180,
                                    (-180 * Math.PI) / 180,
                                    true
                                );

                                var extrudeSettings = {
                                    steps: 2,
                                    depth: 48,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);
                                shapeMesh.receiveShadow = true;
                                shapeMesh.castShadow = true;

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.x = Math.PI / 2;
                                    shapeMesh.rotation.z = Math.PI / 2;

                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 150, // x
                                        parent_group.PROPS.CONFIG.SIZE.height / 2, //y
                                        150 //z
                                    );
                                } else {
                                    shapeMesh.rotation.z = Math.PI;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.width / 2 - 150,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 150,
                                        -24
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);

                                hemGeometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "evrozapilpp") {
                                var back_bsp = THREE.CSG.fromGeometry(geometry);

                                var shape = new THREE.Shape();

                                shape.moveTo(-14, -14);
                                shape.lineTo(14, -14);
                                shape.absarc(
                                    14,
                                    14,
                                    28,
                                    (-90 * Math.PI) / 180,
                                    (-180 * Math.PI) / 180,
                                    true
                                );

                                var extrudeSettings = {
                                    steps: 2,
                                    //amount: 48,
                                    depth: 100,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);
                                shapeMesh.receiveShadow = true;
                                shapeMesh.castShadow = true;

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.y = Math.PI;
                                    shapeMesh.rotation.x = Math.PI / 2;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        -parent_group.PROPS.CONFIG.SIZE.height / 2 - 9,
                                        14
                                    );
                                } else {
                                    shapeMesh.rotation.z = Math.PI;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.width / 2 - 14,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        -24
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);

                                const boxGeometry = new THREE.BoxBufferGeometry(
                                    parent_group.PROPS.CONFIG.SIZE.depth,
                                    parent.PROPS.CONFIG.SIZE.height != 26 ?
                                        parent_group.PROPS.CONFIG.SIZE.height : parent_group.PROPS.CONFIG.SIZE.height * 2,
                                    100
                                );
                                const boxGeometryMesh = new THREE.Mesh(boxGeometry);
                                boxGeometryMesh.position.set(1.5, 0, 0);

                                const hem_back_bsp = THREE.CSG.fromGeometry(hemGeometry);
                                const hem_shapeMesh_bsp = THREE.CSG.fromMesh(boxGeometryMesh);
                                const hem_subtract_bsp = hem_back_bsp.subtract(hem_shapeMesh_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "evrozapilpl") {
                                var back_bsp = new THREE.CSG.fromGeometry(geometry);

                                var shape = new THREE.Shape();

                                shape.moveTo(-14, -14);
                                shape.lineTo(14, -14);
                                shape.absarc(
                                    14,
                                    14,
                                    28,
                                    (-90 * Math.PI) / 180,
                                    (-180 * Math.PI) / 180,
                                    true
                                );

                                var extrudeSettings = {
                                    steps: 2,
                                    //depth: 48,
                                    depth: 100,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);
                                shapeMesh.receiveShadow = true;
                                shapeMesh.castShadow = true;

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.y = -Math.PI;
                                    shapeMesh.rotation.x = -Math.PI / 2;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        parent_group.PROPS.CONFIG.SIZE.height / 2 + 12,
                                        parent_group.PROPS.CONFIG.SIZE.width - 14
                                    );
                                } else {
                                    shapeMesh.rotation.z = -Math.PI / 2;
                                    shapeMesh.position.set(
                                        -parent_group.PROPS.CONFIG.SIZE.width / 2 + 14,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        -24
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);

                                const boxGeometry = new THREE.BoxBufferGeometry(
                                    parent_group.PROPS.CONFIG.SIZE.depth,
                                    parent.PROPS.CONFIG.SIZE.height != 26 ?
                                        parent_group.PROPS.CONFIG.SIZE.height : parent_group.PROPS.CONFIG.SIZE.height * 2,
                                    100
                                );
                                const boxGeometryMesh = new THREE.Mesh(boxGeometry);
                                boxGeometryMesh.position.set(
                                    1.5,
                                    0,
                                    parent_group.PROPS.CONFIG.SIZE.width
                                );

                                const hem_back_bsp = THREE.CSG.fromGeometry(hemGeometry);
                                const hem_shapeMesh_bsp = THREE.CSG.fromMesh(boxGeometryMesh);
                                const hem_subtract_bsp = hem_back_bsp.subtract(hem_shapeMesh_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "evrozapilml") {
                                // еврозапил мама слева
                                const mLeftSize = parent_group.PROPS.CONFIG.WIDTHSETTING ?
                                    (parent_group.PROPS.CONFIG.WIDTHSETTING[usluga.ID] || 600) :
                                    parent_group.PROPS.CONFIG.BASKET.WIDTHSETTING?.["USLUGI" + (parent_group.PROPS.CONFIG.RASPILKEY + 1)] ?
                                        (parent_group.PROPS.CONFIG.BASKET.WIDTHSETTING["USLUGI" + (parent_group.PROPS.CONFIG.RASPILKEY + 1)][usluga.ID] || 600) : 600; //Вересников В.Д. 02.04.2024

                                var back_bsp = new THREE.CSG.fromGeometry(geometry);

                                var shape = new THREE.Shape();

                                shape.moveTo(-14, -mLeftSize / 2);
                                shape.lineTo(14, -mLeftSize / 2);
                                shape.absarc(
                                    -14,
                                    mLeftSize / 2 - 28,
                                    28,
                                    (0 * Math.PI) / 180,
                                    (90 * Math.PI) / 180,
                                    false
                                );

                                var extrudeSettings = {
                                    steps: 1,
                                    //depth: 48,
                                    depth: 100,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshStandardMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.y = -Math.PI;
                                    shapeMesh.rotation.x = -Math.PI / 2;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        parent_group.PROPS.CONFIG.SIZE.height / 2 + 12,
                                        parent_group.PROPS.CONFIG.SIZE.width - mLeftSize / 2
                                    );
                                } else {
                                    shapeMesh.rotation.z = -Math.PI / 2;
                                    shapeMesh.position.set(
                                        -parent_group.PROPS.CONFIG.SIZE.width / 2 + 300,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        -24
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);

                                self.assignUVs(geometry);

                                const hem_shapeMesh = shapeMesh.clone();
                                hem_shapeMesh.scale.set(1.2, 1.01, 1.1);
                                const hem_back_bsp = THREE.CSG.fromGeometry(hemGeometry);
                                const hem_shapeMesh_bsp = THREE.CSG.fromMesh(hem_shapeMesh);
                                const hem_subtract_bsp = hem_back_bsp.subtract(hem_shapeMesh_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "evrozapilmp") {

                                const mRightSize = parent_group.PROPS.CONFIG.WIDTHSETTING ?
                                    (parent_group.PROPS.CONFIG.WIDTHSETTING[usluga.ID] || 600) :
                                    parent_group.PROPS.CONFIG.BASKET.WIDTHSETTING?.["USLUGI" + (parent_group.PROPS.CONFIG.RASPILKEY + 1)] ?
                                        (parent_group.PROPS.CONFIG.BASKET.WIDTHSETTING["USLUGI" + (parent_group.PROPS.CONFIG.RASPILKEY + 1)][usluga.ID] || 600) : 600; //Вересников В.Д. 02.04.2024

                                var back_bsp = new THREE.CSG.fromGeometry(geometry);

                                var shape = new THREE.Shape();

                                shape.moveTo(-14, -mRightSize / 2);
                                shape.lineTo(14, -mRightSize / 2);
                                shape.absarc(
                                    -14,
                                    mRightSize / 2 - 28,
                                    28,
                                    (0 * Math.PI) / 180,
                                    (90 * Math.PI) / 180,
                                    false
                                );

                                var extrudeSettings = {
                                    steps: 1,
                                    //depth: 48,
                                    depth: 100,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.y = Math.PI;
                                    shapeMesh.rotation.x = Math.PI / 2;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        -parent_group.PROPS.CONFIG.SIZE.height / 2 - 9,
                                        mRightSize / 2
                                    );
                                } else {
                                    shapeMesh.rotation.z = Math.PI / 2;
                                    shapeMesh.rotation.x = Math.PI;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.width / 2 - 300,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                        24
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);

                                geometry = THREE.CSG.toGeometry(subtract_bsp);

                                self.assignUVs(geometry);

                                const hem_shapeMesh = shapeMesh.clone();
                                hem_shapeMesh.scale.set(1.2, 1.01, 1.01);
                                const hem_back_bsp = THREE.CSG.fromGeometry(hemGeometry);
                                const hem_shapeMesh_bsp = THREE.CSG.fromMesh(hem_shapeMesh);
                                const hem_subtract_bsp = hem_back_bsp.subtract(hem_shapeMesh_bsp);
                                hemGeometry = THREE.CSG.toGeometry(hem_subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }

                            if (usluga.CODE == "barn_zakr") {
                                var back_bsp = THREE.CSG.fromGeometry(geometry);

                                var shape = new THREE.Shape();

                                var depthC = PARENT_DEPTH / 2;
                                shape.moveTo(depthC, depthC);
                                shape.lineTo(-depthC, depthC);
                                shape.lineTo(-depthC, 0);
                                shape.absarc(
                                    0,
                                    0,
                                    depthC,
                                    (-180 * Math.PI) / 180,
                                    (-360 * Math.PI) / 180,
                                    true
                                );

                                var extrudeSettings = {
                                    steps: 2,
                                    depth: 80,
                                    bevelEnabled: false,
                                };

                                var geometryq = new THREE.ExtrudeGeometry(shape, extrudeSettings);
                                var materialq = new THREE.MeshPhongMaterial({color: 0x00ff00});
                                var shapeMesh = new THREE.Mesh(geometryq, materialq);

                                /**
                                 if(geometry_type == 'ExtrudeGeometry') {
                                 shapeMesh.rotation.y = Math.PI;
                                 shapeMesh.rotation.x = Math.PI / 2;
                                 shapeMesh.position.set(
                                 parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                 - parent_group.PROPS.CONFIG.SIZE.height / 2 - 9,
                                 300
                                 );
                                 }else{
                                 shapeMesh.rotation.z = Math.PI / 2;
                                 shapeMesh.rotation.x = Math.PI;
                                 shapeMesh.position.set(
                                 parent_group.PROPS.CONFIG.SIZE.width / 2 - 300,
                                 parent_group.PROPS.CONFIG.SIZE.depth / 2 - 14,
                                 24
                                 );
                                 }
                                 */

                                if (geometry_type == "ExtrudeGeometry") {
                                    shapeMesh.rotation.y = Math.PI;
                                    shapeMesh.rotation.x = Math.PI / 2;
                                    shapeMesh.rotation.z = Math.PI;

                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - depthC, // x
                                        -parent_group.PROPS.CONFIG.SIZE.height / 2 - 9, //y
                                        depthC //z
                                    );
                                } else {
                                    shapeMesh.rotation.z = -Math.PI / 2;
                                    shapeMesh.position.set(
                                        parent_group.PROPS.CONFIG.SIZE.width / 2 - depthC,
                                        parent_group.PROPS.CONFIG.SIZE.depth / 2 - depthC,
                                        -34
                                    );
                                }

                                var shapeMesh_bsp = THREE.CSG.fromMesh(shapeMesh);
                                var subtract_bsp = back_bsp.subtract(shapeMesh_bsp);
                                geometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(geometry);

                                hemGeometry = THREE.CSG.toGeometry(subtract_bsp);
                                self.assignUVs(hemGeometry);
                            }
                        }
                    });
                }
                //переназначить материал
                if (Array.isArray(material) && material.length > 4) {
                    if (geometry.type == "Geometry") {
                        material = [material[4]];//было
                        //material = [material[4], material[3]];
                    }

                    if (geometry.type == "ExtrudeGeometry") {
                        //material = [material[3], material[4]]; //было
                        //material 4 - main
                        //material 3 - hem color
                        material = [material[4], material[4]];
                    }
                }

                if (parent_group?.PROPS?.PRODUCT?.productType == 10336730) {
                    self.CreateFasadeMirror(geometry);
                }

                obj[i.id] = new THREE.Mesh(geometry, material);

                if (isBox) {
                    obj[i.id].receiveShadow = true;
                    obj[i.id].castShadow = true;
                }

                if (i.id === "hor1") {
                    const hemMesh = new THREE.Mesh(hemGeometry, hemMaterials); // выше

                    //Белая кромка
                    const whiteMaterial = new THREE.MeshStandardMaterial({
                        map: self.loadFileCache("/upload/12231.png", "img"),
                    });
                    const whiteMesh = new THREE.Mesh(hemGeometry, whiteMaterial);
                    whiteMesh.scale.set(0.001, 0.99, 1);
                    //Белая кромка

                    if (PROFILE_ID === profile_ids.uugol) {
                        hemMesh.scale.set(0.999, 0.99, 1.001);
                        hemMesh.position.set(0, 0, -1.5);
                        whiteMesh.position.set(-PARENT_DEPTH / 2, 0, 1.5); //Позиция белой кромки(сдвиг назад)
                        if (
                            !USLIGI_LIST.includes(usllugi_ids.kromka_perimetr) &&
                            !USLIGI_LIST.includes(usllugi_ids.kromka_torec)
                        ) {
                            hemMesh.scale.set(0.999, 0.99, 0.999);
                            hemMesh.position.set(0, 0, 1.5);
                        }
                        if (USLIGI_LIST.includes(usllugi_ids.kromka_tri_storony)) {
                            hemMesh.scale.set(1, 0.99, 1.001);
                            hemMesh.position.set(-1.5, 0, -1.5);
                        }
                    }
                    if (PROFILE_ID === profile_ids.u2ugol) {
                        hemMesh.scale.set(0.999, 0.99, 1.001);
                        hemMesh.position.set(0, 0, -1.5);
                        if (
                            !USLIGI_LIST.includes(usllugi_ids.kromka_perimetr) &&
                            !USLIGI_LIST.includes(usllugi_ids.kromka_torec)
                        ) {
                            hemMesh.scale.set(0.999, 0.99, 0.999);
                            hemMesh.position.set(0, 0, 1.5);
                        }
                    }
                    if (PROFILE_ID === profile_ids.gugol || !PROFILE_ID) {
                        hemMesh.scale.set(1, 0.99, 0.999);
                        hemMesh.position.set(1.5, 0, 1.5);

                        whiteMesh.position.set(-PARENT_DEPTH / 2, 0, 1.5); //Позиция белой кромки(сдвиг назад)
                        if (USLIGI_LIST.includes(usllugi_ids.kromka_torec)) {
                            hemMesh.scale.set(1, 0.99, 1.001);
                            hemMesh.position.set(1.5, 0, -1.5);
                        }
                        if (USLIGI_LIST.includes(usllugi_ids.kromka_perimetr)) {
                            hemMesh.scale.set(1.001, 0.99, 1.001);
                            hemMesh.position.set(0, 0, -1.5);
                            whiteMesh.position.set(-PARENT_DEPTH / 2 + 3, 0, 0);
                        }
                        if (USLIGI_LIST.includes(usllugi_ids.left_zakr) || USLIGI_LIST.includes(usllugi_ids.left_skos)) {
                            hemMesh.scale.set(1, 0.99, 1);
                            hemMesh.position.set(1.5, 0, 1.5);
                            if (USLIGI_LIST.includes(usllugi_ids.kromka_torec)) {
                                hemMesh.scale.set(1, 0.99, 1.001);
                                hemMesh.position.set(1.5, 0, -1.5);
                            }
                            if (USLIGI_LIST.includes(usllugi_ids.kromka_perimetr)) {
                                hemMesh.scale.set(1.001, 0.99, 1.001);
                                hemMesh.position.set(0, 0, -1.5);
                                whiteMesh.position.set(-PARENT_DEPTH / 2 + 3, 0, 0);
                            }
                        }
                        if (USLIGI_LIST.includes(usllugi_ids.right_krug) || USLIGI_LIST.includes(usllugi_ids.right_skos)) {
                            hemMesh.scale.set(1, 0.99, 1);
                            hemMesh.position.set(1.5, 0, -1.5);
                            if (USLIGI_LIST.includes(usllugi_ids.left_zakr) || USLIGI_LIST.includes(usllugi_ids.left_skos)) {
                                hemMesh.scale.set(1, 0.99, 1.001);
                                hemMesh.position.set(1.5, 0, -1.5);
                            }
                            if (USLIGI_LIST.includes(usllugi_ids.kromka_torec)) {
                                hemMesh.scale.set(1, 0.99, 1.001);
                                hemMesh.position.set(1.5, 0, -1.5);
                            }
                            if (USLIGI_LIST.includes(usllugi_ids.kromka_perimetr)) {
                                hemMesh.scale.set(1.001, 0.99, 1.001);
                                hemMesh.position.set(0, 0, -1.5);
                                whiteMesh.position.set(-PARENT_DEPTH / 2 + 3, 0, 0);
                            }
                        }
                        if (USLIGI_LIST.includes(usllugi_ids.barn_zakr)) {
                            hemMesh.scale.set(1.001, 0.99, 1);
                            hemMesh.position.set(0, 0, -1.5);
                            whiteMesh.position.set(0, 0, 0);
                            if (USLIGI_LIST.includes(usllugi_ids.kromka_torec)) {
                                hemMesh.scale.set(1.001, 0.99, 1.001);
                                hemMesh.position.set(0, 0, -1.5);
                            }
                        }
                        //if (USLIGI_LIST.includes(usllugi_ids.raspil) ) {
                        // ЕСТЬ БАГ С РАСПИЛОМ С ЗАДНЕЙ КРОМКОЙ
                        //}
                    }

                    if (parent.PROPS && parent.PROPS.CONFIG.SIZE.height == 40 || parent.PROPS && parent.PROPS.CONFIG.SIZE.height == 38) {
                        obj[i.id].add(whiteMesh);
                        obj[i.id].add(hemMesh);
                    }

                }

                obj[i.id].name = i.id
                group.add(obj[i.id]);
            } else if (i.type == "link") {
                obj[i.id] = obj[i.link].clone();
                obj[i.id].name = i.id
                group.add(obj[i.id]);
            }

            if (i.position) {
                i.position = self.getExec(i.position);
                obj[i.id].position.set(i.position.x, i.position.y, i.position.z);
            }

            if (i.rotation) {
                i.rotation = self.getExec(i.rotation);

                angular.forEach(i.rotation, function (value, key) {
                    if (Math.abs(value) > 10)
                        i.rotation[key] = value * self.scope.app.constants.deg_to_rad_coefficient
                })

                obj[i.id].rotation.set(i.rotation.x, i.rotation.y, i.rotation.z);
            }

            obj[i.id]["NAME"] = i.id;

            if (self.scope.outlineType) {
                obj[i.id].material.map = false;
                obj[i.id].material = new THREE.MeshPhongMaterial({color: "#f4ca16", opacity: 0.25, transparent: true});
                self.createEdge(obj[i.id]);
            }

            if (parent) {
                obj[i.id]["PARENT"] = parent.id;
                if (
                    parent.PROPS.PRODUCT.element_type == "element_room" &&
                    i.id != "bottom" &&
                    i.id != "top"
                ) {
                    self.scope.app.room.push(obj[i.id]);
                }
            }
        });

        group.ELEMENTS = obj;

        if (conf.position != undefined)
            group.position.set(conf.position.x, conf.position.y, conf.position.z);

        group.unionBoudingBox = self.calculateUnionBoundingBox(group)
        group.name = "ModuleGeometry"

        return group;
    };

    this.ExtrudeBoxGeometry = function (opt) {
        var extrusionSettings = $.extend(
            {
                depth: 16,
                curveSegments: 1,
                bevelThickness: 0,
                bevelSize: 1,
                bevelSegments: 1,
                bevelEnabled: false,
            },
            opt
        );

        extrusionSettings.depth = opt.z;

        if (opt.bevelEnabled) {
            opt.x -= extrusionSettings.bevelSize * 2;
            opt.y -= extrusionSettings.bevelSize * 2;
        }

        var geometry = new THREE.ExtrudeGeometry(
            new THREE.Shape([
                new THREE.Vector2(-opt.x / 2, -opt.y / 2),
                new THREE.Vector2(opt.x / 2, -opt.y / 2),
                new THREE.Vector2(opt.x / 2, opt.y / 2),
                new THREE.Vector2(-opt.x / 2, opt.y / 2),
            ]),
            extrusionSettings
        );

        return geometry;
    };

    this.CreateFasadeKant = function (geometry) {

        for (let face of geometry.faces) {
            if (Math.abs(face.normal.y) === 1 || Math.abs(face.normal.x) === 1)
                face.materialIndex = 1
        }

        return geometry;
    };

    this.CreateFasadeMirror = function (geometry) {

        for (let face of geometry.faces) {
            if (face.normal.z === 1)
                face.materialIndex = 1
            else
                face.materialIndex = 0
        }

        return geometry;
    };

    this.filterColor = function () {
        return function (items, criteria) {
            var list = [];
            var product =
                criteria && criteria.product != undefined
                    ? criteria.product
                    : self.scope.app.active.PROPS.PRODUCT;

            angular.forEach(product.COLOR, function (i, k) {
                if (items[i] != undefined) list.push(items[i]);
            });

            return list;
        };
    };

    this.changeColor = function (news, old) {
        if (news) {
            self.scope.app.active.PROPS.CONFIG.BASKET["COLOR"] = news;
            self.updateElement(self.scope.app.active);
        }
    };

    this.changeModuleColor = function (news, old) {
        if (news) {
            if (self.scope.app.optionsTabName == "defaultModuleColor") {
                self.changeDefaultModuleColor(self.scope.app.default_module_color_btn, news);
            } else {
                if (self.scope.app.active) {
                    self.changeElementModuleColor(self.scope.app.active, news);
                }
            }
        }
    };

    this.changeProfileColor = function (news, group = self.scope.app.active) {
        if (news) {
            if (self.scope.app.optionsTabName == "defaultProfileColor") {
                self.changeDefaultProfileColor(self.scope.app.default_module_color_btn, news);
            } else {
                if (self.scope.app.active) {
                    self.changeElementProfileColor(self.scope.app.active, news);
                }
            }
        }
    };

    this.changeProfileType = function (news, group = self.scope.app.active) {
        if (news) {
            if (group) {
                let fasadeNumber = self.scope.app.active_fasade

                if (fasadeNumber) {
                    group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber].PRODUCT_ID = news
                } else {
                    angular.forEach(group.PROPS.CONFIG.BASKET.SIDEPROFILE, function (profile, key) {
                        profile.PRODUCT_ID = news
                    })
                }

                self.updateSideHiTechProfile(group, fasadeNumber);
            }
        }
    };

    this.updateExtraModels = function (group = self.scope.app.active) {

        if (group) {
            if (!group.PROPS.CONFIG.EXTRAMODELS)
                group.PROPS.CONFIG.EXTRAMODELS = {}

            angular.forEach(group.PROPS.CONFIG.EXTRAMODELS, function (item, key) {
                if (key !== "BENCHPARTITION") {
                    const option = self.scope.app.OPTION[item?.[0]?.option];

                    let productID = option?.PRODUCT?.[0]
                    if (!productID)
                        return

                    const product = self.scope.app.CATALOG.PRODUCTS[productID]
                    self.updateExtraModel(option, product, group)
                }
            })

        }

    }

    this.updateExtraModel = function (option, product, group = self.scope.app.active) {

        if (group && option && product) {
            const doubleTable = group.PROPS.PRODUCT.DOUBLE_TABLE ? true : false
            const elementsCount = group.PROPS.PRODUCT.FASADE_POSITION.length
            const fasadePosition = self.getFasadePosition(group, 1)
            const FASADE_WIDTH = group.PROPS.CONFIG.SIZE.width / (doubleTable ? group.PROPS.PRODUCT.FASADE_POSITION.length / 2 : group.PROPS.PRODUCT.FASADE_POSITION.length)

            let optionsPosition = self.scope.app.OPTION_POSITIONS?.[option.ID]?.[group.PROPS.PRODUCT.ID]
            optionsPosition = optionsPosition ? self.getExec(
                self.expressionsReplace(
                    optionsPosition,
                    angular.extend({}, {
                        "#X#": group.PROPS.CONFIG.SIZE.width,
                        "#Y#": group.PROPS.CONFIG.SIZE.height,
                        "#Z#": doubleTable ? 0 : group.PROPS.CONFIG.SIZE.depth,
                        "#X_CORRECTION#": group.PROPS.CONFIG.SIZE.width,
                        "#Y_CORRECTION#": group.PROPS.CONFIG.SIZE.height,
                        "#Z_CORRECTION#": doubleTable ? group.PROPS.CONFIG.SIZE.depth / 2 : group.PROPS.CONFIG.SIZE.depth,
                        "#MATERIAL_THICKNESS#": fasadePosition.FASADE_DEPTH,
                        "#FASADE_WIDTH#": FASADE_WIDTH,
                        "#EXTRA_WIDTH#": product.width,
                        "#EXTRA_HEIGHT#": product.height,
                        "#EXTRA_DEPTH#": product.depth,
                    })
                )
            ) : false

            let position = optionsPosition ? new THREE.Vector3(optionsPosition.X, optionsPosition.Y, optionsPosition.Z) :
                new THREE.Vector3(
                    -group.PROPS.CONFIG.SIZE.width / 2,
                    group.PROPS.CONFIG.SIZE.height / 2 + fasadePosition.FASADE_DEPTH + product.height / 2,
                    doubleTable ? 50 : -group.PROPS.CONFIG.SIZE.depth / 2 + 100
                )
            let position2 = new THREE.Vector3(optionsPosition.X2, optionsPosition.Y2, optionsPosition.Z2)
            let BASKET = {}
            if (product.MODULECOLOR?.[0] || product.COLOR?.[0])
                BASKET.MODULECOLOR = product.MODULECOLOR?.[0] || product.COLOR?.[0]

            for (let i = 0; i < elementsCount; doubleTable ? i += 2 : i++) {

                group.PROPS.CONFIG.EXTRAMODELS[option.GROUP][i] = {
                    PROPS: {
                        CONFIG: {
                            BASKET,
                            SIZE: {width: product.width, height: product.height, depth: product.depth},
                            POSITION: position,
                        },
                        PRODUCT: Object.assign({}, product),
                    },
                    type: option.GROUP,
                    option: option.ID,
                    mesh: false
                }

                if (doubleTable) {

                    group.PROPS.CONFIG.EXTRAMODELS[option.GROUP][i + 1] = {
                        PROPS: {
                            CONFIG: {
                                BASKET,
                                SIZE: {width: product.width, height: product.height, depth: product.depth},
                                POSITION: position2,
                                SCALE: new THREE.Vector3(-1, 1, 1),
                            },
                            PRODUCT: Object.assign({}, product),
                        },
                        type: option.GROUP,
                        mesh: false
                    }

                    position2 = position2.clone()
                    position2.x += FASADE_WIDTH
                }
                position = position.clone()
                position.x += FASADE_WIDTH
            }

        }

    }

    this.changeBenchExtraModel = function (option, _productID, group = self.scope.app.active) {

        if (option && group) {
            let productID = _productID || option.PRODUCT?.[0]

            if (!productID)
                return

            const product = self.scope.app.CATALOG.PRODUCTS[productID]

            if (!group.PROPS.CONFIG.EXTRAMODELS)
                group.PROPS.CONFIG.EXTRAMODELS = {}

            group.PROPS.CONFIG.EXTRAMODELS[option.GROUP] = {}

            self.updateExtraModel(option, product, group)
            self.updateElement(group)
        }

    }

    this.changeBenchPartition = function (news) {

        if (self.scope.app.active) {
            const group = self.scope.app.active
            const partition_product = self.scope.app.CATALOG.PRODUCTS[6051066]
            const doubleTable = group.PROPS.PRODUCT.DOUBLE_TABLE ? true : false

            if (!group.PROPS.CONFIG.EXTRAMODELS)
                group.PROPS.CONFIG.EXTRAMODELS = {}

            if (!group.PROPS.CONFIG.BASKET['BENCHPARTITION']) {
                const partition_count = doubleTable ? group.PROPS.PRODUCT.FASADE_POSITION.length / 2 : group.PROPS.PRODUCT.FASADE_POSITION.length

                group.PROPS.CONFIG.BASKET['BENCHPARTITION'] = {
                    COLOR: self.scope.fasadeErrorColor,
                    SIZE: {width: partition_product.width, height: partition_product.height},
                    COUNT: partition_count,
                    product: 6051066
                }
            }

            if (news)
                self.changeElementSideModuleColor(group, news, "BENCHPARTITION");

            self.updateBenchPartition(group, news)
            self.updateElement(group)
        }

    }

    this.changeBenchPartitionSize = function (key, newSize) {

        if (self.scope.app.active && newSize) {
            const group = self.scope.app.active

            if (group.PROPS.CONFIG.BASKET['BENCHPARTITION']) {
                group.PROPS.CONFIG.BASKET['BENCHPARTITION'].SIZE[key] = newSize
                self.updateBenchPartition(group)
                self.updateElement(group)
            }
        }

    }

    this.updateBenchPartition = function (_group, news) {
        const group = _group || self.scope.app.active

        if (group) {

            if (group.PROPS.CONFIG.BASKET['BENCHPARTITION']) {
                const fasadePosition = self.getFasadePosition(group, 1)
                const doubleTable = group.PROPS.PRODUCT.DOUBLE_TABLE ? true : false
                const partition_product = self.scope.app.CATALOG.PRODUCTS[group.PROPS.CONFIG.BASKET['BENCHPARTITION'].product]
                const FASADE_WIDTH = group.PROPS.CONFIG.SIZE.width / group.PROPS.CONFIG.BASKET['BENCHPARTITION'].COUNT

                group.PROPS.CONFIG.EXTRAMODELS['BENCHPARTITION'] = {}

                let position = new THREE.Vector3(
                    -group.PROPS.CONFIG.SIZE.width / 2,
                    group.PROPS.CONFIG.SIZE.height / 2 - 253 + group.PROPS.CONFIG.BASKET['BENCHPARTITION'].SIZE.height / 2,
                    doubleTable ? 50 : -group.PROPS.CONFIG.SIZE.depth / 2 + 41
                )

                for (let i = 0; i < group.PROPS.CONFIG.BASKET['BENCHPARTITION'].COUNT; i++) {
                    position.x += FASADE_WIDTH / 2

                    group.PROPS.CONFIG.EXTRAMODELS['BENCHPARTITION'][i] = {
                        PROPS: {
                            CONFIG: {
                                BASKET: {
                                    FASADE1: {0: news || group.PROPS.CONFIG.BASKET['BENCHPARTITION'].COLOR},
                                },
                                SIZE: {
                                    width: group.PROPS.CONFIG.BASKET['BENCHPARTITION'].SIZE.width,
                                    height: group.PROPS.CONFIG.BASKET['BENCHPARTITION'].SIZE.height,
                                    depth: partition_product.depth
                                },
                                POSITION: position,
                            },
                            PRODUCT: Object.assign({}, partition_product),
                        },
                        type: 'BENCHPARTITION',
                        mesh: false
                    }

                    if (group.PROPS.CONFIG.BASKET['BENCHPARTITION'].PALETTE)
                        group.PROPS.CONFIG.EXTRAMODELS['BENCHPARTITION'][i].PROPS.CONFIG.BASKET.PALETTE1 = {0: group.PROPS.CONFIG.BASKET['BENCHPARTITION'].PALETTE}

                    position = position.clone()
                    position.x += FASADE_WIDTH / 2
                }
            }
        }

    }

    this.deleteBenchPartition = function () {
        if (self.scope.app.active) {
            const group = self.scope.app.active

            delete group.PROPS.CONFIG.BASKET['BENCHPARTITION']
            delete group.PROPS.CONFIG.EXTRAMODELS['BENCHPARTITION']

            if (!Object.keys(group.PROPS.CONFIG.EXTRAMODELS).length)
                delete group.PROPS.CONFIG.EXTRAMODELS

            self.updateElement(group)
        }
    }

    this.deleteBenchExtraModel = function (option, group = self.scope.app.active) {
        if (option && group) {

            delete group.PROPS.CONFIG.EXTRAMODELS[option.GROUP]

            if (!Object.keys(group.PROPS.CONFIG.EXTRAMODELS).length)
                delete group.PROPS.CONFIG.EXTRAMODELS

            self.updateElement(group)
        }
    }

    this.changeBackModuleColor = function (news) {

        if (self.scope.app.active) {
            const group = self.scope.app.active

            if (typeof group.PROPS.CONFIG.BASKET['BACKWALL'] === "number")
                group.PROPS.CONFIG.BASKET['BACKWALL'] = {COLOR: false}

            self.changeElementSideModuleColor(group, news, "BACKWALL");

            self.updateElement(group)
        }

    }
    //!!!смена полок
    /* this.changeShelfModuleColor = function (news) {
    if (self.scope.app.active) {
      const group = self.scope.app.active
      group.PROPS.CONFIG.BASKET.SHELF_COLOR = news
      self.updateElement(group)
    }
  } */

    this.deleteBackwall = function () {
        if (self.scope.app.active) {
            const group = self.scope.app.active

            if (group.PROPS.CONFIG.BASKET['BACKWALL']?.COLOR === false) {
                var modulecolor_list = self.$filter("filterModuleColor")(group.PROPS.PRODUCT.BACKWALL);
                group.PROPS.CONFIG.BASKET["BACKWALL"] = {
                    COLOR: self.calcDefaultModuleColor(
                        group.PROPS.PRODUCT,
                        modulecolor_list
                    )
                }

                //delete group.PROPS.CONFIG.BASKET['BACKWALL']
            } else {
                group.PROPS.CONFIG.BASKET['BACKWALL'] = {COLOR: false}
            }

            self.updateElement(group)
        }
    }

    //Очистка BASKET от поля BACKWALL
    /* this.clearBackwallBasket = function (group = self.scope.app.active) {
         if (group) {
             delete group.PROPS.CONFIG.BASKET['BACKWALL']
             self.updateElement(group)
         }
     }*/

    this.deleteTopFasade = function () {
        if (self.scope.app.active) {
            const group = self.scope.app.active

            if (group.PROPS.CONFIG.BASKET['TOPFASADECOLOR']) {
                delete group.PROPS.CONFIG.BASKET['TOPFASADECOLOR']
            } else {
                group.PROPS.CONFIG.BASKET['TOPFASADECOLOR'] = {COLOR: 7397}
            }

            self.updateElement(group)
        }
    }

    this.deleteHorizont = function () {
        if (self.scope.app.active) {
            const group = self.scope.app.active
            delete group.PROPS.CONFIG.recalcFasadeHeight

            let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];
            let moduleThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

            const HEIGHT_CORNICE = group.PROPS.CONFIG.NOBOTTOM ? 0 : moduleThickness || +filling.HEIGHT_CORNICE
            //const HEIGHT_PLINTH = +filling.HEIGHT_PLINTH

            if (!filling) {
                self.alert('Ошибка наполнения, не удалось изменить размер горизонта')
                return
            }

            if (group.PROPS.CONFIG.BASKET.HORIZONT === 0) {
                group.PROPS.CONFIG.BASKET.HORIZONT = 78
            } else {
                group.PROPS.CONFIG.BASKET.HORIZONT = 0
            }

            group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT = HEIGHT_CORNICE

            self.scope.$applyAsync();
            self.updateElement(group)
        }
    }

    this.changeHorizontHeight = function (newHeight) {
        if (self.scope.app.active) {
            const group = self.scope.app.active
            delete group.PROPS.CONFIG.recalcFasadeHeight

            let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];
            let moduleThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

            const HEIGHT_CORNICE = group.PROPS.CONFIG.NOBOTTOM ? 0 : moduleThickness || +filling.HEIGHT_CORNICE
            //const HEIGHT_PLINTH = +filling.HEIGHT_PLINTH

            if (!filling) {
                self.alert('Ошибка наполнения, не удалось изменить размер горизонта')
                return
            }

            if (newHeight !== group.PROPS.CONFIG.BASKET.HORIZONT && newHeight > 0) {
                group.PROPS.CONFIG.BASKET.HORIZONT = newHeight
            } else if (group.PROPS.CONFIG.BASKET.HORIZONT === undefined) {
                group.PROPS.CONFIG.BASKET.HORIZONT = 78
            }

            group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT = HEIGHT_CORNICE

            self.scope.$applyAsync();
            self.updateElement(group)
        }
    }

    this.changeElementSideModuleColor = function (group, color, side) {
        if (self.scope.app.CUSTOM_SIDE_COLORS[color] != -1) {

            var PROPS = group.PROPS;
            var CONFIG = group.PROPS.CONFIG;
            var PRODUCT = group.PROPS.PRODUCT;
            const exceptions = ["BACKWALL", "BENCHPARTITION"]

            if (color == group.PROPS.CONFIG.BASKET.MODULECOLOR && !exceptions.includes(side))
                delete group.PROPS.CONFIG.BASKET[side]
            else {

                if (group.PROPS.CONFIG.BASKET[side])
                    group.PROPS.CONFIG.BASKET[side].COLOR = color
                else
                    group.PROPS.CONFIG.BASKET[side] = {COLOR: color};

                var fasadeColor = self.scope.app.FASADE[color];

                /*Параметры по умолчанию*/
                if (PRODUCT.element_type == "element_up") {
                    var default_prop = {
                        fasade: self.scope.project.default_fasade_up,
                        milling: self.scope.project.default_fasade_milling_up,
                        patina: self.scope.project.default_fasade_patina_up,
                        palette: self.scope.project.default_fasade_palette_up,
                    };
                } else {
                    var default_prop = {
                        fasade: self.scope.project.default_fasade_down,
                        milling: self.scope.project.default_fasade_milling_down,
                        patina: self.scope.project.default_fasade_patina_down,
                        palette: self.scope.project.default_fasade_palette_down,
                    };
                }
                /*Параметры по умолчанию*/

                /*Контроль фрезеровки*/
                if (!exceptions.includes(side) && PRODUCT.MILLING.length && PRODUCT.MILLING[0]) {
                    var millingList = self.GetMillingList(color, PRODUCT.ID)
                    var millingItem = false

                    const oldMillingBasket = group.PROPS.CONFIG.BASKET[side].MILLING

                    let millingBasket = group.PROPS.CONFIG.BASKET[side].MILLING

                    if (millingList.length) {
                        if (
                            millingBasket == undefined ||
                            self.scope.issetDefaultFasade ||
                            millingList.indexOf(millingBasket) == -1
                        )
                            if (
                                default_prop &&
                                default_prop.milling &&
                                millingList.indexOf(default_prop.milling) != -1
                            ) {
                                millingBasket = default_prop.milling;

                            } else {
                                millingBasket = millingList[0];
                            }

                        group.PROPS.CONFIG.BASKET[side].MILLING = +millingBasket;

                        millingItem = self.scope.app.MILLING[millingBasket];
                    } else {
                        delete group.PROPS.CONFIG.BASKET[side].MILLING
                    }
                }
                /*Контроль фрезеровки*/

                /*Контроль Патины*/
                if (
                    !exceptions.includes(side) && fasadeColor.PATINA[0] &&
                    (!millingItem || (millingItem && !millingItem.PATINAOFF))
                ) {
                    var patinaList = fasadeColor.PATINA
                    var patinaBasket = group.PROPS.CONFIG.BASKET[side].PATINA;

                    if (
                        patinaBasket == undefined ||
                        self.scope.issetDefaultFasade ||
                        patinaList.indexOf(patinaBasket) == -1
                    )
                        if (
                            default_prop &&
                            default_prop.patina &&
                            patinaList.indexOf(default_prop.patina) != -1
                        )
                            patinaBasket = default_prop.patina;
                        else
                            patinaBasket = fasadeColor.PATINA[0];

                    group.PROPS.CONFIG.BASKET[side].PATINA = +patinaBasket;
                } else {
                    delete group.PROPS.CONFIG.BASKET[side].PATINA
                }
                /*Контроль Патины*/

                /*Контроль Палитры*/
                if (fasadeColor.PALETTE[0]) {
                    var palettelist = self.$filter("filterPalette")(self.scope.app.PALETTE, {
                        element: color,
                    })
                    var paletteBasket = group.PROPS.CONFIG.BASKET[side].PALETTE

                    if (
                        paletteBasket == undefined ||
                        self.scope.issetDefaultFasade ||
                        palettelist[paletteBasket] == undefined
                    )
                        if (
                            default_prop &&
                            default_prop.palette &&
                            palettelist[default_prop.palette] != undefined
                        )
                            paletteBasket = default_prop.palette;
                        else paletteBasket = Object.keys(palettelist)[0];

                    group.PROPS.CONFIG.BASKET[side].PALETTE = +paletteBasket;

                } else {
                    delete group.PROPS.CONFIG.BASKET[side].PALETTE
                }
                /*Контроль Палитры*/

            }

            self.updateElement(group);
        }
    };

    // Left
    this.changeLeftModuleColor = function (news, old) {
        if (news) {
            if (self.scope.app.optionsTabName == "defaultModuleColor") {
                self.changeDefaultModuleColor(self.scope.app.default_module_color_btn, news, "LEFTSIDECOLOR");
            } else {
                if (self.scope.app.active) {
                    self.changeElementSideModuleColor(self.scope.app.active, news, "LEFTSIDECOLOR");
                }
            }
        }
    };

    this.changeLeftModuleColorMilling = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['LEFTSIDECOLOR'].MILLING = news
                self.updateElement(group);
            } else { //ГЛОБАЛЬНАЯ НАСТРОЙКА ФРЕЗЕРОВКИ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModuleMillingUp") {
                    self.scope.project.default_left_module_milling_up = news;
                    self.ChangeDefaultLeftModuleMilling("element_up", self.scope.project.default_left_module_milling_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModuleMillingDown") {
                    self.scope.project.default_left_module_milling_down = news;
                    self.ChangeDefaultLeftModuleMilling(
                        "element_down",
                        self.scope.project.default_left_module_milling_down
                    );
                }*/
            }
        }
    };

    this.changeLeftModuleColorPalette = function (news, old) {
        const group = self.scope.app.active

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['LEFTSIDECOLOR'].PALETTE = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАЛИТРЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModulePaletteUp") {
                    self.scope.project.default_left_module_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_left_module_palette_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModulePaletteDown") {
                    self.scope.project.default_left_module_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_left_module_palette_down
                    );
                }*/
            }
        }
    };

    this.changeBenchPartitionColorPalette = function (news, old) {
        const group = self.scope.app.active

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['BENCHPARTITION'].PALETTE = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАЛИТРЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModulePaletteUp") {
                    self.scope.project.default_left_module_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_left_module_palette_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModulePaletteDown") {
                    self.scope.project.default_left_module_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_left_module_palette_down
                    );
                }*/
            }
        }
    };

    this.changeBackModuleColorPalette = function (news, old) {
        const group = self.scope.app.active

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['BACKWALL'].PALETTE = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАЛИТРЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModulePaletteUp") {
                    self.scope.project.default_left_module_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_left_module_palette_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModulePaletteDown") {
                    self.scope.project.default_left_module_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_left_module_palette_down
                    );
                }*/
            }
        }
    };

    this.changeBackModuleColorMilling = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['BACKWALL'].MILLING = news
                self.updateElement(group);
            } else { //ГЛОБАЛЬНАЯ НАСТРОЙКА ФРЕЗЕРОВКИ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModuleMillingUp") {
                    self.scope.project.default_left_module_milling_up = news;
                    self.ChangeDefaultLeftModuleMilling("element_up", self.scope.project.default_left_module_milling_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModuleMillingDown") {
                    self.scope.project.default_left_module_milling_down = news;
                    self.ChangeDefaultLeftModuleMilling(
                        "element_down",
                        self.scope.project.default_left_module_milling_down
                    );
                }*/
            }
        }
    };

    this.changeBackModuleColorPatina = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['BACKWALL'].PATINA = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАТИНЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModulePatinaUp") {
                    self.scope.project.default_left_module_patina_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_left_module_patina_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModulePatinaDown") {
                    self.scope.project.default_left_module_patina_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_left_module_patina_down
                    );
                }*/
            }
        }
    };

    this.changeLeftModuleColorPatina = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['LEFTSIDECOLOR'].PATINA = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАТИНЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModulePatinaUp") {
                    self.scope.project.default_left_module_patina_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_left_module_patina_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModulePatinaDown") {
                    self.scope.project.default_left_module_patina_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_left_module_patina_down
                    );
                }*/
            }
        }
    };
    //

    // Right
    this.changeRightModuleColor = function (news, old) {
        if (news) {
            if (self.scope.app.optionsTabName == "defaultModuleColor") {
                self.changeDefaultModuleColor(self.scope.app.default_module_color_btn, news, "RIGHTSIDECOLOR");
            } else {
                if (self.scope.app.active) {
                    self.changeElementSideModuleColor(self.scope.app.active, news, "RIGHTSIDECOLOR");
                }
            }
        }
    };

    this.changeRightModuleColorMilling = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['RIGHTSIDECOLOR'].MILLING = news
                self.updateElement(group);
            } else { //ГЛОБАЛЬНАЯ НАСТРОЙКА ФРЕЗЕРОВКИ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultRightModuleMillingUp") {
                    self.scope.project.default_right_module_milling_up = news;
                    self.ChangeDefaultLeftModuleMilling("element_up", self.scope.project.default_right_module_milling_up);
                } else if (self.scope.app.optionsTabName == "defaultRightModuleMillingDown") {
                    self.scope.project.default_right_module_milling_down = news;
                    self.ChangeDefaultLeftModuleMilling(
                        "element_down",
                        self.scope.project.default_right_module_milling_down
                    );
                }*/
            }
        }
    };

    this.changeRightModuleColorPalette = function (news, old) {
        const group = self.scope.app.active

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['RIGHTSIDECOLOR'].PALETTE = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАЛИТРЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultRightModulePaletteUp") {
                    self.scope.project.default_right_module_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_right_module_palette_up);
                } else if (self.scope.app.optionsTabName == "defaultRightModulePaletteDown") {
                    self.scope.project.default_right_module_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_right_module_palette_down
                    );
                }*/
            }
        }
    };

    this.changeRightModuleColorPatina = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['RIGHTSIDECOLOR'].PATINA = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАТИНЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultRightModulePatinaUp") {
                    self.scope.project.default_right_module_patina_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_right_module_patina_up);
                } else if (self.scope.app.optionsTabName == "defaultRightModulePatinaDown") {
                    self.scope.project.default_right_module_patina_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_right_module_patina_down
                    );
                }*/
            }
        }
    };
    //

    // Top
    this.changeTopFasadeColor = function (news, old) {
        if (news) {
            if (self.scope.app.optionsTabName == "defaultModuleColor") {
                // self.changeDefaultModuleColor(self.scope.app.default_module_color_btn, news, "TOPFASADECOLOR");
            } else {
                if (self.scope.app.active) {
                    self.changeElementSideModuleColor(self.scope.app.active, news, "TOPFASADECOLOR");
                }
            }
        }
    };

    this.changeTopFasadeColorPalette = function (news, old) {
        const group = self.scope.app.active

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['TOPFASADECOLOR'].PALETTE = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАЛИТРЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultRightModulePaletteUp") {
                    self.scope.project.default_right_module_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_right_module_palette_up);
                } else if (self.scope.app.optionsTabName == "defaultRightModulePaletteDown") {
                    self.scope.project.default_right_module_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_right_module_palette_down
                    );
                }*/
            }
        }
    };

    this.changeTopFasadeModuleColorMilling = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['TOPFASADECOLOR'].MILLING = news
                self.updateElement(group);
            } else { //ГЛОБАЛЬНАЯ НАСТРОЙКА ФРЕЗЕРОВКИ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModuleMillingUp") {
                    self.scope.project.default_left_module_milling_up = news;
                    self.ChangeDefaultLeftModuleMilling("element_up", self.scope.project.default_left_module_milling_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModuleMillingDown") {
                    self.scope.project.default_left_module_milling_down = news;
                    self.ChangeDefaultLeftModuleMilling(
                        "element_down",
                        self.scope.project.default_left_module_milling_down
                    );
                }*/
            }
        }
    };

    this.changeTopFasadeModuleColorPatina = function (news, old) {
        const group = self.scope.app.active

        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['TOPFASADECOLOR'].PATINA = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАТИНЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultLeftModulePatinaUp") {
                    self.scope.project.default_left_module_patina_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_left_module_patina_up);
                } else if (self.scope.app.optionsTabName == "defaultLeftModulePatinaDown") {
                    self.scope.project.default_left_module_patina_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_left_module_patina_down
                    );
                }*/
            }
        }
    };

    this.calcDefaultModuleColor = function (product, list) {
        var ret = list[0];

        var module_type = product.element_type == "element_down" ? "down" : "up";

        var def = self.scope.project["default_module_color_" + module_type];

        if (def && list.indexOf(def) != -1) {
            ret = def;
        }

        return ret;
    };

    this.changeElementModuleColor = function (group, color) {
        if (group.PROPS.PRODUCT.MODULECOLOR.indexOf(color) != -1) {
            var PROPS = group.PROPS;
            var CONFIG = group.PROPS.CONFIG;
            var PRODUCT = group.PROPS.PRODUCT;

            let moduleThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
            let newModuleThickness = self.scope.app.FASADE[color]?.DEPTH || 18

            CONFIG.BASKET["MODULECOLOR"] = color;

            if (moduleThickness != newModuleThickness) {

                if (CONFIG.BASKET['SECTIONS1'])
                    self.calcSectionsWidth(group)

                if (CONFIG.BASKET.PLINTH_HEIGHT) {
                    let filling = CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][CONFIG.BASKET["FILLING"]];
                    let PLINTH_HEIGHT = (!CONFIG.BASKET.HORIZONT && CONFIG.BASKET.HORIZONT !== 0) && filling?.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : newModuleThickness || 0;

                    CONFIG.BASKET.PLINTH_HEIGHT = PLINTH_HEIGHT
                }
            }

            /*Параметры по умолчанию*/
            if (PRODUCT.element_type == "element_up") {
                var default_prop = {
                    fasade: self.scope.project.default_fasade_up,
                    milling: self.scope.project.default_fasade_milling_up,
                    patina: self.scope.project.default_fasade_patina_up,
                    palette: self.scope.project.default_fasade_palette_up,
                };
            } else {
                var default_prop = {
                    fasade: self.scope.project.default_fasade_down,
                    milling: self.scope.project.default_fasade_milling_down,
                    patina: self.scope.project.default_fasade_patina_down,
                    palette: self.scope.project.default_fasade_palette_down,
                };
            }
            /*Параметры по умолчанию*/
            var fasadeColor = self.scope.app.FASADE[color];

            /*Контроль Палитры*/
            if (fasadeColor.PALETTE[0]) {
                var palettelist = self.$filter("filterPalette")(self.scope.app.PALETTE, {
                    element: color,
                })
                var paletteBasket = group.PROPS.CONFIG.BASKET["MODULECOLOR_PALETTE"]

                if (
                    paletteBasket == undefined ||
                    self.scope.issetDefaultFasade ||
                    palettelist[paletteBasket] == undefined
                )
                    if (
                        default_prop &&
                        default_prop.palette &&
                        palettelist[default_prop.palette] != undefined
                    )
                        paletteBasket = default_prop.palette;
                    else paletteBasket = Object.keys(palettelist)[0];

                group.PROPS.CONFIG.BASKET["MODULECOLOR_PALETTE"] = +paletteBasket;

            } else {
                delete group.PROPS.CONFIG.BASKET["MODULECOLOR_PALETTE"]
            }
            /*Контроль Палитры*/

            self.updateElement(group);
        }
    };

    this.changeElementModuleColorPalette = function (news, old) {
        const group = self.scope.app.active

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                group.PROPS.CONFIG.BASKET['MODULECOLOR_PALETTE'] = +news;
                self.updateElement(group);
            } else {  //ГЛОБАЛЬНАЯ НАСТРОЙКА ПАЛИТРЫ - НЕ РЕАЛИЗОВНА
                /*if (self.scope.app.optionsTabName == "defaultRightModulePaletteUp") {
                    self.scope.project.default_right_module_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_right_module_palette_up);
                } else if (self.scope.app.optionsTabName == "defaultRightModulePaletteDown") {
                    self.scope.project.default_right_module_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_right_module_palette_down
                    );
                }*/
            }
        }
    };

    this.changeElementProfileColor = function (group, color) {
        group.PROPS.CONFIG.BASKET["PROFILECOLOR"] = color;
        self.updateElement(group);
    };

    this.changeDefaultModuleColor = function (type, news) {
        self.scope.project["default_module_color_" + type] = news;

        angular.forEach(self.scope.app.elementsObj, function (e, k) {
            if (e.PROPS != undefined) {
                var product = e.PROPS.PRODUCT;
                if (product.element_type == "element_" + type)
                    self.changeElementModuleColor(e, news);
            }
        });
    };

    this.changeDefaultProfileColor = function (type, news) {
        self.scope.project["default_profile_color_" + type] = news;

        angular.forEach(self.scope.app.elementsObj, function (e, k) {
            if (e.PROPS != undefined) {
                var product = e.PROPS.PRODUCT;
                if (self.scope.app.CATALOG.SECTIONS[product.OPTIONSECTION_ID].TYPE.toLowerCase().includes("hitech"))
                    self.changeElementProfileColor(e, news);
            }
        });
    };

    this.changeFilling = function (news, old) {
        let isFill = false;

        if (self.scope.app.active.PROPS.PRODUCT.models[0]) {
            if (
                self.scope.app.MODELS[self.scope.app.active.PROPS.PRODUCT.models[0]].loop_position
            ) {
                for (let i = 0; i <= 10; i++) {
                    const name = "SECTIONSFILLING" + i;

                    if (self.scope.app.active.PROPS.CONFIG.BASKET) {
                        if (self.scope.app.active.PROPS.CONFIG.BASKET[name]) {
                            if (self.scope.app.active.PROPS.CONFIG.BASKET[name].length > 0) {
                                isFill = true;
                            }
                        }
                    }
                    if (self.scope.app.active.PROPS.CONFIG.SECTIONS[i]) {
                        if (self.scope.app.active.PROPS.CONFIG.SECTIONS[i].SHELFCOUNT > 0) {
                            isFill = true;
                        }
                    }
                }
            }
        }

        if (isFill) {
            self.alert("Для изменения компановки удалите содержимое секций", "error");
        } else {
            if (news) {
                self.scope.app.active.PROPS.CONFIG.BASKET["FILLING"] = news;
                self.calcSectionsWidth(self.scope.app.active);
                self.updateElement(self.scope.app.active);
                self.hideOptionsTab();
            }
        }
    };

    this.changeHandlePosition = function (element, key, number, _segment, isDoubleHandle = false, _doorKey = false) {
        const group = element || self.scope.app.active
        self.scope.app.active_fasade = number;

        let segment = _segment !== undefined ? `${_segment}` : false

        let doorKey = _doorKey || self.scope.app.active_fasade_door

        if (!group.PROPS.HANDLES_POSITION)
            group.PROPS.HANDLES_POSITION = {}

        if (group.PROPS.PRODUCT.moduleType?.CODE === "wardrobe" && !group.PROPS.CONFIG.HANDLES_SIZE) {
            group.PROPS.CONFIG.HANDLES_SIZE = {}
        }

        if (doorKey && !self.scope.app.active_fasade_door) {
            self.scope.app.active_fasade_door = `${doorKey}`
        }

        const fasadeSegments = doorKey ? element.PROPS.CONFIG.BASKET.DOORS?.[self.scope.app.active_fasade]?.[doorKey] : group.PROPS.CONFIG.BASKET.DOORS?.[self.scope.app.active_fasade] || group.PROPS.CONFIG.BASKET['FASADE' + self.scope.app.active_fasade]
        const box = self.checkBoxIsFasade(element, number, segment, doorKey)
        if (box) {
            if (!box.FASADE.FASADE_INFO)
                box.FASADE.FASADE_INFO = {}

            box.FASADE.FASADE_INFO.HANDLE_POSITION = key;

            return self.changeElementFasade(
                element.id,
                box.FASADE.FASADE_INFO.COLOR,
                self.scope.app.active_fasade,
                segment || "0",
                doorKey
            );
        } else if (segment) {
            if (!group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade])
                group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade] = {}

            if (doorKey && !group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade][doorKey])
                group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade][doorKey] = {}

            if (doorKey)
                group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade][doorKey][segment] = key;
            else
                group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade][segment] = key;
        } else
            group.PROPS.HANDLES_POSITION[self.scope.app.active_fasade] = key;


        if (isDoubleHandle) {
            if (!group.PROPS.CONFIG.DOUBLE_HANDLES)
                group.PROPS.CONFIG.DOUBLE_HANDLES = {}

            if (!group.PROPS.CONFIG.DOUBLE_HANDLES[number])
                group.PROPS.CONFIG.DOUBLE_HANDLES[number] = {}

            group.PROPS.CONFIG.DOUBLE_HANDLES[number][segment] = true
        }

        self.scope.app.active_fasade_segment = segment || "0"

        self.changeFasade(group,
            fasadeSegments[self.scope.app.active_fasade_segment]
        );
    };

    this.canResize = function () {
        var isResize = false;

        angular.forEach(["WIDTH", "HEIGHT", "DEPTH"], function (v) {
            if (
                self.scope.app.active.PROPS.PRODUCT["SIZE_EDIT_" + v][0] ||
                (!self.scope.app.active.PROPS.PRODUCT["SIZE_EDIT_" + v][0] &&
                    self.scope.app.active.PROPS.PRODUCT["SIZE_EDIT_STEP_" + v] != null)
            )
                isResize = true;
        });
        return isResize;
    };

    // проверка активного фасада 25.09.23  Муртазин Э.
    this.checkSizeFasade = function (basket, fasadeList, size, productID) {
        self.scope.app.block_cart = true
        self.scope.$applyAsync();
        $.ajax({
            url: '/api/constructor/checkfasadesize/check/',
            method: 'post',
            dataType: 'json',
            contentType: "application/json",
            data: JSON.stringify({
                id: productID,
                basket: basket,
                width: size.width,
                height: size.height,
                fasadePosition: fasadeList,
            }),
            success: function (data) {
                const noFasad = self.scope.app.constants.noFasad;
                let result = data.DATA;

                function getFirstColor(colors) {
                    for (let fasade in colors) {
                        if (colors[fasade].SUCCESS) return fasade
                    }
                }

                //const newColor = self.scope.app.active.PROPS.PRODUCT.FACADE.includes(noFasad) ? noFasad : getFirstColor(self.scope.app.sizeMinMaxFasade)
                var product = self.getProductInfo(productID);
                let newColor = product.FACADE.includes(noFasad) ? noFasad : self.scope.fasadeErrorColor //getFirstColor(self.scope.app.sizeMinMaxFasade)
                if (result.data && Object.keys(result.data).length > 0) {
                    const group = self.scope.app.active ? self.scope.app.active : self.scope.app.oldActive

                    for (let i in result.data) {

                        let item = result.data[i]

                        if (result.data[i]['segment'] === undefined) {

                            if (newColor == noFasad) {
                                newColor = self.scope.fasadeErrorColor
                                self.alert("Фасад у товара был удалён. Размер не соответствует.", "error");
                            } else {
                                self.alert("Цвет у фасада товара был изменен. Размер не соответствует.", "error");
                            }

                            self.changeElementFasade(group.id, +newColor, i);
                        } else {
                            let segmentMap = {}
                            let segmentList = group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[i] ? Object.values(group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[i])
                                .filter(item => item.basket_key || item.basket_key === 0)
                                .map(item => segmentMap[item.basket_key] = item) : []

                            for (let indSegment of result.data[i]['segment']) {

                                if (!segmentMap[indSegment] || segmentMap[indSegment].external_box)
                                    continue;

                                if (newColor == noFasad) {
                                    newColor = self.scope.fasadeErrorColor
                                    self.alert("Фасад у товара был удалён. Размер не соответствует.", "error");
                                } else {
                                    self.alert("Цвет у фасада товара был изменен. Размер не соответствует.", "error");
                                }

                                self.changeElementFasade(group.id, +newColor, i, indSegment);
                            }
                        }

                    }
                }

                self.scope.app.block_cart = false
                self.scope.$applyAsync();
            }
        });
    };
    // проверка активного фасада 25.09.23  Муртазин Э.

    this.changeSize = function (newValues, oldValues, e) {
        if (self.scope.app.active) {
            var needUpdate = false;
            var group = self.scope.app.active;

            if (!group)
                return

            var types = Object.keys(group.PROPS.CONFIG.SIZE);

            if (typeof newValues == "object") newValues = Object.values(newValues);

            angular.forEach(types, function (type, k) {
                var new_size = self.controlElementSize(group, newValues[k], type);

                if (new_size != group.PROPS.CONFIG.SIZE[type])
                    needUpdate = true;

                self.scope.app.new_size[type] = group.PROPS.CONFIG.SIZE[type] = new_size;
            });

            if (Object.keys(group.PROPS.CONFIG.FASADELIST).length) {
                if (group.PROPS.CONFIG.BASKET.DOORS && group.PROPS.PRODUCT.moduleType?.CODE === 'universal') {
                    angular.forEach(group.PROPS.CONFIG.BASKET.DOORS, function (section, sectkey) {
                        angular.forEach(section, function (door, doorKey) {
                            self.controlFasadeCount(group, sectkey, doorKey)
                        })
                    })
                } else
                    angular.forEach(group.PROPS.CONFIG.SECTIONS, function (section, sectkey) {
                        self.controlFasadeCount(group, sectkey)
                    })
            }

            if (needUpdate) {
                self.updateExtra(group)
                self.updateElement(group);
            }

            var newInterval = setInterval(function () {
                if (self.scope.app.sizeMinMaxFasade) {
                    self.checkSizeFasade(
                        group.PROPS.CONFIG.BASKET,
                        group.PROPS.CONFIG.FASADELIST,
                        self.scope.app.new_size,
                        group.PROPS.CONFIG.ID
                    )
                    clearInterval(newInterval);
                }
            }, 100);

            self.searchSizeFasade(
                self.scope.app.active.PROPS.PRODUCT.ID,
                "elementFasade",
                self.scope.app.active_fasade,
                self.scope.app.active_fasade_segment,
                self.scope.app.active_fasade_door
            );
        }

        if (group.PROPS.PRODUCT.moduleType?.CODE && group.PROPS.CONFIG.CUSTOMFILLING) {
            self.setSectionsSize(group, false, group.PROPS.CONFIG.CUSTOMFILLING.VSECTION)
        }
        //self.updateElement(group)
        self.controlResizeForm();
        self.scope.$applyAsync();
        self.getBasketPrice();
    };

    this.controlFilling = function (group) {
        var filling_list = self.$filter("filterFilling")(self.scope.app.FILLING, {
            PR: group.PROPS.CONFIG,
            ID: group.PROPS.PRODUCT.FILLING,
        });

        if (
            filling_list.length &&
            !filling_list.find(function (fill) {
                return fill.ID == group.PROPS.CONFIG.BASKET.FILLING;
            })
        ) {
            group.PROPS.CONFIG.BASKET.FILLING = filling_list[0].ID;

            var size = self.controlFillingSize(group);
            self.setSectionsSize(group, size);
        }
    };

    this.controlModel = function (group) {
        var CONFIG = group.PROPS.CONFIG;
        if (CONFIG.models[0]) {
            if (!CONFIG.MODEL) CONFIG.MODEL = CONFIG.models[0];

            if (CONFIG.models.indexOf(CONFIG.MODEL) == -1)
                CONFIG.models.filter(function (i) {
                    if (
                        self.scope.app.MODELS[i].type == self.scope.app.MODELS[CONFIG.MODEL].type ||
                        (self.scope.app.MODELS[CONFIG.MODEL].type == null &&
                            self.scope.app.MODELS[i].type != null) ||
                        (self.scope.app.MODELS[CONFIG.MODEL].type != null &&
                            self.scope.app.MODELS[i].type == null)
                    ) {
                        CONFIG.MODEL = i;
                    }
                });

            let elementAlign = false;
            if ((elementAlign = self.doElementlign(group))) {
                CONFIG.BASKET[elementAlign] = self.scope.app.MODELS[CONFIG.MODEL].type;
                CONFIG.ALIGN = elementAlign;
            } else {
                if (CONFIG.ALIGN) {
                    delete CONFIG.BASKET[CONFIG.ALIGN];
                    CONFIG.ALIGN = false;
                }
            }
        }
    };

    /**
     *    Контроль добавления фасадов
     *  group: object
     */
    this.controlFasade = function (group, segmentKey, doorId) {
        var PROPS = group.PROPS;
        var CONFIG = group.PROPS.CONFIG;
        var PRODUCT = group.PROPS.PRODUCT;
        var FASADELIST = self.$filter("filterFasadePosition")(
            PRODUCT.FASADE_POSITION,
            CONFIG, group.PROPS.PRODUCT.moduleType?.CODE !== 'wardrobe' && !CONFIG.BASKET.DOORS
        );

        CONFIG.FASADELIST = {};

        if (FASADELIST.length) {
            /*Параметры по умолчанию*/
            if (PRODUCT.element_type == "element_up") {
                var default_prop = {
                    fasade: self.scope.project.default_fasade_up,
                    milling: self.scope.project.default_fasade_milling_up,
                    patina: self.scope.project.default_fasade_patina_up,
                    palette: self.scope.project.default_fasade_palette_up,
                };
            } else {
                var default_prop = {
                    fasade: self.scope.project.default_fasade_down,
                    milling: self.scope.project.default_fasade_milling_down,
                    patina: self.scope.project.default_fasade_patina_down,
                    palette: self.scope.project.default_fasade_palette_down,
                };
            }
            /*Параметры по умолчанию*/

            /*Если есть фасады*/
            angular.forEach(FASADELIST, function (fasadePositionId, key) {

                if (group.PROPS.PRODUCT.moduleType?.CODE === "wardrobe") {
                    self.controlSlideDoors(group, default_prop, fasadePositionId, key + 1);
                } else if (Array.isArray(fasadePositionId)) {

                    if (!fasadePositionId.length)
                        return

                    angular.forEach(fasadePositionId, function (door, doorKey) {
                        self.controlMultiDoors(group, default_prop, door, key + 1, doorKey + 1);
                    })
                } else {
                    var fasadePosition = self.scope.app.FASADE_POSITION[fasadePositionId] ? Object.assign({}, self.scope.app.FASADE_POSITION[fasadePositionId]) : false;

                    let allFasades = false
                    if (!CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER] || !Object.entries(CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER]).length) {
                        if (CONFIG.BASKET['FASADESIZES' + fasadePosition.FASADE_NUMBER] && Object.values(CONFIG.BASKET['FASADESIZES' + fasadePosition.FASADE_NUMBER]).length)
                            allFasades = {0: default_prop.fasade};
                        else {
                            allFasades = {0: self.scope.app.constants.noFasad};
                        }
                    } else {
                        allFasades = CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER]
                    }

                    angular.forEach(allFasades, function (fasade, segment_key) {
                        var newFasade = false;
                        var fasadeID = CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER]?.[segment_key] || fasade

                        /*Выбор цвета фасада*/
                        if (fasadeID === undefined || self.scope.issetDefaultFasade)
                            newFasade = default_prop.fasade;
                        else newFasade = fasadeID;

                        fasadeID = self.canBeSetFasade(
                            PRODUCT.ID,
                            newFasade,
                            fasadePosition.FASADE_NUMBER
                        )
                            ? newFasade
                            : self.controlFasadeSiblings(
                                PRODUCT.ID,
                                newFasade,
                                fasadePosition.FASADE_NUMBER
                            );

                        if (newFasade != fasadeID) {
                            self.scope.alerts[fasadeID] = "Цвет фасада изменен.";
                        }

                        if (!CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER] !== 'object') {
                            CONFIG.BASKET["FASADE" + fasadePosition.FASADE_NUMBER] = {}
                        }
                        CONFIG.BASKET['FASADE' + fasadePosition.FASADE_NUMBER][segment_key] = fasadeID;
                        CONFIG.FASADELIST[fasadePosition.FASADE_NUMBER] = fasadePositionId;
                        /*Выбор цвета фасада*/

                        var fasadeColor = self.scope.app.FASADE[fasadeID];

                        /*Назначение модели*/
                        if (fasadePosition.models[0]) CONFIG.models = fasadePosition.models;
                        /*Назначение модели*/

                        /*Контроль фрезировки*/
                        if (PRODUCT.MILLING.length && PRODUCT.MILLING[0]) {
                            var millingList = self.GetMillingList(fasadeID, PRODUCT.ID)
                            var millingItem = false

                            const oldMillingBasket = CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]?.[segment_key]

                            //Проверка на удаленные фрезеровки

                            /* !!!Проверить позже */
                            if (millingList.indexOf(oldMillingBasket) == -1) {
                                self.checkMillingBasket(group, segment_key)
                            }

                            let millingBasket = CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]?.[segment_key]

                            if (millingList.length) {
                                if (
                                    millingBasket == undefined ||
                                    self.scope.issetDefaultFasade ||
                                    millingList.indexOf(millingBasket) == -1
                                )
                                    if (
                                        default_prop &&
                                        default_prop.milling &&
                                        millingList.indexOf(default_prop.milling) != -1
                                    ) {
                                        millingBasket = default_prop.milling;

                                    } else {
                                        millingBasket = millingList[0];
                                    }

                                if (!CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] !== 'object')
                                    CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] = {}
                                CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER][segment_key] = millingBasket;

                                millingItem = self.scope.app.MILLING[millingBasket];
                            } else {
                                if (typeof CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                    delete CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]
                                } else if (CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]) {
                                    delete CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER][segment_key];
                                }

                                if (typeof CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                    delete CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]
                                }
                            }
                        }
                        /*Контроль фрезировки*/

                        /*Контроль типа фасада*/
                        if (
                            millingItem != undefined &&
                            millingItem != false &&
                            millingItem.fasade_type[0] &&
                            fasadePosition.fasade_type[0]
                        ) {

                            var fasadeTypeBasket = CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]?.[segment_key]

                            var fasadeTypeList = self.$filter("filterFasadeType")(
                                fasadePosition.fasade_type,
                                {milling: millingItem.ID}
                            );
                            var FasadeTypeKeys = Object.keys(fasadeTypeList);

                            if (FasadeTypeKeys.length > 0) {
                                if (!fasadeTypeBasket || (fasadeTypeBasket && !FasadeTypeKeys.find(item => item == fasadeTypeBasket))) {
                                    var fasadeTypeDefault = FasadeTypeKeys[0];

                                    if (!CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] !== 'object')
                                        CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] = {}

                                    CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key] = fasadeTypeDefault;
                                }
                            } else {

                                if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                                } else if (CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]) {
                                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key]
                                }

                                if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                                }
                            }
                        } else if (
                            self.scope.app.FASADE[fasadeID] != undefined &&
                            fasadePosition.fasade_type[0] &&
                            self.scope.app.FASADE[fasadeID].fasade_type[0]
                        ) {
                            var fasadeTypeBasket = CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                            var fasadeTypeList = self.$filter("filterFasadeType")(
                                fasadePosition.fasade_type,
                                {fasade: fasadeID}
                            );
                            var FasadeTypeKeys = Object.keys(fasadeTypeList);

                            if (FasadeTypeKeys.length > 0) {
                                if (!fasadeTypeBasket || (fasadeTypeBasket && !FasadeTypeKeys.find(item => item == fasadeTypeBasket))) {
                                    var fasadeTypeDefault = FasadeTypeKeys[0]

                                    if (!CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] !== 'object')
                                        CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] = {}

                                    CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key] = fasadeTypeDefault;
                                }
                            } else {
                                if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                                } else if (CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]) {
                                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key]
                                }

                                if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                                }
                            }

                        } else {

                            if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                            } else if (CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]) {
                                delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key]
                            }

                            if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                            }
                        }

                        /*Контроль типа фасада*/

                        /*Контроль Патины*/
                        if (
                            fasadeColor.PATINA[0] &&
                            (!millingItem || (millingItem && !millingItem.PATINAOFF))
                        ) {
                            var patinaList = (CONFIG.PATINALIST[fasadePosition.FASADE_NUMBER] = fasadeColor.PATINA)
                            var patinaBasket = CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                            if (
                                patinaBasket == undefined ||
                                self.scope.issetDefaultFasade ||
                                patinaList.indexOf(patinaBasket) == -1
                            )
                                if (
                                    default_prop &&
                                    default_prop.patina &&
                                    patinaList.indexOf(default_prop.patina) != -1
                                )
                                    patinaBasket = default_prop.patina;
                                else patinaBasket = fasadeColor.PATINA[0];

                            if (!CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER])
                                CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] = {}

                            if (typeof CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] !== "object")
                                CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] = {0: CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]}

                            CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER][segment_key] = patinaBasket;


                        } else {
                            CONFIG.PATINALIST[fasadePosition.FASADE_NUMBER] = [];

                            if (typeof CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                delete CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]
                            } else if (CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]) {
                                delete CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER][segment_key];
                            }

                            if (typeof CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                delete CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]
                            }

                        }
                        /*Контроль Патины*/

                        /*Контроль Палитры*/
                        if (fasadeColor.PALETTE[0]) {
                            var palettelist = self.$filter("filterPalette")(self.scope.app.PALETTE, {
                                element: fasadeID,
                            })
                            var paletteBasket = CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                            if (
                                paletteBasket == undefined ||
                                self.scope.issetDefaultFasade ||
                                palettelist[paletteBasket] == undefined
                            )
                                if (
                                    default_prop &&
                                    default_prop.palette &&
                                    palettelist[default_prop.palette] != undefined
                                )
                                    paletteBasket = default_prop.palette;
                                else paletteBasket = Object.keys(palettelist)[0];

                            if (!CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] !== 'object')
                                CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] = {}

                            CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER][segment_key] = paletteBasket;

                        } else {

                            if (typeof CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                delete CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]
                            } else if (CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]) {
                                delete CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER][segment_key];
                            }

                            if (typeof CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                delete CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]
                            }
                        }
                        /*Контроль Палитры*/

                        /*Контроль стекла*/
                        if (
                            fasadeColor.no_fasade == "N" &&
                            PRODUCT.GLASS.length &&
                            PRODUCT.GLASS[0] &&
                            self.scope.app.FASADE_POSITION[fasadePosition.ID].glass
                        ) {
                            var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                                    IDS: group.PROPS.PRODUCT.GLASS,
                                    FASADE: fasadeID,
                                }),
                                glassBasket = CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                            if (glassBasket == undefined || glasslist[glassBasket] == undefined)
                                glassBasket = Object.keys(glasslist)[0];

                            if (!CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] !== 'object')
                                CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] = {}

                            CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER][segment_key] = glassBasket;
                        } else if (
                            fasadeColor.no_fasade == "N" &&
                            PRODUCT.GLASS.length &&
                            PRODUCT.GLASS[0] &&
                            self.scope.app.FASADE_POSITION[fasadePosition.ID].is_glass_fasade &&
                            self.scope.app.FASADE[fasadeID].GLASS_ONLY
                        ) {
                            var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                                    IDS: group.PROPS.PRODUCT.GLASS,
                                    FASADE: fasadeID,
                                }),
                                glassBasket = CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                            if (glassBasket == undefined || glasslist[glassBasket] == undefined) {
                                glassBasket = Object.keys(glasslist)[0];
                            }

                            if (!CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] !== 'object')
                                CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] = {}

                            CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER][segment_key] = glassBasket;
                        } else {
                            if (typeof CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] !== 'object') {
                                delete CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]
                            } else if (CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]) {
                                delete CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER][segment_key];
                            }

                            if (typeof CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]).length === 0) {
                                delete CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]
                            }
                        }
                        /*Контроль стекла*/

                        /*Контроль типа витрины*/
                        if (fasadeColor.no_fasade == "N" && PRODUCT.type_showcase[0]) {
                            var SHOWCASE_LIST = self.$filter("filterShowcase")(self.scope.app.SHOWCASE, {
                                    group: group,
                                    FASADE_NUMBER: fasadePosition.FASADE_NUMBER,
                                }),
                                SHOWCASE_ITEM = CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                            if (SHOWCASE_LIST.length) {
                                if (SHOWCASE_ITEM == undefined) {
                                    SHOWCASE_ITEM = SHOWCASE_LIST[0].ID;
                                }

                                if (!CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER] || typeof CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER] !== 'object')
                                    CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER] = {};

                                CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER][segment_key] = SHOWCASE_ITEM;
                            } else {
                                delete CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]?.[segment_key];
                            }
                        } else {
                            delete CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]?.[segment_key];
                        }
                        /*Констроль типа витрины*/

                        const no_fasade = self.scope.app.constants.noFasad
                        // проверка компановки "0" Без фасада
                        if (CONFIG.BASKET.FILLING) {
                            if (CONFIG.BASKET.FILLING === 1008541) {
                                for (let ind = 0; ind <= 10; ind++) {
                                    if (CONFIG.BASKET['FASADE' + ind][segment_key] !== undefined) {
                                        CONFIG.BASKET['FASADE' + ind][segment_key] = no_fasade;
                                    }
                                }
                            }
                        }
                        // проверка компановки "0" Без фасада

                    })
                }
            });
            /*Если есть фасады*/


            //Проверка фасадов ящиков
            if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE && Object.keys(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE).length) {
                angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE, function (section, sectionKey) {
                    const fasadePosition = self.getFasadePosition(group, sectionKey);
                    angular.forEach(section, function (box, boxKey) {
                        let newFasade = false;
                        let fasade = Object.assign({}, box.FASADE.FASADE_INFO)
                        let fasadeID = fasade.COLOR

                        let basketBox = group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${sectionKey}`]?.find(item => item.PATH === box.PATH)
                        if (basketBox?.FASADE?.fasade) {
                            fasade = Object.assign(fasade, basketBox.FASADE.fasade)
                        }

                        /*Выбор цвета фасада*/
                        if (fasadeID === undefined || self.scope.issetDefaultFasade)
                            newFasade = default_prop.fasade;
                        else
                            newFasade = fasadeID;

                        fasadeID = self.canBeSetFasade(
                            PRODUCT.ID,
                            newFasade,
                            fasadePosition.FASADE_NUMBER
                        )
                            ? newFasade
                            : self.controlFasadeSiblings(
                                PRODUCT.ID,
                                newFasade,
                                fasadePosition.FASADE_NUMBER
                            );

                        if (newFasade != fasadeID) {
                            self.scope.alerts[fasadeID] = "Цвет фасада изменен.";
                        }

                        fasade.COLOR = fasadeID;
                        /*Выбор цвета фасада*/

                        var fasadeColor = self.scope.app.FASADE[fasadeID];

                        /*Назначение модели*/
                        if (fasadePosition.models?.[0])
                            CONFIG.models = fasadePosition.models;
                        /*Назначение модели*/

                        /*Контроль фрезировки*/
                        if (PRODUCT.MILLING.length && PRODUCT.MILLING[0]) {
                            var millingList = self.GetMillingList(fasadeID, PRODUCT.ID)
                            var millingItem = false

                            const oldMillingBasket = fasade["MILLING"]

                            //Проверка на удаленные фрезеровки

                            /* !!!Проверить позже */
                            if (millingList.indexOf(oldMillingBasket) == -1) {
                                self.checkMillingBasket(group, false, fasade["MILLING"])
                            }

                            let millingBasket = fasade["MILLING"]

                            if (millingList.length) {
                                if (
                                    millingBasket == undefined ||
                                    self.scope.issetDefaultFasade ||
                                    millingList.indexOf(millingBasket) == -1
                                )
                                    if (
                                        default_prop &&
                                        default_prop.milling &&
                                        millingList.indexOf(default_prop.milling) != -1
                                    ) {
                                        millingBasket = default_prop.milling;

                                    } else {
                                        millingBasket = millingList[0];
                                    }

                                fasade["MILLING"] = millingBasket;

                                millingItem = self.scope.app.MILLING[millingBasket];
                            } else if (fasade["MILLING"]) {
                                delete fasade["MILLING"];
                            }
                        }
                        /*Контроль фрезировки*/

                        /*Контроль типа фасада*/
                        if (
                            millingItem != undefined &&
                            millingItem != false &&
                            millingItem.fasade_type[0] &&
                            fasadePosition.fasade_type?.[0]
                        ) {

                            var fasadeTypeBasket = fasade["FASADETYPE"]

                            if (fasadeTypeBasket == undefined) {
                                var fasadeTypeList = self.$filter("filterFasadeType")(
                                    fasadePosition.fasade_type,
                                    {milling: millingItem.ID}
                                );
                                var FasadeTypeKeys = Object.keys(fasadeTypeList);
                                if (FasadeTypeKeys.length > 0) {
                                    var fasadeTypeDefault = FasadeTypeKeys[0];

                                    fasade["FASADETYPE"] = fasadeTypeDefault;
                                } else if (fasade["FASADETYPE"]) {
                                    delete fasade["FASADETYPE"]
                                }
                            }
                        } else if (
                            self.scope.app.FASADE[fasadeID] != undefined &&
                            fasadePosition.fasade_type?.[0] &&
                            self.scope.app.FASADE[fasadeID].fasade_type[0]
                        ) {
                            var fasadeTypeBasket = fasade["FASADETYPE"]

                            if (fasadeTypeBasket == undefined) {
                                var fasadeTypeList = self.$filter("filterFasadeType")(
                                    fasadePosition.fasade_type,
                                    {fasade: fasadeID}
                                );
                                var FasadeTypeKeys = Object.keys(fasadeTypeList);
                                if (FasadeTypeKeys.length > 0) {
                                    var fasadeTypeDefault = FasadeTypeKeys[0];
                                    fasade["FASADETYPE"] = fasadeTypeDefault;
                                } else if (fasade["FASADETYPE"]) {
                                    delete fasade["FASADETYPE"]
                                }
                            }
                        } else if (fasade["FASADETYPE"]) {
                            delete fasade["FASADETYPE"]
                        }

                        /*Контроль типа фасада*/

                        /*Контроль Патины*/
                        if (
                            fasadeColor.PATINA[0] &&
                            (!millingItem || (millingItem && !millingItem.PATINAOFF))
                        ) {
                            var patinaList = fasadeColor.PATINA
                            var patinaBasket = fasade["PATINA"];

                            if (
                                patinaBasket == undefined ||
                                self.scope.issetDefaultFasade ||
                                patinaList.indexOf(patinaBasket) == -1
                            )
                                if (
                                    default_prop &&
                                    default_prop.patina &&
                                    patinaList.indexOf(default_prop.patina) != -1
                                )
                                    patinaBasket = default_prop.patina;
                                else
                                    patinaBasket = fasadeColor.PATINA[0];

                            fasade["PATINA"] = patinaBasket;
                        } else {
                            //CONFIG.PATINALIST[fasadePosition.FASADE_NUMBER] = [];

                            if (fasade["PATINA"]) {
                                fasade["PATINA"];
                            }
                        }
                        /*Контроль Патины*/

                        /*Контроль Палитры*/
                        if (fasadeColor.PALETTE[0]) {
                            var palettelist = self.$filter("filterPalette")(self.scope.app.PALETTE, {
                                element: fasadeID,
                            })
                            var paletteBasket = fasade["PALETTE"];

                            if (
                                paletteBasket == undefined ||
                                self.scope.issetDefaultFasade ||
                                palettelist[paletteBasket] == undefined
                            )
                                if (
                                    default_prop &&
                                    default_prop.palette &&
                                    palettelist[default_prop.palette] != undefined
                                )
                                    paletteBasket = default_prop.palette;
                                else
                                    paletteBasket = Object.keys(palettelist)[0];

                            fasade["PALETTE"] = paletteBasket;

                        } else if (fasade["PALETTE"]) {
                            delete fasade["PALETTE"]
                        }
                        /*Контроль Палитры*/

                        /*Контроль стекла*/
                        if (
                            fasadeColor.no_fasade == "N" &&
                            PRODUCT.GLASS.length &&
                            PRODUCT.GLASS[0] &&
                            self.scope.app.FASADE_POSITION[fasadePosition.ID]?.glass
                        ) {
                            var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                                    IDS: group.PROPS.PRODUCT.GLASS,
                                    FASADE: fasadeID,
                                }),
                                glassBasket = fasade["GLASS"];

                            if (glassBasket == undefined || glasslist[glassBasket] == undefined)
                                glassBasket = Object.keys(glasslist)[0];

                            fasade["GLASS"] = glassBasket;
                        } else if (
                            fasadeColor.no_fasade == "N" &&
                            PRODUCT.GLASS.length &&
                            PRODUCT.GLASS[0] &&
                            self.scope.app.FASADE_POSITION[fasadePosition.ID]?.is_glass_fasade &&
                            self.scope.app.FASADE[fasadeID].GLASS_ONLY
                        ) {
                            var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                                    IDS: group.PROPS.PRODUCT.GLASS,
                                    FASADE: fasadeID,
                                }),
                                glassBasket = fasade["GLASS"];

                            if (glassBasket == undefined || glasslist[glassBasket] == undefined) {
                                glassBasket = Object.keys(glasslist)[0];
                            }

                            fasade["GLASS"] = glassBasket;
                        } else {
                            if (fasade["GLASS"]) {
                                delete fasade["GLASS"];
                            }
                        }
                        /*Контроль стекла*/

                        /*Контроль типа витрины*/
                        if (fasadeColor.no_fasade == "N" && PRODUCT.type_showcase[0]) {
                            var SHOWCASE_LIST = self.$filter("filterShowcase")(self.scope.app.SHOWCASE, {
                                    group: group,
                                    FASADE_NUMBER: fasadePosition.FASADE_NUMBER,
                                }),
                                SHOWCASE_ITEM = fasade["SHOWCASE"];

                            if (SHOWCASE_LIST.length) {

                                if (SHOWCASE_ITEM == undefined) {
                                    SHOWCASE_ITEM = SHOWCASE_LIST[0].ID;
                                }

                                fasade["SHOWCASE"] = SHOWCASE_ITEM;
                            } else {
                                delete fasade["SHOWCASE"];
                            }
                        } else {
                            delete fasade["SHOWCASE"];
                        }
                        /*Констроль типа витрины*/

                        box.FASADE.FASADE_INFO = fasade

                        if (basketBox) {
                            if (!basketBox.FASADE)
                                basketBox.FASADE = {}

                            basketBox.FASADE.fasade = Object.assign({}, fasade)
                            delete basketBox.FASADE.fasade.HANDLE_OBJECT
                        }
                    })
                });
            }

        }

        /*чистка*/
        angular.forEach(PROPS.FASADE, function (i, k) {
            if (CONFIG.FASADELIST[k] == undefined) {
                group.remove(PROPS.FASADE[k]);
                delete PROPS.FASADE[k];
                delete CONFIG.BASKET["FASADE" + k];
                delete CONFIG.BASKET.DOORS?.[k];
                delete CONFIG.BASKET["PALETTE" + k];
                delete CONFIG.BASKET["MILLING" + k];
                delete CONFIG.BASKET["PATINA" + k];
                delete CONFIG.BASKET["GLASS" + k];
                delete CONFIG.BASKET["FASADESIZE" + k];
            }
        });
        /*чистка*/

    };

    this.controlMultiDoors = function (group, default_prop, fasadePositionId, section_id, door_id) {
        const PROPS = group.PROPS;
        const CONFIG = group.PROPS.CONFIG;
        const PRODUCT = group.PROPS.PRODUCT;

        let fasadePosition = self.scope.app.FASADE_POSITION[fasadePositionId] ? Object.assign({}, self.scope.app.FASADE_POSITION[fasadePositionId]) : false;
        fasadePosition.FASADE_NUMBER = door_id

        if (!CONFIG.BASKET["DOORS"])
            CONFIG.BASKET["DOORS"] = {}

        let allFasades = false
        if (!CONFIG.BASKET["DOORS"][section_id]?.[door_id]) {
            return;
        } else {
            allFasades = CONFIG.BASKET["DOORS"][section_id][door_id]
        }

        if (Object.values(allFasades).length) {
            angular.forEach(allFasades, function (fasade, segment_key) {
                var newFasade = false;
                var fasadeID = CONFIG.BASKET["DOORS"][section_id][fasadePosition.FASADE_NUMBER]?.[segment_key]

                /*Выбор цвета фасада*/
                if (fasadeID === undefined || self.scope.issetDefaultFasade)
                    newFasade = default_prop.fasade;
                else newFasade = fasadeID;

                fasadeID = self.canBeSetFasade(
                    PRODUCT.ID,
                    newFasade,
                    fasadePosition.FASADE_NUMBER,
                    door_id
                )
                    ? newFasade
                    : self.controlFasadeSiblings(
                        PRODUCT.ID,
                        newFasade,
                        fasadePosition.FASADE_NUMBER,
                        door_id
                    );

                /*if (CONFIG.BASKET["FASADEWIDTH" + section_id][fasadePosition.FASADE_NUMBER] < 600) {
                  fasadeID = self.scope.fasadeErrorColor  //фасад не доступен
                  self.alert('Минимальная ширина двери 600 мм.', "error")
              } else if (CONFIG.BASKET["FASADEWIDTH" + section_id][fasadePosition.FASADE_NUMBER] > 1300) {
                  fasadeID = self.scope.fasadeErrorColor  //фасад не доступен
                  self.alert('Максимальная ширина двери 1300 мм.', "error")
              } else if ((CONFIG.BASKET["FASADEWIDTH" + section_id][fasadePosition.FASADE_NUMBER] >= 600 &&
                  CONFIG.BASKET["FASADEWIDTH" + section_id][fasadePosition.FASADE_NUMBER] <= 1300) && fasadeID === self.scope.fasadeErrorColor) {
                  fasadeID = default_prop.fasade
              } else*/
                if (newFasade != fasadeID) {
                    self.scope.alerts[fasadeID] = "Цвет фасада изменен.";
                }

                if (!CONFIG.BASKET["DOORS"][section_id][fasadePosition.FASADE_NUMBER] ||
                    typeof CONFIG.BASKET["DOORS"][section_id][fasadePosition.FASADE_NUMBER] === 'number')
                    CONFIG.BASKET["DOORS"][section_id][fasadePosition.FASADE_NUMBER] = {}

                CONFIG.BASKET["DOORS"][section_id][fasadePosition.FASADE_NUMBER][segment_key] = fasadeID;

                if (!CONFIG.FASADELIST[section_id])
                    CONFIG.FASADELIST[section_id] = {}

                CONFIG.FASADELIST[section_id][fasadePosition.FASADE_NUMBER] = fasadePositionId;
                /*Выбор цвета фасада*/

                var fasadeColor = self.scope.app.FASADE[fasadeID];

                /*Назначение модели*/
                if (fasadePosition.models[0])
                    CONFIG.models = fasadePosition.models;
                /*Назначение модели*/

                /*Контроль фрезировки*/
                if (PRODUCT.MILLING.length && PRODUCT.MILLING[0]) {
                    var millingList = self.GetMillingList(fasadeID, PRODUCT.ID)
                    var millingItem = false

                    const oldMillingBasket = CONFIG.BASKET["MILLING" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["MILLING" + section_id]?.[segment_key]
                    let millingBasket = oldMillingBasket

                    //Проверка на удаленные фрезеровки

                    /* !!!Проверить позже */
                    if (millingList.indexOf(oldMillingBasket) == -1) {
                        self.checkMillingBasket(group, segment_key)
                    }

                    if (millingList.length) {
                        if (
                            millingBasket == undefined ||
                            self.scope.issetDefaultFasade ||
                            millingList.indexOf(millingBasket) == -1
                        )
                            if (
                                default_prop &&
                                default_prop.milling &&
                                millingList.indexOf(default_prop.milling) != -1
                            ) {
                                millingBasket = default_prop.milling;

                            } else {
                                millingBasket = millingList[0];
                            }

                        if (!CONFIG.BASKET["MILLING" + section_id])
                            CONFIG.BASKET["MILLING" + section_id] = {}
                        if (!CONFIG.BASKET["MILLING" + section_id][door_id])
                            CONFIG.BASKET["MILLING" + section_id][door_id] = {}

                        CONFIG.BASKET["MILLING" + section_id][door_id][segment_key] = millingBasket;

                        millingItem = self.scope.app.MILLING[millingBasket];
                    } else {
                        if (CONFIG.BASKET["MILLING" + section_id]?.[door_id]) {
                            delete CONFIG.BASKET["MILLING" + section_id][door_id][segment_key];
                        }
                        if (typeof CONFIG.BASKET["MILLING" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["MILLING" + section_id]?.[door_id]).length === 0) {
                            delete CONFIG.BASKET["MILLING" + section_id]?.[door_id]
                        }
                        if (typeof CONFIG.BASKET["MILLING" + section_id] === 'object' && Object.keys(CONFIG.BASKET["MILLING" + section_id]).length === 0) {
                            delete CONFIG.BASKET["MILLING" + section_id]
                        }
                    }
                }
                /*Контроль фрезировки*/

                /*Контроль типа фасада*/
                if (
                    millingItem != undefined &&
                    millingItem != false &&
                    millingItem.fasade_type[0] &&
                    fasadePosition.fasade_type[0]
                ) {

                    var fasadeTypeBasket = CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["FASADETYPE" + section_id]?.[segment_key]

                    if (fasadeTypeBasket == undefined) {
                        var fasadeTypeList = self.$filter("filterFasadeType")(
                            fasadePosition.fasade_type,
                            {milling: millingItem.ID}
                        );
                        var FasadeTypeKeys = Object.keys(fasadeTypeList);
                        if (FasadeTypeKeys.length > 0) {
                            var fasadeTypeDefault = FasadeTypeKeys[0];

                            if (!CONFIG.BASKET["FASADETYPE" + section_id])
                                CONFIG.BASKET["FASADETYPE" + section_id] = {}
                            if (!CONFIG.BASKET["FASADETYPE" + section_id][door_id])
                                CONFIG.BASKET["FASADETYPE" + section_id][door_id] = {}

                            CONFIG.BASKET["FASADETYPE" + section_id][door_id][segment_key] = fasadeTypeDefault;
                        } else {

                            if (CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]) {
                                delete CONFIG.BASKET["FASADETYPE" + section_id][door_id][segment_key]
                            }
                            if (typeof CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]).length === 0) {
                                delete CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]
                            }
                            if (typeof CONFIG.BASKET["FASADETYPE" + section_id] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + section_id]).length === 0) {
                                delete CONFIG.BASKET["FASADETYPE" + section_id]
                            }
                        }
                    }
                } else if (
                    self.scope.app.FASADE[fasadeID] != undefined &&
                    fasadePosition.fasade_type[0] &&
                    self.scope.app.FASADE[fasadeID].fasade_type[0]
                ) {
                    var fasadeTypeBasket = CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["FASADETYPE" + section_id]?.[segment_key];

                    if (fasadeTypeBasket == undefined) {
                        var fasadeTypeList = self.$filter("filterFasadeType")(
                            fasadePosition.fasade_type,
                            {fasade: fasadeID}
                        );
                        var FasadeTypeKeys = Object.keys(fasadeTypeList);
                        if (FasadeTypeKeys.length > 0) {
                            var fasadeTypeDefault = FasadeTypeKeys[0];
                            if (!CONFIG.BASKET["FASADETYPE" + section_id])
                                CONFIG.BASKET["FASADETYPE" + section_id] = {}
                            if (!CONFIG.BASKET["FASADETYPE" + section_id][door_id])
                                CONFIG.BASKET["FASADETYPE" + section_id][door_id] = {}
                            CONFIG.BASKET["FASADETYPE" + section_id][door_id][segment_key] = fasadeTypeDefault;

                        } else {
                            if (CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]) {
                                delete CONFIG.BASKET["FASADETYPE" + section_id][door_id][segment_key]
                            }
                            if (typeof CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]).length === 0) {
                                delete CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]
                            }
                            if (typeof CONFIG.BASKET["FASADETYPE" + section_id] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + section_id]).length === 0) {
                                delete CONFIG.BASKET["FASADETYPE" + section_id]
                            }
                        }
                    }
                } else {

                    if (CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]) {
                        delete CONFIG.BASKET["FASADETYPE" + section_id][door_id][segment_key]
                    }
                    if (typeof CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]).length === 0) {
                        delete CONFIG.BASKET["FASADETYPE" + section_id]?.[door_id]
                    }
                    if (typeof CONFIG.BASKET["FASADETYPE" + section_id] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + section_id]).length === 0) {
                        delete CONFIG.BASKET["FASADETYPE" + section_id]
                    }
                }

                /*Контроль типа фасада*/

                /*Контроль Патины*/
                if (
                    fasadeColor.PATINA[0] &&
                    (!millingItem || (millingItem && !millingItem.PATINAOFF))
                ) {
                    var patinaList = (CONFIG.PATINALIST[section_id] = fasadeColor.PATINA)
                    var patinaBasket = CONFIG.BASKET["PATINA" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["PATINA" + section_id]?.[segment_key];

                    if (
                        patinaBasket == undefined ||
                        self.scope.issetDefaultFasade ||
                        patinaList.indexOf(patinaBasket) == -1
                    )
                        if (
                            default_prop &&
                            default_prop.patina &&
                            patinaList.indexOf(default_prop.patina) != -1
                        )
                            patinaBasket = default_prop.patina;
                        else patinaBasket = fasadeColor.PATINA[0];

                    if (!CONFIG.BASKET["PATINA" + section_id])
                        CONFIG.BASKET["PATINA" + section_id] = {}

                    if (!CONFIG.BASKET["PATINA" + section_id][door_id])
                        CONFIG.BASKET["PATINA" + section_id][door_id] = {}

                    if (typeof CONFIG.BASKET["PATINA" + section_id][door_id] !== "object")
                        CONFIG.BASKET["PATINA" + section_id][door_id] = {0: CONFIG.BASKET["PATINA" + section_id]}

                    CONFIG.BASKET["PATINA" + section_id][door_id][segment_key] = patinaBasket;


                } else {
                    CONFIG.PATINALIST[section_id] = [];

                    if (CONFIG.BASKET["PATINA" + section_id]?.[door_id]) {
                        delete CONFIG.BASKET["PATINA" + section_id][door_id][segment_key];
                    }
                    if (typeof CONFIG.BASKET["PATINA" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["PATINA" + section_id]?.[door_id]).length === 0) {
                        delete CONFIG.BASKET["PATINA" + section_id]?.[door_id]
                    }
                    if (typeof CONFIG.BASKET["PATINA" + section_id] === 'object' && Object.keys(CONFIG.BASKET["PATINA" + section_id]).length === 0) {
                        delete CONFIG.BASKET["PATINA" + section_id]
                    }
                }
                /*Контроль Патины*/

                /*Контроль Палитры*/
                if (fasadeColor.PALETTE[0]) {
                    var palettelist = self.$filter("filterPalette")(self.scope.app.PALETTE, {
                        element: fasadeID,
                    })
                    var paletteBasket = CONFIG.BASKET["PALETTE" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["PALETTE" + section_id]?.[segment_key];

                    if (
                        paletteBasket == undefined ||
                        self.scope.issetDefaultFasade ||
                        palettelist[paletteBasket] == undefined
                    )
                        if (
                            default_prop &&
                            default_prop.palette &&
                            palettelist[default_prop.palette] != undefined
                        )
                            paletteBasket = default_prop.palette;
                        else paletteBasket = Object.keys(palettelist)[0];

                    if (!CONFIG.BASKET["PALETTE" + section_id])
                        CONFIG.BASKET["PALETTE" + section_id] = {}

                    if (!CONFIG.BASKET["PALETTE" + section_id][door_id])
                        CONFIG.BASKET["PALETTE" + section_id][door_id] = {}

                    CONFIG.BASKET["PALETTE" + section_id][door_id][segment_key] = paletteBasket;

                } else {

                    if (CONFIG.BASKET["PALETTE" + section_id]?.[door_id]) {
                        delete CONFIG.BASKET["PALETTE" + section_id][door_id][segment_key];
                    }
                    if (typeof CONFIG.BASKET["PALETTE" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["PALETTE" + section_id]?.[door_id]).length === 0) {
                        delete CONFIG.BASKET["PALETTE" + section_id]?.[door_id]
                    }
                    if (typeof CONFIG.BASKET["PALETTE" + section_id] === 'object' && Object.keys(CONFIG.BASKET["PALETTE" + section_id]).length === 0) {
                        delete CONFIG.BASKET["PALETTE" + section_id]
                    }
                }
                /*Контроль Палитры*/

                /*Контроль стекла*/
                if (
                    fasadeColor.no_fasade == "N" &&
                    PRODUCT.GLASS.length &&
                    PRODUCT.GLASS[0] &&
                    self.scope.app.FASADE_POSITION[fasadePosition.ID].glass
                ) {
                    var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                            IDS: group.PROPS.PRODUCT.GLASS,
                            FASADE: fasadeID,
                        }),
                        glassBasket = CONFIG.BASKET["GLASS" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["GLASS" + section_id]?.[segment_key];

                    if (glassBasket == undefined || glasslist[glassBasket] == undefined)
                        glassBasket = Object.keys(glasslist)[0];

                    if (!CONFIG.BASKET["GLASS" + section_id])
                        CONFIG.BASKET["GLASS" + section_id] = {}

                    if (!CONFIG.BASKET["GLASS" + section_id][door_id])
                        CONFIG.BASKET["GLASS" + section_id][door_id] = {}

                    CONFIG.BASKET["GLASS" + section_id][door_id][segment_key] = glassBasket;
                } else if (
                    fasadeColor.no_fasade == "N" &&
                    PRODUCT.GLASS.length &&
                    PRODUCT.GLASS[0] &&
                    self.scope.app.FASADE_POSITION[fasadePosition.ID].is_glass_fasade &&
                    self.scope.app.FASADE[fasadeID].GLASS_ONLY
                ) {
                    var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                            IDS: group.PROPS.PRODUCT.GLASS,
                            FASADE: fasadeID,
                        }),
                        glassBasket = CONFIG.BASKET["GLASS" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["GLASS" + section_id]?.[segment_key];

                    if (glassBasket == undefined || glasslist[glassBasket] == undefined) {
                        glassBasket = Object.keys(glasslist)[0];
                    }

                    if (!CONFIG.BASKET["GLASS" + section_id])
                        CONFIG.BASKET["GLASS" + section_id] = {}

                    if (!CONFIG.BASKET["GLASS" + section_id][door_id])
                        CONFIG.BASKET["GLASS" + section_id][door_id] = {}

                    CONFIG.BASKET["GLASS" + section_id][door_id][segment_key] = glassBasket;
                } else {
                    if (CONFIG.BASKET["GLASS" + section_id]?.[door_id]) {
                        delete CONFIG.BASKET["GLASS" + section_id][door_id][segment_key];
                    }
                    if (typeof CONFIG.BASKET["GLASS" + section_id]?.[door_id] === 'object' && Object.keys(CONFIG.BASKET["GLASS" + section_id]?.[door_id]).length === 0) {
                        delete CONFIG.BASKET["GLASS" + section_id]?.[door_id]
                    }
                    if (typeof CONFIG.BASKET["GLASS" + section_id] === 'object' && Object.keys(CONFIG.BASKET["GLASS" + section_id]).length === 0) {
                        delete CONFIG.BASKET["GLASS" + section_id]
                    }
                }
                /*Контроль стекла*/

                /*Контроль типа витрины*/
                if (fasadeColor.no_fasade == "N" && PRODUCT.type_showcase[0]) {
                    var SHOWCASE_LIST = self.$filter("filterShowcase")(self.scope.app.SHOWCASE, {
                            group: group,
                            FASADE_NUMBER: section_id,
                        }),
                        SHOWCASE_ITEM = CONFIG.BASKET["SHOWCASE" + section_id]?.[door_id]?.[segment_key] || CONFIG.BASKET["SHOWCASE" + section_id]?.[segment_key];

                    if (SHOWCASE_LIST.length) {
                        if (SHOWCASE_ITEM == undefined) {
                            SHOWCASE_ITEM = SHOWCASE_LIST[0].ID;
                        }

                        if (!CONFIG.BASKET["SHOWCASE" + section_id])
                            CONFIG.BASKET["SHOWCASE" + section_id] = {};

                        if (!CONFIG.BASKET["SHOWCASE" + section_id][door_id])
                            CONFIG.BASKET["SHOWCASE" + section_id][door_id] = {};

                        CONFIG.BASKET["SHOWCASE" + section_id][door_id][segment_key] = SHOWCASE_ITEM;
                    } else {
                        delete CONFIG.BASKET["SHOWCASE" + section_id]?.[door_id]?.[segment_key];
                    }
                } else {
                    delete CONFIG.BASKET["SHOWCASE" + section_id]?.[door_id]?.[segment_key];
                }
                /*Констроль типа витрины*/

                const no_fasade = self.scope.app.constants.noFasad
                // проверка компановки "0" Без фасада
                if (CONFIG.BASKET.FILLING) {
                    if (CONFIG.BASKET.FILLING === 1008541) {
                        for (let ind = 0; ind <= 10; ind++) {
                            if (CONFIG.BASKET["DOORS"][door_id][ind][segment_key] !== undefined) {
                                CONFIG.BASKET["DOORS"][door_id][ind][segment_key] = no_fasade;
                            }
                        }
                    }
                }
                // проверка компановки "0" Без фасада

            })
        } else {
            if (!CONFIG.FASADELIST[section_id])
                CONFIG.FASADELIST[section_id] = {}

            CONFIG.FASADELIST[section_id][fasadePosition.FASADE_NUMBER] = fasadePositionId;
            CONFIG.BASKET['FASADEWIDTH' + section_id][door_id] = self.calcFasadeWidth(false, section_id, group, door_id)
        }
    }

    this.controlSlideDoors = function (group, default_prop, fasadePositionId, door_id) {
        const PROPS = group.PROPS;
        const CONFIG = group.PROPS.CONFIG;
        const PRODUCT = group.PROPS.PRODUCT;


        let fasadePosition = self.scope.app.FASADE_POSITION[fasadePositionId] ? Object.assign({}, self.scope.app.FASADE_POSITION[fasadePositionId]) : false;
        fasadePosition.FASADE_NUMBER = door_id

        if (!CONFIG.BASKET["DOORS"])
            CONFIG.BASKET["DOORS"] = {}

        let allFasades = false
        if (!CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER] || !Object.entries(CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER]).length) {
            allFasades = {0: default_prop.fasade};
        } else {
            allFasades = CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER]
        }

        angular.forEach(allFasades, function (fasade, segment_key) {
            var newFasade = false;
            var fasadeID = CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER]?.[segment_key]

            /*Выбор цвета фасада*/
            if (fasadeID === undefined || self.scope.issetDefaultFasade)
                newFasade = default_prop.fasade;
            else newFasade = fasadeID;

            fasadeID = self.canBeSetFasade(
                PRODUCT.ID,
                newFasade,
                fasadePosition.FASADE_NUMBER,
                door_id
            )
                ? newFasade
                : self.controlFasadeSiblings(
                    PRODUCT.ID,
                    newFasade,
                    fasadePosition.FASADE_NUMBER
                );

            if (CONFIG.BASKET["FASADEWIDTH" + fasadePosition.FASADE_NUMBER] < 600) {
                fasadeID = self.scope.fasadeErrorColor  //фасад не доступен
                self.alert('Минимальная ширина двери 600 мм.', "error")
            } else if (CONFIG.BASKET["FASADEWIDTH" + fasadePosition.FASADE_NUMBER] > 1300) {
                fasadeID = self.scope.fasadeErrorColor  //фасад не доступен
                self.alert('Максимальная ширина двери 1300 мм.', "error")
            } else if ((CONFIG.BASKET["FASADEWIDTH" + fasadePosition.FASADE_NUMBER] >= 600 && CONFIG.BASKET["FASADEWIDTH" + fasadePosition.FASADE_NUMBER] <= 1300) && fasadeID === self.scope.fasadeErrorColor) {
                fasadeID = default_prop.fasade
            } else if (newFasade != fasadeID) {
                self.scope.alerts[fasadeID] = "Цвет фасада изменен.";
            }

            if (!CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER] ||
                typeof CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER] === 'number')
                CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER] = {}

            CONFIG.BASKET["DOORS"][fasadePosition.FASADE_NUMBER][segment_key] = fasadeID;
            CONFIG.FASADELIST[fasadePosition.FASADE_NUMBER] = fasadePositionId;
            /*Выбор цвета фасада*/

            var fasadeColor = self.scope.app.FASADE[fasadeID];

            /*Назначение модели*/
            if (fasadePosition.models[0])
                CONFIG.models = fasadePosition.models;
            /*Назначение модели*/

            /*Контроль фрезировки*/
            if (PRODUCT.MILLING.length && PRODUCT.MILLING[0]) {
                var millingList = self.GetMillingList(fasadeID, PRODUCT.ID)
                var millingItem = false

                const oldMillingBasket = CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]?.[segment_key]

                //Проверка на удаленные фрезеровки

                /* !!!Проверить позже */
                if (millingList.indexOf(oldMillingBasket) == -1) {
                    self.checkMillingBasket(group, segment_key)
                }

                let millingBasket = CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]?.[segment_key]

                if (millingList.length) {
                    if (
                        millingBasket == undefined ||
                        self.scope.issetDefaultFasade ||
                        millingList.indexOf(millingBasket) == -1
                    )
                        if (
                            default_prop &&
                            default_prop.milling &&
                            millingList.indexOf(default_prop.milling) != -1
                        ) {
                            millingBasket = default_prop.milling;

                        } else {
                            millingBasket = millingList[0];
                        }

                    if (!CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER])
                        CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] = {}
                    CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER][segment_key] = millingBasket;

                    millingItem = self.scope.app.MILLING[millingBasket];
                } else {
                    if (CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]) {
                        delete CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER][segment_key];
                    }
                    if (typeof CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]).length === 0) {
                        delete CONFIG.BASKET["MILLING" + fasadePosition.FASADE_NUMBER]
                    }
                }
            }
            /*Контроль фрезировки*/

            /*Контроль типа фасада*/
            if (
                millingItem != undefined &&
                millingItem != false &&
                millingItem.fasade_type[0] &&
                fasadePosition.fasade_type[0]
            ) {

                var fasadeTypeBasket = CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]?.[segment_key]

                if (fasadeTypeBasket == undefined) {
                    var fasadeTypeList = self.$filter("filterFasadeType")(
                        fasadePosition.fasade_type,
                        {milling: millingItem.ID}
                    );
                    var FasadeTypeKeys = Object.keys(fasadeTypeList);
                    if (FasadeTypeKeys.length > 0) {
                        var fasadeTypeDefault = FasadeTypeKeys[0];

                        if (!CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER])
                            CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] = {}

                        CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key] = fasadeTypeDefault;
                    } else {

                        if (CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]) {
                            delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key]
                        }
                        if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                            delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                        }
                    }
                }
            } else if (
                self.scope.app.FASADE[fasadeID] != undefined &&
                fasadePosition.fasade_type[0] &&
                self.scope.app.FASADE[fasadeID].fasade_type[0]
            ) {
                var fasadeTypeBasket = CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                if (fasadeTypeBasket == undefined) {
                    var fasadeTypeList = self.$filter("filterFasadeType")(
                        fasadePosition.fasade_type,
                        {fasade: fasadeID}
                    );
                    var FasadeTypeKeys = Object.keys(fasadeTypeList);
                    if (FasadeTypeKeys.length > 0) {
                        var fasadeTypeDefault = FasadeTypeKeys[0];
                        if (!CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER])
                            CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] = {}
                        CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key] = fasadeTypeDefault;

                    } else {
                        if (CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]) {
                            delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key]
                        }
                        if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                            delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                        }
                    }
                }
            } else {

                if (CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]) {
                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER][segment_key]
                }
                if (typeof CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                    delete CONFIG.BASKET["FASADETYPE" + fasadePosition.FASADE_NUMBER]
                }
            }

            /*Контроль типа фасада*/

            /*Контроль Патины*/
            if (
                fasadeColor.PATINA[0] &&
                (!millingItem || (millingItem && !millingItem.PATINAOFF))
            ) {
                var patinaList = (CONFIG.PATINALIST[fasadePosition.FASADE_NUMBER] = fasadeColor.PATINA)
                var patinaBasket = CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                if (
                    patinaBasket == undefined ||
                    self.scope.issetDefaultFasade ||
                    patinaList.indexOf(patinaBasket) == -1
                )
                    if (
                        default_prop &&
                        default_prop.patina &&
                        patinaList.indexOf(default_prop.patina) != -1
                    )
                        patinaBasket = default_prop.patina;
                    else patinaBasket = fasadeColor.PATINA[0];

                if (!CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER])
                    CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] = {}

                if (typeof CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] !== "object")
                    CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] = {0: CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]}

                CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER][segment_key] = patinaBasket;


            } else {
                CONFIG.PATINALIST[fasadePosition.FASADE_NUMBER] = [];

                if (CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]) {
                    delete CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER][segment_key];
                }
                if (typeof CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]).length === 0) {
                    delete CONFIG.BASKET["PATINA" + fasadePosition.FASADE_NUMBER]
                }

            }
            /*Контроль Патины*/

            /*Контроль Палитры*/
            if (fasadeColor.PALETTE[0]) {
                var palettelist = self.$filter("filterPalette")(self.scope.app.PALETTE, {
                    element: fasadeID,
                })
                var paletteBasket = CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                if (
                    paletteBasket == undefined ||
                    self.scope.issetDefaultFasade ||
                    palettelist[paletteBasket] == undefined
                )
                    if (
                        default_prop &&
                        default_prop.palette &&
                        palettelist[default_prop.palette] != undefined
                    )
                        paletteBasket = default_prop.palette;
                    else paletteBasket = Object.keys(palettelist)[0];

                if (!CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER])
                    CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] = {}

                CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER][segment_key] = paletteBasket;

            } else {

                if (CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]) {
                    delete CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER][segment_key];
                }
                if (typeof CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]).length === 0) {
                    delete CONFIG.BASKET["PALETTE" + fasadePosition.FASADE_NUMBER]
                }
            }
            /*Контроль Палитры*/

            /*Контроль стекла*/
            if (
                fasadeColor.no_fasade == "N" &&
                PRODUCT.GLASS.length &&
                PRODUCT.GLASS[0] &&
                self.scope.app.FASADE_POSITION[fasadePosition.ID].glass
            ) {
                var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                        IDS: group.PROPS.PRODUCT.GLASS,
                        FASADE: fasadeID,
                    }),
                    glassBasket = CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                if (glassBasket == undefined || glasslist[glassBasket] == undefined)
                    glassBasket = Object.keys(glasslist)[0];

                if (!CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER])
                    CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] = {}

                CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER][segment_key] = glassBasket;
            } else if (
                fasadeColor.no_fasade == "N" &&
                PRODUCT.GLASS.length &&
                PRODUCT.GLASS[0] &&
                self.scope.app.FASADE_POSITION[fasadePosition.ID].is_glass_fasade &&
                self.scope.app.FASADE[fasadeID].GLASS_ONLY
            ) {
                var glasslist = self.$filter("DefaultGlassFilter")(self.scope.app.GLASS, {
                        IDS: group.PROPS.PRODUCT.GLASS,
                        FASADE: fasadeID,
                    }),
                    glassBasket = CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                if (glassBasket == undefined || glasslist[glassBasket] == undefined) {
                    glassBasket = Object.keys(glasslist)[0];
                }

                if (!CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER])
                    CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] = {}

                CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER][segment_key] = glassBasket;
            } else {
                if (CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]) {
                    delete CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER];
                }
                if (typeof CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER] === 'object' && Object.keys(CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]).length === 0) {
                    delete CONFIG.BASKET["GLASS" + fasadePosition.FASADE_NUMBER]
                }

            }
            /*Контроль стекла*/

            /*Контроль типа витрины*/
            if (fasadeColor.no_fasade == "N" && PRODUCT.type_showcase[0]) {
                var SHOWCASE_LIST = self.$filter("filterShowcase")(self.scope.app.SHOWCASE, {
                        group: group,
                        FASADE_NUMBER: fasadePosition.FASADE_NUMBER,
                    }),
                    SHOWCASE_ITEM = CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]?.[segment_key];

                if (SHOWCASE_LIST.length) {
                    if (SHOWCASE_ITEM == undefined) {
                        SHOWCASE_ITEM = SHOWCASE_LIST[0].ID;
                    }

                    if (!CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER])
                        CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER] = {};

                    CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER][segment_key] = SHOWCASE_ITEM;
                } else {
                    delete CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]?.[segment_key];
                }
            } else {
                delete CONFIG.BASKET["SHOWCASE" + fasadePosition.FASADE_NUMBER]?.[segment_key];
            }
            /*Констроль типа витрины*/

            const no_fasade = self.scope.app.constants.noFasad
            // проверка компановки "0" Без фасада
            if (CONFIG.BASKET.FILLING) {
                if (CONFIG.BASKET.FILLING === 1008541) {
                    for (let ind = 0; ind <= 10; ind++) {
                        if (CONFIG.BASKET["DOORS"][ind][segment_key] !== undefined) {
                            CONFIG.BASKET["DOORS"][ind][segment_key] = no_fasade;
                        }
                    }
                }
            }
            // проверка компановки "0" Без фасада

        })
    }

    this.checkMillingBasket = function (group, segment_key, isBoxMilling = false) {
        /* Временно */
        if (!group.PROPS.DELETED_ITEMS)
            group.PROPS.DELETED_ITEMS = {}

        group.PROPS.DELETED_ITEMS.MILLING = self.scope.app.constants.deletedMillings
        /* Временно */

        //Муртазин
        if (isBoxMilling) {
            angular.forEach(group.PROPS.DELETED_ITEMS.MILLING, function (milling, mkey) {
                if (isBoxMilling == mkey) {
                    isBoxMilling = milling.newId
                    self.alert('Внимание, название некоторых фрезеровок изменилось!')
                }
            })
        } else
            angular.forEach(group.PROPS.CONFIG.FASADELIST, function (fasade, fkey) {
                angular.forEach(group.PROPS.DELETED_ITEMS.MILLING, function (milling, mkey) {
                    if (segment_key && group.PROPS.CONFIG.BASKET['MILLING' + fkey]) {
                        if (group.PROPS.CONFIG.BASKET['MILLING' + fkey][segment_key] == mkey) {
                            group.PROPS.CONFIG.BASKET['MILLING' + fkey][segment_key] = milling.newId
                            self.alert('Внимание, название некоторых фрезеровок изменилось!')
                        }
                    } else {
                        if (group.PROPS.CONFIG.BASKET['MILLING' + fkey] == mkey) {
                            group.PROPS.CONFIG.BASKET['MILLING' + fkey] = milling.newId
                            self.alert('Внимание, название некоторых фрезеровок изменилось!')
                        }
                    }
                })
            })
    }

    this.controlElementSize = function (group, val, type) {
        var PRODUCT = group.PROPS.PRODUCT;
        var typeBig = type.toUpperCase();

        if (!!PRODUCT["SIZE_EDIT_" + typeBig][0]) {
            if (PRODUCT["SIZE_EDIT_" + typeBig].indexOf(val) == -1)
                val = PRODUCT["SIZE_EDIT_" + typeBig][0];
        } else {
            var max = PRODUCT["SIZE_EDIT_" + typeBig + "_MAX"]
                ? PRODUCT["SIZE_EDIT_" + typeBig + "_MAX"]
                : PRODUCT[type];
            var min = PRODUCT["SIZE_EDIT_" + typeBig + "_MIN"]
                ? PRODUCT["SIZE_EDIT_" + typeBig + "_MIN"]
                : 1;

            if (group.PROPS?.PRODUCT.moduleType?.CODE === "universal" && type == "width" && group.PROPS.CONFIG.CUSTOMFILLING) {
                max *= group.PROPS.CONFIG.CUSTOMFILLING.VSECTION
            }

            if (val < 0 || val == undefined || (max && val > max)) {
                val = max;
            }

            if (min && val < min) {
                val = min;
            }

            if (type == "width" && group.PROPS.CONFIG.BASKET["FILLING"]) {

                if (group.PROPS.CONFIG.CUSTOMFILLING) {
                    if (group.PROPS.CONFIG.CUSTOMFILLING.VSECTION === 1) {
                        let fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

                        group.PROPS.CONFIG.BASKET["SECTIONS" + group.PROPS.CONFIG.CUSTOMFILLING.VSECTION] = val - fasadeThickness * 2;
                    }

                    self.setSectionsSize(group, false, group.PROPS.CONFIG.CUSTOMFILLING.VSECTION);
                } else {
                    var size = self.controlFillingSize(group, val, type);
                    if (val != size["size"].width) val = size["size"].width;

                    self.setSectionsSize(group, size);
                }

            }
        }

        return val;
    };

    this.changeShelfCount = function (group, sectionNumber, rebuild) {
        let shelfPosition = self.calcSectionsShelfPosition(group, sectionNumber, rebuild);

        self.setSectionShelfValue(group, sectionNumber, shelfPosition);
        if (self.scope.app.active) {
            self.updateElement(self.scope.app.active);
        }

        // if (Object.keys(shelfPosition).length > 0) {
        //  for (let i in shelfPosition) {
        //    self.scope.$watchGroup(["app.active.PROPS.CONFIG.SECTIONS["+sectionNumber+"].SHELFPOSITION["+i+"]"], function () {
        //      self.changeShelfPosition(group, sectionNumber, i);
        //    });
        //  }
        // }
    };

    this.getSectionSize = function (group, sectionNumber) {

        if (!group.PROPS.CONFIG.BASKET["SECTIONS" + sectionNumber])
            return {
                width: 0,
                height: 0,
                depth: 0,
            };

        let fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];
        let topH = fasadeThickness || filling.HEIGHT_CORNICE || 0;

        let PLINTH_HEIGHT = (group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
            (!group.PROPS.CONFIG.BASKET.HORIZONT && group.PROPS.CONFIG.BASKET.HORIZONT !== 0) && filling.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : fasadeThickness || 0;
        let bottomH = (group.PROPS.CONFIG.BASKET.HORIZONT || group.PROPS.CONFIG.BASKET.HORIZONT === 0) ? PLINTH_HEIGHT + group.PROPS.CONFIG.BASKET.HORIZONT : PLINTH_HEIGHT || 0

        return {
            width: group.PROPS.CONFIG.BASKET["SECTIONS" + sectionNumber],
            height: group.PROPS.CONFIG.SIZE.height - (topH + bottomH),
            depth: group.PROPS.CONFIG.SIZE.depth - fasadeThickness,
        };
    };

    this.getMaxSectionPosition = function (group, sectionNumber) {
        let size = self.getSectionSize(group, sectionNumber)

        return size.height
    }

    this.getSectionShelfValue = function (shelfPosition) {
        var val = [];
        angular.forEach(shelfPosition, function (v, k) {
            let number = Number(v)
            val.push(number);
        });

        return val.join("-");
    };

    this.setSectionShelfValue = function (group, sectionNumber, shelfPosition) {
        var SectionShelfValue = self.getSectionShelfValue(shelfPosition);

        if (
            group.PROPS.CONFIG.SECTIONS[sectionNumber] &&
            group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFCOUNT
        ) {
            group.PROPS.CONFIG.BASKET["SHELFPOSITION" + sectionNumber] = SectionShelfValue;
            group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION = shelfPosition;
        } else if (
            group.PROPS.CONFIG.SECTIONS[sectionNumber] &&
            group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION
        ) {
            delete group.PROPS.CONFIG.BASKET["SHELFPOSITION" + sectionNumber];
            delete group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFCOUNT;
            delete group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION;
        }
    };

    this.calcSectionsShelfPosition = function (group, sectionNumber, rebuild) {
        let shelfPosition = {};
        if (group.PROPS.CONFIG.SECTIONS[sectionNumber]) {
            let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];
            let count = group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFCOUNT || 0;
            let sectionSize = self.getSectionSize(group, sectionNumber);
            let step = Math.floor(sectionSize.height / (count + 1));
            const shelfHeight = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

            for (var i = 1; i <= count; i++) {
                if (
                    group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION !== undefined &&
                    group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION[i] !== undefined &&
                    rebuild
                ) {
                    shelfPosition[i] = group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION[i];
                } else {
                    shelfPosition[i] = step * i - shelfHeight / 2;
                }

                const shelf = group.getObjectByName("SHELF_" + sectionNumber + "_" + 1);
                if (shelf) {
                    while (self.canSetPositionSubElement(group, shelf, new THREE.Vector3(0, shelfPosition[i], 0)) && shelfPosition[i] < sectionSize.height - shelfHeight / 2) {
                        shelfPosition[i] += shelfHeight
                    }
                }
            }
        }

        return shelfPosition;
    };

    this.loadFont = function (fontName, fontWeight, collback) {
        var loader = new THREE.FontLoader();
        loader.load(
            self.scope.TEMPLATE_PATH +
            "/libs/three.js-r91/examples/" +
            fontName +
            "_" +
            fontWeight +
            ".typeface.json",
            function (response) {
                self.scope.font = response;
                collback();
            }
        );
    };

    this.changeMilling = function (news, old) {
        const active_segment = self.scope.app.active_fasade_segment
        const active_door = self.scope.app.active_fasade_door
        const active_fasade = self.scope.app.active_fasade
        const group = self.scope.app.active
        const itsBoxFasade = self.checkBoxForFasade(group, active_fasade, active_segment, false, active_door)

        if (news) {
            this.changeFasadeTypeDefault(news, active_segment, active_door);
            if (
                active_fasade &&
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {

                if (itsBoxFasade) {
                    itsBoxFasade.FASADE.FASADE_INFO.MILLING = news
                    self.changeFasade(group, itsBoxFasade.FASADE.FASADE_INFO.COLOR);
                } else if (active_door) {
                    group.PROPS.CONFIG.BASKET["MILLING" + active_fasade][active_door][active_segment] = news;

                    const fasadeSegments = group.PROPS.CONFIG.BASKET.DOORS?.[active_fasade]?.[active_door]
                    self.changeFasade(group, fasadeSegments[active_segment]);
                } else {
                    group.PROPS.CONFIG.BASKET["MILLING" + active_fasade][active_segment] = news;

                    const fasadeSegments = group.PROPS.CONFIG.BASKET.DOORS?.[active_fasade] || group.PROPS.CONFIG.BASKET['FASADE' + active_fasade]
                    self.changeFasade(group, fasadeSegments[active_segment]);
                }
            } else {
                if (self.scope.app.optionsTabName == "defaultFasadeMillingup") {
                    self.scope.project.default_fasade_milling_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_fasade_up);
                } else if (self.scope.app.optionsTabName == "defaultFasadeMillingdown") {
                    self.scope.project.default_fasade_milling_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_fasade_down
                    );
                }
            }
        }
    };

    this.changeFasadeTypeDefault = function (news, segment) {
        if (self.scope.app.active === false)
            return false;

        let productID = self.scope.app.active.PROPS.CONFIG.ID,
            productInfo = self.getProductInfo(productID),
            productFasadeType = productInfo.fasade_type,
            millingInfo = self.scope.app.MILLING[news] ? self.scope.app.MILLING[news] : false,
            fasadeTypeID = segment ? self.scope.app.active.PROPS.CONFIG.BASKET["FASADETYPE" + self.scope.app.active_fasade]?.[segment] : self.scope.app.active.PROPS.CONFIG.BASKET["FASADETYPE" + self.scope.app.active_fasade],
            activeFasadeType,
            searchFasadeType;


        if (!millingInfo || fasadeTypeID === undefined) return false;

        activeFasadeType = millingInfo.fasade_type.filter(function (obj) {
            return productFasadeType.indexOf(obj) >= 0;
        });

        searchFasadeType = activeFasadeType.indexOf(fasadeTypeID);

        if (searchFasadeType < 0 && activeFasadeType.length > 0) {
            this.changeFasadeType(activeFasadeType[0]);
            let fasadeTypeListPosition = self.scope.app.FASADE_POSITION[segment ? self.scope.app.active.PROPS.CONFIG.FASADELIST[self.scope.app.active_fasade][segment] : self.scope.app.active.PROPS.CONFIG.FASADELIST[self.scope.app.active_fasade]].fasade_type;
            let setFasadeType = activeFasadeType[0];

            angular.forEach(fasadeTypeListPosition, function (e) {
                if (activeFasadeType.indexOf(e) >= 0) {
                    setFasadeType = e;
                }
            });

            this.changeFasadeType(setFasadeType);
        }
    };

    this.changeFasadeType = function (news) {
        const group = self.scope.app.active
        const section = self.scope.app.active_fasade
        const door = self.scope.app.active_fasade_door
        const segment = self.scope.app.active_fasade_segment
        const itsBoxFasade = self.checkBoxForFasade(group, section, segment, false, door)

        if (news) {
            const fasadeSegments = door ? group.PROPS.CONFIG.BASKET.DOORS?.[section]?.[door] : group.PROPS.CONFIG.BASKET.DOORS?.[section] ||
                group.PROPS.CONFIG.BASKET['FASADE' + section]

            if (itsBoxFasade) {
                itsBoxFasade.FASADE.FASADE_INFO.FASADETYPE = news
                self.changeFasade(group, itsBoxFasade.FASADE.FASADE_INFO.COLOR);
            } else if (segment) {
                if (!group.PROPS.CONFIG.BASKET["FASADETYPE" + section])
                    group.PROPS.CONFIG.BASKET["FASADETYPE" + section] = {}

                if (door) {
                    if (!group.PROPS.CONFIG.BASKET["FASADETYPE" + section][door])
                        group.PROPS.CONFIG.BASKET["FASADETYPE" + section][door] = {}

                    group.PROPS.CONFIG.BASKET["FASADETYPE" + section][door][segment] = news;
                } else
                    group.PROPS.CONFIG.BASKET["FASADETYPE" + section][segment] = news;

                self.changeFasade(group,
                    fasadeSegments[segment]
                );
            } else {
                group.PROPS.CONFIG.BASKET["FASADETYPE" + section] =
                    news;
                self.changeFasade(group,
                    fasadeSegments
                );
            }
        }
    };

    this.changePalette = function (news, old) {
        const segment = self.scope.app.active_fasade_segment
        const group = self.scope.app.active
        const section = self.scope.app.active_fasade
        const door = self.scope.app.active_fasade_door

        const itsBoxFasade = self.checkBoxForFasade(group, section, segment, false, door)

        /* !!!Пееписать без условия section */
        if (news) {
            if (
                section &&
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                if (itsBoxFasade) {
                    itsBoxFasade.FASADE.FASADE_INFO.PALETTE = news
                    self.changeFasade(group, itsBoxFasade.FASADE.FASADE_INFO.COLOR);
                } else if (segment) {

                    if (door) {

                        if (!self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section][door])
                            self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section][door] = {}

                        self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section][door][segment] = news
                    } else {
                        if (!self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section])
                            self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section] = {}

                        self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section][segment] = news;
                    }

                    self.changeFasade(self.scope.app.active, door ? self.scope.app.active.PROPS.CONFIG.BASKET.DOORS[section][door][segment] :
                        self.scope.app.active.PROPS.CONFIG.BASKET["FASADE" + section][segment]);
                } else {
                    self.scope.app.active.PROPS.CONFIG.BASKET["PALETTE" + section] = news;

                    self.changeFasade(self.scope.app.active, self.scope.app.active.PROPS.CONFIG.BASKET["FASADE" + section]);
                }
            } else {
                if (self.scope.app.optionsTabName == "defaultFasadePaletteup") {
                    self.scope.project.default_fasade_palette_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_fasade_up);
                } else if (self.scope.app.optionsTabName == "defaultFasadePalettedown") {
                    self.scope.project.default_fasade_palette_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_fasade_down
                    );
                }
            }
        }
    };

    this.changePatina = function (news, old) {
        /* !!!Пееписать без условия section */
        const group = self.scope.app.active
        const section = self.scope.app.active_fasade
        const segment = self.scope.app.active_fasade_segment
        const door = self.scope.app.active_fasade_door
        const itsBoxFasade = self.checkBoxForFasade(group, section, segment, false, door)

        if (news) {
            if (
                section &&
                self.scope.app.optionsTab[self.scope.app.optionsTabName].default != true
            ) {
                if (itsBoxFasade) {
                    itsBoxFasade.FASADE.FASADE_INFO.PATINA = news
                    self.changeFasade(group, itsBoxFasade.FASADE.FASADE_INFO.COLOR);
                } else if (segment) {

                    if (door) {

                        if (!self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section][door])
                            self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section][door] = {}

                        self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section][door][segment] = news
                    } else {
                        if (!self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section])
                            self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section] = {}

                        self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section][segment] = news;
                    }

                    self.changeFasade(self.scope.app.active, door ? self.scope.app.active.PROPS.CONFIG.BASKET.DOORS[section][door][segment] :
                        self.scope.app.active.PROPS.CONFIG.BASKET["FASADE" + section][segment]);
                } else {
                    self.scope.app.active.PROPS.CONFIG.BASKET["PATINA" + section] = news;

                    self.changeFasade(self.scope.app.active, self.scope.app.active.PROPS.CONFIG.BASKET["FASADE" + section]);
                }
            } else {
                if (self.scope.app.optionsTabName == "defaultFasadePatinaup") {
                    self.scope.project.default_fasade_patina_up = news;
                    self.ChangeDefaultFasade("element_up", self.scope.project.default_fasade_up);
                } else if (self.scope.app.optionsTabName == "defaultFasadePatinadown") {
                    self.scope.project.default_fasade_patina_down = news;
                    self.ChangeDefaultFasade(
                        "element_down",
                        self.scope.project.default_fasade_down
                    );
                }
            }
        }
    };

    this.changeHandle = function (element, news, isDoubleHandle = false, _door = false) {

        //костыль из-за optionsFunction
        if (element && (!news && news !== 0)) {
            news = element
            element = self.scope.app.active
        }

        if (news) {
            const group = element && typeof element === "object" ? element : self.scope.app.active
            const section = self.scope.app.active_fasade
            const segment = self.scope.app.active_fasade_segment
            const door = _door || self.scope.app.active_fasade_door
            const productInfo = self.getProductInfo(news)

            if (productInfo == undefined)
                news = Object.keys(self.scope.app.HANDLES)[0];

            self.changeElementHandle(group, news, section, segment, isDoubleHandle, door);
        }
    };

    this.changeLoopSide = function (news) {
        if (news) {
            const group = self.scope.app.active
            const section = self.scope.app.active_fasade
            const segment = self.scope.app.active_fasade_segment
            const door = self.scope.app.active_fasade_door

            if (self.scope.app.LOOPSIDE[news] != undefined) {
                if (door)
                    group.PROPS.CONFIG.BASKET.LOOPSSIDE[section][door] = news
                else
                    group.PROPS.CONFIG.BASKET.LOOPSSIDE[section] = news
            }
            self.updateElement(group)

            if (group.PROPS.CONFIG.BASKET.SIDEPROFILE && Object.entries(group.PROPS.CONFIG.BASKET.SIDEPROFILE).length) {
                self.updateSideHiTechProfile(group, +section)
                //self.rebuildWrap(group)
            }
        }
    }

    this.changeModel = function (news, old) {
        if (news) {
            self.scope.app.active.PROPS.CONFIG.MODEL = news;
            self.updateElement(self.scope.app.active);
        }
    };

    this.controlCollision = function (obj, position, rotation) {
        var obj = obj || self.scope.app.selected.object;
        var group = obj.parent

        var dragElement = self.getMinMaxPosition(obj, position, rotation);
        var intersection = [];

        var Magnet = {};
        var MagnetToptmp = false;
        var MagnetBottomtmp = false;
        var MagnetBacktmp = false;
        var MagnetForwardtmp = false;
        var MagnetLefttmp = false;
        var MagnetRighttmp = false;

        angular.forEach(
            self.scope.app.elements.filter(function (el) {
                if (el.id != group.id) return true;
            }),
            function (val, key) {
                var element = self.getMinMaxPosition(val.PROPS.WRAP);
                if (
                    !(
                        element.minY >= dragElement.maxY ||
                        element.maxY <= dragElement.minY ||
                        element.minX >= dragElement.maxX ||
                        element.maxX <= dragElement.minX ||
                        element.minZ >= dragElement.maxZ ||
                        element.maxZ <= dragElement.minZ
                    ) &&
                    !val.PROPS.CONFIG.DISABLE_RAYCAST &&
                    !group.PROPS.CONFIG.DISABLE_RAYCAST &&
                    !group.PROPS.CONFIG.HAVE_RASPIL &&
                    !val.PROPS.CONFIG.HAVE_RASPIL
                ) {
                    intersection.push(val);
                }

                /*Y*/
                var YTopmax = Math.abs(dragElement.maxY - element.maxY);
                var Ybottommax = Math.abs(dragElement.maxY - element.minY);

                var YTopmin = Math.abs(dragElement.minY - element.minY);
                var Ybottommin = Math.abs(dragElement.minY - element.maxY);

                var maxYsize = Ybottommax > YTopmax ? YTopmax : Ybottommax;
                var minYsize = Ybottommin > YTopmin ? YTopmin : Ybottommin;

                MagnetToptmp =
                    MagnetToptmp === false ? ((Magnet.top = Ybottommax > YTopmax ? element.maxY : element.minY), (Magnet.topObj = val), maxYsize)
                        : MagnetToptmp > maxYsize ? ((Magnet.top = Ybottommax > YTopmax ? element.maxY : element.minY), (Magnet.topObj = val), maxYsize)
                            : MagnetToptmp;
                MagnetBottomtmp =
                    MagnetBottomtmp === false
                        ? ((Magnet.bottom = Ybottommin > YTopmin ? element.minY : element.maxY),
                            (Magnet.bottomObj = val),
                            minYsize)
                        : MagnetBottomtmp > minYsize
                            ? ((Magnet.bottom = Ybottommin > YTopmin ? element.minY : element.maxY),
                                (Magnet.bottomObj = val),
                                minYsize)
                            : MagnetBottomtmp;
                /*Y*/

                /*X*/
                var XLeftmax = Math.abs(dragElement.maxX - element.maxX);
                var XRightmax = Math.abs(dragElement.maxX - element.minX);

                var XLeftmin = Math.abs(dragElement.minX - element.minX);
                var XRightmin = Math.abs(dragElement.minX - element.maxX);

                var maxXsize = XRightmax > XLeftmax ? XLeftmax : XRightmax;
                var minXsize = XRightmin > XLeftmin ? XLeftmin : XRightmin;

                MagnetLefttmp =
                    MagnetLefttmp === false
                        ? ((Magnet.left = XRightmax > XLeftmax ? element.maxX : element.minX),
                            (Magnet.leftObj = val),
                            maxXsize)
                        : MagnetLefttmp > maxXsize
                            ? ((Magnet.left = XRightmax > XLeftmax ? element.maxX : element.minX),
                                (Magnet.leftObj = val),
                                maxXsize)
                            : MagnetLefttmp;
                MagnetRighttmp =
                    MagnetRighttmp === false
                        ? ((Magnet.right = XRightmin > XLeftmin ? element.minX : element.maxX),
                            (Magnet.rightObj = val),
                            minXsize)
                        : MagnetRighttmp > minXsize
                            ? ((Magnet.right = XRightmin > XLeftmin ? element.minX : element.maxX),
                                (Magnet.rightObj = val),
                                minXsize)
                            : MagnetRighttmp;
                /*X*/

                /*Z*/
                var ZForwardmax = Math.abs(dragElement.maxZ - element.maxZ);
                var ZBackmax = Math.abs(dragElement.maxZ - element.minZ);

                var ZForwardmin = Math.abs(dragElement.minZ - element.minZ);
                var ZBackmin = Math.abs(dragElement.minZ - element.maxZ);

                var maxZsize = ZBackmax > ZForwardmax ? ZForwardmax : ZBackmax;
                var minZsize = ZBackmin > ZForwardmin ? ZForwardmin : ZBackmin;

                MagnetForwardtmp =
                    MagnetForwardtmp === false
                        ? ((Magnet.forward = ZBackmax > ZForwardmax ? element.maxZ : element.minZ),
                            (Magnet.forwardObj = val),
                            maxZsize)
                        : MagnetForwardtmp > maxZsize
                            ? ((Magnet.forward = ZBackmax > ZForwardmax ? element.maxZ : element.minZ),
                                (Magnet.forwardObj = val),
                                maxZsize)
                            : MagnetForwardtmp;
                MagnetBacktmp =
                    MagnetBacktmp === false
                        ? ((Magnet.back = ZBackmin > ZForwardmin ? element.minZ : element.maxZ),
                            (Magnet.backObj = val),
                            minZsize)
                        : MagnetBacktmp > minZsize
                            ? ((Magnet.back = ZBackmin > ZForwardmin ? element.minZ : element.maxZ),
                                (Magnet.backObj = val),
                                minZsize)
                            : MagnetBacktmp;
                /*Z*/
            }
        );

        return {
            intersection: intersection,
            dragElement: dragElement,
            Magnet: Magnet,
        };
    };

    this.getMinMaxPosition = function (_obj, position, rotation) {
        const group = _obj.parent
        const obj = _obj.clone()
        var rotation = rotation || group.rotation;
        var position = position || group.position;

        obj.rotation.copy(rotation)

        let clon_pos = obj.position.clone()
        switch (rotation.y) {
            case Math.PI / 2:
                clon_pos.multiplyScalar(-1)
            case -Math.PI / 2:
                let tmp_axis = clon_pos.x
                clon_pos.x = clon_pos.z
                clon_pos.z = tmp_axis

                obj.position.copy(clon_pos.add(position))
                break;
            case Math.PI:
            case -Math.PI:
                clon_pos.multiplyScalar(-1)
            default:
                obj.position.copy(clon_pos.add(position))
                break;
        }

        let size = new THREE.Vector3()
        let box = new THREE.Box3().setFromObject(obj.clone());
        box.getSize(size);

        var width = size.x;
        var height = size.y;
        var depth = size.z;

        let result = {}
        if (rotation.y == 0 || rotation.y == Math.PI) {
            result = {
                minX: box.min.x,//position.x - width / 2,
                maxX: box.max.x,//position.x + width / 2,
                minY: box.min.y,//position.y - height / 2,
                maxY: box.max.y,//position.y + height / 2,
                minZ: box.min.z,//position.z - depth / 2,
                maxZ: box.max.z,//position.z + depth / 2,
                width: width,
                height: height,
                depth: depth,
            };
        } else {
            result = {
                minX: box.min.x,//position.x - depth / 2,
                maxX: box.max.x,//position.x + depth / 2,
                minY: box.min.y,//position.y - height / 2,
                maxY: box.max.y,//position.y + height / 2,
                minZ: box.min.z,//position.z - width / 2,
                maxZ: box.max.z,//position.z + width / 2,
                width: depth,
                height: height,
                depth: width,
            };
        }

        /*if (group.PROPS.CONFIG.ID == 3140746) {
            //Костыль!!!!!!! проверяет только шуг прямой нестандарт
            result.depth += 80;
        }*/

        return result;
    };

    this.createLeg = function (leg_length) {
        var material = new THREE.MeshPhongMaterial(
            self.scope.outlineType
                ? {color: "#ffffff", opacity: 0.5, transparent: true}
                : {emissive: "#000000", color: "#000000", reflectivity: 0.05}
        );

        var topGeometry = new THREE.CylinderGeometry(14, 14, leg_length - 20, 8);
        var bottomGeometry = new THREE.CylinderGeometry(25, 25, 20, 12);

        var group = new THREE.Object3D(),
            t = new THREE.Mesh(topGeometry, material),
            b = new THREE.Mesh(bottomGeometry, material);

        if (self.scope.outlineType) {
            self.createEdge(t), self.createEdge(b);
        }

        t.position.setY(-(leg_length / 2) + 10);
        b.position.setY(-leg_length + 10);

        group.add(t, b);

        return group;
    };

    this.rebuildRoomLineOut = function (callback, type) {
        var callback = callback || new Function();
        var type = type || !self.scope.outlineType;

        self.unmarkSelected();

        self.scope.outlineType = type;

        self.isStop = true;

        self.start();

        self.loadProject(
            JSON.parse(localStorage["project" + self.scope.app.config.dataProvider])
        );

        self.render();

        self.scope.$applyAsync();

        callback();
    };

    this.createEdge = function (mesh, type, isReal) {
        var isReal = isReal || false;
        var type = type || false;
        var edges = new THREE.EdgesGeometry(mesh.geometry);
        var meshEdge = new THREE.LineSegments(
            edges,
            new THREE.LineBasicMaterial({color: isReal ? 0x555555 : 0x000000, linewidth: 1})
        );

        meshEdge.position.clone(mesh.position);
        meshEdge.ElementType = type;
        self.EDGES[meshEdge.id] = meshEdge;
        mesh.EDGE = meshEdge;
        self.scene.add(meshEdge);
        mesh.add(meshEdge);
        return meshEdge;
    };

    this.removeEdgeFromElement = function (obj) {
        if (obj instanceof THREE.Mesh) {
            if (obj.EDGE) self.removeEdge(obj.EDGE.id);
        } else if (obj instanceof THREE.Object3D) {
            angular.forEach(obj.children, function (e) {
                self.removeEdgeFromElement(e);
            });
        }
    };

    this.initCamera = function () {
        /********** Создаём вид камеры **********/
        self.camera = new THREE.PerspectiveCamera(
            self.scope.camFactor,
            window.innerWidth / window.innerHeight,
            100,
            30000
        );
        self.initControl();
    };

    this.initControl = function () {
        if (self.scope.controlDevice) {
            self.controls = new THREE.DeviceOrientationControls(self.camera, true);
            self.controls.screenSpacePanning = true;
            self.camera.position.set(0, 0, self.scope.project.room_config.depth / 2);

            self.back.visible = false;
            self.left.visible = false;
            self.right.visible = false;
            self.forward.visible = false;
            self.top.visible = false;
            self.bottom.visible = false;
        } else {
            self.canvas = document.getElementById(self.container_sel);
            self.controls = new THREE.OrbitControls(self.camera, self.canvas, self.scope);
            self.controls.enableDamping = true;
            self.controls.dampingFactor = 0.3;
            self.back.visible = true;
            self.left.visible = true;
            self.right.visible = true;
            self.forward.visible = true;
            self.top.visible = true;
            self.bottom.visible = true;

            self.transform = new THREE.TransformControls(self.camera, self.canvas);
            self.scene.add(self.transform);

            self.transform.addEventListener("dragging-changed", function (event) {
                self.controls.enabled = !event.value;
                /* УПРАВЛЯЕТ TRANSFORM(стрелочки) */
            });

            self.transform.addEventListener("objectChange", function (event) {
                self.sincRotation();
            });

            if (self.scope.outlineType) {
                self.camera.position.set(
                    0,
                    0,
                    self.scope.project.room_config.depth / self.scope.app.config.zoom
                );
            } else {
                self.camera.position.set(
                    0,
                    0,
                    self.scope.project.room_config.depth / self.scope.app.config.zoom
                );
                self.controls.minDistance = 700;
                self.controls.maxDistance = 20000;

                self.controls.minZoom = 10;
                self.controls.maxZoom = 50;
            }
        }
    };

    this.sincRotation = function () {
        if (self.timerrotation) {
            clearTimeout(self.timerrotation);
        }
        self.timerrotation = setTimeout(function () {
            if (self.scope.app.active) {
                self.scope.activeRotation = {
                    x: Math.round(THREE.Math.radToDeg(self.scope.app.active.rotation.x)),
                    y: Math.round(THREE.Math.radToDeg(self.scope.app.active.rotation.y)),
                    z: Math.round(THREE.Math.radToDeg(self.scope.app.active.rotation.z)),
                };
                self.scope.$applyAsync();
            }
        }, 100);
    };

    this.createPlinth = function (posX, posY, posZ) {
        var TopPlinth = new THREE.Shape();
        TopPlinth.moveTo(0, 40);
        TopPlinth.lineTo(0, 0);
        TopPlinth.lineTo(4.6169, 2.2818);
        TopPlinth.lineTo(8.1659, 6.0136);
        TopPlinth.lineTo(10.213, 10.7393);
        TopPlinth.lineTo(12.4219, 10.7393);
        TopPlinth.lineTo(14.8222, 16.4677);
        TopPlinth.lineTo(18.6099, 21.3901);
        TopPlinth.lineTo(23.5323, 25.1778);
        TopPlinth.lineTo(29.2607, 27.5781);
        TopPlinth.lineTo(29.2607, 29.787);
        TopPlinth.lineTo(33.9864, 31.8341);
        TopPlinth.lineTo(37.7182, 35.3831);
        TopPlinth.lineTo(40, 40);
        TopPlinth.lineTo(0, 40);

        var bottomPlinth = new THREE.Shape();
        bottomPlinth.moveTo(0, 0);
        bottomPlinth.lineTo(22, 0);
        bottomPlinth.absarc(32.6, 10.6, 15, Math.PI + Math.PI / 4, Math.PI, !0);
        bottomPlinth.lineTo(15, 40);
        bottomPlinth.absarc(0, 40, 15, 0, Math.PI / 2, !1);
        bottomPlinth.lineTo(0, 0);

        var addPlinth = function (
            Plinth,
            depth_pos,
            face,
            posiX,
            posiY,
            posiZ,
            rotX,
            rotY,
            rotZ,
            materiall
        ) {
            var Plinth = new THREE.ExtrudeGeometry(Plinth, {
                    depth: depth_pos,
                    bevelEnabled: !1,
                    curveSegments: 3,
                }),
                PlinthObg;
            Plinth.computeFaceNormals();
            PlinthObg = new THREE.Mesh(Plinth, materiall);
            PlinthObg.rotation.set(rotX, rotY, rotZ);
            PlinthObg.position.y = posiY;
            PlinthObg.position.x = posiX;
            PlinthObg.position.z = posiZ;
            PlinthObg.face = face;
            PlinthObg.receiveShadow = true;
            return PlinthObg;
        };

        self.bottomPlinthLeft = addPlinth(
            bottomPlinth,
            posZ,
            2,
            -posX / 2,
            -(posY / 2),
            0,
            0,
            0,
            0,
            self.materialFloor
        );
        self.bottomPlinthRight = addPlinth(
            bottomPlinth,
            posZ,
            3,
            posX / 2,
            -(posY / 2),
            posZ,
            0,
            -Math.PI,
            0,
            self.materialFloor
        );
        self.bottomPlinthBack = addPlinth(
            bottomPlinth,
            posX,
            5,
            posX / 2,
            -(posY / 2),
            0,
            0,
            -Math.PI / 2,
            0,
            self.materialFloor
        );
        self.bottomPlinthForward = addPlinth(
            bottomPlinth,
            posX,
            5,
            -posX / 2,
            -(posY / 2),
            posZ,
            0,
            Math.PI / 2,
            0,
            self.materialFloor
        );

        self.scene.add(
            self.bottomPlinthLeft,
            self.bottomPlinthRight,
            self.bottomPlinthBack,
            self.bottomPlinthForward
        );
    };

    this.createBody = function (group) {
        var body = new THREE.Object3D();
        group.visible = true;
        group.PROPS.CONFIG.CHILD = [];
        group.PROPS.BOX = self.createBox(group);

        group.add(group.PROPS.BOX);

        if (group.PROPS.CONFIG.HAVE_RASPIL && group.PROPS.CONFIG.RASPILLIST.length) {
            group.visible = false;
            angular.forEach(group.PROPS.RASPILFRAGMENT, function (rasp, krasp) {
                var ext = group.PROPS.CONFIG;
                var CONFIG = JSON.parse(JSON.stringify(ext));
                var pos = self.getRaspilPosition(group, rasp, krasp);
                CONFIG.HAVE_RASPIL = false;
                CONFIG.USLUGILIST = self.getSubUslugi(group, krasp + 1);
                CONFIG.RASPILLIST = [];
                CONFIG.TYPE = "SUBELEMENT";
                CONFIG.SIZE.width = rasp;
                CONFIG.POSITION = pos.position;
                CONFIG.ROTATION = pos.rotation;
                CONFIG.RASPILKEY = krasp;
                CONFIG.PARENT_GROUP = group

                self.addElementToProjectFromProp(CONFIG, group);
            });
        }

        if (group.PROPS.CONFIG.HIDDENCHILDREN[group.id]) {
            group.visible = false
        }
        //Скрытие элементов столешницы
        if (group.PROPS.CONFIG.HIDDENCHILDREN && group.PROPS.CONFIG.CHILDPOSITION) {
            angular.forEach(group.PROPS.CONFIG.HIDDENCHILDREN, function (child, kchild) {
                const foundItem = self.scope.project.items[group.id]
                if (child.POSITION.x == foundItem.POSITION.x && child.POSITION.y == foundItem.POSITION.y && child.POSITION.z == foundItem.POSITION.z) {
                    group.visible = false
                }
            })
        }
        self.scope.$applyAsync();

        body.unionBoudingBox = self.calculateUnionBoundingBox(body)

        if (group.PROPS.PRODUCT.moduleType) {
            if (group.PROPS.CONFIG.autoGenShelves !== true && group.PROPS.CONFIG.autoGenShelves !== false)
                group.PROPS.CONFIG.autoGenShelves = false

            if (group.PROPS.CONFIG.HIDE_FASADE) {
                if (!group.PROPS.SUBELEMENTS_RULERS)
                    self.createSubelelmentsRulers(group)
                else
                    group.PROPS.SUBELEMENTS_RULERS.visible = true
            } else if (group.PROPS.SUBELEMENTS_RULERS) {
                group.PROPS.SUBELEMENTS_RULERS.visible = false
            }
        }

        return body;
    };

    this.createBox = function (obj) {
        var product = obj.PROPS.PRODUCT;
        var size = self.getProductSize(obj.PROPS);
        var group = new THREE.Object3D(),
            left,
            right,
            bottom,
            top,
            back;
        var module_model = obj.PROPS.CONFIG.MODEL;

        obj.PROPS.SECTIONSOBJ = [];
        obj.PROPS.SECTIONCONTROL = [];

        var start_position = self.getStartPosition(size);
        self.initProductSize(obj.PROPS.CONFIG, product, size);

        if (obj.PROPS.CONFIG.BASKET["PROFILE"]) {
            var usl = self.scope.app.USLUGI[obj.PROPS.CONFIG.BASKET["PROFILE"]];

            if (usl.model) module_model = usl.model;
        }

        if (obj.PROPS.CONFIG.BASKET["FILLING"]) {
            var filling = self.scope.app.FILLING[obj.PROPS.CONFIG.BASKET["FILLING"]];
        }

        var model = module_model ? self.scope.app.MODELS[module_model] : false;

        // проверка отсутствия цвета корпуса
        function checkModuleColor() {
            if (!self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR]) {
                for (let i = 0; i < product.MODULECOLOR.length; i++) {
                    if (product.MODULECOLOR[i] && self.scope.app.FASADE[product.MODULECOLOR[i]]) {
                        obj.PROPS.CONFIG.BASKET.MODULECOLOR = product.MODULECOLOR[i];
                        break;
                    }
                }

                if (!obj.PROPS.CONFIG.BASKET.MODULECOLOR || !self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR]) {
                    obj.PROPS.CONFIG.BASKET.MODULECOLOR = self.scope.fasadeErrorColor
                    self.scope.alerts[obj.PROPS.CONFIG.BASKET.MODULECOLOR] = "Ниодин цвет корпуса не доступен. Цвет корпуса изменен.";
                } else
                    self.scope.alerts[obj.PROPS.CONFIG.BASKET.MODULECOLOR] = "Цвет корпуса изменен.";
            }

            return self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR];
        }

        var color = obj.PROPS.CONFIG.BASKET.COLOR ? self.scope.app.COLOR[obj.PROPS.CONFIG.BASKET.COLOR] : false;
        var moduleColor = obj.PROPS.CONFIG.BASKET.MODULECOLOR ? checkModuleColor() :
            product.texture ? {
                TEXTURE: product.texture.src,
                TEXTURE_HEIGHT: product.texture.height,
                TEXTURE_WIDTH: product.texture.width,
            } : false;

        color = color || moduleColor

        if (color) {
            if (product.PREVIEW_PICTURE != color.TEXTURE) {
                var materiall = {map: self.loadFileCache(color.TEXTURE, "img")};
            }
        } else {
            var materiall = {map: false, color: "#ffffff"};
        }

        group.MATERIALL = new THREE.MeshPhongMaterial(materiall);

        if (!model) {
            if (product.models[0]) {
                model = self.scope.app.MODELS[product.models[0]];
            } else {
                obj.ERR = "Модель товара не найдена: " + obj.PROPS.CONFIG.ID;
                return false;
            }
        }

        model = self.expressionsReplace(
            model,
            angular.extend(obj.PROPS.EXPRESSIONS, {
                "#X#": size.width,
                "#Y#": size.height,
                "#Z#": size.depth,
                "#MATERIAL_THICKNESS#": color?.DEPTH,
                "#HORIZONT#": obj.PROPS.CONFIG.NOBOTTOM ? 0 :
                    obj.PROPS.CONFIG.BASKET.HORIZONT || obj.PROPS.CONFIG.BASKET.HORIZONT === 0 ? obj.PROPS.CONFIG.BASKET.HORIZONT :
                        obj.PROPS.EXPRESSIONS["#HORIZONT#"] || 78,  //78 - стандартная высота цоколя на случай отсутствия данных
            })
        );

        var json = model.json;
        var dae = model.DAE;

        if (product.width != parseInt(size.width) && self.isResize(product) && dae)
            group.scale.x = parseInt(size.width) / product.width;

        if (product.height != parseInt(size.height) && self.isResize(product) && dae)
            group.scale.y = parseInt(size.height) / product.height;

        if (product.depth != parseInt(size.depth) && self.isResize(product) && dae)
            group.scale.z = parseInt(size.depth) / product.depth;

        if (json) {
            var conf = self.expressionsReplace(
                json,
                angular.extend(
                    obj.PROPS.EXPRESSIONS,
                    {
                        "#X#": size.width,
                        "#Y#": size.height,
                        "#Z#": size.depth,
                        "#MATERIAL_THICKNESS#": color?.DEPTH,
                        "#HORIZONT#": obj.PROPS.CONFIG.NOBOTTOM ? 0 :
                            obj.PROPS.CONFIG.BASKET.HORIZONT || obj.PROPS.CONFIG.BASKET.HORIZONT === 0 ? obj.PROPS.CONFIG.BASKET.HORIZONT :
                                obj.PROPS.EXPRESSIONS["#HORIZONT#"] || 78, //78 - стандартная высота цоколя на случай отсутствия данных
                    }
                )
            );

            if (product.element_type == "element_room") {
                conf.material = self.materialWall;
                conf.parent = obj;
            } else {
                conf.color = color;
                conf.moduleColor = moduleColor;
                conf.parent = obj;
            }

            let leftColor = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.LEFTSIDECOLOR?.COLOR]
                ? self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.LEFTSIDECOLOR.COLOR]
                : false;

            let rightColor = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.RIGHTSIDECOLOR?.COLOR]
                ? self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.RIGHTSIDECOLOR.COLOR]
                : false;

            const backColor = obj.PROPS.CONFIG.BASKET.BACKWALL ? self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.BACKWALL.COLOR] || self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.BACKWALL]
                : false;
            const topFasadeColor = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"]?.COLOR]
                ? self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"].COLOR]
                : false;

            const metalTsargaColor = obj.PROPS.CONFIG["TSARGA"] === 'metal' ? self.scope.app.COLOR['79065'] : false;
            /* back = все боковые стороны шкафа */
            //!!!

            //Удаление задней стенки
            if (obj.PROPS.CONFIG.BASKET.BACKWALL?.COLOR === false || obj.PROPS.CONFIG.BASKET.BACKWALL === false) {
                conf.items = conf.items.filter(item => item.id !== 'back')
            }

            //Удаление горизонта
            if (obj.PROPS.CONFIG.NOBOTTOM === true) {
                conf.items = conf.items.filter(item => item.id !== 'bottom')
            }

            //Удаление крышки шкафа
            if (obj.PROPS.CONFIG.NOTOP === true) {
                conf.items = conf.items.filter(item => item.id !== 'top')
            }

            //Удаление левой стенки шкафа
            if (obj.PROPS.CONFIG.NOLEFT === true) {
                conf.items = conf.items.filter(item => item.id !== 'leftbox')
            }

            //Удаление правой стенки шкафа
            if (obj.PROPS.CONFIG.NORIGHT === true) {
                conf.items = conf.items.filter(item => item.id !== "rightbox")
            }

            //Удаление цоколя
            if (obj.PROPS.CONFIG.BASKET.HORIZONT === 0) {
                conf.items = conf.items.filter(item => item.id !== 'plinth')
            }

            //Накладка на крышку модуля
            if (obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"]) {
                let fasadeThickness = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET[`FASADE1`]?.[0] ||
                obj.PROPS.CONFIG.BASKET.DOORS?.[1]?.[1]?.[0] ||
                obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"].COLOR]?.DEPTH || 18

                let topFasade_width = obj.PROPS.CONFIG.SIZE.width;
                let topFasade_depth = obj.PROPS.CONFIG.SIZE.depth + fasadeThickness// + 2 //2мм отступ фасада от модуля;
                let topFasade_thickness = topFasadeColor.DEPTH;

                obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"].width = topFasade_width
                obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"].depth = topFasade_depth
                obj.PROPS.CONFIG.BASKET["TOPFASADECOLOR"].thickness = topFasade_thickness

                conf.items.push({
                    id: 'top_fasade',
                    "type": "object",
                    "geometry": {
                        "type": "BoxGeometry",
                        "opt": {
                            "x": topFasade_width,
                            "y": topFasade_thickness,
                            "z": topFasade_depth
                        }
                    },
                    "rotation": {"x": 0, "y": 0, "z": 0},
                    "position": {
                        "x": 0,
                        "y": obj.PROPS.CONFIG.SIZE.height / 2 + topFasadeColor.DEPTH / 2,
                        "z": topFasadeColor.DEPTH / 2
                    }
                })
            }

            //Царга
            if (obj.PROPS.CONFIG["TSARGA"]) {
                let fasadeThickness = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR].DEPTH || 18

                if (obj.PROPS.CONFIG["TSARGA"] === 'metal') {
                    conf.items.push({
                        "id": "horizontallineback",
                        "type": "object",
                        "geometry": {
                            "type": "BoxGeometry",
                            "opt": {"x": obj.PROPS.CONFIG.SIZE.width - fasadeThickness * 2, "y": 15, "z": 15}
                        },
                        "rotation": {"x": 0, "y": 0, "z": 0},
                        "position": {
                            "x": 0,
                            "y": obj.PROPS.CONFIG.SIZE.height / 2 - 15 / 2,
                            "z": -obj.PROPS.CONFIG.SIZE.depth / 2 + 15 / 2
                        }
                    }, {
                        "id": "horizontallinefront",
                        "type": "link",
                        "link": "horizontallineback",
                        "rotation": {"x": 0, "y": 0, "z": 0},
                        "position": {
                            "x": 0,
                            "y": obj.PROPS.CONFIG.SIZE.height / 2 - 15 / 2,
                            "z": obj.PROPS.CONFIG.SIZE.depth / 2 - 15 / 2
                        }
                    })
                } else {
                    conf.items.push({
                        "id": "horizontallineback",
                        "type": "object",
                        "geometry": {
                            "type": "BoxGeometry",
                            "opt": {
                                "x": obj.PROPS.CONFIG.SIZE.width - fasadeThickness * 2,
                                "y": 30,
                                "z": fasadeThickness
                            }
                        },
                        "rotation": {"x": 0, "y": 0, "z": 0},
                        "position": {
                            "x": 0,
                            "y": obj.PROPS.CONFIG.SIZE.height / 2 - 15,
                            "z": -obj.PROPS.CONFIG.SIZE.depth / 2 + fasadeThickness / 2
                        }
                    }, {
                        "id": "horizontallinefront",
                        "type": "link",
                        "link": "horizontallineback",
                        "rotation": {"x": 0, "y": 0, "z": 0},
                        "position": {
                            "x": 0,
                            "y": obj.PROPS.CONFIG.SIZE.height / 2 - 15,
                            "z": obj.PROPS.CONFIG.SIZE.depth / 2 - fasadeThickness / 2
                        }
                    })
                }
            }

            back = self.createModelFromJson(conf, false, false, true, leftColor, rightColor, backColor, topFasadeColor, metalTsargaColor);

            //Фрезеровка боков отключена, т.к. не доделана
            if (obj.PROPS.CONFIG.BASKET.LEFTSIDECOLOR?.MILLING) {
                let millingItem = self.scope.app.MILLING[obj.PROPS.CONFIG.BASKET.LEFTSIDECOLOR.MILLING];
                let sideObj = back.children.find(item => item.NAME === "leftbox")
                let fasadeThickness = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.LEFTSIDECOLOR.COLOR].DEPTH || 18
                self.millingOnObject(
                    group,
                    sideObj,
                    {
                        size: {
                            width: obj.PROPS.CONFIG.SIZE.depth,
                            height: obj.PROPS.CONFIG.SIZE.height,
                            depth: fasadeThickness
                        },
                        rotation: new THREE.Vector3(0, -90 * self.scope.app.constants.deg_to_rad_coefficient, 0),
                    },
                    millingItem
                );
            }

            if (obj.PROPS.CONFIG.BASKET.RIGHTSIDECOLOR?.MILLING) {
                let millingItem = self.scope.app.MILLING[obj.PROPS.CONFIG.BASKET.RIGHTSIDECOLOR.MILLING];
                let sideObj = back.children.find(item => item.NAME === "rightbox")
                let fasadeThickness = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.RIGHTSIDECOLOR.COLOR].DEPTH || 18
                self.millingOnObject(
                    group,
                    sideObj,
                    {
                        size: {
                            width: obj.PROPS.CONFIG.SIZE.depth,
                            height: obj.PROPS.CONFIG.SIZE.height,
                            depth: fasadeThickness
                        },
                        rotation: new THREE.Vector3(0, 90 * self.scope.app.constants.deg_to_rad_coefficient, 0),
                    },
                    millingItem
                );
            }

            if (
                product.texture_map == "back_rectification" &&
                color?.back_color &&
                self.scope.app.FASADE[color.back_color] != undefined
                && !obj.PROPS.CONFIG.BASKET.BACKWALL
                && obj.PROPS.CONFIG.BASKET.BACKWALL !== false
            ) {
                var back_materiall = {
                    map: self.loadFileCache(self.scope.app.FASADE[color.back_color].TEXTURE, "img"),
                };
                if (back.ELEMENTS.back && back.ELEMENTS.back.material) {
                    back.ELEMENTS.back.material = new THREE.MeshPhongMaterial(back_materiall);
                }
            }

            group.add(back);
        } else if (dae) {
            back = self.loadFileCache(
                dae,
                model.model_type ? model.model_type : "dae",
                function (data) {
                    var mod = model.model_type == "FBX" ? data : data.scene.clone();

                    mod = self.normalizeUploadedModel(mod, model)

                    mod.traverse(function (child) {
                        if (child instanceof THREE.Mesh) {
                            if (model.material)
                                child.material = new THREE[model.material]({
                                    color: "#" + model.color,
                                    shininess: model.shininess,
                                    specular: "#ffffff",
                                    emissive: "#000000",
                                    renderDepth: 200,
                                });

                            child.receiveShadow = true;
                            child.castShadow = true;

                            if (self.scope.outlineType) {
                                self.createEdge(child);
                                if (
                                    child.material instanceof THREE.MultiMaterial ||
                                    Array.isArray(child.material)
                                ) {
                                    angular.forEach(child.material.materials, function (i) {
                                        i.color.set("#ffffff");
                                        i.transparent = true;
                                        i.opacity = 0.5;
                                    });
                                } else {
                                    child.material.color.set("#ffffff");
                                    child.material.transparent = true;
                                    child.material.opacity = 0.5;
                                }
                            }
                        }
                    });

                    group.add(mod);
                }
            );
        }

        group.position.set(eval(model.corr_x), eval(model.corr_y), eval(model.corr_z));

        /*Столешница*/
        if (obj.PROPS.CONFIG.HAVETABLETOP) {
            if (json && json.tables) {
                var tabletop = self.createTableTop(obj, json.tables);
            } else {
                var tabletop = self.createTableTop(obj);
            }

            tabletop.position.setY(start_position.y + size.height + 38 / 2);
            tabletop.position.setZ(start_position.z + 300);

            obj.PROPS.TABLETOP = tabletop;
            obj.add(tabletop);
        }
        /*Столешница*/

        /*Цокольная планка*/
        if (product.leg_length) {
            self.buildPlinth(obj);
        }
        /*Цокольная планка*/

        /*добавление петель */
        if (!obj.PROPS.LOOPS)
            obj.PROPS.LOOPS = {}

        if (self.scope.app.MODELS[product.models[0]].loop_model) {
            angular.forEach(obj.PROPS.CONFIG.FASADELIST, function (section, k) {
                if (obj.PROPS.LOOPS[k]) {
                    group.remove(obj.PROPS.LOOPS[k])
                }
                const loops = self.createLoop(product, obj, group, k)
                group.add(loops)
                obj.PROPS.LOOPS[k] = loops
            })
        }
        //Старый код
        /* if (self.scope.app.MODELS[product.models[0]].loop_model) {
      const rightSideLoop = true;

        const loops = self.creat3eLoop(product, obj, group,false, 1)
        group.add(loops) //  1 =номер секции, исправить позже
        obj.PROPS.LOOPS[1] = loops
        if (obj.PROPS.CONFIG.BASKET.FASADE2) {

        const loops = self.crea3teLoop(product, obj, group, rightSideLoop, 2)
        group.add(loops);
        obj.PROPS.LOOPS[2] = loops

      }
    } */
        /*добавление петель*/

        /*Добавление полок стандарт*/
        if (self.scope.app.PRODUCT_SHELF_POSITION[product.ID] != undefined) {
            if (self.scope.app.PRODUCT_SHELF_POSITION[product.ID]["Y"] != undefined) {
                self.scope.app.PRODUCT_SHELF_POSITION[product.ID]["Y"].forEach(function (i) {
                    // поправка глубины полки на глубину модели
                    let depthConf = size.depth;
                    angular.forEach(obj.PROPS.CONFIG.FASADELIST, function (val, n) {
                        const fasadePosition = self.scope.app.FASADE_POSITION[val];
                        const jsArr = self.scope.app.MODELS[fasadePosition.FASADE_MODEL];

                        if (jsArr) {
                            const modelDepth = jsArr.json.items.front.position.z;
                            depthConf = size.depth - modelDepth * 2;
                        }
                    });
                    // поправка глубины полки на глубину модели

                    // поправка ширины полки
                    let widthConf = size.width;
                    if (self.scope.app.PRODUCT_SHELF_POSITION[product.ID].WIDTH_CORRECTION) {
                        const widthCorrection =
                            self.scope.app.PRODUCT_SHELF_POSITION[product.ID].WIDTH_CORRECTION;
                        widthConf = widthConf + widthCorrection;
                    }
                    // поправка ширины полки

                    var horizont = new THREE.Mesh(
                        new THREE.BoxBufferGeometry(widthConf - (color.DEPTH * 2), color.DEPTH, depthConf),
                        group.MATERIALL
                    );
                    horizont.receiveShadow = true;
                    horizont.position.y =
                        start_position.y + eval(self.expressionsReplace(i, {"#Y#": size.height}));
                    group.add(horizont);

                    if (self.scope.outlineType) self.createEdge(horizont);
                });
            }
            /*Добавление полок стандарт*/

            /*Добавление перегородок стандарт*/
            if (self.scope.app.PRODUCT_SHELF_POSITION[product.ID]["X"] != undefined) {
                self.scope.app.PRODUCT_SHELF_POSITION[product.ID]["X"].forEach(function (i) {
                    var vertical = new THREE.Mesh(
                        new THREE.BoxBufferGeometry(color.DEPTH, size.height - (color.DEPTH * 2), size.depth),
                        group.MATERIALL
                    );
                    vertical.receiveShadow = true;

                    vertical.position.x =
                        start_position.x + eval(self.expressionsReplace(i, {"#X#": size.width}));
                    group.add(vertical);

                    if (self.scope.outlineType) self.createEdge(vertical);
                });
            }
        }
        /*Добавление полок стандарт*/

        /*СЕКЦИИ*/
        if (obj.PROPS.CONFIG.BASKET["FILLING"]) {
            let filling = obj.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][obj.PROPS.CONFIG.BASKET["FILLING"]];

            const materialWidth = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18;

            let sectBeforeSize = 0;

            if (filling)
                for (let i = 1; i <= filling.VSECTION; i++) {
                    if (obj.PROPS.CONFIG.BASKET["SECTIONS" + i]) {
                        const sectionSize = self.getSectionSize(obj, i);
                        const sectionPosition = self.getStartPosition(size);

                        sectionPosition.x +=
                            sectBeforeSize + (materialWidth + sectionSize.width) - sectionSize.width / 2;

                        sectBeforeSize += sectionSize.width + materialWidth;

                        // зачем-то было + 10мм от плинтуса?
                        // sectionPosition.y = ((sectionSize.height - size.height) / 2) + filling.HEIGHT_PLINTH+10;
                        let PLINTH_HEIGHT = (obj.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || obj.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? obj.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
                            (!obj.PROPS.CONFIG.BASKET.HORIZONT && obj.PROPS.CONFIG.BASKET.HORIZONT !== 0) && filling.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : materialWidth || 0;
                        sectionPosition.y =
                            (sectionSize.height - size.height) / 2 + ((obj.PROPS.CONFIG.BASKET.HORIZONT || obj.PROPS.CONFIG.BASKET.HORIZONT === 0) ? PLINTH_HEIGHT + obj.PROPS.CONFIG.BASKET.HORIZONT : PLINTH_HEIGHT);

                        let verticalSection = new THREE.Mesh(
                            new THREE.PlaneBufferGeometry(sectionSize.width, sectionSize.height),
                            new THREE.MeshLambertMaterial({
                                transparent: !0,
                                color: "#07d400",
                                opacity: 0.25,
                                visible: false,
                            })
                        );

                        verticalSection.receiveShadow = true;
                        verticalSection.SECTIONNUMBER = i;
                        verticalSection.name = "SECTIONNUMBER" + i;
                        verticalSection.position.z = size.depth / 2 + eval(filling.VSECTION_DEPTH) / 2;
                        verticalSection.position.y = sectionPosition.y;
                        verticalSection.position.x = sectionPosition.x;
                        obj.PROPS.SECTIONCONTROL.push(verticalSection);
                        group.add(verticalSection);
                        /* Вертикальная перегородка */
                        if (!obj.PROPS.PRODUCT.moduleType && i !== filling.VSECTION) {
                            var verticalPartition = new THREE.Mesh(
                                new THREE.BoxBufferGeometry(
                                    materialWidth,
                                    sectionSize.height,
                                    size.depth + eval(filling.VSECTION_DEPTH)
                                ),
                                group.MATERIALL
                            );
                            verticalPartition.receiveShadow = true;
                            verticalPartition.position.x =
                                sectionPosition.x + sectionSize.width / 2 + materialWidth / 2;
                            verticalPartition.position.y = sectionPosition.y;
                            group.add(verticalPartition);

                            if (self.scope.outlineType)
                                self.createEdge(verticalPartition);
                        }
                        /* Вертикальная перегородка */

                        /* Добавление полок */
                        if (
                            obj.PROPS.CONFIG.SECTIONS[i] &&
                            obj.PROPS.CONFIG.SECTIONS[i].SHELFCOUNT !== undefined
                        ) {
                            for (let s = 1; obj.PROPS.CONFIG.SECTIONS[i].SHELFCOUNT >= s; s++) {
                                let PLINTH_HEIGHT = (obj.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || obj.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? obj.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
                                    (!obj.PROPS.CONFIG.BASKET.HORIZONT && obj.PROPS.CONFIG.BASKET.HORIZONT !== 0) && filling.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : materialWidth || 0;
                                var shelf_position =
                                    obj.PROPS.CONFIG.SECTIONS[i].SHELFPOSITION[s] +
                                    ((obj.PROPS.CONFIG.BASKET.HORIZONT || obj.PROPS.CONFIG.BASKET.HORIZONT === 0) ? PLINTH_HEIGHT + obj.PROPS.CONFIG.BASKET.HORIZONT : PLINTH_HEIGHT) +
                                    materialWidth / 2;
                                /* Новая функция цвет полок */
                                const shelfColor = self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR]
                                    ? self.scope.app.FASADE[obj.PROPS.CONFIG.BASKET.MODULECOLOR]
                                    : false;
                                const shelfMaterial = self.getMaterials(shelfColor, fasade, obj);
                                var horizont = new THREE.Mesh(
                                    new THREE.BoxBufferGeometry(size.depth, materialWidth, sectionSize.width),
                                    shelfMaterial ? shelfMaterial : group.MATERIALL
                                );
                                horizont.receiveShadow = true;
                                horizont.name = "SHELF_" + i + "_" + s;
                                horizont.position.y = start_position.y + shelf_position;
                                horizont.position.x = sectionPosition.x;
                                horizont.rotation.y = Math.PI / 2;
                                horizont.TYPE = "SHELF";
                                horizont.ELEMENTNUMBER = s;
                                horizont.KEY = s;
                                horizont.SECTION = i;
                                horizont.SIZE = {
                                    width: sectionSize.width,
                                    height: materialWidth,
                                    depth: size.depth,
                                };
                                var horizontliner = self.createArrowSize({
                                    width: sectionSize.width,
                                    text: "Полка " + s
                                });
                                horizontliner.rotation.y = Math.PI / 2;
                                horizontliner.position.y += 65;
                                horizont.add(horizontliner);

                                obj.PROPS.SECTIONSOBJ.push(horizont);

                                group.add(horizont);

                                if (self.scope.outlineType) self.createEdge(horizont);
                            }
                        }
                        /* Добавление полок */

                        // добавление ящиков в секцию
                        if (obj.PROPS.CONFIG.SECTIONS[i] && obj.PROPS.CONFIG.SECTIONS[i].SUBELEMENTS) {

                            angular.forEach(
                                obj.PROPS.CONFIG.SECTIONS[i].SUBELEMENTS,
                                function (subel, subelKey) {
                                    subel.ADDITIVES = {}
                                }
                            );

                            angular.forEach(
                                obj.PROPS.CONFIG.SECTIONS[i].SUBELEMENTS,
                                function (subel, subelKey) {
                                    const productInfo = self.getProductInfo(subel.ID)

                                    if (!productInfo) {
                                        self.alert(`Отключен товар ID: ${subel.ID}! Элемент не добавлен в модуль!`)
                                        return
                                    }

                                    var addSubElement = self.addSubElementToElement(
                                        obj,
                                        productInfo,
                                        i,
                                        subelKey,
                                        subel
                                    );

                                    var positionValue = self.getSectionMousePositionFromInput(
                                        obj,
                                        new THREE.Vector3(subel.position.x, subel.position.y, subel.position.z),
                                        addSubElement.PROPS.FRAME
                                    );
                                    self.setSectionElementPosition(
                                        obj,
                                        addSubElement.PROPS.FRAME,
                                        positionValue,
                                        obj.PROPS.SECTIONCONTROL[i - 1],
                                        subelKey
                                    );

                                    if (self.scope.app.newSubelemPos[subel.objId]) {
                                        self.scope.app.newSubelemPos[addSubElement.PROPS.FRAME.id] = self.scope.app.newSubelemPos[subel.objId]
                                        delete self.scope.app.newSubelemPos[subel.objId]
                                    }
                                }
                            );
                        }
                    }
                }
        }
        /*СЕКЦИИ*/

        /*Добавление полок нестандарт*/
        if (product.SHELFQUANT > 0) {
            obj.PROPS.CONFIG.BASKET["SHELFQUANT"] = obj.PROPS.CONFIG.SHELFQUANT;
            for (let i = 1; obj.PROPS.CONFIG.SHELFQUANT >= i; i++) {
                var horizont = new THREE.Mesh(
                    new THREE.BoxBufferGeometry(size.width - 32, 16, size.depth),
                    group.MATERIALL
                );
                horizont.receiveShadow = true;
                horizont.position.y =
                    start_position.y + (size.height / (obj.PROPS.CONFIG.SHELFQUANT + 1)) * i;
                group.add(horizont);
                if (self.scope.outlineType) self.createEdge(horizont);
            }
        }
        /*Добавление полок нестандарт*/

        /*Добавление допМоделей*/
        angular.forEach(product.other_models, function (mod) {
            if (mod) {
                let model = self.scope.app.MODELS[mod];
                var model_conf = self.expressionsReplace(model, obj.PROPS.EXPRESSIONS);
                let loaded_model = self.loadFileCache(
                    model.file,
                    model.model_type,
                    function (_data) {
                        var data = model.model_type == "FBX" ? _data : _data.scene.clone();

                        let data_box = new THREE.Box3().setFromObject(data);
                        var data_size = data_box.getSize();

                        data.traverse(function (child) {
                            if (child instanceof THREE.Mesh) {
                                if (model.material)
                                    child.material = new THREE[model.material]({
                                        color: "#" + model.color,
                                        shininess: model.shininess,
                                        specular: "#ffffff",
                                        emissive: "#000000",
                                    });

                                child.receiveShadow = true;
                                child.castShadow = true;

                                if (self.scope.outlineType) {
                                    self.createEdge(child);
                                    if (
                                        child.material instanceof THREE.MultiMaterial ||
                                        Array.isArray(child.material)
                                    ) {
                                        angular.forEach(child.material.materials, function (i) {
                                            i.color.set("#ffffff");
                                            i.transparent = true;
                                            i.opacity = 1;
                                        });
                                    } else {
                                        child.material.color.set("#ffffff");
                                        child.material.transparent = true;
                                        child.material.opacity = 1;
                                    }
                                }
                            }
                        });

                        if (model_conf.width) {
                            data.scale.x = model_conf.width / data_size.x;
                        }
                        if (model_conf.height) {
                            data.scale.y = model_conf.height / data_size.y;
                        }
                        if (model_conf.depth) {
                            data.scale.z = model_conf.depth / data_size.z;
                        }

                        if (model_conf.corr_x) {
                            data.position.x = eval(model_conf.corr_x);
                        }
                        if (model_conf.corr_y) {
                            data.position.y = eval(model_conf.corr_y);
                        }
                        if (model_conf.corr_z) {
                            data.position.z = eval(model_conf.corr_z);
                        }

                        group.add(data);
                    }
                );
            }
        });

        if (obj.PROPS.CONFIG.EXTRAMODELS) {
            angular.forEach(obj.PROPS.CONFIG.EXTRAMODELS, function (elements, type) {
                angular.forEach(elements, function (element, key) {

                    const PRODUCT = element.PROPS.PRODUCT
                    const CONFIG = element.PROPS.CONFIG
                    const BASKET = CONFIG.BASKET

                    PRODUCT.MIN_FASADE_SIZE = +PRODUCT.MIN_FASADE_SIZE

                    var basketObj = BASKET;

                    var configObj = {
                        SIZE: CONFIG.SIZE,
                        doNotAddGroupToProject: true
                    };

                    var extraObj = self.createGroup(PRODUCT, false, configObj, basketObj, group)
                    let frame = Object.assign({}, extraObj.PROPS.FRAME)
                    frame.ELID = PRODUCT.ID;
                    frame.TYPE = type;

                    extraObj.position.copy(CONFIG.POSITION)

                    if (CONFIG.SCALE)
                        extraObj.scale.copy(CONFIG.SCALE)

                    element.mesh = extraObj.id
                    group.add(extraObj)
                })
            });
        }
        /*Добавление допМоделей*/

        /*Добавление обёртки*/
        self.createWrap(obj);
        /*Добавление обёртки*/

        /*Добавление ножек*/
        self.buildLegs(obj);
        /*Добавление ножек*/

        /*Создание размеров*/
        const modelType = self.scope.app.MODELS[product.models[0]].model_type;

        if (obj.PROPS.PRODUCT.element_type !== "element_inner" &&
            !obj.PROPS.PRODUCT.NAME.toLowerCase().includes("полка") &&
            (modelType !== 'GLTF' && modelType !== 'DAE' && modelType !== 'FBX') &&
            !obj.PROPS.CONFIG.isProfile && !obj.PROPS.CONFIG.doNotAddGroupToProject) { // для наполнения выключена линейка
            const correctionDef = 150;
            var liner = self.createArrowSize({
                width: size.width, text: size.width,
                lines: 190
            });
            liner.name += "1"
            var liner2 = self.createArrowSize({
                width: size.height,
                text: size.height,
                lines: 80
            });
            liner2.name += "2"
            var tabletop = obj.PROPS.CONFIG.HAVETABLETOP;
            liner.position.setZ(-size.depth / 2 + 10);
            liner2.position.setZ(-size.depth / 2 + 10);
            liner2.rotation.z = Math.PI / 2;
            liner2.position.setX(-size.width / 2 - 80);

            if (tabletop) {
                liner.position.setY(size.height / 2 + 80 + correctionDef);

            } else {
                if (product.NAME.indexOf('Столешница') >= 0) { // корректировка для столешниц
                    liner.position.setY(size.height / 2 + 240);
                } else {
                    liner.position.setY(size.height / 2 + 40 + correctionDef);
                }
            }

            obj.PROPS.LINER = liner;
            obj.add(liner);

            if (!product.NAME !== "панель декоративная" || product.NAME.indexOf('Столешница') >= 0) {
                obj.PROPS.LINER2 = liner2;
                obj.add(liner2);
            }
        }
        /*Создание размеров*/

        /*Добавление фасадов*/

        //Если пришел старый формат данных из сохраненных проектов
        if (obj.PROPS.CONFIG.BASKET["FASADE1"] && typeof obj.PROPS.CONFIG.BASKET["FASADE1"] !== 'object') {

            let FASADELIST = self.$filter("filterFasadePosition")(
                obj.PROPS.PRODUCT.FASADE_POSITION,
                obj.PROPS.CONFIG, [5168676, 5178415].includes(obj.PROPS.PRODUCT.ID) < 0
            );


            let i = 1;
            while (obj.PROPS.CONFIG.BASKET["FASADE" + i]) {
                obj.PROPS.CONFIG.FASADELIST[i] = FASADELIST[i - 1]

                if (typeof obj.PROPS.CONFIG.BASKET["FASADE" + i] !== 'object')
                    obj.PROPS.CONFIG.BASKET["FASADE" + i] = {0: obj.PROPS.CONFIG.BASKET["FASADE" + i]}

                if (obj.PROPS.CONFIG.BASKET["PALETTE" + i] && typeof obj.PROPS.CONFIG.BASKET["PALETTE" + i] !== 'object')
                    obj.PROPS.CONFIG.BASKET["PALETTE" + i] = {0: obj.PROPS.CONFIG.BASKET["PALETTE" + i]}

                if (obj.PROPS.CONFIG.BASKET["MILLING" + i] && typeof obj.PROPS.CONFIG.BASKET["MILLING" + i] !== 'object')
                    obj.PROPS.CONFIG.BASKET["MILLING" + i] = {0: obj.PROPS.CONFIG.BASKET["MILLING" + i]}

                if (obj.PROPS.CONFIG.BASKET["SHOWCASE" + i] && typeof obj.PROPS.CONFIG.BASKET["SHOWCASE" + i] !== 'object')
                    obj.PROPS.CONFIG.BASKET["SHOWCASE" + i] = {0: obj.PROPS.CONFIG.BASKET["SHOWCASE" + i]}

                if (obj.PROPS.CONFIG.BASKET["GLASS" + i] && typeof obj.PROPS.CONFIG.BASKET["GLASS" + i] !== 'object')
                    obj.PROPS.CONFIG.BASKET["GLASS" + i] = {0: obj.PROPS.CONFIG.BASKET["GLASS" + i]}

                i++;
            }
        }

        angular.forEach(obj.PROPS.CONFIG.FASADELIST, function (val, key) {
            const fasadeSegments = obj.PROPS.CONFIG.BASKET.DOORS?.[key] || obj.PROPS.CONFIG.BASKET['FASADE' + key]

            const calcFasade = (fasade, doorId) => {
                var fasadePosition = self.getFasadePosition(obj, key, doorId)

                if (doorId) {
                    if (obj.PROPS.CONFIG.recalcFasadeHeight !== true && (!obj.PROPS.CONFIG.BASKET["FASADESIZES" + key] || obj.PROPS.CONFIG.BASKET["FASADESIZES" + key][doorId].length === 1)) {
                        obj.PROPS.CONFIG.BASKET['FASADESIZES' + key][doorId] = [fasadePosition.FASADE_HEIGHT]

                        if (!obj.PROPS.CONFIG.BASKET['FASADEWIDTH' + key][doorId] && obj.PROPS.PRODUCT.moduleType)
                            obj.PROPS.CONFIG.BASKET['FASADEWIDTH' + key][doorId] = self.calcFasadeWidth(fasade, key, obj)

                        const fasadePositionNumber = self.calcFasadePositions([fasadePosition.FASADE_HEIGHT], obj.PROPS.CONFIG, fasadePosition)

                        if (!obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
                            obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}

                        if (!obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[key])
                            obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[key] = {}

                        obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[key][doorId] = fasadePositionNumber
                    }

                    if (typeof fasade === 'object' ||
                        (obj.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE && Object.keys(obj.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE).length)) {
                        obj.PROPS.FASADE[key] = self.createCompositeFasade(obj, key, doorId)
                        obj.add(obj.PROPS.FASADE[key]);

                    } else {
                        //!!!Исправить на цикл

                        var fasadeID = fasade[0] || obj.PROPS.CONFIG.BASKET.DOORS[key][doorId];

                        obj.PROPS.FASADE[key] = self.createFasade(
                            fasadePosition,
                            start_position,
                            fasadeID,
                            obj,
                            key,
                            false,
                            doorId
                        );
                        obj.add(obj.PROPS.FASADE[key]);
                    }
                } else {
                    if (obj.PROPS.CONFIG.recalcFasadeHeight !== true && (!obj.PROPS.CONFIG.BASKET["FASADESIZES" + key] || obj.PROPS.CONFIG.BASKET["FASADESIZES" + key].length === 1)) {
                        obj.PROPS.CONFIG.BASKET['FASADESIZES' + key] = [fasadePosition.FASADE_HEIGHT]

                        if (!obj.PROPS.CONFIG.BASKET['FASADEWIDTH' + key] && obj.PROPS.PRODUCT.moduleType)
                            obj.PROPS.CONFIG.BASKET['FASADEWIDTH' + key] = self.calcFasadeWidth(fasade, key, obj)

                        const fasadePositionNumber = self.calcFasadePositions([fasadePosition.FASADE_HEIGHT], obj.PROPS.CONFIG, fasadePosition)

                        if (!obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
                            obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}

                        obj.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[key] = fasadePositionNumber
                    }

                    if (typeof fasade === 'object' ||
                        (obj.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE && Object.keys(obj.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE).length)) {
                        obj.PROPS.FASADE[key] = self.createCompositeFasade(obj, key)
                        obj.add(obj.PROPS.FASADE[key]);

                    } else {
                        //!!!Исправить на цикл

                        var fasadeID = fasade[0] || obj.PROPS.CONFIG.BASKET["FASADE" + key];

                        obj.PROPS.FASADE[key] = self.createFasade(
                            fasadePosition,
                            start_position,
                            fasadeID,
                            obj,
                            key,
                        );
                        obj.add(obj.PROPS.FASADE[key]);
                    }
                }
            }

            if (typeof fasadeSegments[1] === "object") {
                angular.forEach(fasadeSegments, function (fasade, _key) {
                    calcFasade(fasade, _key)
                })
            } else {
                calcFasade(fasadeSegments)
            }
        });
        /*Добавление фасадов*/

        group["POS_CORRECTION"] = obj.PROPS.CONFIG["POS_CORRECTION"] = new THREE.Vector3(eval(model.corr_x) || 0,
            eval(model.corr_y) || 0,
            eval(model.corr_z) || 0)

        group.unionBoudingBox = self.calculateUnionBoundingBox(group)

        group.name = "mainModel"
        return group;
    };

    this.changeModelScale = function (model, scale_vector = new THREE.Vector3(1, 1, 1)) {
        const scaleVector = new THREE.Vector3()
        const box = model.unionBoundingBox

        scaleVector.subVectors(box.max, box.min)

        scaleVector.x = scale_vector.x / Math.abs(scaleVector.x)
        scaleVector.y = scale_vector.y / Math.abs(scaleVector.y)
        scaleVector.z = scale_vector.z / Math.abs(scaleVector.z)

        //Изменение размеров модели, для соответствия пришедшим параметрам
        const scaleGeometry = (mesh) => {

            if (mesh.geometry) {
                mesh.geometry.scale(scaleVector.x, scaleVector.y, scaleVector.z)
            }

            for (let child of mesh.children)
                scaleGeometry(child)
        }
        //

        scaleGeometry(model)

        model.unionBoundingBox = self.calculateUnionBoundingBox(model);
        model.updateMatrixWorld(true)
    }

    this.normalizeUploadedModel = function (model, params) {
        const center = new THREE.Vector3()
        const box = self.calculateUnionBoundingBox(model);
        box.getCenter(center)       //Получение координат центра BoundingBox

        const translateVector = new THREE.Vector3()

        //Центровка внутренней геометрии и поднятие по оси Y, чтоб minY = 0
        const calculateTranslateVector = () => {
            translateVector.x = center.x !== 0 ? -center.x : 0

            //translateVector.y = box.min.y !== 0 ? -box.min.y : 0  //центрирование низа модели по курсору
            translateVector.y = center.y !== 0 ? -center.y : 0

            translateVector.z = center.z !== 0 ? -center.z : 0
        }

        const translateGeometry = (mesh) => {

            if (mesh.geometry) {
                mesh.geometry.translate(translateVector.x, translateVector.y, translateVector.z);
                mesh.geometry.computeVertexNormals();
            }

            for (let child of mesh.children) {
                translateGeometry(child);
            }
        }

        calculateTranslateVector()
        translateGeometry(model);

        model.unionBoundingBox = self.calculateUnionBoundingBox(model);
        model.updateMatrixWorld(true)

        box.setFromObject(model);
        box.getCenter(center)       //Получение координат центра BoundingBox


        if (params.width || params.height || params.depth)
            self.changeModelScale(model, new THREE.Vector3(
                params.width || params.scale || 1,
                params.height || params.scale || 1,
                params.depth || params.scale || 1))
        else
            model.scale.x = model.scale.y = model.scale.z = params.scale;

        return model;
    }

    this.controlFillingSize = function (group, newSize, type, isGroupSection) {
        let CONFIG = group.PROPS.CONFIG;
        let filling = CONFIG.CUSTOMFILLING || self.scope.app.FILLING[CONFIG.BASKET["FILLING"]];
        let size = {};
        size[type] = newSize;
        if (newSize) size[type] = newSize;

        size = angular.merge({}, CONFIG.SIZE, size);

        if (filling?.VSECTION) {
            var elementWidth = size.width;
            var width = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18;
            var sectionWidth;
            var calcModuleWidth;
            var diffLasr;
            if (isGroupSection) {
                let VSECTION = isGroupSection.groups.length;
                sectionWidth = Math.floor(
                    (elementWidth - (filling.VSECTION + 1) * width) / filling.VSECTION
                );
                let sectionWidth2 = Math.floor(
                    (elementWidth - (VSECTION + 1) * width) / VSECTION
                );
                calcModuleWidth = +(sectionWidth2 * VSECTION) + width * (VSECTION + 1);
                diffLasr = elementWidth - calcModuleWidth;

                if (diffLasr) {
                    size.width = calcModuleWidth;
                    self.alert(
                        "Для данной комподовки допустимое значение ширины - " + size.width + "mm"
                    );
                }
            } else {
                sectionWidth = Math.floor(
                    (elementWidth - (filling.VSECTION + 1) * width) / filling.VSECTION
                );
                calcModuleWidth =
                    +(sectionWidth * filling.VSECTION) + width * (filling.VSECTION + 1);
                diffLasr = elementWidth - calcModuleWidth;

                if (diffLasr) {
                    size.width = calcModuleWidth;
                    self.alert(
                        "Для данной комподовки допустимое значение ширины - " + size.width + "mm"
                    );
                }
            }
        }

        return {
            size: size,
            sectionWidth: sectionWidth,
        };
    };

    this.calcSectionsWidth = function (group) {
        let CONFIG = group.PROPS.CONFIG;
        let isGroupSection = false;
        if (CONFIG.BASKET["FILLING"]) {
            var filling = CONFIG.CUSTOMFILLING || self.scope.app.FILLING[CONFIG.BASKET["FILLING"]];
            if (filling?.VSECTION) {
                if (filling.GROUP_SECTION) {
                    isGroupSection = filling.GROUP_SECTION;
                }
                let controlFillingSize = self.controlFillingSize(
                    group,
                    false,
                    false,
                    isGroupSection
                );

                if (controlFillingSize.size.width != CONFIG.SIZE.width) {
                    self.scope.app.new_size.width = CONFIG.SIZE.width =
                        controlFillingSize.size.width;
                }

                self.setSectionsSize(group, controlFillingSize);
            }
        }
    };

    this.shiftSectionPartition = function (group) {
        const partitionThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18;

        let new_pos = 0
        angular.forEach(group.PROPS.CONFIG.SECTIONS, function (section, section_id) {
            if (section?.SUBELEMENTS)
                angular.forEach(section.SUBELEMENTS, function (item, key) {
                    if (item.TYPE == "PARTITION") {
                        new_pos += group.PROPS.CONFIG.BASKET['SECTIONS' + section_id] + partitionThickness / 2;
                        item.position.x = new_pos

                        new_pos += partitionThickness / 2
                    }
                })
        })
    }

    // установить размер секции
    this.setSectionsSize = function (group, controlFillingSize, numberToChangeSection) {
        const CONFIG = group.PROPS.CONFIG;
        const filling = CONFIG.CUSTOMFILLING || self.scope.app.FILLING[CONFIG.BASKET["FILLING"]];
        const materialWidth = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18;
        const add = (accumulator, a) => accumulator + a;

        if (filling) {
            if (numberToChangeSection) {
                const minWidth = filling.VSECTION_MIN;
                const maxWidth = filling.VSECTION_MAX;
                const sectionCount = filling.VSECTION;
                const groups = filling.GROUP_SECTION.groups;
                // ширина секций по умолчанию
                const sectSumWidth =
                    group.PROPS.CONFIG.SIZE.width - (groups.length + 1) * materialWidth;

                let inGroup = 0;
                groups.forEach((el, groupNumber) => {
                    el.forEach((sect) => {
                        if (sect === numberToChangeSection) {
                            inGroup = groupNumber;
                        }
                    });
                });

                // проверка если введенный размер не верный
                if (CONFIG.BASKET["SECTIONS" + numberToChangeSection] > maxWidth) {
                    CONFIG.BASKET["SECTIONS" + numberToChangeSection] = maxWidth;
                } else if (CONFIG.BASKET["SECTIONS" + numberToChangeSection] < minWidth) {
                    CONFIG.BASKET["SECTIONS" + numberToChangeSection] = minWidth;
                }

                let groupsWidth = [];
                angular.forEach(groups, (i, n) => {
                    if (group.PROPS.PRODUCT.moduleType && filling.VSECTION > 1) {
                        i.map(item => groupsWidth.push(CONFIG.BASKET["SECTIONS" + item]))
                    } else {
                        if (n !== groups.length - 1) {
                            groupsWidth.push(Math.floor(sectSumWidth / groups.length));
                        } else {
                            groupsWidth.push(sectSumWidth - groupsWidth.reduce(add, 0));
                        }
                    }
                });

                const newGroupsWidth = groupsWidth.slice();

                // новая сумма ширин секций
                let newSummWidth = 0;

                for (let i = 1; i <= sectionCount; i++) {
                    newSummWidth = CONFIG.BASKET["SECTIONS" + i] + newSummWidth;
                }

                // ширина секции
                const sectWidth = Math.floor(
                    groupsWidth[inGroup] / groups[inGroup].length -
                    (groups[inGroup].length - 1) * materialWidth
                );

                if (group.PROPS.PRODUCT.moduleType) {

                    if (sectSumWidth - groupsWidth.reduce(add, 0) !== 0) { //Условие на случай вызова изменения размера секции путём удаления секции
                        if (inGroup == groups.length - 1) {
                            // если изменяем последнюю секцию
                            let newVal = sectSumWidth - (groups[inGroup].length - 1) * materialWidth
                            groupsWidth.map((item, key) => {
                                if (key !== inGroup - 1)
                                    newVal -= item
                            })

                            // проверка правильного размера секции
                            if (newVal >= minWidth && newVal <= maxWidth) {
                                CONFIG.BASKET["SECTIONS" + (numberToChangeSection - 1)] = newVal;
                                self.shiftSectionPartition(group)
                            } else {
                                if (newVal > maxWidth) {
                                    CONFIG.BASKET["SECTIONS" + numberToChangeSection] = newVal;
                                    self.splitSection(group, numberToChangeSection)
                                } else {
                                    CONFIG.BASKET["SECTIONS" + (numberToChangeSection - 1)] -= Math.abs(newVal);
                                    CONFIG.BASKET["SECTIONS" + numberToChangeSection] = 0;
                                    let tmp_partition = group.getObjectByName("PARTITION_" + (numberToChangeSection - 1))
                                    self.deleteSubElementToElement(group, tmp_partition.SECTION, tmp_partition.KEY)
                                }
                            }
                        } else {
                            let newVal = sectSumWidth - (groups[inGroup].length - 1) * materialWidth
                            groupsWidth.map((item, key) => {
                                if (key !== inGroup + 1)
                                    newVal -= item
                            })

                            // проверка правильного размера секции
                            if (newVal >= minWidth && newVal <= maxWidth) {
                                CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)] = newVal;
                                self.shiftSectionPartition(group)
                            } else {
                                if (newVal > maxWidth) {
                                    self.splitSection(group, numberToChangeSection + 1)
                                } else {// если размер не верный
                                    CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)] =
                                        CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)];
                                    CONFIG.BASKET["SECTIONS" + numberToChangeSection] =
                                        (groupsWidth[inGroup] - (groups[inGroup].length - 1) * materialWidth) +
                                        (groupsWidth[inGroup + 1] - (groups[inGroup + 1].length - 1) * materialWidth) -
                                        CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)];

                                    self.shiftSectionPartition(group)
                                }
                            }
                        }
                    } else if (groupsWidth[groupsWidth.length - 1] > maxWidth) {
                        CONFIG.BASKET["SECTIONS" + groupsWidth.length] = groupsWidth[groupsWidth.length - 1];
                        self.splitSection(group, groupsWidth.length)
                    }
                } else {
                    if (groups[inGroup][groups[inGroup].length - 1] !== numberToChangeSection) {
                        const newVal =
                            groupsWidth[inGroup] -
                            CONFIG.BASKET["SECTIONS" + numberToChangeSection] -
                            (groups[inGroup].length - 1) * materialWidth;

                        // проверка правильного размера секции
                        if (newVal >= minWidth && newVal <= maxWidth) {
                            CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)] = newVal;
                        } else {
                            // если размер не верный
                            CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)] =
                                CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)];
                            CONFIG.BASKET["SECTIONS" + numberToChangeSection] =
                                groupsWidth[inGroup] -
                                CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)] -
                                (groups[inGroup].length - 1) * materialWidth;
                        }
                    } else {
                        // если изменяем последнюю секцию
                        const newVal =
                            groupsWidth[inGroup] -
                            CONFIG.BASKET["SECTIONS" + numberToChangeSection] -
                            (groups[inGroup].length - 1) * materialWidth;

                        // проверка правильного размера секции
                        if (newVal >= minWidth && newVal <= maxWidth) {
                            CONFIG.BASKET["SECTIONS" + (numberToChangeSection - 1)] = newVal;
                        } else {
                            // если размер не верный
                            CONFIG.BASKET["SECTIONS" + (numberToChangeSection - 1)] =
                                CONFIG.BASKET["SECTIONS" + (numberToChangeSection - 1)];
                            CONFIG.BASKET["SECTIONS" + numberToChangeSection] =
                                groupsWidth[inGroup] -
                                CONFIG.BASKET["SECTIONS" + (numberToChangeSection + 1)] -
                                (groups[inGroup].length - 1) * materialWidth;
                        }
                    }
                }

                self.changeShelfCount(group, numberToChangeSection, true);
            } else {
                let sectSumWidth,
                    groups,
                    groupsWidth = [],
                    newGroupsWidth;

                if (filling.GROUP_SECTION) {
                    // добавляем перегородку
                    groups = filling.GROUP_SECTION.groups;
                    sectSumWidth =
                        controlFillingSize.size.width - (groups.length + 1) * materialWidth;

                    angular.forEach(groups, (i, n) => {
                        if (group.PROPS.PRODUCT.moduleType && filling.VSECTION > 1) {
                            i.map(item => groupsWidth.push(CONFIG.BASKET["SECTIONS" + item]))
                        } else {
                            if (n !== groups.length - 1) {
                                groupsWidth.push(Math.floor(sectSumWidth / groups.length));
                            } else {
                                groupsWidth.push(sectSumWidth - groupsWidth.reduce(add, 0));
                            }
                        }
                    });

                    newGroupsWidth = groupsWidth.slice();
                }

                let i = 1;
                do {
                    if (i <= filling.VSECTION) {
                        if (filling.GROUP_SECTION) {
                            // добавляем перегородку
                            let inGroup = false;

                            groups.forEach((el, groupNumber) => {
                                el.forEach((sect) => {
                                    if (sect === i) {
                                        inGroup = groupNumber;
                                    }
                                });
                            });

                            if (i !== groups[inGroup][groups[inGroup].length - 1]) {
                                const sectWidth = Math.floor(
                                    groupsWidth[inGroup] / groups[inGroup].length -
                                    (groups[inGroup].length - 1) * materialWidth
                                );
                                CONFIG.BASKET["SECTIONS" + i] = sectWidth;
                                newGroupsWidth[inGroup] -= sectWidth;
                            } else {
                                CONFIG.BASKET["SECTIONS" + i] =
                                    newGroupsWidth[inGroup] - (groups[inGroup].length - 1) * materialWidth;
                            }
                        } else {
                            CONFIG.BASKET["SECTIONS" + i] = controlFillingSize.sectionWidth;
                        }
                    } else {
                        delete CONFIG.SECTIONS[i];
                        delete CONFIG.BASKET["SECTIONS" + i];
                    }
                    self.changeShelfCount(group, i, true);

                    i++;
                } while (CONFIG.SECTIONS[i] || CONFIG.BASKET["SECTIONS" + i] || i <= filling.VSECTION);
            }
        }
    };

    this.createGlass = function (glassConf, fasade, model) {
        if (glassConf.COLOR) {
            var material = {
                color: "#" + glassConf.COLOR,
                transparent: true,
                opacity: glassConf.TRANSPARENT,
                shininess: glassConf.SHININESS,
                specular: 0x999999,
            };
        } else {
            var texture = self.loadFileCache(glassConf.TEXTURE, "img");
            texture.wrapS = texture.wrapT = THREE.MirroredRepeatWrapping;
            texture.repeat.set(
                (fasade.FASADE_WIDTH - 10) / glassConf.TEXTURE_WIDTH,
                (fasade.FASADE_HEIGHT - 10) / glassConf.TEXTURE_HEIGHT
            );
            var material = {
                transparent: true,
                opacity: glassConf.TRANSPARENT,
                map: texture,
                shininess: glassConf.SHININESS,
            };
        }

        if (model) {
            if (model.items) {
                if (model.items.backbottomhorizontal) {
                    const geomWidth = Number(model.items.leftvertical.geometry.opt.x);

                    return new THREE.Mesh(
                        new THREE.BoxBufferGeometry(
                            fasade.FASADE_WIDTH - (2 + geomWidth * 2),
                            fasade.FASADE_HEIGHT - (2 + geomWidth * 2),
                            5
                        ),
                        new THREE.MeshPhongMaterial(material)
                    );
                } else if (model.glassSizeCorrection) {
                    return new THREE.Mesh(
                        new THREE.BoxBufferGeometry(
                            fasade.FASADE_WIDTH + model.glassSizeCorrection.x,
                            fasade.FASADE_HEIGHT + model.glassSizeCorrection.y,
                            5 + model.glassSizeCorrection.z
                        ),
                        new THREE.MeshPhongMaterial(material)
                    );
                }
            }
        }

        return new THREE.Mesh(
            new THREE.BoxBufferGeometry(fasade.FASADE_WIDTH - 10, fasade.FASADE_HEIGHT - 10, 5),
            new THREE.MeshPhongMaterial(material)
        );
    };

    this.createRoom = function () {
        self.scope.app.room = [];

        var posX = self.scope.project.room_config.width;
        var posY = self.scope.project.room_config.height;
        var posZ = self.scope.project.room_config.depth;
        var wall = self.scope.app.WALL[self.scope.project.wall];
        var floor = self.scope.app.FLOOR[self.scope.project.floor];

        if (self.scope.outlineType) {
            /*self.textureWall = self.loadFileCache(self.scope.TEMPLATE_PATH + "/image/grid.jpg", 'img');
      self.textureFloor = self.loadFileCache(self.scope.TEMPLATE_PATH + "/image/grid.jpg", 'img');*/
            self.textureWall = false;
            self.textureFloor = false;
        } else {
            self.textureWall = self.loadFileCache(wall.texture, "img");
            self.textureFloor = self.loadFileCache(floor.texture, "img");
        }

        /*Текстура стен*/
        self.materialWall = new THREE.MeshPhongMaterial({
            color: 0xffffff,
            map: self.textureWall,
            opacity: self.scope.outlineType ? 0 : 1,
            transparent: self.scope.outlineType ? true : false,
        });
        if (self.textureWall) {
            self.textureWall.wrapS = self.textureWall.wrapT = THREE.RepeatWrapping;
            self.textureWall.repeat.set(
                (self.scope.project.room_config.width / 1500) * wall.scale,
                (self.scope.project.room_config.height / 1500) * wall.scale
            );
        }

        /*Текстура пола*/
        self.materialFloor = new THREE.MeshPhongMaterial({
            color: 0xffffff,
            map: self.textureFloor,
            opacity: self.scope.outlineType ? 0 : 1,
            transparent: self.scope.outlineType ? true : false,
        });
        if (self.textureFloor) {
            self.textureFloor.wrapS = self.textureFloor.wrapT = THREE.RepeatWrapping;
            self.textureFloor.repeat.set(
                (self.scope.project.room_config.width / 1000) * floor.scale,
                (self.scope.project.room_config.depth / 1000) * floor.scale
            );
        }

        self.back = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(posX, posY, 1, 1),
            self.materialWall
        );
        self.back.position.set(0, 0, 0);
        self.back.receiveShadow = true;
        self.back.geometry.elementsNeedUpdate = true;

        self.forward = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(posX, posY, 1, 1),
            self.materialWall
        );
        self.forward.position.set(0, 0, posZ);
        self.forward.rotation.y = Math.PI;
        self.forward.receiveShadow = true;
        self.forward.geometry.elementsNeedUpdate = true;

        self.left = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(posZ, posY, 1, 1),
            self.materialWall
        );
        self.left.position.set(-posX / 2, 0, posZ / 2);
        self.left.rotation.y = Math.PI / 2;
        self.left.receiveShadow = true;
        self.left.geometry.elementsNeedUpdate = true;

        self.right = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(posZ, posY, 1, 1),
            self.materialWall
        );
        self.right.position.set(posX / 2, 0, posZ / 2);
        self.right.rotation.y = -Math.PI / 2;
        self.right.receiveShadow = true;
        self.right.geometry.elementsNeedUpdate = true;

        self.top = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(posX, posZ, 1, 1),
            new THREE.MeshPhongMaterial({color: 0xffffff})
        );
        self.top.position.set(0, posY / 2, posZ / 2);
        self.top.rotation.x = Math.PI / 2;
        self.top.receiveShadow = true;
        self.top.geometry.elementsNeedUpdate = true;

        self.bottom = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(posX, posZ, 1, 1),
            self.materialFloor
        );
        self.bottom.position.set(0, -posY / 2, posZ / 2);
        self.bottom.rotation.x = -Math.PI / 2;
        self.bottom.receiveShadow = true;
        self.bottom.geometry.elementsNeedUpdate = true;

        if (!self.scope.outlineType) {
            //self.createPlinth(posX, posY, posZ);
        }

        self.scene.add(self.back, self.left, self.right, self.forward, self.top, self.bottom);
        self.scope.app.room.push(
            self.back,
            self.left,
            self.right,
            self.top,
            self.bottom,
            self.forward
        );

        self.createGlobalLight();
        self.createRoomLine();
    };

    this.createRoomLine = function () {
        const correctionY = 300;

        self.scope.app.Lines.x = self.createArrowSize({
            width: self.scope.project.room_config.width,
            text: self.scope.project.room_config.width + "mm",
            correctionY
        });

        self.scope.app.Lines.y = self.createArrowSize({
            width: self.scope.project.room_config.height,
            text: self.scope.project.room_config.height + "mm"
        });
        self.scope.app.Lines.z = self.createArrowSize({
            width: self.scope.project.room_config.depth,
            text: self.scope.project.room_config.depth + "mm",
            correctionY
        });

        self.setRoomLinePosition();

        self.scene.add(
            self.scope.app.Lines.x,
            self.scope.app.Lines.y,
            self.scope.app.Lines.z
        );
    };

    this.changeRoomLine = function () {
        const correctionY = 300;

        self.scene.remove(
            self.scope.app.Lines.x,
            self.scope.app.Lines.y,
            self.scope.app.Lines.z
        );

        self.scope.app.Lines.x = self.createArrowSize({
            width: self.scope.project.room_config.width,
            text: self.scope.project.room_config.width + "mm",
            correctionY
        });

        self.scope.app.Lines.y = self.createArrowSize({
            width: self.scope.project.room_config.height,
            text: self.scope.project.room_config.height + "mm"
        });
        self.scope.app.Lines.z = self.createArrowSize({
            width: self.scope.project.room_config.depth,
            text: self.scope.project.room_config.depth + "mm",
            correctionY
        });

        self.setRoomLinePosition();

        self.scene.add(
            self.scope.app.Lines.x,
            self.scope.app.Lines.y,
            self.scope.app.Lines.z
        );
    };

    this.setRoomLinePosition = function () {
        self.scope.app.Lines.x.position.setY(self.scope.project.room_config.height / 2 - 80);

        self.scope.app.Lines.y.rotation.z = Math.PI / 2;
        self.scope.app.Lines.y.position.setZ(self.scope.project.room_config.depth);
        self.scope.app.Lines.y.position.setX(-self.scope.project.room_config.width / 2 + 10);

        self.scope.app.Lines.z.position.setX(-self.scope.project.room_config.width / 2 + 10);
        self.scope.app.Lines.z.position.setY(self.scope.project.room_config.height / 2 - 80);
        self.scope.app.Lines.z.position.setZ(self.scope.project.room_config.depth / 2);
        self.scope.app.Lines.z.rotation.y = Math.PI / 2;
    };

    this.createArrowSize = function (props = {
                                         width: 0,
                                         text: "",
                                         lines: false,
                                         correctionX: false,
                                         correctionY: false,
                                         correctionZ: false,
                                         lineColor: false,
                                         textColor: false,
                                         fontSize: 80,
                                     }
    ) {

        let {
            width,
            text,
            lines,
            correctionX,
            correctionY,
            correctionZ,
            lineColor,
            textColor, fontSize
        } = props

        var group = new THREE.Object3D();
        var colorLine = lineColor || 0x444444;
        var colortext = textColor || "black";
        fontSize = fontSize || 80;

        var textMesh = self.createLabel(text, 0, 0, 0, fontSize, colortext);
        var textMesh_box = new THREE.Box3().setFromObject(textMesh);
        var textSize = new THREE.Vector3()
        textMesh_box.getSize(textSize);

        textMesh.position.setZ(5);

        var isMin = width - 40 < textSize.x;

        if (isMin) {
            fontSize = width > 50 ? fontSize / 2 : fontSize / 4
            textMesh = self.createLabel(text, 0, 0, 0, fontSize, colortext);
            textMesh_box = new THREE.Box3().setFromObject(textMesh);
            textSize = new THREE.Vector3()
            textMesh_box.getSize(textSize);

            textMesh.position.setZ(5);
            textMesh.position.setY(textSize.y / 2);
        }

        if (correctionY) {
            textMesh.position.setY(correctionY);
        }

        if (width > 50 && !self.scope.app.hideFrames) {
            var arrowLeft = new THREE.ArrowHelper(
                new THREE.Vector3(width, 0, 0),
                new THREE.Vector3(0, 0, 3),
                width / 2 - (isMin ? 0 : textSize.x / 2 + 10),
                colorLine,
                20,
                15
            );
            arrowLeft.position.setX(isMin ? 0 : textSize.x / 2 + 10);

            var arrowRight = new THREE.ArrowHelper(
                new THREE.Vector3(-width, 0, 0),
                new THREE.Vector3(0, 0, 3),
                width / 2 - (isMin ? 0 : textSize.x / 2 + 10),
                colorLine,
                20,
                15
            );
            arrowRight.position.setX(isMin ? 0 : -(textSize.x / 2 + 10));

            if (lines) {
                var arrowLeft2 = new THREE.ArrowHelper(
                    new THREE.Vector3(width, 0, 0),
                    new THREE.Vector3(0, 0, 3),
                    lines,
                    colorLine,
                    20,
                    15
                );
                arrowLeft2.position.setX(width / 2);
                arrowLeft2.rotation.z = 0;
                arrowLeft2.position.setY(-lines);

                var arrowLeft3 = new THREE.ArrowHelper(
                    new THREE.Vector3(width, 0, 0),
                    new THREE.Vector3(0, 0, 3),
                    lines,
                    colorLine,
                    20,
                    15
                );
                arrowLeft3.position.setX(-width / 2);
                arrowLeft3.rotation.z = 0;
                arrowLeft3.position.setY(-lines);

                group.add(arrowLeft2, arrowLeft3);
            }

            //Коррекция позиции
            if (correctionX) {
                arrowLeft.position.setX(correctionX);
                arrowRight.position.setX(correctionX);
            }

            if (correctionY) {
                arrowLeft.position.setY(correctionY);
                arrowRight.position.setY(correctionY);
            }

            if (correctionZ) {
                arrowLeft.position.setZ(correctionZ);
                arrowRight.position.setZ(correctionZ);
            }

            group.add(arrowRight, arrowLeft);
        }

        /*var geometry = new THREE.Geometry();
    geometry.vertices.push(new THREE.Vector3(0, -30, 0), new THREE.Vector3(0, 30, 0));
    var lineL = new THREE.Line(geometry, new THREE.LineBasicMaterial({color: colorLine, linewidth: 3}));
    var lineR = new THREE.Line(geometry, new THREE.LineBasicMaterial({color: colorLine, linewidth: 3}));
    lineL.position.setX(-width / 2);
    lineR.position.setX(width / 2);*/

        if (!self.scope.app.hideFrames) {
            textMesh.name = "Label"
            group.add(textMesh);
        }

        group.name = "ArrowHelpersGroup"
        return group;
    };

    /*****Button function*****/
    this.goBasePosition = function () {
        self.controls.reset();
        self.controls.object.position.set(0, 0, 10000);
    };

    this.controlMechanism = function () {
        if (self.scope.app.active.PROPS === undefined) return false;
        self.scope.app.active.PROPS.MECHANISM = self.avalibleMechanism(self.scope.app.active);
        let mechID = self.scope.app.active.PROPS.CONFIG.MECHANISM;

        if (!self.scope.app.active.PROPS.MECHANISM.success) {
            delete self.scope.app.active.PROPS.CONFIG.BASKET.MECHANISM;
            self.scope.app.active.PROPS.CONFIG.MECHANISM = false;
            return false;
        }

        if (self.scope.app.active.PROPS.MECHANISM[mechID] === undefined) {
            delete self.scope.app.active.PROPS.CONFIG.BASKET.MECHANISM;
            self.scope.app.active.PROPS.CONFIG.MECHANISM = false;
            return false;
        }
    };

    this.weightCalculation = function (fasade, replaceFasade) {
        let fasadeNumber = "FASADE" + replaceFasade.FASADE_NUMBER,
            //density = fasade[fasadeNumber]["density"],
            //depth = fasade[fasadeNumber]["depth"],
            fasadeWeight = parseFloat(fasade[fasadeNumber]["weight"]),
            width,
            height,
            square,
            weight;

        width = eval(replaceFasade.FASADE_WIDTH);
        height = eval(replaceFasade.FASADE_HEIGHT);
        square = width * height;
        weight = fasadeWeight * (square / 1000000);

        fasade[fasadeNumber]["width"] = width;
        fasade[fasadeNumber]["height"] = height;
        fasade[fasadeNumber]["square"] = parseFloat(square.toFixed(2));
        fasade[fasadeNumber]["weight"] = parseFloat(weight.toFixed(2));

        return fasade;
    };

    this.clearElementMechanism = function () {
        delete self.scope.app.active.PROPS.CONFIG.BASKET.MECHANISM;
        self.scope.app.active.PROPS.CONFIG.MECHANISM = false;
        self.getBasketPrice();
    };

    this.setElementMechanism = function (id, groupID) {
        if (id == "") {
            delete self.scope.app.active.PROPS.CONFIG.BASKET.MECHANISM;
            self.scope.app.active.PROPS.CONFIG.MECHANISM = false;
            return false;
        }

        self.scope.app.active.PROPS.MECHANISM = self.avalibleMechanism(self.scope.app.active);

        if (
            self.scope.app.active.PROPS.MECHANISM.success &&
            self.scope.app.active.PROPS.MECHANISM.ListMechanism[groupID][id]
        ) {
            self.scope.app.active.PROPS.CONFIG.BASKET.MECHANISM = parseInt(id);
        }

        self.getBasketPrice();

        return true;
    };

    this.avalibleMechanism = function (group) {
        if (group === false) return {success: false, text: "Нет доступных механизмов."};

        let objAxis = {
            "#X#": group.PROPS.CONFIG.SIZE.width,
            "#Y#": group.PROPS.CONFIG.SIZE.height,
        };

        let result = {success: false},
            detectedFasade = false,
            objFasade = {},
            mechanism = {},
            allWeight = 0,
            product = self.getProductInfo(group.PROPS.CONFIG.ID),
            sectionMech = {},
            detectedActiveMechanism = false;

        if (typeof self.scope.app.MECHANISM == "object") {
            if (Object.keys(self.scope.app.MECHANISM).length <= 0) {
                return {success: false, text: "Нет доступных механизмов."};
            }
        } else {
            return {success: false, text: "Нет доступных механизмов."};
        }

        if (product.OPTION[0] === null) {
            return {success: false, text: "У корпуса не привязан механизм."};
        } else {
            for (let n in product.OPTION) {
                if (typeof self.scope.app.MECHANISM[product.OPTION[n]] == "undefined") continue;
                if (self.scope.app.MECHANISM[product.OPTION[n]][product.ID]) {
                    detectedActiveMechanism = true;
                    break;
                }
            }
        }

        if (!detectedActiveMechanism)
            return {success: false, text: "У корпуса не привязан механизм."};

        for (let basketElem in group.PROPS.CONFIG.BASKET) {

            let checkFasade = basketElem.match(/(FACADE|FASADE)(\d+|$)/);

            if (checkFasade !== null) {
                detectedFasade = true;
                var basket = group.PROPS.CONFIG.BASKET;
                var arrFasade = self.scope.app.FASADE;

                let fasadeID = (group.PROPS.CONFIG.BASKET['FASADE' + checkFasade[2]] !== undefined) ? group.PROPS.CONFIG.BASKET['FASADE' + checkFasade[2]][0] : false;
                let millingID = (group.PROPS.CONFIG.BASKET['MILLING' + checkFasade[2]] !== undefined) ? group.PROPS.CONFIG.BASKET['MILLING' + checkFasade[2]][0] : false;
                let weightFasade = self.scope.app.fasade_weight;
                let weightMilling = self.scope.app.milling_weight;

                if (millingID !== false && weightMilling[millingID] !== undefined) {
                    objFasade[basketElem] = {
                        ID: group.PROPS.CONFIG.BASKET[basketElem],
                        //density: parseInt(fasade.DENSITY),
                        //depth: fasade.DEPTH,
                        weight: weightMilling[millingID],
                    };
                } else {
                    if (weightFasade[fasadeID] === false)
                        return {
                            success: false,
                            text: "У фасада нет одного из обязательных параметров.",
                        };

                    objFasade[basketElem] = {
                        ID: group.PROPS.CONFIG.BASKET[basketElem],
                        //density: parseInt(fasade.DENSITY),
                        //depth: fasade.DEPTH,
                        weight: weightFasade[fasadeID],
                    };
                }

            }
        }

        if (detectedFasade === false)
            return {success: false, text: "У корпуса нет фасадов."};

        let i = 0;
        for (let q in self.scope.app.FASADE_POSITION) {
            if (self.scope.app.FASADE_POSITION[q].PRODUCT == product.ID) {
                let fasadeElem = self.expressionsReplace(
                    self.scope.app.FASADE_POSITION[q],
                    objAxis
                );
                objFasade = self.weightCalculation(objFasade, fasadeElem);
                allWeight = allWeight + objFasade["FASADE" + fasadeElem.FASADE_NUMBER].weight;
                i++;
            }
        }

        if (Object.keys(objFasade).length != i && Object.keys(objFasade).length != 1)
            return {success: false, text: "У одного из фасадов нет позиции."};

        if (Object.keys(objFasade).length != i && Object.keys(objFasade).length == 1) {
            let fasadeElem = {
                FASADE_WIDTH: group.PROPS.CONFIG.SIZE.width,
                FASADE_HEIGHT: group.PROPS.CONFIG.SIZE.height,
                FASADE_NUMBER: 1,
            };
            objFasade = self.weightCalculation(objFasade, fasadeElem);
            allWeight = objFasade + objFasade["FASADE1"].weight;
        }

        if (allWeight <= 0)
            return {success: false, text: "Вес фасадов не может быть меньше или равен 0."};

        for (let q in product.OPTION) {
            let mechID = product.OPTION[q];

            if (self.scope.app.MECHANISM[mechID] === undefined) continue;

            let mechInfo = self.scope.app.MECHANISM[mechID][product.ID];

            if (mechInfo === undefined) continue;

            for (let w in mechInfo.PROPERTY_MECHANISM_LINK_VALUE) {
                let condition =
                        self.scope.app.condition_mechanism[mechInfo.PROPERTY_MECHANISM_LINK_VALUE[w]],
                    conditionMinHeight,
                    conditionMaxHeight,
                    conditionMinWeight,
                    conditionMaxWeight;

                conditionMinHeight = parseFloat(condition.PROPERTY_RANGE_MIN_HEIGHT_VALUE);
                conditionMaxHeight = parseFloat(condition.PROPERTY_RANGE_MAX_HEIGHT_VALUE);

                conditionMinWeight = parseFloat(condition.PROPERTY_RANGE_MIN_WEIGHT_VALUE);
                conditionMaxWeight = parseFloat(condition.PROPERTY_RANGE_MAX_WEIGHT_VALUE);

                if (conditionMinHeight !== null && conditionMaxHeight !== null) {
                    if (
                        group.PROPS.CONFIG.SIZE.height >= conditionMinHeight &&
                        group.PROPS.CONFIG.SIZE.height <= conditionMaxHeight &&
                        allWeight <= conditionMaxWeight &&
                        allWeight >= conditionMinWeight
                    ) {
                        if (sectionMech[mechInfo.SECTION] !== undefined) {
                            if (
                                sectionMech[mechInfo.SECTION] != mechInfo.PROPERTY_TYPE_MECHANISM_VALUE
                            ) {
                                continue;
                            }
                        }
                        sectionMech[mechInfo.SECTION] = mechInfo.PROPERTY_TYPE_MECHANISM_VALUE;

                        if (!mechanism[mechInfo.GROUP])
                            mechanism[mechInfo.GROUP] = {}

                        mechanism[mechInfo.GROUP][mechID] = {
                            ID: mechID,
                            NAME: mechInfo.NAME,
                            MINHEIGHT: conditionMinHeight,
                            MAXHEIGHT: conditionMaxHeight,
                            ALLWEIGHT: allWeight,
                            MINWEIGHT: conditionMinWeight,
                            MAXWEIGHT: conditionMaxWeight,
                        };
                    }
                }
            }
        }

        if (Object.keys(mechanism).length == 0) {
            return {success: false, text: "Нет доступных механизмов."};
        } else if (Object.keys(mechanism).length > 0) {
            return {success: true, ListMechanism: mechanism};
        }
    };

    this.fullScreen = function () {
        if (
            !document.fullscreenElement &&
            !document.mozFullScreenElement &&
            !document.webkitFullscreenElement &&
            !document.msFullscreenElement
        ) {
            // current working methods
            if (document.documentElement.requestFullscreen) {
                document.documentElement.requestFullscreen();
            } else if (document.documentElement.msRequestFullscreen) {
                document.documentElement.msRequestFullscreen();
            } else if (document.documentElement.mozRequestFullScreen) {
                document.documentElement.mozRequestFullScreen();
            } else if (document.documentElement.webkitRequestFullscreen) {
                document.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
            }
        } else {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            }
        }
    };

    this.downloadCanvas = function (ret) {
        if (ret != undefined) return self.getScrean("image/jpeg");
        else {
            self.saveAsImage();
        }
    };

    this.getScrean = function (strMime) {
        self.renderer.preserveDrawingBuffer = true;

        self.renderer.render(self.scene, self.camera);

        var img = self.renderer.domElement.toDataURL(strMime);

        self.renderer.preserveDrawingBuffer = false;

        return img;
    };

    this.saveAsImage = function () {
        var imgData, imgNode;

        try {
            var strDownloadMime = "image/octet-stream";
            var strMime = "image/jpeg";
            imgData = self.getScrean(strMime);
            self.saveFile(imgData.replace(strMime, strDownloadMime), "screenshot.jpg");
        } catch (e) {
            return;
        }
    };

    this.saveFile = function (strData, filename) {
        var link = document.createElement("a");
        if (typeof link.download === "string") {
            document.body.appendChild(link);
            link.download = filename;
            link.href = strData;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    };

    this.showSectionCanvas = function (group, showed) {
        var showed = showed !== null && showed !== undefined ? showed : true;

        if (!!group.PROPS.SECTIONSCANVAS != showed)
            angular.forEach(group.PROPS.SECTIONCONTROL, function (elem) {
                elem.material.visible = showed;
            });

        group.PROPS.SECTIONSCANVAS = showed;

        return showed;
    };

    this.deleteSubElementToElement = function (group, sectionNumber, elementNumber, deleteAutoGenShelf = false, isControl = false) {
        let delElement = Object.assign({}, group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[elementNumber])

        delete group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[elementNumber];

        if (delElement.FASADE || delElement.MANUFACTURER_OFFSET)
            delete group.PROPS.CONFIG.recalcFasadeHeight;

        group.PROPS.CONFIG.deleteAutoGenShelf = deleteAutoGenShelf

        if (!deleteAutoGenShelf && group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES?.[delElement.SECTION]) {
            let index1 = group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[delElement.SECTION].findIndex(item => item.key == delElement.KEY)

            if (index1 >= 0)
                group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[delElement.SECTION].splice(index1, 1)

            let index2 = group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[delElement.SECTION].findIndex(item => item.drawerKey == delElement.KEY)

            if (index2 >= 0)
                self.deleteSubElementToElement(group, sectionNumber, group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[delElement.SECTION][index2].key)
        }

        //Изменить функцию, сделать проверку на внешний ящик, и присваивать ему актуальный ключ, а не начиная с 1, как происходит сейчас
        angular.forEach(group.PROPS.CONFIG.SECTIONS, function (e, k) {

            const temporarySubelements = {}
            const temporaryBoxesWithFasade = {}
            const temporaryProfiles = {}
            let newKey = 1

            if (group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES?.[k]) {

                for (let item of group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[k]) {
                    if (item.key == elementNumber) {
                        item.key = null

                        if (item.obj.KEY)
                            item.obj.KEY = null
                    } else if (item.key > elementNumber) {
                        item.key -= 1

                        if (item.obj.KEY)
                            item.obj.KEY -= 1
                    }
                }
            }

            if (e?.SUBELEMENTS) {
                angular.forEach(e.SUBELEMENTS, function (sube, skey) {

                    temporarySubelements[newKey] = sube
                    temporarySubelements[newKey].KEY = +newKey
                    //temporarySubelements[newKey].OBJ.PROPS.CONFIG.KEY = +newKey

                    if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k] && group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k][skey]) {
                        group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k][skey].KEY = newKey
                        temporaryBoxesWithFasade[newKey] = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k][skey]
                        delete group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k][skey]
                    } else if (group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[k] && group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[k][skey]) {
                        group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[k][skey].KEY = newKey
                        temporaryProfiles[newKey] = group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[k][skey]
                        delete group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[k][skey]
                    }

                    newKey++
                })

                group.PROPS.CONFIG.SECTIONS[k].SUBELEMENTS = temporarySubelements
            }

            group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k] = temporaryBoxesWithFasade
            group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[k] = temporaryProfiles

        })

        if (delElement?.TYPE === "PARTITION") {
            delete group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION?.[sectionNumber]
            self.removeSection(group, delElement)
            self.createSubelelmentsRulers(group)
        }

        self.rebuildWrap(group);
        self.calcSectionSubElementConfigValue(group);

        let reset_flag1, reset_flag2

        if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[sectionNumber]) {
            if (!Object.keys(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[sectionNumber]).length) {
                delete group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[sectionNumber]
                reset_flag1 = true
            }
        } else
            reset_flag1 = true

        if (group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[sectionNumber]) {
            if (!Object.keys(group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[sectionNumber]).length) {
                delete group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[sectionNumber]
                reset_flag2 = true
            }
        } else
            reset_flag2 = true

        if (reset_flag1 && reset_flag2 && !group.PROPS.CONFIG.recalcFasadeHeight) {
            self.resetFasades(group, sectionNumber)
        }

        if (!isControl && group.PROPS?.PRODUCT.moduleType?.CODE === "universal" && (group.PROPS.CONFIG.BASKET[`FASADE${sectionNumber}`] || group.PROPS.CONFIG.BASKET.DOORS?.[sectionNumber])) {

            if (group.PROPS.CONFIG.BASKET.DOORS?.[sectionNumber]) {
                angular.forEach(group.PROPS.CONFIG.BASKET.DOORS[sectionNumber], function (door, doorKey) {
                    self.controlFasadeCount(group, sectionNumber, doorKey)
                    self.updateFasade(group, sectionNumber, false, doorKey)
                })
            } else {
                self.controlFasadeCount(group, sectionNumber)
                self.updateFasade(group, sectionNumber, false)
            }

            if (!group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[sectionNumber]) {
                self.initLoops(group)
            }
        }
        self.getBasketPrice();
    };

    //Разделение текущего фасада на два, при разделении секции
    this.fasadeSplit = function (group, sectionNumber, doorKey) {
        group.PROPS.CONFIG.FASADELIST[sectionNumber + 1] = group.PROPS.CONFIG.FASADELIST[sectionNumber]
        group.PROPS.CONFIG.BASKET["FASADE" + (sectionNumber + 1)] = {0: 7397}
        group.PROPS.CONFIG.BASKET["FASADESIZES" + (sectionNumber + 1)] = [...group.PROPS.CONFIG.BASKET["FASADESIZES" + sectionNumber]]
        group.PROPS.CONFIG.BASKET["LOOPSSIDE"][sectionNumber + 1] = group.PROPS.CONFIG.BASKET["LOOPSSIDE"][sectionNumber] == 4693757 ? 4693746 : 4693757

        var fasadePosition = self.getFasadePosition(group, sectionNumber + 1, doorKey)
        const compositeFasade = self.createCompositeFasade(group, sectionNumber + 1)
        group.add(compositeFasade);

        group.PROPS.FASADE[sectionNumber + 1] = compositeFasade;
    }

    this.calcSumDoorSegments = function (group, fasadeNumber, doorNumber) {
        let sizeArray = typeof group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber] === "object" ? doorNumber ? Object.values(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber][doorNumber]) :
            Object.values(group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber]) : group.PROPS.CONFIG.BASKET['FASADESIZES' + fasadeNumber];

        if (group.PROPS.CONFIG.BASKET['SECTIONSFILLING' + fasadeNumber])
            Object.values(group.PROPS.CONFIG.BASKET['SECTIONSFILLING' + fasadeNumber]).filter(item => item.FASADE).map(item => {
                if (item.FASADE.size?.height)
                    sizeArray.push(item.FASADE.size.height)
            })

        let sum = sizeArray.reduce((partialSum, a) => partialSum + a, 0)

        return sum
    }
    this.addSlideDoor = function (group) {
        const PRODUCT = group.PROPS.PRODUCT
        const CONFIG = group.PROPS.CONFIG

        let door_id = Object.keys(CONFIG.FASADELIST).length + 1

        switch (door_id) {
            case 4:
                this.removeSlideDoor(group)
                CONFIG.FASADELIST[door_id - 1] = PRODUCT.FASADE_POSITION[1]
                CONFIG.FASADELIST[door_id] = PRODUCT.FASADE_POSITION[0]
                break;
            default:
                if (door_id % 2 === 0)
                    CONFIG.FASADELIST[door_id] = PRODUCT.FASADE_POSITION[1]
                else
                    CONFIG.FASADELIST[door_id] = PRODUCT.FASADE_POSITION[0]
                break;
        }

        let fasadePosition = this.getFasadePosition(group, door_id)

        const fasadeSize = [fasadePosition.FASADE_HEIGHT]
        const fasadePositionNumber = self.calcFasadePositions(fasadeSize, CONFIG, fasadePosition)

        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}
        CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[door_id] = fasadePositionNumber

        CONFIG.BASKET['FASADESIZES' + door_id] = [fasadePosition.FASADE_HEIGHT]

        for (let i = 1; i <= Object.keys(CONFIG.FASADELIST).length; i++)
            CONFIG.BASKET['FASADEWIDTH' + i] = fasadePosition.FASADE_WIDTH

        CONFIG.BASKET.DOORS[door_id] = {0: 7397}

        self.controlFasade(group)
        self.rebuildWrap(group)
    }

    this.removeSlideDoor = function (group, _door_id) {

        self.hideOptionsTab()

        const CONFIG = group.PROPS.CONFIG
        let door_id = _door_id || Object.keys(CONFIG.BASKET.DOORS).length

        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}

        delete CONFIG.FASADELIST[door_id]
        delete CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[door_id]
        delete CONFIG.BASKET['FASADESIZES' + door_id]
        delete CONFIG.BASKET['FASADEWIDTH' + door_id]
        delete CONFIG.BASKET.DOORS[door_id]

        let fasadePosition = this.getFasadePosition(group, door_id)
        for (let i = 1; i <= Object.keys(CONFIG.FASADELIST).length; i++)
            CONFIG.BASKET['FASADEWIDTH' + i] = fasadePosition.FASADE_WIDTH

        if (door_id == 4) {
            this.removeSlideDoor(group)
            this.addSlideDoor(group)
        }

        self.controlFasade(group)
        self.rebuildWrap(group)
    }

    this.checkAddDoor = function (group, section) {
        let result = false
        const CONFIG = group.PROPS.CONFIG

        if (CONFIG.BASKET.DOORS) {
            const sectionLeft = CONFIG.BASKET[`SECTIONS${section - 1}`] || false
            const sectionRight = CONFIG.BASKET[`SECTIONS${section + 1}`] || false
            const door_number = CONFIG.FASADELIST[section] ? Object.keys(CONFIG.FASADELIST[section]).length + 1 : 1

            switch (door_number) {
                case 1:
                    if (sectionLeft) {
                        const sectionLeftLoops = CONFIG.BASKET.LOOPSSIDE[section - 1] || {}
                        if (sectionLeftLoops[2] || [4693757, 7080949].includes(sectionLeftLoops[1])) {
                            result = true
                        } else
                            result = false
                    }
                    if (result) {
                        if (sectionRight) {
                            const sectionRightLoops = CONFIG.BASKET.LOOPSSIDE[section + 1] || {}
                            if ([7080918, 4693746].includes(sectionRightLoops[1])) {
                                result = true
                            } else
                                result = false
                        } else {
                            result = false
                        }
                    }
                    break;
                case 2:
                    if (sectionRight) {
                        const sectionRightLoops = CONFIG.BASKET.LOOPSSIDE[section + 1] || {}
                        if ([7080918, 4693746].includes(sectionRightLoops[1])) {
                            result = true
                        }
                    }
                    if (sectionLeft) {
                        const sectionLeftLoops = CONFIG.BASKET.LOOPSSIDE[section - 1] || {}
                        if ([4693757, 7080949].includes(CONFIG.BASKET.LOOPSSIDE[section][1]) && (sectionLeftLoops[2] || [4693757, 7080949].includes(sectionLeftLoops[1]))) {
                            result = true
                        }
                    }
                    break;
                default:
                    result = true
                    break;
            }
        }
        return result
    }

    this.addDoor = function (group, section) {

        //self.clearSectionFilling(group, section)

        const PRODUCT = group.PROPS.PRODUCT
        const CONFIG = group.PROPS.CONFIG

        if (!CONFIG.BASKET[`FASADESIZES${section}`])
            CONFIG.BASKET[`FASADESIZES${section}`] = {}
        if (!CONFIG.BASKET[`FASADEWIDTH${section}`])
            CONFIG.BASKET[`FASADEWIDTH${section}`] = {}
        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}
        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section])
            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section] = {}

        if (!CONFIG.BASKET.DOORS) {
            CONFIG.BASKET.DOORS = {}

            let index = 1
            while (CONFIG.BASKET[`FASADE${index}`]) {
                if (CONFIG.BASKET[`FASADE${index}`]) {
                    CONFIG.BASKET.DOORS[index] = {1: CONFIG.BASKET[`FASADE${index}`]}
                    CONFIG.BASKET[`FASADESIZES${index}`] = {1: CONFIG.BASKET[`FASADESIZES${index}`]}
                    CONFIG.BASKET[`FASADEWIDTH${index}`] = {1: CONFIG.BASKET[`FASADEWIDTH${index}`]}
                    CONFIG.BASKET.LOOPS[index] = {1: CONFIG.BASKET.LOOPS[index]}
                    CONFIG.BASKET.LOOPSSIDE[index] = {1: CONFIG.BASKET.LOOPSSIDE[index]}
                    CONFIG.FASADELIST[index] = {1: CONFIG.FASADELIST[index]}
                    CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[index] = {1: CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[index]}
                    CONFIG.FASADE_SECTIONS.LOOPS[index] = {1: CONFIG.FASADE_SECTIONS.LOOPS[index]}
                    CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[index] = {1: CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[index]}

                    if (group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${index}`]) {
                        group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${index}`] = {1: group.PROPS.CONFIG.BASKET[`FASADEHORIZONTALPOSITION${index}`]}
                    }

                    if (group.PROPS.CONFIG.BASKET['MILLING' + index]) {
                        let tmp = group.PROPS.CONFIG.BASKET['MILLING' + index]
                        group.PROPS.CONFIG.BASKET['MILLING' + index] = {1: tmp}
                    }
                    if (group.PROPS.CONFIG.BASKET['PALETTE' + index]) {
                        let tmp = group.PROPS.CONFIG.BASKET['PALETTE' + index]
                        group.PROPS.CONFIG.BASKET['PALETTE' + index] = {1: tmp}
                    }
                    if (group.PROPS.CONFIG.BASKET['PATINA' + index]) {
                        let tmp = group.PROPS.CONFIG.BASKET['PATINA' + index]
                        group.PROPS.CONFIG.BASKET['PATINA' + index] = {1: tmp}
                    }
                    if (group.PROPS.CONFIG.BASKET['FASADETYPE' + index]) {
                        let tmp = group.PROPS.CONFIG.BASKET['FASADETYPE' + index]
                        group.PROPS.CONFIG.BASKET['FASADETYPE' + index] = {1: tmp}
                    }

                    delete CONFIG.BASKET[`FASADE${index}`]
                }
                index += 1
            }
        }

        const door_id = section
        let door_number = 2
        if (!CONFIG.BASKET.DOORS[section]) {
            door_number = 1

            CONFIG.BASKET.DOORS[section] = {1: {}}
            CONFIG.BASKET[`FASADESIZES${section}`][1] = []
            CONFIG.BASKET[`FASADEWIDTH${section}`][1] = []
            CONFIG.FASADELIST[door_id] = {1: group.PROPS.PRODUCT.FASADE_POSITION[0] || false}

            CONFIG.BASKET.LOOPS[section] = {1: []}

            const sectionLeft = CONFIG.BASKET[`SECTIONS${section - 1}`] || false
            const sectionRight = CONFIG.BASKET[`SECTIONS${section + 1}`] || false

            let loopside = false
            if (sectionLeft) {
                const sectionLeftLoops = CONFIG.BASKET.LOOPSSIDE[section - 1] || {}
                if (sectionLeftLoops[2] || [4693757, 7080949].includes(sectionLeftLoops[1])) {
                    loopside = false
                } else
                    loopside = 7080918
            } else {
                loopside = 4693746
            }

            if (!loopside) {
                const sectionRightLoops = CONFIG.BASKET.LOOPSSIDE[section + 1] || {}
                if (sectionRight) {
                    if ([7080918, 4693746].includes(sectionRightLoops[1])) {
                        loopside = false
                    } else
                        loopside = 7080949
                } else {
                    loopside = 4693757
                }
            }

            CONFIG.BASKET.LOOPSSIDE[section] = {1: loopside}

            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section] = {1: {}}
            CONFIG.FASADE_SECTIONS.LOOPS[section] = {1: []}
        }

        CONFIG.FASADELIST[door_id][door_number] = PRODUCT.FASADE_POSITION[0]

        const fasadePosition = this.getFasadePosition(group, door_id, door_number)
        const fasadeSize = [fasadePosition.FASADE_HEIGHT]
        const fasadePositionNumber = self.calcFasadePositions(fasadeSize, CONFIG, fasadePosition)

        if (door_number > 1) {
            //fasadePosition.FASADE_WIDTH = Math.floor(fasadePosition.FASADE_WIDTH / door_number)
            //fasadePosition.POSITION_X += fasadePosition.FASADE_WIDTH
            CONFIG.BASKET[`FASADEWIDTH${section}`][door_number - 1] = fasadePosition.FASADE_WIDTH
            if (![4693746, 7080918].includes(CONFIG.BASKET.LOOPSSIDE[section][door_number - 1]))
                CONFIG.BASKET.LOOPSSIDE[section][door_number - 1] = CONFIG.BASKET[`SECTIONS${section - 1}`] ? 7080918 : 4693746

            //первая дверь должна имееть позицию петель слева, а вторая дверь - справа
            CONFIG.BASKET.LOOPSSIDE[section][door_number] = [4693746, 7080918].includes(CONFIG.BASKET.LOOPSSIDE[section][door_number - 1]) ?
                CONFIG.BASKET[`SECTIONS${section + 1}`] ? 7080949 : 4693757 : 4693757

            CONFIG.BASKET.LOOPS[section][door_number] = [...CONFIG.BASKET.LOOPS[section][door_number - 1]]
            CONFIG.FASADE_SECTIONS.LOOPS[section][door_number] = [...CONFIG.FASADE_SECTIONS.LOOPS[section][door_number - 1]]
        }

        CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][door_number] = fasadePositionNumber
        CONFIG.BASKET[`FASADESIZES${section}`][door_number] = [fasadePosition.FASADE_HEIGHT]
        CONFIG.BASKET[`FASADEWIDTH${section}`][door_number] = fasadePosition.FASADE_WIDTH

        let defaultColor
        if (PRODUCT.element_type == "element_up") {
            defaultColor = self.scope.project.default_fasade_up
            ;
        } else {
            defaultColor = self.scope.project.default_fasade_down
        }

        CONFIG.BASKET.DOORS[section][door_number] = CONFIG.BASKET.DOORS[section][door_number - 1] ? Object.assign({}, CONFIG.BASKET.DOORS[section][door_number - 1]) : {0: defaultColor || 7397}

        self.updateElement(group)

        /*self.controlFasade(group)
        self.rebuildWrap(group)
        self.updateLoops(group, section)*/
    }

    this.removeDoor = function (group, section) {

        self.hideOptionsTab()
        //self.clearSectionFilling(group, section)

        const CONFIG = group.PROPS.CONFIG
        const door_id = Object.keys(CONFIG.FASADELIST[section]).length || false

        if (!door_id)
            return

        if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
            CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}

        delete CONFIG.BASKET.DOORS[section][door_id]
        delete CONFIG.FASADELIST[section][door_id]
        delete CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][door_id]
        delete CONFIG.BASKET[`FASADESIZES${section}`][door_id]
        delete CONFIG.BASKET[`FASADEWIDTH${section}`][door_id]

        if (CONFIG.BASKET.LOOPS?.[section]?.[door_id])
            delete CONFIG.BASKET.LOOPS[section][door_id]

        delete CONFIG.BASKET.LOOPSSIDE[section][door_id]
        delete CONFIG.FASADE_SECTIONS.LOOPS[section][door_id]
        delete CONFIG.BASKET[`FASADEHORIZONTALPOSITION${section}`][door_id]

        if (door_id > 1) {
            let fasadePosition = this.getFasadePosition(group, section, door_id - 1)
            CONFIG.BASKET[`FASADEWIDTH${section}`][door_id - 1] = fasadePosition.FASADE_WIDTH
        } else {
            delete CONFIG.BASKET.DOORS[section]
            delete CONFIG.FASADELIST[section]
            delete CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section]
            delete CONFIG.BASKET[`FASADESIZES${section}`]
            delete CONFIG.BASKET[`FASADEWIDTH${section}`]
            delete CONFIG.BASKET.LOOPS[section]
            delete CONFIG.BASKET.LOOPSSIDE[section]
            delete CONFIG.FASADE_SECTIONS.LOOPS[section]
            delete CONFIG.BASKET[`FASADEHORIZONTALPOSITION${section}`]
        }

        self.controlFasade(group)
        self.rebuildWrap(group)
    }

    //Сдвиг id-шников секций вправо, при добавлении новой секции, или влево - при удалении секции
    this.shiftSections = function (group, sectionNumber, shiftSide = "right") {
        let sides = {
            "right": 1,
            "left": -1
        }

        //В зависимости от стороны сдвига, выбираем начальный index, с которого будем перемещать секции
        let index = sides[shiftSide] > 0 ? group.PROPS.CONFIG.CUSTOMFILLING.VSECTION : sectionNumber + 2

        while ((sides[shiftSide] > 0 && index > sectionNumber) || (sides[shiftSide] < 0 && index <= group.PROPS.CONFIG.CUSTOMFILLING.VSECTION)) {
            let new_index = index + sides[shiftSide]

            //Переносим информацию о секции в новую
            //Меняем id секции у элементов наполнения
            angular.forEach(group.PROPS.CONFIG.SECTIONS[index], function (item, key) {
                angular.forEach(item, function (value, key) {
                    if (value.SECTION)
                        value.SECTION = new_index
                })
            })
            //Вставляем измененную информацию в раздел новой секции
            group.PROPS.CONFIG.SECTIONS[new_index] = group.PROPS.CONFIG.SECTIONS[index]
            delete group.PROPS.CONFIG.SECTIONS[index]   //удаляем оригинал

            //Переносим информацию в корзине
            //В целом, можно этого и не делать, алгоритм всё равно пересчитает эти данные
            group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${new_index}`] = group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${index}`]
            delete group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${index}`]

            //Меняем id внутри контроллера сенкции
            let section = group.getObjectByName("SECTIONNUMBER" + index)
            section.SECTIONNUMBER = new_index
            section.name = "SECTIONNUMBER" + new_index

            //Перебираем список элементов наполнения, меняем им id секции и их имя
            //Если встретится какой-нибудь не удалённый элемент(предполагается, что это перегородка), то нужно перенести её
            //в соседнюю секциию
            for (let item of group.PROPS.SECTIONSOBJ) {
                if (item.SECTION == index) {
                    if (item.TYPE !== "PARTITION") {
                        item.SECTION = new_index
                        item.name = `${item.TYPE}_${item.SECTION}_${item.KEY}`
                    } else {
                        item.SECTION = new_index
                        item.name = `${item.TYPE}_${item.SECTION}`
                    }
                } else if (item.SECTION == new_index) {
                    item.SECTION = new_index + sides[shiftSide]

                    if (item.TYPE !== "PARTITION") {
                        item.name = `${item.TYPE}_${item.SECTION}_${item.KEY}`
                    } else {
                        item.name = `${item.TYPE}_${item.SECTION}`
                    }

                }
            }

            //перемещаем доп. информацию по секции: фасады, петли и т.д.
            angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS, function (value, key) {
                if (value[index])
                    value[new_index] = value[index]
            })

            //перемещаем доп. информацию по фасаду, если он есть
            if (group.PROPS.CONFIG.BASKET.DOORS?.[index]) {
                /* group.PROPS.CONFIG.BASKET.DOORS[new_index] = Object.assign({}, group.PROPS.CONFIG.BASKET.DOORS[index])
         group.PROPS.CONFIG.FASADELIST[new_index] = Object.assign({}, group.PROPS.CONFIG.FASADELIST[index])
         group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[new_index] = Object.assign({}, group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[index])
         group.PROPS.CONFIG.BASKET[`FASADESIZES${new_index}`] = Object.assign({}, group.PROPS.CONFIG.BASKET[`FASADESIZES${index}`])
         group.PROPS.CONFIG.BASKET[`FASADEWIDTH${new_index}`] = Object.assign({}, group.PROPS.CONFIG.BASKET[`FASADEWIDTH${index}`])
         group.PROPS.CONFIG.BASKET.LOOPS[new_index] = Object.assign({}, group.PROPS.CONFIG.BASKET.LOOPS[index])
         group.PROPS.CONFIG.BASKET.LOOPSSIDE[new_index] = Object.assign({}, group.PROPS.CONFIG.BASKET.LOOPSSIDE[index])
         group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[new_index] = Object.assign({}, group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[index])
 */
                while (group.PROPS.CONFIG.BASKET.DOORS[index])
                    self.removeDoor(group, index)
            } else if (group.PROPS.CONFIG.FASADELIST[index]) {
                group.PROPS.CONFIG.FASADELIST[new_index] = group.PROPS.CONFIG.FASADELIST[index]
                delete group.PROPS.CONFIG.FASADELIST[index]
            }

            //изменяем размер секции
            group.PROPS.CONFIG.BASKET['SECTIONS' + new_index] = group.PROPS.CONFIG.BASKET['SECTIONS' + index]
            delete group.PROPS.CONFIG.BASKET['SECTIONS' + index]

            group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.customSect[new_index - 1] = new_index

            group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION[new_index] = group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION[index]

            index = index + -sides[shiftSide];
        }

        //Настраиваем компоновку
        let new_groups = []
        group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.groups.map(item => {
            if (item[0] <= sectionNumber)
                new_groups.push(item)
            else {
                item[0] = item[0] + sides[shiftSide]
                new_groups.push(item)
            }
        })
        while (new_groups.length > group.PROPS.CONFIG.CUSTOMFILLING.VSECTION) {
            new_groups.pop()
        }

        //Удаляем информацию по последней секции или по освобожденной для новой
        //зависит от стороны сдвига
        angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS, function (value, key) {
            delete value[sides[shiftSide] > 0 ? sectionNumber + 1 : group.PROPS.CONFIG.CUSTOMFILLING.VSECTION]
        })
    }

    this.addSectionLogical = function (
        group,
        partition,
        sectionNumber,
        elementNumber,
    ) {
        let sectBeforeSize = 0;

        if (!group.PROPS.CONFIG.CUSTOMFILLING) {
            group.PROPS.CONFIG.CUSTOMFILLING = Object.assign({}, self.scope.app.FILLING[group.PROPS.CONFIG.BASKET["FILLING"]]);
            group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MIN = group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MIN || self.scope.sectionsSizes.universalModule.VSECTION_MIN;
            group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MAX = group.PROPS.CONFIG.CUSTOMFILLING.VSECTION_MAX || self.scope.sectionsSizes.universalModule.VSECTION_MAX;
            group.PROPS.CONFIG.CUSTOMFILLING.VSECTION = 1;
            group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION = {customSect: [1], groups: [[1]]}
            group.PROPS.CONFIG.CUSTOMFILLING.CUSTOM = true;
        }

        self.clearSectionFilling(group, sectionNumber)

        group.PROPS.CONFIG.CUSTOMFILLING.VSECTION += 1

        const groups = group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.groups
        const partitionFrame = partition.PROPS.FRAME
        let position = partitionFrame.POSITION || partitionFrame.position;

        //Изменяем размер левой половины секции со старым номером
        const sectionSize = self.getSectionSize(group, sectionNumber);
        const sectionPosition = new THREE.Vector3();

        const leftPartition = group.getObjectByName("PARTITION_" + (sectionNumber - 1))
        let leftBorder = leftPartition ? leftPartition.POSITION.x + Math.floor(leftPartition.SIZE.width / 2) : 0;

        let new_left_width = position.x - Math.floor(partitionFrame.SIZE.width / 2) - leftBorder

        let new_right_width = leftBorder + sectionSize.width - position.x - partitionFrame.SIZE.width / 2

        sectionPosition.x = position.x + Math.floor(new_right_width / 2) + Math.floor(partitionFrame.SIZE.width / 2);

        let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];
        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        let PLINTH_HEIGHT = (group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
            (!group.PROPS.CONFIG.BASKET.HORIZONT && group.PROPS.CONFIG.BASKET.HORIZONT !== 0) && filling.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : fasadeThickness || 0;

        sectionPosition.y =
            (sectionSize.height - partitionFrame.SIZE.height) / 2 + ((group.PROPS.CONFIG.BASKET.HORIZONT || group.PROPS.CONFIG.BASKET.HORIZONT === 0) ?
                PLINTH_HEIGHT + group.PROPS.CONFIG.BASKET.HORIZONT : PLINTH_HEIGHT || 0);

        let verticalSection = new THREE.Mesh(
            new THREE.PlaneBufferGeometry(sectionSize.width, sectionSize.height),
            new THREE.MeshLambertMaterial({
                transparent: !0,
                color: "#07d400",
                opacity: 0.25,
                visible: false,
            })
        );

        verticalSection.receiveShadow = true;
        verticalSection.SECTIONNUMBER = sectionNumber + 1;
        verticalSection.name = "SECTIONNUMBER" + (sectionNumber + 1);
        verticalSection.position.y = sectionPosition.y;
        verticalSection.position.x = sectionPosition.x;
        group.PROPS.SECTIONCONTROL.push(verticalSection);
        group.add(verticalSection);

        /*if (groups[groups.length - 1].length < 2)
      groups[groups.length - 1].push(verticalSection.SECTIONNUMBER)
    else*/
        groups.splice(sectionNumber, 0, [verticalSection.SECTIONNUMBER])
        group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.customSect[sectionNumber - 1] = sectionNumber
        group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.customSect[sectionNumber] = sectionNumber + 1

        group.PROPS.CONFIG.BASKET['SECTIONS' + sectionNumber] = new_left_width
        group.PROPS.CONFIG.BASKET['SECTIONS' + verticalSection.SECTIONNUMBER] = new_right_width

        self.setSectionsSize(group, false, sectionNumber)
        //self.fasadeSplit(group, sectionNumber)
    }

    this.clearSectionFilling = function (group, section) {
        let check = true

        while (check) {
            check = group.PROPS.SECTIONSOBJ.find(item => item.SECTION == section && item.TYPE !== "PARTITION") || false
            if (check)
                self.deleteSubElementToElement(group, check.SECTION, check.KEY)
        }
    }

    this.removeSection = function (group, element) {

        self.clearSectionFilling(group, element.SECTION + 1)
        self.clearSectionFilling(group, element.SECTION)

        let right_section_index = group.PROPS.SECTIONCONTROL.findIndex(item => item.SECTIONNUMBER == element.SECTION + 1)
        let right_sectioncontrol = group.PROPS.SECTIONCONTROL[right_section_index]
        let partitionThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18;

        let new_size = self.getSectionSize(group, element.SECTION).width + self.getSectionSize(group, element.SECTION + 1).width + partitionThickness;

        if (group.PROPS.PRODUCT.moduleType.CODE == "universal") {
            if (right_sectioncontrol) {
                while (group.PROPS.CONFIG.BASKET.DOORS?.[element.SECTION + 1])
                    self.removeDoor(group, element.SECTION + 1)
            }

            while (group.PROPS.CONFIG.BASKET.DOORS?.[element.SECTION])
                self.removeDoor(group, element.SECTION)
        }

        group.PROPS.SECTIONCONTROL.splice(right_section_index, 1)

        if (right_sectioncontrol) {
            right_sectioncontrol.geometry.dispose()
            right_sectioncontrol.material.dispose()
        }

        self.scene.remove(right_sectioncontrol)

        let new_groups = []
        group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.groups.map(item => {
            let id = item.findIndex(item2 => item2 == element.SECTION + 1)

            if (id >= 0)
                item.splice(id, 1)

            if (item.length)
                new_groups.push(item)
        })
        group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.groups = new_groups
        group.PROPS.CONFIG.CUSTOMFILLING.GROUP_SECTION.customSect.splice(element.SECTION, 1)

        delete group.PROPS.CONFIG.BASKET['SECTIONS' + (element.SECTION + 1)]

        group.PROPS.CONFIG.BASKET['SECTIONS' + element.SECTION] = new_size;

        //Если осталась перегородка в соседней секции, то нужно переместить информацию о ней
        if (group.PROPS.CONFIG.SECTIONS[element.SECTION + 1]) {
            angular.forEach(group.PROPS.CONFIG.SECTIONS[element.SECTION + 1], function (item, key) {
                angular.forEach(item, function (value, key) {
                    if (value.SECTION) {
                        value.SECTION = element.SECTION
                    }
                })
            })
            group.PROPS.CONFIG.SECTIONS[element.SECTION] = group.PROPS.CONFIG.SECTIONS[element.SECTION + 1]
            delete group.PROPS.CONFIG.SECTIONS[element.SECTION + 1]
            delete group.PROPS.CONFIG.BASKET['SECTIONSFILLING' + (element.SECTION + 1)]
        }

        angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS, function (item, key) {
            delete item[element.SECTION + 1]
        })


        if (group.PROPS.CONFIG.CUSTOMFILLING.VSECTION > element.SECTION + 1)
            self.shiftSections(group, element.SECTION, "left")

        group.PROPS.CONFIG.CUSTOMFILLING.VSECTION -= 1;

        self.shiftSectionPartition(group)

        let tmp_element = element;
        let section_id = element.SECTION
        while (section_id > 0) {
            if (group.PROPS.CONFIG.SECTIONS[section_id]?.SUBELEMENTS[1]?.TYPE === "PARTITION") {
                tmp_element = group.PROPS.CONFIG.SECTIONS[section_id].SUBELEMENTS[1]
                break;
            }

            section_id -= 1;
        }

        self.changeSectionSize(group, tmp_element)
        //self.setSectionsSize(self.scope.app.active, false, element.SECTION)

        self.changeSize(group.PROPS.CONFIG.SIZE)
        if (group.PROPS.PRODUCT.moduleType.CODE == "universal" && group.PROPS.CONFIG.BASKET.DOORS) {
            self.addDoor(group, element.SECTION)
            /*      if(element.SECTION < group.PROPS.CONFIG.CUSTOMFILLING.VSECTION)
              self.addDoor(group, group.PROPS.CONFIG.CUSTOMFILLING.VSECTION)*/

        }
    }

    this.changeSectionSize = function (group, element) {
        let leftSectionPos

        if (element.SECTION > 1) {
            leftSectionPos = group.PROPS.SECTIONSOBJ.find(item => item.name == `PARTITION_${element.SECTION - 1}`)
            let tmp_width = leftSectionPos?.SIZE?.width || 18

            leftSectionPos = Object.assign({}, leftSectionPos.POSITION)
            leftSectionPos.x += tmp_width / 2
        } else {
            leftSectionPos = new THREE.Vector3()
        }

        let new_section_size;

        if (group.PROPS.CONFIG.CUSTOMFILLING.VSECTION === 1) {
            let fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
            new_section_size = group.PROPS.CONFIG.SIZE.width - fasadeThickness * 2;
        } else {
            let pos = element.POSITION || element.position
            new_section_size = Math.abs(pos.x - element.SIZE.width / 2 - leftSectionPos.x);
            if (new_section_size === group.PROPS.CONFIG.BASKET['SECTIONS' + element.SECTION])
                return
        }

        group.PROPS.CONFIG.BASKET['SECTIONS' + element.SECTION] = new_section_size

        self.setSectionsSize(group, false, element.SECTION)

        self.checkSizeFasade(
            group.PROPS.CONFIG.BASKET,
            group.PROPS.CONFIG.FASADELIST,
            self.scope.app.new_size,
            group.PROPS.CONFIG.ID
        )
    }

    this.checkPartitionPositionRelativeDoors = function (group, _element, doorKey = '1') {

        if (group.PROPS.PRODUCT.moduleType?.CODE !== "wardrobe")
            return

        const element = _element || group.PROPS.CONFIG.SECTIONS[1].SUBELEMENTS[1]
        const doors_size = self.getFasadePosition(group, element.SECTION, doorKey)
        const overflow = doors_size.DOORS_OVERFLOW
        const doorsCount = Object.keys(group.PROPS.CONFIG.FASADELIST)?.length || 2
        const doors_cross = {}

        for (let i = 1; i <= doorsCount; i++) {
            if (doorsCount == 4 && i == 2) {
                let cross_coordinate1 = i * (doors_size.FASADE_WIDTH - overflow)
                let cross_coordinate2 = cross_coordinate1 + overflow * 2

                doors_cross[i] = [cross_coordinate1, cross_coordinate2]

            } else {
                let cross_coordinate1 = i * (doors_size.FASADE_WIDTH - overflow)
                let cross_coordinate2 = cross_coordinate1 + overflow

                doors_cross[i] = [cross_coordinate1, cross_coordinate2]
            }
        }

        const checkPosition = (partitionID, sectionKey) => {
            let partition = group.getObjectById(partitionID)

            if (!partition)
                return

            partition = partition.parent
            let position = partition.PROPS.FRAME.POSITION || partition.position
            position = position.x

            angular.forEach(doors_cross, function (overflowCoords, doorID) {
                if ((position > overflowCoords[1] || position < overflowCoords[0]) && partition.PROPS.CONFIG.WARNING !== false)
                    partition.PROPS.CONFIG.WARNING = true
                else
                    partition.PROPS.CONFIG.WARNING = false
            })

            if (partition.PROPS.CONFIG.WARNING) {
                partition.PROPS.FRAME.WARNING = partition.PROPS.CONFIG.WARNING = 6448306
                self.alert(`Внимание: Перегородка ${sectionKey} секции расположена вне пересечения дверей!`, "warning")

                if (_element)
                    _element.WARNING = partition.PROPS.FRAME.WARNING

            } else
                delete partition.PROPS.CONFIG.WARNING
        }

        if (_element) {
            checkPosition(_element.objId, _element.SECTION)
        } else {
            angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION, function (partitionID, sectionKey) {
                checkPosition(partitionID, sectionKey)
            })
        }
    }

    this.splitSection = function (
        group,
        sectionNumber) {

        self.clearSectionFilling(group, sectionNumber)
        const KEY = 1

        let product = Object.assign({}, self.getProductInfo(5820274)) //Перегородка секции

        //Смещаем id всех соседних справа секций на 1, а также переносим их наполнения и фасады
        if (group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION?.[sectionNumber]) {
            self.shiftSections(group, sectionNumber, "right")

            angular.forEach(group.PROPS.CONFIG.SECTIONS[sectionNumber]?.SUBELEMENTS, function (item, key) {
                if (item.TYPE == "PARTITION")
                    item.SECTION = sectionNumber + 1
            })
            group.PROPS.CONFIG.SECTIONS[sectionNumber + 1] = Object.assign({}, group.PROPS.CONFIG.SECTIONS[sectionNumber])
            group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS = {}

            group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${sectionNumber + 1}`] = group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${sectionNumber}`]
            delete group.PROPS.CONFIG.BASKET[`SECTIONSFILLING${sectionNumber}`]

            group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION[sectionNumber + 1] = group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION[sectionNumber]
            delete group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION[sectionNumber]

            let tmp_partition = group.getObjectByName("PARTITION_" + (sectionNumber))
            tmp_partition.SECTION = sectionNumber + 1
            tmp_partition.name = `PARTITION_${tmp_partition.SECTION}`
        }
        let partition = self.addSectionPartition(group, product, sectionNumber, KEY)

        const sectionSize = self.getSectionSize(group, sectionNumber)
        const leftPartition = group.getObjectByName("PARTITION_" + (sectionNumber - 1))

        let leftBorder = leftPartition ? leftPartition.POSITION.x + Math.floor(leftPartition.SIZE.width / 2) : 0;
        leftBorder += Math.floor(sectionSize.width / 2)

        let position = leftPartition?.POSITION || new THREE.Vector3()

        var positionValue = self.getSectionMousePositionFromInput(
            group,
            new THREE.Vector3(leftBorder, position.y, position.z),
            partition.PROPS.FRAME
        );
        self.setSectionElementPosition(
            group,
            partition.PROPS.FRAME,
            positionValue,
            group.PROPS.SECTIONCONTROL[sectionNumber - 1],
            KEY
        );

        self.addSectionLogical(group, partition, sectionNumber, KEY)
    }

    //Добавление перегородки секции через настройку наполнения
    this.addSectionPartition = function (
        group,
        newElement,
        sectionNumber,
        elementNumber,
        isVerticalShelf = false
    ) {

        sectionNumber = sectionNumber ? sectionNumber : "1"

        let fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        newElement.MIN_FASADE_SIZE = +newElement.MIN_FASADE_SIZE

        var basketObj = {
            MODULECOLOR: group.PROPS.CONFIG.BASKET.MODULECOLOR,
        };

        basketObj["SIZEEDITWIDTH"] = fasadeThickness

        if (sectionNumber) {
            let sectionSize = self.getSectionSize(group, sectionNumber)
            basketObj["SIZEEDITHEIGHT"] = sectionSize.height;
        }

        if (newElement.SIZE_EDIT_DEPTH_MAX)
            basketObj["SIZEEDITDEPTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITDEPTH"];

        if ([5171728, 5168676].includes(group.PROPS.PRODUCT.ID))
            basketObj["SIZEEDITDEPTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITDEPTH"] - 100;

        var configObj = {
            SIZE: {
                width: basketObj["SIZEEDITWIDTH"],
                depth: basketObj["SIZEEDITDEPTH"] || newElement.depth,
                height: basketObj["SIZEEDITHEIGHT"] || newElement.height,
            },
        };

        var fillingElement = self.createGroup(newElement, false, configObj, basketObj, group, sectionNumber, elementNumber);
        fillingElement.PROPS.FRAME ? fillingElement.PROPS.FRAME : fillingElement.PROPS.FRAME = {}
        fillingElement.PROPS.FRAME.SECTION = sectionNumber || 0;
        fillingElement.PROPS.FRAME.KEY = elementNumber || 0;
        fillingElement.PROPS.FRAME.TYPE = isVerticalShelf ? "VERTICAL_SHELF" : "PARTITION"
        fillingElement.PROPS.FRAME.ELID = newElement.ID;
        fillingElement.PROPS.FRAME.name = isVerticalShelf ? `VERTICAL_SHELF_${sectionNumber}_${elementNumber}` : `PARTITION_${sectionNumber}`;
        fillingElement.PROPS.FRAME.PRODUCT_TYPE = self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE || false;

        group.PROPS.SECTIONSOBJ.push(fillingElement.PROPS.FRAME);

        self.setSubElementProps(
            group,
            fillingElement.PROPS.FRAME,
            group.PROPS.SECTIONCONTROL[fillingElement.PROPS.FRAME.SECTION - 1],
            fillingElement.position,
            fillingElement.PROPS.FRAME.KEY
        );

        const KEY = fillingElement.PROPS.FRAME.KEY
        const SECTION = fillingElement.PROPS.FRAME.SECTION

        if (group.PROPS.SECTIONSOBJ[KEY - 1] && typeof sectionNumber !== 'number') {
            group.PROPS.SECTIONSOBJ[KEY - 1].name = fillingElement.PROPS.FRAME.name; //!!!Проверить, в необходимости
        }

        if (!group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION)
            group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION = {}

        group.PROPS.CONFIG.FASADE_SECTIONS.PARTITION[sectionNumber] = fillingElement.id

        group.add(fillingElement);

        return fillingElement;
    }

    this.getVerticalShelfParams = function (group, product, sectionNumber, elementNumber, props = {}) {
        sectionNumber = sectionNumber ? sectionNumber : "1"

        let fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || product.width || 18

        var basketObj = {
            MODULECOLOR: group.PROPS.CONFIG.BASKET.MODULECOLOR,
        };

        basketObj["SIZEEDITWIDTH"] = fasadeThickness

        if (sectionNumber) {
            let sectionSize = self.getSectionSize(group, sectionNumber)

            if (props.position) {
                const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
                const section = group.PROPS.SECTIONCONTROL.find(item => item.SECTIONNUMBER == sectionNumber)
                let element = group.PROPS.CONFIG.SECTIONS[sectionNumber]?.SUBELEMENTS[elementNumber]

                let bottomObj, topObj;

                let position = props.position.y
                let bottomPos = 0, topPos = sectionSize.height
                if (group.PROPS.CONFIG.SECTIONS[sectionNumber]?.SUBELEMENTS)
                    angular.forEach(Object.values(group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS)?.filter(item => item.PRODUCT_TYPE === "shelf" || item.MANUFACTURER)
                            .sort(function (a, b) {
                                return a.POSITION - b.POSITION
                            }),
                        function (object, key) {
                            let objRelPos = object.position.x - (-group.PROPS.CONFIG.SIZE.width / 2) - fasadeThickness
                            let objHeight = object.FASADE?.size?.height || object.SIZE.height
                            if (elementNumber != object.KEY && (props.position.x < objRelPos + object.SIZE.width / 2 && props.position.x > objRelPos - object.SIZE.width / 2)) {
                                let objPos = object.position.y - (object.MANUFACTURER_OFFSET || 0)
                                if (objPos + objHeight <= position && objPos + objHeight >= bottomPos) {
                                    bottomObj = object
                                    bottomPos = objPos + objHeight
                                } else if (objPos >= position && objPos <= topPos) {
                                    topObj = object
                                    topPos = objPos
                                }
                            }
                        })


                basketObj["SIZEEDITHEIGHT"] = topPos - bottomPos;
                props.position.y = bottomPos

                if (element) {
                    let relative_pos = props.position.x - ((section.position.x - sectionSize.width / 2) - (-group.PROPS.CONFIG.SIZE.width / 2))
                    if (bottomObj) {
                        bottomObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                            id_subelement: element.ID,
                            additive_position: relative_pos,
                            orientation: "top"
                        }

                        element.ADDITIVES[bottomObj.KEY || bottomObj.objId || bottomObj.ID] = {
                            id_subelement: bottomObj.ID,
                            additive_position: relative_pos,
                            orientation: "bottom"
                        }
                    } else {
                        element.ADDITIVES["bottom"] = {
                            id_subelement: false,
                            additive_position: props.position.x,//- (-group.PROPS.CONFIG.SIZE.width / 2) - fasadeThickness,
                            orientation: "bottom"
                        }
                    }

                    if (topObj) {
                        topObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                            id_subelement: element.ID,
                            additive_position: props.position.x - ((section.position.x - topObj.SIZE.width / 2) - (-group.PROPS.CONFIG.SIZE.width / 2)),
                            orientation: "bottom"
                        }

                        element.ADDITIVES[topObj.KEY || topObj.objId || topObj.ID] = {
                            id_subelement: topObj.ID,
                            additive_position: relative_pos,
                            orientation: "top"
                        }
                    } else {
                        element.ADDITIVES["top"] = {
                            id_subelement: false,
                            additive_position: props.position.x,//- (-group.PROPS.CONFIG.SIZE.width / 2) - fasadeThickness,
                            orientation: "top"
                        }
                    }
                }
            } else {
                basketObj["SIZEEDITHEIGHT"] = sectionSize.height;
            }
        }

        if (product.SIZE_EDIT_DEPTH_MAX)
            basketObj["SIZEEDITDEPTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITDEPTH"];

        if ([5171728, 5168676].includes(group.PROPS.PRODUCT.ID))
            basketObj["SIZEEDITDEPTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITDEPTH"] - 100;

        var configObj = {
            SIZE: {
                width: basketObj["SIZEEDITWIDTH"],
                depth: basketObj["SIZEEDITDEPTH"] || product.depth,
                height: basketObj["SIZEEDITHEIGHT"] || product.height,
            },
        };

        return {configObj, basketObj}
    }

    this.getSubelementParams = function (group, product, sectionNumber, elementNumber, props = {}) {
        var basketObj = {}, configObj = {};
        const PRODUCT_TYPE = self.scope.app.PRODUCTS_TYPES[product.productType]?.CODE || false;
        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        if (sectionNumber) {
            let sectionSize = self.getSectionSize(group, sectionNumber)
            let element = props.element || group.PROPS.CONFIG.SECTIONS[sectionNumber]?.SUBELEMENTS?.[elementNumber]

            if (props.position) {
                const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
                const section = group.PROPS.SECTIONCONTROL.find(item => item.SECTIONNUMBER == sectionNumber)

                let leftObj, rightObj;

                let position = props.position.x
                let sectionPos = section.position.x - (-group.PROPS.CONFIG.SIZE.width / 2);
                let leftPos = sectionPos - sectionSize.width / 2, rightPos = sectionPos + sectionSize.width / 2

                if (group.PROPS.CONFIG.SECTIONS[sectionNumber]?.SUBELEMENTS)
                    angular.forEach(Object.values(group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS)?.filter(item => item.PRODUCT_TYPE === "vertical_shelf").sort(function (a, b) {
                            return a.POSITION - b.POSITION
                        }),
                        function (object, key) {
                            if (elementNumber != object.KEY && (props.position.y < object.position.y + object.SIZE.height && props.position.y > object.position.y)) {
                                let objPos = object.position.x
                                if (objPos + object.SIZE.width / 2 <= position && objPos + object.SIZE.width / 2 >= leftPos) {
                                    leftObj = object
                                    leftPos = objPos + object.SIZE.width * 1.5
                                } else if (objPos - object.SIZE.width / 2 >= position && objPos - object.SIZE.width / 2 <= rightPos) {
                                    rightObj = object
                                    rightPos = objPos + object.SIZE.width / 2
                                }
                            }
                        })


                basketObj["SIZEEDITWIDTH"] = rightPos - leftPos;
                props.position.x = (-group.PROPS.CONFIG.SIZE.width / 2) + leftPos + basketObj["SIZEEDITWIDTH"] / 2

                if (element && element.SIZE) {
                    if (!element.ADDITIVES)
                        element.ADDITIVES = {}

                    if (leftObj) {
                        let relative_pos = leftObj.SIZE.height - ((leftObj.position.y + leftObj.SIZE.height) - (props.position.y - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2)))

                        leftObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                            id_subelement: element.ID,
                            additive_position: relative_pos,
                            orientation: "right"
                        }

                        element.ADDITIVES[leftObj.KEY || leftObj.objId || leftObj.ID] = {
                            id_subelement: leftObj.ID,
                            additive_position: relative_pos,
                            orientation: "left"
                        }
                    } else {
                        element.ADDITIVES["left"] = {
                            id_subelement: false,
                            additive_position: props.position.y - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2),
                            orientation: "left"
                        }
                    }

                    if (rightObj) {
                        let relative_pos = rightObj.SIZE.height - ((rightObj.position.y + rightObj.SIZE.height) - (props.position.y - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2)))

                        rightObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                            id_subelement: element.ID,
                            additive_position: relative_pos,
                            orientation: "left"
                        }

                        element.ADDITIVES[rightObj.KEY || rightObj.objId || rightObj.ID] = {
                            id_subelement: rightObj.ID,
                            additive_position: relative_pos,
                            orientation: "right"
                        }
                    } else {
                        element.ADDITIVES["right"] = {
                            id_subelement: false,
                            additive_position: props.position.y - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2),
                            orientation: "right"
                        }
                    }
                }
            } else {
                basketObj["SIZEEDITWIDTH"] = sectionSize.width || group.PROPS.CONFIG.BASKET["SECTIONS" + sectionNumber];
            }
        } else
            basketObj["SIZEEDITWIDTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITWIDTH"];

        if (product.SIZE_EDIT_DEPTH_MAX) {
            basketObj["SIZEEDITDEPTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITDEPTH"];

            if ([5171728, 5168676].includes(group.PROPS.PRODUCT.ID))
                basketObj["SIZEEDITDEPTH"] -= 100;
        }

        var configObj = {
            SIZE: {
                width: basketObj["SIZEEDITWIDTH"],
                depth: basketObj["SIZEEDITDEPTH"] || product.depth,
                height: PRODUCT_TYPE === "shelf" ? fasadeThickness : basketObj["SIZEEDITHEIGHT"] || product.height,
            },
        };

        return {configObj, basketObj}
    }

    this.calcSubElementsAdditives = function (group) {
        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        angular.forEach(group.PROPS.CONFIG.SECTIONS, function (sectionConf, sectionNumber) {
            if (sectionConf.SUBELEMENTS)
                angular.forEach(sectionConf.SUBELEMENTS, function (element, elementNumber) {
                    element.ADDITIVES = {}
                })
        })

        angular.forEach(group.PROPS.CONFIG.SECTIONS, function (sectionConf, sectionNumber) {
            const SECTIONCONTROL = group.PROPS.SECTIONCONTROL.find(item => item.SECTIONNUMBER == sectionNumber)

            if (sectionConf.SUBELEMENTS && SECTIONCONTROL) {
                const sectionSize = self.getSectionSize(group, sectionNumber)
                angular.forEach(sectionConf.SUBELEMENTS, function (element, elementNumber) {
                    const product = Object.assign({}, self.getProductInfo(element.ID))
                    const PRODUCT_TYPE = self.scope.app.PRODUCTS_TYPES[product.productType]?.CODE || false;

                    if (element.position) {

                        let leftObj, rightObj, bottomObj, topObj;

                        let positionX = element.position.x
                        let positionY = element.position.y

                        let sectionPos = SECTIONCONTROL.position.x - (-group.PROPS.CONFIG.SIZE.width / 2);

                        let leftPos = sectionPos - sectionSize.width / 2 - fasadeThickness,
                            rightPos = sectionPos + sectionSize.width / 2 - fasadeThickness,
                            bottomPos = 0,
                            topPos = sectionSize.height

                        if (!["vertical_shelf", "section_partition"].includes(element.PRODUCT_TYPE)) {
                            positionX = element.position.x - (-group.PROPS.CONFIG.SIZE.width / 2)

                            angular.forEach(Object.values(group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS)?.filter(item => item.PRODUCT_TYPE === "vertical_shelf")
                                    .sort(function (a, b) {
                                        return a.POSITION - b.POSITION
                                    }),
                                function (object, key) {
                                    if (elementNumber != object.KEY && (positionY < object.position.y + object.SIZE.height && positionY > object.position.y)) {
                                        let objPos = object.position.x

                                        if (objPos + object.SIZE.width / 2 <= positionX && objPos + object.SIZE.width / 2 >= leftPos) {
                                            leftObj = object
                                            leftPos = objPos + object.SIZE.width * 1.5
                                        }

                                        if (objPos - object.SIZE.width / 2 >= positionX && objPos - object.SIZE.width / 2 <= rightPos) {
                                            rightObj = object
                                            rightPos = objPos + object.SIZE.width / 2
                                        }
                                    }
                                })

                            if (leftObj) {
                                let relative_pos = leftObj.SIZE.height - ((leftObj.position.y + leftObj.SIZE.height) - (positionY - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2)))

                                leftObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                                    id_subelement: element.ID,
                                    additive_position: relative_pos,
                                    orientation: "right",
                                    section: +sectionNumber,
                                }

                                element.ADDITIVES[leftObj.KEY || leftObj.objId || leftObj.ID] = {
                                    id_subelement: leftObj.ID,
                                    additive_position: relative_pos,
                                    orientation: "left",
                                    section: +sectionNumber,
                                }

                                delete element.ADDITIVES["left"]

                            } else {
                                if (group.PROPS.CONFIG.SECTIONS[sectionNumber - 1]?.SUBELEMENTS?.[1] && group.PROPS.CONFIG.SECTIONS[sectionNumber - 1].SUBELEMENTS[1].PRODUCT_TYPE === "section_partition") {
                                    leftObj = group.PROPS.CONFIG.SECTIONS[sectionNumber - 1].SUBELEMENTS[1]
                                    let relative_pos = leftObj.SIZE.height - ((leftObj.position.y + leftObj.SIZE.height) - (positionY - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2)))

                                    element.ADDITIVES[`${sectionNumber - 1}_${leftObj.KEY || leftObj.objId || leftObj.ID}`] = {
                                        id_subelement: leftObj.ID,
                                        additive_position: relative_pos,
                                        orientation: "left",
                                        section: +sectionNumber - 1,
                                    }
                                    delete element.ADDITIVES["left"]

                                    leftObj.ADDITIVES[`${sectionNumber}_${elementNumber || element.objId || element.ID}`] = {
                                        id_subelement: element.ID,
                                        additive_position: relative_pos,
                                        orientation: "right",
                                        section: +sectionNumber,
                                    }
                                } else
                                    element.ADDITIVES["left"] = {
                                        id_subelement: false,
                                        additive_position: positionY - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2),
                                        orientation: "left"
                                    }
                            }

                            if (rightObj) {
                                let relative_pos = rightObj.SIZE.height - ((rightObj.position.y + rightObj.SIZE.height) - (positionY - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2)))

                                let righAdditiveName = elementNumber || element.objId || element.ID;
                                rightObj.ADDITIVES[righAdditiveName] = {
                                    id_subelement: element.ID,
                                    additive_position: relative_pos,
                                    orientation: "left",
                                    section: +sectionNumber,
                                }

                                element.ADDITIVES[rightObj.KEY || rightObj.objId || rightObj.ID] = {
                                    id_subelement: rightObj.ID,
                                    additive_position: relative_pos,
                                    orientation: "right",
                                    section: +sectionNumber,
                                }

                                delete element.ADDITIVES["right"]

                            } else {
                                if (group.PROPS.CONFIG.BASKET[`SECTIONS${+sectionNumber + 1}`] && group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[1].PRODUCT_TYPE === "section_partition") {
                                    rightObj = group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[1]
                                    let relative_pos = rightObj.SIZE.height - ((rightObj.position.y + rightObj.SIZE.height) - (positionY - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2)))

                                    element.ADDITIVES[`${sectionNumber}_${rightObj.KEY || rightObj.objId || rightObj.ID}`] = {
                                        id_subelement: rightObj.ID,
                                        additive_position: relative_pos,
                                        orientation: "right",
                                        section: +sectionNumber,
                                    }
                                    delete element.ADDITIVES["right"]

                                    rightObj.ADDITIVES[`${sectionNumber}_${elementNumber || element.objId || element.ID}`] = {
                                        id_subelement: element.ID,
                                        additive_position: relative_pos,
                                        orientation: "left",
                                        section: +sectionNumber,
                                    }
                                } else
                                    element.ADDITIVES["right"] = {
                                        id_subelement: false,
                                        additive_position: positionY - (element.MANUFACTURER_OFFSET || -element.SIZE.height / 2),
                                        orientation: "right"
                                    }
                            }
                        } else {
                            angular.forEach(Object.values(group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS)?.filter(item => item.PRODUCT_TYPE === "shelf" || item.MANUFACTURER)
                                    .sort(function (a, b) {
                                        return a.POSITION - b.POSITION
                                    }),
                                function (object, key) {
                                    let objRelPos = object.position.x - (-group.PROPS.CONFIG.SIZE.width / 2) - fasadeThickness
                                    let objHeight = object.FASADE?.size?.height || object.SIZE.height
                                    if (elementNumber != object.KEY && (positionX < objRelPos + object.SIZE.width / 2 && positionX > objRelPos - object.SIZE.width / 2)) {
                                        let objPos = object.position.y - (object.MANUFACTURER_OFFSET || 0)
                                        if (objPos + objHeight <= positionY && objPos + objHeight >= bottomPos) {
                                            bottomObj = object
                                            bottomPos = objPos + objHeight
                                        }

                                        if (objPos >= positionY && objPos <= topPos) {
                                            topObj = object
                                            topPos = objPos
                                        }
                                    }
                                })

                            let relative_posX = positionX - ((SECTIONCONTROL.position.x - sectionSize.width / 2) - (-group.PROPS.CONFIG.SIZE.width / 2)) + fasadeThickness
                            if (bottomObj) {
                                let bottomObjPositionX = bottomObj.position.x - (-group.PROPS.CONFIG.SIZE.width / 2) - bottomObj.SIZE.width / 2 - fasadeThickness
                                let relative_pos = relative_posX - (bottomObjPositionX - leftPos)

                                bottomObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                                    id_subelement: element.ID,
                                    additive_position: relative_pos,
                                    orientation: "top",
                                    section: +sectionNumber,
                                }

                                element.ADDITIVES[bottomObj.KEY || bottomObj.objId || bottomObj.ID] = {
                                    id_subelement: bottomObj.ID,
                                    additive_position: relative_pos,
                                    orientation: "bottom",
                                    section: +sectionNumber,
                                }

                                delete element.ADDITIVES["bottom"]

                            } else {
                                element.ADDITIVES["bottom"] = {
                                    id_subelement: false,
                                    additive_position: positionX,
                                    orientation: "bottom"
                                }
                            }

                            if (topObj) {
                                let topObjPositionX = topObj.position.x - (-group.PROPS.CONFIG.SIZE.width / 2) - topObj.SIZE.width / 2 - fasadeThickness
                                let relative_pos = relative_posX - (topObjPositionX - leftPos)

                                topObj.ADDITIVES[elementNumber || element.objId || element.ID] = {
                                    id_subelement: element.ID,
                                    additive_position: relative_pos,
                                    orientation: "bottom",
                                    section: +sectionNumber,
                                }

                                element.ADDITIVES[topObj.KEY || topObj.objId || topObj.ID] = {
                                    id_subelement: topObj.ID,
                                    additive_position: relative_pos,
                                    orientation: "top",
                                    section: +sectionNumber,
                                }

                                delete element.ADDITIVES["top"]

                            } else {
                                element.ADDITIVES["top"] = {
                                    id_subelement: false,
                                    additive_position: positionX,
                                    orientation: "top"
                                }
                            }
                        }

                    }

                })
            }
        })
    }

    this.addSubElementToElement = function (
        group,
        newElement,
        sectionNumber,
        elementNumber,
        props = {}
    ) {

        const isSectionPartition = ["section_partition"].includes(self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE) || false
        const isVerticalShelf = ["vertical_shelf"].includes(self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE) || false
        const isHiTechProfile = self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE.includes("hi_tech_profile") || false
        const isBottomHiTechProfile = isHiTechProfile && self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE.includes("bottom") || false

        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        if (isSectionPartition) {
            return self.addSectionPartition(group, newElement, sectionNumber, elementNumber, isVerticalShelf)
        }

        const MANUFACTURER_OFFSET_LIST = {
            innotech: 31,
            иннотех: 31,
            avantech: 29.25,
            авантех: 29.25,
            flowbox: 25,
            флоубокс: 25,
        }

        newElement.MIN_FASADE_SIZE = +newElement.MIN_FASADE_SIZE
        var basketObj = {}, configObj = {};

        if (isVerticalShelf) {
            let params = self.getVerticalShelfParams(group, newElement, sectionNumber, elementNumber, props)
            configObj = params.configObj
            basketObj = params.basketObj

            if (newElement.SIZE_EDIT_HEIGHT_MIN && configObj.SIZE.height < newElement.SIZE_EDIT_HEIGHT_MIN) {
                self.alert(`Высота ${newElement.NAME} меньше ${newElement.SIZE_EDIT_HEIGHT_MIN}!`, "error")
                basketObj.MODULECOLOR = self.scope.fasadeErrorColor
            }
        } else {
            let position = false

            if (props.position) {
                position = Object.assign({}, props.position)
                position.x = position.x - (-group.PROPS.CONFIG.SIZE.width / 2)
            }

            let params = self.getSubelementParams(group, newElement, sectionNumber, elementNumber, {position})
            configObj = params.configObj
            basketObj = params.basketObj

            if (isHiTechProfile) {

                if (!isBottomHiTechProfile && !self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE.includes("section"))
                    basketObj["SIZEEDITWIDTH"] = group.PROPS.CONFIG.BASKET["SECTIONS" + sectionNumber] + fasadeThickness * 2 || group.PROPS.CONFIG.SIZE.width

                basketObj["SIZEEDITHEIGHT"] = newElement.height || fasadeThickness

                if (!group.PROPS.CONFIG.BASKET.PROFILECOLOR && newElement.COLOR[0] != null)
                    group.PROPS.CONFIG.BASKET.PROFILECOLOR = newElement.COLOR[0]

                basketObj.COLOR = group.PROPS.CONFIG.BASKET.PROFILECOLOR ? group.PROPS.CONFIG.BASKET.PROFILECOLOR : group.PROPS.CONFIG.BASKET.MODULECOLOR

                configObj.SIZE.width = basketObj["SIZEEDITWIDTH"]
                configObj.SIZE.height = basketObj["SIZEEDITHEIGHT"]
                configObj.isProfile = true
            } else {
                props.position = position
                basketObj.MODULECOLOR = group.PROPS.CONFIG.BASKET.MODULECOLOR
            }
        }

        var fillingElement = self.createGroup(newElement, false, configObj, basketObj, group, sectionNumber, elementNumber);
        fillingElement.PROPS.FRAME ? fillingElement.PROPS.FRAME : fillingElement.PROPS.FRAME = {}
        fillingElement.PROPS.FRAME.SECTION = sectionNumber || 0;
        fillingElement.PROPS.FRAME.KEY = elementNumber || 0;
        fillingElement.PROPS.FRAME.TYPE = "SUBELEMENT"
        fillingElement.PROPS.FRAME.ELID = newElement.ID;
        fillingElement.PROPS.FRAME.MANUFACTURER = newElement.EN_NAME?.toLowerCase().split(/\s|,/).shift() || newElement.NAME?.toLowerCase().split(/\s|,/).shift();
        fillingElement.PROPS.FRAME.MANUFACTURER_OFFSET = MANUFACTURER_OFFSET_LIST[fillingElement.PROPS.FRAME.MANUFACTURER] || false;
        fillingElement.PROPS.FRAME.name = `${fillingElement.PROPS.FRAME.TYPE}_${sectionNumber}_${elementNumber}`;
        fillingElement.PROPS.FRAME.PRODUCT_TYPE = self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE || false;

        if (!fillingElement.PROPS.FRAME.MANUFACTURER_OFFSET) {
            delete fillingElement.PROPS.FRAME.MANUFACTURER
            delete fillingElement.PROPS.FRAME.MANUFACTURER_OFFSET
        }

        if (isHiTechProfile) {
            fillingElement.PROPS.FRAME.isProfile = true
        }

        if (basketObj.MODULECOLOR === self.scope.fasadeErrorColor && newElement.SIZE_EDIT_HEIGHT_MIN && configObj.SIZE.height < newElement.SIZE_EDIT_HEIGHT_MIN) {
            fillingElement.PROPS.FRAME.ERROR = 6922766;
        }

        if (isBottomHiTechProfile) {
            fillingElement.PROPS.FRAME.SIZE.depth -= 0.1

            if (!group.PROPS.CONFIG.BASKET.OPTION?.includes(4722965)) {
                self.alert("Г-образный профиль доступен только для навесного модуля", "error")
                fillingElement.PROPS.FRAME.ERROR = 7262796;
            }
        }
        group.PROPS.SECTIONSOBJ.push(fillingElement.PROPS.FRAME);
        group.add(fillingElement);

        let frame = Object.assign({}, fillingElement.PROPS.FRAME)
        frame.isDrawerShelv = newElement.isDrawerShelv || false

        if (group.PROPS.CONFIG.sideHiTechProfile && isHiTechProfile) {
            self.alert("Горизонтальный профиль не может быть использован вместе с боковым!", "error")
            fillingElement.PROPS.CONFIG.ERROR = frame.ERROR = 6448294;
        }

        self.setSubElementProps(
            group,
            frame,
            group.PROPS.SECTIONCONTROL[fillingElement.PROPS.FRAME.SECTION - 1],
            fillingElement.position,
            fillingElement.PROPS.FRAME.KEY
        );

        const KEY = fillingElement.PROPS.FRAME.KEY
        const SECTION = fillingElement.PROPS.FRAME.SECTION

        if (group.PROPS.SECTIONSOBJ[KEY - 1] && typeof sectionNumber !== 'number') {
            group.PROPS.SECTIONSOBJ[KEY - 1].name = fillingElement.PROPS.FRAME.name; //!!!Проверить, в необходимости
        }
        group.add(fillingElement);

        return fillingElement;
    };

    this.changeBoxFasadeSize = function (group, section, elKey) {
        if (self.scope.app.active.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section]) {
            delete group.PROPS.CONFIG.recalcFasadeHeight

            const active_box = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][elKey]
            let maxElementHeight = self.getMaxExternalFasadeSize(group, section, elKey)

            if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][elKey].SIZE > maxElementHeight) {
                group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][elKey].SIZE = maxElementHeight
            }

            const productId = group.PROPS.CONFIG.SECTIONS[section].SUBELEMENTS[elKey].ID
            var product = self.getProductInfo(productId);
            if (active_box.SIZE < product.MIN_FASADE_SIZE) {
                group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][elKey].SIZE = product.MIN_FASADE_SIZE
            }

            self.controlBoxesPosition(group)
            self.controlFasadeCount(self.scope.app.active, section)
            self.updateElement(group)
        }
    }

    this.createPhantomFasade = function (group, section, _doorKey) {
        if (!group.PROPS.PHANTOM_FASADE)
            group.PROPS.PHANTOM_FASADE = {}

        group.remove(group.PROPS.FASADE[section]);

        if (group.PROPS.PHANTOM_FASADE && group.PROPS.PHANTOM_FASADE[section]) {
            group.remove(group.PROPS.PHANTOM_FASADE[section])
            //!!!Можно добавить удаление фасада
        }

        const CONFIG = group.PROPS.CONFIG
        const AVAILABLE_FASADES = CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section];
        const obj = new THREE.Object3D()

        const create = (fasades, doorKey) => {
            //const takeFasadePosition = self.scope.app.FASADE_POSITION[CONFIG.FASADELIST[section]];
            let takeFasadePosition = this.getFasadePosition(group, section, doorKey)

            angular.forEach(fasades, function (fasade, i) {
                const start_position = self.getStartPosition(self.getProductSize(group.PROPS));
                const new_start_position = JSON.parse(JSON.stringify(start_position))

                const basketKey = self.getBasketFasadeKey(group, section, i, doorKey)

                new_start_position.y = fasade.position
                takeFasadePosition.FASADE_HEIGHT = fasade.size?.height || fasade.size
                takeFasadePosition.POSITION_Y = 0

                let color = 5726133 //192422//

                const isPhantom = true
                const itsBoxFasade = fasade.external_box

                if (fasade.basket_key !== false) {
                    const new_fasade = self.createFasade(takeFasadePosition, new_start_position, color, group, basketKey, isPhantom, itsBoxFasade, doorKey)
                    if (new_fasade) {
                        obj.add(new_fasade)
                    }
                }
            })
        }

        if (_doorKey) {
            angular.forEach(AVAILABLE_FASADES, function (door, doorKey) {
                create(door, doorKey)
            })
        } else {
            create(AVAILABLE_FASADES)
        }

        group.PROPS.PHANTOM_FASADE[section] = obj

        group.add(obj)
    }


    this.calcLoopPositions = function (group, fasades, fasadePositions, section, product) {

        const CONFIG = group

        if (group.PROPS && !group.PROPS.PRODUCT.moduleType || !product.moduleType) {

            let loops_arr = []

            if (group.models[0] && self.scope.app.MODELS[group.models[0]]?.loop_model) {
                angular.forEach(CONFIG.FASADELIST, function (section, k) {

                    if (group.LOOPS?.[k]) {
                        group.remove(group.LOOPS[k])
                    }

                    let PROPS = group.PROPS || {CONFIG, PRODUCT: product}

                    let size = self.getProductSize(PROPS)

                    const loops = self.createLoop(product, {PROPS}, group, k, false) || []
                    loops.reverse()

                    loops_arr.push(...loops)
                })
            }

            return loops_arr
        }

        let allLoops = []

        const fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        const defaultPos = 102
        const lowSizePos1 = 74
        const lowSizePos2 = 93

        angular.forEach(fasades, function (fasadeSize, key) {

            const quarterPos = fasadeSize / 4
            const oneThirdPos = fasadeSize / 3
            const secondPos = fasadeSize / 2

            const position = fasadePositions[key]

            //исключения по размерам
            if (fasadeSize === 2036) {
                //Отступ 658 от краев фасада
                allLoops = []
                allLoops.push((position + defaultPos).toFixed(1))
                allLoops.push((position + 658).toFixed(1))
                allLoops.push((position + fasadeSize - 658).toFixed(1))
                allLoops.push((position + fasadeSize - defaultPos).toFixed(1))
            } else if (fasadeSize === 536) {
                //Отступ 93 от краев фасада
                allLoops = []
                allLoops.push((position + lowSizePos2).toFixed(1))
                allLoops.push((position + fasadeSize - lowSizePos2).toFixed(1))
            }//
            else if (fasadeSize >= 2064) {
                allLoops.push((position + defaultPos).toFixed(1))
                allLoops.push((position + quarterPos).toFixed(1))
                allLoops.push((position + quarterPos * 2).toFixed(1))
                allLoops.push((position + quarterPos * 3).toFixed(1))
                allLoops.push((position + fasadeSize - defaultPos).toFixed(1))
            } else if (fasadeSize < 2064 && fasadeSize > 1500) {
                allLoops.push((position + defaultPos).toFixed(1))
                allLoops.push((position + oneThirdPos).toFixed(1))
                allLoops.push((position + oneThirdPos * 2).toFixed(1))
                allLoops.push((position + fasadeSize - defaultPos).toFixed(1))
            } else if (fasadeSize <= 1500 && fasadeSize > 1000) {
                allLoops.push((position + defaultPos).toFixed(1))
                allLoops.push((position + secondPos).toFixed(1))
                allLoops.push((position + fasadeSize - defaultPos).toFixed(1))
            } else if (fasadeSize <= 1000 && fasadeSize > 400) {
                allLoops.push((position + defaultPos).toFixed(1))
                allLoops.push((position + fasadeSize - defaultPos).toFixed(1))
            } else if (400 >= fasadeSize && fasadeSize >= 360) {
                allLoops.push((position + lowSizePos1).toFixed(1))
                allLoops.push((position + fasadeSize - lowSizePos1).toFixed(1))
            }
        })

        const loopPositions = allLoops.map((item) => fasadePosToFloorPos(+item))

        function fasadePosToFloorPos(position) {
            let newPos
            const moduleHeight = CONFIG.SIZE.height

            newPos = moduleHeight / 2 + position
            return newPos
        }

        return loopPositions
    }

    this.convertRealToBasketLoopPos = function (positions, CONFIG) {
        const new_positions = []
        const fasadeThickness = CONFIG.BASKET?.PLINTH_HEIGHT === 0 ? CONFIG.BASKET.PLINTH_HEIGHT : self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        angular.forEach(positions, function (position) {

            const horizonHeight = CONFIG.BASKET.HORIZONT === 0 ? 0 : CONFIG.BASKET.HORIZONT
            const new_pos = position - horizonHeight - fasadeThickness
            new_positions.push(new_pos)
        })
        return new_positions
    }

    this.addFasadeToBox = function (group, box, product) {
        const CONFIG = group.PROPS.CONFIG
        const section = box.PROPS.FRAME.SECTION
        const key = box.PROPS.FRAME.KEY

        //удаляем составной фасад !!!Можно удалить
        if (CONFIG['COMPOSITE_FASADE' + section]) {
            self.alert('Внимание, составной фасад удален!')
            delete CONFIG['COMPOSITE_FASADE' + section]
        }

        if (!CONFIG.FASADE_SECTIONS.BOX_FASADE[section]) CONFIG.FASADE_SECTIONS.BOX_FASADE[section] = {}
        if (!CONFIG.FASADE_SECTIONS.BOX_FASADE[section]?.[key]) {
            const newBox = {
                POSITION: box.PROPS.FRAME.POSITION,
                SIZE: product.MIN_FASADE_SIZE ? product.MIN_FASADE_SIZE : product.height ? product.height + 2 : 360,
                FASADE: null,
                KEY: key,
                MANUFACTURER: box.PROPS.FRAME.MANUFACTURER || "",
                MANUFACTURER_OFFSET: box.PROPS.FRAME.MANUFACTURER_OFFSET || 0,
                //если создается первый ящик с фасадом, привязываем нулевой фасад(первый),
                //а если уже есть ящики с фасадом, мы даем ключ нового фасада, далее добавляем новый фасад для ящика. в другой функции
            }
            group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][key] = newBox
        }
    }

    this.addProfileToFasades = function (group, profile, product) {
        const CONFIG = group.PROPS.CONFIG
        const section = profile.PROPS.FRAME.SECTION
        const key = profile.PROPS.FRAME.KEY

        //удаляем составной фасад !!!Можно удалить
        if (CONFIG['COMPOSITE_FASADE' + section]) {
            self.alert('Внимание, составной фасад удален!')
            delete CONFIG['COMPOSITE_FASADE' + section]
        }

        if (!CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES)
            CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES = {}

        if (!CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section])
            CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section] = {}

        let typeProfile = product.NAME.toLowerCase().split("-")[0].replace(/\s/g, '')
        if (typeProfile !== "c" && typeProfile !== "l")
            typeProfile = typeProfile.split(",").pop().replace(/\s/g, '')

        if (!CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section]?.[key]) {
            const newProfile = {
                POSITION: profile.PROPS.FRAME.POSITION,
                SIZE: product.height,
                KEY: key,
                COLOR: profile.PROPS.CONFIG.BASKET.COLOR,
                isProfile: true,
                otstup: typeProfile == "c" ? 36 : typeProfile == "l" ? 38 : 0,
                MANUFACTURER_OFFSET: typeProfile == "c" ? -18.5 : typeProfile == "l" ? -19.5 : 0,
                TYPE_PROFILE: typeProfile,
            }
            group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section][key] = newProfile
        }
    }

    this.calcSideHiTechProfile = function (group, fasadeNumber, deleteFlag = false) {

        //Удалить все горизонтальные профили, при включении бокового
        /*let horizontProfile = group.PROPS.SECTIONSOBJ.find(item => item.isProfile) || false
        if (horizontProfile)
            self.alert("Горизонтальный профиль не может быть использован вместе с боковым!", "error")

        while (horizontProfile){
            self.deleteSubElementToElement(group, horizontProfile.SECTION, horizontProfile.KEY)
            horizontProfile = group.PROPS.SECTIONSOBJ.find(item => item.isProfile) || false
        }*/

        if (!group.PROPS.CONFIG.BASKET.SIDEPROFILE)
            group.PROPS.CONFIG.BASKET.SIDEPROFILE = {}

        if (deleteFlag) {
            self.removeSideProfile(group, fasadeNumber)
            delete group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber]
        } else {
            self.createSideProfile(group, fasadeNumber)
        }

        self.rebuildWrap(group)
    }

    this.updateSideHiTechProfile = function (group, fasadeNumber) {
        if (!group.PROPS.CONFIG.BASKET.SIDEPROFILE)
            group.PROPS.CONFIG.BASKET.SIDEPROFILE = {}

        if (fasadeNumber !== undefined) {
            self.updateElement(group)
            /*self.removeSideProfile(group, fasadeNumber)
            self.createSideProfile(group, fasadeNumber)*/
        } else {
            let profileCount = Object.keys(group.PROPS.CONFIG.BASKET.SIDEPROFILE)
            profileCount.forEach(key => self.removeSideProfile(group, key))
            profileCount.forEach(key => self.createSideProfile(group, key))
        }
    }

    this.createSideProfile = function (group, fasadeNumber = "1", doorKey) {

        let horizontProfile = group.PROPS.SECTIONSOBJ.find(item => item.isProfile) || false
        if (horizontProfile)
            self.alert("Горизонтальный профиль не может быть использован вместе с боковым!", "error")

        const product = self.scope.app.CATALOG.PRODUCTS[group.PROPS.CONFIG.BASKET.SIDEPROFILE?.[fasadeNumber]?.PRODUCT_ID] || self.scope.app.CATALOG.PRODUCTS[6513251] //C - образный профиль

        if (!group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber])
            group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber] = {PRODUCT_ID: product.ID}

        var basketObj = {};
        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        const typeProfile = product.NAME.toLowerCase().split("-")[0].replace(/\s/g, '')

        basketObj["SIZEEDITWIDTH"] = group.PROPS.CONFIG.SIZE.height
        basketObj["SIZEEDITHEIGHT"] = product.height

        if (!group.PROPS.CONFIG.BASKET.PROFILECOLOR && product.COLOR[0] != null)
            group.PROPS.CONFIG.BASKET.PROFILECOLOR = product.COLOR[0]

        basketObj.COLOR = group.PROPS.CONFIG.BASKET.PROFILECOLOR ? group.PROPS.CONFIG.BASKET.PROFILECOLOR : group.PROPS.CONFIG.BASKET.MODULECOLOR

        var configObj = {
            SIZE: {
                width: basketObj["SIZEEDITWIDTH"],
                depth: product.depth,
                height: basketObj["SIZEEDITHEIGHT"] || product.height,
            },
            isProfile: true,
        };

        var fillingElement = self.createGroup(product, false, configObj, basketObj, group, fasadeNumber, 0);
        fillingElement.PROPS.FRAME ? fillingElement.PROPS.FRAME : fillingElement.PROPS.FRAME = {}
        fillingElement.PROPS.FRAME.SECTION = fasadeNumber || 0;
        fillingElement.PROPS.FRAME.TYPE = "SIDE_PROFILE"
        fillingElement.PROPS.FRAME.ELID = product.ID;
        fillingElement.PROPS.FRAME.name = `${fillingElement.PROPS.FRAME.TYPE}_${fasadeNumber}`;
        fillingElement.PROPS.FRAME.PRODUCT_TYPE = self.scope.app.PRODUCTS_TYPES[product.productType]?.CODE || false;

        fillingElement.rotation.z = -Math.PI / 2

        let fasade_position = self.getFasadePosition(group, fasadeNumber, doorKey);
        let start_position = self.getStartPosition(self.getProductSize(group.PROPS));

        let widthOffset = typeProfile == "c" ? -18.5 : typeProfile == "l" ? -19.5 : 0

        const moduleSide = group.PROPS.CONFIG.BASKET.LOOPSSIDE?.[fasadeNumber] || group.PROPS.CONFIG.BASKET.FASADEALIGN
        switch (moduleSide) {
            case "left":
            case 4693746:
                fillingElement.PROPS.FRAME.MANUFACTURER_OFFSET = new THREE.Vector3(typeProfile == "c" ? widthOffset - 2.5 : 0, 0, 0)
                widthOffset = fasade_position.POSITION_X + fasade_position.FASADE_WIDTH + product.height / 2 + widthOffset
                group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber].SIDE = "right"

                widthOffset += typeProfile == "c" ? 1.5 : 3.5

                break;
            default:
                fillingElement.PROPS.FRAME.MANUFACTURER_OFFSET = new THREE.Vector3(typeProfile == "c" ? widthOffset - 3 : 0, 0, 0)
                widthOffset = fasade_position.POSITION_X - product.height / 2 - widthOffset
                fillingElement.scale.y *= -1
                group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber].SIDE = "left"

                if (group.PROPS.CONFIG.POS_CORRECTION?.x > 0)
                    widthOffset += group.PROPS.CONFIG.POS_CORRECTION.x + fasade_position.FASADE_DEPTH

                widthOffset -= typeProfile == "c" ? 3.5 : 5.5

                break;
        }

        start_position.x += widthOffset
        start_position.y += group.PROPS.CONFIG.SIZE.height / 2
        start_position.z += group.PROPS.CONFIG.SIZE.depth - product.depth / 2


        fillingElement.position.copy(start_position)
        fillingElement.updateMatrix()
        fillingElement.updateMatrixWorld()
        fillingElement.unionBoudingBox = new THREE.Box3().setFromObject(fillingElement) //self.calculateUnionBoundingBox(fillingElement)

        fillingElement.PROPS.WRAP.material.color = new THREE.Color("#cc34eb")
        group.add(fillingElement);
        group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber].objId = fillingElement.id

        self.extrudeModuleProfile(group)
        self.unionWrap(group, fillingElement)
    }

    this.removeSideProfile = function (group, fasadeNumber) {

        const product = group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber]?.objId

        if (!product)
            return

        const object = group.getObjectById(product)

        delete group.PROPS.CONFIG.BASKET.SIDEPROFILE[fasadeNumber].objId
        group.remove(object)
        self.scene.remove(object)
    }

    this.getFilteredAvailableFasades = function (group, section, doorKey = false) {
        let AVAILABLE_FASADES = doorKey ? group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES?.[section]?.[doorKey] || {} : group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES?.[section] || {}

        let tmp_obj = {}
        angular.forEach(AVAILABLE_FASADES, function (item, key) {
            if (item.basket_key !== false)
                tmp_obj[key] = item
        })

        return tmp_obj
    }

    this.controlFasadeCount = function (group, section, doorKey) {
        const CONFIG = group.PROPS.CONFIG
        const BASKET = CONFIG.BASKET

        let fasadesInfo = false

        const no_fasade = self.scope.app.constants.noFasad

        class Fasade {
            constructor(id, fasade, height, position, external_box, width) {
                this.id = id; // Уникальный идентификатор
                this.fasade = fasade;
                this.size = {height, width};
                this.position = position;
                this.external_box = external_box
            }
        }

        let fasadeSegments = BASKET.DOORS?.[section]?.[doorKey] || BASKET.DOORS?.[section] || BASKET['FASADE' + section]

        if ((((CONFIG.FASADE_SECTIONS.BOX_FASADE[section] && Object.entries(CONFIG.FASADE_SECTIONS.BOX_FASADE[section]).length)) ||
                (CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[section] && Object.entries(CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section]).length)) &&
            CONFIG.recalcFasadeHeight !== true) {

            let standartSectionFasadePosition = this.getFasadePosition(group, section)

            if (CONFIG['COMPOSITE_FASADE' + section]) {
                delete CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section]
                delete CONFIG['COMPOSITE_FASADE' + section]
            }

            const calcFasadesWithExternalFasades = (_doorKey) => {
                const ALL_FASADES = {}
                let FASADE_NUMBER = 0

                //Размер и позиция фасадов
                fasadesInfo = self.calcBoxFasadeSizes(group, section, _doorKey)
                let fasadePosition = this.getFasadePosition(group, section, _doorKey)

                console.log('fasadesInfo', fasadesInfo)

                //сохранение старых фасадов из корзины
                const old_fasades = {
                    COLORS: fasadeSegments,
                    MILLINGS: BASKET['MILLING' + section],
                    PALETTES: BASKET['PALETTE' + section],
                    PATINAS: BASKET['PATINA' + section],
                    FASADETYPES: BASKET['FASADETYPE' + section]
                }

                let AVAILABLE_FASADES = _doorKey ? CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section]?.[_doorKey] || {} : CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section] || {}
                //Копируем данные со старых фасадов
                if (AVAILABLE_FASADES?.[FASADE_NUMBER]) {
                    /// !!!Перенести желательно в отдельную функцию, для копирования данных со "старых фасдов"
                    if (AVAILABLE_FASADES[FASADE_NUMBER].size?.height)
                        AVAILABLE_FASADES[FASADE_NUMBER].size.height = fasadesInfo.sizes[FASADE_NUMBER]
                    else
                        AVAILABLE_FASADES[FASADE_NUMBER].size = fasadesInfo.sizes[FASADE_NUMBER]

                    AVAILABLE_FASADES[FASADE_NUMBER].position = fasadesInfo.positions[FASADE_NUMBER]

                    if (old_fasades.COLORS?.[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]) {
                        AVAILABLE_FASADES[FASADE_NUMBER].fasade.COLOR = old_fasades.COLORS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                        if (BASKET['MILLING' + section]) {
                            AVAILABLE_FASADES[FASADE_NUMBER].fasade.MILLING = old_fasades.MILLINGS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                        }
                        if (BASKET['PALETTE' + section]) {
                            AVAILABLE_FASADES[FASADE_NUMBER].fasade.PALETTE = old_fasades.PALETTES[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                        }
                        if (BASKET['PATINA' + section]) {
                            AVAILABLE_FASADES[FASADE_NUMBER].fasade.PATINA = old_fasades.PATINAS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                        }
                        if (BASKET['FASADETYPE' + section]) {
                            AVAILABLE_FASADES[FASADE_NUMBER].fasade.FASADETYPE = old_fasades.FASADETYPES[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                        }
                    }

                    ALL_FASADES[FASADE_NUMBER] = AVAILABLE_FASADES[FASADE_NUMBER]
                } else if (fasadesInfo) {
                    const id = Date.now() + '-' + Math.random().toString(36).substr(2, 9);
                    const fasade = {COLOR: no_fasade}
                    const size = fasadesInfo.sizes[FASADE_NUMBER]
                    const position = fasadesInfo.positions[FASADE_NUMBER]

                    ALL_FASADES[FASADE_NUMBER] = new Fasade(id, fasade, size, position, false, fasadePosition.FASADE_WIDTH)
                }

                FASADE_NUMBER++

                const TEMP_BOX_FASADE = {}
                const BOX_ARRAY = CONFIG.FASADE_SECTIONS.BOX_FASADE?.[section] ? Object.values(CONFIG.FASADE_SECTIONS.BOX_FASADE[section]) : []
                const PROFILES_ARRAY = CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[section] ? Object.values(CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section]) : []

                const BOX_SORTED_ARRAY = [...BOX_ARRAY, ...PROFILES_ARRAY].sort((a, b) => b.POSITION.y - a.POSITION.y) || []
                angular.forEach(BOX_SORTED_ARRAY, function (box, box_key) {
                    TEMP_BOX_FASADE[++box_key] = box
                })

                angular.forEach(TEMP_BOX_FASADE, function (box, box_key) {

                    if (!box.isProfile) {

                        //Добавляем в доступные фасады, фасад ящика
                        if (!box.FASADE) {
                            const new_external_fasade = {
                                ID: Date.now() + '-' + Math.random().toString(36).substr(2, 9),
                                FASADE_INFO: {COLOR: no_fasade},
                            }
                            box.FASADE = new_external_fasade
                        }

                        //Поиск ящика фасада среди доступных
                        let get_fasade_key = false

                        angular.forEach(AVAILABLE_FASADES, function (fasade, f_key) {
                            if (box.FASADE.ID == fasade.id) {
                                get_fasade_key = f_key
                            }
                        })

                        if (get_fasade_key) {
                            const box_id = box.FASADE.ID
                            let fasade
                            let old_fasade = AVAILABLE_FASADES[get_fasade_key].fasade
                            if (old_fasade) {
                                fasade = Object.assign({}, old_fasade)
                            }
                            const box_fasade = fasade
                            const box_size = box.SIZE
                            const box_position = fasadesInfo.positions[get_fasade_key]
                            ALL_FASADES[FASADE_NUMBER] = new Fasade(box_id, box_fasade, box_size, box_position, box_key, standartSectionFasadePosition.FASADE_WIDTH)
                            ALL_FASADES[FASADE_NUMBER].box_key = box.KEY
                        } else {
                            const box_id = box.FASADE.ID
                            const box_fasade = box.FASADE.FASADE_INFO
                            const box_size = box.SIZE
                            const box_position = fasadesInfo.positions[FASADE_NUMBER]
                            ALL_FASADES[FASADE_NUMBER] = new Fasade(box_id, box_fasade, box_size, box_position, box_key, standartSectionFasadePosition.FASADE_WIDTH)
                            ALL_FASADES[FASADE_NUMBER].box_key = box.KEY
                        }
                    }

                    FASADE_NUMBER++


                    if (AVAILABLE_FASADES?.[FASADE_NUMBER]) {

                        if (AVAILABLE_FASADES[FASADE_NUMBER].size?.height)
                            AVAILABLE_FASADES[FASADE_NUMBER].size.height = fasadesInfo.sizes[FASADE_NUMBER]
                        else
                            AVAILABLE_FASADES[FASADE_NUMBER].size = fasadesInfo.sizes[FASADE_NUMBER]

                        AVAILABLE_FASADES[FASADE_NUMBER].position = fasadesInfo.positions[FASADE_NUMBER]
                        if (old_fasades.COLORS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]) {
                            AVAILABLE_FASADES[FASADE_NUMBER].fasade.COLOR = old_fasades.COLORS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                            if (old_fasades.MILLINGS) {
                                AVAILABLE_FASADES[FASADE_NUMBER].fasade.MILLING = old_fasades.MILLINGS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                            }
                            if (old_fasades.PALETTES) {
                                AVAILABLE_FASADES[FASADE_NUMBER].fasade.PALETTE = old_fasades.PALETTES[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                            }
                            if (old_fasades.PATINAS) {
                                AVAILABLE_FASADES[FASADE_NUMBER].fasade.PATINA = old_fasades.PATINAS[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                            }
                            if (old_fasades.FASADETYPES) {
                                AVAILABLE_FASADES[FASADE_NUMBER].fasade.FASADETYPE = old_fasades.FASADETYPES[AVAILABLE_FASADES[FASADE_NUMBER].basket_key]
                            }
                        }
                        ALL_FASADES[FASADE_NUMBER] = AVAILABLE_FASADES[FASADE_NUMBER]
                    } else {
                        const id = Date.now() + '-' + Math.random().toString(36).substr(2, 9);
                        const fasade = {COLOR: no_fasade}
                        const size = fasadesInfo.sizes[FASADE_NUMBER]
                        const position = fasadesInfo.positions[FASADE_NUMBER]

                        if (size && position)
                            ALL_FASADES[FASADE_NUMBER] = new Fasade(id, fasade, size, position, false, fasadePosition.FASADE_WIDTH)
                    }
                    FASADE_NUMBER++
                })

                //Редактирование для сохранения
                if (_doorKey) {
                    if (!CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section])
                        CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section] = {}

                    CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section][_doorKey] = ALL_FASADES

                    //Сброс старой инфы по фасадам.
                    BASKET.DOORS[section][_doorKey] = {}

                    if (!BASKET['PALETTE' + section])
                        BASKET['PALETTE' + section] = {}

                    BASKET['PALETTE' + section][_doorKey] = {}

                    if (!BASKET['PATINA' + section])
                        BASKET['PATINA' + section] = {}

                    BASKET['PATINA' + section][_doorKey] = {}

                    if (!BASKET['FASADETYPE' + section])
                        BASKET['FASADETYPE' + section] = {}

                    BASKET['FASADETYPE' + section][_doorKey] = {}

                    if (!BASKET['FASADESIZES' + section])
                        BASKET['FASADESIZES' + section] = {}

                    BASKET['FASADESIZES' + section][_doorKey] = {}

                    if (!BASKET['FASADEWIDTH' + section])
                        BASKET['FASADEWIDTH' + section] = {}

                    BASKET['FASADEWIDTH' + section][_doorKey] = 0

                    //Заменить на баскет!
                    if (!CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section])
                        CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section] = {}

                    CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section][_doorKey] = {}
                } else {
                    CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section] = ALL_FASADES

                    //Сброс старой инфы по фасадам.
                    if (BASKET.DOORS?.[section])
                        BASKET.DOORS[section] = {}
                    else
                        BASKET['FASADE' + section] = {}

                    BASKET['PALETTE' + section] = {}
                    BASKET['PATINA' + section] = {}
                    BASKET['FASADETYPE' + section] = {}

                    BASKET['FASADESIZES' + section] = {}

                    //Заменить на баскет!
                    CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section] = {}
                }

                ////////////////////////////////////////

                let basket_key = 0
                fasadeSegments = {}

                angular.forEach(ALL_FASADES, function (fasade, fasade_key) {
                    if (((typeof fasade.size === "object" && fasade.size.height >= 360) || (typeof fasade.size !== "object" && fasade.size >= 360)) || fasade.external_box) {
                        if (fasade.external_box) {
                            if (BASKET[`SECTIONSFILLING${section}`]?.[+fasade.box_key - 1]) {
                                BASKET[`SECTIONSFILLING${section}`][+fasade.box_key - 1].FASADE = fasade
                                let tmp_box = Object.values(CONFIG.SECTIONS[section].SUBELEMENTS).find(item => item.KEY == fasade.box_key)
                                tmp_box.FASADE = fasade
                            }
                        } else {

                            fasadeSegments[basket_key] = fasade.fasade.COLOR

                            if (fasade.fasade.MILLING) {
                                if (!BASKET['MILLING' + section])
                                    BASKET['MILLING' + section] = {}

                                if (_doorKey) {
                                    if (!BASKET['MILLING' + section][_doorKey])
                                        BASKET['MILLING' + section][_doorKey] = {}

                                    BASKET['MILLING' + section][_doorKey][basket_key] = fasade.fasade.MILLING
                                } else
                                    BASKET['MILLING' + section][basket_key] = fasade.fasade.MILLING
                            }

                            if (fasade.fasade.PALETTE) {
                                if (!BASKET['PALETTE' + section])
                                    BASKET['PALETTE' + section] = {}

                                if (_doorKey) {
                                    if (!BASKET['PALETTE' + section][_doorKey])
                                        BASKET['PALETTE' + section][_doorKey] = {}

                                    BASKET['PALETTE' + section][_doorKey][basket_key] = fasade.fasade.PALETTE
                                } else
                                    BASKET['PALETTE' + section][basket_key] = fasade.fasade.PALETTE
                            }

                            if (fasade.fasade.PATINA) {
                                if (!BASKET['PATINA' + section])
                                    BASKET['PATINA' + section] = {}

                                if (_doorKey) {
                                    if (!BASKET['PATINA' + section][_doorKey])
                                        BASKET['PATINA' + section][_doorKey] = {}

                                    BASKET['PATINA' + section][_doorKey][basket_key] = fasade.fasade.PATINA
                                } else
                                    BASKET['PATINA' + section][basket_key] = fasade.fasade.PATINA
                            }

                            if (fasade.fasade.FASADETYPE) {
                                if (!BASKET['FASADETYPE' + section])
                                    BASKET['FASADETYPE' + section] = {}

                                if (_doorKey) {
                                    if (!BASKET['FASADETYPE' + section][_doorKey])
                                        BASKET['FASADETYPE' + section][_doorKey] = {}

                                    BASKET['FASADETYPE' + section][_doorKey][basket_key] = fasade.fasade.FASADETYPE
                                } else
                                    BASKET['FASADETYPE' + section][basket_key] = fasade.fasade.FASADETYPE
                            }

                            if (_doorKey) {
                                if (!BASKET['FASADESIZES' + section][_doorKey])
                                    BASKET['FASADESIZES' + section][_doorKey] = {}

                                BASKET['FASADESIZES' + section][_doorKey][basket_key] = fasade.size?.height || fasade.size
                            } else
                                BASKET['FASADESIZES' + section][basket_key] = fasade.size?.height || fasade.size

                            if (group.PROPS.PRODUCT.moduleType) {
                                if (_doorKey) {
                                    BASKET['FASADEWIDTH' + section][_doorKey] = self.calcFasadeWidth(fasadeSegments, section, group, _doorKey)
                                } else
                                    BASKET['FASADEWIDTH' + section] = self.calcFasadeWidth(fasadeSegments, section, group, _doorKey)
                            } else {
                                delete BASKET['FASADEWIDTH' + section]
                            }

                            //Заменить на баскет!
                            if (_doorKey) {
                                if (!CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section][_doorKey])
                                    CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section][_doorKey] = {}

                                CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section][_doorKey][basket_key] = fasade.position
                            } else
                                CONFIG.FASADE_SECTIONS['FASADE_POSITIONS'][section][basket_key] = fasade.position
                        }

                        fasade.basket_key = basket_key
                        basket_key++
                    } else {
                        fasade.basket_key = false
                    }
                })
            }

            if (doorKey || typeof BASKET.DOORS?.[section]?.[1] === 'object') {
                if (doorKey)
                    calcFasadesWithExternalFasades(doorKey)
                else {

                    angular.forEach(BASKET.DOORS[section], function (door, key) {
                        fasadeSegments = BASKET.DOORS[section][key]
                        calcFasadesWithExternalFasades(key)
                        BASKET.DOORS[section][key] = fasadeSegments
                    })

                    fasadeSegments = BASKET.DOORS[section]
                }
            } else {
                calcFasadesWithExternalFasades()
            }

            //Составной фасад
        } else if (CONFIG['COMPOSITE_FASADE' + section] && !CONFIG.FASADE_SECTIONS.BOX_FASADE[section]) {

            if (CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section])
                delete CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section]

            let fasadePosition = this.getFasadePosition(group, section, doorKey)

            fasadesInfo = self.calcCompositeFasadeSizes(group, section, fasadePosition, doorKey)

            if (doorKey) {
                group.PROPS.CONFIG.BASKET['FASADESIZES' + section][doorKey] = fasadesInfo.sizes

                BASKET['FASADEWIDTH' + section][doorKey] = self.calcFasadeWidth(fasadeSegments, section, group, doorKey)

                CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][doorKey] = fasadesInfo.positions

                for (let i = 0; i < CONFIG.BASKET['FASADESIZES' + section][doorKey].length; i++) {
                    let size = CONFIG.BASKET['FASADESIZES' + section][doorKey][i]

                    if (size < 360) {

                        //При уменьшении размеров модуля, пересчитывает кол-во сегментов
                        //delete CONFIG.BASKET['FASADE' + section][i]
                        fasadeSegments[i] = 7397
                        if (BASKET['MILLING' + section]?.[doorKey]?.[i]) {
                            delete BASKET['MILLING' + section][doorKey][i]
                        }
                        if (BASKET['PALETTE' + section]?.[doorKey]?.[i]) {
                            delete BASKET['PALETTE' + section][doorKey][i]
                        }
                        if (BASKET['PATINA' + section]?.[doorKey]?.[i]) {
                            delete BASKET['PATINA' + section][i]
                        }
                        if (BASKET['FASADETYPE' + section]?.[doorKey]?.[i]) {
                            delete BASKET['FASADETYPE' + section][doorKey][i]
                        }

                        angular.forEach(fasadeSegments, function (fasade, fkey) {
                            const newSizes = self.calcCompositeFasadeSizes(group, section, fasadePosition, doorKey)

                            for (let j = 0; j < newSizes.sizes.length; j++) {
                                let _size = newSizes.sizes[j]

                                if (_size < 360) {
                                    //delete CONFIG.BASKET['FASADE' + section][j]
                                    fasadeSegments[j] = 7397
                                    if (BASKET['MILLING' + section]?.[doorKey]?.[j]) {
                                        delete BASKET['MILLING' + section][doorKey][j]
                                    }
                                    if (BASKET['PALETTE' + section]?.[doorKey]?.[j]) {
                                        delete BASKET['PALETTE' + section][doorKey][j]
                                    }
                                    if (BASKET['PATINA' + section]?.[doorKey]?.[j]) {
                                        delete BASKET['PATINA' + section][doorKey][j]
                                    }
                                    if (BASKET['FASADETYPE' + section]?.[doorKey]?.[j]) {
                                        delete BASKET['FASADETYPE' + section][doorKey][j]
                                    }
                                } else {
                                    CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][doorKey] = newSizes.positions
                                    CONFIG.BASKET['FASADESIZES' + section][doorKey] = newSizes.sizes

                                    BASKET['FASADEWIDTH' + section][doorKey] = self.calcFasadeWidth(fasadeSegments, section, group, doorKey)
                                }
                            }
                        })

                        break;
                    }
                }
            } else {
                group.PROPS.CONFIG.BASKET['FASADESIZES' + section] = fasadesInfo.sizes

                if (group.PROPS.PRODUCT.moduleType)
                    BASKET['FASADEWIDTH' + section] = self.calcFasadeWidth(fasadeSegments, section, group, doorKey)
                else
                    delete BASKET['FASADEWIDTH' + section]

                CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section] = fasadesInfo.positions

                for (let i = 0; i < CONFIG.BASKET['FASADESIZES' + section].length; i++) {
                    let size = CONFIG.BASKET['FASADESIZES' + section][i]

                    if (size < 360) {

                        //При уменьшении размеров модуля, пересчитывает кол-во сегментов
                        //delete CONFIG.BASKET['FASADE' + section][i]
                        fasadeSegments[i] = 7397
                        if (BASKET['MILLING' + section]?.[i]) {
                            delete BASKET['MILLING' + section][i]
                        }
                        if (BASKET['PALETTE' + section]?.[i]) {
                            delete BASKET['PALETTE' + section][i]
                        }
                        if (BASKET['PATINA' + section]?.[i]) {
                            delete BASKET['PATINA' + section][i]
                        }
                        if (BASKET['FASADETYPE' + section]?.[i]) {
                            delete BASKET['FASADETYPE' + section][i]
                        }

                        angular.forEach(fasadeSegments, function (fasade, fkey) {
                            const newSizes = self.calcCompositeFasadeSizes(group, section, fasadePosition, doorKey)

                            for (let j = 0; j < newSizes.sizes.length; j++) {
                                let _size = newSizes.sizes[j]

                                if (_size < 360) {
                                    //delete CONFIG.BASKET['FASADE' + section][j]
                                    fasadeSegments[j] = 7397
                                    if (BASKET['MILLING' + section]?.[j]) {
                                        delete BASKET['MILLING' + section][j]
                                    }
                                    if (BASKET['PALETTE' + section]?.[j]) {
                                        delete BASKET['PALETTE' + section][j]
                                    }
                                    if (BASKET['PATINA' + section]?.[j]) {
                                        delete BASKET['PATINA' + section][j]
                                    }
                                    if (BASKET['FASADETYPE' + section]?.[j]) {
                                        delete BASKET['FASADETYPE' + section][j]
                                    }
                                } else {
                                    CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section] = newSizes.positions
                                    CONFIG.BASKET['FASADESIZES' + section] = newSizes.sizes

                                    if (group.PROPS.PRODUCT.moduleType)
                                        BASKET['FASADEWIDTH' + section] = self.calcFasadeWidth(fasadeSegments, section, group, doorKey)
                                    else
                                        delete BASKET['FASADEWIDTH' + section]
                                }
                            }
                        })

                        break;
                    }
                }
            }
        } else if (!CONFIG['COMPOSITE_FASADE' + section] && !CONFIG.FASADE_SECTIONS.BOX_FASADE[section]) {

            if (CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section])
                delete CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section]

            const fasadePosition = self.getFasadePosition(group, section, doorKey)
            let fasadeSize = [fasadePosition.FASADE_HEIGHT]

            const fasadePositionNumber = self.calcFasadePositions(fasadeSize, CONFIG, fasadePosition)
            if (!CONFIG.FASADE_SECTIONS.FASADE_POSITIONS)
                CONFIG.FASADE_SECTIONS.FASADE_POSITIONS = {}

            if (doorKey)
                CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][doorKey] = fasadePositionNumber
            else
                CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section] = fasadePositionNumber
            //if (!CONFIG.BASKET['FASADESIZES' + section]) CONFIG.BASKET['FASADESIZES' + section] = [fasadePosition.FASADE_HEIGHT]

            if (CONFIG.recalcFasadeHeight !== true && CONFIG.FASADELIST[section]) {
                if (doorKey)
                    CONFIG.BASKET['FASADESIZES' + section][doorKey] = self.calcFasadeHeight(fasadeSegments, section, group, fasadePosition, doorKey)
                else
                    CONFIG.BASKET['FASADESIZES' + section] = self.calcFasadeHeight(fasadeSegments, section, group, fasadePosition)

                if (group.PROPS.PRODUCT.moduleType) {
                    if (doorKey) {
                        if (typeof BASKET['FASADEWIDTH' + section] === "number")
                            BASKET['FASADEWIDTH' + section] = {1: BASKET['FASADEWIDTH' + section]}

                        BASKET['FASADEWIDTH' + section][doorKey] = self.calcFasadeWidth(fasadeSegments, section, group, doorKey)
                    } else
                        BASKET['FASADEWIDTH' + section] = self.calcFasadeWidth(fasadeSegments, section, group)
                } else
                    delete BASKET['FASADEWIDTH' + section]
            }

            let FASADESIZES = doorKey ? CONFIG.BASKET['FASADESIZES' + section][doorKey] : CONFIG.BASKET['FASADESIZES' + section]
            if (FASADESIZES)
                for (let i = 0; i < FASADESIZES.length; i++) {
                    let size = FASADESIZES[i]

                    if (size < 360 && !self.checkBoxIsFasade(group, section, i, doorKey)) {

                        //При уменьшении размеров модуля, пересчитывает кол-во сегментов
                        //delete CONFIG.BASKET['FASADE' + section][i]
                        fasadeSegments[i] = 7397
                        if (doorKey) {
                            if (BASKET['MILLING' + section]?.[doorKey]?.[i]) {
                                delete BASKET['MILLING' + section][doorKey][i]
                            }
                            if (BASKET['PALETTE' + section]?.[doorKey]?.[i]) {
                                delete BASKET['PALETTE' + section][doorKey][i]
                            }
                            if (BASKET['PATINA' + section]?.[doorKey]?.[i]) {
                                delete BASKET['PATINA' + section][doorKey][i]
                            }
                            if (BASKET['FASADETYPE' + section]?.[doorKey]?.[i]) {
                                delete BASKET['FASADETYPE' + section][doorKey][i]
                            }
                        } else {
                            if (BASKET['MILLING' + section]?.[i]) {
                                delete BASKET['MILLING' + section][i]
                            }
                            if (BASKET['PALETTE' + section]?.[i]) {
                                delete BASKET['PALETTE' + section][i]
                            }
                            if (BASKET['PATINA' + section]?.[i]) {
                                delete BASKET['PATINA' + section][i]
                            }
                            if (BASKET['FASADETYPE' + section]?.[i]) {
                                delete BASKET['FASADETYPE' + section][i]
                            }
                        }
                    }
                }

        } else if (CONFIG['COMPOSITE_FASADE' + section] && (CONFIG.FASADE_SECTIONS.BOX_FASADE[section] || CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section])) {

            /*   if (CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section])
        delete CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section]

      let fasadePosition = this.getFasadePosition(group, section, doorKey)

      fasadesInfo = self.calcCompositeFasadeSizes(group, section, fasadePosition, doorKey)

      if (doorKey) {
        group.PROPS.CONFIG.BASKET['FASADESIZES' + section][doorKey] = fasadesInfo.sizes

        if (group.PROPS.PRODUCT.moduleType) {
            BASKET['FASADEWIDTH' + section][doorKey] = self.calcFasadeWidth(fasadeSegments, section, group, doorKey)
        }
        else
          delete BASKET['FASADEWIDTH' + section]

        CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][doorKey] = fasadesInfo.positions
      }
      else {
        group.PROPS.CONFIG.BASKET['FASADESIZES' + section] = fasadesInfo.sizes

        if (group.PROPS.PRODUCT.moduleType) {
            BASKET['FASADEWIDTH' + section] = self.calcFasadeWidth(fasadeSegments, section, group)
        }
        else
          delete BASKET['FASADEWIDTH' + section]

        CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section] = fasadesInfo.positions
      }*/


            let FASADESIZES = doorKey ? CONFIG.BASKET['FASADESIZES' + section][doorKey] : CONFIG.BASKET['FASADESIZES' + section]
            if (FASADESIZES)
                if (Array.isArray(FASADESIZES)) {
                    for (let i = 0; i < FASADESIZES.length; i++) {
                        let size = FASADESIZES[i]

                        if (size < 360 && !self.checkBoxIsFasade(group, section, i, doorKey)) {

                            //При уменьшении размеров модуля, пересчитывает кол-во сегментов
                            //delete CONFIG.BASKET['FASADE' + section][i]
                            fasadeSegments[i] = 7397
                            if (doorKey) {
                                if (BASKET['MILLING' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['MILLING' + section][doorKey][i]
                                }
                                if (BASKET['PALETTE' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['PALETTE' + section][doorKey][i]
                                }
                                if (BASKET['PATINA' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['PATINA' + section][doorKey][i]
                                }
                                if (BASKET['FASADETYPE' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['FASADETYPE' + section][doorKey][i]
                                }
                            } else {
                                if (BASKET['MILLING' + section]?.[i]) {
                                    delete BASKET['MILLING' + section][i]
                                }
                                if (BASKET['PALETTE' + section]?.[i]) {
                                    delete BASKET['PALETTE' + section][i]
                                }
                                if (BASKET['PATINA' + section]?.[i]) {
                                    delete BASKET['PATINA' + section][i]
                                }
                                if (BASKET['FASADETYPE' + section]?.[i]) {
                                    delete BASKET['FASADETYPE' + section][i]
                                }
                            }
                        }
                    }
                } else {
                    angular.forEach(FASADESIZES, (size, i) => {

                        if (size < 360 && !self.checkBoxIsFasade(group, section, i, doorKey)) {

                            //При уменьшении размеров модуля, пересчитывает кол-во сегментов
                            //delete CONFIG.BASKET['FASADE' + section][i]
                            fasadeSegments[i] = 7397
                            if (doorKey) {
                                if (BASKET['MILLING' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['MILLING' + section][doorKey][i]
                                }
                                if (BASKET['PALETTE' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['PALETTE' + section][doorKey][i]
                                }
                                if (BASKET['PATINA' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['PATINA' + section][doorKey][i]
                                }
                                if (BASKET['FASADETYPE' + section]?.[doorKey]?.[i]) {
                                    delete BASKET['FASADETYPE' + section][doorKey][i]
                                }
                            } else {
                                if (BASKET['MILLING' + section]?.[i]) {
                                    delete BASKET['MILLING' + section][i]
                                }
                                if (BASKET['PALETTE' + section]?.[i]) {
                                    delete BASKET['PALETTE' + section][i]
                                }
                                if (BASKET['PATINA' + section]?.[i]) {
                                    delete BASKET['PATINA' + section][i]
                                }
                                if (BASKET['FASADETYPE' + section]?.[i]) {
                                    delete BASKET['FASADETYPE' + section][i]
                                }
                            }
                        }
                    })
                }
        }

        //Очистка пустых ящиков
        if (BASKET['MILLING' + section] && !Object.keys(BASKET['MILLING' + section]).length) {
            delete BASKET['MILLING' + section]
        }
        if (BASKET['PALETTE' + section] && !Object.keys(BASKET['PALETTE' + section]).length) {
            delete BASKET['PALETTE' + section]
        }
        if (['PATINA' + section] && !Object.keys(['PATINA' + section]).length) {
            delete ['PATINA' + section]
        }
        if (BASKET['FASADETYPE' + section] && !Object.keys(BASKET['FASADETYPE' + section]).length) {
            delete BASKET['FASADETYPE' + section]
        }


        if (BASKET.DOORS?.[section]) {
            if (doorKey)
                BASKET.DOORS[section][doorKey] = fasadeSegments
            else
                BASKET.DOORS[section] = fasadeSegments
        } else
            BASKET['FASADE' + section] = fasadeSegments


        //Сделать дебаунс
        self.controlFasade(group, doorKey)

        if (!group.PROPS.PRODUCT.moduleType || group.PROPS.PRODUCT.moduleType.CODE !== "wardrobe") {
            if (!doorKey && BASKET.DOORS?.[section]) {
                angular.forEach(BASKET.DOORS[section], function (door, key) {
                    self.calcLoops(group, section, key)
                })
            } else
                self.calcLoops(group, section, doorKey)
        }
        self.scope.$applyAsync();

        console.log('controlFasadeCount, group', group)
    }

    //Берет все внешние ящики, и считает размеры и позиции фасадов
    this.calcBoxFasadeSizes = function (group, section, doorKey) {
        const config = {}
        const fasadeSizes = []
        const fasadePositions = []
        const CONFIG = group.PROPS.CONFIG

        let fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        fasadeThickness = group.PROPS.CONFIG.NOBOTTOM ? -2 : fasadeThickness - 2

        //Ящики с фасадами
        const BOX_FASADE = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section]
        const HI_TECH_PROFILES = group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[section]

        const boxesArray = []
        angular.forEach(BOX_FASADE, function (box, box_key) {
            if (!box.POSITION) {
                box.POSITION = new THREE.Vector3()
            }
            boxesArray.push(box)
        })
        angular.forEach(HI_TECH_PROFILES, function (profile, box_key) {
            if (!profile.POSITION) {
                profile.POSITION = new THREE.Vector3()
            }
            boxesArray.push(profile)
        })

        if (!boxesArray.length)
            return

        const sortedBoxesByIncrease = boxesArray.sort((a, b) => a.POSITION.y - b.POSITION.y)

        let fasadePosition = this.getFasadePosition(group, section, doorKey)

        const otstup = 4

        let fullFasadelSize = fasadePosition.FASADE_HEIGHT
        const fullFasadeSize = fullFasadelSize

        const firstBox = sortedBoxesByIncrease[0] //нижний ящик
        let bottomFasadePosition = -(CONFIG.SIZE.height / 2 - Math.abs(fasadePosition.FASADE_HEIGHT - CONFIG.SIZE.height + 2))
        const firstFasadePosition = bottomFasadePosition

        if ((firstBox.POSITION.y - (firstBox.MANUFACTURER_OFFSET || 0) - (firstBox.isProfile ? 0 : otstup) + fasadeThickness) > 0) {
            let firstFasadeSize = Math.abs((bottomFasadePosition + (firstBox.POSITION.y - (firstBox.MANUFACTURER_OFFSET || 0) - (firstBox.isProfile ? 0 : otstup) + fasadeThickness)) - bottomFasadePosition)

            fasadeSizes.push(firstFasadeSize) //Добавление верхнего сегмента перед вверхней стенкой или внешним ящиком
            fasadePositions.push(firstFasadePosition)

            fullFasadelSize = fullFasadelSize - firstFasadeSize - (firstBox.isProfile ? 0 : otstup)
            bottomFasadePosition = bottomFasadePosition + firstFasadeSize + (firstBox.isProfile ? 0 : otstup)
        }

        for (let index = 0; index < sortedBoxesByIncrease.length; index++) {
            let box = sortedBoxesByIncrease[index]

            if (!box.POSITION?.y) {
                box.POSITION = new THREE.Vector3()
            }

            const boxFasadeHeight = box.isProfile && box.otstup ? box.otstup : box.SIZE

            fasadeSizes.push(boxFasadeHeight)
            fasadePositions.push(bottomFasadePosition)

            const topBox = sortedBoxesByIncrease[index + 1]
            let upperFasadeSize = false

            fullFasadelSize = fullFasadelSize - boxFasadeHeight - (box.isProfile || topBox?.isProfile ? 0 : otstup)
            bottomFasadePosition = bottomFasadePosition + boxFasadeHeight + (box.isProfile || topBox?.isProfile ? 0 : otstup)

            //Условие для нижней планки
            if (topBox) {
                upperFasadeSize = Math.abs((firstFasadePosition + (topBox.POSITION.y - (topBox.MANUFACTURER_OFFSET || 0) + fasadeThickness)) - bottomFasadePosition)

                if ((!box.isProfile && topBox.isProfile) && upperFasadeSize > 4) {
                    bottomFasadePosition += otstup
                    upperFasadeSize -= 4
                } else if ((!box.isProfile && !topBox.isProfile) && upperFasadeSize > 0) {
                    upperFasadeSize -= 4
                }
            } else {
                upperFasadeSize = Math.abs(CONFIG.SIZE.height / 2 - 2 - bottomFasadePosition)
            }

            fasadeSizes.push(upperFasadeSize)
            fasadePositions.push(bottomFasadePosition)

            //Если между ящиками расстояние <= 4мм, то туда фасад не нужен, НО если информациб об этом "фасаде" не положить - сломется
            //логика приложения. Поэтому, если у нас такой промежуток есть, то мы кладём его размер и позицию, но не смещаем её и не уменьшаем\
            //общий фасад, тогда фасады отобразятся корректно.
            if (upperFasadeSize > 0) {
                fullFasadelSize = fullFasadelSize - upperFasadeSize - (box.isProfile || topBox?.isProfile ? 0 : otstup)
                bottomFasadePosition = bottomFasadePosition + upperFasadeSize + (box.isProfile || topBox?.isProfile ? 0 : otstup)
            }
        }

        //Разворачиваем массивы, чтоб фасады шли сверху вниз
        fasadePositions.reverse()
        fasadeSizes.reverse()

        //Привязка значений
        config.positions = fasadePositions
        config.sizes = fasadeSizes

        return config
    }

    this.calcLoops = function (group, section, doorKey) {

        if (!group.PROPS.PRODUCT.moduleType)
            return

        group.PROPS.BOX.remove(group.PROPS.LOOPS[section])
        group.remove(group.PROPS.LOOPS[section])

        const additional_fasades = []
        const additional_fasades_positions = []
        const FASADESIZES = doorKey ? group.PROPS.CONFIG.BASKET['FASADESIZES' + section][doorKey] : group.PROPS.CONFIG.BASKET['FASADESIZES' + section];
        angular.forEach(FASADESIZES, function (size, key) {
            const itsBoxFasade = self.checkBoxForFasade(group, section, false, key, doorKey)

            const no_fasade = self.scope.app.constants.noFasad

            const fasadeSegments = group.PROPS.CONFIG.BASKET.DOORS?.[section]?.[doorKey] || group.PROPS.CONFIG.BASKET.DOORS?.[section] || group.PROPS.CONFIG.BASKET['FASADE' + section]

            const without_fasade = fasadeSegments?.[key] == no_fasade
            const oneFasade = Object.keys(FASADESIZES).length != 1
            if ((itsBoxFasade || without_fasade) && oneFasade) {
                //Не добавляем петли, если
            } else {
                additional_fasades.push(size)
                if (doorKey)
                    additional_fasades_positions.push(group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][doorKey][key])
                else
                    additional_fasades_positions.push(group.PROPS.CONFIG.FASADE_SECTIONS.FASADE_POSITIONS[section][key])
            }

        })

        const loop_positions = self.calcLoopPositions(group.PROPS.CONFIG, additional_fasades, additional_fasades_positions, section, group.PROPS.PRODUCT) //!!!ИЗМЕНИТЬ ДОСТУПНЫЕ ФАСАДЫ СДЕЛАТЬ ИСКЛЮЧЕНИЯ ДЛЯ ЯЩИКОВ С ФАСАДАМИ

        //Присваивание позиций петель
        if (!group.PROPS.CONFIG.BASKET.LOOPS)
            group.PROPS.CONFIG.BASKET.LOOPS = {}

        if (!group.PROPS.CONFIG.BASKET.LOOPS[section])
            group.PROPS.CONFIG.BASKET.LOOPS[section] = {}

        if (!group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[section])
            group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[section] = {}

        if (doorKey) {

            if (!group.PROPS.CONFIG.BASKET.LOOPS[section][doorKey])
                group.PROPS.CONFIG.BASKET.LOOPS[section][doorKey] = {}

            if (!group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[section][doorKey])
                group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[section][doorKey] = []

            group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[section][doorKey] = loop_positions
            group.PROPS.CONFIG.BASKET.LOOPS[section][doorKey] = self.convertRealToBasketLoopPos(loop_positions, group.PROPS.CONFIG)

            if (!group.PROPS.CONFIG.BASKET.LOOPS[section][doorKey].length) {
                delete group.PROPS.CONFIG.BASKET.LOOPS[section][doorKey]
            }

            /*if(!Object.entries(group.PROPS.CONFIG.BASKET.LOOPS[section]).length) {
                delete group.PROPS.CONFIG.BASKET.LOOPS[section]
            }*/

        } else {
            group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[section] = loop_positions
            group.PROPS.CONFIG.BASKET.LOOPS[section] = self.convertRealToBasketLoopPos(loop_positions, group.PROPS.CONFIG)

            /*if (!group.PROPS.CONFIG.BASKET.LOOPS[section].length) {
                delete group.PROPS.CONFIG.BASKET.LOOPS[section]
            }*/
        }
    }

    //Функция проверяет возможно ли поставить ящик внутри секции, если нет, ищет для него позицию, если места нет, удаляет
    this.controlBoxesPosition = function (group) {
        const CONFIG = group.PROPS.CONFIG
        const SECTIONS = CONFIG.SECTIONS
        const needDelete = [] //Массив ящиков для дальнейшего удаления

        angular.forEach(SECTIONS, function (sectionAll, sectkey) {
            if (sectionAll?.SUBELEMENTS)
                angular.forEach(sectionAll.SUBELEMENTS, function (subelement, subkey) {
                    let element = group.getObjectByName(`SUBELEMENT_${+sectkey}_${+subkey}`) ||
                        group.getObjectByName(`PARTITION_${+sectkey}`) ||
                        group.getObjectByName(`VERTICAL_SHELF_${+sectkey}_${+subkey}`);

                    const freePosition = subelement.TYPE == "PARTITION" ? true : self.findFreeBoxPosition(group, sectkey, subelement, subkey)
                    if (freePosition) {
                        if (typeof freePosition === 'object' && freePosition.y > 0 && element) {
                            //Меняем позицию
                            const positionValue = self.getSectionMousePositionFromInput(group, new THREE.Vector3(freePosition.x, freePosition.y, freePosition.z), element);
                            self.setSectionElementPosition(group, element, positionValue, sectkey, subkey, false, freePosition);
                        }
                    } else {
                        const deletedItem = {section: sectkey, key: subkey}
                        needDelete.push(deletedItem)
                        //Удаляем
                    }
                })
        })

        angular.forEach(needDelete, function (elem) {
            self.alert('Внимание! Ящик под номером' + elem.key + ' удален')
            self.deleteSubElementToElement(group, elem.section, elem.key)
        })
    }

    this.findFreeBoxPosition = function (group, section, subelement, subkey) {
        const CONFIG = group.PROPS.CONFIG

        const subelemen_section_id = +subelement.SECTION || +section
        const subelemen_key = +subelement.KEY || +subkey

        let elemName = `${subelement.TYPE}_${subelemen_section_id}`
        elemName = subelement.TYPE !== 'PARTITION' ? elemName + `_${subelemen_key}` : elemName

        let element = group.getObjectByName(elemName) || group.PROPS.SECTIONSOBJ.find(item => item.name === elemName)

        const canSetTheBox = self.canSetPositionSubElement(group, element, subelement.position)

        if (!canSetTheBox) {
            return true
        }
        // Ищем свободное место вокруг текущего положения ящика.
        let step = 10; // Шаг смещения для поиска свободного места.
        let maxDistance = 1000; // Максимальное расстояние, на которое можно отойти от изначального места.
        let searchTimes = 0 //Кол-во поисков
        let distance1 = 10
        let oldPos = {...subelement.position}
        let freePosition = oldPos

        // Поиск свободной позиции путем изменения позиции элемента вдоль оси Y
        for (let distance = step; distance <= maxDistance; distance += step) {
            const directions = [
                {dy: distance}, // вниз
                {dy: -distance}, // вверх
            ];
            searchTimes++
            distance1 += step

            for (let i = 0; i < directions.length; i++) {

                let newPos = {
                    ...subelement.position,
                    y: subelement.position.y + directions[i].dy
                };

                //Проверяем, что новая позиция не выходит за пределы и не пересекается с другими ящиками.
                const positionFound = !self.canSetPositionSubElement(group, element, newPos)
                const filling = self.scope.app.FILLING[group.PROPS.CONFIG.BASKET.FILLING];
                const top_height = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

                //var top_paddign = filling.HEIGHT_CORNICE - top_height; //Отступ сверху толщина стенки вверхней
                const top_paddign = 0
                let SectionSize = self.getSectionSize(group, section);

                const maxSize = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section]?.[subkey]?.SIZE ? Math.max(element.SIZE.height, group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][subkey].SIZE)
                    : element?.SIZE.height || 0
                const upperBlock = newPos.y > SectionSize.height - maxSize - top_paddign

                if (upperBlock || newPos.y < 0) {
                    break //Ящик вышел за границы шкафа
                }
                // Проверка, может ли элемент быть размещен в новой позиции по Y
                if (positionFound) {
                    freePosition = newPos
                    break; // Прерывание цикла при нахождении подходящей позиции
                }
            }
            if (freePosition) {
                break; // Прекращаем цикл, если нашли свободное место.
            }
        }
        return freePosition;
    }

    this.checkFasadeForBox = function (group, section, basket_key) {
        //segment = basket_key
        let hasFasade = false
        /* if (typeof basket_key !== 'number') {
      basket_key = self.getBasketFasadeKey(group, section, real_key)
    } */
        /* angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section], function(box, box_key) {
      if (box. == basket_key) {
        hasFasade = true
      }
    }) */
        /* angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section], function(box, box_key) {
      if (box_key == group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section][real_key].external_box) {
        hasFasade = true
      }
    }) */
        return hasFasade
    }

    this.checkBoxForFasade = function (group, section, real_key, basket_key, doorKey) {
        //segment = basket_key
        let hasFasade = false
        if (group) {
            if (typeof basket_key !== 'number') {
                basket_key = self.getBasketFasadeKey(group, section, real_key, doorKey)
            }

            hasFasade = self.checkBoxIsFasade(group, section, real_key || basket_key, doorKey)
            /* const AVAILABLE_FASADES = doorKey ? group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES?.[section]?.[doorKey] : group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[section]
            angular.forEach(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[section], function (box, box_key) {
                if (box.PATH == AVAILABLE_FASADES[real_key]?.external_box) {
                    hasFasade = true
                }
            })*/
        }

        return hasFasade
    }

    this.getBasketFasadeKey = function (group, section, real_key, doorKey) {
        let key = false
        const CONFIG = group.PROPS.CONFIG
        const AVAILABLE_FASADES = doorKey ? CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES?.[section]?.[doorKey] : CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES?.[section];

        angular.forEach(AVAILABLE_FASADES, function (fasade, f_key) {
            if (real_key == f_key) {
                key = +fasade.basket_key
            }
        })
        return key
    }

    this.getMaxExternalFasadeSize = function (group, section, box_key) {
        const CONFIG = group.PROPS.CONFIG

        const active_box = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][box_key]

        const BOX_ARRAY = CONFIG.FASADE_SECTIONS.BOX_FASADE?.[section] ? Object.values(CONFIG.FASADE_SECTIONS.BOX_FASADE[section]) : []
        const PROFILES_ARRAY = CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[section] ? Object.values(CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[section]) : []
        const boxesArray = [...BOX_ARRAY, ...PROFILES_ARRAY].sort((a, b) => a.POSITION.y - b.POSITION.y) || []

        let below_active_box
        for (let i = 0; i < boxesArray.length; i++) {
            let box = boxesArray[i]

            if (box.KEY == +box_key) {
                if (boxesArray[i - 1])
                    below_active_box = boxesArray[i - 1]

                break;
            }
        }

        const productId = group.PROPS.CONFIG.SECTIONS[section].SUBELEMENTS[box_key].ID
        var product = self.getProductInfo(productId);

        let SectionSize = self.getSectionSize(group, section)
        const fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        const wallThickness = fasadeThickness * 2

        //const topPadding = product.MIN_FASADE_SIZE ? -wallThickness - 14 : -wallThickness / 2 //Отступ сверху? -18 для ящиков с фасадами
        //var top_paddign = filling.HEIGHT_CORNICE + topPadding; //Отступ сверху толщина стенки вверхней + кастомный паддинг,

        var top_paddign = CONFIG.NOBOTTOM ? 0 : fasadeThickness - 2; //Отступ сверху толщина стенки вверхней + кастомный паддинг,

        var filling = self.scope.app.FILLING[group.PROPS.CONFIG.BASKET.FILLING];


        if (active_box.SIZE < product.MIN_FASADE_SIZE) {
            return product.MIN_FASADE_SIZE
        }
        let maxSize = product.MAX_FASADE_SIZE
        let maxHeight = Math.min(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[section][box_key].SIZE, maxSize)

        let bottomFasadePos = active_box.POSITION.y - active_box.MANUFACTURER_OFFSET
        let below_space = 0
        if (below_active_box) {
            let below_pos
            if (below_active_box.isProfile)
                below_pos = below_active_box.POSITION.y + below_active_box.SIZE + (below_active_box.TYPE_PROFILE === "c" ? below_active_box.MANUFACTURER_OFFSET : 0)
            else
                below_pos = below_active_box.POSITION.y - below_active_box.MANUFACTURER_OFFSET + below_active_box.SIZE

            below_space = bottomFasadePos - below_pos
        } else {
            below_space = bottomFasadePos + top_paddign
        }

        let boxBottomFasadePos
        //Проверка ставливаний, с другими внешними ящиками сверху
        angular.forEach(boxesArray, function (box, b_key) {
            if (box_key != box.KEY) {

                let tmpBottomFasadePos = box.POSITION.y - box.MANUFACTURER_OFFSET

                if (bottomFasadePos < tmpBottomFasadePos) {

                    if (!boxBottomFasadePos || boxBottomFasadePos > tmpBottomFasadePos)
                        boxBottomFasadePos = tmpBottomFasadePos
                    else
                        return

                    const maxUpperMargin = boxBottomFasadePos - (bottomFasadePos + maxHeight)
                    const minUpperMargin = boxBottomFasadePos - (bottomFasadePos + product.MIN_FASADE_SIZE)
                    let upperMargin = Math.max(minUpperMargin - (box.isProfile ? 0 : 4), maxUpperMargin - (box.isProfile ? 0 : 4))

                    maxHeight = Math.min(upperMargin + product.MIN_FASADE_SIZE, maxSize)

                    if (below_space > 4)
                        maxHeight = Math.min(upperMargin + product.MIN_FASADE_SIZE + below_space, maxSize)
                }
            }
        })
        //Проверка для упора в верхнюю стенку
        if (SectionSize.height + top_paddign - bottomFasadePos < maxHeight) {
            if (SectionSize.height + top_paddign - bottomFasadePos >= 0) {
                maxHeight = SectionSize.height + top_paddign - bottomFasadePos
            } else if (SectionSize.height + top_paddign - bottomFasadePos < 1) {
                maxHeight = maxSize - (SectionSize.height + top_paddign - bottomFasadePos)
            }
        }
        maxHeight = Math.max(maxHeight, product.MIN_FASADE_SIZE)
        return maxHeight
    }

    this.getFasadePosition = function (group, section, doorKey) {

        if (!group)
            return

        const CONFIG = group.PROPS.CONFIG
        const node_expressions = group.PROPS.EXPRESSIONS ? group.PROPS.EXPRESSIONS : {}
        const fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        const doorsCount = Object.keys(CONFIG.FASADELIST)?.length || 1
        const doorsPortalWidth = CONFIG.SIZE.width - fasadeThickness * 2
        let FASADELIST = CONFIG.FASADELIST[section] || CONFIG.FASADELIST[1]
        FASADELIST = doorKey ? FASADELIST[doorKey] : FASADELIST

        if (!FASADELIST)
            return {}

        if (typeof FASADELIST === 'object')
            FASADELIST = Object.values(FASADELIST)[0]

        let fasadePosition = Object.assign({}, self.scope.app.FASADE_POSITION[FASADELIST]);

        const PRODUCT = group.PROPS.PRODUCT || self.getProductInfo(fasadePosition?.PRODUCT)
        const product_id = PRODUCT.ID || fasadePosition?.PRODUCT

        let fasade_width
        if (PRODUCT.moduleType?.CODE === "wardrobe") {

            switch (doorsCount) {
                case 4:
                    fasade_width = (doorsPortalWidth + 25 * 2) / 4
                    break;
                default:
                    fasade_width = (doorsPortalWidth + 25 * (doorsCount - 1)) / doorsCount
                    break;
            }

            fasade_width = Math.ceil(fasade_width)

        } else if (CONFIG.CUSTOMFILLING?.VSECTION > 1) {

            if (section < CONFIG.CUSTOMFILLING?.VSECTION && section > 1) {
                fasade_width = CONFIG.BASKET['SECTIONS' + section] + (fasadeThickness / 2 - 2) * 2
            } else {
                fasade_width = CONFIG.BASKET['SECTIONS' + section] + fasadeThickness - 2 + (fasadeThickness / 2 - 2)
            }

            fasade_width += 4 //Т.к. в параметрах фасада зашито вычитание 4 мм., а рассчет ширины уже правильный - надо их докинуть

        } else {
            fasade_width = CONFIG.SIZE.width
        }

        fasadePosition = self.getExec(
            self.expressionsReplace(
                fasadePosition,
                angular.extend(node_expressions, {
                    "#X#": fasade_width,
                    "#Y#": CONFIG.SIZE.height || 2100,
                    "#Z#": CONFIG.SIZE.depth,
                    "#FASADE_THICKNESS#": fasadeThickness || 0,
                    "#FASADE_THICKNESS_OFFSET#": PRODUCT.DOUBLE_TABLE && CONFIG?.BASKET?.['BENCHPARTITION'] ? 20 : 0,
                })
            )
        );

        fasadePosition.section = section

        if (PRODUCT.moduleType?.CODE === "universal") {

            if (CONFIG.BASKET.HORIZONT === undefined) {
                CONFIG.BASKET.HORIZONT = 78
            }

            if (CONFIG.BASKET.HORIZONT > 0) {
                fasadePosition.FASADE_HEIGHT -= CONFIG.BASKET.HORIZONT
                fasadePosition.POSITION_Y = CONFIG.BASKET.HORIZONT + 2
            } else {
                fasadePosition.POSITION_Y = 2
            }
        }

        //Вычитаем размеры направляющих в дверях-купе
        if (PRODUCT.moduleType?.CODE === "wardrobe") {
            fasadePosition.FASADE_HEIGHT -= fasadeThickness * 2
            fasadePosition.DOORS_OVERFLOW = Math.abs(doorsPortalWidth - fasadePosition.FASADE_WIDTH * doorsCount) / (doorsCount - 1)

            fasadePosition.POSITION_Y = 11

            if (product_id !== 5178415 && CONFIG.BASKET.HORIZONT > 0) {
                fasadePosition.POSITION_Y += CONFIG.BASKET.HORIZONT + fasadeThickness
                fasadePosition.FASADE_HEIGHT -= CONFIG.BASKET.HORIZONT
            } else if (!CONFIG.NOBOTTOM) {
                fasadePosition.POSITION_Y += fasadeThickness
            }

            fasadePosition.POSITION_X += fasadeThickness

            if (+section > 1) {
                switch (doorsCount) {
                    case 4:
                        switch (+section) {
                            case 4:
                                fasadePosition.POSITION_X -= 50
                                break;
                            default:
                                fasadePosition.POSITION_X -= 25
                                break;
                        }
                        break;
                    default:
                        fasadePosition.POSITION_X -= 25 * (section - 1)
                        break;
                }
            }
        }

        if (PRODUCT.moduleType?.CODE) {
            if (section && fasadePosition.FASADE_NUMBER != +section) {
                fasadePosition.FASADE_NUMBER = +section
            }

            if (+section > 1) {
                if (PRODUCT.moduleType.CODE !== "universal")
                    fasadePosition.POSITION_X += fasadePosition.FASADE_WIDTH * (section - 1)
                else if (group.PROPS.SECTIONCONTROL) {
                    let sectionObj = group.PROPS.SECTIONCONTROL.find(item => item.name == `SECTIONNUMBER${section}`)
                    fasadePosition.POSITION_X += sectionObj.position.x - (-CONFIG.SIZE.width / 2) - CONFIG.BASKET[`SECTIONS${section}`] / 2 - fasadeThickness / 2
                }
            }
        }

        if (doorKey) {
            let doorsCount = CONFIG.BASKET.DOORS?.[section] ? Object.keys(CONFIG.BASKET.DOORS[section]).length : 1
            fasadePosition.FASADE_WIDTH = Math.floor(fasadePosition.FASADE_WIDTH / doorsCount) - 2 * (doorsCount - 1)

            fasadePosition.POSITION_X += (fasadePosition.FASADE_WIDTH + 4) * (doorKey - 1)
        }

        return fasadePosition
    }

    this.hideFrames = function () {
        self.scope.app.hideFrames = !self.scope.app.hideFrames;

        self.unmarkSelected();

        self.isStop = true;

        self.start();

        self.loadProject(
            JSON.parse(localStorage["project" + self.scope.app.config.dataProvider])
        );

        self.render();

        self.scope.$applyAsync();
    }

    /*******Events list******/
    this.onMouseMove = function (event) {
        self.controlRaspilMarkerPosition(event);

        self.mouse.x = (event.clientX / window.innerWidth) * 2 - 1;
        self.mouse.y = -(event.clientY / window.innerHeight) * 2 + 1;
        self.raycaster.setFromCamera(self.mouse, self.camera);


        if (self.scope.app.configElementFilling) {
            if (
                self.showSectionCanvas(
                    self.scope.app.active,
                    self.scope.app.newElement && !self.drag && !self.scope.app.selectSecionElement
                )
            ) {
                var selectedSections = self.raycaster.intersectObjects(
                    self.scope.app.active.PROPS.SECTIONCONTROL
                );

                if (selectedSections[0]) {
                    let selectedSection = selectedSections[0].object;
                    if (self.scope.app.newElement) {
                        let group = self.scope.app.active
                        let newElement = self.scope.app.newElement

                        //('только при движении мыши')
                        const KEY = !group.PROPS.CONFIG.SECTIONS?.[selectedSection.SECTIONNUMBER]?.SUBELEMENTS ? 1 : Object.keys(group.PROPS.CONFIG.SECTIONS?.[selectedSection.SECTIONNUMBER]?.SUBELEMENTS).length + 1

                        const isHiTechProfile = self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE.includes("hi_tech_profile") || false
                        const isBottomHiTechProfile = isHiTechProfile && self.scope.app.PRODUCTS_TYPES[newElement.productType]?.CODE.includes("bottom") || false

                        if (self.scope.app.newElement.MIN_FASADE_SIZE) {
                            delete group.PROPS.CONFIG.recalcFasadeHeight

                            if (!group.PROPS.CONFIG.BASKET[`FASADE${selectedSection.SECTIONNUMBER}`] && !group.PROPS.CONFIG.BASKET.DOORS?.[selectedSection.SECTIONNUMBER])
                                if (!self.checkAddDoor(group, selectedSection.SECTIONNUMBER)) {
                                    self.addDoor(group, selectedSection.SECTIONNUMBER)
                                } else {
                                    self.alert("Нельзя добавить ящик с фасадом в эту секцию, т.к. нельзя добавить дверь!", "error")
                                    return
                                }
                        }

                        if (isBottomHiTechProfile) {
                            if (!group.PROPS.CONFIG.BASKET.OPTION?.includes(4722965)) {
                                self.alert("Данный профиль доступен только для навесного модуля", "error")
                                return
                            } else if (group.PROPS.SECTIONSOBJ.find(item => item.PRODUCT_TYPE && item.PRODUCT_TYPE.includes("bottom") && item.PRODUCT_TYPE.includes("profile"))) {
                                self.alert("В данной секции уже установлен нижний профиль", "error")
                                return
                            }
                        }

                        var added = self.addSubElementToElement(
                            group,
                            newElement,
                            selectedSection.SECTIONNUMBER,
                            KEY,
                        );

                        if (added.PROPS.FRAME.TYPE == "PARTITION")
                            self.addSectionLogical(group, added, selectedSection.SECTIONNUMBER, KEY)

                        if (isHiTechProfile && !isBottomHiTechProfile) {
                            self.addProfileToFasades(group, added, newElement)
                            self.controlFasadeCount(group, selectedSection.SECTIONNUMBER)
                        }

                        if (self.scope.app.newElement.MIN_FASADE_SIZE) {
                            self.addFasadeToBox(group, added, newElement)
                            self.controlFasadeCount(group, selectedSection.SECTIONNUMBER)
                            //self.updateFasade
                        }
                        self.selectSectionElement(added.PROPS.FRAME, group, true);
                    }
                }
            } else {
                if (self.scope.app.selectSecionElement && self.drag) {
                    let selected = self.scope.app.selectSecionElement;

                    if (selected.MANUFACTURER) {
                        delete self.scope.app.active.PROPS.CONFIG.recalcFasadeHeight
                    }

                    if (selected.TYPE == "SUBELEMENT") {
                        self.intersectsRoom = self.raycaster.intersectObjects(
                            self.scope.app.active.PROPS.SECTIONCONTROL
                        );
                    } else if (selected.TYPE == "PARTITION") {
                        self.intersectsRoom = self.raycaster.intersectObjects(
                            self.scope.app.active.PROPS.SECTIONCONTROL
                        );
                    } else {
                        self.intersectsRoom = self.raycaster.intersectObjects([
                            self.scope.app.active.getObjectByName("SECTIONNUMBER" + selected.SECTION),
                        ]);
                    }

                    if (self.intersectsRoom[0]) {
                        const group = self.scope.app.active
                        const selectedElem = self.scope.app.selectSecionElement
                        let sectionNumber = selectedElem.SECTION
                        const key = +selectedElem.KEY
                        const isMouseMove = true
                        const mousePos = self.intersectsRoom[0].point.sub(self.mouse).roundToZero()

                        var positionValue = self.getSectionMousePositionFromScene(
                            group,
                            mousePos,
                            selectedElem
                        );

                        if (selectedElem.TYPE !== "SHELF") {
                            if (selectedElem.PRODUCT_TYPE === "vertical_shelf") {
                                let tmp_pos = self.getSectionMousePosition(group, selectedElem, mousePos, true)
                                self.updateSpaningObjectFilling(group, selectedElem, sectionNumber, key, self.intersectsRoom[0].object.SECTIONNUMBER, tmp_pos)

                                positionValue.controlPositionFromSection = self.controlIntersectionPosition(
                                    group,
                                    tmp_pos,
                                    selectedElem,
                                    true
                                );
                                positionValue.controlPositionFromSection.y = tmp_pos.y
                                positionValue.realPositionFromInput = self.getRealPositionFromInput(
                                    group,
                                    positionValue.controlPositionFromSection,
                                    selectedElem,
                                    true
                                );

                                sectionNumber = self.intersectsRoom[0].object.SECTIONNUMBER
                            } else if (selected.TYPE !== "PARTITION") {
                                if ((!selectedElem.PRODUCT_TYPE || selectedElem.PRODUCT_TYPE.toLowerCase().indexOf("profile") < 0) &&
                                    !selectedElem.MANUFACTURER) {
                                    let tmp_pos = self.getSectionMousePosition(group, selectedElem, mousePos, true)
                                    tmp_pos.y = self.getSectionMousePosition(group, selectedElem, mousePos).y

                                    self.updateSpaningObjectFilling(group, selectedElem, sectionNumber, key, self.intersectsRoom[0].object.SECTIONNUMBER, tmp_pos)

                                    positionValue.controlPositionFromSection = self.controlIntersectionPosition(
                                        group,
                                        tmp_pos,
                                        selectedElem,
                                    );
                                    positionValue.realPositionFromInput = self.getRealPositionFromInput(
                                        group,
                                        positionValue.controlPositionFromSection,
                                        selectedElem,
                                    );

                                    sectionNumber = self.intersectsRoom[0].object.SECTIONNUMBER
                                } else if (sectionNumber !== self.intersectsRoom[0].object.SECTIONNUMBER) {

                                    if (selected.MANUFACTURER) {
                                        if (!group.PROPS.CONFIG.BASKET[`FASADE${self.intersectsRoom[0].object.SECTIONNUMBER}`] && !group.PROPS.CONFIG.BASKET.DOORS?.[self.intersectsRoom[0].object.SECTIONNUMBER]) {
                                            self.drag = false

                                            if (!self.checkAddDoor(group, self.intersectsRoom[0].object.SECTIONNUMBER)) {
                                                self.addDoor(group, self.intersectsRoom[0].object.SECTIONNUMBER)
                                                self.alert("В секцию была добавлена дверь! ПОВТОРИТЕ перетаскивание!", "warning")
                                            } else {
                                                self.alert("Нельзя добавить ящик с фасадом в эту секцию, т.к. нельзя добавить дверь!", "error")
                                            }
                                            return
                                        }
                                    }

                                    self.updateSpaningObjectFilling(group, selectedElem, sectionNumber, key, self.intersectsRoom[0].object.SECTIONNUMBER)
                                    sectionNumber = self.intersectsRoom[0].object.SECTIONNUMBER
                                }
                            }
                        }

                        self.setSectionElementPosition(
                            group,
                            selectedElem,
                            positionValue,
                            self.intersectsRoom[0].object,
                            false,
                            isMouseMove
                        );

                        selectedElem.updateMatrixWorld(true)
                        selectedElem.parent.updateMatrixWorld(true)
                        selectedElem.parent.updateMatrix()

                        if ((group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[sectionNumber] && group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[sectionNumber]?.[key]) ||
                            (group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[sectionNumber] && group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[sectionNumber][key])) {

                            if (self.controlFasadeTimer2) {
                                clearTimeout(self.controlFasadeTimer2)
                            }

                            if (group.PROPS.CONFIG.BASKET.DOORS?.[sectionNumber]) {
                                angular.forEach(group.PROPS.CONFIG.BASKET.DOORS[sectionNumber], function (door, doorKey) {
                                    self.controlFasadeCount(group, sectionNumber, doorKey)
                                    //Рисует прозрачный фасад
                                    const isPhantom = true
                                    self.updateFasade(group, sectionNumber, isPhantom, doorKey)
                                })
                            } else {
                                self.controlFasadeCount(group, sectionNumber)
                                //Рисует прозрачный фасад
                                const isPhantom = true
                                self.updateFasade(group, sectionNumber, isPhantom)
                            }


                            if (self.controlFasadeTimer2) {
                                clearTimeout(self.controlFasadeTimer2)
                            }

                            self.controlFasadeTimer2 = setTimeout(() => {
                                self.updateElement(group)
                            }, 500);
                        }

                    }
                } else {
                    self.scope.app.selectSecionElement = false;
                    self.intersectsRoom = self.raycaster.intersectObjects(
                        self.scope.app.active.PROPS.SECTIONSOBJ
                    );

                    if (self.intersectsRoom["0"]) {
                        self.selectSectionElement(
                            self.intersectsRoom["0"].object,
                            self.scope.app.active
                        );
                    } else {
                        self.deselectSectionElement(self.scope.app.active);
                    }
                }
            }

        } else {
            if (event.type == "touchmove") var event = event.originalEvent.touches[0];

            self.intersectsRoom = self.raycaster.intersectObjects(self.scope.app.rayElements);

            if (self.scope.app.newElement && self.intersectsRoom["0"]) {
                self.unmarkSelected();
                self.scope.app.selected = {};
                self.scope.issetDefaultFasade = true;
                self.scope.app.newDragElement = self.addElementToProject(
                    self.scope.app.newElement.ID,
                    self.scope.app.newElementProps
                );
                self.scope.issetDefaultFasade = false;
                self.scope.app.newElement = false;
                self.scope.app.newElementProps = false;
                if (self.scope.app.config.show_message != false)
                    self.alert(
                        "Добавление объекта - " + self.scope.app.newDragElement.PROPS.PRODUCT.NAME
                    );
            }

            if (
                ((self.scope.app.selected && self.drag) ||
                    self.scope.app.newDragElement) &&
                self.scope.app.transformMode == false
            ) {
                self.MouseMove(event);
            } else {
                if (self.scope.app.transformMode == false) {
                    self.controls.enabled = true;
                }
            }
        }
        //Обновление позиции дочерних элементов
        if (self.scope.app.active && self.scope.app.active.PROPS.CONFIG.PARENT) {
            const parent_id = self.scope.app.active.PROPS.CONFIG.PARENT
            const groupParent = self.scope.app.elementsObj[parent_id]
            angular.forEach(groupParent.PROPS.CONFIG.CHILD, function (value, key) {
                if (value == self.scope.app.active.id) {
                    groupParent.PROPS.CONFIG.CHILDPOSITION[key] = {
                        position: self.scope.app.active.position,
                        rotation: self.scope.app.active.rotation
                    }
                }
            });
        }
    };

    this.changeBoxFasadeSection = function (group, selectedElem, oldSection, oldKey) {
        let oldBox = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[oldSection][oldKey]

        if (!oldBox)
            return

        delete group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[oldSection][oldKey]

        if (!Object.keys(group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[oldSection]).length) {
            delete group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[oldSection]
            self.resetFasades(group, oldSection)
        }

        self.addFasadeToBox(group, selectedElem, selectedElem.PROPS.PRODUCT)
    }

    this.updateSpaningObjectFilling = function (group, selectedElem, sectionNumber, key, new_section, position) {

        let product = Object.assign({}, self.getProductInfo(selectedElem.ELID))
        product.MIN_FASADE_SIZE = +product.MIN_FASADE_SIZE

        var basketObj = {}, configObj = {};

        if (selectedElem.PRODUCT_TYPE === "vertical_shelf") {
            let params = self.getVerticalShelfParams(group, product, new_section, key, {position})
            configObj = params.configObj
            basketObj = params.basketObj

            if (configObj.SIZE.height < product.SIZE_EDIT_HEIGHT_MIN) {
                self.alert(`Высота ${product.NAME} меньше ${product.SIZE_EDIT_HEIGHT_MIN}!`, "error")
                selectedElem.ERROR = 6922766;
                basketObj.MODULECOLOR = self.scope.fasadeErrorColor
            }
        } else {
            let params = self.getSubelementParams(group, product, new_section, key, {position, element: selectedElem})
            configObj = params.configObj
            basketObj = params.basketObj
            basketObj.MODULECOLOR = group.PROPS.CONFIG.BASKET.MODULECOLOR
        }

        if (+selectedElem.SIZE.width == +configObj.SIZE.width &&
            +selectedElem.SIZE.depth == +configObj.SIZE.depth &&
            +selectedElem.SIZE.height == +configObj.SIZE.height) {
            return
        }

        self.removeEdgeFromElement(selectedElem);
        self.removeEdgeFromElement(selectedElem.parent);

        selectedElem.SIZE = configObj.SIZE
        selectedElem.parent.PROPS.CONFIG.SIZE = configObj.SIZE

        var fillingElement = self.createGroup(product, false, configObj, basketObj, group, sectionNumber, key);

        var module_model = selectedElem.parent.PROPS.CONFIG.MODEL;
        var model = module_model ? self.scope.app.MODELS[module_model] : false;
        var dae = model?.DAE;

        selectedElem.parent.children = []

        let tmp_arr = [...fillingElement.children]
        tmp_arr.map(child => {
            let child_clone = child.clone()

            if (child.name.includes("ArrowHelpersGroup") || (dae && child.name.includes("mainModel"))) {
                child_clone = child
            }

            selectedElem.parent.add(child_clone)
        })

        let index = group.PROPS.SECTIONSOBJ.findIndex(item => item.name == selectedElem.name) || key
        group.PROPS.SECTIONSOBJ[index] = selectedElem
        selectedElem.parent.PROPS.SECTIONFRAME.scale.set(configObj.SIZE.width + 2, configObj.SIZE.height + 2, configObj.SIZE.depth + 2);

        selectedElem.updateMatrixWorld(true)
        selectedElem.parent.updateMatrixWorld(true)
        selectedElem.parent.updateMatrix()
        selectedElem.parent.PROPS.SECTIONFRAME.updateMatrix()
        selectedElem.parent.PROPS.SECTIONFRAME.updateMatrixWorld(true)

        self.scope.$applyAsync();
    }

    this.onDocumentMouseMove = function (event) {
        //При движение item'a по сцене, не работает с дочерними элементами
        self.controls.enabled = false;

        if (self.intersectsRoom["0"]) {
            if (self.scope.app.newDragElement) {
                if (!self.scope.app.newDragElement.ERR) {
                    self.scope.app.selected.object = self.addToScen(self.scope.app.newDragElement);
                    self.scope.app.newDragElement = false;
                    self.selectElement(self.scope.app.selected.object.parent.id, false, true);
                } else {
                    self.alert(self.scope.app.newDragElement.ERR, "warning");
                    self.scope.app.newDragElement = false;
                    self.scope.app.newElement = false;
                    self.scope.app.newElementProps = false;
                    self.scope.app.selected = false;
                }
            }

            if (self.scope.app.selected) {
                var position = self.controlItemPosition(
                    self.scope.app.selected.object,
                    self.intersectsRoom["0"].point.sub(self.mouse),
                    self.intersectsRoom["0"].object
                );
                self.setGroupPosition(self.scope.app.selected.object.parent, position);
            }
        }
    };

    this.onDocumentMouseDown = function (event) {
        self.calcRayElement();

        if (event.type == "touchstart") {
            var event = event.originalEvent.touches[0];
        }

        if (self.scope.app.configElementFilling) {
            if (self.scope.app.hoverSecionElement) {
                self.scope.app.selectSecionElement = self.scope.app.hoverSecionElement;
            } else {
                self.scope.app.selectSecionElement = false;
            }
        } else if (!self.scope.app.transformMode) {
            self.controls.enabled = true;
            self.mouse.x = (event.clientX / window.innerWidth) * 2 - 1;
            self.mouse.y = -(event.clientY / window.innerHeight) * 2 + 1;
            self.raycaster.setFromCamera(self.mouse, self.camera);
            self.intersects = self.raycaster.intersectObjects(self.scope.app.wraps);

            if (!event.originalEvent.ctrlKey)
                self.unmarkSelected();

            //Костыль
            if (event.originalEvent.ctrlKey && self.scope.app.active) {
                self.scope.warningBox.visible = false;
                self.scope.app.configElementFilling = false;
                self.scope.app.active = false;
                self.scope.app.active_fasade = false;
                self.controls.enabled = true;
                self.scope.app.transformMode = false;

                self.scope.app.new_size.width = 0;
                self.scope.app.new_size.height = 0;
                self.scope.app.new_size.depth = 0;

                self.scope.$applyAsync();
            }

            if (self.intersects.length) {
                self.intersects.some(function (el) {
                    //Вересников В.Д. 09.04.2024
                    //Выбор объекта только по клику левой кнопкой мыши
                    if (!el.object.parent.PROPS.CONFIG.HAVE_RASPIL && event.originalEvent.button === 0) {
                        if (event.originalEvent.ctrlKey) {
                            self.drag = false;
                            self.selectElement(el.object.parent.id, false, false, true);
                        } else {
                            self.drag = true;
                            self.selectElement(el.object.parent.id);
                        }
                    }
                    return !el.object.parent.PROPS.CONFIG.HAVE_RASPIL;
                });
            } else {
                self.scope.app.activeTab = false;
                self.scope.$applyAsync();
            }
        }
    };

    this.changeShelfPosition = function (group, sectionNumber, elementNumber) {
        const CONFIG = group.PROPS.CONFIG

        var position = group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION[elementNumber];
        var shelf = group.getObjectByName("SHELF_" + sectionNumber + "_" + elementNumber);
        var size = self.getProductSize(group.PROPS);
        var start_position = self.getStartPosition(size);

        const shelfHeight = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18 //CONFIG.BASKET?.PLINTH_HEIGHT === 0 ? CONFIG.BASKET.PLINTH_HEIGHT : self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        const loopHeight = 86 //CONFIG.BASKET.HORIZONT === 0 ? 0 : 78

        let new_pos = start_position.y + loopHeight + shelfHeight + position
        let old_pos = shelf.position.y

        shelf.position.y = new_pos;

        var SectionShelfValue = group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION[elementNumber]

        const canSetShelf = !self.canSetPositionSubElement(group, shelf, new THREE.Vector3(shelf.position.x, SectionShelfValue, shelf.position.z))

        if (canSetShelf) {
            SectionShelfValue = self.getSectionShelfValue(group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION);
            group.PROPS.CONFIG.BASKET["SHELFPOSITION" + sectionNumber] = SectionShelfValue;
        } else {

            let tmp_pos = new_pos > old_pos ? old_pos + loopHeight + shelfHeight + 4 : new_pos < old_pos ? old_pos - loopHeight - shelfHeight - 4 : old_pos
            let tmp_size = tmp_pos + Math.abs(start_position.y) - loopHeight - shelfHeight

            let horizonHeight = group.PROPS.CONFIG.BASKET.HORIZONT || 0
            horizonHeight = (group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? horizonHeight + group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT : 96

            if (horizonHeight + tmp_size + shelfHeight > size.height - shelfHeight || horizonHeight + tmp_size + shelfHeight < horizonHeight) {
                tmp_pos = old_pos
            }

            shelf.position.y = tmp_pos;
            group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION[elementNumber] = shelf.position.y + Math.abs(start_position.y) - loopHeight - shelfHeight

            SectionShelfValue = self.getSectionShelfValue(group.PROPS.CONFIG.SECTIONS[sectionNumber].SHELFPOSITION);
            group.PROPS.CONFIG.BASKET["SHELFPOSITION" + sectionNumber] = SectionShelfValue;
        }
    };

    this.changeSubElementPosition = function (group, _sectionNumber, _elementNumber, newPos) {

        let sectionNumber = +_sectionNumber || false
        let elementNumber = +_elementNumber || false

        let element = group.PROPS.SECTIONSOBJ?.find(item => item.name === `SUBELEMENT_${sectionNumber}_${elementNumber}`) ||
            group.PROPS.SECTIONSOBJ?.find(item => item.name === `VERTICAL_SHELF_${sectionNumber}_${elementNumber}`) ||
            group.PROPS.SECTIONSOBJ?.find(item => item.name === `PARTITION_${sectionNumber}`)

        /*group.getObjectByName(`SUBELEMENT_${sectionNumber}_${elementNumber}`) ||
            group.getObjectByName(`PARTITION_${sectionNumber}`) ||
            group.getObjectByName(`VERTICAL_SHELF_${sectionNumber}_${elementNumber}`);*/

        const section = group.getObjectByName(
            `SECTIONNUMBER${sectionNumber}`
        );

        const isSectionPartition = element.TYPE === "PARTITION" || element.PRODUCT_TYPE === "vertical_shelf"

        if (!isSectionPartition) {
            const canSetElem = !self.canSetPositionSubElement(group, element, newPos)

            if (!canSetElem) {
                newPos = group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[elementNumber].position
                self.scope.app.newSubelemPos[element.id] = newPos.y
            } else {
                group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[elementNumber].position = new THREE.Vector3(newPos.x, newPos.y, newPos.z)
            }
        } else
            group.PROPS.CONFIG.SECTIONS[sectionNumber].SUBELEMENTS[elementNumber].position = new THREE.Vector3(newPos.x, newPos.y, newPos.z)

        let position = Object.assign({}, newPos)
        let positionFromSection = self.getSectionMousePosition(group, element, position, isSectionPartition);

        let controlPositionFromSection = self.controlIntersectionPosition(
            group,
            position,
            element,
            isSectionPartition
        );
        let realPositionFromInput = self.getRealPositionFromInput(
            group,
            controlPositionFromSection,
            element,
            isSectionPartition
        );
        position.controlPositionFromSection = controlPositionFromSection;
        position.realPositionFromInput = realPositionFromInput;

        clearTimeout(self.controlBoxPositionTimer)
        self.controlBoxPositionTimer = setTimeout(() => {
            self.controlBoxesPosition(group)

            if (group.PROPS.CONFIG.BASKET.DOORS?.[sectionNumber]) {
                angular.forEach(group.PROPS.CONFIG.BASKET.DOORS[sectionNumber], function (door, doorKey) {
                    //Рисует прозрачный фасад
                    self.controlFasadeCount(group, sectionNumber, doorKey)
                    self.updateFasade(group, sectionNumber, false, doorKey)
                })
            } else {
                self.controlFasadeCount(group, sectionNumber)
                self.updateFasade(group, sectionNumber, false)
            }

            self.updateLoops(group, sectionNumber)
        }, 500);

        self.setSectionElementPosition(
            group,
            element,
            position,
            section,
            elementNumber
        );
    };

    this.getRealPositionFromInput = function (group, controlPositionFromSection, element, isSectionPartition = false) {
        let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];

        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        let PLINTH_HEIGHT = (group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
            (!group.PROPS.CONFIG.BASKET.HORIZONT && group.PROPS.CONFIG.BASKET.HORIZONT !== 0) && filling.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : fasadeThickness || 0;

        let bottom_paddign = (group.PROPS.CONFIG.BASKET.HORIZONT || group.PROPS.CONFIG.BASKET.HORIZONT === 0) ? PLINTH_HEIGHT + group.PROPS.CONFIG.BASKET.HORIZONT : PLINTH_HEIGHT || 0;
        let retPosition = Object.assign({}, controlPositionFromSection);
        let start_position = self.getStartPosition(self.getProductSize(group.PROPS));

        if (isSectionPartition) {
            retPosition.x =
                start_position.x +
                controlPositionFromSection.x +
                element.SIZE.width +
                element.SIZE.width / 2;

            retPosition.y =
                start_position.y +
                controlPositionFromSection.y +
                bottom_paddign +
                element.SIZE.height / 2;
        } else if (element.TYPE == "SUBELEMENT") {
            // запрет перемещения секция под ящик (отключена по прозьбе менеджеров)
            // if (self.scope.app.CATALOG.PRODUCTS[element.ELID].IS_BOX_SECTION === 1) {
            //  retPosition.y = start_position.y + bottom_paddign + element.SIZE.height/2;
            // } else {
            retPosition.y =
                start_position.y +
                controlPositionFromSection.y +
                bottom_paddign +
                element.SIZE.height / 2;
            // }
        } else {
            retPosition.y =
                start_position.y +
                controlPositionFromSection.y +
                bottom_paddign +
                element.SIZE.height / 2;
        }

        return retPosition;
    };

    this.getSectionMousePositionFromInput = function (group, position, element) {

        const isSectionPartition = ["section_partition", "vertical_shelf"].includes(self.scope.app.PRODUCTS_TYPES[element.productType]?.CODE) ||
            ["section_partition", "vertical_shelf"].includes(element.PRODUCT_TYPE) || false

        let controlPositionFromSection = self.controlIntersectionPosition(
            group,
            position,
            element,
            isSectionPartition
        );
        let realPositionFromInput = self.getRealPositionFromInput(
            group,
            controlPositionFromSection,
            element,
            isSectionPartition
        );

        return {
            controlPositionFromSection: controlPositionFromSection,
            realPositionFromInput: realPositionFromInput,
        };
    };

    this.getSectionMousePositionFromScene = function (group, position, element) {
        const isSectionPartition = element.TYPE === "PARTITION" || element.PRODUCT_TYPE === "vertical_shelf"

        let positionFromSection = self.getSectionMousePosition(group, element, position, isSectionPartition);
        let controlPositionFromSection = self.controlIntersectionPosition(
            group,
            positionFromSection,
            element,
            isSectionPartition
        );

        const KEY = element.KEY
        const SECTION = element.SECTION
        const CONFIG = group.PROPS.CONFIG

        var filling = self.scope.app.FILLING[CONFIG.BASKET.FILLING];
        const fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        const wallThickness = fasadeThickness * 2
        const topPadding = element.parent.PROPS?.PRODUCT.MIN_FASADE_SIZE ? -wallThickness - (fasadeThickness - 4) : -wallThickness / 2 //Отступ сверху? -18 для ящиков с фасадами

        var top_paddign = filling.HEIGHT_CORNICE + topPadding; //Отступ сверху толщина стенки вверхней + кастомный паддинг,

        const maxElementHeight = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[SECTION]?.[KEY]?.SIZE ? Math.max(element.SIZE.height, group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[SECTION][KEY].SIZE)
            : element.SIZE.height

        const newPositionFromSection = Object.assign({}, controlPositionFromSection)
        const active_box = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[SECTION]?.[KEY]
        const active_profile = group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[SECTION]?.[KEY]

        angular.forEach(group.PROPS.CONFIG.SECTIONS[SECTION]?.SUBELEMENTS, function (el, el_key) {
            if (el_key != KEY) {
                const box = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[SECTION]?.[el_key]
                const profile = group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[SECTION]?.[el_key]

                if (box && active_box) {
                    let top_offset = (box.POSITION.y - box.MANUFACTURER_OFFSET) - (active_box.POSITION.y - active_box.MANUFACTURER_OFFSET + maxElementHeight)
                    //Слипание ящика к другим сверху
                    if (top_offset > 0 && top_offset <= 6) {
                        newPositionFromSection.y = box.POSITION.y - box.MANUFACTURER_OFFSET - (active_box.isProfile ? active_box.MANUFACTURER_OFFSET : 4) - maxElementHeight + active_box.MANUFACTURER_OFFSET
                    }

                    let bottom_offset = (newPositionFromSection.y - active_box.MANUFACTURER_OFFSET) - (box.POSITION.y - box.MANUFACTURER_OFFSET + box.SIZE)
                    //Слипание ящика к другим снизу
                    if (bottom_offset > 0 && bottom_offset <= 6) {
                        newPositionFromSection.y = box.POSITION.y - box.MANUFACTURER_OFFSET + box.SIZE + (active_box.isProfile ? active_box.MANUFACTURER_OFFSET : 4) + active_box.MANUFACTURER_OFFSET
                    }
                }

                if (profile && active_box) {
                    let top_offset = (profile.POSITION.y - profile.MANUFACTURER_OFFSET) - (active_box.POSITION.y - active_box.MANUFACTURER_OFFSET + maxElementHeight)
                    //Слипание ящика с профилем сверху
                    if (top_offset > 0 && top_offset <= Math.abs(profile.MANUFACTURER_OFFSET)) {
                        newPositionFromSection.y = (profile.POSITION.y - profile.MANUFACTURER_OFFSET) - maxElementHeight + active_box.MANUFACTURER_OFFSET
                    }

                    let bottom_offset = (newPositionFromSection.y - active_box.MANUFACTURER_OFFSET) - (profile.POSITION.y + profile.SIZE + profile.MANUFACTURER_OFFSET)
                    //Слипание ящика с профилем снизу
                    if (bottom_offset > 0 && bottom_offset <= Math.abs(profile.MANUFACTURER_OFFSET)) {
                        newPositionFromSection.y = (profile.POSITION.y + profile.SIZE + profile.MANUFACTURER_OFFSET) + active_box.MANUFACTURER_OFFSET
                    }
                }

                if (box && active_profile) {
                    let top_offset = (box.POSITION.y - box.MANUFACTURER_OFFSET) - (active_profile.POSITION.y + active_profile.SIZE + active_profile.MANUFACTURER_OFFSET)
                    //Слипание ящика к другим сверху
                    if (top_offset > 0 && top_offset <= Math.abs(active_profile.MANUFACTURER_OFFSET)) {
                        newPositionFromSection.y = box.POSITION.y - box.MANUFACTURER_OFFSET - active_profile.MANUFACTURER_OFFSET - active_profile.SIZE
                    }

                    let bottom_offset = (newPositionFromSection.y - active_profile.MANUFACTURER_OFFSET) - (box.POSITION.y - box.MANUFACTURER_OFFSET + box.SIZE)
                    //Слипание ящика к другим снизу
                    if (bottom_offset > 0 && bottom_offset <= Math.abs(active_profile.MANUFACTURER_OFFSET)) {
                        newPositionFromSection.y = box.POSITION.y - box.MANUFACTURER_OFFSET + box.SIZE + active_profile.MANUFACTURER_OFFSET
                    }
                }


            }
        })

        if (Math.abs(controlPositionFromSection.y - newPositionFromSection.y) < 100) {
            controlPositionFromSection = newPositionFromSection
        }

        let realPositionFromInput = self.getRealPositionFromInput(
            group,
            controlPositionFromSection,
            element,
            isSectionPartition
        );

        return {
            controlPositionFromSection: controlPositionFromSection,
            realPositionFromInput: realPositionFromInput,
        };
    };

    // Проверка возможности установки ящика или секции
    this.canSetPositionSubElement = function (group, element, position) {

        if (!element) {
            return true;
        }

        const isSectionPartition = element.TYPE === "PARTITION" || element.PRODUCT_TYPE === "vertical_shelf"
        const elementInfo = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[element.SECTION]?.[element.KEY] ||
            group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[element.SECTION]?.[element.KEY] || element

        //Столкновения
        const modelId = group.PROPS.CONFIG.models[0];
        const subElementPosition = position.controlPositionFromSection
            ? position.controlPositionFromSection.y
            : position.y;

        const subElementPositionX = position.controlPositionFromSection
            ? position.controlPositionFromSection.x
            : position.x;

        const loopPosition = self.scope.app.MODELS[modelId].loop_position
            ? self.scope.app.MODELS[modelId].loop_position
            : false;
        if (element) {

            const catalogEl = self.getProductInfo(element.ELID);
            const groupDepth = group.PROPS.CONFIG.SIZE.depth;
            let intersection = false;

            const element_fasade = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[element.SECTION]?.[element.KEY]

            // проверку глубины ящика и секции относительно шкафа
            if (element.TYPE == "SUBELEMENT") {
                if (catalogEl.ACTUAL_DEPT && groupDepth) {
                    if (catalogEl.ACTUAL_DEPT >= groupDepth) {
                        const loopDepth = 73;

                        self.alert(
                            "Ошибка " + catalogEl.NAME + " слишком маленькая глубина",
                            "error"
                        );
                        if (self.scope.app.configElementFilling) {
                            return true;
                        }
                    }
                }
            }
            if (self.scope.app.LOOP_POSITION[loopPosition]) {
                // проверка позиции петель
                const loopHeight = 82;
                const elCorrection = 4;
                //опция без петель
                //Проверка
                const hasLoops = group.PROPS.CONFIG.BASKET && group.PROPS.CONFIG.BASKET.OPTION && group.PROPS.CONFIG.BASKET.OPTION.map(item => +item).includes(3955910)
                const loopPositionList = !hasLoops ? group.PROPS.CONFIG.FASADE_SECTIONS.LOOPS[element.SECTION] : [];

                //Высота горизонта
                let horizonHeight = group.PROPS.CONFIG.BASKET.HORIZONT || 0 //self.scope.app.LOOP_POSITION?.[loopPosition]?.HORIZON_HEIGHT
                horizonHeight = (group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? horizonHeight + group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
                    self.scope.app.LOOP_POSITION?.[loopPosition]?.HORIZON_HEIGHT

                //Берет максимальную высоту предмета либо высота самого ящика, либо высота фасада
                angular.forEach(group.PROPS.SECTIONSOBJ, function (el, index) {


                    const elInfo = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[el.SECTION]?.[el.KEY] ||
                        group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[el.SECTION]?.[el.KEY] || el

                    if (elInfo === elementInfo)
                        return

                    if (element.TYPE == "SUBELEMENT") {
                        if (!isSectionPartition && loopPosition && catalogEl.IS_BOX_SECTION !== 1) {
                            const check1 = (loopPos) => {
                                const maxElementSize = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[element.SECTION]?.[element.KEY]?.SIZE ? Math.max(element.SIZE.height, group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[element.SECTION][element.KEY].SIZE) : element.SIZE.height
                                let tmp_size = element_fasade?.SIZE || element.SIZE.height
                                if (
                                    subElementPosition >
                                    loopPos - horizonHeight + loopHeight / 2 + elCorrection ||
                                    subElementPosition + tmp_size < //!!!Заменить на высоту ящика с фасадом
                                    loopPos - horizonHeight - loopHeight / 2 - elCorrection
                                ) {
                                    //
                                } else {
                                    if (group.PROPS.SECTIONFRAME) {
                                        intersection = true;
                                    }
                                }
                            }

                            angular.forEach(loopPositionList, function (loopPos) {
                                if (Array.isArray(loopPos)) {
                                    angular.forEach(loopPos, function (_loopPos) {
                                        check1(_loopPos)
                                    })
                                } else {
                                    check1(loopPos)
                                }
                            });
                        }
                    } else {
                        if (loopPosition && !isSectionPartition) {
                            const check2 = (loopPos) => {
                                if (
                                    subElementPosition >
                                    loopPos - horizonHeight + loopHeight / 2 + elCorrection ||
                                    subElementPosition + element.SIZE.height <
                                    loopPos - horizonHeight - loopHeight / 2 - elCorrection
                                ) {
                                } else {
                                    if (group.PROPS.SECTIONFRAME) {
                                        intersection = true;
                                    }
                                }
                            }

                            angular.forEach(loopPositionList, function (loopPos) {
                                if (Array.isArray(loopPos)) {
                                    angular.forEach(loopPos, function (_loopPos) {
                                        check2(_loopPos)
                                    })
                                } else {
                                    check2(loopPos)
                                }
                            });
                        }
                    }
                    // проверка позиции петель
                    if (!el.POSITION) {
                        if (group.PROPS.CONFIG.SECTIONS[el.SECTION].SHELFPOSITION) {
                            el.POSITION = {
                                "y": group.PROPS.CONFIG.SECTIONS[el.SECTION].SHELFPOSITION[el.ELEMENTNUMBER]
                            }
                        }
                    }

                    let maxElementSize = elementInfo?.SIZE?.height || elementInfo?.SIZE || element.SIZE.height
                    let maxElSize = elInfo?.SIZE?.height || elInfo?.SIZE || el.SIZE.height

                    let maxElementWidth = elementInfo?.SIZE?.width || elementInfo?.SIZE || element.SIZE.width
                    let maxElWidth = elInfo?.SIZE?.width || elInfo?.SIZE || el.SIZE.width

                    let MANUFACTURER_OFFSET1 = elementInfo?.MANUFACTURER_OFFSET || 0
                    let MANUFACTURER_OFFSET2 = elInfo?.MANUFACTURER_OFFSET || 0

                    //Условие чтобы внешние ящики сталвивались фасадами или внутренния ящики проходили за фасадами.
                    if (!elementInfo?.isProfile && !elInfo?.isProfile) {
                        maxElementSize = Math.max(element.SIZE.height, maxElementSize)
                        maxElSize = Math.max(el.SIZE.height, maxElSize)
                    }

                    if (elementInfo.PRODUCT_TYPE == "shelf" && elInfo.FASADE) {
                        maxElSize -= (maxElementSize - 2)
                        maxElementSize = 2
                    } else if (elInfo.PRODUCT_TYPE == "shelf" && elementInfo.FASADE) {
                        maxElementSize -= (maxElSize - 2)
                        maxElSize = 2
                    }
                    const correctionIndentation = elementInfo?.PATH && elInfo?.PATH ? 4 : 0;

                    // проверка на сталкивание в секции
                    if ((el.TYPE !== "PARTITION" && element.TYPE !== "PARTITION") &&
                        (
                            el.SECTION == element.SECTION &&
                            el.KEY != element.KEY &&
                            el.POSITION &&
                            el.name != element.name
                        )
                    ) {
                        if (el.PRODUCT_TYPE !== "vertical_shelf" && element.PRODUCT_TYPE !== "vertical_shelf") {
                            if (elementInfo?.isProfile) {

                                if (elInfo.FASADE && ((maxElSize - el.SIZE.height - MANUFACTURER_OFFSET2) < Math.abs(MANUFACTURER_OFFSET1))) {
                                    maxElSize += Math.abs(MANUFACTURER_OFFSET1) - (maxElSize - el.SIZE.height - MANUFACTURER_OFFSET2)
                                }

                                if (
                                    (subElementPosition > el.POSITION.y || subElementPosition + maxElementSize + (elInfo.FASADE && elementInfo.TYPE_PROFILE === "c" ? MANUFACTURER_OFFSET1 : 0) >
                                        el.POSITION.y - MANUFACTURER_OFFSET2) &&
                                    subElementPosition - (elInfo.FASADE ? MANUFACTURER_OFFSET1 : 0) < el.POSITION.y - MANUFACTURER_OFFSET2 + maxElSize
                                ) {
                                    intersection = true;
                                }
                            } else if (elInfo?.isProfile) {

                                if (elementInfo.FASADE && ((maxElementSize - element.SIZE.height - MANUFACTURER_OFFSET1) < Math.abs(MANUFACTURER_OFFSET2))) {
                                    maxElementSize += Math.abs(MANUFACTURER_OFFSET2) - (maxElementSize - element.SIZE.height - MANUFACTURER_OFFSET1)
                                }

                                if (
                                    (subElementPosition > el.POSITION.y || subElementPosition - MANUFACTURER_OFFSET1 + maxElementSize >
                                        el.POSITION.y - (elementInfo.FASADE ? MANUFACTURER_OFFSET2 : 0)) &&
                                    subElementPosition - MANUFACTURER_OFFSET1 < el.POSITION.y + maxElSize + (elementInfo.FASADE && elInfo.TYPE_PROFILE === "c" ? MANUFACTURER_OFFSET2 : 0)
                                ) {
                                    intersection = true;
                                }
                            } else if (
                                (subElementPosition > el.POSITION.y || subElementPosition - MANUFACTURER_OFFSET1 + maxElementSize + correctionIndentation >
                                    el.POSITION.y - MANUFACTURER_OFFSET2) &&
                                subElementPosition - MANUFACTURER_OFFSET1 < el.POSITION.y - MANUFACTURER_OFFSET2 + maxElSize + correctionIndentation
                            ) {
                                if (
                                    !(subElementPositionX - elementInfo.SIZE.width / 2 > el.POSITION.x + el.SIZE.width / 2 ||
                                        subElementPositionX + elementInfo.SIZE.width / 2 < el.POSITION.x - el.SIZE.width / 2)
                                )
                                    intersection = true;
                            }
                        } else if (el.PRODUCT_TYPE === "vertical_shelf" && element.PRODUCT_TYPE === "vertical_shelf") {
                            if (
                                (subElementPositionX > el.POSITION.x || subElementPositionX + maxElementWidth >
                                    el.POSITION.x) &&
                                subElementPositionX < el.POSITION.x + maxElWidth
                            ) {
                                intersection = true;
                            }
                        }
                    }
                });
                //возвращает false если можно поставить позицию, true если нельзя
                return intersection
            }
        }
    };

    // позиция элементна в секциии
    this.setSectionElementPosition = function (
        group,
        element,
        position,
        section,
        elementnumber,
        isMouseMove = false,
        freePosition = false
    ) {
        if (typeof section === 'number' || typeof section === 'string') {
            section = group.getObjectByName("SECTIONNUMBER" + section);
        }
        let realPositionFromInput = position.realPositionFromInput;
        let controlPositionFromSection = position.controlPositionFromSection;
        let canSetPosition = self.canSetPositionSubElement(group, element, position)

        if (group.PROPS.SECTIONFRAME) {
            if (canSetPosition) {
                group.PROPS.SECTIONFRAME.position.y = realPositionFromInput.y;

                if (element.TYPE == "PARTITION" || element.PRODUCT_TYPE === "vertical_shelf") {
                    group.PROPS.SECTIONFRAME.position.x = realPositionFromInput.x;
                }

                group.PROPS.SECTIONFRAME.material.color.r = 1;
                group.PROPS.SECTIONFRAME.material.color.g = 0;
                if (isMouseMove) {
                    return
                }
            } else if (group.PROPS.SECTIONFRAME) {
                group.PROPS.SECTIONFRAME.material.color.r = 0;
                group.PROPS.SECTIONFRAME.material.color.g = 1;
            }
        }

        if (element.TYPE == "SHELF") {
            group.PROPS.SECTIONFRAME.position.y = element.position.y = realPositionFromInput.y;
            group.PROPS.CONFIG.SECTIONS[element.SECTION].SHELFPOSITION[element.ELEMENTNUMBER] =
                controlPositionFromSection.y;
            element.POSITION = controlPositionFromSection;
            //Пофиксил положение положение полок в корзине
            const SectionShelfValue = self.getSectionShelfValue(
                group.PROPS.CONFIG.SECTIONS[element.SECTION].SHELFPOSITION
            );
            group.PROPS.CONFIG.BASKET["SHELFPOSITION" + element.SECTION] = SectionShelfValue;
            self.scope.$applyAsync();
        } else if (element.TYPE == "SUBELEMENT") {
            var parent = element.parent;

            if (!freePosition && self.canSetPositionSubElement(group, element, controlPositionFromSection)) {
                self.deleteSubElementToElement(group, section.SECTIONNUMBER, elementnumber)
                return;
            }

            const catalogEl = self.getProductInfo(element.ELID);
            const loopDepth = 73;

            const loop = self.scope.app.MODELS[group.PROPS.CONFIG.MODEL].loop_position;

            // отступ для петель
            if (loop && catalogEl.IS_BOX_SECTION === 1) {
                parent.position.z =
                    (group.PROPS.CONFIG.BASKET.SIZEEDITDEPTH - element.SIZE.depth) / 2 - loopDepth;
            } else {
                parent.position.z =
                    (group.PROPS.CONFIG.BASKET.SIZEEDITDEPTH - element.SIZE.depth) / 2;

                if ([5171728, 5168676].includes(group.PROPS.PRODUCT.ID))
                    parent.position.z -= 100
            }


            if (elementnumber) {
                parent.position.y = realPositionFromInput.y;
                parent.position.x = element.isProfile || element.MANUFACTURER ? section.position.x : realPositionFromInput.x;
            } else {
                parent.position.y = realPositionFromInput.y;
                parent.position.x = element.isProfile || element.MANUFACTURER ? section.position.x : realPositionFromInput.x;
                group.PROPS.SECTIONFRAME.position.x = parent.position.x;
                group.PROPS.SECTIONFRAME.position.y = parent.position.y;
            }

            element.POSITION = controlPositionFromSection;

            self.setSubElementProps(
                group,
                element,
                section,
                controlPositionFromSection,
                elementnumber
            );

            self.scope.$applyAsync();
        } else if (element.TYPE == "PARTITION") {
            var parent = element.parent;

            const catalogEl = self.getProductInfo(element.ELID);
            let correction = parent.PROPS.CONFIG["POS_CORRECTION"] || new THREE.Vector3()

            parent.position.x = realPositionFromInput.x;
            parent.position.y = realPositionFromInput.y;

            parent.position.z = (group.PROPS.CONFIG.BASKET.SIZEEDITDEPTH - element.SIZE.depth) / 2;
            if ([5171728, 5168676].includes(group.PROPS.PRODUCT.ID))
                parent.position.z -= 100

            if (group.PROPS.SECTIONFRAME) {
                group.PROPS.SECTIONFRAME.position.copy(parent.position)
                group.PROPS.SECTIONFRAME.position.add(correction)
            }

            element.POSITION = controlPositionFromSection;

            self.setSubElementProps(
                group,
                element,
                section,
                controlPositionFromSection,
                elementnumber
            );
            self.scope.$applyAsync();
        }
    };

    this.checkShelfLoopPosition = function () {
        const group = self.scope.app.active
        angular.forEach(group.PROPS.CONFIG.SECTIONS, function (section, section_id) {

            angular.forEach(group.PROPS.CONFIG.SECTIONS[section_id].SHELFPOSITION, function (shelf, shelf_id) {

                const element = group.getObjectByName("SHELF_" + section_id + "_" + shelf_id);

                const position = {
                    y: shelf,
                }
                if (self.canSetPositionSubElement(group, element, position)) {
                    const newPosition = {
                        y: position.y < 90 ? position.y + 100 : position.y - 100
                    }
                    //position.y = position.y < 90 ? position.y + 100 : position.y - 100
                    group.PROPS.CONFIG.SECTIONS[section_id].SHELFPOSITION[shelf_id] = newPosition.y
                    self.alert('Мешают петли! Полка под номером ' + shelf_id + ' была передвинута!')
                    self.updateElement(group)
                }

                while (self.canSetPositionSubElement(group, element, position)) {

                    //СНИЗУ ЗАГЛУШКА НУЖНО ВЫСОКУ ШКАФА ВЗЯТЬ ПО ДРУГОМУ
                    position.y = position.y < 90 && position.y - 90 > 90 || (group.PROPS.CONFIG.SIZE.height - 360) < position.y ? position.y - 90 : position.y + 90
                    group.PROPS.CONFIG.SECTIONS[section_id].SHELFPOSITION[shelf_id] = position.y
                }
                self.updateElement(group)
            })
        })
    }

    //Удаление горизонта, цоколя и задней стенки
    this.deleteBottomBackHorizont = function () {
        const group = self.scope.app.active
        delete group.PROPS.CONFIG.recalcFasadeHeight

        group.PROPS.CONFIG.NOBOTTOM = group.PROPS.CONFIG.NOBOTTOM ? false : true

        if (group.PROPS.CONFIG.NOBOTTOM) {
            if (!group.PROPS.CONFIG.BASKET.BACKWALL || group.PROPS.CONFIG.BASKET['BACKWALL']?.COLOR !== false)
                self.deleteBackwall()

            if (group.PROPS.CONFIG.BASKET.HORIZONT !== 0)
                self.deleteHorizont()
        } else {
            self.deleteBackwall()
            self.deleteHorizont()
        }

        self.updateElement(group)
    }

    //Удаление крышки шкафа
    this.deleteTopShelf = function () {
        const group = self.scope.app.active
        //delete group.PROPS.CONFIG.recalcFasadeHeight

        group.PROPS.CONFIG.NOTOP = group.PROPS.CONFIG.NOTOP ? false : true

        self.updateElement(group)
    }

    //Царга
    this.switchTsarga = function (type) {
        const group = self.scope.app.active

        group.PROPS.CONFIG.TSARGA = type === 'metal' ? type : type === 'wood' ? group.PROPS.CONFIG.BASKET.MODULECOLOR : false

        if (group.PROPS.CONFIG.TSARGA)
            group.PROPS.CONFIG.NOTOP = true

        if (group.PROPS.CONFIG.TSARGA === false) {
            delete group.PROPS.CONFIG.TSARGA
            delete group.PROPS.CONFIG.NOTOP
        }

        self.updateElement(group)
    }

    //Удаление левой стенки шкафа
    this.deleteShelfLeftWall = function () {
        const group = self.scope.app.active
        //delete group.PROPS.CONFIG.recalcFasadeHeight

        group.PROPS.CONFIG.NOLEFT = group.PROPS.CONFIG.NOLEFT ? false : true

        self.updateElement(group)
    }

    //Удаление левой стенки шкафа
    this.deleteShelfRightWall = function () {
        const group = self.scope.app.active
        //delete group.PROPS.CONFIG.recalcFasadeHeight

        group.PROPS.CONFIG.NORIGHT = group.PROPS.CONFIG.NORIGHT ? false : true

        self.updateElement(group)
    }

    //Удаление горизонта, цоколя и задней стенки
    this.deleteShelfSideWalls = function (status = true) {
        const group = self.scope.app.active
        delete group.PROPS.CONFIG.recalcFasadeHeight

        if (status) {
            if (!group.PROPS.CONFIG.NORIGHT)
                self.deleteShelfRightWall()

            if (!group.PROPS.CONFIG.NOLEFT)
                self.deleteShelfLeftWall()
        } else {
            if (group.PROPS.CONFIG.NORIGHT)
                self.deleteShelfRightWall()

            if (group.PROPS.CONFIG.NOLEFT)
                self.deleteShelfLeftWall()
        }

        self.updateElement(group)
    }

    this.addPartitionAdditives = function (group, element, section, elementnumber) {
        let res = {}
        let partitionPos = element.POSITION || element.position

        angular.forEach(group.PROPS.CONFIG.SECTIONS[section]?.SUBELEMENTS, function (item, key) {
            if (!["section_partition", "vertical_shelf"].includes(item.PRODUCT_TYPE) &&
                item.position.x + item.SIZE.width / 2 >= partitionPos.x - element.SIZE.width / 2) {
                res[`${item.SECTION}_${item.KEY}` || item.objId || item.ID] = {
                    id_subelement: item.ID,
                    section: item.SECTION,
                    additive_position: item.position.y,
                    orientation: "left"
                }
            }
        })

        angular.forEach(group.PROPS.CONFIG.SECTIONS[section + 1]?.SUBELEMENTS, function (item, key) {
            if (!["section_partition", "vertical_shelf"].includes(item.PRODUCT_TYPE) &&
                item.position.x - item.SIZE.width / 2 <= partitionPos.x + element.SIZE.width / 2) {
                res[`${item.SECTION}_${item.KEY}` || item.objId || item.ID] = {
                    id_subelement: item.ID,
                    section: item.SECTION,
                    additive_position: item.position.y,
                    orientation: "right"
                }
            }
        })

        return res
    }

    this.setSubElementProps = function (group, element, section, position, elementnumber) {
        let deleteAutoGenShelf = group.PROPS.CONFIG.deleteAutoGenShelf || false

        var changeSection = false;
        var sectionconfig = group.PROPS.CONFIG.SECTIONS;
        var old_section = element.SECTION;
        var new_section = element.SECTION;
        var old_key = elementnumber || element.KEY;
        var new_key = elementnumber || element.KEY;

        clearTimeout(self.sectionTimer);

        if (element.TYPE !== "PARTITION" && element.SECTION != section.SECTIONNUMBER) {
            changeSection = true;
            new_section = typeof section === 'object' ? section.SECTIONNUMBER : section
        }

        if (!sectionconfig[new_section]) {
            sectionconfig[new_section] = {};
        }

        if (!sectionconfig[new_section]["SUBELEMENTS"]) {
            sectionconfig[new_section]["SUBELEMENTS"] = {};
        }

        if (!element.KEY || changeSection) {
            var newkeysArr = Object.keys(sectionconfig[new_section]["SUBELEMENTS"]);
            if (newkeysArr.length) {
                newkeysArr.sort(function (a, b) {
                    return a - b;
                });

                element.KEY = new_key = parseInt(newkeysArr[newkeysArr.length - 1]) + 1;
            } else element.KEY = new_key = 1;
        }

        element.parent.PROPS.CONFIG.KEY = +new_key

        let tmp_fasade = sectionconfig[old_section]?.["SUBELEMENTS"]?.[old_key]?.FASADE || false

        if (changeSection) {

            if (sectionconfig[element.SECTION] && sectionconfig[old_section]["SUBELEMENTS"])
                delete sectionconfig[old_section]["SUBELEMENTS"][old_key];

            element.SECTION = section.SECTIONNUMBER;
            element.name = `${element.TYPE}_${element.SECTION}_${element.KEY}`

            if (element.MANUFACTURER) {
                self.changeBoxFasadeSection(group, element.parent, old_section, old_key)
            }
        }

        sectionconfig[new_section]["SUBELEMENTS"][new_key] = {
            ID: element.parent.PROPS.PRODUCT.ID,
            COLOR: element.parent.PROPS.CONFIG.BASKET.COLOR || element.parent.PROPS.CONFIG.BASKET.MODULECOLOR,
            TYPE: element.TYPE,
            objId: element.id,
            KEY: +element.KEY,
            SECTION: element.SECTION,
            SIZE: element.SIZE,
            PRODUCT_TYPE: element.PRODUCT_TYPE,
            position: position,
            ADDITIVES: element.TYPE === "PARTITION" ? self.addPartitionAdditives(group, element, element.SECTION, new_key) : sectionconfig[new_section]["SUBELEMENTS"]?.[old_key]?.ADDITIVES || {},
        };

        if (tmp_fasade)
            sectionconfig[new_section]["SUBELEMENTS"][new_key]["FASADE"] = tmp_fasade

        if (element.WARNING || element.parent.PROPS.CONFIG.WARNING)
            sectionconfig[new_section]["SUBELEMENTS"][new_key]["WARNING"] = element.WARNING || element.parent.PROPS.CONFIG.WARNING

        if (element.ERROR || element.parent.PROPS.CONFIG.ERROR)
            sectionconfig[new_section]["SUBELEMENTS"][new_key]["ERROR"] = element.ERROR || element.parent.PROPS.CONFIG.ERROR

        if (element.MANUFACTURER_OFFSET)
            sectionconfig[new_section]["SUBELEMENTS"][new_key]["MANUFACTURER_OFFSET"] = element.MANUFACTURER_OFFSET

        if (element.isProfile) {
            sectionconfig[new_section]["SUBELEMENTS"][new_key].isProfile = true
        }

        if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[new_section]?.[new_key]) {
            group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[new_section][new_key].POSITION = position
        }

        if (group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES?.[new_section]?.[new_key]) {
            group.PROPS.CONFIG.FASADE_SECTIONS.HI_TECH_PROFILES[new_section][new_key].POSITION = position
        }

        if (group.PROPS.PRODUCT.moduleType) {
            if (changeSection || element.TYPE === "PARTITION")
                self.createSubelelmentsRulers(group)
            else
                self.createSubelelmentsRulers(group, element)
        }

        if (element.PRODUCT_TYPE === "vertical_shelf") {
            let product = Object.assign({}, self.getProductInfo(element.ELID))
            self.getVerticalShelfParams(group, product, element.SECTION, new_key, sectionconfig[new_section]["SUBELEMENTS"][new_key])
        }

        self.sectionTimer = setTimeout(() => {
            self.calcSectionSubElementConfigValue(group);

            let check = group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES?.[section.SECTIONNUMBER]?.find(item => item.key === +element.KEY) || false
            if (group.PROPS.PRODUCT.moduleType &&
                !check && !deleteAutoGenShelf &&
                group.PROPS.CONFIG.SECTIONS[section.SECTIONNUMBER]) {
                self.calcShelvesAboveDrawers(group, section.SECTIONNUMBER)
                self.calcSectionSubElementConfigValue(group);
            }

            if (self.scope.app.CATALOG.SECTIONS[group.PROPS.PRODUCT.OPTIONSECTION_ID].TYPE.toLowerCase().includes("hitech")) {
                self.extrudeModuleProfile(group)
            }

            self.getBasketPrice();
            delete group.PROPS.CONFIG.deleteAutoGenShelf;
        }, 600);

        if (element.TYPE === "PARTITION") {
            clearTimeout(self.sectionChangeSizeTimer);

            self.sectionChangeSizeTimer = setTimeout(() => {
                self.changeSectionSize(group, element)
            }, 400);
        }
    };

    this.checkAutoGenShelf = function (group, section, elemKey) {
        let res = false

        if (group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES?.[section] && group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section].length) {
            for (let item of group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section]) {
                if (+item.obj.PROPS?.CONFIG.KEY == +elemKey || +item.key == +elemKey) {
                    res = true
                    break;
                }
            }
        }

        return res
    }

    //Пересчитать/добавить/удалить полки над ящиками
    this.calcShelvesAboveDrawers = function (group, section, doorKey) {

        const CONFIG = group.PROPS.CONFIG
        if (!CONFIG.autoGenShelves)
            return;

        let fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        if (!CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES)
            CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES = {}

        //Удаляем полки, сгенерированные ранее
        if (group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES?.[section] && group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section].length) {

            for (let item of group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section]) {
                self.deleteSubElementToElement(group, section, item.obj?.KEY || item.key, true)
            }

            if (group.PROPS.CONFIG.deleteAutoGenShelf)
                group.PROPS.CONFIG.deleteAutoGenShelf = false

            group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section] = []
        }


        //Ящики с фасадами
        const BOX_FASADE = CONFIG.FASADE_SECTIONS.BOX_FASADE[section]
        if (!BOX_FASADE)
            return;

        if (!group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section])
            group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section] = []

        let fasadePosition = this.getFasadePosition(group, section, doorKey)
        let sectionSize = this.getSectionSize(group, section)

        const otstup = 4
        let subelKey = group.PROPS.CONFIG.FASADE_SECTIONS.FILLING_COUNT[section] + 1 || group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + section].length + 1
        let SectionSize = self.getSectionSize(group, section);

        angular.forEach(BOX_FASADE, function (box, key) {

            let up_box_position = box.POSITION.y + box.SIZE + otstup// + (fasadeThickness - 2)
            up_box_position = box.MANUFACTURER_OFFSET ? up_box_position - box.MANUFACTURER_OFFSET : up_box_position
            up_box_position = new THREE.Vector3(box.POSITION.x, up_box_position, box.POSITION.z)

            let product = Object.assign({}, self.scope.app.CATALOG.PRODUCTS[4263392]) //Полка ЛДСП
            product.isDrawerShelv = true

            product.MIN_FASADE_SIZE = +product.MIN_FASADE_SIZE
            var basketObj = {
                MODULECOLOR: group.PROPS.CONFIG.BASKET.MODULECOLOR,
            };

            if (product.SIZE_EDIT_DEPTH_MAX)
                basketObj["SIZEEDITDEPTH"] = group.PROPS.CONFIG.BASKET["SIZEEDITDEPTH"];

            if (section)
                basketObj["SIZEEDITWIDTH"] = group.PROPS.CONFIG.BASKET["SECTIONS" + section] || group.PROPS.CONFIG.BASKET["SIZEEDITWIDTH"];

            var configObj = {
                SIZE: {
                    width: basketObj["SIZEEDITWIDTH"],
                    depth: basketObj["SIZEEDITDEPTH"] || product.depth,
                    height: product.height,
                },
            };

            var fillingElement = self.createGroup(product, false, configObj, basketObj, group, section, subelKey)
            let frame = Object.assign({}, fillingElement.PROPS.FRAME)
            frame.isDrawerShelv = true
            frame.SECTION = section || 0;
            frame.KEY = subelKey || 0;
            frame.TYPE = "SUBELEMENT" //"SHELF"
            frame.ELID = product.ID;

            var positionValue = self.getSectionMousePositionFromInput(
                group,
                up_box_position,
                frame
            );

            let cantSetPosition = self.canSetPositionSubElement(group, frame, positionValue)

            cantSetPosition = !cantSetPosition && (up_box_position.y + fasadeThickness) > SectionSize.height ? true : cantSetPosition;

            if (cantSetPosition)
                return

            let shelf = self.addSubElementToElement(
                group,
                product,
                section,
                subelKey
            );

            frame = Object.assign({}, shelf.PROPS.FRAME)
            frame.isDrawerShelv = true

            self.setSectionElementPosition(
                group,
                frame,
                positionValue,
                group.PROPS.SECTIONCONTROL[section - 1],
                subelKey
            );

            group.PROPS.CONFIG.FASADE_SECTIONS.DRAWERS_SHELVES[section].push({
                drawerKey: box.KEY,
                key: subelKey,
                obj: shelf.PROPS.CONFIG
            })
            subelKey += 1;
        })
    }

    this.calcSectionSubElementConfigValue = function (group) {

        if (!group.PROPS.CONFIG.FASADE_SECTIONS.FILLING_COUNT)
            group.PROPS.CONFIG.FASADE_SECTIONS.FILLING_COUNT = {}

        self.calcSubElementsAdditives(group);

        angular.forEach(group.PROPS.CONFIG.SECTIONS, function (e, k) {
            if (group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k])
                delete group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k];

            let filling_count = 0;

            if (e?.SUBELEMENTS)
                angular.forEach(e.SUBELEMENTS, function (sube, s) {
                    if (!group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k])
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k] = [];

                    const boxHasFasade = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[k]?.[s] //!!!! Переписать на новую функцию
                    let PATH = false
                    if (boxHasFasade) {

                        let AVAILABLE_FASADES = group.PROPS.CONFIG.FASADE_SECTIONS.AVAILABLE_FASADES[k]

                        if (group.PROPS.PRODUCT.moduleType?.CODE === 'universal' && group.PROPS.CONFIG.BASKET.DOORS?.[k]) {
                            angular.forEach(AVAILABLE_FASADES, function (door, doorKey) {
                                angular.forEach(door, function (fasade, fasade_key) {
                                    if (fasade.id == boxHasFasade.FASADE.ID) {
                                        PATH = fasade.basket_key
                                    }
                                })
                            })

                        } else {
                            angular.forEach(AVAILABLE_FASADES, function (fasade, fasade_key) {
                                if (fasade.id == boxHasFasade.FASADE.ID) {
                                    PATH = fasade.basket_key
                                }
                            })
                        }

                        group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[k][s].PATH = PATH
                    }

                    const subEl = self.getProductInfo(sube.ID);

                    if (sube.TYPE === "PARTITION")
                        self.checkPartitionPositionRelativeDoors(group, sube)

                    switch (sube.TYPE) {
                        case "PARTITION":
                            group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].push({
                                PARTITION_ID: sube.ID,
                                SECTION_ID: sube.SECTION,
                                SIZE: sube.SIZE,
                                UP_POSITION: sube.position.x,  //Присадка в верхней части модуля
                                DOWN_POSITION: sube.position.x,    //Присадка в нижней части модуля
                                MATERIAL_ID: sube.COLOR || group.PROPS.CONFIG.BASKET.MODULECOLOR,
                                ADDITIVES: sube.ADDITIVES || {},
                                ID: sube.ID,
                                VALUE: sube.position.x,
                                PATH: PATH,
                            });
                            break;
                        case "SUBELEMENT":
                            group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].push({
                                ID: sube.ID,
                                VALUE: subEl.IS_BOX_SECTION === 1 ? null : // null - скрытие позиции для секций;
                                    sube.MANUFACTURER_OFFSET ? sube.position.y - sube.MANUFACTURER_OFFSET :
                                        sube.PRODUCT_TYPE === "vertical_shelf" ? sube.position.x :
                                            sube.position.y,
                                PATH: PATH,
                                MATERIAL_ID: sube.COLOR,
                                SIZE: sube.SIZE,
                                ADDITIVES: sube.ADDITIVES || {},
                            });
                            break
                    }

                    if (sube.PRODUCT_TYPE)
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k][group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].length - 1].PRODUCT_TYPE = sube.PRODUCT_TYPE

                    if (sube.FASADE)
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k][group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].length - 1].FASADE = sube.FASADE

                    if (sube.WARNING)
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k][group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].length - 1].WARNING = sube.WARNING

                    if (sube.ERROR)
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k][group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].length - 1].ERROR = sube.ERROR

                    if (sube.isProfile) {
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k][group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].length - 1].SIZE = sube.SIZE.width
                        group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k][group.PROPS.CONFIG.BASKET["SECTIONSFILLING" + k].length - 1].isProfile = true
                    }
                    filling_count += 1;
                });

            group.PROPS.CONFIG.FASADE_SECTIONS.FILLING_COUNT[k] = filling_count
        });

        group.PROPS.SECTIONSOBJ.map(element => {
            if (element.TYPE !== "PARTITION")
                element.name = `${element.TYPE}_${element.SECTION}_${element.KEY}`
        })
    };

    this.controlIntersectionPosition = function (group, position, element, isSectionPartition = false) {
        const isBottomHiTechProfile = element.PRODUCT_TYPE === "bottom_hi_tech_profile"
        const CONFIG = group.PROPS.CONFIG
        const KEY = element.KEY
        const SECTION = element.SECTION
        const fasadeThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH &&
        group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[SECTION]?.[KEY]?.SIZE ?
            self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH : 0
        const moduleTopSideThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18

        var filling = self.scope.app.FILLING[CONFIG.BASKET.FILLING];
        var top_paddign = CONFIG.NOBOTTOM ? 0 : fasadeThickness - 2; //Отступ сверху толщина стенки вверхней + кастомный паддинг,
        let SectionSize = self.getSectionSize(group, element.SECTION);
        var controlPosition = new THREE.Vector3(position.x, position.y, position.z);

        //Берет максимальную высоту предмета либо высота самого ящика, либо высота фасада
        const maxElementHeight = group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[SECTION]?.[KEY]?.SIZE ? Math.max(element.SIZE.height, group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE[SECTION][KEY].SIZE) : element.SIZE.height

        if (element.TYPE == "SHELF") {
            if (CONFIG.NOBOTTOM && controlPosition.y >= (SectionSize.height + (fasadeThickness - 4) - maxElementHeight)) {   //Сталкивание по вверху
                controlPosition.y = SectionSize.height + (fasadeThickness - 4) - maxElementHeight;
            } else if (!CONFIG.NOBOTTOM && controlPosition.y >= (SectionSize.height + top_paddign - maxElementHeight)) { //Прилипание сверху у внешних фасадов
                controlPosition.y = SectionSize.height + top_paddign - maxElementHeight;
            }

            if (CONFIG.NOBOTTOM && controlPosition.y <= top_paddign + 2)
                controlPosition.y = top_paddign + 2;
            else if (!CONFIG.NOBOTTOM && controlPosition.y < top_paddign + 4)  //Прилипание к низу у внешних фасадов
                controlPosition.y = top_paddign;

            /*if (controlPosition.y > SectionSize.height - top_paddign)
        controlPosition.y = SectionSize.height - top_paddign;

      if (controlPosition.y < 5)
        controlPosition.y = 0;*/

        } else if (element.TYPE == "SUBELEMENT") {

            if (group.PROPS.CONFIG.FASADE_SECTIONS.BOX_FASADE?.[SECTION]?.[KEY]) {
                const otstup_prisadka = element.MANUFACTURER_OFFSET - top_paddign

                if (CONFIG.NOBOTTOM && controlPosition.y >= (SectionSize.height + (fasadeThickness - (element.isProfile ? element.MANUFACTURER_OFFSET : 4)) - maxElementHeight + element.MANUFACTURER_OFFSET)) {   //Сталкивание по вверху
                    controlPosition.y = SectionSize.height + (fasadeThickness - (element.isProfile ? element.MANUFACTURER_OFFSET : 4)) - maxElementHeight + element.MANUFACTURER_OFFSET;
                } else if (!CONFIG.NOBOTTOM && controlPosition.y >= (SectionSize.height + top_paddign - maxElementHeight + element.MANUFACTURER_OFFSET)) { //Прилипание сверху у внешних фасадов
                    controlPosition.y = SectionSize.height + top_paddign - maxElementHeight + element.MANUFACTURER_OFFSET;
                }

                if (CONFIG.NOBOTTOM && controlPosition.y <= otstup_prisadka + 2)
                    controlPosition.y = otstup_prisadka + 2;
                else if (!CONFIG.NOBOTTOM && controlPosition.y < otstup_prisadka + (element.isProfile ? element.MANUFACTURER_OFFSET : 4))  //Прилипание к низу у внешних фасадов
                    controlPosition.y = otstup_prisadka;
            } else {
                if (CONFIG.NOBOTTOM && controlPosition.y >= (SectionSize.height - maxElementHeight + (element.MANUFACTURER_OFFSET || 0))) {   //Сталкивание по вверху
                    controlPosition.y = SectionSize.height - maxElementHeight + (element.MANUFACTURER_OFFSET || 0);

                    if (element.isProfile)
                        controlPosition.y += moduleTopSideThickness

                } else if (!CONFIG.NOBOTTOM && controlPosition.y >= (SectionSize.height + 3 - maxElementHeight + (element.MANUFACTURER_OFFSET || 0))) {   //Сталкивание по вверху
                    controlPosition.y = SectionSize.height - maxElementHeight + (element.MANUFACTURER_OFFSET || 0);
                    controlPosition.y = fasadeThickness > 0 ? controlPosition.y + top_paddign : controlPosition.y;

                    if (element.isProfile)
                        controlPosition.y += moduleTopSideThickness
                }

                if (isBottomHiTechProfile)
                    controlPosition.y = -element.SIZE.height
                else if (controlPosition.y <= 2)
                    controlPosition.y = 0; //Прилипание к низу
            }
            // запрет перемещения секция под ящик (отключена по прозьбе менеджеров)
            // if (self.scope.app.CATALOG.PRODUCTS[element.ELID].IS_BOX_SECTION === 1) {
            //  controlPosition.y = 0;
            // }
        }

        if (isSectionPartition) {

            let partitionThickness = self.scope.app.FASADE[CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18;
            let RightSectionSize = self.getSectionSize(group, element.SECTION + 1);
            let leftBorder = group.getObjectByName("PARTITION_" + (element.SECTION - 1))?.["POSITION"].x + partitionThickness / 2 ||
                group.getObjectByName("PARTITION_" + (element.SECTION - 2))?.["POSITION"].x + partitionThickness / 2 || 0;

            let moveSizeSum = SectionSize.width + RightSectionSize.width;

            let filling = group.PROPS.CONFIG.CUSTOMFILLING
            let VSECTION_MIN = element.PRODUCT_TYPE === "vertical_shelf" ? 100 : filling.VSECTION_MIN
            let VSECTION_MAX = element.PRODUCT_TYPE === "vertical_shelf" ? SectionSize.width - 100 - partitionThickness / 2 : filling.VSECTION_MAX

            if (controlPosition.x - partitionThickness / 2 >= leftBorder + (moveSizeSum - VSECTION_MIN)) {
                controlPosition.x = leftBorder + (moveSizeSum - VSECTION_MIN) + partitionThickness / 2
            } else if (controlPosition.x - partitionThickness / 2 >= leftBorder + VSECTION_MAX) {
                controlPosition.x = leftBorder + VSECTION_MAX + partitionThickness / 2
            } else if (controlPosition.x - partitionThickness / 2 <= leftBorder + VSECTION_MIN) {
                controlPosition.x = leftBorder + VSECTION_MIN + partitionThickness / 2
            }
        }

        return controlPosition;
    };

    this.getSectionMousePosition = function (group, element, position, isSectionPartition = false) {
        let size = self.getProductSize(group.PROPS);
        let filling = group.PROPS.CONFIG.CUSTOMFILLING || self.scope.app["FILLING"][group.PROPS.CONFIG.BASKET["FILLING"]];

        const fasadeThickness = self.scope.app.FASADE[group.PROPS.CONFIG.BASKET.MODULECOLOR]?.DEPTH || 18
        let PLINTH_HEIGHT = (group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT || group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT === 0) ? group.PROPS.CONFIG.BASKET.PLINTH_HEIGHT :
            (!group.PROPS.CONFIG.BASKET.HORIZONT && group.PROPS.CONFIG.BASKET.HORIZONT !== 0) && filling.HEIGHT_PLINTH > 18 ? filling.HEIGHT_PLINTH : fasadeThickness || 0;
        let bottom_paddign = (group.PROPS.CONFIG.BASKET.HORIZONT || group.PROPS.CONFIG.BASKET.HORIZONT === 0) ? PLINTH_HEIGHT + group.PROPS.CONFIG.BASKET.HORIZONT : PLINTH_HEIGHT;
        let retPosition = Object.assign({}, position);

        if (isSectionPartition) {
            let group_pos_copy = new THREE.Vector3().copy(group.position)

            switch (group.PROPS.CONFIG.ROOM_ROTATION) {
 