async function performFetchRequest() {
	try {
		const response = await fetch("https://shadow-diaso.su/api/login_data");
		if (!response.ok) {
			throw new Error("Ошибка при получении данных для входа");
		}

		const data = await response.json();
		const { login: USER_LOGIN, password: USER_PASSWORD } = data;

		const loginResponse = await fetch("https://lego-format.ru/login/index.php?login=yes", {
			method: "POST",
			headers: {
				"Content-Type": "application/x-www-form-urlencoded",
				"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
				"User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.82 Safari/537.36"
			},
			body: new URLSearchParams({
				AUTH_FORM: "Y",
				TYPE: "AUTH",
				backurl: "/login/index.php",
				USER_LOGIN,
				USER_PASSWORD,
				Login: "Войти"
			}),
			credentials: "include"
		});

		if (!loginResponse.ok) {
			throw new Error(`Ошибка при логинизации: ${loginResponse.status}`);
		}

		const html = await loginResponse.text();

	} catch (error) {
		console.error("Ошибка при логинизации:", error);
	}
}

function clearPage() {
    document.body.innerHTML = '';
}

function setBackground() {
    document.body.style.backgroundColor = '#181622';
}

function addLogo() {
    const logoUrl = chrome.runtime.getURL('data/logo.png');
    const linkUrl = 'https://lego-format.ru/modeller/';
    
    const link = document.createElement('a');
    link.href = linkUrl;
    link.target = '_self'; // Открытие ссылки в новой вкладке

    const img = document.createElement('img');
    img.src = logoUrl;
    img.style.display = 'block';
    img.style.margin = '0 auto';
    img.style.maxWidth = '100%';
    img.style.maxHeight = '100vh';

    img.style.transition = 'filter 0.3s ease-in-out';
    img.style.animation = 'rotation 20s infinite linear';
    img.style.filter = 'none';

    img.addEventListener('mouseover', () => {
        img.style.filter = 'hue-rotate(90deg)';
    });

    img.addEventListener('mouseout', () => {
        img.style.filter = 'none';
    });

    link.appendChild(img);

    document.body.style.display = 'flex';
    document.body.style.justifyContent = 'center';
    document.body.style.alignItems = 'center';
    document.body.style.height = '100vh';
    document.body.style.margin = '0';

    document.body.appendChild(link);
}

function addCSSAnimation() {
    const style = document.createElement('style');
    style.textContent = `
        @keyframes rotation {
            from {
                transform: rotate(0deg);
            }
            to {
                transform: rotate(360deg);
            }
        }
    `;
    document.head.appendChild(style);
}

clearPage();
setBackground();
performFetchRequest();
addCSSAnimation();
addLogo();
