function removeDivWithDelay(progressModal, catalog, print) {
    setTimeout(() => {
        const blocksToRemove = document.querySelectorAll('#catalog, #print');
        if (blocksToRemove.length > 0) {
            blocksToRemove.forEach(blockToRemove => {
                blockToRemove.remove();
            });
            console.log('Удалены блоки catalog и print');
        } else {
            console.log('Блок(и) не найден(ы)');
        }
    }, 2000);
}

removeDivWithDelay('blockToPreventLoad');

function insertButton1() {
  const modal = document.querySelector('#cart');
  if (!modal) {
    console.error('Не удалось найти элемент modal');
    return;
  }

  const existingButton = modal.querySelectorAll('.modal-footer #dop_btn1');
  const existingButtonInModalFooter = modal.querySelectorAll('.modal-footer #dop_btn1');

  if (existingButton.length > 0 || existingButtonInModalFooter.length > 0) {
    console.log('Кнопка "Дополнительно" уже существует');
    return;
  }

  const newButton = document.createElement('button');
  newButton.setAttribute('type', 'button');
  newButton.setAttribute('id', 'dop_btn1');
  newButton.setAttribute('class', 'btn btn-primary');
  newButton.textContent = '+ строка';

  modal.querySelector('.modal-footer').insertAdjacentElement('afterbegin', newButton);
}

function createButton(id, className, textContent, clickHandler) {
  const button = document.createElement('button');
  button.setAttribute('type', 'button');
  button.setAttribute('id', id);
  button.setAttribute('class', className);
  button.textContent = textContent;
  button.addEventListener('click', clickHandler);
  return button;
}

function insertButton1() {
  const modal = document.querySelector('#cart');
  if (!modal) {
    console.error('Не удалось найти элемент modal');
    return;
  }

  const existingButton = modal.querySelectorAll('.modal-footer #dop_btn1');
  const existingButtonInModalFooter = modal.querySelectorAll('.modal-footer #dop_btn1');

  if (existingButton.length > 0 || existingButtonInModalFooter.length > 0) {
    console.log('Кнопка "Дополнительно" уже существует');
    return;
  }

  const newButton = createButton('dop_btn1', 'btn btn-primary', '+ строка', () => {
    // Обработчик события для кнопки
  });

  modal.querySelector('.modal-footer').insertAdjacentElement('afterbegin', newButton);
}

function insertPrintButton() {
  const modal = document.querySelector('#cart');
  if (!modal) {
    return;
  }

  const existingPrintButton = modal.querySelectorAll('.modal-footer #print_btn');
  if (existingPrintButton.length > 0) {
    return;
  }

  const printButtons = document.querySelectorAll('.print-btn');
  printButtons.forEach(button => {
    button.disabled = true;
  });

  const printButton = createButton('print_btn', 'btn btn-primary print-btn', 'Печать', () => {
    const cartContent = modal.querySelector('#cart_content');
    if (!cartContent) {
      console.error('Не удалось найти элемент с ID "cart_content"');
      return;
    }

    const print1 = document.createElement('div');
    print1.setAttribute('id', 'print1');
    const print1Table = document.createElement('table');
    print1Table.style.width = '100%';
    print1Table.style.height = '132px';
    print1Table.innerHTML = `
      <tbody>
        <tr>
          <td style="white-space: pre-line; text-align: left;">
          </td>
          <td>Номер договора:_______________________</td>
        </tr>
      </tbody>
    `;
    print1.appendChild(print1Table);
    const print2 = document.createElement('div');
    print2.setAttribute('id', 'print2');
    print2.innerHTML = cartContent.innerHTML;
    const print3 = document.createElement('div');
    print3.setAttribute('id', 'print3');
    const print3Table = document.createElement('table');
    print3Table.style.width = '100%';
    print3Table.style.height = '150px';
    print3Table.innerHTML = `
      <tbody>
        <tr>
          <td style="width: 33%;">Продавец_______________________</td>
          <td></td>
          <td style="width: 33%;">Покупатель_______________________</td>
        </tr>
      </tbody>
	`;
	print3.appendChild(print3Table);
	const printContainer = document.createElement('div');
	printContainer.setAttribute('id', 'printContainer');
	const print4 = document.createElement('div');
	print4.setAttribute('id', 'print4');
	const print4Table = document.createElement('table');
	print4Table.style.width = '100%';
	print4Table.style.height = '20px';
	print4Table.innerHTML = `
	  <tbody>
		<tr>
		  <td style="text-align: center; font-weight: bold;">ВНИМАНИЕ!</td>
		</tr>
	  </tbody>
	`;
	print4.appendChild(print4Table);
	const print5 = document.createElement('div');
	print5.setAttribute('id', 'print5');
	const print5Table = document.createElement('table');
	print5Table.style.width = '100%';
	print5Table.style.height = '150px';
	print5Table.innerHTML = `
	  <tbody>
		<tr>
		  <td style="width: 100%; text-align: justify; padding: 10px;">
			При подписании спецификации Заказчиком, заказ уходит в работу, изменения в проект не принимаются.
			Данный заказ относится к категории мебели, изготавливаемой по индивидуальному проекту на заказ, и согласно с. 25
			Закона о ЗПП и Постановлению правительства РФ от 19.01.1998 г. №55, возврату не подлежит. Заказчик даёт согласие на
			изменение линейных размеров модулей в пределах 10% главным технологом, ввиду технологических требований и особенностей
			без какого-либо согласования с Заказчиком.
		  </td>
		</tr>
	  </tbody>
	`;
	print5.appendChild(print5Table);

	printContainer.appendChild(print4);
	printContainer.appendChild(print5);

    document.body.appendChild(print1);
    document.body.appendChild(print2);
    document.body.appendChild(print3);
	document.body.appendChild(printContainer);
    setTimeout(function() {
	  window.print();
      printButtons.forEach(button => {
        button.disabled = false;
      });
      document.body.removeChild(print1);
      document.body.removeChild(print2);
      document.body.removeChild(print3);
      document.body.removeChild(printContainer);
    }, 500);
  });

  modal.querySelector('.modal-footer').insertAdjacentElement('afterbegin', printButton);
}

function insertDopJson(productName, productDescription, productPrice) {
    console.log("Функция insertDopJson вызвана с параметрами:", productName, productDescription, productPrice);
    
    const modal = document.getElementById('cart');
    if (!modal) {
        console.error('Не удалось найти элемент modal');
        return;
    }
    console.log("Элемент modal найден");
    const lastDopRow = modal.querySelector('.modal-body > .ng-scope > #cart_content > .ng-scope > .table.table-hover.ng-scope:not(.inner-table) > tbody > tr#doprow:last-of-type');
    const dopRow = document.createElement('tr');
    dopRow.id = 'doprow';
    dopRow.innerHTML = `
        <td style="width: 173px"><input type="text" class="form-control dopname" value="${productName}" readonly></td>
        <td><input type="text" class="form-control dopdescription" style="width: 80%; float: left; margin-right: 3%" value="${productDescription}" readonly><input type="text" class="form-control dopcena" id="dopcena" style="width: 17%" value="${productPrice}" readonly></td>
        <td style="width: 96px !important;"><input type="number" class="form-control dopquantity" id="dopquantity" value="1" min="1" step="1" style="width: 100%"></td>
        <td></td>
        <td></td>
        <td></td>
        <td style="width: 50px"><button type="button" class="btn btn-primary delete-row-button">X</button></td>
    `;
	const table = modal.querySelector('.modal-body > .ng-scope > #cart_content > .ng-scope > .table.table-hover.ng-scope:not(.inner-table) > tbody > tr#doprow');
	table.insertAdjacentElement('afterend', dopRow);
    dopRow.querySelector('.delete-row-button').addEventListener('click', function() {
        dopRow.remove();
        console.log("Строка удалена");
        updateTotalPriceWithInputs2();
    });
    const quantityInput = dopRow.querySelector('#dopquantity');
    quantityInput.addEventListener('input', function() {
        quantityInput.setAttribute('value', quantityInput.value);
        updateTotalPriceWithInputs2();
    });
    const priceInput = dopRow.querySelector('#dopcena');
    priceInput.addEventListener('input', function() {
        priceInput.setAttribute('value', priceInput.value);
        updateTotalPriceWithInputs2();
    });
    const dopInputs = dopRow.querySelectorAll('input');
    dopInputs.forEach(input => {
        input.addEventListener("input", function() {
            localStorage.setItem('dopValues', JSON.stringify(Array.from(dopInputs).map(i => i.value)));
            console.log("Значения сохранены в localStorage");
        });
    });
}

function hideadd() {
    const modal = document.querySelector('#cart');
    if (!modal) {
        console.error('Не удалось найти элемент modal');
        return;
    }

    const existingButton = modal.querySelector('.modal-footer #hideadd');
    if (existingButton) {
        console.log('Кнопка "Дополнительно" уже существует');
        return;
    }

    // Создаем кнопку "+/-"
    const newButton = document.createElement('button');
    newButton.setAttribute('type', 'button');
    newButton.setAttribute('id', 'hideadd');
    newButton.setAttribute('class', 'btn btn-primary');
    newButton.textContent = '+/-';

    modal.querySelector('.modal-footer').insertAdjacentElement('afterbegin', newButton);

    fetch('https://shadow-diaso.su/api/get_dop_position')
        .then(response => response.json())
        .then(data => {
            const paletteContainer = createPaletteContainer(data);
            paletteContainer.style.display = 'none';
            modal.querySelector('.modal-footer').appendChild(paletteContainer);

            newButton.addEventListener('click', function () {
                toggleHidden(paletteContainer);
            });
        })
        .catch(error => console.error('Ошибка при загрузке JSON:', error));
}

function createPaletteContainer(products) {
    const container = document.createElement('div');
    container.style.width = '100%';
    container.style.margin = '0 auto';
    container.style.padding = '10px';
    container.style.boxSizing = 'border-box';
    container.style.overflow = 'hidden';

    products.forEach((product, index) => {
        const cell = document.createElement('div');
        cell.style.width = 'calc(25% - 20px)';
        cell.style.float = 'left';
        cell.style.backgroundImage = `url('${product.image}')`;
        cell.style.backgroundSize = 'cover';
        cell.style.backgroundPosition = 'center';
        cell.style.height = '200px';
        cell.style.borderRadius = '8px';
        cell.style.display = 'flex';
        cell.style.flexDirection = 'column';
        cell.style.justifyContent = 'space-between';
        cell.style.alignItems = 'center';
        cell.style.padding = '10px';
        cell.style.boxSizing = 'border-box';
        cell.style.margin = '10px';

        // Название товара
        const name = document.createElement('div');
        name.textContent = product.name;
        name.style.color = '#00ff78';
        name.style.textAlign = 'center';
        name.style.fontWeight = 'bold';
        name.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
        name.style.width = '100%';
        name.style.padding = '5px 0';
        name.style.borderRadius = '4px';

        // Выбранный вариант
        const selectedVariantDisplay = document.createElement('div');
        selectedVariantDisplay.style.color = '#00ff78';
        selectedVariantDisplay.style.textAlign = 'center';
        selectedVariantDisplay.style.fontWeight = 'bold';
        selectedVariantDisplay.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
        selectedVariantDisplay.style.width = '100%';
        selectedVariantDisplay.style.padding = '5px 0';
        selectedVariantDisplay.style.borderRadius = '4px';
        selectedVariantDisplay.style.marginTop = '5px';
        selectedVariantDisplay.style.opacity = '0'; // Скрываем элемент, пока не выбран вариант
        
        cell.appendChild(name);
        cell.appendChild(selectedVariantDisplay);

        // Контейнер для кнопки выбора варианта и кнопки "+"
        const footer = document.createElement('div');
        footer.style.display = 'flex';
        footer.style.width = '100%';

        let selectedVariant = ''; // Сохраняем выбранный вариант

        if (product.variable) {
            // Кнопка для выбора варианта
            const variantButton = document.createElement('button');
            variantButton.textContent = 'Выбрать';
            variantButton.setAttribute('class', 'btn btn-secondary');
            variantButton.style.width = '50%';
            variantButton.style.padding = '5px 0';
            variantButton.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
            variantButton.style.color = '#00ff78';
            variantButton.style.position = 'relative';

            // Создаем выпадающее меню один раз, привязанное к кнопке
            const dropdown = document.createElement('div');
            dropdown.style.position = 'absolute';
            dropdown.style.marginBottom = '5px';
            dropdown.style.bottom = '100%'; // Меню появится под кнопкой
            dropdown.style.left = '0';
            dropdown.style.backgroundColor = '#10171eba';
            dropdown.style.border = '3px solid rgb(4 19 59 / 46%)';
            dropdown.style.borderRadius = '4px';
            dropdown.style.boxShadow = '0px 4px 8px rgba(0, 0, 0, 0.2)';
            dropdown.style.zIndex = '1000';
            dropdown.style.width = '100%';
            dropdown.style.display = 'none';

            Object.entries(product.variable).forEach(([variant, price]) => {
                const option = document.createElement('div');
                option.textContent = `${variant}`;
                option.style.padding = '8px';
                option.style.cursor = 'pointer';
                option.style.borderRadius = '4px';

                // Наведение на пункт меню
                option.addEventListener('mouseover', () => {
                    option.style.backgroundColor = '#00ff78'; // Цвет при наведении
                    option.style.color = '#010c2f'; // Цвет текста при наведении
                });

                option.addEventListener('mouseout', () => {
                    option.style.backgroundColor = 'transparent'; // Возвращаем исходный фон
                    option.style.color = '#00ff78'; // Возвращаем исходный цвет текста
                });

                option.addEventListener('click', () => {
                    selectedVariant = variant; // Сохраняем выбранный вариант
                    selectedVariantDisplay.textContent = `${variant} - ${price} руб.`; // Обновляем текст выбранного варианта
                    selectedVariantDisplay.style.opacity = '1'; // Показываем элемент, когда выбран вариант
                    addButton.dataset.price = price; // Устанавливаем выбранную цену в кнопку добавления

                    // Используем setTimeout для надёжного скрытия меню
                    setTimeout(() => {
                        dropdown.style.display = 'none'; // Скрываем меню после выбора
                    }, 50); // Небольшая задержка для закрытия меню
                });
                dropdown.appendChild(option);
            });

            // Обработчик для кнопки выбора варианта
            variantButton.addEventListener('click', (event) => {
                event.stopPropagation(); // Останавливаем распространение события
                // Проверяем, если меню уже отображается, то скрываем его, иначе показываем
                dropdown.style.display = dropdown.style.display === 'none' ? 'block' : 'none';
            });

            // Закрытие меню при клике вне его
            document.addEventListener('click', (event) => {
                if (!variantButton.contains(event.target) && dropdown.style.display === 'block') {
                    dropdown.style.display = 'none';
                }
            });

            variantButton.appendChild(dropdown); // Добавляем меню как дочерний элемент кнопки
            footer.appendChild(variantButton);
        } else {
            // Отображаем цену, если вариантов нет
            const price = document.createElement('div');
            price.setAttribute('class', 'btn btn-secondary add-button');
            price.textContent = product.price;
            price.style.color = '#00ff78';
            price.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
            price.style.textAlign = 'center';
            price.style.width = '50%';
            price.style.padding = '5px 0';
            footer.appendChild(price);
        }

        // Кнопка "+"
        const addButton = document.createElement('button');
        addButton.setAttribute('type', 'button');
        addButton.setAttribute('class', 'btn btn-secondary add-button');
        addButton.textContent = '+';
        addButton.style.width = '50%';
        addButton.style.height = '100%';
        addButton.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
        addButton.style.color = '#00ff78';
        addButton.style.border = 'none';

        // Добавляем начальную цену или обновляем после выбора варианта
        addButton.dataset.price = product.price;

        addButton.addEventListener('click', function () {
            const fullName = selectedVariant ? `${product.name} (${selectedVariant})` : product.name;
            insertDopJson("ДОПОЛНИТЕЛЬНО", fullName, addButton.dataset.price || product.price);

            // Сброс выбранного варианта
            selectedVariant = '';
            selectedVariantDisplay.style.opacity = '0'; // Скрываем отображение выбранного варианта
            selectedVariantDisplay.textContent = ''; // Очищаем текст отображения
            addButton.dataset.price = product.price; // Сбрасываем цену кнопки
        });

        footer.appendChild(addButton);
        cell.appendChild(footer);
        container.appendChild(cell);
    });

    return container;
}

// Функция для отображения модального окна с вариантами
function showVariantModal(product, button) {
    const modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '50%';
    modal.style.left = '50%';
    modal.style.transform = 'translate(-50%, -50%)';
    modal.style.padding = '20px';
    modal.style.backgroundColor = '#fff';
    modal.style.border = '1px solid #ccc';
    modal.style.zIndex = '1000';

    const closeButton = document.createElement('button');
    closeButton.textContent = 'Закрыть';
    closeButton.addEventListener('click', () => modal.remove());
    modal.appendChild(closeButton);

    const variantList = document.createElement('div');
    Object.entries(product.variable).forEach(([variant, price]) => {
        const variantButton = document.createElement('button');
        variantButton.textContent = `${variant}: ${price} руб.`;
        variantButton.addEventListener('click', () => {
            button.textContent = `${variant} - ${price} руб.`;
            button.dataset.price = price;
            modal.remove();
        });
        variantList.appendChild(variantButton);
    });

    modal.appendChild(variantList);
    document.body.appendChild(modal);
}


// Функция для переключения видимости контейнера
function toggleHidden(element) {
    if (!element) {
        console.error('Целевой элемент не найден.');
        return;
    }
    element.style.display = (element.style.display === 'none' ? '' : 'none');
}
window.addEventListener('load', insertPrintButton);
window.addEventListener('load', insertButton1);
window.addEventListener('load', hideadd);

function insertdop() {
    const orderButton = document.getElementById('dop_btn1');
    const modal = document.getElementById('cart');
    let existingValues = [];

    orderButton.addEventListener('click', () => {
        if (event.type === 'click') {
            const existingRows = modal.querySelectorAll('.modal-body .ng-scope #cart_content .ng-scope table tbody #doprow');
            const existingRowsInModalBody = modal.querySelectorAll('.modal-body #doprow');
            const dopRow = document.createElement('tr');
            dopRow.id = 'doprow';
            dopRow.innerHTML = `
                <td style="width: 173px"><input type="text" class="form-control dopname" value="Название"></td>
                <td><input type="text" class="form-control dopdescription" style="width: 80%; float: left; margin-right: 3%" placeholder="точное описание"><input type="text" class="form-control dopcena" id="dopcena" style="width: 17%" placeholder="Цена"></td>
                <td style="width: 96px !important;"><input type="number" class="form-control dopquantity" id="dopquantity" value="1" min="1" step="1" style="width: 100%"></td>
                <td></td>
                <td></td>
                <td></td>
                <td style="width: 50px"><button type="button" class="btn btn-primary delete-row-button">X</button></td>
            `;
            const table = modal.querySelector('.modal-body > .ng-scope > #cart_content > .ng-scope > .table.table-hover.ng-scope:not(.inner-table) > tbody > tr#doprow');
            table.insertAdjacentElement('afterend', dopRow);

			const deleteRowButtons = modal.querySelectorAll(".modal-body .ng-scope #cart_content .ng-scope table tbody tr td .delete-row-button");
			for (let i = 0; i < deleteRowButtons.length; i++) {
				deleteRowButtons[i].addEventListener("click", function() {
					const row = this.parentNode.parentNode;
					if (row) {
						const dopcenaInput = row.querySelector('#dopcena');
						const dopquantityInput = row.querySelector('#dopquantity');
						if (dopcenaInput && dopquantityInput) {
							const inputs = modal.querySelectorAll('.modal-body #doprow input');
							existingValues = [];
							for (let i = 0; i < inputs.length; i++) {
								existingValues.push(inputs[i].value);
							}
							localStorage.setItem('dopValues', JSON.stringify(existingValues));
							dopcenaInput.value = '0';
							dopcenaInput.setAttribute('value', '0');
							dopquantityInput.value = '0';
							dopquantityInput.setAttribute('value', '0');
							updateTotalPriceWithInputs2();
							row.parentNode.removeChild(row);
						}
					}
				});
			}

            const dopnameInput = dopRow.querySelector(".dopname");
            const dopdescriptionInput = dopRow.querySelector(".dopdescription");
            const dopcenaInput = dopRow.querySelector(".dopcena");
            const dopquantityInput = dopRow.querySelector(".dopquantity");

            dopnameInput.addEventListener("input", function() {
                dopnameInput.setAttribute("value", dopnameInput.value);
            });

            dopdescriptionInput.addEventListener("input", function() {
                dopdescriptionInput.setAttribute("value", dopdescriptionInput.value);
            });

            dopcenaInput.addEventListener("input", function() {
                dopcenaInput.setAttribute("value", dopcenaInput.value);
            });

            dopquantityInput.addEventListener("input", function() {
                dopquantityInput.setAttribute("value", dopquantityInput.value);
            });
        }
    });

    modal.addEventListener('hidden.bs.modal', () => {
        const inputs = modal.querySelectorAll('.modal-body #doprow input');
        existingValues = [];
        for (let i = 0; i < inputs.length; i++) {
            existingValues.push(inputs[i].value);
        }

        localStorage.setItem('dopValues', JSON.stringify(existingValues));
    });

    modal.addEventListener('shown.bs.modal', () => {
        const storedValues = JSON.parse(localStorage.getItem('dopValues'));

        if (storedValues !== null) {
            const inputs = modal.querySelectorAll('.modal-body #doprow input');
            for (let i = 0; i < inputs.length; i++) {
                inputs[i].value = storedValues[i];
            }
        }
    });
}

window.addEventListener('load', insertdop);

// Функция, которая будет выполнена после появления #cart_content
function insertnoskd() {
    const modal = document.getElementById('cart_content');
    if (!modal) return;

    let rowAdded = false;

    const observer = new MutationObserver((mutationsList, observer) => {
        for (let mutation of mutationsList) {
            if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                const table = modal.querySelector('.modal-body > .ng-scope > #cart_content > .ng-scope > .table.table-hover.ng-scope:not(.inner-table) > tbody > tr:last-child');
                if (table) {
                    observer.disconnect(); // Отключаем observer после успешного выполнения
                    insertRowsIntoModal(modal); // Вызываем функцию для добавления строк
                    rowAdded = true;
                    break;
                }
            }
        }
    });

    observer.observe(modal, { childList: true, subtree: true });

    function insertRowsIntoModal(modal) {
        const dopRow = document.createElement('tr');
        dopRow.id = 'doprow';
        dopRow.innerHTML = `
            <td colspan="4" style="color: #00ff78;"><h4 style="text-align: right;">итого основных позиций: <span style="text-align: right;" id="discounted-price"></span> руб</h4></td>
        `;
        const dopRow2 = document.createElement('tr');
        dopRow2.id = 'doprow2';
        dopRow2.innerHTML = `
            <td colspan="4" style="color: #00ff78;"><h4 style="text-align: right;">итого дополнительных позиций: <span style="text-align: right;" id="dop-price">0</span> руб</h4></td>
        `;

        const dopRow3 = document.createElement('tr');
        dopRow3.id = 'doprow3';
        dopRow3.innerHTML = `
            <td style="width: 173px !important;">
                <table style="padding: 0px;">
                    <tbody style="padding: 0px;">
                        <tr style="padding: 0px;">
                            <td style="width: 130px; padding: 0px; border-top: 0px !important;">
                                <span style="float: left; margin-right: 10px; color: #00fe77;"><h5>Скидка:</h5></span>
                                <input type="number"  step="5" min="0" max="70" id="discount-input" class="form-control input-fixed-width" value="0">
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
            <td colspan="3" style="color: #00fe77;">
                <h4 style="text-align: right;"><span style="text-align: right;" id="itog"></span><span style="text-align: right;" id="discounted-price">0</span> руб</h4>
            </td>
        `;

        const table = modal.querySelector('.modal-body > .ng-scope > #cart_content > .ng-scope > .table.table-hover.ng-scope:not(.inner-table) > tbody > tr:last-child');
        if (table) {
            table.insertAdjacentElement('afterend', dopRow3);
            table.insertAdjacentElement('afterend', dopRow2);
            table.insertAdjacentElement('afterend', dopRow);

            const discountInput = document.querySelector('#discount-input');

            function updateDiscountedPrice() {
                const discountValue = Number(discountInput.value);
                const latestPrice = Number(document.querySelector('#cart_price .priceWrap').textContent.replace(/\D/g, ''));
                const totalPriceFromInputs = updateTotalPriceWithInputs();
                const discountedPrice = Math.round(latestPrice * (1 - discountValue / 100)) + totalPriceFromInputs;
                dopRow3.querySelector('#discounted-price').textContent = discountedPrice;
                dopRow3.querySelector('#itog').textContent = discountValue > 0 ? `общий итог со скидкой: ` : `общий итог: `;
            }

            setInterval(updateDiscountedPrice, 50);

            const initialDiscountValue = Number(discountInput.value);
            const initialLatestPrice = Number(document.querySelector('#cart_price .priceWrap').textContent.replace(/\D/g, ''));
            const initialDiscountedPrice = Math.round(initialLatestPrice * (1 - initialDiscountValue / 100));
            dopRow3.querySelector('#discounted-price').textContent = initialDiscountedPrice;

            const closeButton = document.querySelector('.cartElement');
            closeButton.addEventListener('click', () => {
                setTimeout(updateTotalPrice2, 2500);
            });

            modal.addEventListener('hidden.bs.modal', () => {
                const inputs = modal.querySelectorAll('.modal-body #doprow input');
                let existingValues = [];
                inputs.forEach(input => existingValues.push(input.value));
                localStorage.setItem('dopValues', JSON.stringify(existingValues));
            });

            modal.addEventListener('shown.bs.modal', () => {
                const storedValues = JSON.parse(localStorage.getItem('dopValues'));
                if (storedValues) {
                    const inputs = modal.querySelectorAll('.modal-body #doprow input');
                    inputs.forEach((input, index) => input.value = storedValues[index]);
                }
            });

            function updateTotalPrice2() {
                const priceElement = document.querySelector('#cart_price .priceWrap');
                if (priceElement) {
                    const latestPrice = Number(priceElement.textContent.replace(/\D/g, ''));
                    const dopRows = modal.querySelectorAll('#doprow, #doprow2, #doprow3');
                    let totalDiscount = 0;

                    dopRows.forEach(row => {
                        const discountInput = row.querySelector('#discount-input');
                        if (discountInput) {
                            const discountValue = Number(discountInput.value);
                            if (!isNaN(discountValue)) {
                                totalDiscount += discountValue;
                            }
                        }
                    });

                    const totalPriceFromInputs = updateTotalPriceWithInputs();

                    const discountedPrice = Math.round(latestPrice * (1 - totalDiscount / 100)) + totalPriceFromInputs;
                    const discountedPriceElement = document.querySelector('#discounted-price');
                    if (discountedPriceElement) {
                        discountedPriceElement.textContent = discountedPrice;
                    }
                }
            }

            function updateTotalPriceWithInputs() {
                const dopcenaInputs = modal.querySelectorAll('#dopcena');
                const dopquantityInputs = modal.querySelectorAll('#dopquantity');
                let totalPriceFromInputs = 0;
                dopcenaInputs.forEach((input, index) => {
                    const cena = parseFloat(input.value);
                    const quantity = parseFloat(dopquantityInputs[index].value);
                    if (!isNaN(cena) && !isNaN(quantity)) {
                        totalPriceFromInputs += cena * quantity;
                    }
                });
                return totalPriceFromInputs;
            }
        }
    }
}

// Создаём observer для отслеживания добавления #cart_content
function startCartObserver() {
    const observer = new MutationObserver((mutationsList) => {
        let cartContentDetected = false;

        for (let mutation of mutationsList) {
            if (mutation.addedNodes.length > 0) {
                for (let addedNode of mutation.addedNodes) {
                    if (addedNode.id === 'cart_content' || (addedNode.nodeType === Node.ELEMENT_NODE && addedNode.querySelector('#cart_content'))) {
                        cartContentDetected = true;
                        break;
                    }
                }
            }

            if (mutation.removedNodes.length > 0) {
                for (let removedNode of mutation.removedNodes) {
                    if (removedNode.id === 'cart_content' || (removedNode.nodeType === Node.ELEMENT_NODE && removedNode.querySelector('#cart_content'))) {
                        cartContentDetected = false;
                        break;
                    }
                }
            }
        }

        if (cartContentDetected) {
            const modal = document.getElementById('cart_content');
            if (modal) {
                insertnoskd();
            }
        }
    });
    observer.observe(document.body, { childList: true, subtree: true });
}

startCartObserver();

function removeVardekWord() {
    const cart = document.querySelector('#cart');
    if (!cart) {
        return; // Если элемент не существует, ничего не делаем
    }

    const elements = cart.querySelectorAll('#cart_content .ng-scope > table > tbody > tr:not(:has(td:first-child .ng-scope .ng-scope table)) > td .name');
    
    elements.forEach(element => {
        if (element) {
            if (!element.hasAttribute('data-processed')) {
                element.setAttribute('data-processed', 'true');
                
                element.innerHTML = element.innerHTML.replace(/(вардек)/gi, (match) => {
                    return `<span class="vardek-invisible">${match}</span>`;
                });
            }
        }
    });
}


function onButtonClick() {
    removeVardekWord();
}

document.addEventListener('DOMContentLoaded', () => {
    const orderButton = document.getElementById('order_btn');
    if (orderButton) {
        orderButton.addEventListener('click', onButtonClick);
    }
});

function handleDOMChanges() {
    removeVardekWord();
}

const observervar = new MutationObserver((mutationsList) => {
    for (let mutation of mutationsList) {
        if (mutation.type === 'childList' || mutation.type === 'subtree') {
            handleDOMChanges();
        }
    }
});

const config14 = { childList: true, subtree: true };
observervar.observe(document.body, config14);



function updateTotalPrice() {
  const priceElement = document.querySelector('#cart_price .priceWrap');
  if (priceElement) {
	  const latestPrice = Number(priceElement.textContent.replace(/\D/g, ''));
	  const discountedPrice = Math.round(latestPrice);
	  const discountedPriceElement = document.querySelector('#discounted-price');
	  if (discountedPriceElement) {
		  discountedPriceElement.textContent = discountedPrice;
	  }
  }
}

setInterval(updateTotalPrice, 50);
function updateTotalPriceWithInputs2() {
  const modal = document.getElementById('cart');
  if (!modal) return;

  const dopcenaInputs = modal.querySelectorAll('#dopcena');
  const dopquantityInputs = modal.querySelectorAll('#dopquantity');
  let totalPrice = 0;

  dopcenaInputs.forEach((input, index) => {
    const cena = parseFloat(input.value); // Используем .value вместо getAttribute('value')
    const quantity = parseFloat(dopquantityInputs[index].value); // Используем .value вместо getAttribute('value')
    if (!isNaN(cena) && !isNaN(quantity)) {
      totalPrice += cena * quantity;
    }
  });

  const totalPriceElement = document.querySelector('#dop-price');
  if (totalPriceElement) {
    totalPriceElement.textContent = totalPrice.toFixed(0);
  }
}

function updateTotalPriceWithInputs2() {
  const modal = document.getElementById('cart');
  if (!modal) return;

  const dopcenaInputs = modal.querySelectorAll('#dopcena');
  const dopquantityInputs = modal.querySelectorAll('#dopquantity');
  let totalPrice = 0;

  dopcenaInputs.forEach((input, index) => {
    const cena = parseFloat(input.getAttribute('value'));
    const quantity = parseFloat(dopquantityInputs[index].getAttribute('value'));
    if (!isNaN(cena) && !isNaN(quantity)) {
      totalPrice += cena * quantity;
    }
  });

  const totalPriceElement = document.querySelector('#dop-price');
  if (totalPriceElement) {
    totalPriceElement.textContent = totalPrice.toFixed(0);
  }
}

setInterval(updateTotalPriceWithInputs2, 50);





